/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

class PlayerItem
extends Item {
    private boolean m_bMoving;
    private int m_xStart;
    private int m_yStart;
    private int m_xFinish;
    private int m_yFinish;
    private int m_uiMovingTime;
    private long m_lMovingTick;
    private boolean m_bGotKey;
    private boolean m_bExplode;

    public PlayerItem(PuppyAdventureCanvas puppyAdventureCanvas, Image image) {
        this.m_pCanvas = puppyAdventureCanvas;
        this.setPosition(0, 0);
        this.setVelocity(0, 0);
        this.setImage(image);
        this.setFrame(0);
        this.setFrameTick(0L);
        this.setFrameDelay(16L);
        this.setVisible(false);
        this.setNumCellRows(5);
        this.setNumCellColumns(4);
        this.setCellRow(0);
        this.setCellColumn(0);
        this.setVisible(true);
        this.reset();
    }

    public void reset() {
        this.setCellRow(0);
        this.setCellColumn(0);
        this.m_bMoving = false;
        this.m_uiMovingTime = 80;
        this.m_lFrameTick = 0L;
        this.m_bGotKey = false;
        this.m_bExplode = false;
        this.setVisible(true);
    }

    public boolean isGotKey() {
        return this.m_bGotKey;
    }

    public void setGotKey(boolean bl) {
        this.m_bGotKey = bl;
    }

    public boolean isExplode() {
        return this.m_bExplode;
    }

    public boolean isExplosionCompleted() {
        return this.isExplode() && !this.isVisible();
    }

    public void explode() {
        this.m_lFrameTick = 0L;
        this.m_iCellRow = 4;
        this.m_iCellColumn = 0;
        this.m_bExplode = true;
    }

    public boolean isMoving() {
        return this.m_bMoving;
    }

    public void turnLeft() {
        this.m_iCellRow = 3;
    }

    public void turnRight() {
        this.m_iCellRow = 2;
    }

    public void turnUp() {
        this.m_iCellRow = 1;
    }

    public void turnDown() {
        this.m_iCellRow = 0;
    }

    public void moveLeft() {
        if (this.m_bMoving) {
            return;
        }
        this.turnLeft();
        this.m_xStart = this.getX();
        this.m_yStart = this.getY();
        this.m_xFinish = this.m_xStart - this.getWidth();
        this.m_yFinish = this.m_yStart;
        this.m_lFrameTick = 0L;
        this.m_bMoving = true;
    }

    public void moveRight() {
        if (this.m_bMoving) {
            return;
        }
        this.turnRight();
        this.m_xStart = this.getX();
        this.m_yStart = this.getY();
        this.m_xFinish = this.m_xStart + this.getWidth();
        this.m_yFinish = this.m_yStart;
        this.m_lFrameTick = 0L;
        this.m_bMoving = true;
    }

    public void moveUp() {
        if (this.m_bMoving) {
            return;
        }
        this.turnUp();
        this.m_xStart = this.getX();
        this.m_yStart = this.getY();
        this.m_xFinish = this.m_xStart;
        this.m_yFinish = this.m_yStart - this.getHeight();
        this.m_lFrameTick = 0L;
        this.m_bMoving = true;
    }

    public void moveDown() {
        if (this.m_bMoving) {
            return;
        }
        this.turnDown();
        this.m_xStart = this.getX();
        this.m_yStart = this.getY();
        this.m_xFinish = this.m_xStart;
        this.m_yFinish = this.m_yStart + this.getHeight();
        this.m_lFrameTick = 0L;
        this.m_bMoving = true;
    }

    public void update(long l) {
        super.update(l);
        if (this.m_bExplode) {
            this.m_lFrameTick += l;
            if (this.m_lFrameTick > this.m_lFrameDelay) {
                int n = this.m_iCellColumn + 1;
                if (n >= this.m_iNumCellColumns) {
                    this.setVisible(false);
                } else {
                    this.m_iCellColumn = n;
                    this.m_lFrameTick = 0L;
                }
            }
        } else if (this.m_bMoving) {
            this.m_lMovingTick += l;
            if (this.m_lMovingTick >= (long)this.m_uiMovingTime) {
                this.setX(this.m_xFinish);
                this.setY(this.m_yFinish);
                this.m_iCellColumn = 0;
                this.m_lMovingTick = 0L;
                this.m_bMoving = false;
                return;
            }
            int n = this.m_xFinish - this.m_xStart;
            int n2 = this.m_yFinish - this.m_yStart;
            long l2 = this.m_lMovingTick / (long)this.m_uiMovingTime;
            this.setX((int)((long)this.m_xStart + l2 * (long)n));
            this.setY((int)((long)this.m_yStart + l2 * (long)n2));
            this.m_lFrameTick += l;
            if (this.m_lFrameTick > this.m_lFrameDelay) {
                n = this.m_iCellColumn + 1;
                this.m_iCellColumn = n %= this.m_iNumCellColumns;
                this.m_lFrameTick = 0L;
            }
        }
    }
}

