/*
 * Decompiled with CFR 0.152.
 */
package org.eaves.piefight;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.eaves.piefight.SpriteEvent;
import org.eaves.piefight.SpriteListener;
import org.eaves.piefight.State;

public class Sprite {
    public static final int INTRO = 0;
    public static final int LIVE = 1;
    public static final int LEAVE = 2;
    public static final int IDLE = 3;
    public static final int START = 4;
    public static final int HIT = 5;
    public static final int INTRO_MISS = 6;
    public static final int IDLE_MISS = 7;
    public static final int STATES = 8;
    Image _strip;
    State[] _state;
    int _thrownAt;
    SpriteListener _listener;
    int _currentState;
    int _queueState;
    int _frameX;
    int _frameY;
    int _xpos;
    int _ypos;
    boolean _moved = false;
    boolean _painted = false;

    public Sprite(Image image) {
        this._strip = image;
        this._state = new State[8];
    }

    public void start() {
        this._state[4] = new State(0, 1);
        this._state[0] = new State(7, 5);
        this._state[1] = new State(11, 4);
        this._state[2] = new State(15, 4);
        this._state[3] = new State(0, 7);
        this._state[5] = new State(39, 11);
        this._state[6] = new State(27, 12);
        this._state[7] = new State(20, 7);
        this.setState(4);
    }

    public void throwAt() {
        this._thrownAt = 4;
    }

    public void setListener(SpriteListener spriteListener) {
        this._listener = spriteListener;
    }

    public void nextState() {
        if (this._currentState < 3) {
            this.setState(++this._currentState);
        } else {
            this.action(SpriteEvent.END_SPRITE);
        }
    }

    private void action(int n) {
        if (this._listener == null) {
            return;
        }
        this._listener.spriteAction(this, new SpriteEvent(n));
    }

    public void draw(Graphics graphics) {
        int n = this._ypos + this._frameY + 2;
        int n2 = this._thrownAt * 5;
        int n3 = this._xpos + this._frameX / 2 - n2 / 2;
        this.clear(graphics, this._xpos, this._ypos);
        graphics.clipRect(this._xpos, this._ypos, this._frameX, this._frameY + 5);
        int n4 = this.getFrame();
        graphics.drawImage(this._strip, this._xpos - this.frameXPos(n4), this._ypos, 20);
        if (this._state[this._currentState].atEnd()) {
            this.action(SpriteEvent.END_STATE);
        }
        if (this._thrownAt > 0) {
            graphics.fillRect(n3, n, n2, 3);
        }
        this._painted = true;
    }

    public void animate() {
        if (!this._painted) {
            return;
        }
        this._state[this._currentState].next();
        if (this._thrownAt > 0) {
            --this._thrownAt;
        }
        this._painted = false;
    }

    public void clear(Graphics graphics, int n, int n2) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n, n2, this._frameX, this._frameY + 4);
        graphics.setColor(0);
    }

    public void setX(int n) {
        this._xpos = n;
    }

    public void setY(int n) {
        this._ypos = n;
    }

    public void frameX(int n) {
        this._frameX = n;
    }

    public void frameY(int n) {
        this._frameY = n;
    }

    public int getState() {
        return this._currentState;
    }

    public void setState(int n) {
        this._currentState = n;
        this._painted = false;
        this._state[this._currentState].init();
    }

    public int getFrame() {
        return this._state[this._currentState].current();
    }

    private int frameXPos(int n) {
        return this._frameX * n;
    }

    private int frameYPos(int n) {
        return this._frameY;
    }
}

