/*
 * Decompiled with CFR 0.152.
 */
package org.eaves.piefight;

import java.io.IOException;
import java.util.Date;
import java.util.Random;
import java.util.TimerTask;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.eaves.piefight.PieCanvas;
import org.eaves.piefight.Sprite;
import org.eaves.piefight.SpriteEvent;
import org.eaves.piefight.SpriteListener;

public class Animator
extends TimerTask
implements SpriteListener {
    private static int FRAME_WIDTH = 30;
    private static int FRAME_HEIGHT = 25;
    private static int X = 3;
    private static int Y = 5;
    private static int IMAGES = 6;
    Sprite[] _window;
    PieCanvas _parent;
    Display _sound;
    int _width;
    int _height;
    Random _r = new Random(new Date().getTime());

    public Animator(PieCanvas pieCanvas, int n, int n2, Display display) {
        Image image;
        Image image2;
        this._parent = pieCanvas;
        this._sound = display;
        this._width = n;
        this._height = n2;
        try {
            image2 = Image.createImage((String)"/completeBlindStrip.png");
            image = Image.createImage((String)"/completeBlindStripKitty.png");
        }
        catch (IOException iOException) {
            System.out.println("no image file !");
            return;
        }
        this._window = new Sprite[IMAGES];
        int n3 = 0;
        while (n3 < IMAGES) {
            this._window[n3] = Math.abs(this._r.nextInt() % 100) < 10 ? new Sprite(image) : new Sprite(image2);
            this._window[n3].setX(X + n3 % 3 * 35);
            this._window[n3].setY(Y + n3 / 3 * 32);
            this._window[n3].frameX(FRAME_WIDTH);
            this._window[n3].frameY(FRAME_HEIGHT);
            this._window[n3].setListener(this);
            this._window[n3].start();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n3;
        }
    }

    public void guardState(Sprite sprite) {
        if (this.targetsActive() < this._parent.maxAlive() && this._parent.targetsLeft()) {
            sprite.setState(0);
            this._parent.targetShown();
        }
    }

    public void reset() {
        int n = 0;
        while (n < IMAGES) {
            this._window[n].setState(4);
            ++n;
        }
    }

    public void spriteAction(Sprite sprite, SpriteEvent spriteEvent) {
        if (spriteEvent.getEvent() == SpriteEvent.END_STATE) {
            int n = sprite.getState();
            switch (n) {
                case 4: {
                    int n2 = Math.abs(this._r.nextInt()) % 100;
                    if (n2 < 5) {
                        sprite.setState(3);
                    }
                    if (n2 <= 95) break;
                    this.guardState(sprite);
                    break;
                }
                case 3: {
                    int n3 = Math.abs(this._r.nextInt()) % 100;
                    if (n3 < 10) {
                        this.guardState(sprite);
                        break;
                    }
                    sprite.setState(4);
                    break;
                }
                case 5: {
                    sprite.setState(4);
                    break;
                }
                case 1: {
                    sprite.setState(2);
                    break;
                }
                case 6: 
                case 7: {
                    sprite.setState(3);
                    break;
                }
                default: {
                    sprite.nextState();
                }
            }
        }
    }

    public void keyPressed(int n) {
        if (!this._parent.ammoAvailable()) {
            return;
        }
        int n2 = n - 1;
        this._window[n2].throwAt();
        int n3 = this._window[n2].getState();
        if (n3 == 1) {
            this._parent.targetHit();
            this._window[n2].setState(5);
        } else {
            if (n3 == 0 || n3 == 2) {
                this._window[n2].setState(6);
            }
            if (n3 == 3 || n3 == 4) {
                this._window[n2].setState(7);
            }
        }
    }

    public void draw(Graphics graphics) {
        int n = 0;
        while (n < IMAGES) {
            graphics.setClip(0, 0, this._width, this._height);
            this._window[n].draw(graphics);
            ++n;
        }
    }

    public int getFrame() {
        return this._window[0].getFrame();
    }

    public int targetsActive() {
        int n = 0;
        int n2 = 0;
        while (n2 < IMAGES) {
            int n3 = this._window[n2].getState();
            if (n3 == 0 || n3 == 1) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void run() {
        if (this._parent.isRunning()) {
            int n = 0;
            while (n < IMAGES) {
                this._window[n].animate();
                ++n;
            }
        }
        this._parent.repaint();
        this._parent.serviceRepaints();
    }
}

