/*
 * Decompiled with CFR 0.152.
 */
package app;

import engine.TilesImage;
import engine.world.EnemyParameters;
import engine.world.Hero;
import engine.world.Level;
import engine.world.Region;
import engine.world.SimpleAnimation;
import engine.world.SplashScreen;
import engine.world.TiledLayer;
import engine.world.Weapon;
import framework.AppState;
import framework.MIDletTemplate;
import framework.MainGameCanvas;
import framework.sound.Music;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class GameAppState
extends AppState {
    public static int MIN_INTERVAL_TIME = 50;
    public static final int SCREEN_WIDTH = 176;
    public static final int SCREEN_HEIGHT = 168;
    public static int SCREEN_DELTA_Y = 0;
    public static int SCREEN_DELTA_X = 0;
    public static final int FULL_SCREEN_HEIGHT = 208;
    public static String[][][] StrStory = new String[][][]{{{"IN 19XX ... VIOLENCE RULED THE STREETS OF NEW YORK CITY AFTER THE NUCLEAR WAR. EVEN WITH THE CRIME SYNDICATES GROWING BIGGER EVERY YEAR, TWO YOUNG MEN WERE BRAVE ENOUGH TO CHALLENGE THEM. WHILE THEIR NAMES WERE BILLY AND JIMMY LEE..."}, {"THEY'RE ESCAPING IN THAT CHOPPER", "YOU'LL NEVER MAKE IT!", "MISSION 2 - AT THE HELIPORT."}, {"HOLD IT", "YOU'LL NEVER ESCAPE FROM US", "G R A S P"}, {"THE CHOPPER ESCAPED INTO THE NEON-FILLED NIGHT", "MISSION 3 - BATTLE IN THE CHOPPER"}, {"THE CHOPPER IS LANDING ON A MYSTERIOUS ISLAND.", "MISSION 4 - UNDERSEA BASE."}, {"WHERE DOES THIS PATH LEAD US?", "WE'VE GOT NO CHOICE BUT TO GO ON, THOUGH THIS IS THE WAY TO CERTAIN DEATH.", "MISSION 5 - FOREST OF DEATH."}, {"WHERE IN THE WORLD ARE WE?", "THERE IS EVIL IN THE AIR.", "MISSION 6 - MANSION OF TERROR."}, {"BILLY.... FROM HERE ON IT'S TOO DANGEROUS!"}, {"I THINK I HEARD MA... MARIAN'S VOICE. THAT'S IMPOSSIBLE, OR IS IT?", "MISSION 7 - TRAP ROOM."}, {"O.K. GOONS, WHERE'S YOUR SLIME BALL BOSS HIDING?!", "HA...HA...HA... YOU'LL NEVER DEFEAT OUR BOSS. YOU'LL ONLY DESTROY YOURSELVES.", "MISSION 8 - THE DOUBLE ILLUSION."}, {"IT'S IMPOSSIBLE... IT CAN'T BE HER!"}, {"MA... MARIAN?", "MISSION 9 - FINAL CONFRONTATION?"}, {"THIS IS THE END OF THE LINE, DOUBLE DRAGONS. YOU ARE NO MATCH FOR ME OR MY ILLUSIONS. LET'S GO!"}, {"I CAN'T BE BEATEN IN MY REVENGE FOR MARIAN. GET READY, SHADOW WARRIOR.", "GO BILLY LEE!"}, {"   "}, {"IT APPEARS OUR BATTLE IS FINALLY OVER, BUT I WILL LEAVE YOU WITH THE LEGEND OF THE SHADOW...", "IF THE ILLUSION SPREADS, THE EVIL WILL LIVE AGAIN. BUT IF TWO DRAGONS SOAR THROUGH THE SKY, AN ANGEL WILL FALL TO THE EARTH."}, {"SOON... I WILL DIE AND YOU WILL JOIN ME. FAREWELL DOUBLE DRAGONS. HA, HA, HA!"}, {".........", "THE MYSTERIOUS WARRIOR DIED, LEAVING NO CLUE TO WHAT HIS LAST WORDS MEANT. BUT BILLY AND JIMMY FELT THEIR REVENGE WAS COMPLETE..."}, {"WHEN TWO DRAGONS SOAR THROUGH THE SKY, AN ANGEL WILL FALL TO THE EARTH... ", "THAT NIGHT AN ANGEL DESCENDED FROM THE HEAVENS AND RETURNED MARIAN TO THE DOUBLE DRAGONS ALIVE AND WELL."}, {"   "}, {"   "}, {"THE END"}}, {{"19XX... LA VIOLENCE R\u00c8GNAIT \u00c0 NEW YORK D\u00c9VAST\u00c9 PAR LA GUERRE NUCL\u00c9AIRE. SEULS DEUX FR\u00c8RES ONT OS\u00c9 AFFRONTER LE SYNDICAT DU CRIME. LEURS NOMS: BILLY ET JIMMY LEE..."}, {"ILS S'\u00c9CHAPPENT DANS CET H\u00c9LICO !", "VOUS N'Y ARRIVEREZ JAMAIS !", "MISSION 2 - L'H\u00c9LIPORT"}, {"PAS SI VITE...", "VOUS NE NOUS \u00c9CHAPPEREZ PAS!", "C'EST GAGN\u00c9 !"}, {"L'H\u00c9LICO S'EST ENVOL\u00c9 DANS LA NUIT.", "MISSION 3 - BATAILLE DANS LES AIRS"}, {"L'H\u00c9LICO A ATTERRI SUR UNE ILE MYST\u00c9RIEUSE.", "MISSION 4 - BASE SOUS-MARINE"}, {"O\u00d9 NOUS CONDUIRA CE SENTIER ?", "NOUS DEVONS CONTINUER, M\u00caME SI LA MORT NOUS ATTEND AU BOUT DU CHEMIN.", "MISSION 5 - FOR\u00caT DE LA MORT"}, {"O\u00d9 SOMMES-NOUS ?", "LA SOURCE DU MAL EST PROCHE.", "MISSION 6 - MANOIR DE LA TERREUR"}, {"BILLY... C'EST DE LA FOLIE QUE D'ALLER PLUS LOIN !"}, {"JE CROIS QUE J'AI ENTENDU LA VOIX DE MARIANNE. MAIS C'EST IMPOSSIBLE !", "MISSION 7 - SALLE DES PI\u00c8GES"}, {"BANDE DE SALAUDS, O\u00d9 SE CACHE VOTRE CHEF ?", "HA...HA... NOTRE CHEF EST INVINCIBLE. VOTRE MORT EST CERTAINE.", "MISSION 8 - DOUBLE ILLUSION"}, {"C'EST IMPOSSIBLE ! \u00c7A NE PEUT PAS \u00caTRE ELLE !"}, {"MA... MARIANNE ", "MISSION 9 - CONFRONTATION FINALE "}, {"VOTRE FIN EST PROCHE, DOUBLES DRAGONS. VOUS N'AVEZ AUCUNE CHANCE CONTRE MOI OU \u00c0 MES ILLUSIONS."}, {"TU NE M'ARR\u00caTERAS PAS. JE DOIS VENGER MARIANNE. EN GARDE, GUERRIER DES OMBRES.", "VAS-Y, BILLY LEE !"}, {"   "}, {"NOTRE LUTTE EST TERMIN\u00c9E. \u00c9COUTEZ LA L\u00c9GENDE DE L'OMBRE...", "SI L'ILLUSION SE R\u00c9PAND, LE MAL RENA\u00ceTRA. MAIS QUAND DEUX DRAGONS TRAVERSENT LE CIEL, UN ANGE SE R\u00c9VEILLE SUR TERRE."}, {"BIENT\u00d4T... JE SERAI MORT ET VOUS ME REJOINDREZ. ADIEU, DOUBLES DRAGONS. HA, HA, HA !"}, {".........", "LE MYST\u00c9RIEUX GUERRIER EST MORT, SANS EN DIRE PLUS SUR LA L\u00c9GENDE. MAIS BILLY ET JIMMY SAVAIENT QU'ILS AVAIENT EU LEUR REVANCHE."}, {"LORSQUE DEUX DRAGONS TRAVERSENT LE CIEL, UN ANGE SE R\u00c9VEILLE SUR TERRE. ", "CETTE NUIT UN ANGE EST DESCENDU DU CIEL ET LEUR A RETOURN\u00c9 MARIANNE SAINE ET SAUVE."}, {"   "}, {"   "}, {"FIN"}}, {{"19XX... NACH DEM ATOMKRIEG HERRSCHT GEWALT AUF DEN STRASSEN VON NEW YORK. ABER ZWEI JUNGE M\u00c4NNER WAREN TAPFER GENUG, GEGEN DAS ORGANISIERTE VERBRECHEN VORZUGEHEN. IHRE NAMEN WAREN BILLY UND JIMMY LEE..."}, {"SIE ENTKOMMEN IN DEM CHOPPER", "IHR KRIEGT UNS NIE!", "MISSION 2 - AM HELIPORT"}, {"WARTE MAL", "IHR ENTKOMMT UNS NICHT", "GEFASST!"}, {"DER CHOPPER IST IN DIE NEON HELLE NACHT ENTKOMMEN", "MISSION 3 - KAMPF IM CHOPPER"}, {"DER CHOPPER LANDET AUF EINER VERBORGENEN INSEL.", "MISSION 4 - UNTERWASSERBASIS"}, {"WO GEHT ES HIER LANG?", "WIR M\u00dcSSEN WEITER, AUCH WENN DIESER WEG IN DEN SICHEREN TOD F\u00dcHRT.", "MISSION 5 - TODESWALD"}, {"WO SIND WIR?", "ICH SP\u00dcRE B\u00d6SES.", "MISSION 6 - HAUS DES TERRORS"}, {"BILLY... VON HIER IST ES ZU GEF\u00c4HRLICH!"}, {"ICH HABE MA... MARIAN GEH\u00d6RT. DAS KANN DOCH NICHT SEIN, ODER?", "MISSION 7 - DIE FALLE"}, {"OK, IHR FLASCHEN, WO VERSTECKT SICH EUER FEIGER BOSS?!", "HA! GEGEN UNSEREN BOSS KOMMT IHR NIE AN. IHR WERDET NUR SELBST UNTERGEHEN.", "MISSION 8 - DOPPELTE T\u00c4USCHUNG."}, {"UNM\u00d6GLICH... DAS KANN SIE NICHT SEIN!"}, {"MA... MARIAN?", "MISSION 9 - LETZTE KONFRONTATION?"}, {"DAS WAR'S, DOPPELDRACHEN. IHR KOMMT NICHT AN GEGEN MICH ODER MEINE ILLUSIONEN. LOS GEHT'S!"}, {"NICHTS KANN MICH STOPPEN. ICH MUSS MARIAN R\u00c4CHEN. KOMMT HER, SCHATTENKRIEGER!", "LOS, BILLY LEE!"}, {"   "}, {"UNSER KAMPF IST ENDLICH VORBEI. JETZT ERZ\u00c4HLE ICH EUCH DIE LEGENDE DES SCHATTEN... ", "WENN SICH DIE T\u00c4USCHUNG AUSBREITET, ERWACHT DAS B\u00d6SE ZUM LEBEN. ABER WENN ZWEI DRACHEN FLIEGEN, LANDET EIN ENGEL AUF DER ERDE. "}, {"BALD... STERBE ICH UND NEHME DICH MIT. LEBT WOHL, DOPPELDRACHEN, HA, HA, HA!"}, {".........", "DER GEHEIMNISVOLLE KRIEGER IST TOT, NIEMAND VERSTEHT SEINE LETZTEN WORTE. ABER F\u00dcR BILLY UND JIMMY WAR DIE RACHE KOMPLETT."}, {"WENN ZWEI DRACHEN FLIEGEN, LANDET EIN ENGEL AUF DER ERDE... ", "DIESE NACHT LANDETE EIN ENGEL AUS DEM HIMMEL UND BRACHTE DEN DOPPELDRACHEN MARIAN HEIL UND GESUND ZUR\u00dcCK."}, {"   "}, {"   "}, {"ENDE "}}, {{"19XX... LA VIOLENCIA REINA EN LAS CALLES DE NUEVA YORK TRAS LA GUERRA NUCLEAR. AUNQUE LAS ORGANIZACIONES MAFIOSAS CRECEN CADA A\u00d1O, DOS J\u00d3VENES VALIENTES SE ATREVEN A DESAFIARLAS. SE LLAMAN BILLY Y JIMMY LEE..."}, {"SE ESCAPAN EN ESE HELIC\u00d3PTERO", "\u00a1NUNCA LO CONSEGUIR\u00c9IS!", "MISI\u00d3N 2 - EL HELIPUERTO"}, {"NO TAN R\u00c1PIDO", "NUNCA ESCAPAR\u00c9IS", "\u00a1YA SOIS M\u00cdOS!"}, {"EL HELIC\u00d3PTERO SE ESCAPA EN LA NOCHE", "MISI\u00d3N 3 - LUCHA EN EL HELIC\u00d3PTERO"}, {"EL HELIC\u00d3PTERO ATERRIZA EN UNA ISLA MISTERIOSA.", "MISI\u00d3N 4 - BASE SUBMARINA"}, {"\u00bfA D\u00d3NDE LLEVA ESTE CAMINO?", "S\u00d3LO NOS QUEDA SEGUIR, AUNQUE EL CAMINO NOS LLEVE A UNA MUERTE SEGURA.", "MISI\u00d3N 5 - BOSQUE MORTAL"}, {"\u00bfD\u00d3NDE ESTAMOS?", "PRESIENTO ALGO MALO.", "MISI\u00d3N 6 - LA CASA DEL TERROR."}, {"BILLY, A PARTIR DE AQU\u00cd ES MUY PELIGROSO."}, {"ME PARECE HABER O\u00cdDO LA VOZ DE MARIAN. PERO ESO ES IMPOSIBLE, \u00bfNO?", "MISI\u00d3N 7 - EL FOSO."}, {"MUY BIEN, MATONES, \u00bfD\u00d3NDE SE ESCONDE VUESTRO JEFE?", "\u00a1JA, JA, JA! NUNCA ACABAR\u00c9IS CON NUESTRO JEFE. MORIR\u00c9IS EN EL INTENTO.", "MISI\u00d3N 8 - ILUSI\u00d3N DOBLE."}, {"ES IMPOSIBLE... \u00a1NO PUEDE SER ELLA!"}, {"\u00bfMARIAN?", "MISI\u00d3N 9 - CONFRONTACI\u00d3N FINAL"}, {"FIN DE LA HISTORIA, HERMANOS DRAG\u00d3N. NO SOIS NADA COMPARADOS CONMIGO Y MIS ILUSIONES. \u00a1VAMOS ALL\u00c1!"}, {"NO PUEDES DETENERME. VENGAR\u00c9 A MARIAN. PREP\u00c1RATE, GUERRERO EN LA SOMBRA.", " "}, {"   "}, {"LA BATALLA LLEGA A SU FIN. DEJA QUE TE EXPLIQUE LA LEYENDA DEL GUERRERO EN LA SOMBRA...", "SI LA ILUSI\u00d3N SE EXTIENDE, EL MAL VOLVER\u00c1 A REINAR. PERO CUANDO DOS DRAGONES SURQUEN EL CIELO, UN \u00c1NGEL CAER\u00c1 EN LA TIERRA."}, {"PRONTO MORIR\u00c9 Y VOSOTROS ME ACOMPA\u00d1AR\u00c9IS. ADI\u00d3S, HERMANOS DRAG\u00d3N. \u00a1JA, JA, JA!"}, {".........", "AUNQUE EL GUERRERO MISTERIOSO MUERE SIN EXPLICAR SUS \u00daLTIMAS PALABRAS, BILLY Y JIMMY HAN COMPLETADO SU VENGANZA."}, {"CUANDO DOS DRAGONES SURQUEN EL CIELO, UN \u00c1NGEL CAER\u00c1 EN LA TIERRA... ", "AQUELLA NOCHE, UN \u00c1NGEL BAJ\u00d3 DEL CIELO Y DEVOLVI\u00d3 A MARIAN SANA Y SALVA A LOS HERMANOS DRAG\u00d3N."}, {"   "}, {"   "}, {"FIN"}}, {{"19XX... LA VIOLENZA REGNA NELLE STRADE DI NEW YORK DOPO LA GUERRA NUCLEARE. NONOSTANTE LE BANDE CRIMINALI AUMENTINO OGNI ANNO, DUE UOMINI SI DIMOSTRANO TALMENTE CORAGGIOSI DA SFIDARLI. SONO BILLY E JIMMY LEE..."}, {"STANNO SCAPPANDO \nCON \nQUELL'ELI- \nCOTTERO", "NON CE LA FARETE MAI!", "MISSIONE 2 - ALL'ELIPORTO"}, {"NON COS\u00cc VELOCE", "NON CI SCAPPERETE MAI", "PRESO!"}, {"L'ELICOTTERO \u00c8 VOLATO VIA NELLA NOTTE ILLUMINATA", "MISSIONE 3 - LOTTA NELL'ELICOTTERO"}, {"L'ELICOTTERO ATTERRA SU UN'ISOLA MISTERIOSA.", "MISSIONE 4 - BASE SOTTOMARINA"}, {"DOVE CONDUCE QUESTA STRADA?", "NON POSSIAMO FARE ALTRO CHE PROSEGUIRE, ANCHE SE QUESTO CI PORTER\u00c0 ALLA MORTE.", "MISSIONE 5 - LA FORESTA DELLA MORTE"}, {"DOVE SIAMO?", "SENTO QUALCOSA DI MALVAGIO.", "MISSIONE 6 - LA DIMORA DEL TERRORE."}, {"BILLY... DA QUI IN POI \u00c8 TROPPO PERICOLOSO!"}, {"MI SEMBRA DI SENTIRE LA VOCE DI MA... MARIAN. \u00c8 IMPOSSIBILE O \u00c8 LEI?", "MISSIONE 7 - LA TRAPPOLA."}, {"OK, BANDITI. DOVE SI NASCONDE QUEL BAVOSO DEL CAPO?", "AH, AH, AH! NON SCONFI- \nGGERETE MAI IL CAPO. RIUSCIRETE SOLO A FARVI UCCIDERE.", "MISSIONE 8 - LA DOPPIA ILLUSIONE."}, {"\u00c8 IMPOSSIBILE... NON PU\u00d2 ESSERE LEI!"}, {"MA... MARIAN?", "MISSIONE 9 - CONFRONTO FINALE?"}, {"\u00c8 LA FINE, DRAGHI. NON CE LA FARETE CONTRO DI ME O LE MIE ILLUSIONI OTTICHE. VEDIAMO COSA SAPETE FARE!"}, {"NON PUOI FERMARMI. DEVO VENDICARE MARIAN. ATTENTO A TE GUERRIERO DELL'OMBRA.", "VAI, BILLY LEE!"}, {"   "}, {"LA BATTAGLIA \u00c8 FINITA. VI RACCONTER\u00d2 LA LEGGENDA DELL'OMBRA...", "SE SI DIFFONDE L'ILLUSIONE, IL MALE VIVR\u00c0 DI NUOVO. MA SE I DUE DRAGHI VOLERANNO NEI CIELI, UN ANGELO CADR\u00c0 SULLA TERRA."}, {"PRESTO... MORIR\u00d2 E VOI MI RAGGIUNGERETE. ADDIO, DRAGHI AH, AH, AH!"}, {".........", "IL GUERRIERO MISTERIOSO \u00c8 MORTO SENZA FAR CAPIRE IL SIGNIFICATO DELLE SUE PAROLE, MA BILLY E JIMMY SENTONO CHE LA VENDETTA \u00c8 COMPLETA."}, {"QUANDO DUE DRAGHI VOLERANNO NEI CIELI, UN ANGELO CADR\u00c0 SULLA TERRA...", "QUELLA NOTTE UN ANGELO SCESE DAL PARADISO RIPORTANDO MARIAN VIVA VEGETA AI DUE DRAGHI."}, {"   "}, {"   "}, {"FINE"}}};
    public String[] Languages = new String[]{"english", "fran\u00e7ais", "deutsch", "espa\u00f1ol", "italiano"};
    public String[] StrMobVersion = new String[]{"Mobile Version\n", "Version mobile\n", "Handy-Version\n", "Versi\u00f3n para m\u00f3vil\n", "Versione mobile\n"};
    public String[] StrDevelopedBy = new String[]{"Developed By\n", "D\u00e9velopp\u00e9 par\n", "Entwickelt von\n", "Desarrollado por\n", "Sviluppato da\n"};
    public String[] StrLeadProgrammer = new String[]{"Lead Programmer\n", "Programmeur en chef\n", "Lead-Programmierer\n", "Jefe de programaci\u00f3n\n", "Primo programmatore\n"};
    public String[] StrProgrammers = new String[]{"Programmers\n", "Programmeurs\n", "Programmierer\n", "Programadores\n", "Programmatori\n"};
    public String[] StrMusicBy = new String[]{"Music by\n", "Musique\n", "Musik von\n", "M\u00fasica\n", "Musica di\n"};
    public String[] StrGraphics = new String[]{"Graphics Remade By\n", "Recr\u00e9ation graphique\n", "Grafikumarbeitung von\n", "Gr\u00e1ficos\n", "Grafica ricompilata da\n"};
    String creditsString;
    public String[] AboutString = new String[]{"NOTE: You can also redefine keys in the OPTIONS menu\n\nUse * and 0 to attack left or right.  This will result in either a forward Punch or back Kick attack depending upon which way player is facing.\n\nTo jump straight up in the air press 7.\n\nTo jump forwards press 7 whilst walking forward.\n\nTo perform a Jump Kick press * or 0 whilst jumping.\n\nTo perform a Cyclone Kick press * or 0 at the top height of a jump.\n\nTo perform an uppercut use a Punch attack on a stunned enemy.\n\nTo grab an enemy walk into them when they are stunned.\n\nNOTE: not all enemies can be grabbed.\n\nFrom GRAB:\n\nPress back Kick to throw enemy over shoulder.\n\nPress Punch to knee the enemy.\n\nPress down and Punch to deliver elbow attack.\n\nPress up and Punch to deliver kick attack.\n\nTo pick up a weapon press Punch while standing over it.\n\nTo use a weapon press Punch.\n\nSPECIAL MOVES:\n\nHyper Uppercut\nPress Punch when landing from a jump or about to stand back up from being knocked down.\n\nHyper Knee\nPress back Kick when landing from a jump or about to stand back up from being knocked down.\n\nNOTE:\nTiming is crucial to perform a special attack, practice them well and you will be able to master the game.\n\nPress the right softkey in game to pause and return to the main menu.\n\nGame progress will be saved automatically.", "REM: Vous pouvez reprogrammer les touches dans le menu OPTIONS.\n\nAttaque \u00e0 gauche ou \u00e0 droite: appuyer sur * et 0. En fonction de\n l'orientation, cela donne un coup de poing avant ou un coup de pied arri\u00e8re.\n\nSaut vers le haut: appuyer sur 7.\n\nSaut vers l'avant: appuyer sur 7 en marchant.\n\nCoup de pied saut\u00e9: appuyer sur * ou sur 0 pendant un saut.\n\nCoup de pied circulaire: appuyer sur * ou sur 0 \u00e0 l'apog\u00e9e du saut.\n\nUppercut: lancer un coup de poing sur un ennemi sonn\u00e9.\n\nSaisir un ennemi: marcher sur lui lorsqu'il est sonn\u00e9.\n\nREM: certains ennemis ne peuvent pas \u00eatre saisis.\n\nLorsqu'un ennemi est saisi:\n\nLancer par dessus l'\u00e9paule: lancer un Coup de pied arri\u00e8re.\n\nCoup de genou: lancer un Coup de poing.\n\nCoup de coude: appuyer sur Bas et Coup de poing.\n\nCoup de pied: appuyer sur Haut et Coup de poing.\n\nRamasser une arme: se placer au-dessus de l'arme et appuyer sur Coup de poing.\n\nUtiliser une arme: appuyer sur Coup de poing.\n\nMOUV. SP\u00c9CIAUX:\n\nHyper-uppercut\nAppuyer sur Coup de poing en fin de saut ou en se relevant.\n\nHyper-genou\nAppuyer sur Coup de pied arri\u00e8re en fin de saut ou en se relevant.\n\nREM:\n\nLes attaques sp\u00e9ciales exigent une bonne coordination. Exercez-vous pour devenir un champion.\n\nPour mettre le jeu en pause et revenir au menu principal, appuyez sur la touche de s\u00e9lection droite.\n\nVotre progression est enregistr\u00e9e automatiquement.", "HINWEIS: Die Tastenbelegung kann im Men\u00fc OPTIONEN ge\u00e4ndert werden.\n\nMit * und 0 links oder rechts angreifen. Je nach Richtung des Spielers ist das ein Schlag nach vorn oder ein Tritt nach hinten.\n\nMit 7 gerade nach oben springen. \n\nZum Vorw\u00e4rtssprung beim Gehen 7 dr\u00fccken.\n\nF\u00fcr Sprungtritt beim Springen * oder 0 dr\u00fccken.\n\nF\u00fcr Cyclone-Tritt auf Sprungh\u00f6he * oder 0 dr\u00fccken.\n\nF\u00fcr Aufw\u00e4rtshaken benommenen Feind mit Schlag angreifen.\n\nUm Feind zu fassen, auf ihn zugehen, wenn er benommen ist.\n\nHINWEIS: Nicht alle Feinde lassen sich festhalten.\n\nAb GRAB:\n\nMit Zur\u00fcck Kick Feind \u00fcber Schulter werfen.\n\nMit Punch das Knie in den Feind rammen.\n\nPfeil runter und Punch f\u00fcr Ellenbogen- \nangriff. \n\nPfeil hoch und Punch f\u00fcr Kickangriff.\n\nUm eine Waffe zu nehmen, Punch dr\u00fccken, w\u00e4hrend du dar\u00fcber stehst.\n\nUm Waffe anzuwenden, Punch dr\u00fccken. \n\nSPEZIAL- \nBEWEGUNGEN: \n\nHyper-Haken \nBeim Landen nach einem Sprung oder nach dem Aufstehen Punch dr\u00fccken. \n\nHyper-Knie \nBeim Landen nach einem Sprung oder nach dem Aufstehen Zur\u00fcck Kick dr\u00fccken. \n\nHINWEIS \n\nF\u00fcr den Erfolg einer Spezial- \nbewegung ist das richtige Timing entscheidend. Und \u00dcbung macht hier den Meister. \n\nMit dem rechten Softkey h\u00e4ltst du das Spiel an und geht zur\u00fcck zum Hauptmen\u00fc. \n\nDer Spielstand wird automatisch gespeichert.", "NOTA: Puedes redefinir las teclas en el men\u00fa OPCIONES\n\nUsa * y 0 para atacar a izquierda o derecha. Dar\u00e1s un pu\u00f1etazo alante o una patada atr\u00e1s en funci\u00f3n de donde mire el jugador.\n\nPara saltar hacia arriba, pulsa 7. \n\nPara saltar hacia adelante, pulsa 7 mientras caminas.\n\nPara dar una patada voladora, pulsa * o 0 mientras saltas.\n\nPara dar una patada cicl\u00f3n, pulsa * o 0 en el punto m\u00e1s alto de un salto.\n\nPara dar un gancho, dale un pu\u00f1etazo a un enemigo aturdido.\n\nPara sujetar a un enemigo, camina hacia \u00e9l cuando est\u00e9 aturdido.\n\nNOTA: no todos los enemigos se dejan sujetar.\n\nRival sujeto:\n\nPulsa patada para lanzar al enemigo por encima del hombro.\n\nPulsa pu\u00f1etazo para dar un rodillazo.\n\nPulsa abajo y pu\u00f1etazo para dar un codazo.\n\nPulsa arriba y pu\u00f1etazo para dar una patada.\n\nPara coger un arma, pulsa pu\u00f1etazo estando junto a ella.\n\nPara usar el arma, pulsa pu\u00f1etazo.\n\nMOVIM. ESPECIALES:\n\nSupergancho\nPulsa pu\u00f1etazo al caer de un salto o al ponerte en pie tras haber sido derribado.\n\nRodillazo\nPulsa patada al caer de un salto o al ponerte en pie tras haber sido derribado.\n\nNOTA:\n\nLa sincronizaci\u00f3n es crucial a la hora de realizar un ataque especial. Pr\u00e1ctica bien para convertirte en el rey del juego.\n\nPulsa la tecla de selecci\u00f3n derecha en juego para poner pausa e ir al men\u00fa principal.\n\nEl progreso del juego se guardar\u00e1 autom\u00e1ticamente.", "NOTA: nel menu OPZIONI \u00e8 possibile anche ridefinire i tasti\n\nUsare * e 0 per attaccare a destra o a sinistra. Il risultato pu\u00f2 essere un Pugno in avanti o un Calcio all'indietro in base alla posizione del giocatore.\n\nPer saltare dritto in alto premere 7.\n\nPer saltare in avanti premere 7 camminando in avanti.\n\nPer eseguire un Calcio con salto premere * o 0 mentre si salta.\n\nPer eseguire un Calcio ciclone premere * o 0 nel punto pi\u00f9 alto di un salto.\n\nPer eseguire un montante attaccare con un Pugno un nemico intontito.\n\nPer afferrare un nemico camminare verso di lui mentre \u00e8 intontito.\n\nNOTA: non tutti possono essere afferrati.\n\nDa AFFERRA:\n\nEseguire un Calcio all'indietro per lanciare il nemico.\n\nColpirlo con un Pugno per farlo cadere.\n\nPremere gi\u00f9 e Pugno per sferrare una gomitata.\n\nPremere su e Pugno per sferrare un calcio.\n\nPer raccogliere un'arma premere Pugno mentre ci si trova sopra di essa.\n\nPer usare un'arma premere Pugno.\n\nMOSSE SPECIALI:\n\nIpermontante\nPremere Pugno atterrando da un salto o quando ci si rialza dopo essere stati atterrati.\n\nIperginocch.\nPremere Calcio all'indietro atterrando da un salto o quando ci si rialza dopo essere stati atterrati. \n\nNOTA:\n\nIl tempo \u00e8 un fattore fondamentale per eseguire un attacco speciale, esercitati bene e sarai pronto a vincere la partita.\n\nPremere il softkey destro in partita per la pausa e tornare al menu principale.\n\nLa partita verr\u00e0 salvata automaticamente."};
    public String[] StrYes = new String[]{"yes", "oui", "ja", "s\u00ed", "s\u00ec"};
    public String[] StrNo = new String[]{"no", "non", "nein", "no", "no"};
    public String[] StrBack = new String[]{"back", "retour", "zur\u00fcck", "volver", "indietro"};
    public String[] StrSelect = new String[]{"select", "s\u00e9lect.", "ausw\u00e4hlen", "selec.", "seleziona"};
    public String[] StrSave = new String[]{"save", "enreg.", "speichern", "guardar", "salva"};
    public String[] StrOn = new String[]{" on", " act.", " an", " s\u00ed", " on"};
    public String[] StrOff = new String[]{" off", " d\u00e9s.", " aus", " no", " off"};
    public static String[] StrLoading = new String[]{"loading...", "chargement...", "wird geladen", "cargando...", "caricamento..."};
    public String[] StrChange = new String[]{"change", "modifier", "\u00e4ndern", "cambiar", "cambia"};
    public String[] StrExit = new String[]{"exit", "quitter", "ende", "salir", "esci"};
    public String[] StrVolume = new String[]{"volume", "volume", "lautst\u00e4rke", "volumen", "volume"};
    public String[] StrGameOver = new String[]{"GAME OVER", "GAME OVER", "GAME OVER", "FIN DE LA PARTIDA", "FINE DEL GIOCO"};
    public String[] StrMusicQuestion = new String[]{"Do you want to enable music?", "Activer la musique?", "Musik anstellen?", "\u00bfQuieres activar la m\u00fasica?", "Attivare la musica?"};
    public String[] StrExitQuestion = new String[]{"Are you sure you want to exit?", "\u00cates-vous s\u00fbr de vouloir quitter?", "Spiel wirklich beenden?", "\u00bfSeguro que quieres salir?", "Uscire?"};
    public String[] StrHiscoreQuestion = new String[]{"Are you sure you want to reset hi-score?", "Effacer les meilleurs scores?", "Highscore wirklich zur\u00fccksetzen?", "\u00bfQuieres borrar la m\u00e1xima puntuaci\u00f3n?", "Reimpostare i record?"};
    public String[] StrNewgameQuestion = new String[]{"Current game progress will be lost, are you sure?", "La partie en cours sera perdue. \u00cates-vous s\u00fbr?", "Aktueller Stand geht verloren. Wirklich?", "El progreso actual se perder\u00e1. \u00bfContinuar?", "La partita non verr\u00e0 salvata. Continuare?"};
    String[] Levels = new String[]{"level1", "level2", "level3", "level4", "level5", "level6", "level7", "level8", "level9"};
    public String[][] Menu = new String[][]{{"continue", "new game", "options", "help", "about"}, {"continuer", "nouvelle partie", "options", "aide", "\u00e0 propos de..."}, {"weiter", "neues spiel", "optionen", "hilfe", "info \u00fcber"}, {"continuar", "nueva partida", "opciones", "ayuda", "acerca de"}, {"continua", "nuova partita", "opzioni", "guida", "informazioni"}};
    public String[][] Difficulties = new String[][]{{"beginner", "master", "supreme master"}, {"d\u00e9butant", "expert", "champion"}, {"anf\u00e4nger", "master", "supreme master"}, {"principiante", "maestro", "supermaestro"}, {"principiante", "maestro", "maestro supremo"}};
    public String[][] Options = new String[][]{{"music", "sound effects", "volume", "vibrations", "clear high score", "controls", "language"}, {"musique", "effets audio", "volume", "vibrations", "effacer meil. scores", "commandes", "langue"}, {"musik", "soundeffekte", "lautst\u00e4rke", "vibrationen", "highscore l\u00f6schen", "steuerung", "sprache"}, {"m\u00fasica", "efectos sonido", "volumen", "vibraci\u00f3n", "borrar m\u00e1x. punt.", "controles", "idioma"}, {"musica", "effetti sonori", "volume", "vibrazioni", "cancella record", "controlli", "lingua"}};
    public String[][] Controls = new String[][]{{"move right", "move left", "move up", "move down", "attack right", "attack left", "jump ", "jump forward"}, {"d\u00e9pl. droite", "d\u00e9pl. gauche", "d\u00e9pl. haut", "d\u00e9pl. bas", "attaq. \u00e0 droite", "attaq. \u00e0 gauche", "saut ", "saut avant"}, {"nach rechts", "nach links", "nach oben", "nach runten", "angriff rechts", "angriff links", "sprung ", "nach vorn"}, {"mover derecha", "mover izquierda", "mover arriba", "mover abajo", "atacar derecha", "atacar izq.", "saltar", "saltar adelante"}, {"destra", "sinistra", "su", "gi\u00f9", "attacco destro", "attacco sinist.", "salto", "salto in avanti"}};
    public String[] StrScore = new String[]{"score", "score", "score", "puntos", "punti"};
    public String[] StrHiScore = new String[]{"hiscore", "m.score", "hiscore", "m\u00e1x", "record"};
    int selectedMenu;
    int selectedElement;
    private static final int MAX_DELTA_TIME = 32;
    public static int cameraX;
    public static int cameraY;
    private int beginHeroPositionX = 64 * GameAppState.scaleUpValue(176) >> 8;
    private int beginHeroPositionY = 192 * GameAppState.scaleUpValue(168) >> 8;
    private static int scrollX_MIN;
    private static int scrollX_MAX;
    private static int scrollY_MIN;
    private static int scrollY_MAX;
    private static int maxScrollSpeed;
    private int tileWidth;
    private int tileHeight;
    public static TiledLayer tiledLayer;
    public static Level level;
    public static Hero hero;
    public static Hero[] heros;
    private int regionTime = 0;
    public static Weapon[] weapons;
    public static int weaponsCount;
    private Image[] handImage = new Image[4];
    public static int handTime;
    private static byte handDirection;
    public static boolean drawHeroFirst;
    public static int levelNumber;
    public static Random random;
    public static byte ileWrogow;
    public Image hud;
    public int time1;
    public int time2;
    public Image door;
    public int HELI_DOOR_TIME = 10000;
    public static boolean doorOpened;
    public Image zgniatarka;
    public int ZGNIATARKA_TIME = 1800;
    public static boolean zgniatarkaEnabled;
    public Image heli1;
    public int fp_heliPosX;
    public static boolean heliEnabled;
    public static int HELI1_STARTX;
    public static int HELI1_ENDX;
    public static boolean heliShooting;
    private byte bulletsShot;
    private byte bulletSpeedY;
    public Image heli2;
    public static int fp_heli2PosY;
    public static int HELI2_STARTY;
    public static int HELI2_ENDY;
    public static int HELI2_X;
    public static boolean heli2Flying;
    public static int enabledPlatform;
    public static int enabledPlatform1;
    public static byte FIRST_PLATFORM2;
    public static byte LAST_PLATFORM2;
    public static byte FIRST_PLATFORM1;
    public static byte LAST_PLATFORM1;
    public int[] platform2X = new int[]{120, 88, 56, 8, 64};
    public int[] platform2Y = new int[]{104, 88, 88, 72, 56};
    public int[] platform1X = new int[]{536, 568, 536};
    public int[] platform1Y = new int[]{104, 88, 64};
    public static short PLATFORM_TIME2;
    public Image platform_small;
    public Image platform_large;
    public Image platform_small_hide;
    public Image platform_large_hide;
    public int[] flamesX = new int[]{155648, 163584, 147712, 147712};
    public int[] flamesY = new int[]{1792, 1792, 5632, 5632};
    public int[] flamesEndY = new int[]{26624, 30720, 46848, 46848};
    public int currentFlame;
    public int[] spikesX = new int[]{154368, 170752, 187136, 178944, 162560};
    public int spikeY = 48640;
    public int currentSpike;
    public byte hiddenTiles1;
    public byte hiddenTiles2;
    boolean levelLoading;
    public static boolean musicEnabled;
    public static boolean soundsEnabled;
    public static boolean vibrationsEnabled;
    SimpleAnimation anim = new SimpleAnimation(5, 1);
    public static SimpleAnimation[] animations;
    public static int[] animPosX;
    public static int[] animPosY;
    private int menuState;
    private boolean menuRequested;
    private static int tractorSpeed;
    private static int tractorStartPosition;
    private Image tractorImage;
    public static boolean tractorEnabled;
    public static final int tractorMaxX = 29440;
    public static final int tractorMinX = -7680;
    private int tractorOffset = 29440;
    public byte currentSteam;
    public static final byte firstSteam = 4;
    public static final byte lastSteam = 6;
    public static boolean fadingIn;
    public static boolean fadingEnabled;
    public static int fadeValue;
    public static byte levelRequested;
    public static byte menuIdRequested;
    public static boolean splashScreenHideRequested;
    public static final short FADING_STEP = 256;
    public boolean nextLevelRequested;
    public static Image font_white;
    public static Image font_gray;
    public static Image font_blue;
    public static Image currentFont;
    public static SplashScreen splash;
    public static Integer punchSoundId;
    public static Integer punchId1;
    public static Image winda;
    public static Image platforma;
    public static boolean windaActive;
    public static boolean savedGameExist;
    public boolean loadGameRequested;
    public int hiScore;
    public byte[] tmpKeys;
    public boolean editingKey;
    public boolean canSaveKeys;
    public int credistScrollValue;
    public Image menuImage;
    public Image menuBackground;
    public Image volumeImage;
    public static boolean paused;
    public int helpScroll;
    public boolean menuRepaintRequested;
    public boolean menuRepainted;
    public static boolean hudRepaintRequested;
    public static byte difficulty;
    public static byte difficultiesPlayed;
    private int lastScore;
    private int lastLife;
    private int lastLives;
    public boolean firstStart;
    public static byte language;
    Image logoImage = null;
    byte currentLogo;
    public static final byte KEY_RIGHT = 0;
    public static final byte KEY_LEFT = 1;
    public static final byte KEY_UP = 2;
    public static final byte KEY_DOWN = 3;
    public static final byte KEY_ATTACK_RIGHT = 4;
    public static final byte KEY_ATTACK_LEFT = 5;
    public static final byte KEY_JUMP = 6;
    public static final byte KEY_DIAGONAL_JUMP = 7;
    public static final byte KEY_PUNCH = 8;
    public static final int keyNumber = 9;
    public static byte[] keyCodes;
    public static int[] stanKlawisza;
    public static int[] czasKlawisza;
    public static long[] momentWcisnieciaKlawisza;
    public static long[] momentPuszczeniaKlawisza;
    public static boolean wyzerujKlawisze;
    Level tmpLevel = null;
    Hero tmpHero = null;
    static boolean init;
    Image life_bar;
    boolean rightHand = true;
    public static TilesImage[] enemyImage;
    public static TilesImage currentEnemyImage;
    public static int currentEnemyImageId;
    boolean firstFrameAfterLoading;
    public static final byte fontSize = 8;
    private static short[] characters;
    public static final int TEXT_ALIGN_LEFT = 0;
    public static final int TEXT_ALIGN_CENTER = 1;
    public static final int TEXT_ALIGN_RIGHT = 2;
    public static boolean maxScroll;
    static int lastVolume;
    static int loopCount;
    static String lastTrack;
    Integer musicId = null;

    public void createCreditsString() {
        this.creditsString = null;
        this.creditsString = "Double Dragon 2\nThe Revenge\n" + this.StrMobVersion[language] + "V1.0.0\n\n" + "\u2122 & \u00a9 2007\n" + "Million Co. Ltd.\n\n" + "(p) 2007\n" + "Elite Systems Group Ltd.\n\n" + this.StrDevelopedBy[language] + "Qubic Games\n\n" + this.StrLeadProgrammer[language] + "Michal Przybylo\n\n" + this.StrProgrammers[language] + "Lukasz Izdebski\n" + "Jakub Pieczykolan\n\n" + this.StrGraphics[language] + "Daniel Mikulik\n" + "Jakub Rozenek\n\n" + this.StrMusicBy[language] + "gyrox.co.uk";
    }

    public GameAppState(String stateName, MainGameCanvas mainGameCanvas) {
        super(stateName, mainGameCanvas);
    }

    public Image createFont(int color) {
        Image tmp = null;
        try {
            tmp = color == 5472725 ? Image.createImage((String)"/font_blue.png") : Image.createImage((String)"/font_gray.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return tmp;
    }

    public boolean initialize(Object param) {
        try {
            GameAppState.setKeyCodes(true);
            random = new Random();
            this.time1 = -15;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.currentLogo = 0;
            this.logoImage = Image.createImage((String)"/elite.png");
            difficulty = 0;
            this.credistScrollValue = -GameAppState.yPosition(400);
            this.menuRepaintRequested = true;
            this.menuRepainted = false;
            hudRepaintRequested = true;
            paused = false;
            savedGameExist = false;
            soundsEnabled = true;
            vibrationsEnabled = true;
            this.loadGameRequested = false;
            splashScreenHideRequested = false;
            levelRequested = (byte)-1;
            menuIdRequested = (byte)-1;
            this.nextLevelRequested = false;
            this.menuRequested = false;
            this.menuState = 16;
            random = new Random();
            this.handImage[0] = Image.createImage((String)"/lapka.png");
            this.handImage[1] = Image.createImage((Image)this.handImage[0], (int)0, (int)0, (int)this.handImage[0].getWidth(), (int)this.handImage[0].getHeight(), (int)2);
            this.handImage[2] = Image.createImage((Image)this.handImage[0], (int)0, (int)0, (int)this.handImage[0].getWidth(), (int)this.handImage[0].getHeight(), (int)6);
            this.handImage[3] = Image.createImage((Image)this.handImage[0], (int)0, (int)0, (int)this.handImage[0].getWidth(), (int)this.handImage[0].getHeight(), (int)5);
            handDirection = (byte)-1;
            this.levelLoading = false;
            font_white = Image.createImage((String)"/font.png");
            font_blue = this.createFont(5472725);
            currentFont = font_white;
            GameAppState.setKeyCodes(true);
            this.firstStart = false;
            language = 0;
            this.loadScores();
            if (language > 4 || language < 0) {
                language = 0;
            }
            if (!savedGameExist) {
                this.selectedMenu = 1;
            }
            if (this.firstStart) {
                this.selectedMenu = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void setCameraStartPosition(int heroScreenPositionX, int heroScreenPositionY) {
        cameraX = (GameAppState.hero.fp_heroX >> 8) - heroScreenPositionX;
        cameraY = (GameAppState.hero.fp_heroY >> 8) - heroScreenPositionY;
        GameAppState.checkCameraPosition();
    }

    public void checkHeroPosition() {
        if (GameAppState.hero.state != 4) {
            int heroX = GameAppState.hero.fp_heroX >> 8;
            int heroY = GameAppState.hero.fp_heroY >> 8;
            if (GameAppState.level.currentRegion == GameAppState.hero.currentRegionX) {
                if (heroX > GameAppState.level.region[GameAppState.level.currentRegion].maxX - 15) {
                    GameAppState.hero.fp_heroX = GameAppState.level.region[GameAppState.level.currentRegion].maxX - 15 - 1 << 8;
                }
                if (heroX < GameAppState.level.region[GameAppState.level.currentRegion].minX + 15) {
                    GameAppState.hero.fp_heroX = GameAppState.level.region[GameAppState.level.currentRegion].minX + 15 + 1 << 8;
                }
            } else {
                if (heroX < cameraX + 15) {
                    GameAppState.hero.fp_heroX = cameraX + 15 << 8;
                }
                if (heroX > cameraX + GameAppState.scaleUpValue(176) - 15) {
                    GameAppState.hero.fp_heroX = cameraX + GameAppState.scaleUpValue(176) - 15 << 8;
                }
            }
            if (GameAppState.level.currentRegion == GameAppState.hero.currentRegionY) {
                if (heroY > GameAppState.level.region[GameAppState.level.currentRegion].maxY) {
                    GameAppState.hero.fp_heroY = GameAppState.level.region[GameAppState.level.currentRegion].maxY - 1 << 8;
                }
                if (heroY - 35 < GameAppState.level.region[GameAppState.level.currentRegion].minY && !hero.inAir()) {
                    GameAppState.hero.fp_heroY = GameAppState.level.region[GameAppState.level.currentRegion].minY + 35 + 1 << 8;
                }
            } else {
                if (heroY - 35 < cameraY && !hero.inAir()) {
                    GameAppState.hero.fp_heroY = cameraY + 35 + 1 << 8;
                }
                if (heroY > cameraY + GameAppState.scaleUpValue(168)) {
                    GameAppState.hero.fp_heroY = cameraY + GameAppState.scaleUpValue(168) << 8;
                }
            }
        } else if (GameAppState.level.currentRegion != GameAppState.hero.currentRegionY && GameAppState.hero.fp_heroY >> 8 > cameraY + GameAppState.scaleUpValue(168)) {
            GameAppState.hero.nextSectorFall = -1;
        }
    }

    public static void checkCameraPosition() {
        int delta;
        int newPos;
        int regionWidth = GameAppState.level.region[GameAppState.level.currentRegion].maxX - GameAppState.level.region[GameAppState.level.currentRegion].minX;
        if (regionWidth < GameAppState.scaleUpValue(176)) {
            cameraX = GameAppState.level.region[GameAppState.level.currentRegion].minX + (regionWidth >> 1) - (GameAppState.scaleUpValue(176) >> 1);
            return;
        }
        int heroScreenPositionX = (GameAppState.hero.fp_heroX >> 8) - cameraX;
        int heroScreenPositionY = (GameAppState.hero.fp_heroY >> 8) - cameraY;
        if (heroScreenPositionX < scrollX_MIN) {
            newPos = (GameAppState.hero.fp_heroX >> 8) - scrollX_MIN;
            delta = cameraX - newPos;
            if (GameAppState.level.currentRegion == GameAppState.hero.currentRegionX || GameAppState.level.region[GameAppState.hero.currentRegionX].nextSectorDirection != Region.DIR_RIGHT) {
                cameraX = delta > maxScrollSpeed ? (cameraX -= maxScrollSpeed) : newPos;
            }
        } else if (heroScreenPositionX > scrollX_MAX) {
            newPos = (GameAppState.hero.fp_heroX >> 8) - scrollX_MAX;
            delta = cameraX - newPos;
            if (GameAppState.level.currentRegion == GameAppState.hero.currentRegionX || GameAppState.level.region[GameAppState.hero.currentRegionX].nextSectorDirection != Region.DIR_LEFT) {
                cameraX = delta < -maxScrollSpeed ? (cameraX += maxScrollSpeed) : newPos;
            }
        }
        if (heroScreenPositionY < scrollY_MIN) {
            newPos = (GameAppState.hero.fp_heroY >> 8) - scrollY_MIN;
            delta = cameraY - newPos;
            if (GameAppState.level.currentRegion == GameAppState.hero.currentRegionY || GameAppState.level.region[GameAppState.hero.currentRegionY].nextSectorDirection != Region.DIR_DOWN) {
                cameraY = delta > maxScrollSpeed ? (cameraY -= maxScrollSpeed) : newPos;
            }
        } else if (heroScreenPositionY > scrollY_MAX) {
            newPos = (GameAppState.hero.fp_heroY >> 8) - scrollY_MAX;
            delta = cameraY - newPos;
            if (GameAppState.level.currentRegion == GameAppState.hero.currentRegionY || GameAppState.level.region[GameAppState.hero.currentRegionY].nextSectorDirection != Region.DIR_UP) {
                cameraY = delta < -maxScrollSpeed ? (cameraY += maxScrollSpeed) : newPos;
            }
        }
        if (cameraX < 0) {
            cameraX = 0;
        }
        if (cameraX > GameAppState.scaleUpValue(GameAppState.tiledLayer.layerWidth - 176)) {
            cameraX = GameAppState.scaleUpValue(GameAppState.tiledLayer.layerWidth - 176);
        }
        if (cameraY < 0) {
            cameraY = 0;
        }
        if (cameraY > GameAppState.scaleUpValue(GameAppState.tiledLayer.layerHeight - 168)) {
            cameraY = GameAppState.scaleUpValue(GameAppState.tiledLayer.layerHeight - 168);
        }
        int heroX = GameAppState.hero.fp_heroX >> 8;
        int heroY = GameAppState.hero.fp_heroY >> 8;
        if (GameAppState.level.currentRegion == GameAppState.hero.currentRegionX) {
            if (cameraX > GameAppState.level.region[GameAppState.level.currentRegion].maxX - GameAppState.scaleUpValue(176) && heroX < GameAppState.level.region[GameAppState.level.currentRegion].maxX) {
                cameraX = GameAppState.level.region[GameAppState.level.currentRegion].maxX - GameAppState.scaleUpValue(176);
            }
            if (cameraX < GameAppState.level.region[GameAppState.level.currentRegion].minX && heroX > GameAppState.level.region[GameAppState.level.currentRegion].minX) {
                cameraX = GameAppState.level.region[GameAppState.level.currentRegion].minX;
            }
        } else {
            if (cameraX >= GameAppState.level.region[GameAppState.level.currentRegion].minX && cameraX <= GameAppState.level.region[GameAppState.level.currentRegion].maxX && (GameAppState.level.region[GameAppState.hero.currentRegionX].nextSectorDirection == Region.DIR_UP || GameAppState.level.region[GameAppState.hero.currentRegionX].nextSectorDirection == Region.DIR_DOWN)) {
                GameAppState.hero.currentRegionX = GameAppState.level.currentRegion;
            }
            if (cameraX >= GameAppState.level.region[GameAppState.level.currentRegion].minX && cameraX <= GameAppState.level.region[GameAppState.level.currentRegion].maxX && GameAppState.level.region[GameAppState.hero.currentRegionX].nextSectorDirection == Region.DIR_RIGHT) {
                GameAppState.hero.currentRegionX = GameAppState.level.currentRegion;
            }
            if (cameraX + GameAppState.scaleUpValue(176) >= GameAppState.level.region[GameAppState.level.currentRegion].minX && cameraX + GameAppState.scaleUpValue(176) <= GameAppState.level.region[GameAppState.level.currentRegion].maxX && GameAppState.level.region[GameAppState.hero.currentRegionX].nextSectorDirection == Region.DIR_LEFT) {
                GameAppState.hero.currentRegionX = GameAppState.level.currentRegion;
            }
        }
        if (GameAppState.level.currentRegion == GameAppState.hero.currentRegionY) {
            if (cameraY < GameAppState.level.region[GameAppState.level.currentRegion].minY) {
                cameraY = GameAppState.level.region[GameAppState.level.currentRegion].minY;
            }
            if (cameraY > GameAppState.level.region[GameAppState.level.currentRegion].maxY - GameAppState.scaleUpValue(168)) {
                cameraY = GameAppState.level.region[GameAppState.level.currentRegion].maxY - GameAppState.scaleUpValue(168);
            }
        } else if (cameraY + 1 >= GameAppState.level.region[GameAppState.level.currentRegion].minY && cameraY + GameAppState.scaleUpValue(168) - 1 <= GameAppState.level.region[GameAppState.level.currentRegion].maxY) {
            GameAppState.hero.currentRegionY = GameAppState.level.currentRegion;
        }
    }

    public void update(int deltaTime) {
        if (deltaTime > 85) {
            deltaTime = 85;
        }
        try {
            if (level != null && splash == null && !this.levelLoading) {
                if (musicEnabled && loopCount == -1 && lastTrack != null && Music.getIdOfMusicBeingPlayed() == null) {
                    GameAppState.changeMusic(lastTrack, -1);
                }
                if (this.menuRequested) {
                    if (menuIdRequested != 104) {
                        GameAppState.changeMusic("/sfx/title.mid", 1);
                    } else {
                        GameAppState.changeMusic("/sfx/gameover.mid", 1);
                    }
                    level = null;
                    this.onMenuLoad();
                    this.menuRequested = false;
                    menuIdRequested = (byte)-1;
                } else {
                    int i;
                    long endTime = MainGameCanvas.currentTime;
                    long beginTime = MainGameCanvas.lastTime;
                    int time = (int)(endTime - beginTime);
                    if (time > 85) {
                        time = 85;
                    }
                    while (time > 0) {
                        int delta = time >= 64 ? 32 : (time <= 32 ? time : time >> 1);
                        if (!init) {
                            GameAppState.wyliczCzasyKlawiszy(beginTime, beginTime + (long)delta);
                        }
                        if (!paused) {
                            for (int z = 0; z < 5; z = (int)((byte)(z + 1))) {
                                if (heros[z] == null) continue;
                                heros[z].update(delta);
                            }
                        }
                        beginTime += (long)delta;
                        time -= delta;
                    }
                    this.checkHeroPosition();
                    if (animations != null) {
                        for (i = 0; i < animations.length; ++i) {
                            animations[i].update(deltaTime);
                        }
                    }
                    try {
                        for (i = 0; i < weaponsCount; ++i) {
                            if (!weapons[i].update(deltaTime)) {
                                GameAppState.removeWeapon(i);
                                --i;
                                continue;
                            }
                            int x = GameAppState.weapons[i].fp_X >> 8;
                            int y = GameAppState.weapons[i].fp_Y >> 8;
                            if (GameAppState.weapons[i].weaponType != 0 && GameAppState.weapons[i].weaponType != 3 && GameAppState.weapons[i].weaponType != 4 || x >= cameraX && x <= cameraX + GameAppState.scaleUpValue(176) && y >= cameraY && y <= cameraY + GameAppState.scaleUpValue(168)) continue;
                            GameAppState.removeWeapon(i);
                            --i;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (levelNumber == 2 && GameAppState.hero.currentRegionY == 3 && heliEnabled) {
                        this.time1 += deltaTime;
                        this.time2 += deltaTime;
                        if (this.time1 > 100 && heliShooting) {
                            GameAppState.addBullet(this.fp_heliPosX, 11520, -41984, this.bulletSpeedY << 8, 0, 0);
                            this.time1 = 0;
                            this.bulletsShot = (byte)(this.bulletsShot + 1);
                        }
                        if (this.bulletsShot == 3) {
                            heliShooting = false;
                            this.bulletSpeedY = this.bulletSpeedY == 64 ? (byte)127 : (byte)64;
                            this.bulletsShot = 0;
                        }
                        if (this.time2 > 1000) {
                            heliShooting = true;
                            this.time2 = 0;
                        }
                        this.fp_heliPosX -= deltaTime << 2;
                        if (this.fp_heliPosX <= HELI1_ENDX) {
                            this.fp_heliPosX = HELI1_ENDX;
                            heliEnabled = false;
                        }
                    }
                    if (levelNumber == 2 && GameAppState.level.currentRegion == 4) {
                        this.fp_heliPosX -= deltaTime << 2;
                        if (heli2Flying) {
                            if ((fp_heli2PosY -= deltaTime << 2) <= HELI2_ENDY) {
                                heli2Flying = false;
                                fp_heli2PosY = HELI2_ENDY;
                            }
                        } else if (fp_heli2PosY == HELI2_ENDY && levelRequested == -1 && Music.getIdOfMusicBeingPlayed() == null) {
                            levelRequested = (byte)(levelNumber + 1);
                            GameAppState.fadeOutIn();
                        }
                    }
                    if (levelNumber == 3) {
                        this.time1 += deltaTime;
                        doorOpened = this.time1 >= this.HELI_DOOR_TIME - 2500;
                        if (this.time1 >= this.HELI_DOOR_TIME) {
                            this.time1 = 0;
                        }
                    }
                    if (levelNumber == 4) {
                        this.time1 += deltaTime;
                        zgniatarkaEnabled = this.time1 >= this.ZGNIATARKA_TIME / 2;
                        if (this.time1 >= this.ZGNIATARKA_TIME) {
                            this.time1 = 0;
                        }
                        if (windaActive && GameAppState.hero.fp_heroX >> 8 > 420) {
                            animations[0].setState((byte)3);
                            windaActive = false;
                            GameAppState.showHand((byte)3);
                        }
                    }
                    if (levelNumber == 5 && GameAppState.level.currentRegion == 5 && tractorEnabled) {
                        int i2;
                        int tDelta;
                        int newPos;
                        if (GameAppState.animations[this.currentSteam].state == 2) {
                            this.currentSteam = (byte)(this.currentSteam - 1);
                            if (this.currentSteam < 4) {
                                this.currentSteam = (byte)6;
                            }
                            animations[this.currentSteam].setState((byte)5);
                        }
                        if ((newPos = this.tractorOffset + (tDelta = tractorSpeed * deltaTime >> 10)) > 29440) {
                            tDelta = 29440 - this.tractorOffset;
                            tractorSpeed = -tractorSpeed;
                        }
                        if (newPos < -7680) {
                            tDelta = -7680 - this.tractorOffset;
                            tractorSpeed = -tractorSpeed;
                            if (GameAppState.hero.currentSector == 22) {
                                tractorEnabled = false;
                            }
                        }
                        this.tractorOffset += tDelta >> 8 << 8;
                        for (i2 = 18; i2 <= 22; ++i2) {
                            int j = 0;
                            while (j < GameAppState.level.sectorEdgeTop[i2].pointsNumber) {
                                int n = j++;
                                GameAppState.level.sectorEdgeTop[i2].xPoint[n] = (short)(GameAppState.level.sectorEdgeTop[i2].xPoint[n] + (tDelta >> 8));
                            }
                            j = 0;
                            while (j < GameAppState.level.sectorEdgeBottom[i2].pointsNumber) {
                                int n = j++;
                                GameAppState.level.sectorEdgeBottom[i2].xPoint[n] = (short)(GameAppState.level.sectorEdgeBottom[i2].xPoint[n] + (tDelta >> 8));
                            }
                        }
                        animPosX[4] = animPosX[4] + (tDelta >> 8);
                        animPosX[5] = animPosX[5] + (tDelta >> 8);
                        animPosX[6] = animPosX[6] + (tDelta >> 8);
                        i2 = 2;
                        while (i2 <= 5) {
                            int n = i2++;
                            GameAppState.level.sectorEdgeTop[16].xPoint[n] = (short)(GameAppState.level.sectorEdgeTop[16].xPoint[n] + (tDelta >> 8));
                        }
                        if (GameAppState.hero.currentSector >= 18 && GameAppState.hero.currentSector <= 22 && !hero.inAir()) {
                            GameAppState.hero.fp_heroX += tDelta >> 8 << 8;
                            if (GameAppState.hero.currentSector == 18 || GameAppState.hero.currentSector == 19) {
                                GameAppState.hero.fp_heroX += tDelta >> 8 << 8;
                            }
                        }
                    }
                    if (levelNumber == 6) {
                        this.time1 += deltaTime;
                        if (this.time1 > PLATFORM_TIME2) {
                            this.time1 = 0;
                            if (++enabledPlatform > LAST_PLATFORM2) {
                                enabledPlatform = FIRST_PLATFORM2;
                            }
                            if (++enabledPlatform1 > LAST_PLATFORM1) {
                                enabledPlatform1 = FIRST_PLATFORM1;
                            }
                        }
                        this.time2 += deltaTime;
                        if (weaponsCount == 0 && this.time2 > 1500) {
                            this.time2 = 0;
                            GameAppState.addBullet(this.flamesX[this.currentFlame], this.flamesY[this.currentFlame], 0, 0, this.flamesEndY[this.currentFlame], 9);
                            ++this.currentFlame;
                            if (this.currentFlame >= this.flamesX.length) {
                                this.currentFlame = 0;
                            }
                        }
                    }
                    if (levelNumber == 7) {
                        if (weaponsCount == 0) {
                            GameAppState.addBullet(this.spikesX[this.currentSpike], this.spikeY, 0, -84480, this.spikeY + 1, 8);
                            ++this.currentSpike;
                            if (this.currentSpike >= this.spikesX.length) {
                                this.currentSpike = 0;
                            }
                        }
                        this.time1 += deltaTime;
                        if (this.time1 > 2000) {
                            this.time1 = 0;
                            if (GameAppState.level.currentRegion == 1 && this.hiddenTiles1 < 24) {
                                this.hiddenTiles1 = (byte)(this.hiddenTiles1 + 1);
                                GameAppState.level.sectorEdgeTop[5].movePoint(0, 8);
                                GameAppState.level.sectorEdgeTop[5].movePoint(1, 8);
                            }
                            if (GameAppState.level.currentRegion == 3 && this.hiddenTiles2 < 24) {
                                this.hiddenTiles2 = (byte)(this.hiddenTiles2 + 1);
                                GameAppState.level.sectorEdgeTop[19].movePoint(0, 8);
                                GameAppState.level.sectorEdgeTop[19].movePoint(1, 8);
                            }
                        }
                        this.time2 += deltaTime;
                        if (this.time2 < 1000 || this.time2 > 5000) {
                            animations[0].setState((byte)0);
                            animations[3].setState((byte)2);
                        } else {
                            animations[0].setState((byte)2);
                            animations[3].setState((byte)0);
                        }
                        if (this.time2 > 1000 && this.time2 < 3000) {
                            animations[1].setState((byte)0);
                        } else {
                            animations[1].setState((byte)2);
                        }
                        if (this.time2 > 3000 && this.time2 < 5500) {
                            animations[2].setState((byte)0);
                        } else {
                            animations[2].setState((byte)2);
                        }
                        if (this.time2 > 0 && this.time2 < 4000) {
                            animations[4].setState((byte)0);
                        } else {
                            animations[4].setState((byte)2);
                        }
                        if (this.time2 > 6000) {
                            this.time2 = 0;
                        }
                    }
                    if (levelNumber == 8 && GameAppState.hero.currentSector == 4 && GameAppState.level.currentRegion != GameAppState.hero.currentRegionY) {
                        ++cameraY;
                    }
                    if (levelNumber == 1 && GameAppState.hero.currentSector == 7 && GameAppState.level.currentRegion != GameAppState.hero.currentRegionY) {
                        --cameraY;
                    }
                    GameAppState.checkCameraPosition();
                    level.update(deltaTime);
                    if (handTime < 0) {
                        handTime = 0;
                        handDirection = (byte)-1;
                    } else {
                        handTime -= deltaTime;
                    }
                    tiledLayer.setLayerPosition(GameAppState.scaleValue(cameraX), GameAppState.scaleValue(cameraY));
                }
            } else if (splash == null || this.levelLoading) {
                if (hero != null) {
                    hero = null;
                }
                if (this.menuState == 16) {
                    if (this.time1 == 1) {
                        this.menuRepaintRequested = true;
                        if (this.currentLogo == 0) {
                            this.currentLogo = (byte)(this.currentLogo + 1);
                            this.logoImage = null;
                            this.time1 = -15;
                        } else if (this.currentLogo == 1) {
                            this.currentLogo = (byte)(this.currentLogo + 1);
                            this.logoImage = null;
                            this.time1 = -15;
                        } else {
                            init = true;
                            enemyImage = new TilesImage[Hero.enemyTypesTable.length];
                            for (int i = 0; i < Hero.enemyTypesTable.length; ++i) {
                                Hero her = new Hero(0, 0, 0, null, Hero.enemyTypesTable[i], 0);
                                byte[] b = new byte[1];
                                GameAppState.enemyImage[i] = new TilesImage(new DataInputStream(b.getClass().getResourceAsStream(her.heroImage)));
                                her = null;
                            }
                            this.clearGameData();
                            this.loadLevel(20);
                            paused = false;
                            GameAppState.hero.lives = (byte)100;
                            Image img = Image.createImage((int)176, (int)208);
                            Graphics g = img.getGraphics();
                            for (int n = 0; n < 1; ++n) {
                                int i;
                                for (i = 0; i < 100; ++i) {
                                    MainGameCanvas.lastTime = 0L;
                                    MainGameCanvas.currentTime = 100L;
                                    try {
                                        int id = random.nextInt() % 9;
                                        if (id < 0) {
                                            id = -id;
                                        }
                                        GameAppState.czasKlawisza[id] = 100;
                                        this.update(100);
                                        continue;
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                Thread.yield();
                                for (i = 0; i < 49; ++i) {
                                    if (i == 8) continue;
                                    try {
                                        heros[0].paint(g);
                                        continue;
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                }
                                for (i = 1; i <= ileWrogow; ++i) {
                                    GameAppState.removeEnemy(GameAppState.heros[i].id);
                                    --i;
                                }
                            }
                            g = null;
                            img = null;
                            this.clearGameData();
                            init = false;
                            MainGameCanvas.lastTime = -1L;
                            MainGameCanvas.currentTime = -1L;
                            hero = null;
                            this.menuState = this.firstStart ? 15 : 8;
                            this.time1 = -1;
                        }
                    }
                    ++this.time1;
                }
            }
            if (fadingEnabled && (splash == null || !GameAppState.splash.loadingMode)) {
                this.onFadedOut();
                fadingEnabled = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void preloadLevel(int number) {
    }

    public void render(Graphics g) {
        block131: {
            try {
                if (level != null && splash == null && !this.levelLoading && !init) {
                    g.setColor(0);
                    if (this.firstFrameAfterLoading) {
                        g.fillRect(0, 0, 176, 208);
                    } else {
                        g.fillRect(0, 0, 176, SCREEN_DELTA_Y + 168);
                    }
                    if (!this.firstFrameAfterLoading) {
                        int i;
                        int i2;
                        g.setClip(0, 0, 176, SCREEN_DELTA_Y + 168);
                        g.translate(0, SCREEN_DELTA_Y);
                        if (drawHeroFirst) {
                            heros[0].paint(g);
                        }
                        tiledLayer.paint(g);
                        if (levelNumber == 5 && GameAppState.level.currentRegion == 5) {
                            g.drawImage(this.tractorImage, GameAppState.scaleValue(tractorStartPosition + (this.tractorOffset >> 8) - cameraX), GameAppState.scaleValue(0 - cameraY), 0);
                        }
                        if (animations != null) {
                            for (i2 = 0; i2 < animations.length; ++i2) {
                                animations[i2].paint(g, animPosX[i2], animPosY[i2], 0);
                            }
                        }
                        if (levelNumber == 3 && doorOpened) {
                            g.drawImage(this.door, GameAppState.scaleValue(177 - cameraX), GameAppState.scaleValue(121 - cameraY), 0);
                        }
                        if (levelNumber == 4) {
                            if (zgniatarkaEnabled) {
                                g.drawImage(this.zgniatarka, GameAppState.scaleValue(537 - cameraX), GameAppState.scaleValue(551 - cameraY), 0);
                                g.drawImage(this.zgniatarka, GameAppState.scaleValue(569 - cameraX), GameAppState.scaleValue(551 - cameraY), 0);
                            } else {
                                g.drawImage(this.zgniatarka, GameAppState.scaleValue(649 - cameraX), GameAppState.scaleValue(551 - cameraY), 0);
                                g.drawImage(this.zgniatarka, GameAppState.scaleValue(745 - cameraX), GameAppState.scaleValue(551 - cameraY), 0);
                            }
                        }
                        if (levelNumber == 5) {
                            if (GameAppState.hero.immortalityTime == 0 && GameAppState.animations[4].frame > 8 && this.currentSteam == 4 && (GameAppState.hero.currentSector == 21 || GameAppState.hero.currentSector == 20) && !hero.inAir() && tractorEnabled) {
                                if (GameAppState.hero.fp_heroX > animPosX[4] << 8) {
                                    if (GameAppState.hero.fp_heroX < animPosX[4] + 40 << 8) {
                                        hero.changeState((byte)16, -1);
                                        GameAppState.hero.life = (short)(GameAppState.hero.life - 4);
                                        GameAppState.hero.flySpeedX = 22528;
                                    }
                                }
                            }
                            if (GameAppState.hero.immortalityTime == 0 && GameAppState.animations[5].frame > 8 && this.currentSteam == 5 && (GameAppState.hero.currentSector == 20 || GameAppState.hero.currentSector == 19) && !hero.inAir() && tractorEnabled) {
                                if (GameAppState.hero.fp_heroX > animPosX[5] << 8) {
                                    if (GameAppState.hero.fp_heroX < animPosX[5] + 40 << 8) {
                                        hero.changeState((byte)16, -1);
                                        GameAppState.hero.life = (short)(GameAppState.hero.life - 4);
                                        GameAppState.hero.flySpeedX = 22528;
                                    }
                                }
                            }
                            if (GameAppState.hero.immortalityTime == 0 && GameAppState.animations[6].frame > 8 && this.currentSteam == 6 && GameAppState.hero.currentSector == 19 && !hero.inAir() && tractorEnabled) {
                                if (GameAppState.hero.fp_heroX > animPosX[6] << 8) {
                                    if (GameAppState.hero.fp_heroX < animPosX[6] + 40 << 8) {
                                        hero.changeState((byte)16, -1);
                                        GameAppState.hero.life = (short)(GameAppState.hero.life - 4);
                                        GameAppState.hero.flySpeedX = 22528;
                                    }
                                }
                            }
                        }
                        if (levelNumber == 2 && GameAppState.hero.currentRegionY >= 3) {
                            g.drawImage(this.heli1, GameAppState.scaleValue((this.fp_heliPosX >> 8) - cameraX), GameAppState.scaleValue(0 - cameraY), 0);
                        }
                        if (levelNumber == 2 && GameAppState.hero.currentRegionY == 4) {
                            if (heli2Flying) {
                                g.drawImage(this.heli2, GameAppState.scaleValue((HELI2_X >> 8) - cameraX + random.nextInt() % 2), GameAppState.scaleValue((fp_heli2PosY >> 8) - cameraY + random.nextInt() % 2), 0);
                            } else {
                                g.drawImage(this.heli2, GameAppState.scaleValue((HELI2_X >> 8) - cameraX), GameAppState.scaleValue((fp_heli2PosY >> 8) - cameraY), 0);
                            }
                        }
                        if (levelNumber == 6) {
                            int next;
                            this.drawPlatform(g, enabledPlatform);
                            if (this.time1 >= PLATFORM_TIME2 - 200) {
                                next = enabledPlatform + 1;
                                if (next > LAST_PLATFORM2) {
                                    next = FIRST_PLATFORM2;
                                }
                                this.drawPlatform(g, next);
                            }
                            this.drawPlatform(g, enabledPlatform1);
                            if (this.time1 >= PLATFORM_TIME2 - 200) {
                                next = enabledPlatform1 + 1;
                                if (next > LAST_PLATFORM1) {
                                    next = FIRST_PLATFORM1;
                                }
                                this.drawPlatform(g, next);
                            }
                        }
                        if (levelNumber == 7 && GameAppState.level.currentRegion == 1) {
                            g.fillRect(GameAppState.scaleValue(266 - cameraX), GameAppState.scaleValue(127 - cameraY), GameAppState.scaleValue(this.hiddenTiles1 * 8), GameAppState.scaleValue(16));
                        }
                        if (levelNumber == 7 && GameAppState.level.currentRegion == 3) {
                            g.fillRect(GameAppState.scaleValue(798 - cameraX), GameAppState.scaleValue(127 - cameraY), GameAppState.scaleValue(this.hiddenTiles2 * 8), GameAppState.scaleValue(16));
                        }
                        for (i2 = 0; i2 < weaponsCount; ++i2) {
                            weapons[i2].paint(g);
                        }
                        if (!drawHeroFirst) {
                            if (ileWrogow == 0) {
                                heros[0].paint(g);
                            } else if (ileWrogow == 1) {
                                if (GameAppState.heros[0].fp_heroY < GameAppState.heros[1].fp_heroY) {
                                    heros[0].paint(g);
                                    heros[1].paint(g);
                                } else {
                                    heros[1].paint(g);
                                    heros[0].paint(g);
                                }
                            } else {
                                int[][] tab = new int[3][2];
                                tab[0][0] = GameAppState.heros[0].fp_heroY;
                                tab[1][0] = GameAppState.heros[1].fp_heroY;
                                tab[2][0] = GameAppState.heros[2].fp_heroY;
                                tab[0][1] = 0;
                                tab[1][1] = 1;
                                tab[2][1] = 2;
                                for (int a = 0; a < 2; a = (int)((byte)(a + 1))) {
                                    for (int b = 0; b < 3 - a - 1; b = (int)((byte)(b + 1))) {
                                        if (tab[a][0] <= tab[a + 1][0]) continue;
                                        int t = tab[a][0];
                                        int t1 = tab[a][1];
                                        tab[a][0] = tab[a + 1][0];
                                        tab[a][1] = tab[a + 1][1];
                                        tab[a + 1][0] = t;
                                        tab[a + 1][1] = t1;
                                    }
                                }
                                for (i = 0; i < 3; i = (int)((byte)(i + 1))) {
                                    if (heros[tab[i][1]] == null) continue;
                                    heros[tab[i][1]].paint(g);
                                }
                            }
                        } else {
                            for (i2 = 1; i2 < heros.length; i2 = (int)((byte)(i2 + 1))) {
                                if (heros[i2] == null) continue;
                                heros[i2].paint(g);
                            }
                        }
                        if (winda != null) {
                            if (!drawHeroFirst) {
                                g.drawImage(platforma, GameAppState.scaleValue(432 - cameraX), GameAppState.scaleValue((GameAppState.hero.fp_heroY >> 8) - cameraY), 0);
                            }
                            g.drawImage(winda, GameAppState.scaleValue(432 - cameraX), GameAppState.scaleValue(249) - GameAppState.scaleValue(cameraY), 0);
                        }
                        if (handDirection != -1 && handTime % 500 > 250) {
                            if (handDirection == 0) {
                                g.drawImage(this.handImage[0], 176 - (this.handImage[0].getWidth() + 3), 84, 0);
                            } else if (handDirection == 1) {
                                g.drawImage(this.handImage[1], 3, 84, 0);
                            } else if (handDirection == 2) {
                                g.drawImage(this.handImage[2], 88, 3, 0);
                            } else if (handDirection == 3) {
                                g.drawImage(this.handImage[3], 88, 168 - (this.handImage[3].getHeight() + 3), 0);
                            }
                        }
                        g.translate(0, -SCREEN_DELTA_Y);
                        g.setColor(0);
                        g.fillRect(0, 0, 176, SCREEN_DELTA_Y);
                        if (GameAppState.hero.score != this.lastScore || GameAppState.hero.life != this.lastLife || this.lastLives != GameAppState.hero.lives) {
                            g.setColor(0, 0, 0);
                            int hudY = SCREEN_DELTA_Y + 168;
                            g.setClip(0, 0, 176, 208);
                            g.fillRect(0, 0, 176, SCREEN_DELTA_Y);
                            g.fillRect(0, hudY, 176, 208 - hudY);
                            g.setClip(0, hudY, 176, 208);
                            g.drawImage(this.hud, SCREEN_DELTA_X, hudY, 0);
                            for (i = 0; i < GameAppState.hero.life / 10; ++i) {
                                SimpleAnimation.paintFrame(g, GameAppState.scaleValue(183), GameAppState.scaleValue(79), GameAppState.scaleValue(6), GameAppState.scaleValue(9), 0, SCREEN_DELTA_X + 4 + i * 7, hudY + 7, 0);
                            }
                            g.fillRect(0, hudY += this.hud.getHeight(), 176, 208 - hudY);
                            if (GameAppState.hero.score > 99999) {
                                GameAppState.hero.score = 99999;
                            }
                            if (GameAppState.hero.score > this.hiScore) {
                                this.hiScore = GameAppState.hero.score;
                            }
                            String hiScoreStr = String.valueOf(this.hiScore);
                            int zeros = 5 - hiScoreStr.length();
                            for (int i3 = 0; i3 < zeros; ++i3) {
                                hiScoreStr = "0" + hiScoreStr;
                            }
                            GameAppState.drawString(hiScoreStr, g, SCREEN_DELTA_X + 126, hudY + 5, 0);
                            String score = String.valueOf(GameAppState.hero.score);
                            zeros = 5 - score.length();
                            for (int i4 = 0; i4 < zeros; ++i4) {
                                score = "0" + score;
                            }
                            GameAppState.drawString(score, g, SCREEN_DELTA_X + 68, hudY + 5, 0);
                            byte lives = GameAppState.hero.lives;
                            if (lives < 0) {
                                lives = 0;
                            }
                            GameAppState.drawString("x" + lives, g, SCREEN_DELTA_X + 28, hudY + 5, 0);
                            currentFont = font_blue;
                            GameAppState.drawString(this.StrScore[language], g, SCREEN_DELTA_X + 86, hudY - 12, 1);
                            GameAppState.drawString(this.StrHiScore[language], g, SCREEN_DELTA_X + 144, hudY - 12, 1);
                            currentFont = font_white;
                            this.lastScore = GameAppState.hero.score;
                            this.lastLife = GameAppState.hero.life;
                            this.lastLives = GameAppState.hero.lives;
                        }
                    }
                    this.firstFrameAfterLoading = false;
                    break block131;
                }
                if (splash != null && !this.levelLoading && !init) {
                    g.setClip(0, 0, 176, 208);
                    g.setColor(0);
                    g.fillRect(0, 0, 176, 208);
                    splash.paint(g);
                } else {
                    g.setClip(0, 0, 176, 208);
                    if (this.menuState == 0) {
                        g.setColor(0);
                        g.fillRect(0, 0, 176, 208);
                    }
                    if (this.menuRepaintRequested || this.menuState == 10) {
                        this.menuRepainted = true;
                        g.setColor(0);
                        g.fillRect(0, 0, 176, 208);
                        if (this.menuState == 1) {
                            this.logoImage = null;
                            this.firstStart = false;
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            g.drawImage(this.menuImage, GameAppState.xPosition(500) - (this.menuImage.getWidth() >> 1), GameAppState.yPosition(20), 0);
                            for (int i = 0; i < this.Menu[language].length; ++i) {
                                currentFont = i == this.selectedMenu ? font_blue : font_white;
                                if (i == 0 && !savedGameExist) {
                                    currentFont = font_gray;
                                }
                                GameAppState.drawString(this.Menu[language][i], g, GameAppState.xPosition(500), GameAppState.yPosition(420 + i * 90), 1);
                            }
                            currentFont = font_white;
                            GameAppState.drawString(this.StrSelect[language], g, GameAppState.xPosition(30), GameAppState.yPosition(950), 0);
                            GameAppState.drawString(this.StrExit[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                        } else if (this.menuState == 2) {
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            for (int i = 0; i < this.Levels.length; ++i) {
                                currentFont = i == this.selectedElement ? font_blue : font_white;
                                GameAppState.drawString(this.Levels[i], g, GameAppState.xPosition(500), 25 + 17 * i, 1);
                            }
                            currentFont = font_white;
                            GameAppState.drawString(this.StrBack[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                            GameAppState.drawString(this.StrSelect[language], g, GameAppState.xPosition(30), GameAppState.yPosition(950), 0);
                        } else if (this.menuState == 3) {
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            g.drawImage(this.menuImage, GameAppState.xPosition(500) - (this.menuImage.getWidth() >> 1), GameAppState.yPosition(20), 0);
                            int menu = 0;
                            int yy = 380;
                            yy += 40;
                            yy += 40;
                            for (int i = 0; i < this.Options[language].length; ++i) {
                                if (i == 1 || i == 3) continue;
                                currentFont = i == this.selectedMenu ? font_blue : font_white;
                                String onoff = "";
                                if (i == 0 && musicEnabled) {
                                    onoff = this.StrOn[language];
                                } else if (i == 0 && !musicEnabled) {
                                    onoff = this.StrOff[language];
                                }
                                if (i == 1 && soundsEnabled) {
                                    onoff = this.StrOn[language];
                                } else if (i == 1 && !soundsEnabled) {
                                    onoff = this.StrOff[language];
                                }
                                if (i == 3 && vibrationsEnabled) {
                                    onoff = this.StrOn[language];
                                } else if (i == 3 && !vibrationsEnabled) {
                                    onoff = this.StrOff[language];
                                }
                                if (i == 4 && this.hiScore == 0) {
                                    currentFont = font_gray;
                                }
                                GameAppState.drawString(this.Options[language][i] + onoff, g, GameAppState.xPosition(500), GameAppState.yPosition(yy + menu * 70), 1);
                                ++menu;
                            }
                            currentFont = font_white;
                            GameAppState.drawString(this.StrBack[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                            GameAppState.drawString(this.StrSelect[language], g, GameAppState.xPosition(30), GameAppState.yPosition(950), 0);
                        } else if (this.menuState == 4) {
                            GameAppState.drawString(this.StrGameOver[language], g, 88, 100, 1);
                        } else if (this.menuState == 5) {
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            g.drawImage(this.menuImage, GameAppState.xPosition(500) - (this.menuImage.getWidth() >> 1), GameAppState.yPosition(20), 0);
                            currentFont = font_white;
                            GameAppState.drawText(this.StrNewgameQuestion[language], g, GameAppState.xPosition(500), GameAppState.yPosition(500), GameAppState.xPosition(909), GameAppState.yPosition(54), 1);
                            GameAppState.drawString(this.StrNo[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                            GameAppState.drawString(this.StrYes[language], g, GameAppState.xPosition(30), GameAppState.yPosition(950), 0);
                        } else if (this.menuState == 6) {
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            g.drawImage(this.menuImage, GameAppState.xPosition(500) - (this.menuImage.getWidth() >> 1), GameAppState.yPosition(20), 0);
                            currentFont = font_white;
                            GameAppState.drawText(this.StrHiscoreQuestion[language], g, GameAppState.xPosition(500), GameAppState.yPosition(500), GameAppState.xPosition(909), GameAppState.yPosition(54), 1);
                            GameAppState.drawString(this.StrNo[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                            GameAppState.drawString(this.StrYes[language], g, GameAppState.xPosition(30), GameAppState.yPosition(950), 0);
                        } else if (this.menuState == 7) {
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            currentFont = font_white;
                            int y = 25;
                            for (int i = 0; i < this.Controls[language].length; ++i) {
                                currentFont = i == this.selectedMenu ? font_blue : font_white;
                                GameAppState.drawString(this.Controls[language][i], g, GameAppState.xPosition(75), GameAppState.yPosition(125 + i * 90), 0);
                                if (i == this.selectedMenu && this.editingKey) {
                                    GameAppState.drawString("-", g, GameAppState.xPosition(850), GameAppState.yPosition(125 + i * 90), 3);
                                    continue;
                                }
                                String k = GameAppState.getKeyString(this.tmpKeys[i]);
                                GameAppState.drawString(k, g, GameAppState.xPosition(850) - (k.length() - 1) * 8, GameAppState.yPosition(125 + i * 90), 3);
                            }
                            currentFont = font_white;
                            GameAppState.drawString(this.StrBack[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                            if (this.editingKey) {
                                currentFont = font_gray;
                            }
                            GameAppState.drawString(this.StrChange[language], g, GameAppState.xPosition(30), GameAppState.yPosition(950), 0);
                        } else if (this.menuState == 8) {
                            currentFont = font_white;
                            GameAppState.drawText(this.StrMusicQuestion[language], g, GameAppState.xPosition(500), GameAppState.yPosition(450), GameAppState.xPosition(909), GameAppState.yPosition(54), 1);
                            GameAppState.drawString(this.StrNo[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                            GameAppState.drawString(this.StrYes[language], g, GameAppState.xPosition(30), GameAppState.yPosition(950), 0);
                        } else if (this.menuState == 9) {
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            currentFont = font_white;
                            String leftAttack = GameAppState.getKeyString(keyCodes[5]);
                            String rightAttack = GameAppState.getKeyString(keyCodes[4]);
                            String jumpAttack1 = GameAppState.getKeyString(keyCodes[6]);
                            String jumptAttack2 = GameAppState.getKeyString(keyCodes[7]);
                            GameAppState.drawScrollingText(this.AboutString[language], g, GameAppState.xPosition(500), GameAppState.yPosition(100), GameAppState.xPosition(770), GameAppState.yPosition(62), 1, GameAppState.yPosition(700), this.helpScroll, true);
                            GameAppState.drawString(this.StrBack[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                        } else if (this.menuState == 10) {
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            g.drawImage(this.menuImage, GameAppState.xPosition(500) - (this.menuImage.getWidth() >> 1), GameAppState.yPosition(20), 0);
                            currentFont = font_white;
                            GameAppState.drawScrollingText(this.creditsString, g, GameAppState.xPosition(500), GameAppState.yPosition(430), GameAppState.xPosition(909), GameAppState.yPosition(54), 1, GameAppState.yPosition(350), this.credistScrollValue, false);
                            ++this.credistScrollValue;
                            if (this.credistScrollValue > GameAppState.yPosition(54) * 28) {
                                this.credistScrollValue = -GameAppState.yPosition(400);
                            }
                            GameAppState.drawString(this.StrBack[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                        } else if (this.menuState == 11) {
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            g.drawImage(this.menuImage, GameAppState.xPosition(500) - (this.menuImage.getWidth() >> 1), GameAppState.yPosition(20), 0);
                            g.drawRegion(this.volumeImage, 0, this.volumeImage.getHeight() / 2, this.volumeImage.getWidth(), this.volumeImage.getHeight() / 2, 0, (176 - this.volumeImage.getWidth()) / 2, GameAppState.yPosition(572), 0);
                            if (musicEnabled) {
                                g.drawRegion(this.volumeImage, 0, 0, this.volumeImage.getWidth() * Music.getVolume() / 100, this.volumeImage.getHeight() / 2, 0, (176 - this.volumeImage.getWidth()) / 2, GameAppState.yPosition(572), 0);
                            }
                            currentFont = font_white;
                            GameAppState.drawString(this.StrVolume[language], g, GameAppState.xPosition(500), GameAppState.yPosition(454), 1);
                            GameAppState.drawString(this.StrBack[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                        } else if (this.menuState == 12) {
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            g.drawImage(this.menuImage, GameAppState.xPosition(500) - (this.menuImage.getWidth() >> 1), GameAppState.yPosition(20), 0);
                            for (int i = 0; i < this.Difficulties[language].length; ++i) {
                                currentFont = i == this.selectedMenu ? font_blue : font_white;
                                if (i > difficultiesPlayed) {
                                    currentFont = font_gray;
                                }
                                GameAppState.drawString(this.Difficulties[language][i], g, GameAppState.xPosition(500), GameAppState.yPosition(500 + i * 90), 1);
                            }
                            currentFont = font_white;
                            GameAppState.drawString(this.StrBack[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                            GameAppState.drawString(this.StrSelect[language], g, GameAppState.xPosition(30), GameAppState.yPosition(950), 0);
                        } else if (this.menuState == 13) {
                            g.drawImage(this.menuBackground, 0, 0, 0);
                            currentFont = font_white;
                            GameAppState.drawText(this.StrExitQuestion[language], g, GameAppState.xPosition(500), GameAppState.yPosition(450), GameAppState.xPosition(909), GameAppState.yPosition(54), 1);
                            GameAppState.drawString(this.StrNo[language], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                            GameAppState.drawString(this.StrYes[language], g, GameAppState.xPosition(30), GameAppState.yPosition(950), 0);
                        } else if (this.menuState == 14) {
                            GameAppState.drawString(StrLoading[language], g, GameAppState.xPosition(500), GameAppState.yPosition(500), 1);
                            if (!this.loadGameRequested) {
                                this.loadGameRequested = true;
                                GameAppState.fadeOutIn();
                            }
                        } else if (this.menuState == 15) {
                            currentFont = font_white;
                            if (this.menuBackground != null) {
                                g.drawImage(this.menuBackground, 0, 0, 0);
                            }
                            if (this.menuImage != null) {
                                g.drawImage(this.menuImage, GameAppState.xPosition(500) - (this.menuImage.getWidth() >> 1), GameAppState.yPosition(20), 0);
                            }
                            GameAppState.drawString(this.StrSelect[this.selectedMenu], g, GameAppState.xPosition(30), GameAppState.yPosition(950), 0);
                            if (!this.firstStart) {
                                GameAppState.drawString(this.StrBack[this.selectedMenu], g, GameAppState.xPosition(970), GameAppState.yPosition(950), 2);
                            }
                            for (int i = 0; i < this.Languages.length; ++i) {
                                currentFont = i == this.selectedMenu ? font_blue : font_white;
                                GameAppState.drawString(this.Languages[i], g, GameAppState.xPosition(500), GameAppState.yPosition(400 + 70 * i), 1);
                            }
                        } else if (this.menuState == 16) {
                            g.setColor(0xFFFFFF);
                            g.fillRect(0, 0, 176, 208);
                            if (this.currentLogo != 2) {
                                if (this.logoImage == null) {
                                    this.logoImage = Image.createImage((String)"/qg.png");
                                }
                                g.drawImage(this.logoImage, 88 - (this.logoImage.getWidth() >> 1), 104 - (this.logoImage.getHeight() >> 1), 0);
                            }
                            if (this.currentLogo == 2) {
                                g.setColor(0);
                                g.fillRect(0, 0, 176, 208);
                                if (font_white == null) {
                                    font_white = Image.createImage((String)"/font.png");
                                }
                                currentFont = font_white;
                                GameAppState.drawString(StrLoading[this.selectedMenu], g, GameAppState.xPosition(500), GameAppState.yPosition(500), 1);
                            }
                        }
                    }
                    if (this.menuRepainted) {
                        this.menuRepaintRequested = false;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void keyPressed(int keyCode) {
        try {
            if (fadingEnabled) return;
            if (level != null && splash == null && !this.levelLoading && !init) {
                if (keyCode == -7) {
                    menuIdRequested = (byte)101;
                    GameAppState.fadeOutIn();
                }
                GameAppState.keyPressedKlawisze(keyCode);
                return;
            }
            if (splash != null && !this.levelLoading) {
                if (keyCode != -6 && keyCode != -5) return;
                splashScreenHideRequested = true;
                GameAppState.fadeOutIn();
                return;
            }
            this.menuRepaintRequested = true;
            this.menuRepainted = false;
            if (this.menuState == 0) {
                if (keyCode != -5) return;
                ++this.menuState;
                if (!savedGameExist) {
                    this.selectedMenu = 1;
                }
                this.anim = null;
                SimpleAnimation.initialize("/anims.png");
                return;
            }
            if (this.menuState == 1) {
                if (MainGameCanvas.keyDown(keyCode) && this.selectedMenu < this.Menu[language].length - 1) {
                    ++this.selectedMenu;
                }
                if (MainGameCanvas.keyUp(keyCode) && this.selectedMenu > 0) {
                    --this.selectedMenu;
                    if (!savedGameExist && this.selectedMenu == 0) {
                        this.selectedMenu = 1;
                    }
                }
                if ((keyCode == -6 || keyCode == -5) && this.selectedMenu == 0) {
                    this.loadGameRequested = true;
                    GameAppState.fadeOutIn();
                }
                if ((keyCode == -6 || MainGameCanvas.keyFire(keyCode)) && this.selectedMenu == 1) {
                    menuIdRequested = !savedGameExist ? (byte)12 : (byte)5;
                    GameAppState.fadeOutIn();
                }
                if ((keyCode == -6 || MainGameCanvas.keyFire(keyCode)) && this.selectedMenu == 2) {
                    menuIdRequested = (byte)3;
                    GameAppState.fadeOutIn();
                }
                if ((keyCode == -6 || MainGameCanvas.keyFire(keyCode)) && this.selectedMenu == 3) {
                    menuIdRequested = (byte)9;
                    this.helpScroll = 0;
                    GameAppState.fadeOutIn();
                }
                if ((keyCode == -6 || MainGameCanvas.keyFire(keyCode)) && this.selectedMenu == 4) {
                    menuIdRequested = (byte)10;
                    GameAppState.fadeOutIn();
                }
                if (keyCode != -7) return;
                menuIdRequested = (byte)13;
                GameAppState.fadeOutIn();
                return;
            }
            if (this.menuState == 2) {
                if (MainGameCanvas.keyDown(keyCode) && this.selectedElement < this.Levels.length - 1) {
                    ++this.selectedElement;
                }
                if (MainGameCanvas.keyUp(keyCode) && this.selectedElement > 0) {
                    --this.selectedElement;
                }
                if (keyCode == -6 || MainGameCanvas.keyFire(keyCode)) {
                    levelRequested = (byte)(this.selectedElement + 1);
                    if (levelRequested == 9) {
                        levelRequested = (byte)10;
                    }
                    GameAppState.fadeOutIn();
                }
                if (keyCode != -7) return;
                menuIdRequested = 1;
                GameAppState.fadeOutIn();
                return;
            }
            if (this.menuState == 3) {
                if (MainGameCanvas.keyDown(keyCode) && this.selectedMenu < this.Options[language].length - 1) {
                    ++this.selectedMenu;
                    if (this.selectedMenu == 1) {
                        ++this.selectedMenu;
                    }
                    if (this.selectedMenu == 3) {
                        ++this.selectedMenu;
                    }
                    if (this.selectedMenu == 4 && this.hiScore == 0) {
                        this.selectedMenu = 5;
                    }
                }
                if (MainGameCanvas.keyUp(keyCode) && this.selectedMenu > 0) {
                    --this.selectedMenu;
                    if (this.selectedMenu == 4 && this.hiScore == 0) {
                        this.selectedMenu = 3;
                    }
                    if (this.selectedMenu == 3) {
                        --this.selectedMenu;
                    }
                    if (this.selectedMenu == 1) {
                        --this.selectedMenu;
                    }
                }
                if (keyCode == -6 || MainGameCanvas.keyFire(keyCode)) {
                    switch (this.selectedMenu) {
                        case 0: {
                            boolean bl = musicEnabled = !musicEnabled;
                            if (musicEnabled) {
                                GameAppState.changeMusic("/sfx/title.mid", 1);
                            } else {
                                GameAppState.changeMusic(null, -1);
                            }
                            if (lastVolume != -1) break;
                            break;
                        }
                        case 1: {
                            soundsEnabled = !soundsEnabled;
                            break;
                        }
                        case 2: {
                            menuIdRequested = (byte)11;
                            GameAppState.fadeOutIn();
                            break;
                        }
                        case 3: {
                            vibrationsEnabled = !vibrationsEnabled;
                            break;
                        }
                        case 4: {
                            menuIdRequested = (byte)6;
                            GameAppState.fadeOutIn();
                            break;
                        }
                        case 5: {
                            menuIdRequested = (byte)7;
                            this.tmpKeys = new byte[9];
                            for (int i = 0; i < 9; ++i) {
                                this.tmpKeys[i] = keyCodes[i];
                            }
                            this.editingKey = false;
                            this.canSaveKeys = true;
                            GameAppState.fadeOutIn();
                            break;
                        }
                        case 6: {
                            menuIdRequested = (byte)15;
                            GameAppState.fadeOutIn();
                        }
                    }
                }
                if (keyCode != -7) return;
                menuIdRequested = 1;
                GameAppState.fadeOutIn();
                return;
            }
            if (this.menuState == 4) {
                if (!MainGameCanvas.keyFire(keyCode)) return;
                GameAppState.changeMusic("/sfx/title.mid", 1);
                menuIdRequested = 1;
                savedGameExist = false;
                GameAppState.fadeOutIn();
                return;
            }
            if (this.menuState == 5) {
                if (keyCode == -7) {
                    menuIdRequested = 1;
                    GameAppState.fadeOutIn();
                }
                if (keyCode != -6 && !MainGameCanvas.keyFire(keyCode)) return;
                menuIdRequested = (byte)12;
                GameAppState.fadeOutIn();
                return;
            }
            if (this.menuState == 6) {
                if (keyCode == -7) {
                    menuIdRequested = (byte)3;
                    GameAppState.fadeOutIn();
                }
                if (keyCode != -6 && !MainGameCanvas.keyFire(keyCode)) return;
                this.hiScore = 0;
                this.saveScores();
                menuIdRequested = (byte)3;
                GameAppState.fadeOutIn();
                return;
            }
            if (this.menuState == 7) {
                if (MainGameCanvas.keyDown(keyCode) && this.selectedMenu < this.Controls[language].length - 1 && !this.editingKey) {
                    ++this.selectedMenu;
                }
                if (MainGameCanvas.keyUp(keyCode) && this.selectedMenu > 0 && !this.editingKey) {
                    --this.selectedMenu;
                }
                if (keyCode == -7) {
                    if (this.canSaveKeys && !this.editingKey) {
                        GameAppState.setKeyCodes(this.tmpKeys);
                        menuIdRequested = (byte)3;
                        GameAppState.fadeOutIn();
                        return;
                    } else {
                        menuIdRequested = (byte)3;
                        GameAppState.fadeOutIn();
                    }
                    return;
                } else if ((keyCode == -6 || MainGameCanvas.keyFire(keyCode)) && !this.editingKey) {
                    this.editingKey = true;
                    return;
                } else {
                    if (!this.editingKey || GameAppState.getKeyString(keyCode).compareTo("??") == 0) return;
                    this.tmpKeys[this.selectedMenu] = (byte)keyCode;
                    this.canSaveKeys = true;
                    for (int i = 0; i < this.tmpKeys.length; ++i) {
                        if (this.tmpKeys[i] == this.tmpKeys[this.selectedMenu] && i != this.selectedMenu) {
                            this.tmpKeys[i] = -100;
                        }
                        if (this.tmpKeys[i] != -100) continue;
                        this.canSaveKeys = false;
                    }
                    this.editingKey = false;
                }
                return;
            }
            if (this.menuState == 8) {
                if (keyCode == -7) {
                    musicEnabled = false;
                    menuIdRequested = 1;
                    GameAppState.fadeOutIn();
                }
                if (keyCode != -6 && !MainGameCanvas.keyFire(keyCode)) return;
                musicEnabled = true;
                GameAppState.changeMusic("/sfx/title.mid", 1);
                if (lastVolume == -1) {
                    Music.setVolume(100);
                }
                menuIdRequested = 1;
                GameAppState.fadeOutIn();
                return;
            }
            if (this.menuState == 9) {
                if (MainGameCanvas.keyDown(keyCode) && !maxScroll) {
                    this.helpScroll += GameAppState.yPosition(62);
                }
                if (MainGameCanvas.keyUp(keyCode) && this.helpScroll > 0) {
                    this.helpScroll -= GameAppState.yPosition(62);
                }
                if (keyCode != -7) return;
                menuIdRequested = 1;
                GameAppState.fadeOutIn();
                return;
            }
            if (this.menuState == 10) {
                if (keyCode != -7) return;
                menuIdRequested = 1;
                GameAppState.fadeOutIn();
                return;
            }
            if (this.menuState == 11) {
                if (keyCode == -7) {
                    menuIdRequested = (byte)3;
                    GameAppState.fadeOutIn();
                    return;
                } else if (keyCode == -3 || keyCode == 52) {
                    if (!musicEnabled) return;
                    int newVol = Music.getVolume() - 10;
                    if (newVol < 0) {
                        newVol = 0;
                    }
                    Music.setVolume(newVol);
                    lastVolume = newVol;
                    return;
                } else {
                    if (keyCode != -4 && keyCode != 54 || !musicEnabled) return;
                    int newVol = Music.getVolume() + 10;
                    if (newVol > 99) {
                        newVol = 99;
                    }
                    Music.setVolume(newVol);
                    lastVolume = newVol;
                }
                return;
            }
            if (this.menuState == 12) {
                if (MainGameCanvas.keyDown(keyCode) && this.selectedMenu < difficultiesPlayed) {
                    ++this.selectedMenu;
                }
                if (MainGameCanvas.keyUp(keyCode) && this.selectedMenu > 0) {
                    --this.selectedMenu;
                }
                if (keyCode == -6 || MainGameCanvas.keyFire(keyCode)) {
                    difficulty = (byte)this.selectedMenu;
                    menuIdRequested = (byte)2;
                    GameAppState.fadeOutIn();
                }
                if (keyCode != -7) return;
                menuIdRequested = 1;
                GameAppState.fadeOutIn();
                return;
            }
            if (this.menuState == 13) {
                if (keyCode == -7) {
                    menuIdRequested = 1;
                    GameAppState.fadeOutIn();
                }
                if (keyCode != -6 && !MainGameCanvas.keyFire(keyCode)) return;
                try {
                    MIDletTemplate.midlet.destroyApp(true);
                    return;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
            if (this.menuState == 15) {
                if (MainGameCanvas.keyDown(keyCode) && this.selectedMenu < this.Languages.length - 1) {
                    ++this.selectedMenu;
                }
                if (MainGameCanvas.keyUp(keyCode) && this.selectedMenu > 0) {
                    --this.selectedMenu;
                }
                if (keyCode == -7 && !this.firstStart) {
                    menuIdRequested = (byte)3;
                    GameAppState.fadeOutIn();
                    return;
                } else {
                    if (keyCode != -6 && !MainGameCanvas.keyFire(keyCode)) return;
                    language = (byte)this.selectedMenu;
                    this.createCreditsString();
                    menuIdRequested = this.firstStart ? (byte)8 : (byte)3;
                    GameAppState.fadeOutIn();
                }
                return;
            }
            if (this.menuState != 16) return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void keyReleased(int keyCode) {
        if (level != null && !this.levelLoading) {
            GameAppState.keyReleasedKlawisze(keyCode);
        }
    }

    public static void addEnemy(int x, int y, int sektor, int levelNumber, int typeOfEnemy, int weapon) {
        EnemyParameters params;
        ileWrogow = (byte)(ileWrogow + 1);
        GameAppState.heros[GameAppState.ileWrogow] = new Hero(x, y, sektor, level, typeOfEnemy, ileWrogow);
        if (currentEnemyImageId != GameAppState.heros[GameAppState.ileWrogow].enemyType || currentEnemyImage == null) {
            try {
                for (int i = 0; i < Hero.enemyTypesTable.length; ++i) {
                    if (Hero.enemyTypesTable[i] != typeOfEnemy) continue;
                    currentEnemyImage = enemyImage[i];
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            currentEnemyImageId = GameAppState.heros[GameAppState.ileWrogow].enemyType;
        }
        if ((params = level.findEnemyParameters(typeOfEnemy)) != null) {
            GameAppState.heros[GameAppState.ileWrogow].damage = params.damage;
            GameAppState.heros[GameAppState.ileWrogow].life = params.startingLife;
            if (difficulty == 2) {
                GameAppState.heros[GameAppState.ileWrogow].life = (short)(GameAppState.heros[GameAppState.ileWrogow].life * 2);
            }
        }
        if (weapon > 0) {
            heros[ileWrogow].addWeapon(new Weapon(weapon));
        }
    }

    public static void removeEnemy(int idd) {
        heros[idd].clear();
        GameAppState.heros[idd] = null;
        if (idd != ileWrogow && ileWrogow != 0 && idd != 0) {
            GameAppState.heros[idd] = heros[ileWrogow];
            GameAppState.heros[GameAppState.ileWrogow] = null;
            GameAppState.heros[idd].id = idd;
        }
        ileWrogow = (byte)(ileWrogow - 1);
    }

    public static void showHand(byte dir) {
        handTime = 3000;
        handDirection = dir;
    }

    public boolean loadSplashAndLevel(int number) {
        levelRequested = (byte)number;
        try {
            if (number >= 1 && number <= 8) {
                this.onMenuLoad();
                splash = new SplashScreen(new DataInputStream(this.getClass().getResourceAsStream("/level" + number + ".splash")));
            } else if (number == 10) {
                this.onMenuLoad();
                splash = new SplashScreen(new DataInputStream(this.getClass().getResourceAsStream("/level9.splash")));
            } else if (number == 11) {
                this.onMenuLoad();
                splash = new SplashScreen(new DataInputStream(this.getClass().getResourceAsStream("/level9c.splash")));
            } else {
                return false;
            }
            level = null;
            GameAppState.changeMusic("/sfx/splash.mid", 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public void loadLevel(int number) {
        handTime = 0;
        this.levelLoading = true;
        this.firstFrameAfterLoading = true;
        this.onGameLoad();
        String music = "/sfx/st1.mid";
        try {
            String map = "/map" + number + ".dd2.lev";
            String tiles = "/map" + number + ".dd2.tiles.png";
            String levelDesc = "/level" + number + ".dd2.lev.desc";
            String levelRegion = "/level" + number + ".region";
            boolean useLayerImage = true;
            levelNumber = number;
            tiledLayer = new TiledLayer(new DataInputStream(this.getClass().getResourceAsStream(map)), useLayerImage, 176, 168);
            tiledLayer.setTileImage(Image.createImage((String)tiles));
            level = new Level(tiledLayer, new DataInputStream(this.getClass().getResourceAsStream(levelDesc)), new DataInputStream(this.getClass().getResourceAsStream(levelRegion)));
            hero = null;
            GameAppState.heros[0] = hero = new Hero(GameAppState.level.heroStartX, GameAppState.level.heroStartY, GameAppState.level.heroStartSector, level, 0, 0);
            ileWrogow = 0;
            GameAppState.setCameraStartPosition(this.beginHeroPositionX, this.beginHeroPositionY);
            this.time1 = 0;
            this.time2 = 0;
            if (levelNumber == 1) {
                animations = new SimpleAnimation[2];
                GameAppState.animations[0] = new SimpleAnimation(6, 0);
                animations[0].setState((byte)2);
                GameAppState.animations[1] = new SimpleAnimation(6, 0);
                animations[1].setState((byte)2);
                animPosX = new int[2];
                GameAppState.animPosX[0] = 634;
                GameAppState.animPosX[1] = 826;
                animPosY = new int[2];
                GameAppState.animPosY[0] = 345;
                GameAppState.animPosY[1] = 329;
                music = "/sfx/st1.mid";
            }
            if (levelNumber == 2) {
                this.bulletSpeedY = (byte)GameAppState.scaleValue(64);
                this.heli1 = Image.createImage((String)"/heli1.png");
                this.fp_heliPosX = HELI1_STARTX;
                heliEnabled = true;
                heliShooting = false;
                this.bulletsShot = 0;
                this.heli2 = Image.createImage((String)"/heli2.png");
                fp_heli2PosY = HELI2_STARTY;
                heli2Flying = false;
                music = "/sfx/st2.mid";
                cameraX += GameAppState.scaleValue(200);
            }
            if (levelNumber == 3) {
                this.door = Image.createImage((String)"/heli_door.png");
                music = "/sfx/st3.mid";
            }
            doorOpened = false;
            if (levelNumber == 4) {
                this.zgniatarka = Image.createImage((String)"/zgniatarka.png");
                zgniatarkaEnabled = false;
                windaActive = false;
                animations = new SimpleAnimation[9];
                GameAppState.animations[0] = new SimpleAnimation(9, 0);
                GameAppState.animations[1] = new SimpleAnimation(9, 0);
                GameAppState.animations[2] = new SimpleAnimation(9, 0);
                GameAppState.animations[3] = new SimpleAnimation(9, 0);
                GameAppState.animations[4] = new SimpleAnimation(9, 0);
                GameAppState.animations[5] = new SimpleAnimation(18, 0);
                GameAppState.animations[6] = new SimpleAnimation(19, 0);
                GameAppState.animations[7] = new SimpleAnimation(19, 0);
                GameAppState.animations[8] = new SimpleAnimation(18, 0);
                animations[4].setToEnd();
                animations[0].setState((byte)2);
                animations[1].setState((byte)2);
                animations[2].setState((byte)2);
                animations[3].setState((byte)2);
                animations[4].setState((byte)2);
                animPosX = new int[9];
                GameAppState.animPosX[0] = 440;
                GameAppState.animPosX[1] = 440;
                GameAppState.animPosX[2] = 968;
                GameAppState.animPosX[3] = 1216;
                GameAppState.animPosX[4] = 1056;
                GameAppState.animPosX[5] = 1168;
                GameAppState.animPosX[6] = 1168;
                GameAppState.animPosX[7] = 1056;
                GameAppState.animPosX[8] = 1056;
                animPosY = new int[9];
                GameAppState.animPosY[0] = 81;
                GameAppState.animPosY[1] = 561;
                GameAppState.animPosY[2] = 561;
                GameAppState.animPosY[3] = 497;
                GameAppState.animPosY[4] = 497;
                GameAppState.animPosY[5] = 554;
                GameAppState.animPosY[6] = 570;
                GameAppState.animPosY[7] = 554;
                GameAppState.animPosY[8] = 570;
                music = "/sfx/st4.mid";
            }
            if (levelNumber == 5) {
                int i;
                animations = new SimpleAnimation[8];
                GameAppState.animations[0] = new SimpleAnimation(7, 0);
                animations[0].setState((byte)2);
                GameAppState.animations[1] = new SimpleAnimation(24, 0);
                GameAppState.animations[2] = new SimpleAnimation(24, 0);
                GameAppState.animations[3] = new SimpleAnimation(25, 0);
                GameAppState.animations[4] = new SimpleAnimation(26, 0);
                GameAppState.animations[5] = new SimpleAnimation(26, 0);
                GameAppState.animations[6] = new SimpleAnimation(26, 0);
                GameAppState.animations[7] = new SimpleAnimation(28, 1);
                GameAppState.animations[7].visible = false;
                animations[4].setState((byte)2);
                animations[5].setState((byte)2);
                animations[6].setState((byte)2);
                animPosX = new int[8];
                GameAppState.animPosX[0] = 554;
                GameAppState.animPosX[1] = 448;
                GameAppState.animPosX[2] = 448;
                GameAppState.animPosX[3] = 448;
                GameAppState.animPosX[4] = tractorStartPosition + (this.tractorOffset >> 8) + 111;
                GameAppState.animPosX[5] = tractorStartPosition + (this.tractorOffset >> 8) + 120;
                GameAppState.animPosX[6] = tractorStartPosition + (this.tractorOffset >> 8) + 152;
                animPosY = new int[8];
                GameAppState.animPosY[0] = 41;
                GameAppState.animPosY[1] = 200;
                GameAppState.animPosY[2] = 248;
                GameAppState.animPosY[3] = 280;
                GameAppState.animPosY[4] = 72;
                GameAppState.animPosY[5] = 87;
                GameAppState.animPosY[6] = 103;
                this.currentSteam = (byte)4;
                for (i = 18; i <= 22; ++i) {
                    int j = 0;
                    while (j < GameAppState.level.sectorEdgeTop[i].pointsNumber) {
                        int n = j++;
                        GameAppState.level.sectorEdgeTop[i].xPoint[n] = (short)(GameAppState.level.sectorEdgeTop[i].xPoint[n] + ((this.tractorOffset >> 8) + 40));
                    }
                    j = 0;
                    while (j < GameAppState.level.sectorEdgeBottom[i].pointsNumber) {
                        int n = j++;
                        GameAppState.level.sectorEdgeBottom[i].xPoint[n] = (short)(GameAppState.level.sectorEdgeBottom[i].xPoint[n] + ((this.tractorOffset >> 8) + 40));
                    }
                }
                i = 2;
                while (i <= 5) {
                    int n = i++;
                    GameAppState.level.sectorEdgeTop[16].xPoint[n] = (short)(GameAppState.level.sectorEdgeTop[16].xPoint[n] + ((this.tractorOffset >> 8) + 40));
                }
                this.tractorImage = Image.createImage((String)"/tracktor.png");
                music = "/sfx/st5.mid";
            }
            tractorEnabled = false;
            if (levelNumber == 6) {
                music = "/sfx/st6.mid";
                enabledPlatform = FIRST_PLATFORM2;
                enabledPlatform1 = FIRST_PLATFORM1;
                this.platform_small = Image.createImage((String)"/platforma_mala.png");
                this.platform_large = Image.createImage((String)"/platforma_duza.png");
                this.platform_small_hide = Image.createImage((String)"/platforma_mala_znika.png");
                this.platform_large_hide = Image.createImage((String)"/platforma_duza_znika.png");
                this.currentFlame = 0;
                animations = new SimpleAnimation[5];
                GameAppState.animations[0] = new SimpleAnimation(4, 0);
                GameAppState.animations[1] = new SimpleAnimation(4, 0);
                GameAppState.animations[2] = new SimpleAnimation(4, 0);
                GameAppState.animations[3] = new SimpleAnimation(4, 0);
                GameAppState.animations[4] = new SimpleAnimation(4, 0);
                animPosX = new int[5];
                GameAppState.animPosX[0] = 568;
                GameAppState.animPosX[1] = 648;
                GameAppState.animPosX[2] = 696;
                GameAppState.animPosX[3] = 600;
                GameAppState.animPosX[4] = 632;
                animPosY = new int[5];
                GameAppState.animPosY[0] = 8;
                GameAppState.animPosY[1] = 24;
                GameAppState.animPosY[2] = 24;
                GameAppState.animPosY[3] = -8;
                GameAppState.animPosY[4] = -8;
            }
            if (levelNumber == 7) {
                this.currentSpike = 0;
                animations = new SimpleAnimation[21];
                GameAppState.animations[0] = new SimpleAnimation(2, 0);
                GameAppState.animations[1] = new SimpleAnimation(3, 0);
                GameAppState.animations[2] = new SimpleAnimation(3, 0);
                GameAppState.animations[3] = new SimpleAnimation(3, 0);
                GameAppState.animations[4] = new SimpleAnimation(2, 0);
                GameAppState.animations[5] = new SimpleAnimation(8, 0);
                GameAppState.animations[6] = new SimpleAnimation(8, 0);
                GameAppState.animations[7] = new SimpleAnimation(8, 0);
                GameAppState.animations[8] = new SimpleAnimation(8, 0);
                animations[5].setToEnd();
                animations[7].setToEnd();
                animations[5].setState((byte)2);
                animations[6].setState((byte)2);
                animations[7].setState((byte)2);
                animations[8].setState((byte)2);
                GameAppState.animations[9] = new SimpleAnimation(20, 0);
                GameAppState.animations[10] = new SimpleAnimation(21, 0);
                GameAppState.animations[11] = new SimpleAnimation(21, 0);
                GameAppState.animations[12] = new SimpleAnimation(21, 0);
                GameAppState.animations[13] = new SimpleAnimation(21, 0);
                GameAppState.animations[14] = new SimpleAnimation(22, 0);
                GameAppState.animations[15] = new SimpleAnimation(20, 0);
                GameAppState.animations[16] = new SimpleAnimation(21, 0);
                GameAppState.animations[17] = new SimpleAnimation(21, 0);
                GameAppState.animations[18] = new SimpleAnimation(22, 0);
                animations[15].setState((byte)6);
                animations[16].setState((byte)6);
                animations[17].setState((byte)6);
                animations[18].setState((byte)6);
                GameAppState.animations[19] = new SimpleAnimation(20, 0);
                GameAppState.animations[20] = new SimpleAnimation(22, 0);
                animPosX = new int[21];
                GameAppState.animPosX[0] = 593;
                GameAppState.animPosX[1] = 673;
                GameAppState.animPosX[2] = 705;
                GameAppState.animPosX[3] = 705;
                GameAppState.animPosX[4] = 593;
                GameAppState.animPosX[5] = 298;
                GameAppState.animPosX[6] = 458;
                GameAppState.animPosX[7] = 826;
                GameAppState.animPosX[8] = 986;
                GameAppState.animPosX[9] = 72;
                GameAppState.animPosX[10] = 80;
                GameAppState.animPosX[11] = 88;
                GameAppState.animPosX[12] = 96;
                GameAppState.animPosX[13] = 104;
                GameAppState.animPosX[14] = 112;
                GameAppState.animPosX[15] = 128;
                GameAppState.animPosX[16] = 136;
                GameAppState.animPosX[17] = 144;
                GameAppState.animPosX[18] = 152;
                GameAppState.animPosX[19] = 176;
                GameAppState.animPosX[20] = 184;
                animPosY = new int[21];
                GameAppState.animPosY[0] = 143;
                GameAppState.animPosY[1] = 111;
                GameAppState.animPosY[2] = 143;
                GameAppState.animPosY[3] = 63;
                GameAppState.animPosY[4] = 47;
                GameAppState.animPosY[5] = 72;
                GameAppState.animPosY[6] = 72;
                GameAppState.animPosY[7] = 72;
                GameAppState.animPosY[8] = 72;
                GameAppState.animPosY[9] = 80;
                GameAppState.animPosY[10] = 80;
                GameAppState.animPosY[11] = 80;
                GameAppState.animPosY[12] = 80;
                GameAppState.animPosY[13] = 80;
                GameAppState.animPosY[14] = 80;
                GameAppState.animPosY[15] = 128;
                GameAppState.animPosY[16] = 128;
                GameAppState.animPosY[17] = 128;
                GameAppState.animPosY[18] = 128;
                GameAppState.animPosY[19] = 128;
                GameAppState.animPosY[20] = 128;
                this.hiddenTiles1 = 0;
                this.hiddenTiles2 = 0;
                music = "/sfx/st7.mid";
            }
            if (levelNumber == 8) {
                music = "/sfx/st8.mid";
            }
            if (levelNumber == 9) {
                music = "/sfx/st9.mid";
            }
            if (levelNumber == 10) {
                music = "/sfx/endgame.mid";
            }
            if (levelNumber == 11) {
                music = "/sfx/st11.mid";
            }
            if (levelNumber == 12) {
                music = "/sfx/st12.mid";
            }
            drawHeroFirst = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GameAppState.changeMusic(music, -1);
        paused = false;
        this.levelLoading = false;
    }

    public static void addBullet(int x, int y, int vx, int vy, int endY, int type) {
        if (weaponsCount < 3) {
            Weapon w = new Weapon(x, y, vx, vy, (byte)type);
            w.state = 0;
            GameAppState.weapons[GameAppState.weaponsCount] = w;
            ++weaponsCount;
            w.thrownByPlayer = false;
            w.beginHeight = endY;
            w.damage = (byte)9;
        }
    }

    public static void addWeapon(Weapon w) {
        if (weaponsCount < 3) {
            GameAppState.weapons[GameAppState.weaponsCount] = w;
            w.id = (byte)weaponsCount;
            ++weaponsCount;
        }
    }

    public static void removeWeapon(int idd) {
        GameAppState.weapons[idd] = null;
        if (idd != weaponsCount - 1 && weaponsCount > 1) {
            GameAppState.weapons[idd] = weapons[weaponsCount - 1];
            GameAppState.weapons[GameAppState.weaponsCount - 1] = null;
            GameAppState.weapons[idd].id = (byte)idd;
        }
        --weaponsCount;
    }

    public void drawPlatform(Graphics g, int platform) {
        try {
            Image img = null;
            img = platform == 14 || platform == 15 ? (this.time1 >= PLATFORM_TIME2 - 1500 && (this.time1 + 30 * platform) % 150 > 75 ? this.platform_small_hide : this.platform_small) : (this.time1 >= PLATFORM_TIME2 - 1500 && (this.time1 + 30 * platform) % 150 > 75 ? this.platform_large_hide : this.platform_large);
            if (platform >= FIRST_PLATFORM2) {
                g.drawImage(img, GameAppState.scaleValue(this.platform2X[platform - FIRST_PLATFORM2] - cameraX), GameAppState.scaleValue(this.platform2Y[platform - FIRST_PLATFORM2] - cameraY), 0);
            } else {
                g.drawImage(img, GameAppState.scaleValue(this.platform1X[platform - FIRST_PLATFORM1] - cameraX), GameAppState.scaleValue(this.platform1Y[platform - FIRST_PLATFORM1] - cameraY), 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int[] createFadeTexture(int alphaLevel) {
        int y = 52;
        int texSize = 176 * y;
        int[] tex = new int[texSize];
        for (int i = 0; i < 176; ++i) {
            tex[i] = 0xFF000000 & alphaLevel << 24;
        }
        for (int currentWidth = 176; currentWidth < texSize; currentWidth += currentWidth) {
            int end = texSize - (currentWidth + currentWidth);
            int width = end <= 0 ? texSize - currentWidth : currentWidth;
            System.arraycopy(tex, 0, tex, currentWidth, width);
        }
        return tex;
    }

    public static void fadeOutIn() {
        fadingEnabled = true;
        fadeValue = 0;
        fadingIn = false;
    }

    public void onFadedOut() {
        this.lastLife = -1;
        this.lastLives = -1;
        this.lastScore = -1;
        if (this.loadGameRequested) {
            this.clearGameData();
            this.loadGame();
            this.loadGameRequested = false;
        } else if (splashScreenHideRequested) {
            if (GameAppState.splash.nextSplash != null) {
                if (GameAppState.splash.nextSplash.compareTo("menu") == 0) {
                    level = null;
                    splash = null;
                    this.menuState = 1;
                    this.selectedMenu = 1;
                    menuIdRequested = (byte)-1;
                    splashScreenHideRequested = false;
                    savedGameExist = false;
                    GameAppState.changeMusic("/sfx/title.mid", 1);
                    this.onMenuLoad();
                    return;
                }
                splash = new SplashScreen(new DataInputStream(this.getClass().getResourceAsStream(GameAppState.splash.nextSplash)));
            } else {
                splash = null;
                if (levelRequested != -1) {
                    int tmpLife = 80;
                    int tmpLives = 3;
                    int tmpScore = 0;
                    if (hero != null) {
                        tmpLives = GameAppState.hero.lives;
                        tmpScore = GameAppState.hero.score;
                    }
                    this.preloadLevel(levelRequested);
                    this.clearGameData();
                    this.loadLevel(levelRequested);
                    GameAppState.hero.life = (short)tmpLife;
                    GameAppState.hero.lives = (byte)tmpLives;
                    GameAppState.hero.score = tmpScore;
                    levelRequested = (byte)-1;
                }
            }
            splashScreenHideRequested = false;
        } else if (levelRequested != -1) {
            this.clearGameData();
            if (!this.loadSplashAndLevel(levelRequested)) {
                int tmpLife = 80;
                int tmpLives = 3;
                int tmpScore = 0;
                if (hero != null) {
                    if (levelRequested == 12) {
                        tmpLife = GameAppState.hero.life;
                    }
                    tmpLives = GameAppState.hero.lives;
                    tmpScore = GameAppState.hero.score;
                }
                this.preloadLevel(levelRequested);
                this.clearGameData();
                this.loadLevel(levelRequested);
                GameAppState.hero.life = (short)tmpLife;
                GameAppState.hero.lives = (byte)tmpLives;
                GameAppState.hero.score = tmpScore;
                levelRequested = (byte)-1;
            }
        } else if (menuIdRequested != -1) {
            if (menuIdRequested >= 100) {
                this.saveGame();
                this.menuRequested = true;
                this.menuState = menuIdRequested - 100;
                return;
            }
            level = null;
            if (menuIdRequested < -1) {
                menuIdRequested = (byte)(menuIdRequested + 256);
            }
            this.menuState = menuIdRequested;
            this.selectedMenu = 0;
            if (this.selectedMenu == 0 && this.menuState == 1) {
                if (!savedGameExist) {
                    this.selectedMenu = 1;
                }
            }
            this.onMenuLoad();
            menuIdRequested = (byte)-1;
        }
    }

    public static void drawChar(char c, Graphics g, int px, int py) {
        try {
            int dy = 0;
            int dh = 0;
            if (c == '\n') {
                return;
            }
            int x = c - 32;
            int y = 0;
            if (c == '\u2122') {
                x = 0;
                y = 2;
            } else if (c == '\u00a9') {
                x = 0;
                y = 1;
            } else if (c == '\u00bf') {
                x = 30;
                y = 0;
            } else if (c == '\u00a1') {
                x = 1;
                y = 0;
            } else if (c > 'z') {
                y = 3;
                if (c == '\u00e7') {
                    dy = 2;
                }
                for (int i = 0; i < characters.length; ++i) {
                    if (characters[i] != (short)c) continue;
                    x = i;
                    i = characters.length;
                }
            }
            while (x >= 32) {
                x -= 32;
                ++y;
            }
            g.drawRegion(currentFont, x * 8, y * 8, 8, 8 + dh, 0, px, py + dy, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void drawString(String s, Graphics g, int px, int py, int align) {
        int x = px;
        if (align == 1) {
            x -= (s.length() * 8 >> 1) - 2;
        } else if (align == 2) {
            x -= s.length() * 8;
        }
        for (int i = 0; i < s.length(); ++i) {
            GameAppState.drawChar(s.charAt(i), g, x, py);
            x += 8;
        }
    }

    public static void drawText(String txt, Graphics g, int px, int py, int width, int dy, int align) {
        String line = "";
        int start = 0;
        int end = 0;
        int caret = 0;
        int y = py;
        boolean newLine = true;
        while (end >= 0 && end != txt.length()) {
            caret = txt.indexOf(10, start);
            if (caret > 0 && (caret - start) * 8 < width && newLine) {
                end = caret;
                line = line + txt.substring(start, end) + " ";
                GameAppState.drawString(line, g, px, y, align);
                y += dy;
                line = "";
                newLine = true;
            } else {
                newLine = false;
                end = txt.indexOf(32, start);
                if (end < 0) {
                    end = txt.length();
                }
                if ((end - start + line.length()) * 8 > width) {
                    GameAppState.drawString(line, g, px, y, align);
                    y += dy;
                    line = "";
                    newLine = true;
                }
                line = line + txt.substring(start, end) + " ";
            }
            start = end + 1;
        }
        GameAppState.drawString(line, g, px, y, align);
    }

    public static void drawScrollingText(String txt, Graphics g, int px, int py, int width, int dy, int align, int height, int scrollValue, boolean showArrows) {
        String line = "";
        int start = 0;
        int end = 0;
        boolean last = false;
        int caret = 0;
        int y = py;
        int firstLine = scrollValue / dy;
        int lastLine = height / dy + firstLine;
        int lines = 0;
        if (showArrows && firstLine != 0) {
            g.setColor(255, 255, 255);
            g.fillTriangle(px - 10, py - 5, px, py - 9, px + 10, py - 5);
        }
        try {
            boolean newLine = true;
            while (end >= 0 && end != txt.length()) {
                caret = txt.indexOf(10, start);
                if (caret > 0 && (caret - start + line.length()) * 8 < width && newLine) {
                    end = caret;
                    line = line + txt.substring(start, end) + " ";
                    if (lines >= firstLine && lines <= lastLine) {
                        GameAppState.drawString(line, g, px, y - scrollValue, align);
                    }
                    y += dy;
                    line = "";
                    ++lines;
                    newLine = true;
                } else {
                    newLine = false;
                    end = txt.indexOf(32, start);
                    if (end < 0) {
                        end = txt.length();
                    }
                    if ((end - start + line.length()) * 8 > width) {
                        if (lines >= firstLine && lines <= lastLine) {
                            GameAppState.drawString(line, g, px, y - scrollValue, align);
                        }
                        y += dy;
                        line = "";
                        ++lines;
                        newLine = true;
                        end = start - 1;
                    } else {
                        line = line + txt.substring(start, end) + " ";
                    }
                }
                start = end + 1;
            }
            if (lines >= firstLine && lines <= lastLine) {
                last = true;
                GameAppState.drawString(line, g, px, y - scrollValue, align);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!last && showArrows) {
            maxScroll = false;
            g.setColor(255, 255, 255);
            g.fillTriangle(px - 10, py + height + 10, px, py + height + 14, px + 10, py + height + 10);
            return;
        }
        maxScroll = true;
    }

    public static void changeMusic(String track, int loops) {
        lastTrack = track;
        Integer id = Music.getIdOfMusicBeingPlayed();
        loopCount = loops;
        if (id != null) {
            lastVolume = Music.getVolume();
            Music.stopMusic();
        }
        Music.removeAllMusicTracks();
        if (musicEnabled && track != null) {
            try {
                Music.playMusic(Music.addMusicTrack(track), loops);
                if (lastVolume != -1) {
                    Music.setVolume(lastVolume);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void saveGame() {
        try {
            RecordStore rs = null;
            rs = RecordStore.openRecordStore((String)"dd2save", (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            if (level != null) {
                int i;
                out.writeByte(1);
                out.writeInt(this.tractorOffset);
                out.writeInt(levelNumber);
                out.writeByte(GameAppState.level.currentRegion);
                out.writeByte(GameAppState.level.region[GameAppState.level.currentRegion].currentGroup);
                out.writeByte(GameAppState.level.region[GameAppState.level.currentRegion].enemiesSpawned);
                out.writeInt(cameraX);
                out.writeInt(cameraY);
                out.writeInt(GameAppState.tiledLayer.layerImageMinTileX);
                out.writeInt(GameAppState.tiledLayer.layerImageMinTileY);
                out.writeInt(fadeValue);
                out.writeBoolean(fadingEnabled);
                out.writeBoolean(fadingIn);
                out.writeByte(levelRequested);
                out.writeBoolean(drawHeroFirst);
                out.writeInt(this.time1);
                out.writeInt(this.time2);
                out.writeBoolean(zgniatarkaEnabled);
                out.writeInt(this.fp_heliPosX);
                out.writeBoolean(heliEnabled);
                out.writeBoolean(heliShooting);
                out.writeByte(this.bulletsShot);
                out.writeByte(this.bulletSpeedY);
                out.writeInt(fp_heli2PosY);
                out.writeBoolean(heli2Flying);
                out.writeInt(enabledPlatform);
                out.writeInt(enabledPlatform1);
                out.writeInt(this.currentFlame);
                out.writeInt(this.currentSpike);
                out.writeByte(this.hiddenTiles1);
                out.writeByte(this.hiddenTiles2);
                out.writeBoolean(tractorEnabled);
                out.writeByte(this.currentSteam);
                out.writeBoolean(this.nextLevelRequested);
                out.writeBoolean(windaActive);
                hero.Serialize(out);
                out.writeByte(ileWrogow);
                for (i = 1; i <= ileWrogow; ++i) {
                    out.writeInt(GameAppState.heros[i].enemyType);
                    if (GameAppState.heros[i].weapon != null) {
                        out.writeByte(GameAppState.heros[i].weapon.weaponType);
                        continue;
                    }
                    out.writeByte(-1);
                }
                for (i = 1; i <= ileWrogow; ++i) {
                    heros[i].Serialize(out);
                }
                out.writeByte(weaponsCount);
                for (i = 0; i < weaponsCount; ++i) {
                    out.writeByte(GameAppState.weapons[i].weaponType);
                    weapons[i].Serialize(out);
                }
                if (animations != null) {
                    for (i = 0; i < animations.length; ++i) {
                        animations[i].Serialize(out);
                    }
                }
            } else if (splash != null) {
                out.writeByte(2);
                out.writeByte(levelRequested);
            }
            byte[] data = baos.toByteArray();
            if (rs.getNumRecords() == 0) {
                rs.addRecord(data, 0, data.length);
            } else {
                RecordEnumeration re = rs.enumerateRecords(null, null, false);
                rs.setRecord(re.nextRecordId(), data, 0, data.length);
            }
            baos.reset();
            baos.close();
            out.close();
            rs.closeRecordStore();
            savedGameExist = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String loadGame() {
        String state = null;
        try {
            RecordStore rs = null;
            rs = RecordStore.openRecordStore((String)"dd2save", (boolean)true);
            ByteArrayInputStream bais = null;
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            bais = new ByteArrayInputStream(rs.getRecord(re.nextRecordId()));
            DataInputStream in = new DataInputStream(bais);
            byte loadMode = in.readByte();
            if (loadMode == 1) {
                int type;
                int i;
                this.tractorOffset = in.readInt();
                levelNumber = in.readInt();
                this.loadLevel(levelNumber);
                this.levelLoading = true;
                GameAppState.level.currentRegion = in.readByte();
                GameAppState.level.region[GameAppState.level.currentRegion].currentGroup = in.readByte();
                GameAppState.level.region[GameAppState.level.currentRegion].enemiesSpawned = in.readByte();
                cameraX = in.readInt();
                cameraY = in.readInt();
                tiledLayer.setLayerPosition(GameAppState.scaleValue(cameraX), GameAppState.scaleValue(cameraY));
                GameAppState.tiledLayer.layerImageMinTileX = in.readInt();
                GameAppState.tiledLayer.layerImageMinTileY = in.readInt();
                fadeValue = in.readInt();
                fadingEnabled = in.readBoolean();
                fadingIn = in.readBoolean();
                levelRequested = in.readByte();
                drawHeroFirst = in.readBoolean();
                this.time1 = in.readInt();
                this.time2 = in.readInt();
                zgniatarkaEnabled = in.readBoolean();
                this.fp_heliPosX = in.readInt();
                heliEnabled = in.readBoolean();
                heliShooting = in.readBoolean();
                this.bulletsShot = in.readByte();
                this.bulletSpeedY = in.readByte();
                fp_heli2PosY = in.readInt();
                heli2Flying = in.readBoolean();
                enabledPlatform = in.readInt();
                enabledPlatform1 = in.readInt();
                this.currentFlame = in.readInt();
                this.currentSpike = in.readInt();
                this.hiddenTiles1 = in.readByte();
                this.hiddenTiles2 = in.readByte();
                if (levelNumber == 7) {
                    GameAppState.level.sectorEdgeTop[5].movePoint(0, 8 * this.hiddenTiles1);
                    GameAppState.level.sectorEdgeTop[5].movePoint(1, 8 * this.hiddenTiles1);
                    GameAppState.level.sectorEdgeTop[19].movePoint(0, 8 * this.hiddenTiles2);
                    GameAppState.level.sectorEdgeTop[19].movePoint(1, 8 * this.hiddenTiles2);
                }
                tractorEnabled = in.readBoolean();
                this.currentSteam = in.readByte();
                this.nextLevelRequested = in.readBoolean();
                windaActive = in.readBoolean();
                hero.DeSerialize(in);
                int enemies = in.readByte();
                for (i = 1; i <= enemies; ++i) {
                    type = in.readInt();
                    byte weapon = in.readByte();
                    GameAppState.addEnemy(0, 0, 0, 0, type, weapon);
                }
                for (i = 1; i <= ileWrogow; ++i) {
                    heros[i].DeSerialize(in);
                }
                weaponsCount = in.readByte();
                for (i = 0; i < weaponsCount; ++i) {
                    type = in.readByte();
                    GameAppState.weapons[i] = new Weapon(type);
                    weapons[i].DeSerialize(in);
                }
                if (animations != null) {
                    for (i = 0; i < animations.length; ++i) {
                        animations[i].DeSerialize(in);
                    }
                }
            } else if (loadMode == 2) {
                levelRequested = in.readByte();
                this.loadSplashAndLevel(levelRequested);
            }
            this.levelLoading = false;
            bais.close();
            in.close();
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return state;
    }

    public void saveScores() {
        try {
            RecordStore rs = null;
            rs = RecordStore.openRecordStore((String)"dd2scores", (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeInt(this.hiScore);
            out.writeBoolean(savedGameExist);
            out.writeBoolean(vibrationsEnabled);
            out.writeBoolean(soundsEnabled);
            if (Music.getIdOfMusicBeingPlayed() != null) {
                out.writeInt(Music.getVolume());
            } else {
                out.writeInt(lastVolume);
            }
            out.writeByte(language);
            for (int i = 0; i < 9; ++i) {
                out.writeByte(keyCodes[i]);
            }
            out.writeByte(difficultiesPlayed);
            byte[] data = baos.toByteArray();
            if (rs.getNumRecords() == 0) {
                rs.addRecord(data, 0, data.length);
            } else {
                RecordEnumeration re = rs.enumerateRecords(null, null, false);
                rs.setRecord(re.nextRecordId(), data, 0, data.length);
            }
            baos.reset();
            baos.close();
            out.close();
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadScores() {
        try {
            RecordStore rs = null;
            rs = RecordStore.openRecordStore((String)"dd2scores", (boolean)true);
            ByteArrayInputStream bais = null;
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            if (rs.getNumRecords() != 0) {
                bais = new ByteArrayInputStream(rs.getRecord(re.nextRecordId()));
                DataInputStream in = new DataInputStream(bais);
                this.hiScore = in.readInt();
                savedGameExist = in.readBoolean();
                vibrationsEnabled = in.readBoolean();
                soundsEnabled = in.readBoolean();
                lastVolume = in.readInt();
                language = in.readByte();
                this.createCreditsString();
                byte[] tmpKeys = new byte[9];
                for (int i = 0; i < 9; ++i) {
                    tmpKeys[i] = in.readByte();
                }
                GameAppState.setKeyCodes(tmpKeys);
                difficultiesPlayed = in.readByte();
                bais.close();
                in.close();
            } else {
                this.hiScore = 0;
                savedGameExist = false;
                difficultiesPlayed = 0;
                this.firstStart = true;
                language = 0;
                this.selectedMenu = 0;
            }
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void applicationDestroyed() {
        if (level != null || splash != null) {
            this.saveGame();
        }
        this.saveScores();
    }

    public static int scaleValue(int val) {
        return val;
    }

    public static int scaleUpValue(int val) {
        return val;
    }

    public void clearGameData() {
        int i;
        this.hud = null;
        this.door = null;
        this.zgniatarka = null;
        this.heli1 = null;
        this.heli2 = null;
        this.platform_small = null;
        this.platform_large = null;
        this.platform_small_hide = null;
        this.platform_large_hide = null;
        animations = null;
        animPosX = null;
        animPosY = null;
        this.tractorImage = null;
        winda = null;
        currentEnemyImage = null;
        currentEnemyImageId = -1;
        if (hero != null) {
            hero.clear();
        }
        for (i = 0; i < heros.length; ++i) {
            if (heros[i] == null) continue;
            heros[i].clear();
            GameAppState.heros[i] = null;
        }
        ileWrogow = 0;
        for (i = 0; i < weapons.length; ++i) {
            GameAppState.weapons[i] = null;
        }
        weaponsCount = 0;
        platforma = null;
        if (tiledLayer != null) {
            tiledLayer.clear();
            tiledLayer = null;
        }
        level = null;
        if (animations != null) {
            for (i = 0; i < animations.length; ++i) {
                GameAppState.animations[i] = null;
            }
        }
        animations = null;
        animPosX = null;
        animPosY = null;
        SimpleAnimation.image = null;
        GameAppState.wyczyscKlawisze();
    }

    public void onMenuLoad() {
        this.menuRepaintRequested = true;
        this.menuRepainted = false;
        this.clearGameData();
        try {
            if (font_gray == null) {
                font_gray = this.createFont(0x9E9E9D);
            }
            if (font_blue == null) {
                font_blue = Image.createImage((String)"/font_blue.png");
            }
            if (this.menuImage == null) {
                this.menuImage = Image.createImage((String)"/logo_menu.png");
            }
            if (this.menuBackground == null) {
                this.menuBackground = Image.createImage((String)"/front_end.png");
            }
            if (this.volumeImage == null) {
                this.volumeImage = Image.createImage((String)"/volume.png");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void onGameLoad() {
        this.menuImage = null;
        this.menuBackground = null;
        this.volumeImage = null;
        font_gray = null;
        SimpleAnimation.initialize("/anims.png");
        try {
            this.hud = Image.createImage((String)"/hud.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void pauseStateChanged(boolean paused) {
        super.pauseStateChanged(paused);
        GameAppState.wyczyscKlawisze();
        if (paused) {
            if (musicEnabled) {
                this.musicId = Music.getIdOfMusicBeingPlayed();
                if (this.musicId != null) {
                    lastVolume = Music.getVolume();
                    Music.stopMusic();
                }
            }
        } else if (!paused && musicEnabled && this.musicId != null && loopCount == -1) {
            Music.playMusic(this.musicId);
            Music.setVolume(lastVolume);
        }
    }

    public static int xPosition(int px) {
        return 176 * px / 1000;
    }

    public static int yPosition(int py) {
        return 208 * py / 1000;
    }

    public static int xPositionWithDelta(int px) {
        return (176 - SCREEN_DELTA_X * 2) * px / 1000;
    }

    public static int yPositionWithDelta(int py) {
        return (208 - SCREEN_DELTA_Y) * py / 1000;
    }

    public static void setKeyCodes(boolean rightHand) {
        GameAppState.keyCodes[0] = -4;
        GameAppState.keyCodes[1] = -3;
        GameAppState.keyCodes[2] = -1;
        GameAppState.keyCodes[3] = -2;
        GameAppState.keyCodes[8] = -5;
        if (rightHand) {
            GameAppState.keyCodes[4] = 48;
            GameAppState.keyCodes[5] = 42;
            GameAppState.keyCodes[6] = 55;
            GameAppState.keyCodes[7] = 56;
        } else {
            GameAppState.keyCodes[4] = 35;
            GameAppState.keyCodes[5] = 48;
            GameAppState.keyCodes[6] = 57;
            GameAppState.keyCodes[7] = 56;
        }
    }

    public static String getKeyString(int code) {
        switch (code) {
            case 48: {
                return "0";
            }
            case 49: {
                return "1";
            }
            case 50: {
                return "2";
            }
            case 51: {
                return "3";
            }
            case 52: {
                return "4";
            }
            case 53: {
                return "5";
            }
            case 54: {
                return "6";
            }
            case 55: {
                return "7";
            }
            case 56: {
                return "8";
            }
            case 57: {
                return "9";
            }
            case 42: {
                return "*";
            }
            case 35: {
                return "#";
            }
            case -3: {
                return "$";
            }
            case -4: {
                return "%";
            }
            case -1: {
                return ";";
            }
            case -2: {
                return "<";
            }
        }
        return "??";
    }

    public static void setKeyCodes(byte[] newKeyCodes) {
        keyCodes = newKeyCodes;
    }

    public static void wyczyscKlawisze() {
        for (int key = 0; key < 9; ++key) {
            GameAppState.stanKlawisza[key] = 0;
        }
    }

    public static void keyPressedKlawisze(int keyCode) {
        long time = System.currentTimeMillis();
        int pozycja = -1;
        if (keyCode == keyCodes[0]) {
            pozycja = 0;
        }
        if (keyCode == keyCodes[1]) {
            pozycja = 1;
        }
        if (keyCode == keyCodes[2]) {
            pozycja = 2;
        }
        if (keyCode == keyCodes[3]) {
            pozycja = 3;
        }
        if (keyCode == keyCodes[4]) {
            pozycja = 4;
        }
        if (keyCode == keyCodes[5]) {
            pozycja = 5;
        }
        if (keyCode == keyCodes[6]) {
            pozycja = 6;
        }
        if (keyCode == keyCodes[7]) {
            pozycja = 7;
        }
        if (keyCode == keyCodes[8]) {
            pozycja = 8;
        }
        if (pozycja != -1) {
            GameAppState.stanKlawisza[pozycja] = 1;
            GameAppState.momentWcisnieciaKlawisza[pozycja] = time;
        }
    }

    public static void keyReleasedKlawisze(int keyCode) {
        long time = System.currentTimeMillis();
        int pozycja = -1;
        if (keyCode == keyCodes[0]) {
            pozycja = 0;
        }
        if (keyCode == keyCodes[1]) {
            pozycja = 1;
        }
        if (keyCode == keyCodes[2]) {
            pozycja = 2;
        }
        if (keyCode == keyCodes[3]) {
            pozycja = 3;
        }
        if (keyCode == keyCodes[4]) {
            pozycja = 4;
        }
        if (keyCode == keyCodes[5]) {
            pozycja = 5;
        }
        if (keyCode == keyCodes[6]) {
            pozycja = 6;
        }
        if (keyCode == keyCodes[7]) {
            pozycja = 7;
        }
        if (keyCode == keyCodes[8]) {
            pozycja = 8;
        }
        if (pozycja != -1) {
            GameAppState.stanKlawisza[pozycja] = 0;
            GameAppState.momentPuszczeniaKlawisza[pozycja] = time;
        }
    }

    public static void przestawStanKlawiszy() {
        for (int key = 0; key < 10; ++key) {
            if (stanKlawisza[key] == 1) {
                GameAppState.stanKlawisza[key] = 2;
            }
            if (stanKlawisza[key] != 3) continue;
            GameAppState.stanKlawisza[key] = 0;
        }
    }

    public static void wyliczCzasyKlawiszy(long beginTime, long endTime) {
        int stepTime = (int)(endTime - beginTime);
        for (int key = 0; key < 9; ++key) {
            switch (stanKlawisza[key]) {
                case 0: {
                    GameAppState.czasKlawisza[key] = 0;
                    break;
                }
                case 1: {
                    GameAppState.czasKlawisza[key] = (int)(endTime - momentWcisnieciaKlawisza[key]);
                    break;
                }
                case 2: {
                    GameAppState.czasKlawisza[key] = stepTime;
                    break;
                }
                case 3: {
                    GameAppState.czasKlawisza[key] = (int)(momentPuszczeniaKlawisza[key] - beginTime);
                }
            }
            if (czasKlawisza[key] > stepTime) {
                GameAppState.czasKlawisza[key] = stepTime;
            }
            if (czasKlawisza[key] >= 0) continue;
            GameAppState.czasKlawisza[key] = 0;
        }
    }

    static {
        scrollX_MIN = 64 * GameAppState.scaleUpValue(176) >> 8;
        scrollX_MAX = 192 * GameAppState.scaleUpValue(176) >> 8;
        scrollY_MIN = 128 * GameAppState.scaleUpValue(168) >> 8;
        scrollY_MAX = 208 * GameAppState.scaleUpValue(168) >> 8;
        maxScrollSpeed = 7;
        heros = new Hero[5];
        weapons = new Weapon[3];
        weaponsCount = 0;
        handTime = 0;
        HELI1_STARTX = 130560;
        HELI1_ENDX = 73984;
        HELI2_STARTY = 2048;
        HELI2_ENDY = -17920;
        HELI2_X = 194816;
        FIRST_PLATFORM2 = (byte)13;
        LAST_PLATFORM2 = (byte)17;
        FIRST_PLATFORM1 = (byte)3;
        LAST_PLATFORM1 = (byte)5;
        PLATFORM_TIME2 = (short)3500;
        tractorSpeed = 8192;
        tractorStartPosition = 1055;
        keyCodes = new byte[9];
        stanKlawisza = new int[9];
        czasKlawisza = new int[9];
        momentWcisnieciaKlawisza = new long[9];
        momentPuszczeniaKlawisza = new long[9];
        wyzerujKlawisze = true;
        characters = new short[]{192, 194, 199, 201, 200, 203, 202, 206, 207, 212, 219, 217, 220, 376, 196, 214, 209, 193, 268, 270, 282, 205, 327, 211, 344, 352, 356, 218, 366, 221, 210, 204, 224, 226, 231, 233, 232, 235, 234, 238, 239, 244, 251, 249, 252, 376, 228, 246, 241, 225, 268, 270, 282, 237, 327, 243, 344, 352, 356, 250, 366, 253, 242, 236};
        lastVolume = -1;
        loopCount = -1;
        lastTrack = null;
    }
}

