/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class vGraphics {
    private boolean m_bDrawImageDG = true;
    private DirectGraphics m_dg;
    private Graphics m_g;
    private vRect m_clipRect = new vRect();
    public vRect m_dirtyRect = new vRect();
    public int m_iTranslateX;
    public int m_iTranslateY;
    private int m_iActualWidth;
    public int m_iActualHeight;
    private vRect m_tempRect = new vRect();
    private vRect[] m_clipRectStack = new vRect[16];
    private int m_iClipRectStackSize;

    public vGraphics(Graphics g, int iWidth, int iHeight) {
        this.m_g = g;
        this.m_dg = DirectUtils.getDirectGraphics((Graphics)g);
        this.m_iActualWidth = iWidth;
        this.m_iActualHeight = iHeight;
        this.m_clipRect.set(0, 0, iWidth, iHeight);
        for (int i = 0; i < 16; ++i) {
            this.m_clipRectStack[i] = new vRect();
        }
    }

    public final boolean drawPixels(short[] img, int iX, int iY, int iFlags) {
        return this.drawPixels(img, iX, iY, img[img.length - 2], img[img.length - 1], 0, 0, iFlags);
    }

    public final boolean drawPixels(short[] img, int iX, int iY, int iWidth, int iHeight, int iSrcX, int iSrcY, int iFlags) {
        this.m_tempRect.set(iX += this.m_iTranslateX, iY += this.m_iTranslateY, iWidth, iHeight);
        if (!this.m_tempRect.intersect(this.m_clipRect)) {
            return false;
        }
        if (iSrcX < 0) {
            iWidth -= -iSrcX;
            iSrcX = 0;
        }
        if (iSrcY < 0) {
            iHeight -= -iSrcY;
            iSrcY = 0;
        }
        short iSrcWidth = img[img.length - 2];
        short iSrcHeight = img[img.length - 1];
        if (iSrcX + iWidth > iSrcWidth) {
            iWidth = iSrcWidth - iSrcX;
        }
        if (iSrcY + iHeight > iSrcHeight) {
            iHeight = iSrcHeight - iSrcY;
        }
        if (iWidth <= 0) {
            return false;
        }
        if (iHeight <= 0) {
            return false;
        }
        int manipulation = 0;
        if ((iFlags & Integer.MIN_VALUE) != 0) {
            manipulation = 8192;
        }
        if ((iFlags & 0x40000000) != 0) {
            manipulation |= 0x4000;
        }
        this.m_dg.drawPixels(img, true, iSrcY * iSrcWidth + iSrcX, (int)iSrcWidth, iX, iY, iWidth, iHeight, manipulation, 4444);
        this.unionClippedDirtyRect(this.m_tempRect);
        return true;
    }

    public final boolean drawImage(Image img, int iX, int iY) {
        this.m_tempRect.set(iX += this.m_iTranslateX, iY += this.m_iTranslateY, img.getWidth(), img.getHeight());
        if (!this.m_tempRect.intersect(this.m_clipRect)) {
            return false;
        }
        this.m_g.drawImage(img, iX, iY, 20);
        this.unionClippedDirtyRect(this.m_tempRect);
        return true;
    }

    public final boolean drawImage(Image img, int iX, int iY, int iFlags) {
        this.m_tempRect.set(iX += this.m_iTranslateX, iY += this.m_iTranslateY, img.getWidth(), img.getHeight());
        if (!this.m_tempRect.intersect(this.m_clipRect)) {
            return false;
        }
        int flags = 0;
        if ((iFlags & Integer.MIN_VALUE) != 0) {
            flags = 8192;
        }
        if ((iFlags & 0x40000000) != 0) {
            flags |= 0x4000;
        }
        if (this.m_bDrawImageDG && flags != 0) {
            this.m_dg.drawImage(img, iX, iY, 20, flags);
        } else {
            this.m_g.drawImage(img, iX, iY, 20);
        }
        this.unionClippedDirtyRect(this.m_tempRect);
        return true;
    }

    public final boolean drawImage(Image img, int iX, int iY, int iWidth, int iHeight, int iSrcX, int iSrcY) {
        this.m_tempRect.set(iX += this.m_iTranslateX, iY += this.m_iTranslateY, iWidth, iHeight);
        this.pushClipRect();
        if (this.clipRect(this.m_tempRect)) {
            this.unionClippedDirtyRect(this.m_tempRect);
            this.m_g.drawImage(img, iX - iSrcX, iY - iSrcY, 20);
        }
        this.popClipRect();
        return true;
    }

    public final boolean drawImage(Image img, int iX, int iY, int iWidth, int iHeight, int iSrcX, int iSrcY, int iFlags) {
        this.m_tempRect.set(iX += this.m_iTranslateX, iY += this.m_iTranslateY, iWidth, iHeight);
        this.pushClipRect();
        if (this.clipRect(this.m_tempRect)) {
            int posY;
            int posX;
            this.unionClippedDirtyRect(this.m_tempRect);
            int flags = 0;
            if ((iFlags & Integer.MIN_VALUE) != 0) {
                flags = 8192;
                posX = iX - (img.getWidth() - iSrcX - iWidth);
            } else {
                posX = iX - iSrcX;
            }
            if ((iFlags & 0x40000000) != 0) {
                flags |= 0x4000;
                posY = iY - (img.getHeight() - iSrcY - iHeight);
            } else {
                posY = iY - iSrcY;
            }
            if (this.m_bDrawImageDG && flags != 0) {
                this.m_dg.drawImage(img, posX, posY, 20, flags);
            } else {
                this.m_g.drawImage(img, posX, posY, 20);
            }
        }
        this.popClipRect();
        return true;
    }

    public final void drawBitmapStyleText(String szText, vBitmapFont font_fg, int baseX, int baseY) {
        font_fg.drawString(this, szText, baseX, baseY);
    }

    public final void drawBitmapStyleTextShadow(String szText, vBitmapFont font_fg, vBitmapFont font_bg, int baseX, int baseY) {
        font_bg.drawString(this, szText, baseX + 1, baseY);
        font_bg.drawString(this, szText, baseX, baseY + 1);
        font_bg.drawString(this, szText, baseX + 1, baseY + 1);
        font_fg.drawString(this, szText, baseX, baseY);
    }

    public final void drawBitmapStyleTextOutline(String szText, vBitmapFont font_fg, vBitmapFont font_bg, int baseX, int baseY) {
        font_bg.drawString(this, szText, baseX, baseY - 1);
        font_bg.drawString(this, szText, baseX + 1, baseY - 1);
        font_bg.drawString(this, szText, baseX - 1, baseY - 1);
        font_bg.drawString(this, szText, baseX, baseY + 1);
        font_bg.drawString(this, szText, baseX + 1, baseY + 1);
        font_bg.drawString(this, szText, baseX - 1, baseY + 1);
        font_bg.drawString(this, szText, baseX - 1, baseY);
        font_bg.drawString(this, szText, baseX + 1, baseY);
        font_fg.drawString(this, szText, baseX, baseY);
    }

    public final boolean fillOutlinedRect(vRect rect, int iFrame, int iFill) {
        if (rect == null) {
            this.m_tempRect.set(0, 0, this.m_iActualWidth, this.m_iActualHeight);
            if (this.fillRect(this.m_tempRect, iFill)) {
                this.drawRect(this.m_tempRect, iFrame);
                return true;
            }
        } else if (this.fillRect(rect, iFill)) {
            this.drawRect(rect, iFrame);
            return true;
        }
        return false;
    }

    public final boolean drawRect(vRect rect, int iColor) {
        if (rect != null) {
            this.m_tempRect.set(rect.x + this.m_iTranslateX, rect.y + this.m_iTranslateY, rect.dx, rect.dy);
        } else {
            this.m_tempRect.set(0, 0, this.m_iActualWidth, this.m_iActualHeight);
            this.m_tempRect.intersect(this.m_clipRect);
            --this.m_tempRect.dy;
        }
        int iOldColor = this.m_g.getColor();
        this.m_g.setColor(iColor);
        this.m_g.drawRect(this.m_tempRect.x, this.m_tempRect.y, this.m_tempRect.dx - 1, this.m_tempRect.dy - 1);
        this.m_g.setColor(iOldColor);
        if (!this.m_tempRect.intersect(this.m_clipRect)) {
            return false;
        }
        this.unionClippedDirtyRect(this.m_tempRect);
        return true;
    }

    public final boolean fillRect(vRect rect, int iColor) {
        if (rect != null) {
            this.m_tempRect.set(rect.x + this.m_iTranslateX, rect.y + this.m_iTranslateY, rect.dx, rect.dy);
        } else {
            this.m_tempRect.set(0, 0, this.m_iActualWidth, this.m_iActualHeight);
        }
        if (!this.m_tempRect.intersect(this.m_clipRect)) {
            return false;
        }
        this.unionClippedDirtyRect(this.m_tempRect);
        int iOldColor = this.m_g.getColor();
        this.m_g.setColor(iColor);
        this.m_g.fillRect(this.m_tempRect.x, this.m_tempRect.y, this.m_tempRect.dx, this.m_tempRect.dy);
        this.m_g.setColor(iOldColor);
        return true;
    }

    public final boolean drawLine(int iX1, int iY1, int iX2, int iY2, int iColor) {
        int iOldColor = this.m_g.getColor();
        this.m_g.setColor(iColor);
        this.m_g.drawLine(iX1 += this.m_iTranslateX, iY1 += this.m_iTranslateY, iX2 += this.m_iTranslateX, iY2 += this.m_iTranslateY);
        this.m_g.setColor(iOldColor);
        this.unionDirtyRect(Math.min(iX1, iX2), Math.min(iY1, iY2), Math.abs(iX2 - iX1) + 1, Math.abs(iY2 - iY1) + 1);
        return true;
    }

    public final void clearDirtyRect() {
        this.m_dirtyRect.dx = 0;
    }

    private void unionDirtyRect(int x, int y, int w, int h) {
        this.m_tempRect.set(x, y, w, h);
        if (this.m_tempRect.intersect(this.m_clipRect)) {
            this.unionClippedDirtyRect(this.m_tempRect);
        }
    }

    private void unionClippedDirtyRect(vRect dirtyRect) {
        if (this.m_dirtyRect.dx != 0) {
            this.m_dirtyRect.unionRect(dirtyRect);
            return;
        }
        this.m_dirtyRect.set(dirtyRect);
    }

    public final void setClippedClipRect(vRect rect) {
        this.m_clipRect.set(rect);
        this.m_g.setClip(this.m_clipRect.x, this.m_clipRect.y, this.m_clipRect.dx, this.m_clipRect.dy);
    }

    public final void pushClipRect() {
        this.m_clipRectStack[this.m_iClipRectStackSize++].set(this.m_clipRect);
    }

    public final void popClipRect() {
        this.m_clipRect.set(this.m_clipRectStack[--this.m_iClipRectStackSize]);
        this.m_g.setClip(this.m_clipRect.x, this.m_clipRect.y, this.m_clipRect.dx, this.m_clipRect.dy);
    }

    public final void getClipRect(vRect rect) {
        rect.set(this.m_clipRect);
    }

    public final void setClipRect(int x, int y, int width, int height) {
        this.m_tempRect.set(x, y, width, height);
        this.setClipRect(this.m_tempRect);
    }

    public final void setClipRect(vRect rect) {
        this.m_clipRect.set(0, 0, this.m_iActualWidth, this.m_iActualHeight);
        if (rect != null) {
            this.m_clipRect.intersect(rect);
        }
        this.m_g.setClip(this.m_clipRect.x, this.m_clipRect.y, this.m_clipRect.dx, this.m_clipRect.dy);
    }

    public final boolean clipRect(vRect rect) {
        boolean bClip = this.m_clipRect.intersect(rect);
        this.m_g.setClip(this.m_clipRect.x, this.m_clipRect.y, this.m_clipRect.dx, this.m_clipRect.dy);
        return bClip;
    }

    public final void translate(int iX, int iY) {
        this.m_iTranslateX += iX;
        this.m_iTranslateY += iY;
    }

    public final void setTranslate(int iX, int iY) {
        this.m_iTranslateX = iX;
        this.m_iTranslateY = iY;
    }
}

