/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class PropertyTable {
    vDictionary m_dictionary;
    int m_iTableSize;
    int[] m_pTable;

    final void init(DataInputStream dis) throws IOException {
        int magicID = dis.readUnsignedShort();
        int version = dis.readUnsignedShort();
        if (magicID != 12111) {
            System.out.println("VASSERT failed ::magicID == kMagicID");
        }
        if (version != 1) {
            System.out.println("VASSERT failed ::version == kVersion");
        }
        this.m_iTableSize = dis.readInt();
        if (this.m_iTableSize > 0) {
            this.m_pTable = new int[this.m_iTableSize];
            for (int i = 0; i < this.m_iTableSize; ++i) {
                this.m_pTable[i] = dis.readInt();
            }
        }
        this.m_dictionary = new vDictionary();
        this.m_dictionary.init(dis);
    }

    final void shutdown() {
        if (this.m_dictionary != null) {
            this.m_dictionary.shutdown();
            this.m_dictionary = null;
        }
        this.m_pTable = null;
    }

    final void save(DataOutputStream dos) throws IOException {
        dos.writeShort(62020);
        dos.writeShort(0);
        for (int i = 0; i < this.m_iTableSize; ++i) {
            dos.writeInt(this.m_pTable[i]);
        }
    }

    final void open(DataInputStream dis) throws IOException {
        short uiMagicID = dis.readShort();
        short uiVersion = dis.readShort();
        if (uiMagicID != 62020) {
            System.out.println("VASSERT failed ::uiMagicID == kSaveMagicID");
        }
        if (uiVersion != 0) {
            System.out.println("VASSERT failed ::uiVersion == kSaveVersion");
        }
        for (int i = 0; i < this.m_iTableSize; ++i) {
            this.m_pTable[i] = dis.readInt();
        }
    }

    final String getString(int uiIndex) {
        return this.m_dictionary.getString(uiIndex);
    }

    final int getInt(int iIndex) {
        if (iIndex < 0 || iIndex >= this.m_iTableSize) {
            System.out.println("VASSERT failed ::iIndex >= 0 && iIndex < m_iTableSize");
        }
        if (this.m_pTable == null) {
            System.out.println("VASSERT failed ::m_pTable != null");
        }
        return this.m_pTable[iIndex];
    }

    final void setInt(int iIndex, int iValue) {
        if (iIndex < 0 || iIndex >= this.m_iTableSize) {
            System.out.println("VASSERT failed ::iIndex >= 0 && iIndex < m_iTableSize");
        }
        if (this.m_pTable == null) {
            System.out.println("VASSERT failed ::m_pTable != null");
        }
        this.m_pTable[iIndex] = iValue;
    }
}

