/*
 * Decompiled with CFR 0.152.
 */
import de.tuttas.GameAPI.AnimatedFragment;
import de.tuttas.GameAPI.AnimatedFragmentListener;
import de.tuttas.GameAPI.FragmentImage;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ship
implements AnimatedFragmentListener {
    public static final int SCHNELLBOOT = 2;
    public static final int FREGATTE = 3;
    public static final int KREUZER = 4;
    public static final int ZERSTOERER = 5;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    AnimatedFragment af;
    boolean explode = false;
    int type;
    int hitCounter;
    int orientation;
    FragmentImage image;
    int elementWidth;
    int elementHeight;
    int xIndex;
    int yIndex;
    int elementState;
    static FragmentImage image2;
    static FragmentImage image3;
    static FragmentImage image4;
    static FragmentImage image5;
    static Image explodeImage;

    public Ship(int xi, int yi, int t) {
        this.type = t;
        this.hitCounter = t;
        this.elementHeight = 1;
        this.elementWidth = t;
        this.orientation = 2;
        this.xIndex = xi;
        this.yIndex = yi;
        if (image2 == null) {
            try {
                explodeImage = Image.createImage((String)"/shipexplode.png");
                image2 = new FragmentImage(Image.createImage((String)"/ship2.png"));
                image3 = new FragmentImage(Image.createImage((String)"/ship3.png"));
                image4 = new FragmentImage(Image.createImage((String)"/ship4.png"));
                image5 = new FragmentImage(Image.createImage((String)"/ship5.png"));
            }
            catch (IOException iox) {
                // empty catch block
            }
        }
        this.af = new AnimatedFragment(explodeImage, explodeImage.getWidth() / 8, 1, 1, 0, 0);
        this.af.setListener(this);
        switch (this.type) {
            case 2: {
                this.image = image2;
                break;
            }
            case 3: {
                this.image = image3;
                break;
            }
            case 4: {
                this.image = image4;
                break;
            }
            case 5: {
                this.image = image5;
            }
        }
        this.elementState = 1;
    }

    public void setElementState(int s) {
        this.elementState = s;
    }

    public int getElementState() {
        return this.elementState;
    }

    public void paint(Graphics g, int x, int y) {
        g.setClip(0, 0, Config.SCREENWIDTH, Config.SCREENHEIGHT);
        this.image.paint(g, x, y - this.image.largeImage.getHeight() / this.type, 0, this.hitCounter - 1, this.image.largeImage.getWidth(), this.image.largeImage.getHeight() / this.type);
        g.setColor(0xFF0000);
        g.fillRect(x, y + 1, this.hitCounter * this.image.largeImage.getWidth() / this.type, Ship.image2.largeImage.getHeight() / 6);
        if (this.explode) {
            g.setClip(0, 0, Config.SCREENWIDTH, Config.SCREENHEIGHT);
            this.af.xPos = x - this.image.largeImage.getWidth() / 4;
            this.af.yPos = y - explodeImage.getHeight();
            this.af.paint(g);
            this.af.next();
        }
    }

    public void rotate() {
        int i = this.elementWidth;
        this.elementWidth = this.elementHeight;
        this.elementHeight = i;
        this.orientation = this.orientation == 1 ? 2 : 1;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public int getElementWidth() {
        return this.elementWidth;
    }

    public int getElementHeight() {
        return this.elementHeight;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void left() {
        --this.xIndex;
        if (this.xIndex < 0) {
            this.xIndex = 0;
        }
    }

    public void right() {
        ++this.xIndex;
        if (this.xIndex > 10 - this.elementWidth) {
            this.xIndex = 10 - this.elementWidth;
        }
    }

    public void up() {
        --this.yIndex;
        if (this.yIndex < 0) {
            this.yIndex = 0;
        }
    }

    public void down() {
        ++this.yIndex;
        if (this.yIndex > 10 - this.elementHeight) {
            this.yIndex = 10 - this.elementHeight;
        }
    }

    public void explode() {
        if (!this.explode) {
            Config.soundExplode();
            this.explode = true;
            this.af.reset();
        }
    }

    public boolean hit() {
        --this.hitCounter;
        return this.hitCounter > 0;
    }

    public void animationFinished(AnimatedFragment f) {
        this.explode = false;
        Game.displayable.animationFinished();
        this.af.reset();
        if (this.hitCounter == 0) {
            Game.displayable.sm.remove(this);
        }
    }

    public void disappear(AnimatedFragment f) {
    }
}

