/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.bluetooth.L2CAPConnection;

public class RemoteObject
implements Runnable {
    L2CAPConnection connection;
    Thread runner;
    RemoteObjectListener listener;
    byte[] buffer;

    public RemoteObject(int i) {
        this.buffer = new byte[i];
    }

    public void start(L2CAPConnection c, RemoteObjectListener l) {
        this.connection = c;
        this.listener = l;
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void stop() {
        this.listener = null;
        this.runner = null;
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
        this.connection = null;
    }

    public void run() {
        while (this.runner == Thread.currentThread()) {
            try {
                int a = this.connection.receive(this.buffer);
                if (this.listener == null) continue;
                this.listener.receive(this.buffer, a);
            }
            catch (Exception iox) {
                if (this.listener != null) {
                    this.listener.remoteError("Connection Lost");
                }
                this.runner = null;
            }
        }
    }

    public void send(byte[] b) {
        block2: {
            if (this.connection == null) break block2;
            try {
                this.connection.send(b);
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }
}

