/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

class GameScreen
extends Canvas
implements Runnable {
    private static final int RAD_W = 32;
    private static final int RAD_H = 32;
    private static final int FIELD_W = 400;
    private static final int FIELD_H = 400;
    private static final int MAX_UNITS = 32;
    private static final int MAX_RESOURCES = 3;
    private static final int MAX_EXPLOSIONS = 32;
    private Random r = new Random();
    private Thread thread;
    private Graphics g;
    private Image[] tiles;
    private Image[] gdragon;
    private Image[] rdragon;
    private Image[] phoenix;
    private Image[] bphoenix;
    private Image forest;
    private Image lair;
    private Image volcano;
    private Image[] explosion;
    private Image font;
    private Image splash;
    private Image title;
    private Image cursor;
    private Image[] radImage;
    private Image waypoint;
    private Image img;
    private Image food;
    private Image[] icons;
    private byte[] map;
    private int loopcounter;
    private int action;
    private int gameState;
    private int mission;
    private int holdtheline;
    private int numlevels;
    private int cur;
    private int mcur;
    private int kcur;
    private int titleY;
    private int unitShown;
    private int radFrame;
    private int radFlag;
    private boolean UP_PRESSED;
    private boolean DOWN_PRESSED;
    private boolean LEFT_PRESSED;
    private boolean RIGHT_PRESSED;
    private int keyA;
    private int keyB;
    private int keyC;
    private int keyD;
    private int[] rHP;
    private int[] rX;
    private int[] rY;
    private int[] pRange;
    private int[] pType;
    private int[] pAtk;
    private int[] pSpd;
    private int[] pHP;
    private int[] pMaxHP;
    private int[] pAP;
    private int[] pX;
    private int[] pY;
    private int[] pXDest;
    private int[] pYDest;
    private int[] pFrame;
    private int[] pDirection;
    private boolean[] pChosen;
    private int pLairHP;
    private int pLairX;
    private int pLairY;
    private int resource;
    private int training;
    private int ptrained;
    private int numgdragons;
    private int bgX;
    private int bgY;
    private int curX;
    private int curY;
    private int[] bX;
    private int[] bY;
    private int[] bXDest;
    private int[] bYDest;
    private int[] bActive;
    private int[] eRange;
    private int[] eType;
    private int[] eAtk;
    private int[] eSpd;
    private int[] eHP;
    private int[] eMaxHP;
    private int[] eAP;
    private int[] eX;
    private int[] eY;
    private int[] eXDest;
    private int[] eYDest;
    private int[] eFrame;
    private int[] eDirection;
    private int eLairHP;
    private int eLairX;
    private int eLairY;
    private int eresource;
    private int etraining;
    private int etrained;
    private int numrdragons;
    private int eTrain;
    private int[] ebX;
    private int[] ebY;
    private int[] ebXDest;
    private int[] ebYDest;
    private int[] ebActive;
    private int[] explX = new int[32];
    private int[] explY = new int[32];
    private int[] expl = new int[32];

    public void LoadGame() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"numlevels", (boolean)true);
            try {
                if (recordStore.getNumRecords() == 0) {
                    this.numlevels = 1;
                    dataOutputStream.writeInt(this.numlevels);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    recordStore.addRecord(byArray, 0, byArray.length);
                } else {
                    byte[] byArray = recordStore.getRecord(1);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    this.numlevels = dataInputStream.readInt();
                    dataInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void SaveGame() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"numlevels", (boolean)true);
            try {
                if (recordStore.getNumRecords() == 0) {
                    this.numlevels = 1;
                    dataOutputStream.writeInt(this.numlevels);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    recordStore.addRecord(byArray, 0, byArray.length);
                } else {
                    if (this.numlevels < this.mission) {
                        this.numlevels = this.mission;
                    }
                    dataOutputStream.writeInt(this.numlevels);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void initGame() {
        int n;
        this.holdtheline = 3000;
        this.loopcounter = 0;
        this.action = 0;
        this.radFrame = 0;
        this.radFlag = 1;
        this.bgX = 0;
        this.bgY = 0;
        this.pRange = new int[32];
        this.pType = new int[32];
        this.pAtk = new int[32];
        this.pSpd = new int[32];
        this.pHP = new int[32];
        this.pMaxHP = new int[32];
        this.pAP = new int[32];
        this.pX = new int[32];
        this.pY = new int[32];
        this.pXDest = new int[32];
        this.pYDest = new int[32];
        this.pFrame = new int[32];
        this.pDirection = new int[32];
        this.pChosen = new boolean[32];
        this.bX = new int[32];
        this.bY = new int[32];
        this.bXDest = new int[32];
        this.bYDest = new int[32];
        this.bActive = new int[32];
        this.eRange = new int[32];
        this.eType = new int[32];
        this.eAtk = new int[32];
        this.eSpd = new int[32];
        this.eHP = new int[32];
        this.eMaxHP = new int[32];
        this.eAP = new int[32];
        this.eX = new int[32];
        this.eY = new int[32];
        this.eXDest = new int[32];
        this.eYDest = new int[32];
        this.eFrame = new int[32];
        this.eDirection = new int[32];
        this.ebX = new int[32];
        this.ebY = new int[32];
        this.ebXDest = new int[32];
        this.ebYDest = new int[32];
        this.ebActive = new int[32];
        this.rHP = new int[3];
        this.rX = new int[3];
        this.rY = new int[3];
        for (n = 0; n < 3; ++n) {
            this.rHP[n] = 10000;
            this.rX[n] = this.random(368);
            this.rY[n] = this.random(32) + n * 133;
        }
        this.pLairHP = 1000;
        this.pLairX = this.random(368);
        this.pLairY = this.random(200);
        this.ptrained = this.numgdragons = 2;
        for (n = 0; n < this.numgdragons; ++n) {
            this.pRange[n] = 64;
            this.pType[n] = 1;
            this.pAtk[n] = 10;
            this.pSpd[n] = 4;
            this.pMaxHP[n] = 100;
            this.pHP[n] = this.pMaxHP[n];
            this.pAP[n] = 0;
            this.pX[n] = this.pLairX + this.random(16);
            this.pY[n] = this.pLairY + this.random(16);
            this.pXDest[n] = this.nearestResourceX(this.pX[n], this.pY[n]) + 8;
            this.pYDest[n] = this.nearestResourceY(this.pX[n], this.pY[n]) + 8;
            this.pFrame[n] = 0;
            this.pDirection[n] = 0;
            this.pChosen[n] = false;
            this.bActive[n] = 0;
        }
        this.eLairHP = this.mission == 1 ? 0 : 1000;
        this.eLairX = this.random(368);
        this.eLairY = this.random(168) + 200;
        this.numrdragons = this.mission == 1 ? 3 : 4;
        this.etrained = this.numrdragons;
        for (n = 0; n < this.numrdragons; ++n) {
            if (n < 3) {
                this.eRange[n] = 64;
                this.eType[n] = 1;
                this.eAtk[n] = 10;
                this.eSpd[n] = 4;
                this.eMaxHP[n] = 100;
                this.eHP[n] = this.eMaxHP[n];
                this.eAP[n] = 0;
                this.eX[n] = this.eLairX + this.random(16);
                this.eY[n] = this.eLairY + this.random(16);
                this.eXDest[n] = this.nearestResourceX(this.eX[n], this.eY[n]) + 8;
                this.eYDest[n] = this.nearestResourceY(this.eX[n], this.eY[n]) + 8;
                this.eFrame[n] = 0;
                this.eDirection[n] = 0;
                this.ebActive[n] = 0;
                continue;
            }
            this.eRange[n] = 128;
            this.eType[n] = 2;
            this.eAtk[n] = 5;
            this.eSpd[n] = 16;
            this.eMaxHP[n] = 130;
            this.eHP[n] = this.eMaxHP[n];
            this.eAP[n] = 0;
            this.eX[n] = this.eLairX + this.random(16);
            this.eY[n] = this.eLairY + this.random(16);
            this.eXDest[n] = this.random(384);
            this.eYDest[n] = this.random(384);
            this.eFrame[n] = 0;
            this.eDirection[n] = 0;
            this.ebActive[n] = 0;
        }
        this.curX = this.getWidth() / 2;
        this.curY = this.getHeight() / 2;
        this.resource = 0;
        this.eresource = 0;
        this.training = 0;
        this.etraining = 0;
        for (n = 0; n < 32; ++n) {
            this.expl[n] = 0;
        }
    }

    public GameScreen() {
        try {
            int n;
            int n2;
            this.waypoint = Image.createImage((String)"/waypoint.png");
            this.food = Image.createImage((String)"/food.png");
            this.icons = new Image[3];
            for (n2 = 0; n2 < 3; ++n2) {
                this.icons[n2] = Image.createImage((String)("/unit" + n2 + ".png"));
            }
            this.radImage = new Image[9];
            for (n2 = 0; n2 < 9; ++n2) {
                this.radImage[n2] = Image.createImage((String)("/radar" + n2 + ".png"));
            }
            InputStream inputStream = this.getClass().getResourceAsStream("/map.bin");
            this.map = new byte[625];
            inputStream.read(this.map, 0, 625);
            inputStream.close();
            this.tiles = new Image[4];
            for (n = 0; n < 4; ++n) {
                this.tiles[n] = Image.createImage((String)("/tiles" + n + ".png"));
            }
            this.gdragon = new Image[8];
            this.rdragon = new Image[8];
            this.phoenix = new Image[8];
            this.bphoenix = new Image[8];
            this.explosion = new Image[8];
            for (n = 0; n < 8; ++n) {
                this.gdragon[n] = Image.createImage((String)("/salamander" + n + ".png"));
                this.rdragon[n] = Image.createImage((String)("/rdragon" + n + ".png"));
                this.phoenix[n] = Image.createImage((String)("/phoenix" + n + ".png"));
                this.bphoenix[n] = Image.createImage((String)("/bphoenix" + n + ".png"));
                this.explosion[n] = Image.createImage((String)("/explosion" + n + ".png"));
            }
            this.forest = Image.createImage((String)"/forest.png");
            this.lair = Image.createImage((String)"/cave.png");
            this.volcano = Image.createImage((String)"/volcano.png");
            this.cursor = Image.createImage((String)"/pointer.png");
            this.font = Image.createImage((String)"/font5.png");
            this.splash = Image.createImage((String)"/gamezone_100x64.png");
            this.title = Image.createImage((String)"/title_shaded.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.gameState = 0;
        this.mission = 1;
        this.cur = 0;
        this.mcur = 0;
        this.kcur = 0;
        this.titleY = this.getHeight();
        this.unitShown = 0;
        this.eTrain = 1;
        this.keyA = 49;
        this.keyB = 51;
        this.keyC = 55;
        this.keyD = 57;
        this.UP_PRESSED = false;
        this.DOWN_PRESSED = false;
        this.LEFT_PRESSED = false;
        this.RIGHT_PRESSED = false;
        this.img = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.g = this.img.getGraphics();
        this.g.setFont(Font.getFont((int)64, (int)0, (int)8));
        this.LoadGame();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.img, 0, 0, 4 | 0x10);
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (this.gameState) {
            case 0: {
                if (n2 == 1 && --this.cur < 0) {
                    this.cur = 2;
                } else if (n2 == 6 && ++this.cur > 2) {
                    this.cur = 0;
                }
                if (n2 != 8) break;
                switch (this.cur) {
                    case 0: {
                        this.gameState = 1;
                        break;
                    }
                    case 1: {
                        this.gameState = 5;
                        break;
                    }
                    case 2: {
                        this.gameState = 6;
                    }
                }
                break;
            }
            case 1: {
                if (n2 == 1 && --this.mcur < 0) {
                    this.mcur = this.numlevels - 1;
                } else if (n2 == 6 && ++this.mcur > this.numlevels - 1) {
                    this.mcur = 0;
                }
                if (n2 != 8) break;
                this.mission = this.mcur + 1;
                this.gameState = 2;
                break;
            }
            case 2: {
                if (n2 != 8) break;
                this.gameState = 3;
                this.initGame();
                break;
            }
            case 3: {
                if (n2 == 1) {
                    this.UP_PRESSED = true;
                } else if (n2 == 6) {
                    this.DOWN_PRESSED = true;
                }
                if (n2 == 2) {
                    this.LEFT_PRESSED = true;
                } else if (n2 == 5) {
                    this.RIGHT_PRESSED = true;
                }
                if (n2 == 8) {
                    this.action = 1;
                }
                if (n == this.keyA) {
                    this.action = 2;
                }
                if (n == this.keyB) {
                    this.action = 3;
                }
                if (n == this.keyC && this.training == 0 && ++this.unitShown > 2) {
                    this.unitShown = 0;
                }
                if (n != this.keyD) break;
                if (this.numgdragons < 32 && this.training == 0 && this.resource >= this.unitShown * 100 && this.pLairHP > 0) {
                    this.training = this.unitShown * 100;
                    this.radFlag = 0;
                    break;
                }
                if (this.training <= 0) break;
                this.training = 0;
                this.radFlag = 1;
                break;
            }
            case 4: {
                if (n2 != 8) break;
                if (this.pLairHP == 0 && this.numgdragons == 0) {
                    this.gameState = 8;
                    break;
                }
                if (++this.mission > 1) {
                    this.gameState = 7;
                    this.mission = 1;
                    break;
                }
                this.gameState = 2;
                this.SaveGame();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (n2 != 8) break;
                this.gameState = 0;
            }
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        if (n2 == 1) {
            this.UP_PRESSED = false;
        } else if (n2 == 6) {
            this.DOWN_PRESSED = false;
        }
        if (n2 == 2) {
            this.LEFT_PRESSED = false;
        } else if (n2 == 5) {
            this.RIGHT_PRESSED = false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block43: while (true) {
            if (this.gameState == 0) {
                this.g.setColor(0, 0, 0);
                this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.g.setColor(0, 255, 0);
                if (this.titleY > this.getHeight() - 27) {
                    this.titleY -= 2;
                    this.g.drawImage(this.splash, (this.getWidth() - this.splash.getWidth()) / 2, (this.getHeight() - this.splash.getHeight()) / 2, 4 | 16);
                    if (this.titleY <= this.getHeight() - 27) {
                        try {
                            this.splash = Image.createImage((String)"/splash.png");
                        }
                        catch (IOException var7_5) {}
                    }
                } else if (this.titleY > 12) {
                    this.titleY -= 2;
                    this.g.drawImage(this.splash, (this.getWidth() - this.splash.getWidth()) / 2, (this.getHeight() - this.splash.getHeight()) / 2, 4 | 16);
                    this.g.drawImage(this.title, (this.getWidth() - this.title.getWidth()) / 2, this.titleY, 4 | 16);
                    if (this.titleY <= 12) {
                        this.splash = null;
                    }
                } else {
                    var7_6 = new String[]{"START GAME", "VIEW CONTROLS", "VIEW GAME INFO"};
                    this.g.drawImage(this.title, (this.getWidth() - this.title.getWidth()) / 2, this.titleY, 4 | 16);
                    for (var8_15 = 0; var8_15 < 3; ++var8_15) {
                        if (var8_15 == this.cur) {
                            this.g.setColor(255, 0, 0);
                            this.g.fillRect(this.getWidth() / 2 - 25, 64 + var8_15 * 12, Font.getDefaultFont().stringWidth(var7_6[var8_15]), Font.getDefaultFont().getHeight());
                            this.g.setColor(0, 255, 0);
                        }
                        this.g.drawString(var7_6[var8_15], this.getWidth() / 2 - 25, 64 + var8_15 * 12, 4 | 16);
                    }
                }
                this.repaint();
                try {
                    Thread.sleep(60L);
                }
                catch (InterruptedException var7_7) {}
                continue;
            }
            while (this.gameState == 1) {
                var7_8 = new String[]{"GATHER 1000 RESOURCES", "TRAIN 12 UNITS", "DEFEND OUR LAIR", "ELIMINATE ALL ENEMIES"};
                this.g.setColor(0, 0, 0);
                this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.g.setColor(0, 255, 0);
                this.g.drawString("SELECT MISSION", 0, 0, 4 | 16);
                for (var8_16 = 0; var8_16 < 4; ++var8_16) {
                    if (var8_16 == this.mcur) {
                        this.g.setColor(255, 0, 0);
                        this.g.fillRect(0, 24 + var8_16 * 12, Font.getDefaultFont().stringWidth(var7_8[var8_16]), Font.getDefaultFont().getHeight());
                        this.g.setColor(0, 255, 0);
                    }
                    if (var8_16 >= this.numlevels) continue;
                    this.g.drawString(var7_8[var8_16], 0, 24 + var8_16 * 12, 4 | 16);
                }
                this.repaint();
                try {
                    Thread.sleep(60L);
                }
                catch (InterruptedException var8_17) {}
            }
            while (this.gameState == 2) {
                this.g.setColor(0, 0, 0);
                this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.g.setColor(0, 255, 0);
                this.g.drawString("MISSION " + this.mission, this.getWidth() / 2 - 22, 0, 4 | 16);
                this.g.drawString("BRIEFING:", 0, 12, 4 | 16);
                this.g.drawString("OBJECTIVE:", 0, 72, 4 | 16);
                switch (this.mission) {
                    case 1: {
                        this.g.drawString("Welcome to Age Of Dragons!", 0, 24, 4 | 16);
                        this.g.drawString("This is your first mission,", 0, 36, 4 | 16);
                        this.g.drawString("complete the objectives to", 0, 48, 4 | 16);
                        this.g.drawString("move in the next mission.", 0, 60, 4 | 16);
                        this.g.drawString("- Gather 1000 resources.", 0, 84, 4 | 16);
                        break;
                    }
                    case 2: {
                        this.g.drawString("Good work, brood! But the", 0, 24, 4 | 16);
                        this.g.drawString("enemies are moving very", 0, 36, 4 | 16);
                        this.g.drawString("fast, you must build your", 0, 48, 4 | 16);
                        this.g.drawString("forces immediately.", 0, 60, 4 | 16);
                        this.g.drawString("- Train 12 units.", 0, 84, 4 | 16);
                        break;
                    }
                    case 3: {
                        this.g.drawString("The enemies are getting", 0, 24, 4 | 16);
                        this.g.drawString("ready to attack you. You", 0, 36, 4 | 16);
                        this.g.drawString("should hold your forces", 0, 48, 4 | 16);
                        this.g.drawString("until their attacks calms.", 0, 60, 4 | 16);
                        this.g.drawString("- Defend our lair.", 0, 84, 4 | 16);
                        break;
                    }
                    case 4: {
                        this.g.drawString("This is the final mission.", 0, 24, 4 | 16);
                        this.g.drawString("You should use all the", 0, 36, 4 | 16);
                        this.g.drawString("skills you learned to", 0, 48, 4 | 16);
                        this.g.drawString("finish the enemies.", 0, 60, 4 | 16);
                        this.g.drawString("- Eliminate all enemies.", 0, 84, 4 | 16);
                        break;
                    }
                }
                this.repaint();
                while (this.gameState == 2) {
                }
            }
            while (true) {
                block188: {
                    block196: {
                        block189: {
                            block195: {
                                block193: {
                                    block194: {
                                        block192: {
                                            block190: {
                                                block191: {
                                                    if (this.gameState != 3) break block189;
                                                    if (!this.UP_PRESSED) break block190;
                                                    if (this.curY <= 0) break block191;
                                                    this.curY -= 4;
                                                    break block192;
                                                }
                                                if (this.bgY < 0) {
                                                    this.bgY += 4;
                                                    this.pLairY += 4;
                                                    this.eLairY += 4;
                                                    var7_9 = 0;
                                                    while (var7_9 < 3) {
                                                        v0 = var7_9++;
                                                        this.rY[v0] = this.rY[v0] + 4;
                                                    }
                                                    var7_9 = 0;
                                                    while (var7_9 < 32) {
                                                        v1 = var7_9;
                                                        this.pY[v1] = this.pY[v1] + 4;
                                                        v2 = var7_9;
                                                        this.pYDest[v2] = this.pYDest[v2] + 4;
                                                        v3 = var7_9;
                                                        this.bY[v3] = this.bY[v3] + 4;
                                                        v4 = var7_9;
                                                        this.bYDest[v4] = this.bYDest[v4] + 4;
                                                        v5 = var7_9;
                                                        this.eY[v5] = this.eY[v5] + 4;
                                                        v6 = var7_9;
                                                        this.eYDest[v6] = this.eYDest[v6] + 4;
                                                        v7 = var7_9;
                                                        this.ebY[v7] = this.ebY[v7] + 4;
                                                        v8 = var7_9;
                                                        this.ebYDest[v8] = this.ebYDest[v8] + 4;
                                                        v9 = var7_9++;
                                                        this.explY[v9] = this.explY[v9] + 4;
                                                    }
                                                }
                                                break block192;
                                            }
                                            if (this.DOWN_PRESSED) {
                                                if (this.curY < this.getHeight() - 8) {
                                                    this.curY += 4;
                                                } else if (this.bgY > this.getHeight() - 400) {
                                                    this.bgY -= 4;
                                                    this.pLairY -= 4;
                                                    this.eLairY -= 4;
                                                    var7_10 = 0;
                                                    while (var7_10 < 3) {
                                                        v10 = var7_10++;
                                                        this.rY[v10] = this.rY[v10] - 4;
                                                    }
                                                    var7_10 = 0;
                                                    while (var7_10 < 32) {
                                                        v11 = var7_10;
                                                        this.pY[v11] = this.pY[v11] - 4;
                                                        v12 = var7_10;
                                                        this.pYDest[v12] = this.pYDest[v12] - 4;
                                                        v13 = var7_10;
                                                        this.bY[v13] = this.bY[v13] - 4;
                                                        v14 = var7_10;
                                                        this.bYDest[v14] = this.bYDest[v14] - 4;
                                                        v15 = var7_10;
                                                        this.eY[v15] = this.eY[v15] - 4;
                                                        v16 = var7_10;
                                                        this.eYDest[v16] = this.eYDest[v16] - 4;
                                                        v17 = var7_10;
                                                        this.ebY[v17] = this.ebY[v17] - 4;
                                                        v18 = var7_10;
                                                        this.ebYDest[v18] = this.ebYDest[v18] - 4;
                                                        v19 = var7_10++;
                                                        this.explY[v19] = this.explY[v19] - 4;
                                                    }
                                                }
                                            }
                                        }
                                        if (!this.LEFT_PRESSED) break block193;
                                        if (this.curX <= 0) break block194;
                                        this.curX -= 4;
                                        break block195;
                                    }
                                    if (this.bgX < 0) {
                                        this.bgX += 4;
                                        this.pLairX += 4;
                                        this.eLairX += 4;
                                        var7_11 = 0;
                                        while (var7_11 < 3) {
                                            v20 = var7_11++;
                                            this.rX[v20] = this.rX[v20] + 4;
                                        }
                                        var7_11 = 0;
                                        while (var7_11 < 32) {
                                            v21 = var7_11;
                                            this.pX[v21] = this.pX[v21] + 4;
                                            v22 = var7_11;
                                            this.pXDest[v22] = this.pXDest[v22] + 4;
                                            v23 = var7_11;
                                            this.bX[v23] = this.bX[v23] + 4;
                                            v24 = var7_11;
                                            this.bXDest[v24] = this.bXDest[v24] + 4;
                                            v25 = var7_11;
                                            this.eX[v25] = this.eX[v25] + 4;
                                            v26 = var7_11;
                                            this.eXDest[v26] = this.eXDest[v26] + 4;
                                            v27 = var7_11;
                                            this.ebX[v27] = this.ebX[v27] + 4;
                                            v28 = var7_11;
                                            this.ebXDest[v28] = this.ebXDest[v28] + 4;
                                            v29 = var7_11++;
                                            this.explX[v29] = this.explX[v29] + 4;
                                        }
                                    }
                                    break block195;
                                }
                                if (this.RIGHT_PRESSED) {
                                    if (this.curX < this.getWidth() - 8) {
                                        this.curX += 4;
                                    } else if (this.bgX > this.getWidth() - 400) {
                                        this.bgX -= 4;
                                        this.pLairX -= 4;
                                        this.eLairX -= 4;
                                        var7_12 = 0;
                                        while (var7_12 < 3) {
                                            v30 = var7_12++;
                                            this.rX[v30] = this.rX[v30] - 4;
                                        }
                                        var7_12 = 0;
                                        while (var7_12 < 32) {
                                            v31 = var7_12;
                                            this.pX[v31] = this.pX[v31] - 4;
                                            v32 = var7_12;
                                            this.pXDest[v32] = this.pXDest[v32] - 4;
                                            v33 = var7_12;
                                            this.bX[v33] = this.bX[v33] - 4;
                                            v34 = var7_12;
                                            this.bXDest[v34] = this.bXDest[v34] - 4;
                                            v35 = var7_12;
                                            this.eX[v35] = this.eX[v35] - 4;
                                            v36 = var7_12;
                                            this.eXDest[v36] = this.eXDest[v36] - 4;
                                            v37 = var7_12;
                                            this.ebX[v37] = this.ebX[v37] - 4;
                                            v38 = var7_12;
                                            this.ebXDest[v38] = this.ebXDest[v38] - 4;
                                            v39 = var7_12++;
                                            this.explX[v39] = this.explX[v39] - 4;
                                        }
                                    }
                                }
                            }
                            ++this.loopcounter;
                            for (var7_13 = 0; var7_13 < 625; ++var7_13) {
                                this.g.drawImage(this.tiles[this.map[var7_13]], var7_13 % 25 * 16 + this.bgX, var7_13 / 25 * 16 + this.bgY, 4 | 16);
                            }
                            if (this.pLairHP > 0) {
                                if (this.pLairHP < 500) {
                                    ++this.pLairHP;
                                }
                                this.g.drawImage(this.lair, this.pLairX, this.pLairY, 4 | 16);
                                if (this.collision(this.pLairX, this.pLairY, 32, 32, this.curX, this.curY, 8, 8)) {
                                    this.g.fillRect(this.pLairX, this.pLairY - 6, 32 * this.pLairHP / 1000, 3);
                                    if (this.training > 0) {
                                        this.g.setColor(0, 0, 255);
                                        this.g.fillRect(this.pLairX, this.pLairY - 4, 32 * this.training / (this.unitShown * 100), 3);
                                    }
                                    this.g.setColor(0, 0, 0);
                                    this.g.drawRect(this.pLairX, this.pLairY - 6, 32, 3);
                                    this.g.drawRect(this.pLairX, this.pLairY - 4, 32, 3);
                                    this.g.setColor(0, 255, 0);
                                }
                                this.g.fillRect(32 * (this.pLairX - this.bgX) / 400, 32 * (this.pLairY - this.bgY) / 400, 2, 2);
                            }
                            if (this.eLairHP > 0) {
                                if (this.eLairHP < 500) {
                                    ++this.eLairHP;
                                }
                                this.g.drawImage(this.volcano, this.eLairX, this.eLairY, 4 | 16);
                                if (this.collision(this.eLairX, this.eLairY, 32, 32, this.curX, this.curY, 8, 8)) {
                                    this.g.fillRect(this.eLairX, this.eLairY - 6, 32 * this.eLairHP / 1000, 3);
                                    this.g.setColor(0, 0, 255);
                                    this.g.fillRect(this.eLairX, this.eLairY - 4, 32 * this.etraining / (this.eTrain * 100), 3);
                                    this.g.setColor(0, 0, 0);
                                    this.g.drawRect(this.eLairX, this.eLairY - 6, 32, 3);
                                    this.g.drawRect(this.eLairX, this.eLairY - 4, 32, 3);
                                    this.g.setColor(0, 255, 0);
                                }
                                this.g.setColor(255, 0, 0);
                                this.g.fillRect(32 * (this.eLairX - this.bgX) / 400, 32 * (this.eLairY - this.bgY) / 400, 2, 2);
                                this.g.setColor(0, 255, 0);
                            }
                            for (var7_13 = 0; var7_13 < 3; ++var7_13) {
                                this.g.drawImage(this.forest, this.rX[var7_13], this.rY[var7_13], 4 | 16);
                                if (this.collision(this.rX[var7_13], this.rY[var7_13], 32, 32, this.curX, this.curY, 8, 8)) {
                                    this.g.fillRect(this.rX[var7_13], this.rY[var7_13] - 4, 32 * this.rHP[var7_13] / 10000, 3);
                                    this.g.setColor(0, 0, 0);
                                    this.g.drawRect(this.rX[var7_13], this.rY[var7_13] - 4, 32, 3);
                                }
                                this.g.setColor(255, 255, 0);
                                this.g.fillRect(32 * (this.rX[var7_13] - this.bgX) / 400, 32 * (this.rY[var7_13] - this.bgY) / 400, 2, 2);
                                this.g.setColor(0, 255, 0);
                            }
                            var7_13 = 0;
                            break block196;
                        }
                        while (this.gameState == 4) {
                            this.g.setColor(0, 0, 0);
                            this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            this.g.setColor(0, 255, 0);
                            this.g.drawString("AFTERMATH", this.getWidth() / 2 - 22, 0, 4 | 16);
                            this.g.drawString("TRAINED", 32, 12, 4 | 16);
                            this.g.drawString("CASUALITIES", 80, 12, 4 | 16);
                            this.g.drawString("PLAYER", 0, 24, 4 | 16);
                            this.g.drawString("" + this.ptrained, 32, 24, 4 | 16);
                            this.g.drawString("" + (this.ptrained - this.numgdragons), 80, 24, 4 | 16);
                            this.g.drawString("ENEMY", 0, 36, 4 | 16);
                            this.g.drawString("" + this.etrained, 32, 36, 4 | 16);
                            this.g.drawString("" + (this.etrained - this.numrdragons), 80, 36, 4 | 16);
                            this.repaint();
                            while (this.gameState == 4) {
                            }
                        }
                        while (this.gameState == 5) {
                            this.g.setColor(0, 0, 0);
                            this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            this.g.setColor(0, 255, 0);
                            this.g.drawString("GAME CONTROLS", 0, 0, 4 | 16);
                            this.g.drawString("UP-move pointer up", 0, 12, 4 | 16);
                            this.g.drawString("DOWN-move pointer down", 0, 24, 4 | 16);
                            this.g.drawString("LEFT-move pointer left", 0, 36, 4 | 16);
                            this.g.drawString("RIGHT-move pointer right", 0, 48, 4 | 16);
                            this.g.drawString("FIRE-select unit", 0, 60, 4 | 16);
                            this.g.drawString((char)this.keyA + "-deselect all units ", 0, 72, 4 | 16);
                            this.g.drawString((char)this.keyB + "-select all units   ", 0, 84, 4 | 16);
                            this.g.drawString((char)this.keyC + "-toggle unit        ", 0, 96, 4 | 16);
                            this.g.drawString((char)this.keyD + "-train/cancel       ", 0, 108, 4 | 16);
                            this.repaint();
                            while (this.gameState == 5) {
                            }
                        }
                        while (this.gameState == 6) {
                            this.g.setColor(0, 0, 0);
                            this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            this.g.setColor(0, 255, 0);
                            this.g.drawString("GAME INFO", 0, 0, 4 | 16);
                            this.g.drawString("Coded by: Gener Gabasa", 0, 12, 4 | 16);
                            this.g.drawString("genergabasa@yahoo.com", 0, 24, 4 | 16);
                            this.g.drawString("+639279697357", 0, 36, 4 | 16);
                            this.g.drawString("COPYRIGHT 2005", 0, 48, 4 | 16);
                            this.g.drawString("ALL RIGHTS RESERVED", 0, 60, 4 | 16);
                            this.repaint();
                            while (this.gameState == 6) {
                            }
                        }
                        while (this.gameState == 7) {
                            this.g.setColor(0, 0, 0);
                            this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            this.g.setColor(0, 255, 0);
                            this.g.drawString("CONGRATULATIONS!", 0, 0, 4 | 16);
                            this.g.drawString("You eliminated all the", 0, 12, 4 | 16);
                            this.g.drawString("phoenixs. Finally,", 0, 24, 4 | 16);
                            this.g.drawString("your battle for", 0, 36, 4 | 16);
                            this.g.drawString("survival is victorious!", 0, 48, 4 | 16);
                            this.g.drawString("Thank you for playing!", 0, 60, 4 | 16);
                            this.repaint();
                            while (this.gameState == 7) {
                            }
                        }
                        block68: while (true) {
                            if (this.gameState == 8) ** break;
                            continue block43;
                            this.g.setColor(0, 0, 0);
                            this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            this.g.setColor(0, 255, 0);
                            this.g.drawString("GAME OVER!", 0, 0, 4 | 16);
                            this.g.drawString("You were defeated by", 0, 12, 4 | 16);
                            this.g.drawString("the ruthless phoenix.", 0, 24, 4 | 16);
                            this.g.drawString("And now, you watch", 0, 36, 4 | 16);
                            this.g.drawString("over your lair burn", 0, 48, 4 | 16);
                            this.g.drawString("into smitherins...", 0, 60, 4 | 16);
                            this.repaint();
                            while (true) {
                                if (this.gameState != 8) continue block68;
                            }
                            break;
                        }
                    }
                    while (true) {
                        block198: {
                            block199: {
                                block197: {
                                    if (var7_13 >= 32) break block197;
                                    if (this.pHP[var7_13] <= 0) break block198;
                                    if (this.loopcounter % 8 == 0) {
                                        v40 = var7_13;
                                        this.pFrame[v40] = this.pFrame[v40] + 1;
                                        if (this.pFrame[v40] > 1) {
                                            this.pFrame[var7_13] = 0;
                                        }
                                    }
                                    if (this.pY[var7_13] > this.pYDest[var7_13]) {
                                        this.pDirection[var7_13] = 0;
                                        v41 = var7_13;
                                        this.pY[v41] = this.pY[v41] - 1;
                                        if (this.pY[var7_13] < this.pYDest[var7_13]) {
                                            this.pY[var7_13] = this.pYDest[var7_13];
                                        }
                                    } else if (this.pY[var7_13] < this.pYDest[var7_13]) {
                                        this.pDirection[var7_13] = 2;
                                        v42 = var7_13;
                                        this.pY[v42] = this.pY[v42] + 1;
                                        if (this.pY[var7_13] > this.pYDest[var7_13]) {
                                            this.pY[var7_13] = this.pYDest[var7_13];
                                        }
                                    }
                                    if (this.pX[var7_13] > this.pXDest[var7_13]) {
                                        if (this.getDistance(this.pX[var7_13], this.pXDest[var7_13]) > this.getDistance(this.pY[var7_13], this.pYDest[var7_13])) {
                                            this.pDirection[var7_13] = 3;
                                        }
                                        v43 = var7_13;
                                        this.pX[v43] = this.pX[v43] - 1;
                                        if (this.pX[var7_13] < this.pXDest[var7_13]) {
                                            this.pX[var7_13] = this.pXDest[var7_13];
                                        }
                                    } else if (this.pX[var7_13] < this.pXDest[var7_13]) {
                                        if (this.getDistance(this.pX[var7_13], this.pXDest[var7_13]) > this.getDistance(this.pY[var7_13], this.pYDest[var7_13])) {
                                            this.pDirection[var7_13] = 1;
                                        }
                                        v44 = var7_13;
                                        this.pX[v44] = this.pX[v44] + 1;
                                        if (this.pX[var7_13] > this.pXDest[var7_13]) {
                                            this.pX[var7_13] = this.pXDest[var7_13];
                                        }
                                    }
                                    switch (this.pType[var7_13]) {
                                        case 1: {
                                            this.g.drawImage(this.gdragon[this.pFrame[var7_13] * 4 + this.pDirection[var7_13]], this.pX[var7_13], this.pY[var7_13], 4 | 16);
                                            break;
                                        }
                                        case 2: {
                                            this.g.drawImage(this.rdragon[this.pFrame[var7_13] * 4 + this.pDirection[var7_13]], this.pX[var7_13], this.pY[var7_13], 4 | 16);
                                            break;
                                        }
                                    }
                                    this.g.fillRect(32 * (this.pX[var7_13] - this.bgX) / 400, 32 * (this.pY[var7_13] - this.bgY) / 400, 1, 1);
                                    if (this.collision(this.curX, this.curY, 8, 8, this.pX[var7_13], this.pY[var7_13], 16, 16)) {
                                        this.g.fillRect(this.pX[var7_13], this.pY[var7_13] - 6, 16 * this.pHP[var7_13] / this.pMaxHP[var7_13], 3);
                                        this.g.setColor(0, 0, 255);
                                        this.g.fillRect(this.pX[var7_13], this.pY[var7_13] - 4, 16 * this.pAP[var7_13] / 50, 3);
                                        this.g.setColor(0, 0, 0);
                                        this.g.drawRect(this.pX[var7_13], this.pY[var7_13] - 6, 16, 3);
                                        this.g.drawRect(this.pX[var7_13], this.pY[var7_13] - 4, 16, 3);
                                        this.g.setColor(0, 255, 0);
                                        if (this.action == 1 && !this.pChosen[var7_13]) {
                                            this.pChosen[var7_13] = true;
                                            this.action = 0;
                                        }
                                    }
                                    if (this.action == 1 && this.pChosen[var7_13]) {
                                        this.pXDest[var7_13] = this.curX;
                                        this.pYDest[var7_13] = this.curY;
                                    }
                                    if (this.action == 2) {
                                        this.pChosen[var7_13] = false;
                                    }
                                    if (this.action == 3) {
                                        this.pChosen[var7_13] = true;
                                    }
                                    this.g.setColor(0, 255, 0);
                                    if (this.pChosen[var7_13]) {
                                        this.g.drawRoundRect(this.pX[var7_13], this.pY[var7_13], 16, 16, 16, 16);
                                        this.g.fillRect(this.pX[var7_13], this.pY[var7_13] - 6, 16 * this.pHP[var7_13] / this.pMaxHP[var7_13], 3);
                                        this.g.setColor(0, 0, 255);
                                        this.g.fillRect(this.pX[var7_13], this.pY[var7_13] - 4, 16 * this.pAP[var7_13] / 50, 3);
                                        this.g.setColor(0, 0, 0);
                                        this.g.drawRect(this.pX[var7_13], this.pY[var7_13] - 6, 16, 3);
                                        this.g.drawRect(this.pX[var7_13], this.pY[var7_13] - 4, 16, 3);
                                        this.g.setColor(0, 255, 0);
                                        this.g.drawImage(this.waypoint, this.pXDest[var7_13], this.pYDest[var7_13], 4 | 16);
                                    }
                                    switch (this.pType[var7_13]) {
                                        case 1: {
                                            if (this.pX[var7_13] != this.pXDest[var7_13] || this.pY[var7_13] != this.pYDest[var7_13]) break;
                                            for (var8_18 = 0; var8_18 < 3; ++var8_18) {
                                                if (!this.collision(this.pX[var7_13], this.pY[var7_13], 16, 16, this.rX[var8_18], this.rY[var8_18], 32, 32)) continue;
                                                if (this.pAP[var7_13] < 50 && this.rHP[var8_18] > 0) {
                                                    v45 = var7_13;
                                                    this.pAP[v45] = this.pAP[v45] + 1;
                                                    v46 = var8_18;
                                                    this.rHP[v46] = this.rHP[v46] - 1;
                                                }
                                                if (this.pAP[var7_13] != 50 && (this.rHP[var8_18] != 0 || this.pLairHP <= 0)) continue;
                                                this.pXDest[var7_13] = this.pLairX;
                                                this.pYDest[var7_13] = this.pLairY + 16;
                                            }
                                            if (!this.collision(this.pX[var7_13], this.pY[var7_13], 16, 16, this.pLairX, this.pLairY, 32, 32) || this.pLairHP <= 0) break;
                                            if (this.pAP[var7_13] > 0) {
                                                v47 = var7_13;
                                                this.pAP[v47] = this.pAP[v47] - 1;
                                                ++this.resource;
                                                break;
                                            }
                                            this.pXDest[var7_13] = this.nearestResourceX(this.pX[var7_13], this.pY[var7_13]) + this.random(16);
                                            this.pYDest[var7_13] = this.nearestResourceY(this.pX[var7_13], this.pY[var7_13]) + this.random(16);
                                            break;
                                        }
                                    }
                                    if (this.getRange(this.pX[var7_13], this.pY[var7_13], this.eLairX, this.eLairY) >= this.pRange[var7_13] || this.eLairHP <= 0 || this.bActive[var7_13] != 0) break block199;
                                    this.bX[var7_13] = this.pX[var7_13] + 8;
                                    this.bY[var7_13] = this.pY[var7_13] + 8;
                                    this.bXDest[var7_13] = this.eLairX + this.random(32);
                                    this.bYDest[var7_13] = this.eLairY + this.random(32);
                                    this.bActive[var7_13] = this.pRange[var7_13] / 2;
                                    break block199;
                                }
                                this.g.drawImage(this.radImage[this.radFrame], this.getWidth() - 32, 0, 4 | 16);
                                if (this.radFlag == 0 && this.radFrame < 8) {
                                    ++this.radFrame;
                                }
                                if (this.radFlag == 1 && this.radFrame > 0) {
                                    --this.radFrame;
                                }
                                if (this.training <= 0) break block188;
                                --this.training;
                                this.g.fillRect(this.getWidth() - 32, 36, 32 - 32 * this.training / (this.unitShown * 100), 3);
                                this.g.setColor(0, 0, 0);
                                this.g.drawRect(this.getWidth() - 32, 36, 32, 3);
                                this.g.setColor(0, 255, 0);
                                if (this.training == 0) {
                                    this.radFlag = 1;
                                    this.resource -= this.unitShown * 100;
                                    ++this.numgdragons;
                                    break;
                                }
                                break block188;
                            }
                            for (var8_18 = 0; var8_18 < 32; ++var8_18) {
                                if (this.getRange(this.pX[var7_13], this.pY[var7_13], this.eX[var8_18], this.eY[var8_18]) >= this.pRange[var7_13] || this.eHP[var8_18] <= 0 || this.bActive[var7_13] != 0) continue;
                                this.bX[var7_13] = this.pX[var7_13] + 8;
                                this.bY[var7_13] = this.pY[var7_13] + 8;
                                this.bXDest[var7_13] = this.eX[var8_18] + this.random(16);
                                this.bYDest[var7_13] = this.eY[var8_18] + this.random(16);
                                this.bActive[var7_13] = this.pRange[var7_13] / 2;
                                break;
                            }
                        }
                        if (this.bActive[var7_13] > 0) {
                            v48 = var7_13;
                            this.bActive[v48] = this.bActive[v48] - 1;
                            var1_1 = this.getDistance(this.bX[var7_13], this.bXDest[var7_13]) + 1;
                            var2_2 = this.getDistance(this.bY[var7_13], this.bYDest[var7_13]);
                            var3_3 = this.pSpd[var7_13] * var1_1 / (var1_1 + var2_2);
                            var4_4 = this.pSpd[var7_13] * var2_2 / (var1_1 + var2_2);
                            if (this.bX[var7_13] > this.bXDest[var7_13]) {
                                v49 = var7_13;
                                this.bX[v49] = this.bX[v49] - var3_3;
                                if (this.bX[var7_13] < this.bXDest[var7_13]) {
                                    this.bX[var7_13] = this.bXDest[var7_13];
                                }
                            } else {
                                v50 = var7_13;
                                this.bX[v50] = this.bX[v50] + var3_3;
                                if (this.bX[var7_13] > this.bXDest[var7_13]) {
                                    this.bX[var7_13] = this.bXDest[var7_13];
                                }
                            }
                            if (this.bY[var7_13] > this.bYDest[var7_13]) {
                                v51 = var7_13;
                                this.bY[v51] = this.bY[v51] - var4_4;
                                if (this.bY[var7_13] < this.bYDest[var7_13]) {
                                    this.bY[var7_13] = this.bYDest[var7_13];
                                }
                            } else {
                                v52 = var7_13;
                                this.bY[v52] = this.bY[v52] + var4_4;
                                if (this.bY[var7_13] > this.bYDest[var7_13]) {
                                    this.bY[var7_13] = this.bYDest[var7_13];
                                }
                            }
                            if (this.bX[var7_13] == this.bXDest[var7_13] && this.bY[var7_13] == this.bYDest[var7_13]) {
                                for (var8_18 = 0; var8_18 < 32; ++var8_18) {
                                    if (!this.collision(this.bX[var7_13], this.bY[var7_13], 2, 2, this.eX[var8_18], this.eY[var8_18], 16, 16) || this.bActive[var7_13] <= 0 || this.eHP[var8_18] <= 0) continue;
                                    this.bActive[var7_13] = 0;
                                    v53 = var8_18;
                                    this.eHP[v53] = this.eHP[v53] - (this.random(3) + this.pAtk[var7_13]);
                                    if (this.eType[var8_18] == 1) {
                                        this.eXDest[var8_18] = this.eLairX + this.random(16);
                                        this.eYDest[var8_18] = this.eLairY + this.random(16);
                                    }
                                    if (this.eHP[var8_18] > 0) continue;
                                    this.eHP[var8_18] = 0;
                                    --this.numrdragons;
                                    this.initExplosions(this.eX[var8_18] - 8, this.eY[var8_18] - 8);
                                    System.out.println("Enemy unit destroyed!");
                                }
                                if (this.collision(this.bX[var7_13], this.bY[var7_13], 2, 2, this.eLairX, this.eLairY, 32, 32) && this.bActive[var7_13] > 0 && this.eLairHP > 0) {
                                    this.bActive[var7_13] = 0;
                                    this.eLairHP -= this.random(3) + this.pAtk[var7_13];
                                    if (this.eLairHP <= 0) {
                                        this.eLairHP = 0;
                                        this.initExplosions(this.eLairX + 8, this.eLairY + 8);
                                        System.out.println("Enemy lair destroyed!");
                                    }
                                }
                                this.initExplosions(this.bX[var7_13] - 14, this.bY[var7_13] - 14);
                                this.bActive[var7_13] = 0;
                            }
                            this.g.setColor(255, 255, 0);
                            this.g.fillRoundRect(this.bX[var7_13], this.bY[var7_13], 2, 2, 2, 2);
                            this.g.setColor(0, 255, 0);
                        }
                        if (this.eHP[var7_13] > 0) {
                            if (this.loopcounter % 8 == 0) {
                                v54 = var7_13;
                                this.eFrame[v54] = this.eFrame[v54] + 1;
                                if (this.eFrame[v54] > 1) {
                                    this.eFrame[var7_13] = 0;
                                }
                            }
                            if (this.eY[var7_13] > this.eYDest[var7_13]) {
                                this.eDirection[var7_13] = 0;
                                v55 = var7_13;
                                this.eY[v55] = this.eY[v55] - 1;
                                if (this.eY[var7_13] < this.eYDest[var7_13]) {
                                    this.eY[var7_13] = this.eYDest[var7_13];
                                }
                            } else if (this.eY[var7_13] < this.eYDest[var7_13]) {
                                this.eDirection[var7_13] = 2;
                                v56 = var7_13;
                                this.eY[v56] = this.eY[v56] + 1;
                                if (this.eY[var7_13] > this.eYDest[var7_13]) {
                                    this.eY[var7_13] = this.eYDest[var7_13];
                                }
                            }
                            if (this.eX[var7_13] > this.eXDest[var7_13]) {
                                if (this.getDistance(this.eX[var7_13], this.eXDest[var7_13]) > this.getDistance(this.eY[var7_13], this.eYDest[var7_13])) {
                                    this.eDirection[var7_13] = 3;
                                }
                                v57 = var7_13;
                                this.eX[v57] = this.eX[v57] - 1;
                                if (this.eX[var7_13] < this.eXDest[var7_13]) {
                                    this.eX[var7_13] = this.eXDest[var7_13];
                                }
                            } else if (this.eX[var7_13] < this.eXDest[var7_13]) {
                                if (this.getDistance(this.eX[var7_13], this.eXDest[var7_13]) > this.getDistance(this.eY[var7_13], this.eYDest[var7_13])) {
                                    this.eDirection[var7_13] = 1;
                                }
                                v58 = var7_13;
                                this.eX[v58] = this.eX[v58] + 1;
                                if (this.eX[var7_13] > this.eXDest[var7_13]) {
                                    this.eX[var7_13] = this.eXDest[var7_13];
                                }
                            }
                            switch (this.eType[var7_13]) {
                                case 1: {
                                    this.g.drawImage(this.phoenix[this.eFrame[var7_13] * 4 + this.eDirection[var7_13]], this.eX[var7_13], this.eY[var7_13], 4 | 16);
                                    break;
                                }
                                case 2: {
                                    this.g.drawImage(this.bphoenix[this.eFrame[var7_13] * 4 + this.eDirection[var7_13]], this.eX[var7_13], this.eY[var7_13], 4 | 16);
                                    break;
                                }
                            }
                            this.g.setColor(255, 0, 0);
                            this.g.fillRect(32 * (this.eX[var7_13] - this.bgX) / 400, 32 * (this.eY[var7_13] - this.bgY) / 400, 1, 1);
                            this.g.setColor(0, 255, 0);
                            if (this.collision(this.curX, this.curY, 8, 8, this.eX[var7_13], this.eY[var7_13], 16, 16)) {
                                this.g.fillRect(this.eX[var7_13], this.eY[var7_13] - 6, 16 * this.eHP[var7_13] / this.eMaxHP[var7_13], 3);
                                this.g.setColor(0, 0, 255);
                                this.g.fillRect(this.eX[var7_13], this.eY[var7_13] - 4, 16 * this.eAP[var7_13] / 50, 3);
                                this.g.setColor(0, 0, 0);
                                this.g.drawRect(this.eX[var7_13], this.eY[var7_13] - 6, 16, 3);
                                this.g.drawRect(this.eX[var7_13], this.eY[var7_13] - 4, 16, 3);
                                this.g.setColor(0, 255, 0);
                            }
                            if (this.eX[var7_13] == this.eXDest[var7_13] && this.eY[var7_13] == this.eYDest[var7_13]) {
                                switch (this.eType[var7_13]) {
                                    case 1: {
                                        for (var8_18 = 0; var8_18 < 3; ++var8_18) {
                                            if (!this.collision(this.eX[var7_13], this.eY[var7_13], 16, 16, this.rX[var8_18], this.rY[var8_18], 32, 32)) continue;
                                            if (this.eAP[var7_13] < 50 && this.rHP[var8_18] > 0) {
                                                v59 = var7_13;
                                                this.eAP[v59] = this.eAP[v59] + 1;
                                                v60 = var8_18;
                                                this.rHP[v60] = this.rHP[v60] - 1;
                                            }
                                            if (this.eAP[var7_13] != 50 && this.rHP[var8_18] != 0) continue;
                                            this.eXDest[var7_13] = this.eLairX;
                                            this.eYDest[var7_13] = this.eLairY;
                                        }
                                        if (!this.collision(this.eX[var7_13], this.eY[var7_13], 16, 16, this.eLairX, this.eLairY, 32, 32) || this.eLairHP <= 0) break;
                                        if (this.eAP[var7_13] > 0) {
                                            v61 = var7_13;
                                            this.eAP[v61] = this.eAP[v61] - 1;
                                            ++this.eresource;
                                            break;
                                        }
                                        this.eXDest[var7_13] = this.nearestResourceX(this.eX[var7_13], this.eY[var7_13]) + this.random(16);
                                        this.eYDest[var7_13] = this.nearestResourceY(this.eX[var7_13], this.eY[var7_13]) + this.random(16);
                                        break;
                                    }
                                    case 2: {
                                        if (this.numrdragons > 12) {
                                            this.eXDest[var7_13] = this.pLairX + this.random(16);
                                            this.eYDest[var7_13] = this.pLairY + this.random(16);
                                            break;
                                        }
                                        this.eXDest[var7_13] = this.random(16) + this.eLairX;
                                        this.eYDest[var7_13] = this.random(16) + this.eLairY;
                                        break;
                                    }
                                }
                                if (this.eLairHP == 0) {
                                    this.eXDest[var7_13] = this.random(384) + this.bgX;
                                    this.eYDest[var7_13] = this.random(384) + this.bgY;
                                }
                                if (this.numgdragons == 0) {
                                    this.eXDest[var7_13] = this.pLairX + this.random(16);
                                    this.eYDest[var7_13] = this.pLairY + this.random(16);
                                }
                            }
                            for (var8_18 = 0; var8_18 < 32; ++var8_18) {
                                if (this.getRange(this.eX[var7_13], this.eY[var7_13], this.pX[var8_18], this.pY[var8_18]) >= this.eRange[var7_13] || this.pHP[var8_18] <= 0 || this.ebActive[var7_13] != 0) continue;
                                this.ebX[var7_13] = this.eX[var7_13] + 8;
                                this.ebY[var7_13] = this.eY[var7_13] + 8;
                                this.ebXDest[var7_13] = this.pX[var8_18] + this.random(16);
                                this.ebYDest[var7_13] = this.pY[var8_18] + this.random(16);
                                this.ebActive[var7_13] = 30;
                                break;
                            }
                            if (this.getRange(this.eX[var7_13], this.eY[var7_13], this.pLairX, this.pLairY) < this.eRange[var7_13] && this.pLairHP > 0 && this.ebActive[var7_13] == 0) {
                                this.ebX[var7_13] = this.eX[var7_13] + 8;
                                this.ebY[var7_13] = this.eY[var7_13] + 8;
                                this.ebXDest[var7_13] = this.pLairX + this.random(32);
                                this.ebYDest[var7_13] = this.pLairY + this.random(32);
                                this.ebActive[var7_13] = 30;
                            }
                            if (this.pLairHP == 0) {
                                var8_18 = this.random(32);
                                while (this.numgdragons > 0 && this.pHP[var8_18] == 0) {
                                    var8_18 = this.random(32);
                                }
                                this.eXDest[var7_13] = this.pX[var8_18];
                                this.eYDest[var7_13] = this.pY[var8_18];
                            }
                        }
                        if (this.ebActive[var7_13] > 0) {
                            v62 = var7_13;
                            this.ebActive[v62] = this.ebActive[v62] - 1;
                            var1_1 = this.getDistance(this.ebX[var7_13], this.ebXDest[var7_13]) + 1;
                            var2_2 = this.getDistance(this.ebY[var7_13], this.ebYDest[var7_13]);
                            var3_3 = this.eSpd[var7_13] * var1_1 / (var1_1 + var2_2);
                            var4_4 = this.eSpd[var7_13] * var2_2 / (var1_1 + var2_2);
                            if (this.ebX[var7_13] > this.ebXDest[var7_13]) {
                                v63 = var7_13;
                                this.ebX[v63] = this.ebX[v63] - var3_3;
                                if (this.ebX[var7_13] < this.ebXDest[var7_13]) {
                                    this.ebX[var7_13] = this.ebXDest[var7_13];
                                }
                            } else {
                                v64 = var7_13;
                                this.ebX[v64] = this.ebX[v64] + var3_3;
                                if (this.ebX[var7_13] > this.ebXDest[var7_13]) {
                                    this.ebX[var7_13] = this.ebXDest[var7_13];
                                }
                            }
                            if (this.ebY[var7_13] > this.ebYDest[var7_13]) {
                                v65 = var7_13;
                                this.ebY[v65] = this.ebY[v65] - var4_4;
                                if (this.ebY[var7_13] < this.ebYDest[var7_13]) {
                                    this.ebY[var7_13] = this.ebYDest[var7_13];
                                }
                            } else {
                                v66 = var7_13;
                                this.ebY[v66] = this.ebY[v66] + var4_4;
                                if (this.ebY[var7_13] > this.ebYDest[var7_13]) {
                                    this.ebY[var7_13] = this.ebYDest[var7_13];
                                }
                            }
                            if (this.ebX[var7_13] == this.ebXDest[var7_13] && this.ebY[var7_13] == this.ebYDest[var7_13]) {
                                for (var8_18 = 0; var8_18 < 32; ++var8_18) {
                                    if (!this.collision(this.ebX[var7_13], this.ebY[var7_13], 2, 2, this.pX[var8_18], this.pY[var8_18], 16, 16) || this.ebActive[var7_13] <= 0 || this.pHP[var8_18] <= 0) continue;
                                    this.ebActive[var7_13] = 0;
                                    v67 = var8_18;
                                    this.pHP[v67] = this.pHP[v67] - (this.random(3) + this.eAtk[var7_13]);
                                    if (this.pHP[var8_18] > 0) continue;
                                    this.pHP[var8_18] = 0;
                                    --this.numgdragons;
                                    this.initExplosions(this.pX[var8_18] - 8, this.pY[var8_18] - 8);
                                    System.out.println("Player unit destroyed!");
                                }
                                if (this.collision(this.ebX[var7_13], this.ebY[var7_13], 2, 2, this.pLairX, this.pLairY, 32, 32) && this.ebActive[var7_13] > 0 && this.pLairHP > 0) {
                                    this.ebActive[var7_13] = 0;
                                    this.pLairHP -= this.random(3) + this.eAtk[var7_13];
                                    if (this.pLairHP <= 0) {
                                        this.pLairHP = 0;
                                        this.initExplosions(this.pLairX + 8, this.pLairY + 8);
                                        System.out.println("Player lair destroyed!");
                                    }
                                }
                                this.initExplosions(this.ebX[var7_13] - 14, this.ebY[var7_13] - 14);
                                this.ebActive[var7_13] = 0;
                            }
                            this.g.setColor(255, 255, 0);
                            this.g.fillRoundRect(this.ebX[var7_13], this.ebY[var7_13], 2, 2, 2, 2);
                            this.g.setColor(0, 255, 0);
                        }
                        ++var7_13;
                    }
                    for (var7_13 = 0; var7_13 < 32; ++var7_13) {
                        if (this.pHP[var7_13] != 0) continue;
                        this.pType[var7_13] = this.unitShown;
                        switch (this.pType[var7_13]) {
                            case 1: {
                                this.pRange[var7_13] = 64;
                                this.pAtk[var7_13] = 10;
                                this.pSpd[var7_13] = 4;
                                this.pMaxHP[var7_13] = 100;
                                this.pXDest[var7_13] = this.nearestResourceX(this.pX[var7_13], this.pY[var7_13]) + this.random(16);
                                this.pYDest[var7_13] = this.nearestResourceY(this.pX[var7_13], this.pY[var7_13]) + this.random(16);
                                break;
                            }
                            case 2: {
                                this.pRange[var7_13] = 128;
                                this.pAtk[var7_13] = 25;
                                this.pSpd[var7_13] = 8;
                                this.pMaxHP[var7_13] = 130;
                                this.pXDest[var7_13] = this.random(32) + this.pLairX;
                                this.pYDest[var7_13] = this.random(32) + this.pLairY;
                                break;
                            }
                        }
                        this.pHP[var7_13] = this.pMaxHP[var7_13];
                        this.pAP[var7_13] = 0;
                        this.pX[var7_13] = this.pLairX;
                        this.pY[var7_13] = this.pLairY + 16;
                        this.pFrame[var7_13] = 0;
                        this.pDirection[var7_13] = 0;
                        this.pChosen[var7_13] = false;
                        System.out.println("Player unit " + this.pType[var7_13] + " training complete!");
                        ++this.ptrained;
                        break;
                    }
                }
                if (this.numrdragons < 32 && this.etraining == 0 && this.eLairHP > 0) {
                    if (this.eresource >= 100 && this.numrdragons < 3) {
                        this.eTrain = 1;
                        this.etraining = this.eTrain * 100;
                    } else if (this.eresource >= 300) {
                        this.eTrain = 2;
                        this.etraining = this.eTrain * 100;
                    }
                }
                if (this.etraining > 0) {
                    --this.etraining;
                    if (this.etraining == 0) {
                        this.eresource -= this.eTrain * 100;
                        ++this.numrdragons;
                        for (var7_13 = 0; var7_13 < 32; ++var7_13) {
                            if (this.eHP[var7_13] != 0) continue;
                            this.eType[var7_13] = this.eTrain;
                            switch (this.eType[var7_13]) {
                                case 1: {
                                    this.eRange[var7_13] = 64;
                                    this.eAtk[var7_13] = 10;
                                    this.eSpd[var7_13] = 4;
                                    this.eMaxHP[var7_13] = 100;
                                    this.eXDest[var7_13] = this.nearestResourceX(this.eX[var7_13], this.eY[var7_13]) + this.random(16);
                                    this.eYDest[var7_13] = this.nearestResourceY(this.eX[var7_13], this.eY[var7_13]) + this.random(16);
                                    break;
                                }
                                case 2: {
                                    this.eRange[var7_13] = 128;
                                    this.eAtk[var7_13] = 5;
                                    this.eSpd[var7_13] = 16;
                                    this.eMaxHP[var7_13] = 130;
                                    this.eXDest[var7_13] = this.random(32) + this.eLairX;
                                    this.eYDest[var7_13] = this.random(32) + this.eLairY;
                                    break;
                                }
                            }
                            this.eHP[var7_13] = this.eMaxHP[var7_13];
                            this.eAP[var7_13] = 0;
                            this.eX[var7_13] = this.eLairX;
                            this.eY[var7_13] = this.eLairY;
                            this.eFrame[var7_13] = 0;
                            this.eDirection[var7_13] = 0;
                            System.out.println("Enemy training complete!");
                            ++this.etrained;
                            break;
                        }
                    }
                }
                this.doExplosions(this.g);
                this.action = 0;
                this.g.setColor(0, 255, 0);
                this.g.drawRect(0, 0, 32, 32);
                this.g.drawRect(32 * -this.bgX / 400, 32 * -this.bgY / 400, 32 * this.getWidth() / 400, 32 * this.getHeight() / 400);
                this.g.drawImage(this.food, 36, 0, 4 | 16);
                this.g.drawImage(this.icons[this.unitShown], 36, 18, 4 | 16);
                this.g.drawString("" + this.resource, 54, 0, 4 | 16);
                this.g.drawString("" + this.unitShown * 100, 54, 18, 4 | 16);
                this.g.drawString("DEMO VERSION", this.getWidth() / 2 - 30, this.getHeight() / 2 - 3, 4 | 16);
                this.g.drawImage(this.cursor, this.curX, this.curY, 4 | 16);
                if (this.pLairHP == 0 && this.numgdragons == 0) {
                    this.gameState = 4;
                }
                switch (this.mission) {
                    case 1: {
                        if (this.resource < 1000) break;
                        this.gameState = 4;
                        break;
                    }
                    case 2: {
                        if (this.ptrained < 12) break;
                        this.gameState = 4;
                        break;
                    }
                    case 3: {
                        this.g.fillRect(0, 36, 32 * this.holdtheline / 3000, 3);
                        this.g.setColor(0, 0, 0);
                        this.g.drawRect(0, 36, 32, 3);
                        this.g.setColor(0, 255, 0);
                        if (this.holdtheline-- != 0) break;
                        this.gameState = 4;
                        break;
                    }
                    case 4: {
                        if (this.eLairHP != 0 || this.numrdragons != 0) break;
                        this.gameState = 4;
                        break;
                    }
                }
                this.repaint();
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException var7_14) {
                }
            }
            break;
        }
    }

    public void showNotify() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void hideNotify() {
        if (this.thread != null) {
            this.thread = null;
        }
    }

    public int random(int n) {
        int n2 = this.r.nextInt() % n;
        while (n2 < 0) {
            n2 = this.r.nextInt() % n;
        }
        return n2;
    }

    public boolean collision(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n + n3 > n5 && n < n5 + n7 && n2 + n4 > n6 && n2 < n6 + n8;
    }

    public int nearestResourceX(int n, int n2) {
        int n3 = this.rX[0];
        int n4 = this.getRange(n, n2, this.rX[0], this.rY[0]);
        for (int i = 1; i < 3; ++i) {
            if (this.getRange(n, n2, this.rX[i], this.rY[i]) > n4 || this.rHP[i] <= 0) continue;
            n4 = this.getRange(n, n2, this.rX[i], this.rY[i]);
            n3 = this.rX[i];
        }
        return n3;
    }

    public int nearestResourceY(int n, int n2) {
        int n3 = this.rY[0];
        int n4 = this.getRange(n, n2, this.rX[0], this.rY[0]);
        for (int i = 1; i < 3; ++i) {
            if (this.getRange(n, n2, this.rX[i], this.rY[i]) > n4 || this.rHP[i] <= 0) continue;
            n4 = this.getRange(n, n2, this.rX[i], this.rY[i]);
            n3 = this.rY[i];
        }
        return n3;
    }

    public int getRange(int n, int n2, int n3, int n4) {
        int n5 = n > n3 ? n - n3 : n3 - n;
        int n6 = n2 > n4 ? n2 - n4 : n4 - n2;
        return n5 + n6;
    }

    public int getDistance(int n, int n2) {
        return n > n2 ? n - n2 : n2 - n;
    }

    public void initExplosions(int n, int n2) {
        for (int i = 0; i < 32; ++i) {
            if (this.expl[i] != 0) continue;
            this.expl[i] = 7;
            this.explX[i] = n;
            this.explY[i] = n2;
            return;
        }
    }

    public void doExplosions(Graphics graphics) {
        for (int i = 0; i < 32; ++i) {
            if (this.expl[i] <= 0) continue;
            graphics.drawImage(this.explosion[this.expl[i]], this.explX[i], this.explY[i], 4 | 0x10);
            int n = i;
            this.expl[n] = this.expl[n] - 1;
        }
    }
}

