/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.casino.gamewidgets.playingcards;

import com.mot.j2me.midlets.casino.gamewidgets.playingcards.Card;
import java.util.Random;
import java.util.Vector;

public class Deck {
    public Vector vectCard;

    public Deck() {
        this(52);
    }

    public Deck(int n) {
        this.vectCard = new Vector(n);
    }

    public void addCard(Card card) {
        this.vectCard.addElement(card);
    }

    public void clearCardFlag(int n) {
        Card card = this.getCard(n);
        card.flagged = false;
        this.replaceCard(card, n);
    }

    public Card dealTopCard() {
        Card card = this.getCard(0);
        this.vectCard.removeElementAt(0);
        return card;
    }

    public Card dealTopCard(Deck deck) {
        if (this.getNumberCards() < 1) {
            this.moveCardsIntoDeck(deck);
            this.shuffle();
        }
        return this.dealTopCard();
    }

    public void faceCardDown() {
        int n = 0;
        while (n < this.getNumberCards()) {
            Card card = this.getCard(n);
            card.faceDown = true;
            this.replaceCard(card, n);
            ++n;
        }
    }

    public void faceCardDown(int n) {
        Card card = this.getCard(n);
        card.faceDown = true;
        this.replaceCard(card, n);
    }

    public void faceCardUp() {
        int n = 0;
        while (n < this.getNumberCards()) {
            Card card = this.getCard(n);
            card.faceDown = false;
            this.replaceCard(card, n);
            ++n;
        }
    }

    public void faceCardUp(int n) {
        Card card = this.getCard(n);
        card.faceDown = false;
        this.replaceCard(card, n);
    }

    public void fill() {
        this.vectCard.removeAllElements();
        int n = 0;
        while (n < this.vectCard.capacity()) {
            Card card = new Card();
            card.face = n % 13 + 1;
            card.suit = n % 4 + 1;
            this.vectCard.addElement(card);
            ++n;
        }
    }

    public Card getCard(int n) {
        return (Card)this.vectCard.elementAt(n);
    }

    public boolean getCardFlag(int n) {
        Card card = this.getCard(n);
        return card.flagged;
    }

    public int getFirstFaceDown() {
        int n = 0;
        while (n < this.getNumberCards()) {
            if (this.isCardFaceDown(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getFirstSelected() {
        int n = 0;
        while (n < this.getNumberCards()) {
            if (this.getCardFlag(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getMaxCapacity() {
        return this.vectCard.capacity();
    }

    public int getNumberCards() {
        return this.vectCard.size();
    }

    public int getNumberEmptySlots() {
        return this.getMaxCapacity() - this.getNumberCards();
    }

    public int getNumberSelected() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.getNumberCards()) {
            if (this.getCardFlag(n2)) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return -1;
        }
        return n;
    }

    public boolean isCardFaceDown(int n) {
        Card card = this.getCard(n);
        return card.faceDown;
    }

    public static void main(String[] stringArray) {
        Card card;
        Deck deck = new Deck(102);
        deck.fill();
        deck.sort(false);
        int n = 0;
        while (n < deck.getNumberCards()) {
            card = deck.getCard(n);
            ++n;
        }
        deck.shuffle();
        int n2 = 0;
        while (n2 < deck.getNumberCards()) {
            card = deck.getCard(n2);
            ++n2;
        }
        System.out.println("Deal five cards to three players...");
        Deck deck2 = new Deck(5);
        Deck deck3 = new Deck(5);
        Deck deck4 = new Deck(5);
        int n3 = 0;
        while (n3 < 5) {
            deck2.addCard(deck.dealTopCard());
            deck3.addCard(deck.dealTopCard());
            deck4.addCard(deck.dealTopCard());
            ++n3;
        }
        System.out.println("*** Player one hand: " + deck2.getNumberCards());
        int n4 = 0;
        while (n4 < 5) {
            System.out.println(deck2.getCard(n4).toString());
            ++n4;
        }
        System.out.println("*** Player two hand: " + deck3.getNumberCards());
        int n5 = 0;
        while (n5 < 5) {
            System.out.println(deck3.getCard(n5).toString());
            ++n5;
        }
        System.out.println("*** Player three hand: " + deck4.getNumberCards());
        int n6 = 0;
        while (n6 < 5) {
            System.out.println(deck4.getCard(n6).toString());
            ++n6;
        }
        deck.shuffle();
        deck.sort(true);
        System.out.println("******* ACE HIGH");
        int n7 = 0;
        while (n7 < deck.getNumberCards()) {
            System.out.println(deck.getCard(n7).toString());
            ++n7;
        }
        deck.shuffle();
        deck.sort(false);
        System.out.println("******* ACE LOW");
        int n8 = 0;
        while (n8 < deck.getNumberCards()) {
            System.out.println(deck.getCard(n8).toString());
            ++n8;
        }
        System.out.println("*** Num remaining in deck: " + deck.getNumberCards());
    }

    public boolean moveCardsIntoDeck(Deck deck) {
        return this.moveCardsIntoDeck(deck, deck.getNumberCards());
    }

    public boolean moveCardsIntoDeck(Deck deck, int n) {
        if (this.getNumberEmptySlots() >= n) {
            int n2 = 0;
            while (n2 < n) {
                this.addCard(deck.dealTopCard());
                ++n2;
            }
            return true;
        }
        return false;
    }

    public Card removeCard(int n) {
        Card card = this.getCard(n);
        this.vectCard.removeElementAt(n);
        return card;
    }

    public Card replaceCard(Card card, int n) {
        Card card2 = this.getCard(n);
        this.vectCard.setElementAt(card, n);
        return card2;
    }

    public void setCardFlag(int n) {
        Card card = this.getCard(n);
        card.flagged = true;
        this.replaceCard(card, n);
    }

    public void shuffle() {
        Card card = new Card();
        Random random = new Random();
        int n = 0;
        while (n < this.getNumberCards()) {
            int n2 = Math.abs(random.nextInt()) % this.getNumberCards();
            card = this.getCard(n);
            this.replaceCard(this.getCard(n2), n);
            this.replaceCard(card, n2);
            ++n;
        }
    }

    public void sort(boolean bl) {
        int n = 0;
        while (n < this.getNumberCards()) {
            int n2 = 1;
            while (n2 < this.getNumberCards() - n) {
                Card card = this.getCard(n2 - 1);
                Card card2 = this.getCard(n2);
                boolean bl2 = false;
                if (card.face == 1 && bl) {
                    bl2 = true;
                }
                if (card2.face == 1 && bl) {
                    bl2 = false;
                } else if (card.face > card2.face) {
                    bl2 = true;
                }
                if (bl2) {
                    Card card3 = this.replaceCard(card2, n2 - 1);
                    this.replaceCard(card3, n2);
                }
                ++n2;
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.getNumberCards()) {
            Card card = this.getCard(n);
            stringBuffer.append(String.valueOf(card.toString()) + "\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void toggleCardFlag(int n) {
        if (!this.getCardFlag(n)) {
            this.setCardFlag(n);
        } else {
            this.clearCardFlag(n);
        }
    }
}

