/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.casino;

import com.mot.j2me.midlets.casino.PokerCanvas;
import com.mot.j2me.midlets.casino.gamewidgets.playingcards.CardGameScreens;
import com.mot.j2me.midlets.casino.gamewidgets.playingcards.CardImageData;
import com.mot.j2me.midlets.casino.gamewidgets.playingcards.Deck;
import com.mot.j2me.midlets.casino.gamewidgets.playingcards.DeckDraw;
import com.mot.j2me.midlets.util.AbstractMIDlet;
import com.mot.j2me.midlets.util.ApplicationController;
import com.mot.j2me.midlets.util.Presentation;
import com.mot.j2me.midlets.util.ResourceBundle;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PokerScreens
extends CardGameScreens {
    private static final String FILE_I18N = "com.mot.j2me.midlets.casino.languages.Poker";
    private static Image gameOverImage;
    private static final String TITLE_STR;
    private static final String WELCOME_SCREEN_STR;
    private static final String SELECT_BET_AMOUNT_STR1;
    private static final String SELECT_BET_AMOUNT_STR2;
    private static final String CASH_STR;
    private static final String BET_STR;
    private static final String DEALING_STR;
    private static final String DISCARD_STR;
    private static final String RE_DEALING_STR;
    private static final String GAME_OVER_STR;
    private static final String WON_STR;
    private static final int DECK_Y = 32;
    private boolean calculateDeckStartX = true;
    private int deckStartX;
    private int deckStartY;
    private DeckDraw deckDrawing = new DeckDraw(33, 1);
    private int cardPaintCounter = 0;
    private boolean isPantherPhone = false;

    static {
        TITLE_STR = ResourceBundle.getString(FILE_I18N, "009");
        WELCOME_SCREEN_STR = ResourceBundle.getString(FILE_I18N, "013");
        SELECT_BET_AMOUNT_STR1 = ResourceBundle.getString(FILE_I18N, "010");
        SELECT_BET_AMOUNT_STR2 = ResourceBundle.getString(FILE_I18N, "027");
        CASH_STR = ResourceBundle.getString(FILE_I18N, "011");
        BET_STR = ResourceBundle.getString(FILE_I18N, "012");
        DEALING_STR = ResourceBundle.getString(FILE_I18N, "014");
        DISCARD_STR = ResourceBundle.getString(FILE_I18N, "028");
        RE_DEALING_STR = ResourceBundle.getString(FILE_I18N, "029");
        GAME_OVER_STR = ResourceBundle.getString(FILE_I18N, "015");
        WON_STR = ResourceBundle.getString(FILE_I18N, "030");
        Image image = null;
        try {
            image = Image.createImage((String)"/com/mot/j2me/midlets/casino/res/all.png");
            gameOverImage = CardImageData.clip(image, 0, 0, 55, 35);
        }
        catch (IOException iOException) {
            System.out.println("ERROR: IOException at initImagesFromMidpData()");
            iOException.printStackTrace();
        }
    }

    PokerScreens(int n, int n2) {
        super(n, n2);
        Presentation presentation = (Presentation)ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).getScreen(-10);
        if (Presentation.PHONE == 1) {
            this.isPantherPhone = true;
        }
    }

    private void calcDeckStartPos(Deck deck) {
        int n = this.deckDrawing.getDeckSizeX(deck) / 2;
        int n2 = this.displayX / 2;
        this.deckStartX = n2 - n - 8;
    }

    private void paintBetAmount(Graphics graphics, int n, int n2) {
        Font font = Font.getFont((int)0, (int)0, (int)8);
        graphics.setFont(font);
        graphics.drawString(String.valueOf(BET_STR) + n, 5, n2 * 13 + 1, 20);
    }

    public void paintBetScreen(Graphics graphics, int n, int n2) {
        int n3 = graphics.getFont().getHeight() * 2 / 3 + 4;
        int n4 = 15;
        graphics.setColor(0, 0, 0);
        this.paintTitle(graphics, TITLE_STR, 0);
        this.paintBorder(graphics);
        this.paintCashBetAmounts(graphics, n2, n);
        graphics.setColor(0, 0, 0);
        graphics.setFont(this.smallFont);
        graphics.drawString(SELECT_BET_AMOUNT_STR1, 5, 2 * n3 + n4 + 8, 68);
        graphics.drawString(SELECT_BET_AMOUNT_STR2, 5, 3 * n3 + n4 + 6, 68);
    }

    private void paintCashBetAmounts(Graphics graphics, int n, int n2) {
        int n3 = graphics.getFont().getHeight() * 2 / 3 + 2;
        graphics.setFont(this.smallFont);
        String string = String.valueOf(CASH_STR) + n + " " + BET_STR + n2;
        if (graphics.getFont().stringWidth(string) + 5 > this.displayX) {
            graphics.drawString(String.valueOf(CASH_STR) + n, 5, n3 + 2, 20);
            graphics.drawString(String.valueOf(BET_STR) + n2, 5, n3 + 2 + graphics.getFont().getHeight(), 20);
        } else {
            graphics.drawString(string, 5, n3 + 2, 20);
        }
    }

    public boolean paintDealScreen(Graphics graphics, Deck deck, int n, int n2) {
        boolean bl = false;
        graphics.setColor(0, 0, 0);
        if (this.calculateDeckStartX) {
            this.calcDeckStartPos(deck);
            this.calculateDeckStartX = false;
        }
        this.paintTitle(graphics, TITLE_STR, 0);
        this.paintBorder(graphics);
        this.paintLastLine(graphics, DEALING_STR);
        this.paintBetAmount(graphics, n, 1);
        this.deckDrawing.setDealDeckStyle(33);
        switch (this.cardPaintCounter) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.deckDrawing.setNumberCardsToPaint(this.cardPaintCounter);
                ++this.cardPaintCounter;
                bl = false;
                break;
            }
            case 6: {
                this.cardPaintCounter = 0;
                bl = true;
            }
        }
        int n3 = 0;
        n3 = !this.isPantherPhone ? -5 : 5;
        this.deckDrawing.paintDeck(graphics, deck, this.deckStartX, 32 + n3);
        return bl;
    }

    public void paintErrorScreen(Graphics graphics, String string, String string2) {
        this.paintTitle(graphics, TITLE_STR, 0);
        this.paintBorder(graphics);
        this.paintStatusText(graphics, string);
    }

    public void paintGameOverScreen(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
        graphics.setColor(0, 0, 0);
        this.paintBorder(graphics);
        if (gameOverImage != null) {
            graphics.drawImage(gameOverImage, this.displayX / 2, this.displayY / 2 - gameOverImage.getHeight() / 2 - 2, 17);
        }
        this.paintTitle(graphics, (String)ResourceBundle.getObject(FILE_I18N, "038"), 0);
        this.paintStatusText(graphics, GAME_OVER_STR);
    }

    public boolean paintReDealScreen(Graphics graphics, Deck deck, int n, int n2) {
        boolean bl = true;
        graphics.setColor(0, 0, 0);
        this.paintTitle(graphics, TITLE_STR, 0);
        this.paintBorder(graphics);
        this.paintBetAmount(graphics, n, 1);
        this.paintLastLine(graphics, RE_DEALING_STR);
        this.deckDrawing.setDealDeckStyle(33);
        int n3 = 0;
        n3 = !this.isPantherPhone ? -5 : 5;
        this.deckDrawing.paintDeck(graphics, deck, this.deckStartX, 32 + n3);
        return bl;
    }

    public void paintReplaceCardScreen(Graphics graphics, Deck deck, int n, int n2) {
        graphics.setColor(0, 0, 0);
        this.paintBorder(graphics);
        this.paintStatusText(graphics, DISCARD_STR);
        this.paintYourCash(graphics, n2, 0);
        this.paintBetAmount(graphics, n, 1);
        this.deckDrawing.setDealDeckStyle(33);
        int n3 = 0;
        n3 = !this.isPantherPhone ? -5 : 5;
        this.deckDrawing.paintNumberedDeck(graphics, deck, this.deckStartX, 32 + n3);
    }

    public void paintResultsScreen(Graphics graphics, Deck deck, String string, int n, int n2, int n3) {
        graphics.setColor(0, 0, 0);
        this.paintBorder(graphics);
        this.paintYourCash(graphics, n3, 0);
        this.paintBetAmount(graphics, n2, 1);
        if (n > 0) {
            this.paintWonAmount(graphics, n2, n, 1);
        }
        this.deckDrawing.setDealDeckStyle(513);
        int n4 = 0;
        n4 = !this.isPantherPhone ? -4 : 0;
        this.deckDrawing.paintDeck(graphics, deck, this.deckStartX, 32 + n4);
        if (n3 <= 0) {
            PokerCanvas.gameOverFlag = true;
            string = "";
        }
        if (this.displayY > 68) {
            this.paintStatusText(graphics, string);
        } else {
            graphics.drawString(string, this.displayX / 2 - 8, this.displayY - graphics.getFont().getHeight() + 1, 17);
        }
    }

    public void paintWelcomeScreen(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        this.paintTitle(graphics, TITLE_STR, 0);
        this.paintStatusText(graphics, WELCOME_SCREEN_STR);
        String[] stringArray = new String[]{"$1", "$5", "$10", "$100"};
        this.paintFourCasinoTables(graphics, stringArray);
        this.paintBorder(graphics);
    }

    private void paintWonAmount(Graphics graphics, int n, int n2, int n3) {
        Font font = Font.getFont((int)0, (int)0, (int)8);
        graphics.setFont(font);
        int n4 = 5 + graphics.getFont().stringWidth(String.valueOf(BET_STR) + Integer.toString(n)) + 3;
        int n5 = graphics.getFont().stringWidth("- " + WON_STR + n2);
        if (n4 + n5 < this.displayX) {
            graphics.drawString("- " + WON_STR + n2, n4, n3 * 13, 20);
        } else {
            graphics.drawString(String.valueOf(WON_STR) + n2, this.displayX - n5 - 2, (n3 + 1) * 13 - 3, 20);
        }
    }

    public void paintYourCash(Graphics graphics, int n, int n2) {
        graphics.setColor(0, 0, 0);
        Font font = Font.getFont((int)0, (int)0, (int)8);
        graphics.setFont(font);
        graphics.drawString(String.valueOf(CASH_STR) + n, 5, n2 * 12 + 1, 20);
    }
}

