/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.casino;

import com.mot.j2me.midlets.casino.JacksBetter;
import com.mot.j2me.midlets.casino.PokerPayout;
import com.mot.j2me.midlets.casino.gamewidgets.playingcards.Card;
import com.mot.j2me.midlets.casino.gamewidgets.playingcards.Deck;

public class PokerGame {
    private static final int INITIAL_CASH = 1000;
    PokerPayout GameResults = new JacksBetter();
    Deck userHand;
    Deck dealerDeck;
    Deck usedDeck;
    int amountGameTable;
    int unitsBet;
    int amountBet;
    int amountCash = 1000;
    int payOut;
    String resultsMessage;
    int cashWon;
    private static int previousGameState;
    private int gameState;
    public static final int WELCOME = 0;
    public static final int BET = 1;
    public static final int DEAL_ALL = 2;
    public static final int USER_SELECT_CARDS = 3;
    public static final int DEAL_REPLACE = 4;
    public static final int DISPLAY_RESULTS = 5;
    public static final int ERROR_DISPLAY = 6;
    public static final int GAME_OVER = 7;

    PokerGame() {
        this.resetDecks();
    }

    private void dealCardsToUser() {
        try {
            int n = 0;
            while (n < 5) {
                this.userHand.addCard(this.dealerDeck.dealTopCard(this.usedDeck));
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception cought in dealCardsToUser");
        }
    }

    private void discardAllUserCards() {
        this.usedDeck.moveCardsIntoDeck(this.userHand);
        this.dealerDeck.moveCardsIntoDeck(this.usedDeck);
        this.dealerDeck.shuffle();
    }

    private void discardSelectedUserCards() {
        int n = 0;
        while (n < 5) {
            if (this.userHand.getCardFlag(n)) {
                Card card = this.dealerDeck.dealTopCard(this.usedDeck);
                Card card2 = this.userHand.replaceCard(card, n);
                card2.flagged = false;
                this.usedDeck.addCard(card2);
            }
            ++n;
        }
    }

    int getBetDollars() {
        return this.amountBet;
    }

    public int getBetUnits() {
        return this.unitsBet;
    }

    int getCashAmount() {
        return this.amountCash;
    }

    public int getCashWon() {
        return this.cashWon;
    }

    int getGameState() {
        return this.gameState;
    }

    public String getResultsMessage() {
        return this.GameResults.getResultString(this.userHand);
    }

    int getTableValue() {
        return this.amountGameTable;
    }

    public void goGameState(int n) {
        previousGameState = this.gameState;
        this.gameState = this.gameState;
    }

    public int goNextGameState() {
        int n = this.gameState;
        switch (this.gameState) {
            case 0: {
                this.payOut = 0;
                this.cashWon = 0;
                this.gameState = 1;
                break;
            }
            case 1: {
                this.gameState = 2;
                this.setBetDollars();
                this.amountCash -= this.getBetDollars();
                this.dealCardsToUser();
                break;
            }
            case 2: {
                this.gameState = 3;
                break;
            }
            case 3: {
                this.gameState = 4;
                break;
            }
            case 4: {
                this.discardSelectedUserCards();
                this.gameState = 5;
                this.payOut = this.GameResults.getPayout(this.userHand, this.amountBet / this.amountGameTable);
                this.cashWon = this.getBetDollars() * this.payOut;
                this.amountCash += this.cashWon;
                break;
            }
            case 5: {
                if (this.amountCash >= this.amountGameTable) {
                    this.cashWon = 0;
                    this.setBetUnits(0);
                    this.gameState = 1;
                    break;
                }
                this.gameState = 7;
                break;
            }
            case 6: {
                this.gameState = previousGameState;
                break;
            }
            default: {
                this.gameState = 7;
            }
        }
        previousGameState = n;
        return this.gameState;
    }

    private boolean keyBetState(int n, int n2) {
        block0 : switch (n) {
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.setBetUnits(n - 48);
                this.setBetDollars();
                break;
            }
            default: {
                switch (n2) {
                    case 5: 
                    case 8: {
                        if (this.getBetUnits() <= 0) {
                            return false;
                        }
                        this.goNextGameState();
                        break block0;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private boolean keyDisplayResults(int n, int n2) {
        switch (n2) {
            case 5: 
            case 8: {
                this.discardAllUserCards();
                this.goNextGameState();
            }
        }
        return true;
    }

    private boolean keySelectCardsState(int n, int n2) {
        block0 : switch (n) {
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.userHand.toggleCardFlag(n - 48 - 1);
                break;
            }
            default: {
                switch (n2) {
                    case 5: 
                    case 8: {
                        if (this.amountBet <= 0) {
                            return false;
                        }
                        this.goNextGameState();
                        break block0;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private boolean keyWelcomeState(int n, int n2) {
        switch (n) {
            case 49: {
                this.setTableValue(1);
                this.goNextGameState();
                break;
            }
            case 50: {
                this.setTableValue(5);
                this.goNextGameState();
                break;
            }
            case 51: {
                this.setTableValue(10);
                this.goNextGameState();
                break;
            }
            case 52: {
                this.setTableValue(100);
                this.goNextGameState();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void resetDecks() {
        this.usedDeck = new Deck();
        this.userHand = new Deck(5);
        this.dealerDeck = new Deck();
        this.dealerDeck.fill();
        this.dealerDeck.shuffle();
    }

    void setBetDollars() {
        this.amountBet = this.unitsBet * this.amountGameTable;
        if (this.amountBet > this.amountCash) {
            this.amountBet = this.amountCash;
        }
    }

    public void setBetUnits(int n) {
        int n2 = this.amountCash / this.amountGameTable;
        this.unitsBet = n2 < n ? n2 : n;
    }

    void setTableValue(int n) {
        this.amountGameTable = n;
    }

    public boolean userInputHandler(int n, int n2) {
        switch (this.getGameState()) {
            case 0: {
                return this.keyWelcomeState(n, n2);
            }
            case 1: {
                return this.keyBetState(n, n2);
            }
            case 3: {
                return this.keySelectCardsState(n, n2);
            }
            case 5: {
                return this.keyDisplayResults(n, n2);
            }
        }
        return true;
    }
}

