/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.casino;

import com.mot.j2me.midlets.casino.PokerGame;
import com.mot.j2me.midlets.casino.PokerMIDlet;
import com.mot.j2me.midlets.casino.PokerScreens;
import com.mot.j2me.midlets.util.AbstractMIDlet;
import com.mot.j2me.midlets.util.ApplicationController;
import com.mot.j2me.midlets.util.ResourceBundle;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class PokerCanvas
extends Canvas
implements Runnable,
CommandListener {
    private static final short SEND_KEY = -14;
    private static final String END_COMMAND_STR = ResourceBundle.getString("com.mot.j2me.midlets.casino.languages.Poker", "001");
    private static final String PLACE_COMMAND_STR = ResourceBundle.getString("com.mot.j2me.midlets.casino.languages.Poker", "002");
    private static final String DISCARD_COMMAND_STR = ResourceBundle.getString("com.mot.j2me.midlets.casino.languages.Poker", "003");
    private static final String AGAIN_COMMAND_STR = ResourceBundle.getString("com.mot.j2me.midlets.casino.languages.Poker", "026");
    private static final String WAIT_STR = ResourceBundle.getString("com.mot.j2me.midlets.casino.languages.Poker", "004");
    private Command endCommand;
    private Command placeCommand;
    private Command discardCommand;
    private Command againCommand;
    private Command emptyCommand;
    private boolean isEndCommandAdded = false;
    private boolean isPlaceCommandAdded = false;
    private boolean isDiscardCommandAdded = false;
    private boolean isAgainCommandAdded = false;
    private boolean isEmptyCommandAdded = false;
    private PokerGame pokerGame = new PokerGame();
    private PokerScreens pokerScreens;
    private Thread periodicRepainter;
    private boolean repainterOn;
    private boolean endPressed = false;
    public static boolean gameOverFlag = false;
    public PokerMIDlet mainMIDlet;

    PokerCanvas(PokerMIDlet pokerMIDlet) {
        this.mainMIDlet = pokerMIDlet;
        this.endCommand = new Command(END_COMMAND_STR, 7, 2);
        this.placeCommand = new Command(PLACE_COMMAND_STR, 1, 1);
        this.discardCommand = new Command(DISCARD_COMMAND_STR, 1, 1);
        this.againCommand = new Command(AGAIN_COMMAND_STR, 1, 1);
        this.emptyCommand = new Command("", 1, 1);
        this.pokerScreens = new PokerScreens(this.getWidth(), this.getHeight());
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.endCommand) {
            this.pokerGame = new PokerGame();
            gameOverFlag = false;
            this.endPressed = true;
            ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).changeScreen(-10);
        } else {
            this.removeAllCommands();
            this.processKey(-14);
        }
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        this.removeAllCommands();
        this.processKey(n);
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
        if (this.endPressed) {
            graphics.setColor(0, 0, 0);
            graphics.drawString(WAIT_STR, this.getWidth() / 2, this.getHeight() / 2 - graphics.getFont().getHeight() / 2, 17);
        } else {
            switch (this.pokerGame.getGameState()) {
                case 0: {
                    if (!this.isEmptyCommandAdded) {
                        this.addCommand(this.emptyCommand);
                        this.isEmptyCommandAdded = true;
                    }
                    if (!this.isEndCommandAdded) {
                        this.addCommand(this.endCommand);
                        this.isEndCommandAdded = true;
                    }
                    this.pokerScreens.paintWelcomeScreen(graphics);
                    break;
                }
                case 1: {
                    if (!this.isPlaceCommandAdded) {
                        this.addCommand(this.placeCommand);
                        this.isPlaceCommandAdded = true;
                    }
                    if (!this.isEndCommandAdded) {
                        this.addCommand(this.endCommand);
                        this.isEndCommandAdded = true;
                    }
                    this.pokerScreens.paintBetScreen(graphics, this.pokerGame.getBetUnits() * this.pokerGame.getTableValue(), this.pokerGame.getCashAmount());
                    break;
                }
                case 2: {
                    this.startRepainter();
                    if (!this.pokerScreens.paintDealScreen(graphics, this.pokerGame.userHand, this.pokerGame.getBetDollars(), this.pokerGame.getCashAmount())) break;
                    this.pokerGame.goNextGameState();
                    break;
                }
                case 3: {
                    if (!this.isDiscardCommandAdded) {
                        this.addCommand(this.discardCommand);
                        this.isDiscardCommandAdded = true;
                    }
                    if (!this.isEndCommandAdded) {
                        this.addCommand(this.endCommand);
                        this.isEndCommandAdded = true;
                    }
                    this.stopRepainter();
                    this.pokerScreens.paintReplaceCardScreen(graphics, this.pokerGame.userHand, this.pokerGame.getBetDollars(), this.pokerGame.getCashAmount());
                    break;
                }
                case 4: {
                    this.startRepainter();
                    if (!this.pokerScreens.paintReDealScreen(graphics, this.pokerGame.userHand, this.pokerGame.getBetDollars(), this.pokerGame.getCashAmount())) break;
                    this.pokerGame.goNextGameState();
                    break;
                }
                case 5: {
                    this.stopRepainter();
                    if (this.pokerGame.getCashAmount() <= 0) {
                        if (!gameOverFlag) {
                            this.removeAllCommands();
                            this.pokerGame.goGameState(7);
                        }
                    } else {
                        if (!this.isAgainCommandAdded) {
                            this.addCommand(this.againCommand);
                            this.isAgainCommandAdded = true;
                        }
                        if (!this.isEndCommandAdded) {
                            this.addCommand(this.endCommand);
                            this.isEndCommandAdded = true;
                        }
                        this.pokerScreens.paintResultsScreen(graphics, this.pokerGame.userHand, this.pokerGame.getResultsMessage(), this.pokerGame.getCashWon(), this.pokerGame.getBetDollars(), this.pokerGame.getCashAmount());
                        break;
                    }
                }
                case 7: {
                    if (!this.isEmptyCommandAdded) {
                        this.addCommand(this.emptyCommand);
                        this.isEmptyCommandAdded = true;
                    }
                    if (!this.isEndCommandAdded) {
                        this.addCommand(this.endCommand);
                        this.isEndCommandAdded = true;
                    }
                    gameOverFlag = true;
                    this.pokerScreens.paintGameOverScreen(graphics);
                    break;
                }
                default: {
                    this.pokerScreens.paintWelcomeScreen(graphics);
                }
            }
        }
    }

    private void processKey(int n) {
        if (!gameOverFlag) {
            this.pokerGame.userInputHandler(n, this.getGameAction(n));
            this.repaint();
            this.serviceRepaints();
        }
    }

    private void removeAllCommands() {
        if (this.isEndCommandAdded) {
            this.removeCommand(this.endCommand);
            this.isEndCommandAdded = false;
        }
        if (this.isPlaceCommandAdded) {
            this.removeCommand(this.placeCommand);
            this.isPlaceCommandAdded = false;
        }
        if (this.isDiscardCommandAdded) {
            this.removeCommand(this.discardCommand);
            this.isDiscardCommandAdded = false;
        }
        if (this.isAgainCommandAdded) {
            this.removeCommand(this.againCommand);
            this.isAgainCommandAdded = false;
        }
        if (this.isEmptyCommandAdded) {
            this.removeCommand(this.emptyCommand);
            this.isEmptyCommandAdded = false;
        }
    }

    public void run() {
        this.repainterOn = true;
        while (this.repainterOn) {
            this.repaint();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void showNotify() {
        this.endPressed = false;
    }

    public void startRepainter() {
        if (this.periodicRepainter == null) {
            this.periodicRepainter = new Thread(this);
            this.periodicRepainter.start();
        }
    }

    public void stopRepainter() {
        this.repainterOn = false;
        this.periodicRepainter = null;
    }
}

