/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.casino;

import com.mot.j2me.midlets.casino.gamewidgets.playingcards.Card;
import com.mot.j2me.midlets.casino.gamewidgets.playingcards.Deck;
import com.mot.j2me.midlets.util.ResourceBundle;

public class HiLowGame {
    private static final int INITIAL_CASH = 1000;
    private static final String FILE_I18N = "com.mot.j2me.midlets.casino.languages.HiLow";
    Deck dealerDeck;
    Deck userHand;
    int amountGameTable;
    int amountBet;
    int amountCash = 1000;
    String resultsMessage;
    int cashWon;
    private boolean lostGame;
    private int gameState;
    public static final int WELCOME = 0;
    public static final int BET = 1;
    public static final int PLAY = 2;
    public static final int DISPLAY_RESULTS = 3;
    public static final int GAME_OVER = 4;
    private static int previousGameState;

    public HiLowGame() {
        this.resetDecks();
    }

    private void dealCardsToUser() {
        int n = 0;
        while (n < 5) {
            this.userHand.addCard(this.dealerDeck.dealTopCard());
            ++n;
        }
        this.userHand.faceCardDown();
        this.userHand.faceCardUp(0);
    }

    private void discardAllUserCards() {
        this.dealerDeck.moveCardsIntoDeck(this.userHand);
        this.dealerDeck.shuffle();
    }

    int getBetDollars() {
        return this.amountBet * this.amountGameTable;
    }

    public int getBetUnits() {
        return this.amountBet;
    }

    int getCashAmount() {
        return this.amountCash;
    }

    public int getCashWon() {
        return this.cashWon;
    }

    public int getGameState() {
        return this.gameState;
    }

    public String getResultsMessage() {
        if (!this.lostGame) {
            return (String)ResourceBundle.getObject(FILE_I18N, "005");
        }
        if (this.amountCash <= 0) {
            return (String)ResourceBundle.getObject(FILE_I18N, "006");
        }
        return (String)ResourceBundle.getObject(FILE_I18N, "007");
    }

    int getTableValue() {
        return this.amountGameTable;
    }

    public void goGameState(int n) {
        previousGameState = this.gameState;
        this.gameState = this.gameState;
    }

    public int goNextGameState() {
        int n = this.gameState;
        switch (this.gameState) {
            case 0: {
                this.cashWon = 0;
                this.gameState = 1;
                this.dealCardsToUser();
                break;
            }
            case 1: {
                this.gameState = 2;
                this.amountCash -= this.getBetDollars();
                this.lostGame = false;
                break;
            }
            case 2: {
                if (!this.lostGame) {
                    this.cashWon = this.getBetDollars() * 2;
                    this.amountCash += this.cashWon;
                }
                this.gameState = 3;
                break;
            }
            case 3: {
                this.gameState = 1;
                this.cashWon = 0;
                this.setBetUnits(0);
                this.dealCardsToUser();
                if (this.amountCash > 0) break;
                this.gameState = 4;
                break;
            }
            default: {
                this.gameState = 0;
            }
            case 4: 
        }
        previousGameState = n;
        return this.gameState;
    }

    private boolean keyBetState(int n, int n2) {
        block0 : switch (n) {
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                int n3 = n - 48;
                if (this.amountCash - n3 * this.amountGameTable < 0) break;
                this.setBetUnits(n3);
                break;
            }
            default: {
                switch (n2) {
                    case 5: 
                    case 8: {
                        if (this.amountBet <= 0) {
                            return false;
                        }
                        this.goNextGameState();
                        break block0;
                    }
                }
                return false;
            }
        }
        return true;
    }

    private boolean keyDisplayResults(int n, int n2) {
        this.discardAllUserCards();
        this.goNextGameState();
        return true;
    }

    private boolean keyPlayState(int n, int n2) {
        int n3 = this.userHand.getFirstFaceDown();
        Card card = this.userHand.getCard(n3 - 1);
        Card card2 = this.userHand.getCard(n3);
        int n4 = card2.compareAceHigh(card);
        switch (n2) {
            case 1: {
                this.userHand.faceCardUp(n3);
                if (n4 == 1) {
                    if (n3 != 4) break;
                    this.goNextGameState();
                    break;
                }
                this.lostGame = true;
                this.goNextGameState();
                break;
            }
            case 6: {
                this.userHand.faceCardUp(n3);
                if (n4 == -1) {
                    if (n3 != 4) break;
                    this.goNextGameState();
                    break;
                }
                this.lostGame = true;
                this.goNextGameState();
            }
        }
        return true;
    }

    private boolean keyWelcomeState(int n, int n2) {
        switch (n) {
            case 49: {
                this.setTableValue(1);
                this.goNextGameState();
                break;
            }
            case 50: {
                this.setTableValue(5);
                this.goNextGameState();
                break;
            }
            case 51: {
                this.setTableValue(10);
                this.goNextGameState();
                break;
            }
            case 52: {
                this.setTableValue(100);
                this.goNextGameState();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void resetDecks() {
        this.dealerDeck = new Deck();
        this.userHand = new Deck(5);
        this.dealerDeck.fill();
        this.dealerDeck.shuffle();
    }

    public void setBetUnits(int n) {
        this.amountBet = n;
    }

    void setTableValue(int n) {
        this.amountGameTable = n;
    }

    public boolean userInputHandler(int n, int n2) {
        switch (this.getGameState()) {
            case 0: {
                return this.keyWelcomeState(n, n2);
            }
            case 1: {
                return this.keyBetState(n, n2);
            }
            case 2: {
                return this.keyPlayState(n, n2);
            }
            case 3: {
                return this.keyDisplayResults(n, n2);
            }
            case 4: {
                return true;
            }
        }
        return true;
    }
}

