/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.util.menu;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ng.games.pacman.Game;
import ng.games.pacman.io.ResourceManager;
import ng.games.pacman.screen.GameScreen;
import ng.games.pacman.settings.Settings;

public class Menu {
    public static final int LEFT_HR_ALIGMENT = 0;
    public static final int CENTER_HR_ALIGMENT = 1;
    private Game engine;
    private Image backgroundImage;
    private int textColor = 0xFFFFFF;
    private int highlightTextColor = 0xFF0000;
    private int upBoundGap = 5;
    private int downBoundGap = 5;
    private int textHrAligment = 1;
    private int horizontalGap = 10;
    private int selectedItemIndex;
    private int perLineGap = 2;
    private int fontSize = 0;
    private boolean valid = true;
    private int lastKey = 0;
    private int horizontalMenuGap = 5;
    private int[] subItemsIndices;
    private String[] items;
    private String[][] subItems;
    private int longestItemWidth;
    private ResourceManager rm = ResourceManager.getInstance();

    public Game getEngine() {
        return this.engine;
    }

    public void setEngine(Game game) {
        this.engine = game;
    }

    public int getSelectedItemIndex() {
        return this.selectedItemIndex;
    }

    public void setSelectedItemIndex(int n) {
        if (n >= this.items.length) {
            n = this.items.length - 1;
        } else if (n < 0) {
            n = 0;
        }
        this.selectedItemIndex = n;
    }

    public int getHorizontalGap() {
        return this.horizontalGap;
    }

    public void setHorizontalGap(int n) {
        this.horizontalGap = n;
    }

    public int getTextHrAligment() {
        return this.textHrAligment;
    }

    public void setTextHrAligment(int n) {
        this.textHrAligment = n;
    }

    public Menu(String[] stringArray, String[][] stringArray2) throws Exception {
        this.items = stringArray;
        this.subItems = stringArray2;
        if (stringArray2 != null && stringArray2.length != stringArray.length) {
            throw new Exception("Invalid subitems length");
        }
        this.subItemsIndices = new int[stringArray.length];
    }

    public void setSelectedSubItem(int n, int n2) {
        this.subItemsIndices[n] = n2;
    }

    public int getSelectedSubItem(int n) {
        return this.subItemsIndices[n];
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int n) {
        this.textColor = n;
    }

    public int getHighlightTextColor() {
        return this.highlightTextColor;
    }

    public void setHighlightTextColor(int n) {
        this.highlightTextColor = n;
    }

    public int getUpBoundGap() {
        return this.upBoundGap;
    }

    public void setUpBoundGap(int n) {
        this.upBoundGap = n;
    }

    public int getDownBoundGap() {
        return this.downBoundGap;
    }

    public void setDownBoundGap(int n) {
        this.downBoundGap = n;
    }

    public int getPerLineGap() {
        return this.perLineGap;
    }

    public void setPerLineGap(int n) {
        this.perLineGap = n;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.getBackgroundImage() != null) {
            graphics.drawImage(this.getBackgroundImage(), 88, 102, 3);
        }
        Font font = Settings.MENU_FONT;
        graphics.setFont(font);
        for (n3 = 0; n3 < this.items.length; ++n3) {
            n2 = font.stringWidth(this.items[n3]);
            if (n2 <= this.longestItemWidth) continue;
            this.longestItemWidth = n2;
        }
        n3 = font.getHeight() + this.getPerLineGap();
        n2 = 204 - this.getDownBoundGap() - this.getUpBoundGap();
        int n4 = n2 / n3;
        int n5 = n4 < this.items.length ? this.getSelectedItemIndex() / n4 * n4 : 0;
        int n6 = n5 + n4 - 1;
        if (n6 >= this.items.length) {
            n6 = this.items.length - 1;
        }
        int n7 = n6 - n5 + 1;
        int n8 = n = (204 - n7 * n3) / 2;
        for (int i = n5; i <= n6; ++i) {
            graphics.setColor(i == this.getSelectedItemIndex() ? this.getHighlightTextColor() : this.getTextColor());
            switch (this.getTextHrAligment()) {
                case 0: {
                    graphics.drawString(this.items[i], this.getHorizontalGap(), n8, 20);
                    if (this.subItems == null || this.subItems[i].length <= 0) break;
                    graphics.drawString(this.getSubItemText(i), 176 - this.getHorizontalGap(), n8, 24);
                    break;
                }
                case 1: {
                    if (this.subItems != null && this.subItems[i].length > 0) {
                        int n9 = font.stringWidth(this.items[i]);
                        int n10 = n9 + font.stringWidth(this.getSubItemText(i)) + this.getHorizontalMenuGap();
                        int n11 = (176 - n10) / 2;
                        graphics.drawString(this.items[i], n11, n8, 20);
                        graphics.drawString(this.getSubItemText(i), n11 + n9 + this.getHorizontalGap(), n8, 20);
                        break;
                    }
                    graphics.drawString(this.items[i], 88, n8, 17);
                }
            }
            n8 += n3;
        }
    }

    private String getSubItemText(int n) {
        return this.subItems[n][this.getSelectedSubItem(n)];
    }

    public int getHorizontalMenuGap() {
        return this.horizontalMenuGap;
    }

    public void setHorizontalMenuGap(int n) {
        this.horizontalMenuGap = n;
    }

    public void updateLogic() {
        this.processUserActions();
    }

    private void processUserActions() {
        if (this.lastKey != 0) {
            int n = GameScreen.getGMAction(this.lastKey);
            switch (n) {
                case 1: {
                    this.scrollItemIndex(-1);
                    break;
                }
                case 6: {
                    this.scrollItemIndex(1);
                    break;
                }
                case 2: {
                    this.scrollSubItemIndex(-1);
                    break;
                }
                case 5: {
                    this.scrollSubItemIndex(1);
                    break;
                }
                case 8: {
                    this.menuFired();
                }
            }
        }
        this.lastKey = 0;
    }

    public void menuFired() {
        if (this.subItems != null && this.subItems[this.selectedItemIndex].length > 0) {
            this.scrollSubItemIndex(1);
        } else if (this.engine != null) {
            this.engine.menuItemSelected(this.getSelectedItemIndex());
        }
    }

    private void scrollSubItemIndex(int n) {
        if (this.subItems != null && this.subItems[this.selectedItemIndex] != null && this.subItems[this.selectedItemIndex].length > 0) {
            int n2 = this.selectedItemIndex;
            this.subItemsIndices[n2] = this.subItemsIndices[n2] + n;
            if (this.subItemsIndices[this.selectedItemIndex] >= this.subItems[this.selectedItemIndex].length) {
                int n3 = this.selectedItemIndex;
                this.subItemsIndices[n3] = this.subItemsIndices[n3] % this.subItems[this.selectedItemIndex].length;
            }
            if (this.subItemsIndices[this.selectedItemIndex] < 0) {
                this.subItemsIndices[this.selectedItemIndex] = this.subItems[this.selectedItemIndex].length + this.subItemsIndices[this.selectedItemIndex];
            }
        }
    }

    private void scrollItemIndex(int n) {
        this.selectedItemIndex += n;
        if (this.selectedItemIndex >= this.items.length) {
            this.selectedItemIndex %= this.items.length;
        }
        if (this.selectedItemIndex < 0) {
            this.selectedItemIndex = this.items.length + this.selectedItemIndex;
        }
    }

    public void keyPressed(int n) {
        if (this.valid) {
            this.lastKey = n;
        }
    }
}

