/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.util;

public class Increaser {
    int increment;
    int value;
    int maximum;
    int minimum;
    int digit = 10;
    int lastRun = -1;
    private boolean roll = false;
    private boolean paused = false;
    private int currentTime = 0;
    private int suspendTime;
    private int posChange;

    public Increaser(int n, int n2, int n3, int n4) {
        this.value = n;
        this.increment = n2;
        this.maximum = n4;
        this.minimum = n3;
    }

    public void setMaximum(int n) {
        this.maximum = n;
    }

    public void setMinimum(int n) {
        this.minimum = n;
    }

    public Increaser(int n, int n2, int n3) {
        this(n, n2, 0, n3);
    }

    public void setRoll(boolean bl) {
        this.roll = bl;
    }

    public void setIncrement(int n) {
        this.increment = n;
    }

    public void shiftTime(int n) {
        this.currentTime += n;
    }

    public int getPosChange() {
        return this.posChange;
    }

    public int increase() {
        if (!this.paused) {
            if (this.lastRun != -1 && this.increment != 0) {
                int n = this.getCurrentTime() - this.lastRun;
                this.posChange = n * this.increment >> this.digit;
                this.value += this.posChange;
                if (this.value > this.maximum) {
                    if (this.roll) {
                        if (this.maximum != this.minimum) {
                            this.value = this.minimum + (this.value - this.minimum) % (this.maximum - this.minimum) - 1;
                        }
                    } else {
                        this.value = this.maximum;
                    }
                }
                if (this.value < this.minimum) {
                    this.value = this.minimum;
                }
                this.lastRun += (this.posChange << this.digit) / this.increment;
            } else {
                this.lastRun = this.getCurrentTime();
            }
        }
        return this.value;
    }

    private int getCurrentTime() {
        return this.currentTime;
    }

    public void suspend() {
        this.suspendTime = this.getCurrentTime();
        this.paused = true;
    }

    public void resume() {
        this.lastRun += this.getCurrentTime() - this.suspendTime;
        this.paused = false;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setDigit(int n) {
        this.digit = n;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void reverse() {
        this.increment = -this.increment;
    }

    public void reset() {
        this.lastRun = -1;
    }

    public boolean isOnRange() {
        if (this.increment > 0) {
            return this.value == this.maximum;
        }
        return this.value == this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }
}

