/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import ng.games.MainMIDlet;
import ng.games.pacman.GameManager;
import ng.games.pacman.io.ResourceManager;
import ng.games.pacman.levels.Level;
import ng.games.pacman.media.GameEffects;
import ng.games.pacman.scores.ScoresHandler;
import ng.games.pacman.screen.GameScreen;
import ng.games.pacman.settings.Settings;
import ng.games.pacman.util.Increaser;
import ng.games.pacman.util.menu.Menu;

public class Game
implements Runnable,
CommandListener {
    public static final byte STATE_SPLASH = 0;
    public static final byte STATE_MAIN_MENU = 1;
    public static final byte STATE_GAME_IN_PROCESS = 2;
    public static final byte STATE_SCOREBOARD = 3;
    public static final byte STATE_ENTER_NAME = 4;
    public static final byte STATE_SETTINGS_MENU = 5;
    public static final int STATE_SELECT_LEVEL_MENU = 6;
    public static final int STATE_PRELOADER = 7;
    private static final int STATE_PAUSE_MENU = 8;
    private static final int STATE_SETTINGS_AFTER_PAUSE = 9;
    private static final int STATE_HELP = 10;
    private static final int STATE_CREDITS = 11;
    private static final byte STATE_LOADING = 12;
    private static final byte STATE_REGISTER = 12;
    public static final byte STATE_QUIT = 99;
    public static final byte MAIN_MENU_NEW_GAME = 0;
    public static final byte MAIN_MENU_SETTINGS = 1;
    public static final byte MAIN_MENU_TOP = 2;
    public static final byte MAIN_MENU_HELP = 3;
    public static final byte MAIN_MENU_CREDITS = 4;
    public static final byte MAIN_MENU_QUIT = 5;
    public static final byte SETTINGS_MENU_RETURN = 0;
    private static final int SETTINGS_MENU_LANGUAGE = 1;
    private static final int SETTINGS_MENU_SOUND = 2;
    private static final int SETTINGS_MENU_DIFFICULTY = 3;
    private static final int PAUSE_MENU_RESUME = 0;
    private static final int PAUSE_MENU_SETTINGS = 1;
    private static final int PAUSE_MENU_MAIN_MENU = 2;
    private static final int PAUSE_MENU_EXIT = 3;
    private int[] userNameIndices = new int[8];
    private int currentUserNameIndex = 0;
    private int gameState;
    private GameScreen gameScreen;
    private Menu settingsMenu;
    private Menu mainMenu;
    private Menu pauseMenu;
    private Menu selectLevelMenu;
    private Image splashImage;
    private Image preloaderImage;
    private long splashHideTime;
    public static Object lock = new Object();
    private MainMIDlet midlet;
    private ResourceManager rm = ResourceManager.getInstance();
    private GameManager gameManager = GameManager.getInstance();
    private boolean repainted;
    private long startTime;
    private ScoresHandler scoreboard = ScoresHandler.getInstance();
    private boolean isSoundOn = false;
    private int reachedLevel = 0;
    private GameEffects gameEffects;
    private Command okCommand;
    private Command exitCommand;
    private Image menuBackroundImage;
    private Increaser windowPositionIncreaser;
    private long lastIterationTime;
    private int offset = 0;
    private final int maxProgressValue;
    private String[] lines;
    public int loadingProgress;
    private static Game instance = null;
    private int state;

    public Game(MainMIDlet mainMIDlet) {
        this.maxProgressValue = 30;
        this.midlet = mainMIDlet;
        this.startTime = System.currentTimeMillis();
        instance = this;
    }

    public static Game getInstance() {
        return instance;
    }

    public void run() {
        try {
            this.initialize();
            while (this.getGameState() != 99) {
                if (this.gameScreen.isShown()) {
                    this.updateLogic();
                    this.repaintScreen();
                    Thread.yield();
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.freeResources();
            this.midlet.quitApp();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int getGameState() {
        return this.gameState;
    }

    private void initialize() {
        this.loadingProgress = 0;
        this.gameScreen = GameScreen.getInstance();
        this.gameScreen.setGame(this);
        this.setGameState(-1);
        MainMIDlet.display.setCurrent((Displayable)this.gameScreen);
        this.repaintScreen();
        this.preloaderImage = ResourceManager.getInstance().getImage("preloader");
        this.setGameState(7);
        this.repaintScreen();
        this.splashImage = ResourceManager.getInstance().getImage("splash");
        this.setGameState(0);
        this.repaintScreen();
        this.preloaderImage = null;
        try {
            this.gameManager.loadGameResources();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.rm.loadStringResources();
        this.windowPositionIncreaser = new Increaser(0, 8, 0, 1);
        this.windowPositionIncreaser.setRoll(true);
        this.lastIterationTime = System.currentTimeMillis();
        this.gameEffects = GameEffects.getInstance();
        this.increaseProgress(2);
        this.loadSettings();
        this.increaseProgress(1);
        this.gameScreen.setCommandListener(this);
        this.gameScreen.addCommand(this.getOKCommand());
        this.gameScreen.addCommand(this.getExitCommand());
        this.repaintScreen();
        this.splashHideTime = System.currentTimeMillis();
        if (this.isSoundOn) {
            this.gameEffects.playTitleMusic();
        }
    }

    public void increaseProgress(int n) {
        this.loadingProgress += n;
        this.repaintScreen();
    }

    public void repaintScreen() {
        this.gameScreen.repaint();
        this.gameScreen.serviceRepaints();
    }

    private void updateLogic() {
        this.windowPositionIncreaser.shiftTime((int)(System.currentTimeMillis() - this.lastIterationTime));
        this.lastIterationTime = System.currentTimeMillis();
        this.windowPositionIncreaser.increase();
        switch (this.getGameState()) {
            case 0: {
                if (System.currentTimeMillis() < this.splashHideTime) break;
                this.setGameState(1);
                break;
            }
            case 1: {
                this.mainMenu.updateLogic();
                break;
            }
            case 5: 
            case 9: {
                this.settingsMenu.updateLogic();
                break;
            }
            case 8: {
                this.pauseMenu.updateLogic();
                break;
            }
            case 6: {
                this.selectLevelMenu.updateLogic();
                break;
            }
            case 2: {
                this.gameManager.updateLogic();
                if (!this.gameManager.isGameFinished()) break;
                if (this.reachedLevel < this.gameManager.getLevel()) {
                    this.reachedLevel = this.gameManager.getLevel();
                }
                if (this.scoreboard.checkForHiscore(this.gameManager.getScore())) {
                    this.setGameState(4);
                    break;
                }
                this.setGameState(1);
            }
        }
    }

    private Command getOKCommand() {
        if (this.okCommand == null) {
            this.okCommand = new Command("OK", 4, 1);
        }
        return this.okCommand;
    }

    private Command getExitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command("Exit", 2, 2);
        }
        return this.exitCommand;
    }

    public synchronized boolean isRepainted() {
        return this.repainted;
    }

    public synchronized void setRepainted(boolean bl) {
        this.repainted = bl;
    }

    public void commandAction(Command command, Displayable displayable) {
        switch (this.getGameState()) {
            case 12: {
                this.setGameState(1);
                this.lines = null;
                break;
            }
            case 4: {
                if (command.getCommandType() == 4) {
                    StringBuffer stringBuffer = new StringBuffer(8);
                    for (int i = 0; i < 8; ++i) {
                        stringBuffer.append(ResourceManager.INPUT_LETTERS[this.userNameIndices[i]]);
                    }
                    this.scoreboard.addToHiscores(stringBuffer.toString(), this.gameManager.getScore());
                    this.setGameState(3);
                    break;
                }
                this.setGameState(1);
                break;
            }
            case 2: {
                this.gameManager.pause();
                this.setGameState(8);
                break;
            }
            case 1: {
                if (command.getCommandType() == 4) {
                    this.mainMenu.menuFired();
                    break;
                }
                this.setGameState(99);
                break;
            }
            case 5: 
            case 9: {
                if (command.getCommandType() == 4) {
                    this.settingsMenu.menuFired();
                    break;
                }
                this.quitSettingsMenu();
                break;
            }
            case 8: {
                if (command.getCommandType() == 4) {
                    this.pauseMenu.menuFired();
                    break;
                }
                this.resumeGame();
                break;
            }
            case 6: {
                if (command.getCommandType() == 4) {
                    this.selectLevelMenu.menuFired();
                    break;
                }
                this.setGameState(1);
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                if (command.getCommandType() != 2) break;
                this.setGameState(1);
            }
        }
    }

    private void resumeGame() {
        this.setGameState(2);
        this.gameManager.resume();
    }

    public void paint(Graphics graphics) {
        long l = System.currentTimeMillis();
        switch (this.getGameState()) {
            case 4: {
                this.drawEnterName(graphics);
                break;
            }
            case 10: {
                this.drawHelpScreen(graphics);
                break;
            }
            case 11: {
                this.drawCredits(graphics);
                break;
            }
            case 12: {
                this.drawRegister(graphics);
                break;
            }
            case 1: {
                this.drawMainMenu(graphics);
                break;
            }
            case 5: 
            case 9: {
                this.drawSettingsMenu(graphics);
                break;
            }
            case 6: {
                this.drawSelectLevelMenu(graphics);
                break;
            }
            case 0: {
                this.drawSplash(graphics);
                break;
            }
            case 7: {
                this.drawPreloader(graphics);
                break;
            }
            case 2: {
                this.drawGameBoard(graphics);
                break;
            }
            case 3: {
                this.drawScoreboard(graphics);
                break;
            }
            case 8: {
                this.drawPauseMenu(graphics);
            }
        }
        this.setRepainted(true);
    }

    private void drawRegister(Graphics graphics) {
        this.drawWindow(graphics, this.rm.getStringResource(27), this.rm.getStringResource(17));
    }

    private void drawCredits(Graphics graphics) {
        this.drawWindow(graphics, this.rm.getStringResource(18), this.rm.getStringResource(19));
    }

    private void drawHelpScreen(Graphics graphics) {
        this.drawWindow(graphics, this.rm.getStringResource(16), this.rm.getStringResource(17));
    }

    private void drawWindow(Graphics graphics, String string, String string2) {
        int n = this.drawWindowTitle(string, graphics);
        this.drawScrollableStrings(this.lines, this.windowPositionIncreaser.getValue(), Settings.DEFAULT_FONT, graphics);
    }

    private final void drawEnterName(Graphics graphics) {
        int n = this.drawWindowTitle(this.rm.getStringResource(4), graphics);
        n = this.drawStrings(this.rm.getCongratulaion(), 0, n, Settings.DEFAULT_FONT, graphics);
        int n2 = 0;
        int n3 = Settings.DEFAULT_FONT.getHeight() + 4;
        n += (176 - n - n3) / 2;
        int n4 = 10;
        for (int i = 0; i < this.userNameIndices.length; ++i) {
            n2 = Settings.DEFAULT_FONT.stringWidth(ResourceManager.INPUT_LETTERS[this.userNameIndices[i]]);
            if (i == this.currentUserNameIndex) {
                graphics.setColor(0xFF0000);
            } else {
                graphics.setColor(0xFFFFFF);
            }
            graphics.drawRect(n4, n, ResourceManager.getMaxLetterWidth() + 3, n3);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(ResourceManager.INPUT_LETTERS[this.userNameIndices[i]], n4 + 3 + (ResourceManager.getMaxLetterWidth() - n2) / 2, n + 3, 20);
            n4 += ResourceManager.getMaxLetterWidth() + 10;
        }
    }

    private int drawWindowTitle(String string, Graphics graphics) {
        graphics.setFont(Settings.DEFAULT_FONT);
        graphics.setColor(0xFFFFFF);
        int n = (176 - Settings.DEFAULT_FONT.stringWidth(string)) / 2;
        int n2 = 5;
        graphics.drawString(string, n, n2, 20);
        graphics.drawLine(0, 25, 176, 25);
        return n2 += 25;
    }

    private int drawStrings(String[] stringArray, int n, int n2, Font font, Graphics graphics) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = font.getHeight();
        int n7 = (204 - n2 - 30) / 15;
        graphics.setClip(0, n2, 176, 174 - n2);
        if (n7 < stringArray.length) {
            n4 = n / n6;
            n3 = Math.min(stringArray.length, n4 + n7 + 1);
        } else {
            n4 = 0;
            n3 = stringArray.length;
            n = 0;
        }
        for (int i = n4; i < n3; ++i) {
            n5 = (176 - font.stringWidth(stringArray[i])) / 2;
            graphics.drawString(stringArray[i], n5, n2 - n % n6, 20);
            n2 += n6;
        }
        graphics.setClip(0, 0, 176, 204);
        return n2;
    }

    private void drawScrollableStrings(String[] stringArray, int n, Font font, Graphics graphics) {
        int n2;
        int n3 = font.getHeight();
        int n4 = 25;
        int n5 = 174 - n4;
        graphics.setClip(0, n4, 176, n5);
        int n6 = n4 + n5 - n;
        int n7 = -n6 / n3 - 1;
        if (n7 < 0) {
            n7 = 0;
        }
        if ((n2 = (n5 - n6) / n3 + 3) >= stringArray.length - 1) {
            n2 = stringArray.length - 1;
        }
        for (int i = n7; i <= n2; ++i) {
            int n8 = n6 + i * n3;
            int n9 = n8 > 102 ? 850 * (204 - n8) / 204 : 850 * n8 / 204;
            if (n9 > 255) {
                n9 = 255;
            }
            if (n9 < 0) {
                n9 = 0;
            }
            graphics.setColor(n9, n9, n9);
            graphics.drawString(stringArray[i], (176 - font.stringWidth(stringArray[i])) / 2, n8, 20);
        }
        graphics.setClip(0, 0, 176, 204);
    }

    private void drawPauseMenu(Graphics graphics) {
        this.gameManager.paint(graphics);
        this.pauseMenu.paint(graphics);
    }

    private void drawPreloader(Graphics graphics) {
        graphics.drawImage(this.preloaderImage, 88, 102, 3);
    }

    private void drawSelectLevelMenu(Graphics graphics) {
        this.selectLevelMenu.paint(graphics);
    }

    private void drawSettingsMenu(Graphics graphics) {
        this.settingsMenu.paint(graphics);
    }

    private void drawScoreboard(Graphics graphics) {
        this.drawWindowTitle(this.rm.getStringResource(3), graphics);
        this.scoreboard.paint(graphics, this.windowPositionIncreaser.getValue());
    }

    private void drawGameBoard(Graphics graphics) {
        this.gameManager.paint(graphics);
    }

    private void drawSplash(Graphics graphics) {
        graphics.drawImage(this.splashImage, 88, 102, 3);
        this.drawProgressBar(graphics);
    }

    private void drawProgressBar(Graphics graphics) {
        int n = 166;
        graphics.setColor(0);
        graphics.drawRect(5, 194, n, 5);
        graphics.setColor(0xFF0000);
        graphics.fillRect(6, 195, (n - 1) * this.loadingProgress / 30, 4);
    }

    private void drawMainMenu(Graphics graphics) {
        this.mainMenu.paint(graphics);
    }

    private Menu createMainMenu() {
        Menu menu = null;
        try {
            menu = new Menu(new String[]{this.rm.getStringResource(0), this.rm.getStringResource(2), this.rm.getStringResource(3), this.rm.getStringResource(16), this.rm.getStringResource(18), this.rm.getStringResource(1)}, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.applyDefaultMenuSettings(menu);
        return menu;
    }

    private Menu createPauseMenu() {
        Menu menu = null;
        try {
            menu = new Menu(new String[]{this.rm.getStringResource(13), this.rm.getStringResource(2), this.rm.getStringResource(15), this.rm.getStringResource(1)}, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.applyDefaultMenuSettings(menu);
        menu.setTextColor(0xFFFFFF);
        menu.setBackgroundImage(null);
        return menu;
    }

    private Menu createSelectLevelMenu() {
        Menu menu = null;
        try {
            String[] stringArray = new String[this.reachedLevel + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.rm.getStringResource(14) + " " + (i + 1);
            }
            menu = new Menu(stringArray, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.applyDefaultMenuSettings(menu);
        return menu;
    }

    private Menu createSettingsMenu() {
        Menu menu = null;
        try {
            menu = new Menu(new String[]{this.rm.getStringResource(7), this.rm.getStringResource(8), this.rm.getStringResource(9), this.rm.getStringResource(20)}, new String[][]{new String[0], ResourceManager.locales, {this.rm.getStringResource(10), this.rm.getStringResource(11)}, {this.rm.getStringResource(21), this.rm.getStringResource(22), this.rm.getStringResource(23)}});
            this.applyDefaultMenuSettings(menu);
            menu.setTextHrAligment(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return menu;
    }

    private void applyDefaultMenuSettings(Menu menu) {
        menu.setTextHrAligment(Settings.MAIN_MENU_TEXT_HR_ALIGMENT);
        menu.setTextColor(0);
        menu.setHighlightTextColor(15778675);
        menu.setUpBoundGap(45);
        menu.setDownBoundGap(Settings.MENU_DOWN_BOUND_GAP);
        menu.setTextHrAligment(Settings.MAIN_MENU_TEXT_HR_ALIGMENT);
        menu.setHorizontalGap(Settings.MENU_HORIZONTAL_GAP);
        menu.setPerLineGap(Settings.MENU_PER_LINE_GAP);
        menu.setHorizontalMenuGap(Settings.MENU_HORIZONTAL_MENU_GAP);
        menu.setBackgroundImage(this.menuBackroundImage);
        menu.setEngine(this);
    }

    public void quitGame() {
        this.setGameState(99);
    }

    private void freeResources() {
        this.menuBackroundImage = null;
        this.gameManager.freeResources();
        Level.freeLevels();
        System.gc();
    }

    public final void destroyGame() {
        this.saveSettings();
        this.gameEffects.destroy();
    }

    public void keyPressed(int n) {
        switch (this.getGameState()) {
            case 1: {
                this.mainMenu.keyPressed(n);
                break;
            }
            case 5: 
            case 9: {
                this.settingsMenu.keyPressed(n);
                break;
            }
            case 8: {
                this.pauseMenu.keyPressed(n);
                break;
            }
            case 6: {
                this.selectLevelMenu.keyPressed(n);
                break;
            }
            case 2: {
                this.gameManager.keyPressed(n);
                break;
            }
            case 4: {
                this.processEnterName(n);
            }
        }
    }

    private void processEnterName(int n) {
        int n2 = GameScreen.getGMAction(n);
        switch (n2) {
            case 6: {
                int n3 = this.currentUserNameIndex;
                this.userNameIndices[n3] = this.userNameIndices[n3] + 1;
                if (this.userNameIndices[this.currentUserNameIndex] < ResourceManager.INPUT_LETTERS.length) break;
                this.userNameIndices[this.currentUserNameIndex] = 0;
                break;
            }
            case 1: {
                int n4 = this.currentUserNameIndex;
                this.userNameIndices[n4] = this.userNameIndices[n4] - 1;
                if (this.userNameIndices[this.currentUserNameIndex] >= 0) break;
                this.userNameIndices[this.currentUserNameIndex] = ResourceManager.INPUT_LETTERS.length - 1;
                break;
            }
            case 5: {
                ++this.currentUserNameIndex;
                if (this.currentUserNameIndex < 8) break;
                this.currentUserNameIndex = 0;
                break;
            }
            case 2: {
                --this.currentUserNameIndex;
                if (this.currentUserNameIndex >= 0) break;
                this.currentUserNameIndex = 7;
            }
        }
    }

    public void menuItemSelected(int n) {
        switch (this.getGameState()) {
            case 1: {
                this.processMainMenu(n);
                break;
            }
            case 8: {
                this.processPauseMenu(n);
                break;
            }
            case 5: 
            case 9: {
                this.processSettingsMenu(n);
                break;
            }
            case 6: {
                this.gameManager.startGame(n);
                this.setGameState(2);
            }
        }
    }

    private void processPauseMenu(int n) {
        switch (n) {
            case 0: {
                this.resumeGame();
                break;
            }
            case 1: {
                this.settingsMenu = this.createSettingsMenu();
                this.setGameState(9);
                break;
            }
            case 3: {
                if (this.reachedLevel < this.gameManager.getLevel()) {
                    this.reachedLevel = this.gameManager.getLevel();
                }
                this.quitGame();
                break;
            }
            case 2: {
                if (this.reachedLevel < this.gameManager.getLevel()) {
                    this.reachedLevel = this.gameManager.getLevel();
                }
                this.setGameState(1);
            }
        }
    }

    private void processMainMenu(int n) {
        switch (n) {
            case 0: {
                this.selectLevelMenu = this.createSelectLevelMenu();
                this.selectLevelMenu.setSelectedItemIndex(this.reachedLevel);
                this.setGameState(6);
                break;
            }
            case 2: {
                this.setGameState(3);
                break;
            }
            case 1: {
                this.setGameState(5);
                break;
            }
            case 3: {
                this.setGameState(10);
                break;
            }
            case 4: {
                this.setGameState(11);
                break;
            }
            case 5: {
                this.setGameState(99);
            }
        }
    }

    private void processSettingsMenu(int n) {
        switch (n) {
            case 0: {
                this.applyNewSettings();
            }
        }
    }

    private void applyNewSettings() {
        this.rm.setLocale(this.settingsMenu.getSelectedSubItem(1));
        if (this.isSoundOn != (this.settingsMenu.getSelectedSubItem(2) == 0)) {
            this.isSoundOn = this.settingsMenu.getSelectedSubItem(2) == 0;
            this.gameEffects.setSoundOn(this.isSoundOn);
            if (this.isSoundOn) {
                if (this.gameState != 2) {
                    this.gameEffects.playTitleMusic();
                }
            } else {
                this.gameEffects.stopTitleMusic();
            }
        }
        this.gameManager.setDifficulty(this.settingsMenu.getSelectedSubItem(3));
        this.mainMenu = this.createMainMenu();
        this.settingsMenu = this.createSettingsMenu();
        this.pauseMenu = this.createPauseMenu();
        this.quitSettingsMenu();
    }

    private void quitSettingsMenu() {
        if (this.getGameState() == 5) {
            this.setGameState(1);
        } else {
            this.setGameState(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() {
        this.scoreboard.saveScores();
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"pmsettings", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.rm.getLocale());
            dataOutputStream.writeBoolean(this.isSoundOn);
            dataOutputStream.writeInt(this.reachedLevel);
            dataOutputStream.writeInt(this.gameManager.getDifficulty());
            for (int i = 0; i < this.userNameIndices.length; ++i) {
                dataOutputStream.writeInt(this.userNameIndices[i]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"pmsettings", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
            if (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                this.rm.setLocale(dataInputStream.readInt());
                this.isSoundOn = dataInputStream.readBoolean();
                this.reachedLevel = dataInputStream.readInt();
                this.gameManager.setDifficulty(dataInputStream.readInt());
                for (int i = 0; i < 8; ++i) {
                    this.userNameIndices[i] = dataInputStream.readInt();
                }
            } else {
                this.rm.setLocale(0);
                this.isSoundOn = true;
            }
            this.gameEffects.setSoundOn(this.isSoundOn);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    public void pauseGame() {
        if (this.getGameState() == 2) {
            this.setGameState(8);
        }
        this.gameManager.pause();
    }

    public void setGameState(int n) {
        if (n == this.gameState) {
            return;
        }
        this.showHideButtons(n);
        if (this.gameEffects != null) {
            if (n == 2) {
                this.gameEffects.stopTitleMusic();
            } else if (this.gameState == 2) {
                this.gameEffects.playTitleMusic();
            }
        }
        if (n == 1) {
            this.splashImage = null;
            if (this.gameState == 0) {
                this.menuBackroundImage = ResourceManager.getInstance().getImage("pmw_bg");
                this.mainMenu = this.createMainMenu();
                this.settingsMenu = this.createSettingsMenu();
                this.pauseMenu = this.createPauseMenu();
            }
        }
        if (n == 3 || n == 10 || n == 11 || n == 12) {
            this.windowPositionIncreaser.setValue(0);
            switch (n) {
                case 3: {
                    this.windowPositionIncreaser.setMaximum(this.scoreboard.getRecordsCount() * 15 + 149);
                    break;
                }
                case 10: {
                    this.lines = this.rm.getHelp();
                    this.windowPositionIncreaser.setMaximum(this.lines.length * Settings.DEFAULT_FONT.getHeight() + 149);
                    break;
                }
                case 11: {
                    this.lines = this.rm.getCredits();
                    this.windowPositionIncreaser.setMaximum(this.lines.length * Settings.DEFAULT_FONT.getHeight() + 149);
                    break;
                }
                case 12: {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.rm.getStringResource(28));
                    stringBuffer.append(" ");
                    String string = this.midlet.getAppProperty("sms-code");
                    if (string == null) {
                        stringBuffer.append(this.rm.getStringResource(29));
                    } else {
                        stringBuffer.append(string);
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append(this.rm.getStringResource(30));
                    this.lines = ResourceManager.breakIntoLines(stringBuffer.toString(), Settings.DEFAULT_FONT, 166);
                    this.windowPositionIncreaser.setMaximum(this.lines.length * Settings.DEFAULT_FONT.getHeight() + 149);
                }
            }
        }
        if (n == 5 || n == 9) {
            this.settingsMenu.setSelectedSubItem(1, this.rm.getLocale());
            this.settingsMenu.setSelectedSubItem(2, this.isSoundOn ? 0 : 1);
            this.settingsMenu.setSelectedSubItem(3, this.gameManager.getDifficulty());
        }
        this.gameState = n;
    }

    private void showHideButtons(int n) {
        boolean bl;
        boolean bl2 = bl = n != 3 && n != 10 && n != 11 && n != 12;
        if (bl) {
            this.gameScreen.addCommand(this.getOKCommand());
        } else {
            this.gameScreen.removeCommand(this.getOKCommand());
        }
        if (n == 0 || n == 2 || n == 7 || n == -1) {
            this.gameScreen.hideButtons();
        } else {
            this.gameScreen.showButtons();
        }
    }
}

