/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class PuppyAdventureCanvas
extends Canvas
implements CommandListener,
Runnable {
    private static final int GS_LOAD = 0;
    private static final int GS_LOGO = 1;
    private static final int GS_PRESENT = 2;
    private static final int GS_TITLE = 3;
    private static final int GS_MENU = 4;
    private static final int GS_LEVEL = 5;
    private static final int GS_PLAY = 6;
    private static final int GS_GAMEOVER = 7;
    private static final int GS_WIN = 8;
    private static final int GS_GAME_CONTROLS = 9;
    private static final int GS_CREDITS = 10;
    private static final int GS_HIGHSCORES = 11;
    private int m_iGameState = 0;
    public int m_iResumeState = 0;
    public static final int VK_STAR = 0;
    public static final int VK_POUND = 1;
    public static final int VK_LEFT = 2;
    public static final int VK_RIGHT = 3;
    public static final int VK_UP = 4;
    public static final int VK_DOWN = 5;
    public static final int VK_FIRE = 6;
    public boolean[] m_pressedKeys = new boolean[7];
    public boolean[] m_releasedKeys = new boolean[7];
    private final PuppyAdventureMIDlet m_midlet;
    private final Display m_display;
    private final byte FPS = (byte)50;
    private long m_oldFrameTick;
    private volatile Thread m_animationThread = null;
    private long m_lFrameTickDiff;
    private boolean m_bPaused = false;
    public Image m_imgLogo;
    public Image m_imgTitle;
    public Image m_imgGame;
    public Image m_imgGround;
    public Image m_imgItems;
    public Image m_imgPlayer;
    public Image[] m_imgEnemy;
    private Image m_imgBlack = null;
    private Font m_fontTexts1;
    private Font m_fontTexts2;
    private Font m_fontTexts3;
    private Random m_rnd;
    private long m_lLogoTick = 0L;
    private long m_lLevelTick = 0L;
    private long m_lWinTick = 0L;
    private long m_lGameOverTick = 0L;
    private long m_lPresentTick = 0L;
    private long m_lBlinkTick = 0L;
    private boolean m_bBlinkShow = true;
    private String[] m_strMenuTexts = new String[]{TextResources.getString(0), TextResources.getString(1), TextResources.getString(2), TextResources.getString(3), TextResources.getString(4), TextResources.getString(5), TextResources.getString(6)};
    private static final int m_iNumMenuTexts = 7;
    private NvMenu m_menu;
    private int m_iCreditTextYPos;
    private NvHighScores m_highScores;
    private NvProfile m_profile;
    private boolean m_bWin = false;
    private boolean m_bPauseDone = false;
    private static final int FLAG_KEY_LEFT = 0;
    private static final int FLAG_KEY_RIGHT = 1;
    private static final int FLAG_KEY_UP = 2;
    private static final int FLAG_KEY_DOWN = 3;
    private static final int FLAG_KEY_ACTION = 4;
    private static final int NUM_KEY_FLAGS = 5;
    private boolean[] m_bKeyPressedFlags = new boolean[5];
    private int m_relX = 0;
    private int m_relY = 0;
    private boolean m_bCanGameResume = false;
    private int m_iScore;
    private int m_iOldScore;
    private int m_iLevel;
    private final int MAX_LEVELS;
    private final int MAX_LIVES;
    private static final int TARGET_W = 176;
    private static final int TARGET_H = 208;
    private static final int NUM_VBLOCKS = 10;
    private static final int NUM_HBLOCKS = 15;
    private static final int CELL_W = 19;
    private static final int CELL_H = 19;
    private NvRectangle m_rTetrisArena = new NvRectangle(0, 0, 285, 190);
    private static final int ITEM_EMPTY = 0;
    private static final int ITEM_WALL = 1;
    private static final int ITEM_DOOR = 2;
    private static final int ITEM_KEY = 3;
    private static final int ITEM_JEWEL = 4;
    private static final int ITEM_ROCK = 5;
    private static final int ITEM_PLAYER = 6;
    private static final int ITEM_ENEMY = 7;
    private static final int DIR_LEFT = 0;
    private static final int DIR_RIGHT = 1;
    private static final int DIR_UP = 2;
    private static final int DIR_DOWN = 3;
    private static final int NUM_DIRS = 4;
    private Item[][] m_aBlocksData;
    private NvProgressbar m_progressBar;
    private PlayerItem m_sptPlayer;
    private Vector m_vcEnemies;
    private Vector m_vcRocks;
    private char[] m_oldEneType = new char[50];
    private static final char[][][] m_maps = new char[][][]{new char[][]{{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0006', '\u0000', '\u0000', '\u0000', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0003', '\u0000', '\u0001', '\u0001', '\u0002', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0000', '\u0001', '\u0001', '\u0000', '\u0004', '\u0004', '\u0004', '\u0004', '\u0004', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}}, new char[][]{{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0001', '\u0007', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0006', '\u0000', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0005', '\u0004', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0004', '\u0004', '\u0000', '\u0001', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0004', '\u0004', '\u0000', '\u0001'}, {'\u0001', '\u0003', '\u0004', '\u0004', '\u0000', '\u0001', '\u0001', '\u0001', '\u0004', '\u0001', '\u0002', '\u0004', '\u0004', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0004', '\u0004', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0004', '\u0004', '\u0004', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}}, new char[][]{{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0004', '\u0004', '\u0005', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0002', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0004', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0000', '\u0004', '\u0004', '\u0001'}, {'\u0001', '\u0003', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0004', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0006', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001'}, {'\u0001', '\u0001', '\u0007', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0000', '\u0001', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}}, new char[][]{{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0007', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0002', '\u0001'}, {'\u0001', '\u0000', '\u0003', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0004', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0004', '\u0001', '\u0006', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0004', '\u0001', '\u0000', '\u0001', '\u0000', '\u0000', '\u0007', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0004', '\u0001', '\u0004', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0004', '\u0001', '\u0000', '\u0004', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0004', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}}, new char[][]{{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0007', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0005', '\u0004', '\u0000', '\u0006', '\u0001'}, {'\u0001', '\u0000', '\u0003', '\u0000', '\u0001', '\u0005', '\u0004', '\u0000', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0004', '\u0001', '\u0001', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0004', '\u0004', '\u0001', '\u0001', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0004', '\u0004', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0002', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}}, new char[][]{{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0007', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0006', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0004', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0004', '\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0002', '\u0001', '\u0001', '\u0004', '\u0001', '\u0004', '\u0001', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0004', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0007', '\u0004', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0003', '\u0001'}, {'\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0007', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}}, new char[][]{{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0005', '\u0004', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001'}, {'\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001'}, {'\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0000', '\u0004', '\u0000', '\u0001', '\u0000', '\u0000', '\u0007', '\u0001', '\u0004', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0000', '\u0007', '\u0001', '\u0000', '\u0003', '\u0000', '\u0001', '\u0004', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0002', '\u0000', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0006', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}}, new char[][]{{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0004', '\u0004', '\u0004', '\u0000', '\u0004', '\u0004', '\u0004', '\u0001', '\u0004', '\u0004', '\u0004', '\u0000', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0004', '\u0007', '\u0004', '\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0003', '\u0004', '\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0004', '\u0004', '\u0004', '\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0004', '\u0007', '\u0004', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0004', '\u0004', '\u0004', '\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0004', '\u0004', '\u0001', '\u0004', '\u0007', '\u0004', '\u0001', '\u0004', '\u0000', '\u0004', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0002', '\u0004', '\u0004', '\u0001', '\u0004', '\u0004', '\u0004', '\u0000', '\u0004', '\u0004', '\u0004', '\u0001', '\u0006', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}}, new char[][]{{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0001', '\u0005', '\u0004', '\u0004', '\u0001', '\u0007', '\u0001', '\u0005', '\u0004', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001'}, {'\u0001', '\u0007', '\u0001', '\u0004', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0000', '\u0001', '\u0007', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0004', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0000', '\u0001', '\u0000', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0004', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0000', '\u0002', '\u0000', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0004', '\u0004', '\u0000', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0006', '\u0001'}, {'\u0001', '\u0000', '\u0000', '\u0004', '\u0004', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0004', '\u0004', '\u0001', '\u0000', '\u0000', '\u0000', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001'}, {'\u0001', '\u0003', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}}, new char[][]{{'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}, {'\u0001', '\u0000', '\u0000', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0000', '\u0000', '\u0004', '\u0005', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0000', '\u0004', '\u0000', '\u0001', '\u0000', '\u0007', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0000', '\u0004', '\u0000', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0001', '\u0004', '\u0001', '\u0001', '\u0007', '\u0004', '\u0000', '\u0001', '\u0000', '\u0003', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001', '\u0000', '\u0001', '\u0000', '\u0001'}, {'\u0001', '\u0000', '\u0001', '\u0002', '\u0000', '\u0004', '\u0004', '\u0000', '\u0000', '\u0000', '\u0004', '\u0000', '\u0007', '\u0000', '\u0001'}, {'\u0001', '\u0006', '\u0001', '\u0001', '\u0000', '\u0001', '\u0001', '\u0001', '\u0000', '\u0000', '\u0001', '\u0000', '\u0000', '\u0000', '\u0001'}, {'\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001', '\u0001'}}};

    public PuppyAdventureCanvas(PuppyAdventureMIDlet puppyAdventureMIDlet, Display display) {
        this.MAX_LEVELS = 10;
        this.MAX_LIVES = 3;
        this.setFullScreenMode(true);
        this.m_fontTexts1 = Font.getFont((int)64, (int)0, (int)8);
        this.repaint();
        this.m_fontTexts2 = Font.getFont((int)64, (int)1, (int)0);
        this.m_fontTexts3 = Font.getFont((int)64, (int)1, (int)16);
        this.m_midlet = puppyAdventureMIDlet;
        this.m_display = display;
        this.m_lFrameTickDiff = 0L;
        this.m_rnd = new Random();
    }

    private void initSprites() {
        this.m_aBlocksData = new Item[10][15];
        this.m_sptPlayer = new PlayerItem(this, this.m_imgPlayer);
        this.m_vcEnemies = new Vector();
        this.m_vcRocks = new Vector();
    }

    private void initGame() {
        int n;
        this.m_imgLogo = PuppyAdventureMIDlet.loadImage("condetsoft");
        this.m_imgTitle = PuppyAdventureMIDlet.loadImage("title");
        this.m_imgGround = PuppyAdventureMIDlet.loadImage("ground");
        this.m_imgItems = PuppyAdventureMIDlet.loadImage("items");
        this.m_imgPlayer = PuppyAdventureMIDlet.loadImage("player");
        this.m_imgEnemy = new Image[3];
        this.m_imgEnemy = PuppyAdventureMIDlet.loadImages("enemy", 3);
        this.createGameImage(this.m_imgGround.getWidth(), this.m_imgGround.getHeight());
        this.createBlackImage(this.getWidth(), this.getHeight());
        this.m_relX = (this.getWidth() - 176) / 2;
        this.m_relY = (this.getHeight() - 208) / 2;
        this.initSprites();
        this.m_menu = new NvMenu(this.m_strMenuTexts, 7, new NvRectangle(0, 0, this.getWidth(), this.getHeight()), this.m_fontTexts1);
        this.m_profile = new NvProfile(this.m_display, this);
        this.m_highScores = new NvHighScores(this.m_profile, this.getWidth(), this.getHeight(), this.m_fontTexts1);
        for (n = 0; n < 5; ++n) {
            this.m_bKeyPressedFlags[n] = false;
        }
        n = 50;
        int n2 = 6;
        int n3 = this.m_relX + 4;
        int n4 = this.m_relY + 196;
        this.m_progressBar = new NvProgressbar(n3, n4, n, n2, 255, 255, 0, 255, 0, 0, 3);
    }

    private void createBlackImage(int n, int n2) {
        this.m_imgBlack = Image.createImage((int)n, (int)n2);
        Graphics graphics = this.m_imgBlack.getGraphics();
        graphics.setColor(0);
        graphics.fillRect(0, 0, n, n2);
    }

    private void createGameImage(int n, int n2) {
        this.m_imgGame = Image.createImage((int)n, (int)n2);
        Graphics graphics = this.m_imgGame.getGraphics();
        graphics.drawImage(this.m_imgGround, 0, 0, 20);
    }

    public synchronized void start() {
        this.initGame();
        this.m_animationThread = new Thread(this);
        this.m_oldFrameTick = System.currentTimeMillis();
        this.m_animationThread.start();
    }

    public synchronized void stop() {
        this.m_animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = 20L;
        Thread thread = Thread.currentThread();
        this.m_iGameState = 1;
        try {
            while (thread == this.m_animationThread && thread != null && !this.m_midlet.m_bNeedExit) {
                long l2 = System.currentTimeMillis();
                this.m_lFrameTickDiff = l2 - this.m_oldFrameTick;
                if (this.m_lFrameTickDiff == 0L) continue;
                this.m_oldFrameTick = l2;
                this.processInput();
                this.repaint(0, 0, this.getWidth(), this.getHeight());
                this.serviceRepaints();
                if (this.m_lFrameTickDiff < l) {
                    PuppyAdventureCanvas puppyAdventureCanvas = this;
                    synchronized (puppyAdventureCanvas) {
                        this.wait(l - this.m_lFrameTickDiff);
                        continue;
                    }
                }
                if (thread == null) continue;
                thread.yield();
            }
            if (this.m_midlet != null) {
                this.m_midlet.exitRequested();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void blackened(Graphics graphics) {
        if (this.m_imgBlack == null) {
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            graphics.drawImage(this.m_imgBlack, 0, 0, 20);
        }
    }

    public void paint(Graphics graphics) {
        switch (this.m_iGameState) {
            case 0: {
                this.blackened(graphics);
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(7), this.m_fontTexts1);
                break;
            }
            case 1: {
                this.blackened(graphics);
                this.renderLogo(graphics, this.m_imgLogo);
                this.m_lLogoTick += this.m_lFrameTickDiff;
                if (this.m_lLogoTick <= 1000L) break;
                this.m_iGameState = 2;
                this.m_lLogoTick = 0L;
                break;
            }
            case 2: {
                this.blackened(graphics);
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(8), this.m_fontTexts2);
                this.m_lPresentTick += this.m_lFrameTickDiff;
                if (this.m_lPresentTick <= 1000L) break;
                this.newTitle();
                this.m_lPresentTick = 0L;
                break;
            }
            case 3: {
                this.blackened(graphics);
                this.renderSplash(graphics);
                break;
            }
            case 4: {
                this.blackened(graphics);
                this.m_menu.render(graphics);
                break;
            }
            case 5: {
                this.blackened(graphics);
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(9) + " " + this.m_iLevel, this.m_fontTexts2);
                this.m_lLevelTick += this.m_lFrameTickDiff;
                if (this.m_lLevelTick <= 3000L) break;
                this.m_lLevelTick = 0L;
                this.play();
                break;
            }
            case 6: {
                this.updateNDrawAll(graphics);
                break;
            }
            case 7: {
                this.updateNDrawAll(graphics);
                if (this.m_bPaused) break;
                this.renderCenteredScreenYellowText(graphics, TextResources.getString(10), this.m_fontTexts3);
                this.m_lGameOverTick += this.m_lFrameTickDiff;
                if (this.m_lGameOverTick <= 3000L) break;
                this.m_lGameOverTick = 0L;
                if (this.m_highScores.isTopSix() != -1) {
                    this.newHighscores();
                    break;
                }
                this.newMenu();
                break;
            }
            case 8: {
                this.updateNDrawAll(graphics);
                if (this.m_bPaused) break;
                if (this.m_iLevel == 10) {
                    this.renderCenteredScreenYellowText(graphics, TextResources.getString(11), this.m_fontTexts3);
                } else {
                    this.renderCenteredScreenYellowText(graphics, TextResources.getString(12), this.m_fontTexts3);
                }
                this.m_lWinTick += this.m_lFrameTickDiff;
                if (this.m_lWinTick <= 3000L) break;
                this.m_lWinTick = 0L;
                if (this.m_iLevel == 10) {
                    this.m_bCanGameResume = false;
                    this.newCredits();
                    break;
                }
                int n = this.m_iLevel + 1;
                this.newGame(n);
                break;
            }
            case 10: {
                this.blackened(graphics);
                this.renderLogo(graphics, this.m_imgLogo);
                this.renderCredits(graphics);
                break;
            }
            case 9: {
                this.blackened(graphics);
                this.renderGameControls(graphics);
                break;
            }
            case 11: {
                this.blackened(graphics);
                this.m_highScores.render(graphics);
            }
        }
    }

    int getGameState() {
        return this.m_iGameState;
    }

    void setGameState(int n) {
        this.m_iGameState = n;
    }

    private void newTitle() {
        this.m_lBlinkTick = 0L;
        this.m_bBlinkShow = true;
        this.m_releasedKeys[6] = false;
        this.m_iGameState = 3;
    }

    private void newGameControls() {
        this.m_iGameState = 9;
    }

    private void newHighscores() {
        this.m_iGameState = 11;
    }

    private void renderSplash(Graphics graphics) {
        int n = (this.getWidth() - this.m_imgTitle.getWidth()) / 2;
        int n2 = (this.getHeight() - this.m_imgTitle.getHeight()) / 2;
        graphics.drawImage(this.m_imgTitle, n, n2, 20);
        if (this.m_bBlinkShow) {
            this.renderCenteredYellowText(graphics, TextResources.getString(13), this.m_fontTexts1, this.getWidth() / 2, 200 + this.m_relY);
        }
        this.m_lBlinkTick += this.m_lFrameTickDiff;
        if (this.m_lBlinkTick > 500L) {
            this.m_bBlinkShow = !this.m_bBlinkShow;
            this.m_lBlinkTick = 0L;
        }
    }

    private void renderPauseMsg(Graphics graphics, String string, Font font) {
        if (this.m_bBlinkShow) {
            this.renderCenteredScreenYellowText(graphics, string, font);
        }
        this.m_lBlinkTick += this.m_lFrameTickDiff;
        if (this.m_lBlinkTick > 500L) {
            this.m_bBlinkShow = !this.m_bBlinkShow;
            this.m_lBlinkTick = 0L;
        }
    }

    private void renderLogo(Graphics graphics, Image image) {
        int n = (this.getWidth() - image.getWidth()) / 2;
        int n2 = (this.getHeight() - image.getHeight()) / 2;
        graphics.drawImage(image, n, n2, 20);
    }

    private void renderCenteredYellowText(Graphics graphics, String string, Font font, int n, int n2) {
        int n3 = font.stringWidth(string) / 2;
        int n4 = font.getHeight() / 2;
        int n5 = n - n3;
        int n6 = n2 - n4;
        graphics.setFont(font);
        graphics.setColor(64, 32, 0);
        graphics.drawString(string, n5, n6, 20);
        graphics.setColor(255, 128, 0);
        graphics.drawString(string, n5 + 1, n6 + 1, 20);
    }

    private void renderCenteredScreenYellowText(Graphics graphics, String string, Font font) {
        int n = (this.getWidth() - font.stringWidth(string)) / 2;
        int n2 = (this.getHeight() - font.getHeight()) / 2;
        graphics.setFont(font);
        graphics.setColor(64, 32, 0);
        graphics.drawString(string, n, n2, 20);
        graphics.setColor(255, 128, 0);
        graphics.drawString(string, n + 1, n2 + 1, 20);
    }

    private void renderCredits(Graphics graphics) {
        String[] stringArray = new String[]{"Puppy Adventure", "Version 1.0", "", "Design & Programming", "Novel Yahya", "", "Arts", "Novel Yahya", "", "Thanks to", "Hurriah & Hafidz A."};
        int n = this.m_fontTexts1.getHeight() * stringArray.length + 3 * (stringArray.length - 1);
        int n2 = this.m_iCreditTextYPos;
        graphics.setFont(this.m_fontTexts1);
        for (int i = 0; i < stringArray.length; ++i) {
            int n3 = (this.getWidth() - this.m_fontTexts1.stringWidth(stringArray[i])) / 2;
            graphics.setColor(64, 64, 32);
            graphics.drawString(stringArray[i], n3, n2, 20);
            graphics.setColor(255, 128, 0);
            graphics.drawString(stringArray[i], n3 + 1, n2 + 1, 20);
            n2 += this.m_fontTexts1.getHeight() + 3;
        }
        --this.m_iCreditTextYPos;
        if (this.m_iCreditTextYPos <= -n) {
            this.m_iCreditTextYPos = this.getHeight();
        }
    }

    private void renderGameControls(Graphics graphics) {
        String string = TextResources.getString(14);
        String[] stringArray = new String[]{TextResources.getString(15), "2", "8", "4", "6", "5", "*", "#"};
        String[] stringArray2 = new String[]{TextResources.getString(27), TextResources.getString(17), TextResources.getString(18), TextResources.getString(19), TextResources.getString(20), TextResources.getString(21), TextResources.getString(22), TextResources.getString(23)};
        int n = (this.getHeight() - (this.m_fontTexts1.getHeight() * 11 + 10)) / 2;
        graphics.setFont(this.m_fontTexts1);
        int n2 = (this.getWidth() - this.m_fontTexts1.stringWidth(string)) / 2;
        graphics.setColor(64, 32, 0);
        graphics.drawString(string, n2, n, 20);
        graphics.setColor(255, 128, 0);
        graphics.drawString(string, n2 + 1, n + 1, 20);
        n += this.m_fontTexts1.getHeight() + this.m_fontTexts1.getHeight() + 1;
        n2 = (this.getWidth() - this.m_fontTexts1.stringWidth(TextResources.getString(15) + "   " + stringArray2[1])) / 2;
        int n3 = n2 + this.m_fontTexts1.stringWidth(TextResources.getString(15) + "   ");
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.setColor(64, 32, 0);
            graphics.drawString(stringArray[i], n2, n, 20);
            graphics.setColor(255, 128, 0);
            graphics.drawString(stringArray[i], n2 + 1, n + 1, 20);
            graphics.setColor(64, 32, 0);
            graphics.drawString(stringArray2[i], n3, n, 20);
            graphics.setColor(255, 128, 0);
            graphics.drawString(stringArray2[i], n3 + 1, n + 1, 20);
            n += this.m_fontTexts1.getHeight() + 1;
        }
    }

    private void newGame(int n) {
        int n2;
        int n3;
        this.m_iLevel = n;
        this.m_bPaused = false;
        this.m_bCanGameResume = true;
        if (this.m_iLevel == 1) {
            this.m_iScore = 0;
        }
        this.m_iOldScore = this.m_iScore;
        this.m_bWin = false;
        this.m_lLevelTick = 0L;
        this.m_progressBar.setValue(3);
        this.m_vcEnemies.removeAllElements();
        this.m_vcRocks.removeAllElements();
        for (n3 = 0; n3 < 10; ++n3) {
            for (n2 = 0; n2 < 15; ++n2) {
                this.m_aBlocksData[n3][n2] = null;
                if (m_maps[this.m_iLevel - 1][n3][n2] == '\u0001') {
                    this.m_aBlocksData[n3][n2] = new Item(this, this.m_imgItems);
                    this.m_aBlocksData[n3][n2].reset();
                    this.m_aBlocksData[n3][n2].setType(1);
                    this.m_aBlocksData[n3][n2].setCellColumn(0);
                    this.m_aBlocksData[n3][n2].setPosition(19 * n2, 19 * n3);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n3][n2] == '\u0002') {
                    this.m_aBlocksData[n3][n2] = new Item(this, this.m_imgItems);
                    this.m_aBlocksData[n3][n2].reset();
                    this.m_aBlocksData[n3][n2].setType(2);
                    this.m_aBlocksData[n3][n2].setCellColumn(1);
                    this.m_aBlocksData[n3][n2].setPosition(19 * n2, 19 * n3);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n3][n2] == '\u0003') {
                    this.m_aBlocksData[n3][n2] = new Item(this, this.m_imgItems);
                    this.m_aBlocksData[n3][n2].reset();
                    this.m_aBlocksData[n3][n2].setType(3);
                    this.m_aBlocksData[n3][n2].setCellColumn(2);
                    this.m_aBlocksData[n3][n2].setPosition(19 * n2, 19 * n3);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n3][n2] == '\u0004') {
                    this.m_aBlocksData[n3][n2] = new Item(this, this.m_imgItems);
                    this.m_aBlocksData[n3][n2].reset();
                    this.m_aBlocksData[n3][n2].setType(4);
                    if (this.getRand(10) < 8) {
                        this.m_aBlocksData[n3][n2].setCellColumn(3);
                    } else {
                        this.m_aBlocksData[n3][n2].setCellColumn(5);
                    }
                    this.m_aBlocksData[n3][n2].setPosition(19 * n2, 19 * n3);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n3][n2] == '\u0006') {
                    this.m_sptPlayer.reset();
                    this.m_sptPlayer.setType(6);
                    this.m_sptPlayer.setPosition(19 * n2, 19 * n3);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n3][n2] == '\u0005') {
                    this.m_aBlocksData[n3][n2] = new RockItem(this, this.m_imgItems);
                    this.m_aBlocksData[n3][n2].reset();
                    this.m_aBlocksData[n3][n2].setType(5);
                    this.m_aBlocksData[n3][n2].setCellColumn(4);
                    this.m_aBlocksData[n3][n2].setPosition(19 * n2, 19 * n3);
                    this.m_vcRocks.addElement(this.m_aBlocksData[n3][n2]);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n3][n2] != '\u0007') continue;
                char c = (char)this.getRand(3);
                EnemyItem enemyItem = new EnemyItem(this, this.m_imgEnemy[c]);
                enemyItem.reset();
                enemyItem.m_iDir = this.getRand(4);
                enemyItem.setType(7);
                enemyItem.setPosition(19 * n2, 19 * n3);
                if (c == '\u0002') {
                    enemyItem.setNumCellRows(1);
                    enemyItem.setNumCellColumns(2);
                }
                this.m_vcEnemies.addElement(enemyItem);
                this.m_oldEneType[this.m_vcEnemies.size() - 1] = c;
            }
        }
        this.m_imgGame.getGraphics().setClip(0, 0, this.m_imgGame.getWidth(), this.m_imgGame.getHeight());
        this.m_imgGame.getGraphics().drawImage(this.m_imgGround, 0, 0, 20);
        for (n3 = 0; n3 < 10; ++n3) {
            for (n2 = 0; n2 < 15; ++n2) {
                if (this.m_aBlocksData[n3][n2] == null) continue;
                this.m_aBlocksData[n3][n2].render(this.m_imgGame.getGraphics());
            }
        }
        this.m_iGameState = 5;
    }

    private void tryAgain() {
        int n;
        int n2;
        this.m_bPaused = false;
        this.m_bCanGameResume = true;
        this.m_bWin = false;
        this.m_lLevelTick = 0L;
        this.m_iScore = this.m_iOldScore;
        this.m_vcEnemies.removeAllElements();
        this.m_vcRocks.removeAllElements();
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < 15; ++n) {
                this.m_aBlocksData[n2][n] = null;
                if (m_maps[this.m_iLevel - 1][n2][n] == '\u0001') {
                    this.m_aBlocksData[n2][n] = new Item(this, this.m_imgItems);
                    this.m_aBlocksData[n2][n].reset();
                    this.m_aBlocksData[n2][n].setType(1);
                    this.m_aBlocksData[n2][n].setCellColumn(0);
                    this.m_aBlocksData[n2][n].setPosition(19 * n, 19 * n2);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n2][n] == '\u0002') {
                    this.m_aBlocksData[n2][n] = new Item(this, this.m_imgItems);
                    this.m_aBlocksData[n2][n].reset();
                    this.m_aBlocksData[n2][n].setType(2);
                    this.m_aBlocksData[n2][n].setCellColumn(1);
                    this.m_aBlocksData[n2][n].setPosition(19 * n, 19 * n2);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n2][n] == '\u0003') {
                    this.m_aBlocksData[n2][n] = new Item(this, this.m_imgItems);
                    this.m_aBlocksData[n2][n].reset();
                    this.m_aBlocksData[n2][n].setType(3);
                    this.m_aBlocksData[n2][n].setCellColumn(2);
                    this.m_aBlocksData[n2][n].setPosition(19 * n, 19 * n2);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n2][n] == '\u0004') {
                    this.m_aBlocksData[n2][n] = new Item(this, this.m_imgItems);
                    this.m_aBlocksData[n2][n].reset();
                    this.m_aBlocksData[n2][n].setType(4);
                    if (this.getRand(10) < 8) {
                        this.m_aBlocksData[n2][n].setCellColumn(3);
                    } else {
                        this.m_aBlocksData[n2][n].setCellColumn(5);
                    }
                    this.m_aBlocksData[n2][n].setPosition(19 * n, 19 * n2);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n2][n] == '\u0006') {
                    this.m_sptPlayer.reset();
                    this.m_sptPlayer.setType(6);
                    this.m_sptPlayer.setPosition(19 * n, 19 * n2);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n2][n] == '\u0005') {
                    this.m_aBlocksData[n2][n] = new RockItem(this, this.m_imgItems);
                    this.m_aBlocksData[n2][n].reset();
                    this.m_aBlocksData[n2][n].setType(5);
                    this.m_aBlocksData[n2][n].setCellColumn(4);
                    this.m_aBlocksData[n2][n].setPosition(19 * n, 19 * n2);
                    this.m_vcRocks.addElement(this.m_aBlocksData[n2][n]);
                    continue;
                }
                if (m_maps[this.m_iLevel - 1][n2][n] != '\u0007') continue;
                char c = this.m_oldEneType[this.m_vcEnemies.size()];
                EnemyItem enemyItem = new EnemyItem(this, this.m_imgEnemy[c]);
                enemyItem.reset();
                enemyItem.m_iDir = this.getRand(4);
                enemyItem.setType(7);
                enemyItem.setPosition(19 * n, 19 * n2);
                if (c == '\u0002') {
                    enemyItem.setNumCellRows(1);
                    enemyItem.setNumCellColumns(2);
                }
                this.m_vcEnemies.addElement(enemyItem);
            }
        }
        this.m_imgGame.getGraphics().setClip(0, 0, this.m_imgGame.getWidth(), this.m_imgGame.getHeight());
        this.m_imgGame.getGraphics().drawImage(this.m_imgGround, 0, 0, 20);
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < 15; ++n) {
                if (this.m_aBlocksData[n2][n] == null) continue;
                this.m_aBlocksData[n2][n].render(this.m_imgGame.getGraphics());
            }
        }
        this.play();
    }

    private void play() {
        this.m_iGameState = 6;
    }

    public int getRand(int n) {
        int n2 = Math.abs(this.m_rnd.nextInt()) % n;
        return n2;
    }

    public void gameOver() {
        this.m_bCanGameResume = false;
        this.m_highScores.update(this.m_iScore);
        this.m_highScores.save();
        this.m_lGameOverTick = 0L;
        this.m_oldFrameTick = System.currentTimeMillis();
        this.m_iGameState = 7;
    }

    private void newCredits() {
        this.m_iCreditTextYPos = this.getHeight();
        this.m_iGameState = 10;
    }

    public void win() {
        this.m_bWin = true;
        this.m_highScores.update(this.m_iScore);
        this.m_highScores.save();
        this.m_lWinTick = 0L;
        this.m_oldFrameTick = System.currentTimeMillis();
        this.m_iGameState = 8;
    }

    public boolean isPlaying() {
        return this.m_iGameState == 6;
    }

    private void processInput() {
        if (this.m_iGameState == 3) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                this.m_display.setCurrent((Displayable)this.m_profile);
            }
        } else if (this.m_iGameState == 11) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                this.newMenu();
            }
        } else if (this.m_iGameState == 9) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                this.newMenu();
            }
        } else if (this.m_iGameState == 10) {
            if (this.m_releasedKeys[6]) {
                this.m_releasedKeys[6] = false;
                if (this.m_bWin && this.m_highScores.isTopSix() != -1) {
                    this.newHighscores();
                } else {
                    this.newMenu();
                }
            }
        } else if (this.m_iGameState == 4) {
            this.m_menu.ProcessInput(this);
        } else {
            if (this.m_pressedKeys[0]) {
                this.m_iResumeState = this.m_iGameState;
                this.newMenu();
            }
            if (this.m_pressedKeys[1]) {
                if (!this.m_bPauseDone) {
                    this.m_bPauseDone = true;
                    boolean bl = this.m_bPaused = !this.m_bPaused;
                    if (this.m_bPaused) {
                        this.m_lBlinkTick = 0L;
                        this.m_bBlinkShow = true;
                    }
                }
            } else {
                this.m_bPauseDone = false;
            }
            this.processGameInput();
        }
    }

    void rockMove(RockItem rockItem) {
        if (rockItem.m_bInit) {
            int n = this.indexFromPosX(rockItem.getX() + rockItem.getWidth());
            int n2 = this.indexFromPosY(rockItem.getY());
            int n3 = this.indexFromPosY(rockItem.getY() + rockItem.getHeight());
            int n4 = this.indexFromPosY(rockItem.getY() + rockItem.getHeight() * 2);
            if (n >= 0 && n < 15 && n3 >= 0 && n3 < 10 && n4 >= 0 && n4 < 10 && this.m_aBlocksData[n2][n] == null && this.m_aBlocksData[n3][n] == null && this.m_aBlocksData[n4][n] == null) {
                this.m_aBlocksData[this.indexFromPosY((int)rockItem.getY())][this.indexFromPosX((int)rockItem.getX())] = null;
                rockItem.moveRight();
                rockItem.m_bInit = false;
                rockItem.m_bCanInjure = true;
            }
            if (rockItem.m_bInit) {
                n = this.indexFromPosX(rockItem.getX() - rockItem.getWidth());
                n2 = this.indexFromPosY(rockItem.getY());
                n3 = this.indexFromPosY(rockItem.getY() + rockItem.getHeight());
                n4 = this.indexFromPosY(rockItem.getY() + rockItem.getHeight() * 2);
                if (n >= 0 && n < 15 && n3 >= 0 && n3 < 10 && n4 >= 0 && n4 < 10 && this.m_aBlocksData[n2][n] == null && this.m_aBlocksData[n3][n] == null && this.m_aBlocksData[n4][n] == null) {
                    this.m_aBlocksData[this.indexFromPosY((int)rockItem.getY())][this.indexFromPosX((int)rockItem.getX())] = null;
                    rockItem.moveLeft();
                    rockItem.m_bInit = false;
                    rockItem.m_bCanInjure = true;
                }
            }
        } else {
            int n = this.indexFromPosX(rockItem.getX());
            int n5 = this.indexFromPosY(rockItem.getY() + rockItem.getHeight());
            if (n5 >= 0 && n5 < 10) {
                if (this.m_aBlocksData[n5][n] == null) {
                    rockItem.m_bCanInjure = true;
                    rockItem.moveDown();
                } else {
                    this.m_aBlocksData[n5 - 1][n] = rockItem;
                    rockItem.m_bCanInjure = rockItem.isCollidedWith(this.m_sptPlayer) && !this.m_sptPlayer.isExplode();
                }
            }
        }
    }

    boolean canEnemyMove(EnemyItem enemyItem) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        n = this.indexFromPosX(enemyItem.getX() - enemyItem.getWidth());
        n5 = this.indexFromPosY(enemyItem.getY());
        n2 = this.indexFromPosX(enemyItem.getX() + enemyItem.getWidth());
        n6 = this.indexFromPosY(enemyItem.getY());
        n3 = this.indexFromPosX(enemyItem.getX());
        n7 = this.indexFromPosY(enemyItem.getY() - enemyItem.getHeight());
        n4 = this.indexFromPosX(enemyItem.getX());
        n8 = this.indexFromPosY(enemyItem.getY() + enemyItem.getHeight());
        return this.m_aBlocksData[n5][n] == null || this.m_aBlocksData[n6][n2] == null || this.m_aBlocksData[n7][n3] == null || this.m_aBlocksData[n8][n4] == null;
    }

    void enemyMove(EnemyItem enemyItem) {
        int n = 0;
        int n2 = 0;
        if (enemyItem.m_iDir == 0) {
            n = this.indexFromPosX(enemyItem.getX() - enemyItem.getWidth());
            n2 = this.indexFromPosY(enemyItem.getY());
        } else if (enemyItem.m_iDir == 1) {
            n = this.indexFromPosX(enemyItem.getX() + enemyItem.getWidth());
            n2 = this.indexFromPosY(enemyItem.getY());
        } else if (enemyItem.m_iDir == 2) {
            n = this.indexFromPosX(enemyItem.getX());
            n2 = this.indexFromPosY(enemyItem.getY() - enemyItem.getHeight());
        } else if (enemyItem.m_iDir == 3) {
            n = this.indexFromPosX(enemyItem.getX());
            n2 = this.indexFromPosY(enemyItem.getY() + enemyItem.getHeight());
        }
        while (this.m_aBlocksData[n2][n] != null) {
            enemyItem.m_iDir = this.getRand(4);
            if (enemyItem.m_iDir == 0) {
                n = this.indexFromPosX(enemyItem.getX() - enemyItem.getWidth());
                n2 = this.indexFromPosY(enemyItem.getY());
                continue;
            }
            if (enemyItem.m_iDir == 1) {
                n = this.indexFromPosX(enemyItem.getX() + enemyItem.getWidth());
                n2 = this.indexFromPosY(enemyItem.getY());
                continue;
            }
            if (enemyItem.m_iDir == 2) {
                n = this.indexFromPosX(enemyItem.getX());
                n2 = this.indexFromPosY(enemyItem.getY() - enemyItem.getHeight());
                continue;
            }
            if (enemyItem.m_iDir != 3) continue;
            n = this.indexFromPosX(enemyItem.getX());
            n2 = this.indexFromPosY(enemyItem.getY() + enemyItem.getHeight());
        }
        if (enemyItem.m_iDir == 0) {
            enemyItem.moveLeft();
        } else if (enemyItem.m_iDir == 1) {
            enemyItem.moveRight();
        } else if (enemyItem.m_iDir == 2) {
            enemyItem.moveUp();
        } else if (enemyItem.m_iDir == 3) {
            enemyItem.moveDown();
        }
    }

    void playerMoveLeft() {
        int n = this.indexFromPosX(this.m_sptPlayer.getX() - this.m_sptPlayer.getWidth());
        int n2 = this.indexFromPosY(this.m_sptPlayer.getY());
        if (n >= 0 && n < 15) {
            if (this.m_aBlocksData[n2][n] == null) {
                this.m_sptPlayer.moveLeft();
            } else if (this.m_aBlocksData[n2][n].getType() == 3) {
                this.m_sptPlayer.moveLeft();
                this.m_sptPlayer.setGotKey(true);
                this.m_aBlocksData[n2][n] = null;
            } else if (this.m_aBlocksData[n2][n].getType() == 2) {
                this.m_sptPlayer.moveLeft();
            } else if (this.m_aBlocksData[n2][n].getType() == 4) {
                this.m_sptPlayer.moveLeft();
                ++this.m_iScore;
                this.m_aBlocksData[n2][n] = null;
            } else if (this.m_aBlocksData[n2][n].getType() == 5 && (this.indexFromPosX(this.m_aBlocksData[n2][n].getX()) != n || this.indexFromPosY(this.m_aBlocksData[n2][n].getY()) != n2)) {
                this.m_sptPlayer.moveLeft();
            }
        }
    }

    void playerMoveRight() {
        int n = this.indexFromPosX(this.m_sptPlayer.getX() + this.m_sptPlayer.getWidth());
        int n2 = this.indexFromPosY(this.m_sptPlayer.getY());
        if (n >= 0 && n < 15) {
            if (this.m_aBlocksData[n2][n] == null) {
                this.m_sptPlayer.moveRight();
            } else if (this.m_aBlocksData[n2][n].getType() == 3) {
                this.m_sptPlayer.moveRight();
                this.m_sptPlayer.setGotKey(true);
                this.m_aBlocksData[n2][n] = null;
            } else if (this.m_aBlocksData[n2][n].getType() == 2) {
                this.m_sptPlayer.moveRight();
            } else if (this.m_aBlocksData[n2][n].getType() == 4) {
                this.m_sptPlayer.moveRight();
                ++this.m_iScore;
                this.m_aBlocksData[n2][n] = null;
            } else if (this.m_aBlocksData[n2][n].getType() == 5 && (this.indexFromPosX(this.m_aBlocksData[n2][n].getX()) != n || this.indexFromPosY(this.m_aBlocksData[n2][n].getY()) != n2)) {
                this.m_sptPlayer.moveRight();
            }
        }
    }

    void playerMoveUp() {
        int n = this.indexFromPosX(this.m_sptPlayer.getX());
        int n2 = this.indexFromPosY(this.m_sptPlayer.getY() - this.m_sptPlayer.getHeight());
        if (n2 >= 0 && n2 < 10) {
            if (this.m_aBlocksData[n2][n] == null) {
                this.m_sptPlayer.moveUp();
            } else if (this.m_aBlocksData[n2][n].getType() == 3) {
                this.m_sptPlayer.moveUp();
                this.m_sptPlayer.setGotKey(true);
                this.m_aBlocksData[n2][n] = null;
            } else if (this.m_aBlocksData[n2][n].getType() == 2) {
                this.m_sptPlayer.moveUp();
            } else if (this.m_aBlocksData[n2][n].getType() == 4) {
                this.m_sptPlayer.moveUp();
                ++this.m_iScore;
                this.m_aBlocksData[n2][n] = null;
            } else if (this.m_aBlocksData[n2][n].getType() == 5 && (this.indexFromPosX(this.m_aBlocksData[n2][n].getX()) != n || this.indexFromPosY(this.m_aBlocksData[n2][n].getY()) != n2)) {
                this.m_sptPlayer.moveUp();
            }
        }
    }

    void playerMoveDown() {
        int n = this.indexFromPosX(this.m_sptPlayer.getX());
        int n2 = this.indexFromPosY(this.m_sptPlayer.getY() + this.m_sptPlayer.getHeight());
        if (n2 >= 0 && n2 < 10) {
            if (this.m_aBlocksData[n2][n] == null) {
                this.m_sptPlayer.moveDown();
            } else if (this.m_aBlocksData[n2][n].getType() == 3) {
                this.m_sptPlayer.moveDown();
                this.m_sptPlayer.setGotKey(true);
                this.m_aBlocksData[n2][n] = null;
            } else if (this.m_aBlocksData[n2][n].getType() == 2) {
                this.m_sptPlayer.moveDown();
            } else if (this.m_aBlocksData[n2][n].getType() == 4) {
                this.m_sptPlayer.moveDown();
                ++this.m_iScore;
                this.m_aBlocksData[n2][n] = null;
            } else if (this.m_aBlocksData[n2][n].getType() == 5 && (this.indexFromPosX(this.m_aBlocksData[n2][n].getX()) != n || this.indexFromPosY(this.m_aBlocksData[n2][n].getY()) != n2)) {
                this.m_sptPlayer.moveDown();
            }
        }
    }

    private boolean isDoorOpened() {
        if (!this.m_sptPlayer.isMoving() && this.m_sptPlayer.isGotKey()) {
            int n = this.indexFromPosX(this.m_sptPlayer.getX());
            int n2 = this.indexFromPosY(this.m_sptPlayer.getY());
            if (this.m_aBlocksData[n2][n] != null && this.m_aBlocksData[n2][n].getType() == 2) {
                return true;
            }
        }
        return false;
    }

    private void processGameInput() {
        if (this.m_iGameState != 6 || this.m_bPaused) {
            return;
        }
        if (this.m_pressedKeys[2]) {
            if (!this.m_sptPlayer.isExplode()) {
                this.playerMoveLeft();
            }
        } else if (this.m_pressedKeys[3]) {
            if (!this.m_sptPlayer.isExplode()) {
                this.playerMoveRight();
            }
        } else if (this.m_pressedKeys[4]) {
            if (!this.m_sptPlayer.isExplode()) {
                this.playerMoveUp();
            }
        } else if (this.m_pressedKeys[5] && !this.m_sptPlayer.isExplode()) {
            this.playerMoveDown();
        }
        if (this.m_pressedKeys[6]) {
            if (!this.m_bKeyPressedFlags[4]) {
                this.m_bKeyPressedFlags[4] = true;
            }
        } else {
            this.m_bKeyPressedFlags[4] = false;
        }
    }

    private synchronized void updateNDrawAll(Graphics graphics) {
        Object object;
        int n;
        int n2;
        Graphics graphics2 = this.m_imgGame.getGraphics();
        if (this.getGameState() == 6 && !this.m_bPaused) {
            this.m_sptPlayer.update(this.m_lFrameTickDiff);
        }
        if ((n2 = this.m_sptPlayer.getX() - 88) < 0) {
            n2 = 0;
        } else if (n2 > this.m_imgGame.getWidth() - 176) {
            n2 = this.m_imgGame.getWidth() - 176;
        }
        int n3 = 0;
        graphics2.setClip(n2, n3, 176, 208);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 15; ++j) {
                if (this.m_aBlocksData[i][j] == null) {
                    graphics2.setClip(j * 19, i * 19, 19, 19);
                    graphics2.drawImage(this.m_imgGround, 0, 0, 20);
                    graphics2.setClip(0, 0, this.m_imgGame.getWidth(), this.m_imgGame.getHeight());
                    continue;
                }
                if (this.m_aBlocksData[i][j].getType() == 2) {
                    this.m_aBlocksData[i][j].render(graphics2);
                    continue;
                }
                if (this.m_aBlocksData[i][j].getType() != 5 || this.indexFromPosX(this.m_aBlocksData[i][j].getX()) == j && this.indexFromPosY(this.m_aBlocksData[i][j].getY()) == i) continue;
                graphics2.setClip(j * 19, i * 19, 19, 19);
                graphics2.drawImage(this.m_imgGround, 0, 0, 20);
                graphics2.setClip(0, 0, this.m_imgGame.getWidth(), this.m_imgGame.getHeight());
            }
        }
        graphics2.setClip(n2, n3, 176, 208);
        for (n = 0; n < this.m_vcRocks.size(); ++n) {
            object = (RockItem)this.m_vcRocks.elementAt(n);
            if (this.getGameState() == 6 && !this.m_bPaused) {
                ((RockItem)object).update(this.m_lFrameTickDiff);
                this.rockMove((RockItem)object);
                if (((NvSprite)object).isCollidedWith(this.m_sptPlayer) && !this.m_sptPlayer.isExplode() && ((RockItem)object).m_bCanInjure) {
                    this.m_sptPlayer.explode();
                }
            }
            ((NvGridSprite)object).render(graphics2);
        }
        for (n = 0; n < this.m_vcEnemies.size(); ++n) {
            object = (EnemyItem)this.m_vcEnemies.elementAt(n);
            if (this.getGameState() == 6 && !this.m_bPaused) {
                ((EnemyItem)object).update(this.m_lFrameTickDiff);
                if (this.canEnemyMove((EnemyItem)object)) {
                    this.enemyMove((EnemyItem)object);
                }
                if (((NvSprite)object).isCollidedWith(this.m_sptPlayer) && !this.m_sptPlayer.isExplode()) {
                    this.m_sptPlayer.explode();
                }
            }
            ((NvGridSprite)object).render(graphics2);
        }
        graphics2.setClip(0, 0, this.m_imgGame.getWidth(), this.m_imgGame.getHeight());
        this.m_sptPlayer.render(graphics2);
        graphics.setClip(this.m_relX, this.m_relY, 176, 208);
        graphics.drawImage(this.m_imgGame, this.m_relX - n2, this.m_relY - n3, 20);
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
        if (this.getGameState() == 6 && !this.m_bPaused) {
            if (this.isDoorOpened()) {
                this.m_sptPlayer.setVisible(false);
                this.win();
            } else if (this.m_sptPlayer.isExplosionCompleted()) {
                this.m_progressBar.setValue(this.m_progressBar.getValue() - 1);
                if (this.m_progressBar.getValue() <= 0) {
                    this.gameOver();
                } else {
                    this.tryAgain();
                }
            }
        }
        graphics.setClip(this.m_relX, this.m_relY + this.m_rTetrisArena.bottom, 176, 208 - this.m_rTetrisArena.bottom);
        graphics.drawImage(this.m_imgBlack, this.m_relX, this.m_relY, 20);
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
        this.m_progressBar.render(graphics);
        object = TextResources.getString(28) + ": " + this.m_iScore;
        this.renderCenteredYellowText(graphics, (String)object, this.m_fontTexts3, this.m_relX + (174 - this.m_fontTexts3.stringWidth((String)object) / 2), this.m_relY + 200);
        if (this.m_bPaused) {
            this.renderPauseMsg(graphics, TextResources.getString(24), this.m_fontTexts2);
        }
    }

    private boolean canGameResume() {
        return this.m_bCanGameResume;
    }

    public void newMenu() {
        this.m_menu.m_bEnabledFirstItem = this.canGameResume();
        this.m_menu.reset();
        this.m_releasedKeys[6] = false;
        this.m_iGameState = 4;
    }

    public void menuDone(int n) {
        switch (n) {
            case 0: {
                this.m_iGameState = this.m_iResumeState;
                break;
            }
            case 1: {
                this.newGame(1);
                break;
            }
            case 2: {
                this.newHighscores();
                break;
            }
            case 3: {
                this.newGameControls();
                break;
            }
            case 4: {
                NvHelp.showInstructions(this.m_display);
                break;
            }
            case 5: {
                this.newCredits();
                break;
            }
            case 6: {
                this.m_midlet.m_bNeedExit = true;
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 2: {
                this.m_pressedKeys[2] = true;
                this.m_releasedKeys[2] = false;
                break;
            }
            case 5: {
                this.m_pressedKeys[3] = true;
                this.m_releasedKeys[3] = false;
                break;
            }
            case 8: {
                this.m_pressedKeys[6] = true;
                this.m_releasedKeys[6] = false;
                break;
            }
            case 1: {
                this.m_pressedKeys[4] = true;
                this.m_releasedKeys[4] = false;
                break;
            }
            case 6: {
                this.m_pressedKeys[5] = true;
                this.m_releasedKeys[5] = false;
                break;
            }
            case 0: {
                switch (n) {
                    case 52: {
                        this.m_pressedKeys[2] = true;
                        this.m_releasedKeys[2] = false;
                        break block0;
                    }
                    case 54: {
                        this.m_pressedKeys[3] = true;
                        this.m_releasedKeys[3] = false;
                        break block0;
                    }
                    case 53: {
                        this.m_pressedKeys[6] = true;
                        this.m_releasedKeys[6] = false;
                        break block0;
                    }
                    case 50: {
                        this.m_pressedKeys[4] = true;
                        this.m_releasedKeys[4] = false;
                        break block0;
                    }
                    case 56: {
                        this.m_pressedKeys[5] = true;
                        this.m_releasedKeys[5] = false;
                    }
                }
            }
        }
        if (n == 42) {
            this.m_pressedKeys[0] = true;
            this.m_releasedKeys[0] = false;
        } else if (n == 35) {
            this.m_pressedKeys[1] = true;
            this.m_releasedKeys[1] = false;
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 2: {
                this.m_pressedKeys[2] = false;
                this.m_releasedKeys[2] = true;
                break;
            }
            case 5: {
                this.m_pressedKeys[3] = false;
                this.m_releasedKeys[3] = true;
                break;
            }
            case 8: {
                this.m_pressedKeys[6] = false;
                this.m_releasedKeys[6] = true;
                break;
            }
            case 1: {
                this.m_pressedKeys[4] = false;
                this.m_releasedKeys[4] = true;
                break;
            }
            case 6: {
                this.m_pressedKeys[5] = false;
                this.m_releasedKeys[5] = true;
                break;
            }
            case 0: {
                switch (n) {
                    case 52: {
                        this.m_pressedKeys[2] = false;
                        this.m_releasedKeys[2] = true;
                        break block0;
                    }
                    case 54: {
                        this.m_pressedKeys[3] = false;
                        this.m_releasedKeys[3] = true;
                        break block0;
                    }
                    case 53: {
                        this.m_pressedKeys[6] = false;
                        this.m_releasedKeys[6] = true;
                        break block0;
                    }
                    case 50: {
                        this.m_pressedKeys[4] = false;
                        this.m_releasedKeys[4] = true;
                        break block0;
                    }
                    case 56: {
                        this.m_pressedKeys[5] = false;
                        this.m_releasedKeys[5] = true;
                    }
                }
            }
        }
        if (n == 42) {
            this.m_pressedKeys[0] = false;
            this.m_releasedKeys[0] = true;
        } else if (n == 35) {
            this.m_pressedKeys[1] = false;
            this.m_releasedKeys[1] = true;
        }
    }

    int indexFromPosX(int n) {
        int n2 = (n - this.m_rTetrisArena.left) / 19;
        return n2;
    }

    int indexFromPosY(int n) {
        int n2 = (n - this.m_rTetrisArena.top) / 19;
        return n2;
    }

    Item getBlockData(int n, int n2) {
        int n3 = this.indexFromPosX(n);
        int n4 = this.indexFromPosY(n2);
        return this.m_aBlocksData[n4][n3];
    }

    void setBlockData(int n, int n2, Item item) {
        int n3 = this.indexFromPosX(n);
        int n4 = this.indexFromPosY(n2);
        this.m_aBlocksData[n4][n3] = item;
    }
}

