/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GBCanvas
extends Canvas
implements CommandListener {
    public MeBoy parent;
    private ICpu cpu;
    private int w;
    private int h;
    private int l;
    private int t;
    private int sw;
    private int sh;
    private int trans;
    private int ssw;
    private int ssh;
    private boolean clear = true;
    boolean showFps = false;
    private int[] previousTime = new int[8];
    private int previousTimeIx;
    private boolean fullScreen;
    private Command pause = new Command("Pause", 1, 0);
    private Command resume = new Command("Resume", 1, 0);
    private static int[] key = new int[]{54, 52, 50, 56, 55, 57, 35, 42};
    private static String[] keyName = new String[]{"right", "left", "up", "down", "a", "b", "select", "start"};
    private int keySetCounter;
    private boolean settingKeys;
    private String cartName;
    private String suspendName;
    private Image buf;
    private Graphics bufg;
    private Thread cpuThread;

    private GBCanvas() {
        this.addCommand(this.pause);
        this.addCommand(new Command("Exit", 7, 1));
        if (this.showFps) {
            this.addCommand(new Command("Hide framerate", 1, 10));
        } else {
            this.addCommand(new Command("Show framerate", 1, 10));
        }
        this.addCommand(new Command("Set buttons", 1, 11));
        this.addCommand(new Command("Suspend", 1, 16));
        this.addCommand(new Command("Full screen", 1, 17));
        this.addCommand(new Command("Unload cart", 1, 2));
        this.setCommandListener(this);
        if (MeBoy.rotations != 0) {
            this.buf = Image.createImage((int)160, (int)144);
            this.bufg = this.buf.getGraphics();
        }
        this.fullScreen = MeBoy.fullScreen;
        this.setFullScreenMode(this.fullScreen);
    }

    public GBCanvas(MeBoy p, String suspendName) throws RecordStoreException {
        this();
        this.parent = p;
        this.suspendName = suspendName;
        RecordStore rs = RecordStore.openRecordStore((String)("s" + suspendName), (boolean)false);
        byte[] b = rs.getRecord(1);
        rs.closeRecordStore();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (b[i] != 0) {
            sb.append((char)b[i]);
            ++i;
        }
        this.cartName = sb.toString();
        this.cpu = this.isColor(this.cartName) && !MeBoy.disableColor ? new DmgcpuColor(this.cartName, this, b, i + 1) : new DmgcpuBW(this.cartName, this, b, i + 1);
        this.setDimensions();
        this.cpuThread = new Thread(this.cpu);
        this.cpuThread.start();
    }

    public GBCanvas(MeBoy p, String cart, boolean timing) {
        this();
        this.parent = p;
        this.cartName = cart;
        this.cpu = this.isColor(cart) && !MeBoy.disableColor ? new DmgcpuColor(cart, this) : new DmgcpuBW(cart, this);
        if (this.cpu.hasBattery()) {
            this.loadCartRam();
        }
        this.setDimensions();
        this.cpuThread = new Thread(this.cpu);
        this.cpuThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isColor(String cartName) {
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream(cartName + 0);
            if (is.skip(323L) != 323L) {
                throw new RuntimeException("failed skipping to 0x143");
            }
            int i = is.read();
            if (i >= 0 && (i & 0x80) == 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public void setDimensions() {
        boolean rotate;
        this.w = this.getWidth();
        this.h = this.getHeight();
        int[] transs = new int[]{0, 5, 3, 6};
        this.trans = transs[MeBoy.rotations];
        boolean bl = rotate = (MeBoy.rotations & 1) != 0;
        if (MeBoy.enableScaling) {
            int deltah = this.showFps ? -16 : 0;
            this.cpu.setScale(rotate ? this.h + deltah : this.w, rotate ? this.w : this.h + deltah);
        }
        this.ssw = this.sw = 20 * this.cpu.getTileWidth();
        this.ssh = this.sh = 18 * this.cpu.getTileHeight();
        if (MeBoy.rotations != 0) {
            this.buf = Image.createImage((int)this.ssw, (int)this.ssh);
            this.bufg = this.buf.getGraphics();
        }
        if (rotate) {
            this.sw = this.ssh;
            this.sh = this.ssw;
        }
        this.l = (this.w - this.sw) / 2;
        this.t = (this.h - this.sh) / 2;
        if (this.showFps) {
            this.t -= 8;
        }
        if (this.l < 0) {
            this.l = 0;
        }
        if (this.t < 0) {
            this.t = 0;
        }
        this.cpu.setTranslation(this.trans == 0 ? this.l : 0, this.trans == 0 ? this.t : 0);
    }

    public void keyReleased(int keyCode) {
        for (int i = 0; i < 8; ++i) {
            if (keyCode != key[i]) continue;
            this.cpu.buttonUp(i);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.settingKeys) {
            GBCanvas.key[this.keySetCounter++] = keyCode;
            if (this.keySetCounter == 8) {
                GBCanvas.writeSettings();
                this.settingKeys = false;
            }
            this.clear = true;
            this.repaint();
            return;
        }
        for (int i = 0; i < 8; ++i) {
            if (keyCode != key[i]) continue;
            this.cpu.buttonDown(i);
        }
    }

    public void commandAction(Command c, Displayable s) {
        try {
            String label = c.getLabel();
            if (label == "Exit") {
                if (this.cpu.hasBattery()) {
                    this.saveCartRam();
                }
                this.parent.destroyApp(true);
                this.parent.notifyDestroyed();
            } else if (label == "Unload cart") {
                if (this.cpu.hasBattery()) {
                    this.saveCartRam();
                }
                this.parent.unloadCart();
                Runtime.getRuntime().gc();
            } else if (label == "Pause") {
                this.removeCommand(this.pause);
                this.addCommand(this.resume);
                this.cpu.terminate();
            } else if (label == "Resume" && !this.settingKeys) {
                this.removeCommand(this.resume);
                this.addCommand(this.pause);
                this.cpuThread = new Thread(this.cpu);
                this.cpuThread.start();
            } else if (label == "Show framerate") {
                this.removeCommand(c);
                this.addCommand(new Command("Hide framerate", 1, 10));
                this.showFps = true;
                this.setDimensions();
            } else if (label == "Hide framerate") {
                this.removeCommand(c);
                this.addCommand(new Command("Show framerate", 1, 10));
                this.showFps = false;
                this.setDimensions();
            } else if (label == "Set buttons" && !this.settingKeys) {
                this.settingKeys = true;
                this.keySetCounter = 0;
            } else if (label == "Suspend" && !this.settingKeys) {
                if (!this.cpu.isTerminated()) {
                    this.cpu.terminate();
                    while (this.cpuThread.isAlive()) {
                        Thread.yield();
                    }
                    this.suspend();
                    this.cpuThread = new Thread(this.cpu);
                    this.cpuThread.start();
                } else {
                    this.suspend();
                }
            } else if (label == "Full screen" && !this.settingKeys) {
                this.fullScreen = !this.fullScreen;
                this.setFullScreenMode(this.fullScreen);
                this.setDimensions();
            }
        }
        catch (Throwable t) {
            MeBoy.log(t.toString());
            MeBoy.showLog();
        }
        this.clear = true;
        this.repaint();
    }

    public final void redrawSmall() {
        if (this.showFps) {
            this.repaint(this.l, this.t, this.sw, this.sh + 16);
        } else {
            this.repaint(this.l, this.t, this.sw, this.sh);
        }
    }

    public final void showNotify() {
        this.clear = true;
        this.repaint();
    }

    public final void paintFps(Graphics g) {
        g.setClip(this.l, this.t + this.sh, 80, 16);
        g.setColor(-1);
        g.fillRect(this.l, this.t + this.sh, 80, 16);
        g.setColor(0);
        int now = (int)System.currentTimeMillis();
        int estfps = (16320 + now - this.previousTime[this.previousTimeIx]) / (now - this.previousTime[this.previousTimeIx]) >> 1;
        this.previousTime[this.previousTimeIx] = now;
        this.previousTimeIx = this.previousTimeIx + 1 & 7;
        g.drawString(estfps + " fps * " + (this.cpu.getLastSkipCount() + 1), this.l + 1, this.t + this.sh, 20);
    }

    public final void paint(Graphics g) {
        if (this.cpu == null) {
            return;
        }
        if (!this.clear) {
            if (this.showFps) {
                this.paintFps(g);
            }
            g.setClip(this.l, this.t, this.sw, this.sh);
            if (this.trans == 0) {
                this.cpu.draw(g);
            } else {
                this.cpu.draw(this.bufg);
                g.drawRegion(this.buf, 0, 0, this.ssw, this.ssh, this.trans, this.l, this.t, 20);
            }
        } else if (this.settingKeys) {
            g.setColor(0x446688);
            g.fillRect(0, 0, this.w, this.h);
            g.setColor(-1);
            g.drawString("press the", this.w / 2, this.h / 2 - 18, 65);
            g.drawString("button for", this.w / 2, this.h / 2, 65);
            g.drawString(keyName[this.keySetCounter], this.w / 2, this.h / 2 + 18, 65);
        } else {
            if (g.getClipHeight() == this.h) {
                this.clear = false;
            }
            g.setColor(0x666666);
            g.fillRect(0, 0, this.w, this.h);
            g.setColor(-1);
            g.fillRect(this.l, this.t, this.sw, this.sh);
            if (this.showFps) {
                this.paintFps(g);
            }
            g.setClip(this.l, this.t, this.sw, this.sh);
            if (this.trans == 0) {
                this.cpu.draw(g);
            } else {
                this.cpu.draw(this.bufg);
                g.drawRegion(this.buf, 0, 0, this.ssw, this.ssh, this.trans, this.l, this.t, 20);
            }
        }
    }

    public static final void setInt(byte[] b, int i, int v) {
        b[i++] = (byte)(v >> 24);
        b[i++] = (byte)(v >> 16);
        b[i++] = (byte)(v >> 8);
        b[i++] = (byte)v;
    }

    public static final int getInt(byte[] b, int i) {
        int r = b[i++] & 0xFF;
        r = (r << 8) + (b[i++] & 0xFF);
        r = (r << 8) + (b[i++] & 0xFF);
        return (r << 8) + (b[i++] & 0xFF);
    }

    public static final void writeSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"set", (boolean)true);
            int bLength = 52;
            for (int i = 0; i < MeBoy.suspendIndex.length; ++i) {
                bLength += 1 + MeBoy.suspendIndex[i].length();
            }
            byte[] b = new byte[++bLength];
            for (int i = 0; i < 8; ++i) {
                GBCanvas.setInt(b, i * 4, key[i]);
            }
            GBCanvas.setInt(b, 32, MeBoy.maxFrameSkip);
            GBCanvas.setInt(b, 36, MeBoy.rotations);
            GBCanvas.setInt(b, 40, MeBoy.lazyLoadingThreshold);
            GBCanvas.setInt(b, 44, MeBoy.suspendCounter);
            GBCanvas.setInt(b, 48, MeBoy.suspendIndex.length);
            int index = 52;
            for (int i = 0; i < MeBoy.suspendIndex.length; ++i) {
                String s = MeBoy.suspendIndex[i];
                b[index++] = (byte)s.length();
                for (int j = 0; j < s.length(); ++j) {
                    b[index++] = (byte)s.charAt(j);
                }
            }
            b[index++] = (byte)((MeBoy.enableScaling ? 1 : 0) + (MeBoy.keepProportions ? 2 : 0) + (MeBoy.fullScreen ? 4 : 0) + (MeBoy.disableColor ? 8 : 0));
            if (rs.getNumRecords() == 0) {
                rs.addRecord(b, 0, bLength);
            } else {
                rs.setRecord(1, b, 0, bLength);
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            MeBoy.log(e.toString());
        }
    }

    public static final void readSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"set", (boolean)true);
            if (rs.getNumRecords() > 0) {
                byte[] b = rs.getRecord(1);
                for (int i = 0; i < 8; ++i) {
                    GBCanvas.key[i] = GBCanvas.getInt(b, i * 4);
                }
                if (b.length >= 36) {
                    MeBoy.maxFrameSkip = GBCanvas.getInt(b, 32);
                }
                if (b.length >= 40) {
                    MeBoy.rotations = GBCanvas.getInt(b, 36);
                }
                if (b.length >= 44) {
                    MeBoy.lazyLoadingThreshold = GBCanvas.getInt(b, 40);
                }
                if (b.length >= 48) {
                    MeBoy.suspendCounter = GBCanvas.getInt(b, 44);
                    MeBoy.suspendIndex = new String[GBCanvas.getInt(b, 48)];
                    int index = 52;
                    for (int i = 0; i < MeBoy.suspendIndex.length; ++i) {
                        int slen = b[index++] & 0xFF;
                        MeBoy.suspendIndex[i] = new String(b, index, slen);
                        index += slen;
                    }
                    if (b.length > index) {
                        MeBoy.enableScaling = (b[index] & 1) != 0;
                        MeBoy.keepProportions = (b[index] & 2) != 0;
                        MeBoy.fullScreen = (b[index] & 4) != 0;
                        MeBoy.disableColor = (b[index] & 8) != 0;
                        ++index;
                    }
                } else {
                    MeBoy.suspendIndex = new String[0];
                }
            } else {
                GBCanvas.writeSettings();
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            MeBoy.log(e.toString());
        }
    }

    private final void saveCartRam() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)this.cartName, (boolean)true);
            byte[][] ram = this.cpu.getCartRam();
            int bankCount = ram.length;
            int bankSize = ram[0].length;
            int size = bankCount * bankSize + 13;
            byte[] b = new byte[size];
            for (int i = 0; i < bankCount; ++i) {
                System.arraycopy(ram[i], 0, b, i * bankSize, bankSize);
            }
            System.arraycopy(this.cpu.getRtcReg(), 0, b, bankCount * bankSize, 5);
            long now = System.currentTimeMillis();
            GBCanvas.setInt(b, bankCount * bankSize + 5, (int)(now >> 32));
            GBCanvas.setInt(b, bankCount * bankSize + 9, (int)now);
            if (rs.getNumRecords() == 0) {
                rs.addRecord(b, 0, size);
            } else {
                rs.setRecord(1, b, 0, size);
            }
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadCartRam() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)this.cartName, (boolean)true);
            if (rs.getNumRecords() > 0) {
                byte[][] ram = this.cpu.getCartRam();
                int bankCount = ram.length;
                int bankSize = ram[0].length;
                byte[] b = rs.getRecord(1);
                for (int i = 0; i < bankCount; ++i) {
                    System.arraycopy(b, i * bankSize, ram[i], 0, bankSize);
                }
                if (b.length == bankCount * bankSize + 13) {
                    System.arraycopy(b, bankCount * bankSize, this.cpu.getRtcReg(), 0, 5);
                    long time = GBCanvas.getInt(b, bankCount * bankSize + 5);
                    time = (time << 32) + ((long)GBCanvas.getInt(b, bankCount * bankSize + 9) & 0xFFFFFFFFL);
                    time = System.currentTimeMillis() - time;
                    this.cpu.rtcSkip((int)(time / 1000L));
                }
            }
            rs.closeRecordStore();
        }
        catch (Exception e) {
            MeBoy.log(e.toString());
        }
    }

    private final void suspend() {
        try {
            boolean insertIndex = false;
            if (this.suspendName == null) {
                this.suspendName = MeBoy.suspendCounter++ + ": " + this.cartName;
                insertIndex = true;
            }
            RecordStore rs = RecordStore.openRecordStore((String)("s" + this.suspendName), (boolean)true);
            byte[] b = this.cpu.flatten();
            if (rs.getNumRecords() == 0) {
                rs.addRecord(b, 0, b.length);
            } else {
                rs.setRecord(1, b, 0, b.length);
            }
            rs.closeRecordStore();
            if (insertIndex) {
                MeBoy.addSuspendedGame(this.suspendName);
            }
            MeBoy.log("suspended to " + this.suspendName);
        }
        catch (Exception e) {
            MeBoy.log("failed suspend: " + e);
            MeBoy.showLog();
        }
    }

    public void releaseReferences() {
        this.cpu.terminate();
        while (this.cpuThread.isAlive()) {
            Thread.yield();
        }
        this.cpu.releaseReferences();
        this.cpu = null;
        this.buf = null;
        this.bufg = null;
        this.cartName = null;
        this.pause = null;
        this.resume = null;
        this.previousTime = null;
        this.parent = null;
        System.gc();
    }
}

