/*
 * Decompiled with CFR 0.152.
 */
package TheClub;

import TheClub.cCanvas;
import TheClub.cGameObject;
import TheClub.cGameResources;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class cLevel {
    private cCanvas m_cnvs;
    private cGameResources m_res;
    private static int canvasWidth;
    private static int canvasHeight;
    public static byte TILE_WIDTH;
    public static byte TILE_HEIGHT;
    private static final int[] LOW_TILESET_TILES;
    private static final byte[] TILESET_COLLISION_OFFSET;
    private static final byte[] levelxsizes;
    private static final byte[] levelysizes;
    private static final String[] str_LOW_TILESET_DAT;
    private static Image[] road_layer_tiles;
    public static byte[][] currentmaptiles_low;
    private static byte TILE_NUM_COL;
    private static byte TILE_NUM_ROW;
    private static int terrainScrollx;
    private static int terrainScrolly;
    private static int startTileX;
    private static int startTileY;
    private static int endTileX;
    private static int endTileY;
    private static int drawTileX;
    private static int drawTileY;
    private static int loadTileCount;
    private static int tileset_section;
    private static int tx;
    private static int ty;
    private static Image tempTileImage;
    private static int LOAD_TILE_INCREMENT;
    private static InputStream m_TileMap_file_input;
    private static DataInputStream m_TileMap_data_in;

    public cLevel(cCanvas cCanvas2, cGameResources cGameResources2) {
        this.m_cnvs = cCanvas2;
        this.m_res = cGameResources2;
        canvasWidth = this.m_cnvs.m_iWidth;
        canvasHeight = this.m_cnvs.m_iHeight;
        loadTileCount = -1;
    }

    public byte loadLevel_Stage1() {
        if (loadTileCount == -1) {
            road_layer_tiles = new Image[LOW_TILESET_TILES[cGameResources.currentLevel / 5]];
            tileset_section = 0;
            loadTileCount = 0;
            return 0;
        }
        try {
            switch (cGameResources.currentLevel / 5) {
                case 0: {
                    if (loadTileCount % -16 == 0) {
                        tempTileImage = Image.createImage((String)("/res/level_1_road_layer_tiles" + tileset_section + ".png"));
                        ++tileset_section;
                        ty = 0;
                        break;
                    }
                    ++ty;
                    break;
                }
                case 1: {
                    if (loadTileCount % -16 == 0) {
                        tempTileImage = Image.createImage((String)("/res/level_2_road_layer_tiles" + tileset_section + ".png"));
                        ++tileset_section;
                        ty = 0;
                        break;
                    }
                    ++ty;
                    break;
                }
                case 2: {
                    if (loadTileCount % -16 == 0) {
                        tempTileImage = Image.createImage((String)("/res/level_3_road_layer_tiles" + tileset_section + ".png"));
                        ++tileset_section;
                        ty = 0;
                        break;
                    }
                    ++ty;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tx = 0;
        int n = 0;
        while (n < LOAD_TILE_INCREMENT) {
            if (loadTileCount >= LOW_TILESET_TILES[cGameResources.currentLevel / 5]) break;
            if (tx == 4) {
                tx = 0;
                ++ty;
            }
            cLevel.road_layer_tiles[cLevel.loadTileCount] = Image.createImage((int)TILE_WIDTH, (int)TILE_HEIGHT);
            road_layer_tiles[loadTileCount].getGraphics().drawImage(tempTileImage, -(tx * TILE_WIDTH), -(ty * TILE_HEIGHT), 0);
            ++n;
            ++tx;
            ++loadTileCount;
        }
        if (loadTileCount == LOW_TILESET_TILES[cGameResources.currentLevel / 5]) {
            tempTileImage = null;
            loadTileCount = -1;
            terrainScrollx = 0;
            terrainScrolly = 0;
            TILE_NUM_COL = levelxsizes[cGameResources.currentLevel];
            TILE_NUM_ROW = levelysizes[cGameResources.currentLevel];
            return 1;
        }
        return 0;
    }

    public byte loadLevel_Stage2() {
        try {
            if (loadTileCount == -1) {
                currentmaptiles_low = new byte[TILE_NUM_ROW][TILE_NUM_COL];
                loadTileCount = 0;
                tx = 0;
                ty = 0;
                m_TileMap_file_input = this.getClass().getResourceAsStream(str_LOW_TILESET_DAT[cGameResources.currentLevel]);
                m_TileMap_data_in = new DataInputStream(m_TileMap_file_input);
                return 0;
            }
            for (int i = 0; i < 300; ++i) {
                try {
                    cLevel.currentmaptiles_low[cLevel.ty][cLevel.tx] = m_TileMap_data_in.readByte();
                }
                catch (EOFException eOFException) {
                    break;
                }
                if (++tx == levelxsizes[cGameResources.currentLevel / 5]) {
                    tx = 0;
                    ++ty;
                }
                if (++loadTileCount != TILE_NUM_COL * TILE_NUM_ROW) continue;
                m_TileMap_data_in.close();
                loadTileCount = -1;
                return 1;
            }
        }
        catch (IOException iOException) {
            System.out.println("IO Exception =: " + iOException);
        }
        return 0;
    }

    public void drawLevel(Graphics graphics) {
        startTileX = terrainScrollx / TILE_WIDTH - 1;
        startTileY = terrainScrolly / TILE_HEIGHT - 1;
        endTileX = (cGameResources.qABS(terrainScrollx) + canvasWidth) / TILE_WIDTH + 1;
        endTileY = (cGameResources.qABS(terrainScrolly) + canvasHeight) / TILE_HEIGHT + 1;
        if (endTileX >= TILE_NUM_COL) {
            endTileX = TILE_NUM_COL - 1;
        }
        if (endTileY >= TILE_NUM_ROW) {
            endTileY = TILE_NUM_ROW - 1;
        }
        if (startTileX < 0) {
            startTileX = 0;
        }
        if (startTileY < 0) {
            startTileY = 0;
        }
        drawTileY = endTileY;
        while (drawTileY + 1 > startTileY) {
            drawTileX = endTileX;
            while (drawTileX + 1 > startTileX) {
                if (currentmaptiles_low[drawTileY][drawTileX] + 127 != 0) {
                    graphics.drawImage(road_layer_tiles[currentmaptiles_low[drawTileY][drawTileX] + 127], drawTileX * TILE_WIDTH - terrainScrollx, drawTileY * TILE_HEIGHT - terrainScrolly, 0);
                }
                --drawTileX;
            }
            --drawTileY;
        }
    }

    public void setCamera(cGameObject cGameObject2) {
        if (cGameObject2 == null) {
            return;
        }
        terrainScrollx = cGameObject2.m_iXpos - (canvasWidth >> 1);
        terrainScrolly = cGameObject2.m_iYpos - (canvasHeight >> 1);
        if (terrainScrollx < 0) {
            terrainScrollx = 0;
        }
        if (terrainScrollx > TILE_WIDTH * TILE_NUM_COL - canvasWidth) {
            terrainScrollx = TILE_WIDTH * TILE_NUM_COL - canvasWidth;
        }
        if (terrainScrolly < 0) {
            terrainScrolly = 0;
        }
        if (terrainScrolly > TILE_HEIGHT * TILE_NUM_ROW - canvasHeight) {
            terrainScrolly = TILE_HEIGHT * TILE_NUM_ROW - canvasHeight;
        }
    }

    public int getterrainScrollx() {
        return terrainScrollx;
    }

    public int getterrainScrolly() {
        return terrainScrolly;
    }

    public int collision_horizontal(cGameObject cGameObject2, int n, int n2, int n3) {
        int n4;
        int n5 = n + n3;
        boolean bl = false;
        cGameObject2.tilecoordy = n2 / TILE_HEIGHT;
        int n6 = n4 / TILE_WIDTH;
        for (n4 = n - n % TILE_WIDTH; n4 <= n5; n4 += TILE_WIDTH) {
            if (n6 < 0 || n6 > TILE_NUM_COL - 1 || cGameObject2.tilecoordy < 0 || cGameObject2.tilecoordy > TILE_NUM_ROW - 1) {
                return 0;
            }
            if (currentmaptiles_low[cGameObject2.tilecoordy][n6] + 127 > TILESET_COLLISION_OFFSET[cGameResources.currentLevel / 5]) {
                return 1;
            }
            ++n6;
        }
        return 0;
    }

    public int collision_vertical(cGameObject cGameObject2, int n, int n2, int n3) {
        int n4;
        int n5 = n2 + n3;
        boolean bl = false;
        cGameObject2.tilecoordx = n / TILE_WIDTH;
        int n6 = n4 / TILE_HEIGHT;
        for (n4 = n2 - n2 % TILE_HEIGHT; n4 <= n5; n4 += TILE_HEIGHT) {
            if (cGameObject2.tilecoordx < 0 || cGameObject2.tilecoordx > TILE_NUM_COL - 1 || n6 < 0 || n6 > TILE_NUM_ROW - 1) {
                return 0;
            }
            if (currentmaptiles_low[n6][cGameObject2.tilecoordx] + 127 > TILESET_COLLISION_OFFSET[cGameResources.currentLevel / 5]) {
                return 1;
            }
            ++n6;
        }
        return 0;
    }

    public void TileBasedCheckCollision(cGameObject cGameObject2, int n, int n2) {
        if (cGameObject2.m_massObj.vel.x > 0) {
            switch (this.collision_vertical(cGameObject2, (cGameObject2.m_massObj.pos.x >> 12) + (cGameObject2.m_massObj.vel.x >> 12) - (n >> 1) + n, (cGameObject2.m_massObj.pos.y >> 12) - (n2 >> 1), n2)) {
                case 1: {
                    cGameObject2.m_iFlags |= 0x2000;
                    cGameObject2.m_massObj.pos.x = cGameObject2.tilecoordx * TILE_WIDTH - n - 1 << 12;
                    cGameObject2.m_massObj.pos.x -= n >> 1 << 12;
                    cGameObject2.m_massObj.vel.x = 0;
                    break;
                }
                default: {
                    cGameObject2.m_massObj.pos.x += cGameObject2.m_massObj.vel.x;
                    break;
                }
            }
        } else if (cGameObject2.m_massObj.vel.x < 0) {
            switch (this.collision_vertical(cGameObject2, (cGameObject2.m_massObj.pos.x >> 12) + (cGameObject2.m_massObj.vel.x >> 12) - (n >> 1), (cGameObject2.m_massObj.pos.y >> 12) - (n2 >> 1), n2)) {
                case 1: {
                    cGameObject2.m_iFlags |= 0x2000;
                    cGameObject2.m_massObj.pos.x = (cGameObject2.tilecoordx + 1) * TILE_WIDTH << 12;
                    cGameObject2.m_massObj.pos.x += n >> 1 << 12;
                    cGameObject2.m_massObj.vel.x = 0;
                    break;
                }
                default: {
                    cGameObject2.m_massObj.pos.x += cGameObject2.m_massObj.vel.x;
                }
            }
        }
        if (cGameObject2.m_massObj.vel.y < 0) {
            switch (this.collision_horizontal(cGameObject2, (cGameObject2.m_massObj.pos.x >> 12) - (n >> 1), (cGameObject2.m_massObj.pos.y >> 12) + (cGameObject2.m_massObj.vel.y >> 12) - (n2 >> 1), n)) {
                case 1: {
                    cGameObject2.m_iFlags |= 0x2000;
                    cGameObject2.m_massObj.pos.y = (cGameObject2.tilecoordy + 1) * TILE_HEIGHT << 12;
                    cGameObject2.m_massObj.pos.y += n2 >> 1 << 12;
                    cGameObject2.m_massObj.vel.y = 0;
                    break;
                }
                default: {
                    cGameObject2.m_massObj.pos.y += cGameObject2.m_massObj.vel.y;
                    break;
                }
            }
        } else {
            switch (this.collision_horizontal(cGameObject2, (cGameObject2.m_massObj.pos.x >> 12) - (n >> 1), (cGameObject2.m_massObj.pos.y >> 12) + (cGameObject2.m_massObj.vel.y >> 12) - (n2 >> 1) + n2, n)) {
                case 1: {
                    cGameObject2.m_iFlags |= 0x2000;
                    cGameObject2.m_massObj.pos.y = cGameObject2.tilecoordy * TILE_HEIGHT - n2 - 1 << 12;
                    cGameObject2.m_massObj.pos.y -= n2 >> 1 << 12;
                    cGameObject2.m_massObj.vel.y = 4096;
                    break;
                }
                default: {
                    cGameObject2.m_massObj.pos.y += cGameObject2.m_massObj.vel.y;
                }
            }
        }
    }

    static {
        TILE_WIDTH = (byte)24;
        TILE_HEIGHT = (byte)24;
        LOW_TILESET_TILES = new int[]{192, 224, 147};
        TILESET_COLLISION_OFFSET = new byte[]{53, 59, 59};
        levelxsizes = new byte[]{85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85};
        levelysizes = new byte[]{85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85};
        str_LOW_TILESET_DAT = new String[]{"/res/level_11_road_layer_tiles.dat", "/res/level_12_road_layer_tiles.dat", "/res/level_13_road_layer_tiles.dat", "/res/level_14_road_layer_tiles.dat", "/res/level_15_road_layer_tiles.dat", "/res/level_21_road_layer_tiles.dat", "/res/level_22_road_layer_tiles.dat", "/res/level_23_road_layer_tiles.dat", "/res/level_24_road_layer_tiles.dat", "/res/level_25_road_layer_tiles.dat", "/res/level_31_road_layer_tiles.dat", "/res/level_32_road_layer_tiles.dat", "/res/level_33_road_layer_tiles.dat", "/res/level_34_road_layer_tiles.dat", "/res/level_35_road_layer_tiles.dat"};
        LOAD_TILE_INCREMENT = 8;
    }
}

