/*
 * Decompiled with CFR 0.152.
 */
import com.bsg.motorola.BSCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ChainsCanvas
extends BSCanvas {
    private boolean endCanvas = false;
    private boolean targetCanvas = false;
    private boolean resuming = false;
    private boolean randomise = true;
    private boolean ready = false;
    private boolean starting = true;
    private boolean complete;
    private boolean dead;
    private Image[] tiles;
    private Image options;
    private Image highlight;
    private Image backBuffer;
    private int difficulty = 0;
    private int tileSpacingY = 10;
    private int tileSpacingX = 10;
    private int intX = 0;
    private int intY = 0;
    private int[][][] startRings = new int[][][]{new int[][]{{1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 2, 2, 2, 2, 2}, {1, 3, 3, 3, 3, 3}}, new int[][]{{0, 0, 1, 0, 1, 0}, {1, 2, 1, 3, 1, 0}, {1, 2, 2, 2, 1, 2}, {1, 3, 1, 3, 3, 3}}, new int[][]{{1, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1}, {1, 2, 2, 2, 2, 1}, {1, 3, 3, 3, 3, 1}}, new int[][]{{1, 0, 0, 0, 0, 1}, {1, 1, 2, 1, 0, 1}, {1, 1, 2, 2, 2, 2}, {1, 2, 3, 3, 3, 0}}, new int[][]{{3, 0, 0, 1, 1, 3}, {0, 1, 1, 2, 2, 0}, {3, 3, 1, 1, 2, 2}, {0, 0, 2, 2, 3, 3}}};
    private int[][][] startRingPosX = new int[][][]{new int[][]{{3, 2, 1, 0, 1, 2}, {4, 3, 3, 4, 5, 5}, {5, 6, 7, 8, 7, 6}, {4, 5, 5, 4, 3, 3}}, new int[][]{{0, 2, 4, 3, 2, 1}, {4, 5, 6, 4, 2, 3}, {4, 6, 8, 7, 6, 5}, {2, 4, 6, 5, 4, 3}}, new int[][]{{3, 2, 1, 0, 1, 2}, {3, 4, 4, 3, 2, 2}, {3, 4, 5, 6, 5, 4}, {4, 5, 4, 2, 1, 2}}, new int[][]{{2, 1, 0, 0, 1, 2}, {2, 3, 3, 2, 1, 1}, {2, 2, 3, 4, 4, 3}, {2, 3, 3, 2, 1, 1}}, new int[][]{{0, 1, 3, 4, 3, 1}, {3, 4, 4, 3, 2, 2}, {0, 1, 3, 4, 3, 1}, {1, 2, 2, 1, 0, 0}}};
    private int[][][] startRingPosY = new int[][][]{new int[][]{{1, 2, 2, 1, 0, 0}, {3, 2, 1, 0, 1, 2}, {1, 0, 0, 1, 2, 2}, {3, 4, 5, 6, 5, 4}}, new int[][]{{0, 0, 0, 1, 2, 1}, {0, 1, 2, 2, 2, 1}, {0, 0, 0, 1, 2, 1}, {2, 2, 2, 3, 4, 3}}, new int[][]{{1, 2, 2, 1, 0, 0}, {1, 2, 3, 4, 3, 2}, {1, 0, 0, 1, 2, 2}, {3, 4, 5, 5, 4, 3}}, new int[][]{{3, 4, 3, 1, 0, 1}, {1, 2, 4, 5, 4, 2}, {3, 1, 0, 1, 3, 4}, {3, 4, 6, 7, 6, 4}}, new int[][]{{1, 0, 0, 1, 2, 2}, {0, 1, 3, 4, 3, 1}, {3, 2, 2, 3, 4, 4}, {0, 1, 3, 4, 3, 1}}};
    private int[][] ringCentreX = new int[][]{{3, 8, 13, 8}, {4, 8, 12, 8}, {3, 6, 9, 6}, {2, 4, 6, 4}, {4, 6, 4, 2}};
    private int[][] ringCentreY = new int[][]{{2, 3, 2, 9}, {2, 2, 2, 6}, {2, 5, 2, 8}, {4, 6, 4, 10}, {2, 4, 6, 4}};
    private int selectedRing = 1;
    private int[][] ringPosX;
    private int[][] ringPosY;
    private int[][] rings;

    public ChainsCanvas() {
        this.tiles = new Image[4];
        try {
            for (int i = 0; i < 4; ++i) {
                this.tiles[i] = Image.createImage((String)String.valueOf(String.valueOf(new StringBuffer("/Tile").append(i + 1).append(".png"))));
            }
            this.options = Image.createImage((String)"/Options.png");
            this.highlight = Image.createImage((String)"/Highlight.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.backBuffer = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.reset();
    }

    public void reset() {
        int n;
        int n2;
        this.endCanvas = false;
        this.targetCanvas = false;
        this.randomise = true;
        this.complete = false;
        this.ready = false;
        this.starting = true;
        this.rings = new int[this.startRings[this.difficulty].length][this.startRings[this.difficulty][0].length];
        for (n2 = 0; n2 < this.startRings[this.difficulty].length; ++n2) {
            for (n = 0; n < this.startRings[this.difficulty][n2].length; ++n) {
                this.rings[n2][n] = this.startRings[this.difficulty][n2][n];
            }
        }
        this.ringPosX = new int[this.startRingPosX[this.difficulty].length][this.startRingPosX[this.difficulty][0].length];
        for (n2 = 0; n2 < this.startRingPosX[this.difficulty].length; ++n2) {
            for (n = 0; n < this.startRingPosX[this.difficulty][n2].length; ++n) {
                this.ringPosX[n2][n] = this.startRingPosX[this.difficulty][n2][n];
            }
        }
        this.ringPosY = new int[this.startRingPosY[this.difficulty].length][this.startRingPosY[this.difficulty][0].length];
        for (n2 = 0; n2 < this.startRingPosY[this.difficulty].length; ++n2) {
            for (n = 0; n < this.startRingPosY[this.difficulty][n2].length; ++n) {
                this.ringPosY[n2][n] = this.startRingPosY[this.difficulty][n2][n];
            }
        }
        this.screenSize();
    }

    private void screenSize() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.ringPosX.length; ++i) {
            for (int j = 0; j < this.ringPosX[i].length; ++j) {
                if (this.ringPosX[i][j] > n) {
                    n = this.ringPosX[i][j];
                }
                if (this.ringPosY[i][j] <= n2) continue;
                n2 = this.ringPosY[i][j];
            }
        }
        this.tileSpacingY = this.getHeight() / (n2 + 2);
        this.tileSpacingX = this.getWidth() / (n + 2);
        this.intX = (this.getWidth() - this.tileSpacingX * n) / 2;
        this.intY = (this.getHeight() - this.tileSpacingY * n2) / 2;
    }

    public void loadGame(byte[] byArray, Gauge gauge) throws Exception {
        gauge.setValue(10);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        gauge.setValue(20);
        this.difficulty = dataInputStream.readInt();
        this.reset();
        gauge.setValue(40);
        this.randomise = dataInputStream.readBoolean();
        this.rings = new int[this.startRings[this.difficulty].length][this.startRings[this.difficulty][0].length];
        gauge.setValue(60);
        for (int i = 0; i < this.rings.length; ++i) {
            for (int j = 0; j < this.rings[i].length; ++j) {
                this.rings[i][j] = dataInputStream.readByte();
            }
        }
        gauge.setValue(80);
        this.paused = false;
        this.complete = false;
        this.ready = true;
        this.starting = false;
        this.resuming = true;
        this.screenSize();
        gauge.setValue(100);
    }

    public byte[] saveGame(Gauge gauge) {
        gauge.setValue(10);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        gauge.setValue(30);
        try {
            dataOutputStream.writeInt(this.difficulty);
            dataOutputStream.writeBoolean(this.randomise);
            gauge.setValue(50);
            for (int i = 0; i < this.rings.length; ++i) {
                for (int j = 0; j < this.rings[i].length; ++j) {
                    dataOutputStream.writeByte((byte)this.rings[i][j]);
                }
            }
            gauge.setValue(70);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gauge.setValue(100);
        return byteArrayOutputStream.toByteArray();
    }

    public void nextLevel(Gauge gauge) {
    }

    private void checkRings() {
        block0 : switch (this.difficulty) {
            case 0: {
                switch (this.selectedRing) {
                    case 0: {
                        this.rings[1][2] = this.rings[0][0];
                        break;
                    }
                    case 1: {
                        this.rings[0][0] = this.rings[1][2];
                        this.rings[2][0] = this.rings[1][4];
                        this.rings[3][0] = this.rings[1][0];
                        break;
                    }
                    case 2: {
                        this.rings[1][4] = this.rings[2][0];
                        break;
                    }
                    case 3: {
                        this.rings[1][0] = this.rings[3][0];
                    }
                }
                break;
            }
            case 1: {
                switch (this.selectedRing) {
                    case 0: {
                        this.rings[1][0] = this.rings[0][2];
                        this.rings[2][0] = this.rings[0][2];
                        this.rings[1][5] = this.rings[0][3];
                        this.rings[1][4] = this.rings[0][4];
                        this.rings[3][0] = this.rings[0][4];
                        break;
                    }
                    case 1: {
                        this.rings[0][2] = this.rings[1][0];
                        this.rings[2][0] = this.rings[1][0];
                        this.rings[2][5] = this.rings[1][1];
                        this.rings[2][4] = this.rings[1][2];
                        this.rings[3][2] = this.rings[1][2];
                        this.rings[3][1] = this.rings[1][3];
                        this.rings[0][4] = this.rings[1][4];
                        this.rings[3][0] = this.rings[1][4];
                        this.rings[0][3] = this.rings[1][5];
                        break;
                    }
                    case 2: {
                        this.rings[0][2] = this.rings[2][0];
                        this.rings[1][0] = this.rings[2][0];
                        this.rings[1][2] = this.rings[2][4];
                        this.rings[3][2] = this.rings[2][4];
                        this.rings[1][1] = this.rings[2][5];
                        break;
                    }
                    case 3: {
                        this.rings[0][4] = this.rings[3][0];
                        this.rings[1][4] = this.rings[3][0];
                        this.rings[1][3] = this.rings[3][1];
                        this.rings[1][2] = this.rings[3][2];
                        this.rings[2][4] = this.rings[3][2];
                    }
                }
                break;
            }
            case 2: {
                switch (this.selectedRing) {
                    case 0: {
                        this.rings[1][0] = this.rings[0][0];
                        this.rings[1][5] = this.rings[0][1];
                        this.rings[2][0] = this.rings[0][0];
                        break;
                    }
                    case 1: {
                        this.rings[0][1] = this.rings[1][5];
                        this.rings[0][0] = this.rings[1][0];
                        this.rings[2][0] = this.rings[1][0];
                        this.rings[2][5] = this.rings[1][1];
                        this.rings[3][0] = this.rings[1][2];
                        this.rings[3][5] = this.rings[1][4];
                        break;
                    }
                    case 2: {
                        this.rings[0][0] = this.rings[2][0];
                        this.rings[1][0] = this.rings[2][0];
                        this.rings[1][1] = this.rings[2][5];
                        break;
                    }
                    case 3: {
                        this.rings[1][2] = this.rings[3][0];
                        this.rings[1][4] = this.rings[3][5];
                    }
                }
                break;
            }
            case 3: {
                switch (this.selectedRing) {
                    case 0: {
                        this.rings[1][0] = this.rings[0][5];
                        this.rings[1][4] = this.rings[0][1];
                        this.rings[2][1] = this.rings[0][5];
                        this.rings[2][0] = this.rings[0][0];
                        this.rings[3][0] = this.rings[0][0];
                        this.rings[3][5] = this.rings[0][1];
                        break;
                    }
                    case 1: {
                        this.rings[0][5] = this.rings[1][0];
                        this.rings[0][1] = this.rings[1][4];
                        this.rings[2][1] = this.rings[1][0];
                        this.rings[2][5] = this.rings[1][2];
                        this.rings[3][1] = this.rings[1][2];
                        this.rings[3][5] = this.rings[1][4];
                        break;
                    }
                    case 2: {
                        this.rings[0][0] = this.rings[2][0];
                        this.rings[0][5] = this.rings[2][1];
                        this.rings[1][0] = this.rings[2][1];
                        this.rings[1][2] = this.rings[2][5];
                        this.rings[3][1] = this.rings[2][5];
                        this.rings[3][0] = this.rings[2][0];
                        break;
                    }
                    case 3: {
                        this.rings[0][0] = this.rings[3][0];
                        this.rings[0][1] = this.rings[3][5];
                        this.rings[2][0] = this.rings[3][0];
                        this.rings[2][5] = this.rings[3][1];
                        this.rings[1][2] = this.rings[3][1];
                        this.rings[1][4] = this.rings[3][5];
                    }
                }
                break;
            }
            case 4: {
                switch (this.selectedRing) {
                    case 0: {
                        this.rings[3][5] = this.rings[0][0];
                        this.rings[3][0] = this.rings[0][1];
                        this.rings[1][0] = this.rings[0][2];
                        this.rings[1][1] = this.rings[0][3];
                        this.rings[2][2] = this.rings[0][4];
                        this.rings[2][1] = this.rings[0][5];
                        break block0;
                    }
                    case 1: {
                        this.rings[0][2] = this.rings[1][0];
                        this.rings[0][3] = this.rings[1][1];
                        this.rings[2][3] = this.rings[1][2];
                        this.rings[2][4] = this.rings[1][3];
                        this.rings[3][2] = this.rings[1][4];
                        this.rings[3][1] = this.rings[1][5];
                        break block0;
                    }
                    case 2: {
                        this.rings[3][4] = this.rings[2][0];
                        this.rings[0][5] = this.rings[2][1];
                        this.rings[0][4] = this.rings[2][2];
                        this.rings[1][2] = this.rings[2][3];
                        this.rings[1][3] = this.rings[2][4];
                        this.rings[3][3] = this.rings[2][5];
                        break block0;
                    }
                    case 3: {
                        this.rings[0][1] = this.rings[3][0];
                        this.rings[1][5] = this.rings[3][1];
                        this.rings[1][4] = this.rings[3][2];
                        this.rings[2][5] = this.rings[3][3];
                        this.rings[2][0] = this.rings[3][4];
                        this.rings[0][0] = this.rings[3][5];
                    }
                }
            }
        }
    }

    private int abs(int n) {
        if (n > -1) {
            return n;
        }
        return -n;
    }

    public void startGame(int n, Gauge gauge) {
        this.difficulty = n;
        this.reset();
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Graphics graphics2 = graphics;
        graphics = this.backBuffer.getGraphics();
        graphics.setGrayScale(255);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setGrayScale(0);
        if (!this.targetCanvas && !this.endCanvas) {
            int n3;
            graphics.translate(this.intX, this.intY);
            n2 = 0;
            for (n = 0; n < 4; ++n) {
                for (n3 = 0; n3 < 6; ++n3) {
                    graphics.drawLine(this.ringPosX[n][n3] * this.tileSpacingX + n * n2, this.ringPosY[n][n3] * this.tileSpacingY, this.ringPosX[n][(n3 + 1) % 6] * this.tileSpacingX + n * n2, this.ringPosY[n][(n3 + 1) % 6] * this.tileSpacingY);
                }
            }
            for (n = 0; n < 4; ++n) {
                for (n3 = 0; n3 < 6; ++n3) {
                    graphics.drawImage(this.tiles[this.rings[n][n3]], this.ringPosX[n][n3] * this.tileSpacingX + n * n2, this.ringPosY[n][n3] * this.tileSpacingY, 1 | 2);
                }
            }
            graphics.drawImage(this.highlight, this.ringCentreX[this.difficulty][this.selectedRing] * this.tileSpacingX / 2, this.ringCentreY[this.difficulty][this.selectedRing] * this.tileSpacingY / 2, 1 | 2);
            graphics.translate(-this.intX, -this.intY);
            graphics.drawImage(this.options, this.getWidth() - this.options.getWidth(), this.getHeight() - this.options.getHeight(), 0x10 | 4);
            if (this.ready) {
                n = 0;
                for (n3 = 0; n3 < this.rings.length && n == 0; ++n3) {
                    for (int i = 0; i < this.rings[0].length && n == 0; ++i) {
                        if (this.rings[n3][i] == this.startRings[this.difficulty][n3][i]) continue;
                        n = 1;
                    }
                }
                if (n == 0) {
                    this.resuming = true;
                    this.complete = true;
                }
            }
            if (this.paused) {
                this.drawText(graphics, new String[]{this.langT[0]}, this.getFont(this.langA[0]), true, this.getWidth() / 2, this.getHeight() / 2);
            } else if (this.resuming || this.complete || this.starting) {
                if (this.complete) {
                    BSCanvas.vibrate(50, 500);
                }
                this.drawText(graphics, new String[]{this.langT[1], this.langT[2]}, this.getFont(this.langA[1]), true, this.getWidth() / 2, this.getHeight() / 2);
            } else if (this.randomise) {
                this.drawText(graphics, new String[]{this.langT[3], this.langT[4]}, this.getFont(this.langA[3]), true, this.getWidth() / 2, this.getHeight() / 2);
            }
        }
        if (this.targetCanvas) {
            graphics.translate(this.intX, this.intY);
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 6; ++n) {
                    graphics.drawLine(this.ringPosX[n2][n] * this.tileSpacingX, this.ringPosY[n2][n] * this.tileSpacingY, this.ringPosX[n2][(n + 1) % 6] * this.tileSpacingX, this.ringPosY[n2][(n + 1) % 6] * this.tileSpacingY);
                }
            }
            for (n2 = 0; n2 < 4; ++n2) {
                for (n = 0; n < 6; ++n) {
                    graphics.drawImage(this.tiles[this.startRings[this.difficulty][n2][n]], this.ringPosX[n2][n] * this.tileSpacingX, this.ringPosY[n2][n] * this.tileSpacingY, 1 | 2);
                }
            }
            graphics.translate(-this.intX, -this.intY);
        }
        if (this.endCanvas) {
            this.drawText(graphics, new String[]{this.langT[5], this.langT[6]}, this.getFont(this.langA[5]), true, this.getWidth() / 2, 2);
            this.drawText(graphics, new String[]{this.langT[1], this.langT[2]}, this.getFont(this.langA[1]), true, this.getWidth() / 2, this.getHeight() * 2 / 3);
        }
        graphics2.drawImage(this.backBuffer, 0, 0, 0x10 | 4);
    }

    private void drawText(Graphics graphics, String[] stringArray, Font font, boolean bl, int n, int n2) {
        Font[] fontArray = new Font[stringArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = font;
        }
        this.drawText(graphics, stringArray, fontArray, bl, n, n2);
    }

    private void drawText(Graphics graphics, String[] stringArray, Font[] fontArray, boolean bl, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            if (stringArray[n3].equals("")) continue;
            n5 = Math.max(fontArray[n3].stringWidth(stringArray[n3]), n5);
            n7 += fontArray[n3].getHeight();
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n - n5 / 2 - 2, n2 - 2, n5 + 2, n7 + 2);
        graphics.setColor(0);
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            if (stringArray[n3].equals("")) continue;
            n4 = fontArray[n3].stringWidth(stringArray[n3]);
            graphics.setFont(fontArray[n3]);
            graphics.drawString(stringArray[n3], n, n2 + n6, 17);
            n6 += fontArray[n3].getHeight();
        }
        if (bl) {
            graphics.drawRect(n - n5 / 2 - 2, n2 - 2, n5 + 2, n7 + 2);
        }
    }

    public void keyPressed(int n) {
        if (!this.targetCanvas) {
            if (this.endCanvas) {
                this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
            } else if (this.randomise) {
                this.starting = false;
                this.repaint();
                this.serviceRepaints();
                this.randomise = false;
                this.randomise();
            } else if (this.complete) {
                this.endCanvas = true;
                this.repaint();
            } else if (this.resuming) {
                this.resuming = false;
                this.repaint();
            } else if (n == -21) {
                this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            } else if (!this.paused) {
                int n2 = this.getGameAction(n);
                if (n2 != 2 && n2 != 5 && n2 != 1 && n2 != 6 && n2 != 8) {
                    switch (n) {
                        case 50: {
                            n2 = 1;
                            break;
                        }
                        case 52: {
                            n2 = 2;
                            break;
                        }
                        case 53: {
                            n2 = 8;
                            break;
                        }
                        case 54: {
                            n2 = 5;
                            break;
                        }
                        case 56: {
                            n2 = 6;
                        }
                    }
                }
                switch (n2) {
                    case 5: {
                        ++this.selectedRing;
                        this.selectedRing %= 4;
                        if (!this.ready) break;
                        this.repaint();
                        break;
                    }
                    case 2: {
                        --this.selectedRing;
                        this.selectedRing %= 4;
                        if (this.selectedRing < 0) {
                            this.selectedRing = 3;
                        }
                        if (!this.ready) break;
                        this.repaint();
                        break;
                    }
                    case 6: {
                        int n3 = this.rings[this.selectedRing][5];
                        for (int i = 5; i > 0; --i) {
                            this.rings[this.selectedRing][i] = this.rings[this.selectedRing][i - 1];
                        }
                        this.rings[this.selectedRing][0] = n3;
                        this.checkRings();
                        if (!this.ready) break;
                        this.repaint();
                        break;
                    }
                    case 1: {
                        int n4 = this.rings[this.selectedRing][0];
                        for (int i = 0; i < 5; ++i) {
                            this.rings[this.selectedRing][i] = this.rings[this.selectedRing][i + 1];
                        }
                        this.rings[this.selectedRing][5] = n4;
                        this.checkRings();
                        if (!this.ready) break;
                        this.repaint();
                        break;
                    }
                    case 8: {
                        this.targetCanvas = true;
                        new Timer().schedule((TimerTask)new DisplayTimerTask(), 2000L);
                        this.repaint();
                    }
                }
            }
        }
    }

    private void randomise() {
        block6: for (int i = 0; i < 500; ++i) {
            int n = BSCanvas.getRandom(4);
            switch (n) {
                case 0: {
                    this.keyPressed(this.getKeyCode(5));
                    continue block6;
                }
                case 1: {
                    this.keyPressed(this.getKeyCode(2));
                    continue block6;
                }
                case 2: {
                    this.keyPressed(this.getKeyCode(1));
                    continue block6;
                }
                case 3: {
                    this.keyPressed(this.getKeyCode(6));
                }
            }
        }
        this.selectedRing = 1;
        this.ready = true;
        this.repaint();
        System.gc();
    }

    private class DisplayTimerTask
    extends TimerTask {
        private DisplayTimerTask() {
        }

        public void run() {
            ChainsCanvas.this.targetCanvas = false;
            ChainsCanvas.this.repaint();
        }
    }
}

