/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Calendar;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class BlockCityCanvas
extends Canvas
implements Runnable,
CommandListener {
    public static final int STATE_INIT = 0;
    public static final int STATE_LOAD = 1;
    public static final int STATE_TITLE = 2;
    public static final int STATE_MENU = 3;
    public static final int STATE_GAME = 4;
    public static final int STATE_PAUSE = 5;
    public static final int STATE_SCORE = 6;
    public static final int STATE_HELP = 7;
    public static final int STATE_CLEAR = 8;
    public static final int STATE_ALLCLEAR = 9;
    public static final int STATE_EXIT = 10;
    public static final int STATE_PREV = 11;
    public static final int STATE_TITLE_Q = 12;
    private static final int TILE_SIZE = 14;
    private static final int BOARD_CNTX = 6;
    private static final int BOARD_CNTY = 6;
    private static final int BOARD_GAPX = 17;
    private static final int BOARD_GAPY = 5;
    private static final int BLOCK_EMPTY = 0;
    private static final int BLOCK_TYPE1_1 = 1;
    private static final int BLOCK_TYPE1_2 = 2;
    private static final int BLOCK_TYPE2_1 = 3;
    private static final int BLOCK_TYPE2_2 = 4;
    private static final int BLOCK_TYPE3_1 = 5;
    private static final int BLOCK_TYPE3_2 = 6;
    private static final int BLOCK_TYPE3_3 = 7;
    private static final int BLOCK_TYPE4_1 = 8;
    private static final int BLOCK_TYPE4_2 = 9;
    private static final int BLOCK_TYPE5_1 = 10;
    private static final int BLOCK_TYPE5_2 = 11;
    private static final int BLOCK_TYPE5_3 = 12;
    private static final int VK_UP = -1;
    private static final int VK_LEFT = -3;
    private static final int VK_RIGHT = -4;
    private static final int VK_DOWN = -2;
    private static final int VK_OK = -5;
    private static final int VK_SOFT1 = 21;
    private static final int VK_SOFT2 = 22;
    private static final int MAP_CNT = 25;
    public int nState = 0;
    private int[][] board;
    private int nStage;
    private int nContinueStage;
    private int nMove;
    private boolean bSelect;
    private int nSelectX;
    private int nSelectY;
    private int nCursorX;
    private int nCursorY;
    private int nClearCnt;
    private int nPrevClearCnt;
    private int nMenuIndex = 0;
    private int nHelpIndex = 0;
    private int nPrevState = 0;
    private BlockCity app;
    Thread th = null;
    private Command cmdStart = new Command("Menu", 4, 1);
    private Command cmdExit = new Command("Exit", 4, 11);
    private Command cmdTitle = new Command("Title", 4, 10);
    private Command cmdPause = new Command("Pause", 4, 0);
    private Command cmdRestart = new Command("Resume", 4, 0);
    private Command cmdOK = new Command("YES", 4, 1);
    private Command cmdCancel = new Command("NO", 4, 9);
    private Command cmdPlay = new Command("Start", 4, 0);
    private Command[] cmd = new Command[2];
    private RecordStore recordStore = null;
    private boolean bExpired = false;
    private RecordStore rcData = null;
    private Image imgLoad1;
    private Image imgLoad2;
    private Image imgTitle;
    private Image imgBoard;
    private Image imgMenu;
    private Image imgBoard0;
    private Image imgBoard1;
    private Image imgBoard2;
    private Image imgBoard3;
    private Image imgBoard4;
    private Image imgBoard5;
    private Image imgBoard6;
    private Image imgBoard7;
    private Image imgMsg;
    private Image imgHand0;
    private Image imgHand1;
    private Image imgBlock;
    private Image imgHelpArrow;
    private Image imgPress;
    private Image imgCopy;
    private Image imgSndOff;
    private boolean bSndOff = false;
    private int nImageState = 0;
    private int nProgress = 0;
    private int press_blink = 0;
    private String[] Map = new String[]{"00000000j000abk00000l000000000000000", "00000000j000abk00000l00000000h0efg0i", "efg00000jefgabk00000l00j00000k0efg0l", "efg00000j0j0abk0k000l0l0h0cd00i00000", "0hcdhh0i0hiiab0i0hcd0h0i000i00000000", "h00efgicdjcdabhk0hcdil0iefg0h00efgi0", "h0j0cdi0k00jabl00k00efgl0000h00efgi0", "00jhcd00ki0jabl0hk0efgilhcdh00icdi00", "h0efg0icdh0jabhi0k00i00l00hcd000iefg", "cd0j00j00k00kabl00l0hefg00i00h0efg0i", "cdhj00cdik000abl00j0efg0k000cdl0efg0", "cdcd0j0000hkabh0iljhicd0ki0hcdlcdicd", "00hcd000i0h00habi00i00cdefg0h00000i0", "efgh0000jicdabk00jh0lcdkihefgl0icdcd", "efg00j00hcdk00iabl00hhcd00iicdefg000", "h0hefgi0ijcdhabk00i00lcd0hcd0h0iefgi", "cdhj0000ik00jabl00k0efg0l00000efg000", "hh0efgii0h0hab0iji0efgk0h0h0lhi0icdi", "h0efgji00cdkabhh0l00iicd00hcd000iefg", "0hjcdj0ik00kabl00lh0cdcdicdhh0efgii0", "00efg000hh00abii00cdhcdjhhicdkii0cdl", "cdjcdj00kh0kabli0l0cdcd0h00h00icdi00", "cdefg0h00hcdiabi0j00jcdkcdk00l00lefg", "0cdcdjcdh0jkabi0kljefgl0k00hcdlcdicd", "jefgcdkh0cdjli0abkefgh0l00hicdcdi000"};

    public void doPause() {
        if (this.nState == 4) {
            this.updateCommands(5);
        }
    }

    public BlockCityCanvas(BlockCity blockCity) {
        this.app = blockCity;
        this.board = new int[6][6];
        this.nStage = 1;
        this.nState = 0;
    }

    protected void showNotify() {
        if (this.th == null) {
            this.loadData();
            this.setCommandListener(this);
            this.th = new Thread(this);
            this.th.start();
        }
    }

    protected void keyPressed(int n) {
        if (n == 42) {
            return;
        }
        switch (this.nState) {
            case 2: {
                this.updateCommands(3);
                break;
            }
            case 3: {
                switch (this.nMenuIndex) {
                    case 0: {
                        if (n != -5) break;
                        this.nStage = 1;
                        this.initStage();
                        this.updateCommands(4);
                        break;
                    }
                    case 1: {
                        if (n == -5) {
                            this.nStage = this.nContinueStage;
                            this.initStage();
                            this.updateCommands(4);
                            break;
                        }
                        if (n == -3) {
                            if (this.nContinueStage <= 1) break;
                            --this.nContinueStage;
                            break;
                        }
                        if (n != -4 || this.nContinueStage > this.nClearCnt || this.nContinueStage >= 25) break;
                        ++this.nContinueStage;
                        break;
                    }
                    case 2: {
                        if (n != -5) break;
                        this.updateCommands(7);
                        break;
                    }
                    case 3: {
                        if (n != -5) break;
                        this.updateCommands(6);
                        break;
                    }
                    case 4: {
                        if (n != -5) break;
                        this.updateCommands(10);
                    }
                }
                if (n == -1) {
                    if (this.nMenuIndex <= 0) break;
                    --this.nMenuIndex;
                    break;
                }
                if (n != -2 || this.nMenuIndex >= 4) break;
                ++this.nMenuIndex;
                break;
            }
            case 4: {
                if (n == -5) {
                    this.selectBlock();
                    break;
                }
                if (n == -1 || n == -2 || n == -3 || n == -4) {
                    if (this.bSelect) {
                        this.moveBlock(n);
                    }
                    if (this.bSelect) break;
                    this.moveCursor(n);
                    break;
                }
                if (n == 21) {
                    this.nState = 3;
                    break;
                }
                if (n == 22) {
                    this.initStage();
                    break;
                }
                if (n == 49) {
                    if (this.nStage == 1 && this.nClearCnt == 25) {
                        this.nStage = 25;
                    } else if (this.nStage != 1) {
                        --this.nStage;
                    }
                    this.initStage();
                    break;
                }
                if (n != 50) break;
                if (this.nStage == 25 && this.nClearCnt == 25) {
                    this.nStage = 1;
                } else if (this.nStage <= this.nClearCnt) {
                    ++this.nStage;
                }
                this.initStage();
                break;
            }
            case 8: {
                if (n != -5) break;
                if (this.nStage == 25) {
                    this.nState = 3;
                    break;
                }
                ++this.nStage;
                this.initStage();
                this.nState = 4;
                this.updateCommands(4);
                break;
            }
            case 6: {
                if (n != -5) break;
                this.updateCommands(3);
                break;
            }
            case 7: {
                if (n == -1 && this.nHelpIndex > 0) {
                    --this.nHelpIndex;
                    break;
                }
                if (n == -2 && this.nHelpIndex < 4) {
                    ++this.nHelpIndex;
                    break;
                }
                if (n != -5) break;
                this.updateCommands(3);
            }
        }
        this.repaint();
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
    }

    protected void paint(Graphics graphics) {
        if (this.nState == 2) {
            this.drawTitle(graphics);
        } else if (this.nState == 12) {
            this.drawTitleQ(graphics);
        } else if (this.nState == 3) {
            this.drawMenu(graphics);
        } else if (this.nState == 4) {
            this.drawGame(graphics);
        } else if (this.nState == 8) {
            this.drawMsg(graphics);
        } else if (this.nState == 6) {
            this.drawScore(graphics);
        } else if (this.nState == 7) {
            this.drawHelp(graphics);
        } else if (this.nState == 5) {
            this.drawPause(graphics);
        } else if (this.nState == 1) {
            this.drawLoad(graphics);
        } else if (this.nState == 10) {
            this.drawExit(graphics);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block15: {
            if (!this.isShown()) break block15;
            this.nState = 1;
            this.loadResource();
            this.nState = 0;
            if (this.nState != 4) ** GOTO lbl20
            ** GOTO lbl33
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
        } while (!this.isShown());
        this.nState = 1;
        this.loadResource();
        this.nState = 0;
        while (true) {
            block16: {
                if (this.nState == 4) break block16;
lbl20:
                // 2 sources

                if (this.nState == 0) {
                    this.updateCommands(2);
                } else if (this.nState == 3) {
                    this.repaint();
                } else if (this.nState == 2 || this.nState == 7) {
                    this.repaint();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException var1_3) {
                        // empty catch block
                    }
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException var1_4) {
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdStart) {
            this.updateCommands(3);
        } else if (command == this.cmdPlay) {
            this.initStage();
            this.updateCommands(4);
        } else if (command == this.cmdExit) {
            this.updateCommands(10);
        } else if (command == this.cmdTitle) {
            if (this.nState == 4) {
                this.updateCommands(12);
            } else {
                this.updateCommands(2);
            }
        } else if (command == this.cmdPause) {
            if (this.nState != 4) {
                return;
            }
            this.updateCommands(5);
        } else if (command == this.cmdRestart) {
            this.updateCommands(4);
        } else if (this.nState == 10) {
            if (command == this.cmdOK) {
                this.app.destroyApp(false);
                this.app.notifyDestroyed();
            } else if (command == this.cmdCancel) {
                this.updateCommands(11);
            }
        } else if (this.nState == 12) {
            if (command == this.cmdOK) {
                this.updateCommands(2);
            } else if (command == this.cmdCancel) {
                this.updateCommands(11);
            }
        }
    }

    private void removeAllCommands() {
        this.removeCommand(this.cmdStart);
        this.removeCommand(this.cmdExit);
        this.removeCommand(this.cmdTitle);
        this.removeCommand(this.cmdPause);
        this.removeCommand(this.cmdRestart);
        this.removeCommand(this.cmdOK);
        this.removeCommand(this.cmdCancel);
        this.removeCommand(this.cmdPlay);
    }

    public void updateCommands(int n) {
        this.cmd[0] = null;
        this.cmd[1] = null;
        if (n == 11) {
            n = this.nPrevState;
        }
        if (n == 2) {
            this.nStage = 1;
            this.cmd[0] = this.cmdStart;
            this.cmd[1] = this.cmdExit;
        } else if (n == 3) {
            this.cmd[0] = this.cmdPlay;
            this.cmd[1] = this.cmdExit;
        } else if (n == 7) {
            this.nHelpIndex = 0;
            this.cmd[0] = this.cmdStart;
            this.cmd[1] = this.cmdPlay;
        } else if (n == 6) {
            this.cmd[0] = this.cmdStart;
            this.cmd[1] = this.cmdPlay;
        } else if (n == 4) {
            this.cmd[0] = this.cmdPause;
            this.cmd[1] = this.cmdTitle;
        } else if (n == 5) {
            this.cmd[0] = this.cmdRestart;
            this.cmd[1] = this.cmdExit;
        } else if (n == 12) {
            this.nPrevState = this.nState;
            this.cmd[0] = this.cmdOK;
            this.cmd[1] = this.cmdCancel;
        } else if (n == 10) {
            this.nPrevState = this.nState;
            this.cmd[0] = this.cmdOK;
            this.cmd[1] = this.cmdCancel;
        } else if (n == 4) {
            this.nPrevState = this.nState;
            this.cmd[0] = this.cmdOK;
            this.cmd[1] = this.cmdCancel;
        }
        this.removeAllCommands();
        if (this.cmd[0] != null) {
            this.addCommand(this.cmd[0]);
        }
        if (this.cmd[1] != null) {
            this.addCommand(this.cmd[1]);
        }
        this.nState = n;
        this.repaint();
    }

    private boolean isExpired() {
        Calendar calendar = Calendar.getInstance();
        try {
            this.recordStore = RecordStore.openRecordStore((String)"expiration", (boolean)true);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            System.out.println((Object)recordStoreNotFoundException);
            recordStoreNotFoundException.printStackTrace();
            return false;
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
            return false;
        }
        try {
            if (this.recordStore.getNumRecords() == 0) {
                int n = Integer.parseInt(String.valueOf(calendar.getTime().getTime() / 86400000L));
                byte[] byArray = String.valueOf(n).getBytes();
                this.recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                int n = Integer.parseInt(new String(this.recordStore.getRecord(1)));
                int n2 = Integer.parseInt(String.valueOf(calendar.getTime().getTime() / 86400000L));
                if (n2 - n > 31) {
                    System.out.println("// EXPIRED!!!");
                    return true;
                }
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            System.out.println((Object)recordStoreNotFoundException);
            recordStoreNotFoundException.printStackTrace();
            return false;
        }
        catch (RecordStoreException recordStoreException) {
            System.out.println((Object)recordStoreException);
            recordStoreException.printStackTrace();
            return false;
        }
        return false;
    }

    private void initStage() {
        this.bSelect = false;
        this.nCursorX = 0;
        this.nCursorY = 0;
        this.nMove = 0;
        this.loadMap(this.nStage);
    }

    private boolean loadMap(int n) {
        int n2 = 0;
        while (n2 < 6) {
            int n3 = 0;
            while (n3 < 6) {
                switch (this.Map[n - 1].charAt(n3 + 6 * n2)) {
                    case 'a': {
                        this.board[n3][n2] = 1;
                        break;
                    }
                    case 'b': {
                        this.board[n3][n2] = 2;
                        break;
                    }
                    case 'c': {
                        this.board[n3][n2] = 3;
                        break;
                    }
                    case 'd': {
                        this.board[n3][n2] = 4;
                        break;
                    }
                    case 'e': {
                        this.board[n3][n2] = 5;
                        break;
                    }
                    case 'f': {
                        this.board[n3][n2] = 6;
                        break;
                    }
                    case 'g': {
                        this.board[n3][n2] = 7;
                        break;
                    }
                    case 'h': {
                        this.board[n3][n2] = 8;
                        break;
                    }
                    case 'i': {
                        this.board[n3][n2] = 9;
                        break;
                    }
                    case 'j': {
                        this.board[n3][n2] = 10;
                        break;
                    }
                    case 'k': {
                        this.board[n3][n2] = 11;
                        break;
                    }
                    case 'l': {
                        this.board[n3][n2] = 12;
                        break;
                    }
                    default: {
                        this.board[n3][n2] = 0;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return true;
    }

    private int getX(int n) {
        return 17 + n * 14;
    }

    private int getY(int n) {
        return 5 + n * 14;
    }

    private void selectBlock() {
        int n = this.board[this.nCursorX][this.nCursorY];
        if (this.bSelect) {
            this.bSelect = false;
        } else {
            this.bSelect = true;
            if (n == 1 || n == 3 || n == 5 || n == 8 || n == 10) {
                this.nSelectX = this.nCursorX;
                this.nSelectY = this.nCursorY;
            } else if (n == 2 || n == 4 || n == 6) {
                this.nSelectX = this.nCursorX - 1;
                this.nSelectY = this.nCursorY;
            } else if (n == 7) {
                this.nSelectX = this.nCursorX - 2;
                this.nSelectY = this.nCursorY;
            } else if (n == 9 || n == 11) {
                this.nSelectX = this.nCursorX;
                this.nSelectY = this.nCursorY - 1;
            } else if (n == 12) {
                this.nSelectX = this.nCursorX;
                this.nSelectY = this.nCursorY - 2;
            } else {
                this.bSelect = false;
            }
        }
    }

    private boolean moveCursor(int n) {
        switch (n) {
            case -3: {
                if (this.nCursorX <= 0) break;
                --this.nCursorX;
                break;
            }
            case -4: {
                if (this.nCursorX >= 5) break;
                ++this.nCursorX;
                break;
            }
            case -1: {
                if (this.nCursorY <= 0) break;
                --this.nCursorY;
                break;
            }
            case -2: {
                if (this.nCursorY >= 5) break;
                ++this.nCursorY;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean moveBlock(int n) {
        if (!this.bSelect) {
            return false;
        }
        int n2 = this.board[this.nSelectX][this.nSelectY];
        switch (n) {
            case -3: {
                if (this.nSelectX == 0 || n2 == 8 || n2 == 10) {
                    return false;
                }
                if (this.board[this.nSelectX - 1][this.nSelectY] != 0) {
                    return false;
                }
                if (n2 == 1 || n2 == 3) {
                    this.board[this.nSelectX - 1][this.nSelectY] = this.board[this.nSelectX][this.nSelectY];
                    this.board[this.nSelectX][this.nSelectY] = this.board[this.nSelectX + 1][this.nSelectY];
                    this.board[this.nSelectX + 1][this.nSelectY] = 0;
                } else if (n2 == 5) {
                    this.board[this.nSelectX - 1][this.nSelectY] = this.board[this.nSelectX][this.nSelectY];
                    this.board[this.nSelectX][this.nSelectY] = this.board[this.nSelectX + 1][this.nSelectY];
                    this.board[this.nSelectX + 1][this.nSelectY] = this.board[this.nSelectX + 2][this.nSelectY];
                    this.board[this.nSelectX + 2][this.nSelectY] = 0;
                }
                --this.nCursorX;
                --this.nSelectX;
                break;
            }
            case -4: {
                if (n2 == 8 || n2 == 10) {
                    return false;
                }
                if (n2 == 1 && this.nSelectX != 4 && this.board[this.nSelectX + 2][this.nSelectY] != 0) {
                    return false;
                }
                if (n2 == 3 && (this.nSelectX == 4 || this.nSelectX != 4 && this.board[this.nSelectX + 2][this.nSelectY] != 0)) {
                    return false;
                }
                if (n2 == 5 && (this.nSelectX == 3 || this.nSelectX != 3 && this.board[this.nSelectX + 3][this.nSelectY] != 0)) {
                    return false;
                }
                if (n2 == 1 && this.nSelectX == 4) {
                    this.board[this.nSelectX + 1][this.nSelectY] = this.board[this.nSelectX][this.nSelectY];
                    this.board[this.nSelectX][this.nCursorY] = 0;
                } else if (n2 == 1 && this.nSelectX != 4 || n2 == 3) {
                    this.board[this.nSelectX + 2][this.nSelectY] = this.board[this.nSelectX + 1][this.nSelectY];
                    this.board[this.nSelectX + 1][this.nSelectY] = this.board[this.nSelectX][this.nSelectY];
                    this.board[this.nSelectX][this.nCursorY] = 0;
                } else if (n2 == 5) {
                    this.board[this.nSelectX + 3][this.nSelectY] = this.board[this.nSelectX + 2][this.nSelectY];
                    this.board[this.nSelectX + 2][this.nSelectY] = this.board[this.nSelectX + 1][this.nSelectY];
                    this.board[this.nSelectX + 1][this.nSelectY] = this.board[this.nSelectX][this.nSelectY];
                    this.board[this.nSelectX][this.nSelectY] = 0;
                }
                ++this.nSelectX;
                ++this.nCursorX;
                break;
            }
            case -1: {
                if (this.nSelectY == 0 || n2 != 8 && n2 != 10) {
                    return false;
                }
                if (this.board[this.nSelectX][this.nSelectY - 1] != 0) {
                    return false;
                }
                if (n2 == 8) {
                    this.board[this.nSelectX][this.nSelectY - 1] = this.board[this.nSelectX][this.nSelectY];
                    this.board[this.nSelectX][this.nSelectY] = this.board[this.nSelectX][this.nSelectY + 1];
                    this.board[this.nSelectX][this.nSelectY + 1] = 0;
                } else if (n2 == 10) {
                    this.board[this.nSelectX][this.nSelectY - 1] = this.board[this.nSelectX][this.nSelectY];
                    this.board[this.nSelectX][this.nSelectY] = this.board[this.nSelectX][this.nSelectY + 1];
                    this.board[this.nSelectX][this.nSelectY + 1] = this.board[this.nSelectX][this.nSelectY + 2];
                    this.board[this.nSelectX][this.nSelectY + 2] = 0;
                }
                --this.nSelectY;
                --this.nCursorY;
                break;
            }
            case -2: {
                if (n2 != 8 && n2 != 10) {
                    return false;
                }
                if (n2 == 8 && (this.nSelectY == 4 || this.nSelectY != 4 && this.board[this.nSelectX][this.nSelectY + 2] != 0)) {
                    return false;
                }
                if (n2 == 10 && (this.nSelectY == 3 || this.nSelectY != 3 && this.board[this.nSelectX][this.nSelectY + 3] != 0)) {
                    return false;
                }
                if (n2 == 8) {
                    this.board[this.nSelectX][this.nSelectY + 2] = this.board[this.nSelectX][this.nSelectY + 1];
                    this.board[this.nSelectX][this.nSelectY + 1] = this.board[this.nSelectX][this.nSelectY];
                    this.board[this.nSelectX][this.nSelectY] = 0;
                } else if (n2 == 10) {
                    this.board[this.nSelectX][this.nSelectY + 3] = this.board[this.nSelectX][this.nSelectY + 2];
                    this.board[this.nSelectX][this.nSelectY + 2] = this.board[this.nSelectX][this.nSelectY + 1];
                    this.board[this.nSelectX][this.nSelectY + 1] = this.board[this.nSelectX][this.nSelectY];
                    this.board[this.nSelectX][this.nSelectY] = 0;
                }
                ++this.nSelectY;
                ++this.nCursorY;
                break;
            }
            default: {
                return false;
            }
        }
        ++this.nMove;
        if (n2 == 1 && this.nSelectX == 5) {
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.nStage > this.nClearCnt) {
                this.nClearCnt = this.nStage;
                this.nContinueStage = this.nClearCnt + 1 <= 25 ? this.nClearCnt + 1 : 25;
                this.saveData();
            }
            this.nState = 8;
            this.updateCommands(8);
        }
        return true;
    }

    private boolean loadData() {
        this.nClearCnt = 0;
        try {
            this.rcData = RecordStore.openRecordStore((String)"BlockCity", (boolean)false);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            try {
                this.rcData = RecordStore.openRecordStore((String)"BlockCity", (boolean)true);
                byte[] byArray = "0".getBytes();
                int n = this.rcData.addRecord(byArray, 0, byArray.length);
            }
            catch (RecordStoreException recordStoreException) {
                return false;
            }
        }
        catch (RecordStoreException recordStoreException) {
            return false;
        }
        try {
            this.nClearCnt = Integer.parseInt(new String(this.rcData.getRecord(1)));
            this.nContinueStage = this.nClearCnt + 1 <= 25 ? this.nClearCnt + 1 : 25;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean saveData() {
        byte[] byArray = String.valueOf(this.nClearCnt).getBytes();
        try {
            this.rcData.setRecord(1, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void loadResource() {
        try {
            this.imgLoad1 = Image.createImage((String)"/img/load1.png");
            this.imgLoad2 = Image.createImage((String)"/img/load2.png");
            this.imgHelpArrow = this.loadImage("/img/arrow-u-d.png");
            this.imgMenu = this.loadImage("/img/menu.png");
            this.imgBoard = this.loadImage("/img/board.png");
            this.imgBoard0 = this.loadImage("/img/board0.png");
            this.imgBoard1 = this.loadImage("/img/board1.png");
            this.imgBoard2 = this.loadImage("/img/board2.png");
            this.imgBoard3 = this.loadImage("/img/board3.png");
            this.imgBoard4 = this.loadImage("/img/board4.png");
            this.imgBoard5 = this.loadImage("/img/board5.png");
            this.imgBoard6 = this.loadImage("/img/board6.png");
            this.imgBoard7 = this.loadImage("/img/board7.png");
            this.imgTitle = this.loadImage("/img/title.png");
            this.imgHand0 = this.loadImage("/img/hand0.png");
            this.imgHand1 = this.loadImage("/img/hand1.png");
            this.imgBlock = this.loadImage("/img/block.png");
            this.imgMsg = this.loadImage("/img/msg.png");
            this.imgPress = this.loadImage("/img/press.png");
            this.imgCopy = this.loadImage("/img/copy.png");
            this.imgSndOff = this.loadImage("/img/sndoff.png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private Image loadImage(String string) {
        this.repaint();
        this.serviceRepaints();
        try {
            System.gc();
            return Image.createImage((String)string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void drawLoad(Graphics graphics) {
        if (this.imgLoad1 == null || this.imgLoad2 == null) {
            return;
        }
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, 120, 108);
        graphics.setColor(255, 204, 0);
        graphics.fillRect(0, 0, 120, 55);
        graphics.setColor(153, 153, 153);
        graphics.drawLine(8, 58, 112, 58);
        graphics.drawLine(8, 63, 112, 63);
        graphics.drawLine(7, 59, 7, 62);
        graphics.drawLine(113, 59, 113, 62);
        graphics.setColor(0, 0, 0);
        graphics.drawRect(8, 59, 104, 3);
        graphics.setColor(255, 102, 0);
        int n = this.nProgress;
        if (n > 15) {
            n = 15;
        }
        graphics.fillRect(9, 60, n * 103 / 15, 1);
        graphics.setColor(255, 51, 0);
        graphics.fillRect(9, 61, n * 103 / 15, 1);
        ++this.nProgress;
        if (this.nImageState == 0) {
            graphics.drawImage(this.imgLoad1, 27, 43, 0);
        } else {
            graphics.drawImage(this.imgLoad2, 27, 43, 0);
        }
        this.nImageState = (this.nImageState + 1) % 2;
        System.gc();
    }

    private void drawImage(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6) {
        graphics.setClip(n, n2, n5, n6);
        graphics.drawImage(image, n - n3, n2 - n4, 0);
        graphics.setClip(0, 0, 120, 125);
    }

    private void drawText(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(255, 255, 255);
        graphics.drawString(string, n - 1, n2 - 1, 0x10 | 1);
        graphics.drawString(string, n + 1, n2 - 1, 0x10 | 1);
        graphics.drawString(string, n - 1, n2 + 1, 0x10 | 1);
        graphics.drawString(string, n + 1, n2 + 1, 0x10 | 1);
        graphics.setColor(n3, n4, n5);
        graphics.drawString(string, n, n2, 0x10 | 1);
    }

    private void drawTitle(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, 120, 108);
        graphics.drawImage(this.imgBoard0, 0, 0, 0);
        graphics.drawImage(this.imgBoard1, 0, 26, 0);
        graphics.drawImage(this.imgBoard2, 113, 26, 0);
        graphics.drawImage(this.imgBoard3, 0, 66, 0);
        graphics.drawImage(this.imgTitle, 25, 22, 0);
        if (this.press_blink < 2) {
            graphics.drawImage(this.imgPress, 30, 64, 0);
        }
        ++this.press_blink;
        this.press_blink %= 3;
        if (this.bSndOff) {
            graphics.drawImage(this.imgSndOff, 4, 82, 0);
        }
        graphics.setClip(0, 0, 120, 125);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 108, 120, 17);
        graphics.drawImage(this.imgCopy, 20, 112, 0);
    }

    private void drawMenu(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, 120, 108);
        graphics.drawImage(this.imgBoard0, 0, 0, 0);
        graphics.drawImage(this.imgBoard1, 0, 26, 0);
        graphics.drawImage(this.imgBoard2, 113, 26, 0);
        graphics.drawImage(this.imgBoard3, 0, 66, 0);
        graphics.setColor(0, 0, 0);
        int n = 36;
        graphics.drawString("PLAY", n, 20, 0);
        graphics.drawString("PLAY", n + 1, 20, 0);
        graphics.drawString("CONTINUE(" + this.nContinueStage + ")", n, 32, 0);
        graphics.drawString("CONTINUE(" + this.nContinueStage + ")", n + 1, 32, 0);
        graphics.drawString("HELP", n, 44, 0);
        graphics.drawString("HELP", n + 1, 44, 0);
        graphics.drawString("SCORE", n, 56, 0);
        graphics.drawString("SCORE", n + 1, 56, 0);
        graphics.drawString("EXIT", n, 68, 0);
        graphics.drawString("EXIT", n + 1, 68, 0);
        if (this.nImageState == 0) {
            graphics.drawImage(this.imgHand0, n - 14, 18 + this.nMenuIndex * 12, 0);
        } else {
            graphics.drawImage(this.imgHand1, n - 14, 18 + this.nMenuIndex * 12, 0);
        }
        this.nImageState = (this.nImageState + 1) % 2;
        graphics.setClip(0, 0, 120, 125);
        graphics.setColor(248, 152, 0);
        graphics.fillRect(0, 105, 120, 20);
    }

    private void drawHelp(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, 120, 108);
        graphics.drawImage(this.imgBoard4, 0, 0, 0);
        graphics.drawImage(this.imgBoard5, 0, 13, 0);
        graphics.drawImage(this.imgBoard6, 108, 13, 0);
        graphics.drawImage(this.imgBoard7, 0, 66, 0);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.setColor(0, 0, 0);
        if (this.nHelpIndex == 0) {
            graphics.drawString("HELP", 60, 6, 0x10 | 1);
            graphics.drawString("Arrow Keys:", 18, 25, 0x10 | 4);
            graphics.drawString(" Moves Hand", 18, 37, 0x10 | 4);
            graphics.drawString("EZ Key:", 18, 49, 0x10 | 4);
            graphics.drawString(" Select/Release", 18, 61, 0x10 | 4);
        } else if (this.nHelpIndex == 1) {
            graphics.drawString("In Block City, ", 18, 13, 0x10 | 4);
            graphics.drawString("tho objective ", 18, 25, 0x10 | 4);
            graphics.drawString("is to get the ", 18, 37, 0x10 | 4);
            graphics.drawString("desired ", 18, 49, 0x10 | 4);
            graphics.drawString("funiture out", 18, 61, 0x10 | 4);
        } else if (this.nHelpIndex == 2) {
            graphics.drawString("of the house.", 18, 13, 0x10 | 4);
            graphics.drawString("Use the arrow", 18, 25, 0x10 | 4);
            graphics.drawString("keys to move ", 18, 37, 0x10 | 4);
            graphics.drawString("around, select", 18, 49, 0x10 | 4);
            graphics.drawString("the furniture", 18, 61, 0x10 | 4);
        } else if (this.nHelpIndex == 3) {
            graphics.drawString("by clicking on", 18, 13, 0x10 | 4);
            graphics.drawString("the 'EZ' key,", 18, 25, 0x10 | 4);
            graphics.drawString("and release ", 18, 37, 0x10 | 4);
            graphics.drawString("the furniture", 18, 49, 0x10 | 4);
            graphics.drawString("by clicking on ", 18, 61, 0x10 | 4);
        } else if (this.nHelpIndex == 4) {
            graphics.drawString("'EZ' again.", 18, 13, 0x10 | 4);
            graphics.drawString("There are 25", 18, 25, 0x10 | 4);
            graphics.drawString("houses in ", 18, 37, 0x10 | 4);
            graphics.drawString("the game. ", 18, 49, 0x10 | 4);
            graphics.drawString("", 18, 61, 0x10 | 4);
        }
        if (this.nHelpIndex != 4) {
            if (this.nImageState == 0) {
                this.drawImage(graphics, 53, 97, this.imgHelpArrow, 0, 0, 13, 8);
            } else {
                this.drawImage(graphics, 53, 97, this.imgHelpArrow, 26, 0, 13, 8);
            }
        }
        if (this.nHelpIndex != 0) {
            if (this.nImageState == 0) {
                this.drawImage(graphics, 53, 3, this.imgHelpArrow, 13, 0, 13, 8);
            } else {
                this.drawImage(graphics, 53, 3, this.imgHelpArrow, 39, 0, 13, 8);
            }
        }
        this.nImageState = (this.nImageState + 1) % 2;
        graphics.setClip(0, 0, 120, 125);
        graphics.setColor(248, 152, 0);
        graphics.fillRect(0, 105, 120, 20);
    }

    private void drawScore(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, 120, 108);
        graphics.drawImage(this.imgBoard4, 0, 0, 0);
        graphics.drawImage(this.imgBoard5, 0, 13, 0);
        graphics.drawImage(this.imgBoard6, 108, 13, 0);
        graphics.drawImage(this.imgBoard7, 0, 66, 0);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        this.drawText(graphics, "SCORE", 60, 15, 0, 0, 0);
        graphics.setColor(0, 0, 0);
        graphics.drawString("CLEAR : " + this.nClearCnt, 60, 40, 0x10 | 1);
        graphics.setClip(0, 0, 120, 125);
        graphics.setColor(248, 152, 0);
        graphics.fillRect(0, 105, 120, 20);
    }

    private void drawGame(Graphics graphics) {
        graphics.drawImage(this.imgBoard, 0, 0, 0);
        int n = 0;
        while (n < 6) {
            int n2 = 0;
            while (n2 < 6) {
                this.drawTile(graphics, n2, n);
                ++n2;
            }
            ++n;
        }
        if (this.board[this.nSelectX][this.nSelectY] == 1 && this.nSelectX == 5) {
            this.drawImage(graphics, 101, 33, this.imgBlock, 14, 0, 14, 14);
        }
        this.drawCursor(graphics, this.nCursorX, this.nCursorY, this.bSelect);
        graphics.setClip(0, 0, 120, 125);
        graphics.setColor(248, 152, 0);
        graphics.fillRect(0, 108, 120, 17);
        graphics.setColor(0, 0, 0);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.drawString("STAGE:", 8, 110, 0x10 | 4);
        graphics.drawString("MOVE:", 70, 110, 0x10 | 4);
        graphics.drawString(String.valueOf(this.nStage), 55, 110, 0x10 | 1);
        graphics.drawString(String.valueOf(this.nMove), 108, 110, 0x10 | 1);
    }

    private void drawTitleQ(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, 120, 108);
        graphics.drawImage(this.imgBoard4, 0, 0, 0);
        graphics.drawImage(this.imgBoard5, 0, 13, 0);
        graphics.drawImage(this.imgBoard6, 108, 13, 0);
        graphics.drawImage(this.imgBoard7, 0, 66, 0);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.setColor(0, 0, 0);
        graphics.drawString("Return to  ", 17, 20, 0);
        graphics.drawString("the title  ", 17, 33, 0);
        graphics.drawString("page?", 17, 46, 0);
        graphics.setClip(0, 0, 120, 125);
        graphics.setColor(248, 152, 0);
        graphics.fillRect(0, 105, 120, 20);
    }

    private void drawExit(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, 120, 108);
        graphics.drawImage(this.imgBoard4, 0, 0, 0);
        graphics.drawImage(this.imgBoard5, 0, 13, 0);
        graphics.drawImage(this.imgBoard6, 108, 13, 0);
        graphics.drawImage(this.imgBoard7, 0, 66, 0);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.setColor(0, 0, 0);
        graphics.drawString("Would you", 17, 20, 0);
        graphics.drawString("like to quit?", 17, 33, 0);
        graphics.setClip(0, 0, 120, 125);
        graphics.setColor(248, 152, 0);
        graphics.fillRect(0, 105, 120, 20);
    }

    private void drawPause(Graphics graphics) {
        this.drawGame(graphics);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(19, 30, 78, 25);
        graphics.setColor(0, 0, 0);
        graphics.drawRect(19, 30, 77, 24);
        graphics.setColor(85, 85, 85);
        graphics.fillRect(19, 30, 2, 2);
        graphics.fillRect(95, 30, 2, 2);
        graphics.fillRect(19, 53, 2, 2);
        graphics.fillRect(95, 53, 2, 2);
        graphics.setColor(0, 0, 0);
        graphics.drawLine(20, 31, 20, 31);
        graphics.drawLine(50, 53, 20, 53);
        graphics.drawLine(95, 53, 95, 53);
        graphics.drawLine(95, 31, 95, 31);
        graphics.setColor(153, 153, 255);
        graphics.drawLine(21, 31, 21, 31);
        graphics.drawLine(94, 31, 94, 31);
        graphics.drawLine(20, 32, 20, 52);
        graphics.drawLine(21, 53, 94, 53);
        graphics.drawLine(95, 32, 95, 52);
        this.drawImage(graphics, 41, 39, this.imgMsg, 0, 14, 34, 7);
        graphics.setClip(0, 0, 120, 125);
        graphics.setColor(248, 152, 0);
        graphics.fillRect(0, 108, 120, 17);
        graphics.setColor(0, 0, 0);
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.drawString("STAGE:", 8, 110, 0x10 | 4);
        graphics.drawString("MOVE:", 70, 110, 0x10 | 4);
        graphics.drawString(String.valueOf(this.nStage), 55, 110, 0x10 | 1);
        graphics.drawString(String.valueOf(this.nMove), 108, 110, 0x10 | 1);
    }

    private void drawMsg(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(19, 21, 78, 43);
        graphics.setColor(0, 0, 0);
        graphics.drawRect(19, 21, 77, 42);
        graphics.setColor(85, 85, 85);
        graphics.fillRect(19, 21, 2, 2);
        graphics.fillRect(95, 21, 2, 2);
        graphics.fillRect(19, 62, 2, 2);
        graphics.fillRect(95, 62, 2, 2);
        graphics.setColor(0, 0, 0);
        graphics.drawLine(20, 22, 20, 22);
        graphics.drawLine(50, 62, 20, 62);
        graphics.drawLine(95, 62, 95, 62);
        graphics.drawLine(95, 22, 95, 22);
        graphics.setColor(153, 153, 255);
        graphics.drawLine(21, 22, 21, 22);
        graphics.drawLine(94, 22, 94, 22);
        graphics.drawLine(20, 23, 20, 61);
        graphics.drawLine(21, 62, 94, 62);
        graphics.drawLine(95, 23, 95, 61);
        if (this.nStage == 25) {
            this.drawImage(graphics, 48, 29, this.imgMsg, 0, 0, 20, 7);
            this.drawImage(graphics, 41, 39, this.imgMsg, 21, 0, 34, 7);
            this.drawImage(graphics, 27, 49, this.imgMsg, 0, 7, 62, 7);
        } else {
            this.drawImage(graphics, 41, 29, this.imgMsg, 21, 0, 34, 7);
            this.drawImage(graphics, 27, 49, this.imgMsg, 0, 7, 62, 7);
        }
        graphics.setClip(0, 0, 120, 125);
        graphics.setColor(248, 152, 0);
        graphics.fillRect(0, 108, 120, 17);
    }

    private void drawCursor(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = this.getX(n);
        int n4 = this.getY(n2);
        if (bl) {
            this.drawImage(graphics, n3, n4, this.imgHand1, 0, 0, 14, 14);
        } else {
            this.drawImage(graphics, n3, n4, this.imgHand0, 0, 0, 14, 14);
        }
    }

    private void drawTile(Graphics graphics, int n, int n2) {
        int n3 = this.board[n][n2];
        int n4 = this.getX(n);
        int n5 = this.getY(n2);
        switch (n3) {
            case 1: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4, n5, 0);
                break;
            }
            case 2: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4 - 14, n5, 0);
                break;
            }
            case 3: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4, n5 - 14, 0);
                break;
            }
            case 4: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4 - 14, n5 - 14, 0);
                break;
            }
            case 5: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4, n5 - 28, 0);
                break;
            }
            case 6: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4 - 14, n5 - 28, 0);
                break;
            }
            case 7: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4 - 28, n5 - 28, 0);
                break;
            }
            case 8: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4 - 28, n5, 0);
                break;
            }
            case 9: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4 - 28, n5 - 14, 0);
                break;
            }
            case 10: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4 - 42, n5, 0);
                break;
            }
            case 11: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4 - 42, n5 - 14, 0);
                break;
            }
            case 12: {
                graphics.setClip(n4, n5, 14, 14);
                graphics.drawImage(this.imgBlock, n4 - 42, n5 - 28, 0);
            }
        }
    }
}

