/*
 * Decompiled with CFR 0.152.
 */
package com.bsg.sa.nokiacolour;

import com.bsg.nokiacolor.BSCanvas;
import com.bsg.sa.nokiacolour.Shark;
import com.bsg.sa.nokiacolour.Shot;
import com.nokia.mid.sound.Sound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SharkAttackCanvas
extends BSCanvas
implements Runnable {
    private Image statusBarImage;
    private Image[] tiles;
    private Image endScreen;
    private Image playerImages;
    private Image sharkImages;
    private Image[] digits;
    private Image chestImage;
    private Image bubbles;
    private Image shotImages;
    private Image optionsImage;
    private Image livesImage;
    private Image coinsImage;
    private Image shotsImage;
    private Graphics statusBarSurface;
    private Thread instance;
    private int screenHeight;
    private int halfScreenHeight;
    private int screenWidth;
    private int halfScreenWidth;
    private int statusBarHeight = 7;
    private int levelWidth;
    private int levelHeight;
    private int xOffSet;
    private int xOffSetAdjust;
    private int xOffSetCounter;
    private int yOffSet;
    private int extraLifeCounter;
    private int totalCoins;
    private int currentLevel;
    private int tileWidth = 12;
    private int tileHeight = 12;
    private int bubblesCounter;
    private int bubblesFrame;
    private int pWidth;
    private int pHeight;
    private int pHalfWidth;
    private int pHalfHeight;
    private int pXPos;
    private int pOrigXPos;
    private int pYPos;
    private int pOrigYPos;
    private int pDX;
    private int pMaxDX = 3;
    private int pDY;
    private int pMaxDY = 3;
    private int pXSlowDown;
    private int pYSlowDown;
    private int pCurrentMove;
    private int pCurrentFrame;
    private int pFrameCounter;
    private int pLives;
    private int pCoins;
    private int pTotalCoins;
    private int pShots;
    private int shotSpeed = 6;
    private int chestX;
    private int chestY;
    private int chestWidth;
    private int chestHeight;
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;
    private boolean fire;
    private boolean running;
    private boolean levelClear;
    private boolean gameover;
    private boolean won;
    private boolean dead;
    private boolean start;
    private boolean keyPressed;
    private boolean updateStatus;
    private boolean extraLife;
    private boolean gameFinished;
    private byte[][] level;
    private Shark[] sharks;
    private Shot shot;
    public static final int P_UP = 0;
    public static final int P_DOWN = 1;
    public static final int P_LEFT = 2;
    public static final int P_RIGHT = 3;
    public static final int P_DEAD = 4;
    public static final int[] P_FRAMES;
    public static final int[] F_FRAMES;
    private Sound[] sounds;
    private final byte[][] soundBytes = new byte[][]{{2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 70, 4, -32, 86, 5, -96, 98, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 98, 5, -96, 86, 4, -32, 70, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 24, 69, -123, 96, 90, 6, 32, -94, 44, 65, 22, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 20, -125, 12, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 32, 86, 0, 0}, {2, 74, 58, 81, -47, -107, -51, -48, 4, 0, 27, 20, -94, -84, 0, 0}};
    private final int WONMELODY;
    private final int DEADMELODY;
    private final int BONUSMELODY;
    private final int BEEP_LOW;
    private final int BEEP_MED;
    private final int BEEP_HIGH;

    public SharkAttackCanvas() {
        this.WONMELODY = 0;
        this.DEADMELODY = 1;
        this.BONUSMELODY = 2;
        this.BEEP_LOW = 3;
        this.BEEP_MED = 4;
        this.BEEP_HIGH = 5;
        this.screenWidth = this.getWidth();
        this.halfScreenWidth = this.screenWidth / 2;
        this.screenHeight = this.getHeight() - this.statusBarHeight;
        this.halfScreenHeight = this.screenHeight / 2;
        this.statusBarImage = Image.createImage((int)this.screenWidth, (int)this.statusBarHeight);
        this.statusBarSurface = this.statusBarImage.getGraphics();
        this.sounds = new Sound[this.soundBytes.length];
        for (int i = 0; i < this.sounds.length; ++i) {
            this.sounds[i] = new Sound(this.soundBytes[i], 1);
            this.sounds[i].init(this.soundBytes[i], 1);
        }
        try {
            int n;
            this.tiles = new Image[100];
            Image image = Image.createImage((String)"/Tiles.png");
            for (n = 0; n < 3; ++n) {
                this.tiles[n] = this.getImage(image, this.tileWidth, this.tileHeight, -(n - n / 10 * 10) * this.tileWidth, -(n / 10) * this.tileHeight);
            }
            for (n = 60; n < 61; ++n) {
                this.tiles[n] = this.getImage(image, this.tileWidth, this.tileHeight, -(n - n / 10 * 10) * this.tileWidth, -(n / 10) * this.tileHeight);
            }
            for (n = 75; n < 76; ++n) {
                this.tiles[n] = this.getImage(image, this.tileWidth, this.tileHeight, -(n - n / 10 * 10) * this.tileWidth, -(n / 10) * this.tileHeight);
            }
            for (n = 90; n < 92; ++n) {
                this.tiles[n] = this.getImage(image, this.tileWidth, this.tileHeight, -(n - n / 10 * 10) * this.tileWidth, -(n / 10) * this.tileHeight);
            }
            for (n = 99; n < 100; ++n) {
                this.tiles[n] = this.getImage(image, this.tileWidth, this.tileHeight, -(n - n / 10 * 10) * this.tileWidth, -(n / 10) * this.tileHeight);
            }
            this.playerImages = Image.createImage((String)"/PlayerImages.png");
            this.bubbles = Image.createImage((String)"/Bubbles.png");
            this.sharkImages = Image.createImage((String)"/SharkImages.png");
            this.shotImages = Image.createImage((String)"/ShotImages.png");
            Image image2 = Image.createImage((String)"/Status.png");
            this.livesImage = this.getImage(image2, 7, 7, -30, 0);
            this.coinsImage = this.getImage(image2, 7, 7, -37, 0);
            this.shotsImage = this.getImage(image2, 5, 6, -44, 0);
            this.optionsImage = this.getImage(image2, image2.getWidth() - 49, 7, -49, 0);
            this.digits = new Image[10];
            for (int i = 0; i < this.digits.length; ++i) {
                this.digits[i] = this.getImage(image2, 3, 5, -3 * i, 0);
            }
            this.chestImage = Image.createImage((String)"/Chest.png");
            this.endScreen = Image.createImage((String)"/endscreen.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pWidth = 24;
        this.pHeight = 12;
        this.pHalfWidth = this.pWidth / 2;
        this.pHalfHeight = this.pHeight / 2;
        this.chestWidth = this.chestImage.getWidth();
        this.chestHeight = this.chestImage.getHeight();
    }

    public Image getImage(Image image, int n, int n2, int n3, int n4) {
        Image image2 = Image.createImage((int)n, (int)n2);
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(image, n3, n4, 20);
        return image2;
    }

    public void startGame(int n, Gauge gauge) {
        this.currentLevel = 0;
        try {
            this.loadLevel(gauge, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        gauge.setValue(100);
        this.score = 0;
        this.pOrigXPos = this.pXPos;
        this.pOrigYPos = this.pYPos;
        this.pDX = 0;
        this.pDY = 0;
        this.pCurrentMove = 3;
        this.pLives = 10;
        this.pCoins = 0;
        this.pShots = 3;
        this.pTotalCoins = 0;
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void loadLevel(Gauge gauge, DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        InputStream inputStream = this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/Levels/level").append(this.currentLevel).append(".txt"))));
        DataInputStream dataInputStream2 = new DataInputStream(inputStream);
        int n3 = dataInputStream2.readInt();
        int n4 = dataInputStream2.readInt();
        if (dataInputStream == null) {
            this.pXPos = dataInputStream2.readInt() * this.tileWidth;
            this.pYPos = dataInputStream2.readInt() * this.tileHeight + this.pHeight;
        } else {
            dataInputStream2.readInt();
            dataInputStream2.readInt();
        }
        this.level = new byte[n4][n3];
        this.totalCoins = 0;
        gauge.setValue(20);
        if (dataInputStream == null) {
            for (n2 = 0; n2 < this.level[0].length; ++n2) {
                for (n = 0; n < this.level.length; ++n) {
                    this.level[n][n2] = dataInputStream2.readByte();
                    if (this.level[n][n2] == 0 || this.level[n][n2] != 99) continue;
                    ++this.totalCoins;
                }
                if (n2 % 5 != 0) continue;
                gauge.setValue(20 + (n2 * 800 / this.level[0].length >> 4));
            }
        } else {
            n2 = dataInputStream.readInt();
            for (n = 0; n < n2; ++n) {
                this.level[dataInputStream.readInt()][dataInputStream.readInt()] = 99;
            }
            for (n = 0; n < this.level[0].length; ++n) {
                for (int i = 0; i < this.level.length; ++i) {
                    byte by = dataInputStream2.readByte();
                    if (by == 0) continue;
                    if (by != 99) {
                        this.level[i][n] = by;
                        continue;
                    }
                    ++this.totalCoins;
                }
                if (n % 5 != 0) continue;
                gauge.setValue(20 + (n * 800 / this.level[0].length >> 4));
            }
        }
        this.sharks = new Shark[dataInputStream2.readByte()];
        for (n2 = 0; n2 < this.sharks.length; ++n2) {
            this.sharks[n2] = new Shark(dataInputStream2.readInt() * this.tileWidth, dataInputStream2.readByte(), dataInputStream2.readInt() * this.tileHeight, dataInputStream2.readByte(), dataInputStream2.read(), 24, 17, this.sharkImages);
        }
        this.chestX = dataInputStream2.readInt() * this.tileWidth;
        this.chestY = dataInputStream2.readInt() * this.tileHeight;
        dataInputStream2.close();
        gauge.setValue(75);
        this.levelWidth = this.level[0].length * this.tileWidth;
        this.levelHeight = this.level.length * this.tileHeight;
        this.xOffSet = 0;
        this.yOffSet = 0;
        this.bubblesCounter = 0;
        this.bubblesFrame = 0;
        this.shot = null;
        this.dead = false;
        this.gameover = false;
        this.levelClear = false;
        this.won = false;
        this.start = true;
        this.keyPressed = false;
        this.updateStatus = true;
        this.gameFinished = false;
        this.xOffSetCounter = 0;
        this.xOffSetAdjust = -40;
    }

    public void nextLevel(Gauge gauge) {
        ++this.currentLevel;
        try {
            this.loadLevel(gauge, null);
        }
        catch (Exception exception) {
            this.currentLevel = 0;
            try {
                this.loadLevel(gauge, null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        gauge.setValue(100);
        this.pOrigXPos = this.pXPos;
        this.pOrigYPos = this.pYPos;
        this.pDX = 0;
        this.pDY = 0;
        this.pCurrentMove = 3;
        this.pCoins = 0;
        this.commandListener.commandAction(BSCanvas.DISPLAY_CANVAS, (Displayable)this);
    }

    public void loadGame(byte[] byArray, Gauge gauge) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.currentLevel = dataInputStream.readInt();
            this.pLives = dataInputStream.readInt();
            this.pXPos = dataInputStream.readInt();
            this.pYPos = dataInputStream.readInt();
            this.pOrigXPos = dataInputStream.readInt();
            this.pOrigYPos = dataInputStream.readInt();
            this.pDX = dataInputStream.readInt();
            this.pDY = dataInputStream.readInt();
            this.pCurrentMove = dataInputStream.readInt();
            this.pCurrentFrame = dataInputStream.readInt();
            this.pFrameCounter = dataInputStream.readInt();
            this.pCoins = dataInputStream.readInt();
            this.pTotalCoins = dataInputStream.readInt();
            this.score = dataInputStream.readInt();
            this.pShots = dataInputStream.readInt();
            this.loadLevel(gauge, dataInputStream);
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                if (!dataInputStream.readBoolean()) {
                    this.sharks[i] = null;
                    continue;
                }
                this.sharks[i].xPos = dataInputStream.readInt();
                this.sharks[i].yPos = dataInputStream.readInt();
                this.sharks[i].dx = dataInputStream.readInt();
                this.sharks[i].dy = dataInputStream.readInt();
                this.sharks[i].currentMove = dataInputStream.readInt();
                this.sharks[i].moveCounter = dataInputStream.readInt();
                this.sharks[i].currentFrame = dataInputStream.readInt();
                this.sharks[i].frameCounter = dataInputStream.readInt();
                this.sharks[i].dead = dataInputStream.readBoolean();
            }
            dataInputStream.close();
            gauge.setValue(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] saveGame(Gauge gauge) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.currentLevel);
            dataOutputStream.writeInt(this.pLives);
            dataOutputStream.writeInt(this.pXPos);
            dataOutputStream.writeInt(this.pYPos);
            dataOutputStream.writeInt(this.pOrigXPos);
            dataOutputStream.writeInt(this.pOrigYPos);
            dataOutputStream.writeInt(this.pDX);
            dataOutputStream.writeInt(this.pDY);
            dataOutputStream.writeInt(this.pCurrentMove);
            dataOutputStream.writeInt(this.pCurrentFrame);
            dataOutputStream.writeInt(this.pFrameCounter);
            dataOutputStream.writeInt(this.pCoins);
            dataOutputStream.writeInt(this.pTotalCoins);
            dataOutputStream.writeInt(this.pFrameCounter);
            dataOutputStream.writeInt(this.pShots);
            dataOutputStream.writeInt(this.totalCoins - this.pCoins);
            gauge.setValue(10);
            for (n = 0; n < this.level[0].length; ++n) {
                for (int i = 0; i < this.level.length; ++i) {
                    if (this.level[i][n] != 99) continue;
                    dataOutputStream.writeInt(i);
                    dataOutputStream.writeInt(n);
                }
                if (n % 5 != 0) continue;
                gauge.setValue(10 + (n * 800 / this.level[0].length >> 4));
            }
            dataOutputStream.writeInt(this.sharks.length);
            for (n = 0; n < this.sharks.length; ++n) {
                if (this.sharks[n] == null) {
                    dataOutputStream.writeBoolean(false);
                    continue;
                }
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeInt(this.sharks[n].xPos);
                dataOutputStream.writeInt(this.sharks[n].yPos);
                dataOutputStream.writeInt(this.sharks[n].dx);
                dataOutputStream.writeInt(this.sharks[n].dy);
                dataOutputStream.writeInt(this.sharks[n].currentMove);
                dataOutputStream.writeInt(this.sharks[n].moveCounter);
                dataOutputStream.writeInt(this.sharks[n].currentFrame);
                dataOutputStream.writeInt(this.sharks[n].frameCounter);
                dataOutputStream.writeBoolean(this.sharks[n].dead);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception exception) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public void paint(Graphics graphics) {
        this.unifiedMethod(graphics);
    }

    public void start() {
        if (this.instance == null || !this.running && !this.paused && !this.instance.isAlive()) {
            this.instance = new Thread(this);
            this.running = true;
            this.instance.start();
        } else if (this.instance.isAlive()) {
            this.running = true;
        }
    }

    public void pause() {
        this.running = false;
        if (!this.dead && !this.won) {
            this.keyPressed = false;
        }
    }

    public void destroy() {
        this.running = false;
        this.instance = null;
    }

    public void hideNotify() {
        this.pause();
    }

    public void showNotify() {
        this.start();
    }

    public void collectCoin(int n, int n2) {
        this.level[n2][n] = 0;
        ++this.pCoins;
        ++this.pTotalCoins;
        this.score += 10;
        this.updateStatus = true;
        if (this.pTotalCoins == 100) {
            this.pTotalCoins = 0;
            if (this.pLives != 99) {
                ++this.pLives;
            }
            this.extraLife = true;
            this.extraLifeCounter = 30;
            BSCanvas.playSound(this.sounds[2]);
        }
    }

    public void continueFrom(int n, int n2) {
        this.level[n2][n] = 0;
        this.pOrigXPos = n * this.tileWidth;
        this.pOrigYPos = n2 * this.tileHeight + this.pHeight;
        BSCanvas.playSound(this.sounds[5]);
    }

    public void collectAmmo(int n, int n2) {
        this.level[n2][n] = 0;
        this.pShots += 3;
        if (this.pShots > 9) {
            this.pShots = 9;
        }
        BSCanvas.playSound(this.sounds[5]);
        this.updateStatus = true;
    }

    public boolean checkTiles(int n, int n2) {
        if (this.level[n2][n] == 75) {
            this.dead();
            return true;
        }
        if (this.level[n2][n] == 99) {
            this.collectCoin(n, n2);
            return true;
        }
        if (this.level[n2][n] == 90) {
            this.continueFrom(n, n2);
            return true;
        }
        if (this.level[n2][n] == 91) {
            this.collectAmmo(n, n2);
            return true;
        }
        return false;
    }

    public void won() {
        this.won = true;
        this.repaint();
        try {
            Thread.sleep(1000L);
            BSCanvas.playSound(this.sounds[0]);
            this.extraLifeCounter = 0;
            this.extraLife = false;
            this.levelClear = true;
            this.repaint();
            Thread.sleep(3000L);
            if (this.currentLevel == 9) {
                this.gameFinished = true;
                this.repaint();
                Thread.sleep(3000L);
                this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
            } else {
                this.commandListener.commandAction(BSCanvas.LEVEL_ENDED, (Displayable)this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dead() {
        this.pDX = 0;
        this.pDY = this.pMaxDY;
        --this.pLives;
        this.dead = true;
        this.updateStatus = true;
        this.left = false;
        this.right = false;
        this.repaint();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pCurrentMove = 4;
        this.pCurrentFrame = 0;
        BSCanvas.playSound(this.sounds[1]);
        BSCanvas.vibrate(50, 500);
    }

    private synchronized void unifiedMethod(Graphics graphics) {
        if (graphics == null) {
            if (this.pDY != 0) {
                ++this.pYSlowDown;
                if (this.pYSlowDown == 10) {
                    this.pYSlowDown = 0;
                    this.pDY = this.pDY < 0 ? ++this.pDY : --this.pDY;
                }
            }
            int n = this.pDX;
            int n2 = this.pDY;
            int n3 = 0;
            int n4 = 0;
            if (this.pDX > 0) {
                n3 = 1;
            } else if (this.pDX < 0) {
                n3 = -1;
            }
            if (this.pDY > 0) {
                n4 = 1;
            } else if (this.pDY < 0) {
                n4 = -1;
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            while (!(this.dead || n == 0 && n2 == 0)) {
                if (n != 0) {
                    this.pXPos += n3;
                    n -= n3;
                }
                if (n2 != 0) {
                    this.pYPos += n4;
                    n2 -= n4;
                }
                n5 = (this.pXPos + 4) / this.tileWidth;
                n6 = (this.pXPos + this.pWidth - 4) / this.tileWidth;
                n7 = (this.pYPos - this.pHeight) / this.tileHeight;
                if (!(this.level[n7][n5] <= 2 && this.level[n7][n6] <= 2 || this.checkTiles(n5, n7) || this.checkTiles(n6, n7) || this.pDY >= 0)) {
                    n2 = 0;
                    this.pYPos = (n7 + 1) * this.tileHeight + this.pHeight;
                    if (this.pDY < 0) {
                        this.pDY = 0;
                    }
                }
                n8 = (this.pXPos + 4) / this.tileWidth;
                n9 = (this.pXPos + this.pWidth - 4) / this.tileWidth;
                n10 = (this.pYPos - 1) / this.tileHeight;
                if (!(this.level[n10][n8] <= 2 && this.level[n10][n9] <= 2 || this.checkTiles(n8, n10) || this.checkTiles(n9, n10) || this.pDY <= 0)) {
                    n2 = 0;
                    this.pYPos = n10 * this.tileHeight;
                    this.pDY = 0;
                }
                n11 = this.pXPos / this.tileWidth;
                n12 = (this.pYPos - this.pHeight + 2) / this.tileHeight;
                n13 = (this.pYPos - 2) / this.tileHeight;
                if (!(this.level[n12][n11] <= 2 && this.level[n13][n11] <= 2 || this.checkTiles(n11, n12) || this.checkTiles(n11, n13))) {
                    n = 0;
                    this.pXPos = n11 * this.tileWidth + this.tileWidth;
                    this.pDX = 0;
                }
                n14 = (this.pXPos + this.pWidth) / this.tileWidth;
                n15 = (this.pYPos - this.pHeight + 2) / this.tileHeight;
                n16 = (this.pYPos - 2) / this.tileHeight;
                if (this.level[n15][n14] <= 2 && this.level[n16][n14] <= 2 || this.checkTiles(n14, n15) || this.checkTiles(n14, n16)) continue;
                n = 0;
                this.pXPos = n14 * this.tileWidth - this.pWidth;
                this.pDX = 0;
            }
        } else {
            graphics.setClip(0, 0, this.screenWidth, this.screenHeight + this.statusBarHeight);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)16));
            if (!this.gameFinished) {
                int n;
                int n17;
                int n18;
                int n19;
                if (this.updateStatus) {
                    this.statusBarSurface.setColor(0xFFFFFF);
                    this.statusBarSurface.fillRect(0, 0, this.screenWidth, this.statusBarHeight);
                    this.statusBarSurface.drawImage(this.optionsImage, this.screenWidth - this.optionsImage.getWidth(), 0, 20);
                    n19 = 0;
                    n18 = 100000;
                    for (n17 = 6; n17 > 0; --n17) {
                        this.statusBarSurface.drawImage(this.digits[this.score / n18 % 10], n19, 1, 20);
                        n18 /= 10;
                        n19 += this.digits[0].getWidth() + 1;
                    }
                    this.statusBarSurface.drawImage(this.livesImage, n19, 0, 20);
                    this.statusBarSurface.drawImage(this.digits[this.pLives / 10 % 10], n19 += this.livesImage.getWidth() + 1, 1, 20);
                    this.statusBarSurface.drawImage(this.digits[this.pLives % 10], n19 += this.digits[0].getWidth() + 1, 1, 20);
                    this.statusBarSurface.drawImage(this.coinsImage, n19 += this.digits[0].getWidth() + 1, 0, 20);
                    this.statusBarSurface.drawImage(this.digits[this.pTotalCoins / 10 % 10], n19 += this.coinsImage.getWidth() + 1, 1, 20);
                    this.statusBarSurface.drawImage(this.digits[this.pTotalCoins % 10], n19 += this.digits[0].getWidth() + 1, 1, 20);
                    this.statusBarSurface.drawImage(this.shotsImage, n19 += this.digits[0].getWidth() + 1, 0, 20);
                    this.statusBarSurface.drawImage(this.digits[this.pShots % 10], n19 += this.shotsImage.getWidth() + 1, 1, 20);
                    this.updateStatus = false;
                }
                if (this.pXPos + this.pHalfWidth > this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter && this.levelWidth + this.xOffSet > this.screenWidth || this.pXPos + this.pHalfWidth < this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter - this.xOffSet && this.xOffSet < 0) {
                    this.xOffSet = this.halfScreenWidth + this.xOffSetAdjust - this.xOffSetCounter - (this.pXPos + this.pHalfWidth);
                    if (this.levelWidth + this.xOffSet < this.screenWidth) {
                        this.xOffSet = -(this.levelWidth - this.screenWidth);
                    } else if (this.xOffSet > 0) {
                        this.xOffSet = 0;
                    }
                }
                if (this.xOffSetCounter > 0) {
                    this.xOffSetCounter -= this.xOffSetCounter / 5 + 1;
                } else if (this.xOffSetCounter < 0) {
                    this.xOffSetCounter += -this.xOffSetCounter / 5 + 1;
                }
                if (this.pYPos - this.pHalfHeight > this.halfScreenHeight && this.levelHeight + this.yOffSet > this.screenHeight || this.pYPos - this.pHalfHeight < this.halfScreenHeight - this.yOffSet && this.yOffSet < 0) {
                    this.yOffSet = this.halfScreenHeight - this.pYPos + this.pHalfHeight;
                    if (this.levelHeight + this.yOffSet < this.screenHeight) {
                        this.yOffSet = -(this.levelHeight - this.screenHeight);
                    } else if (this.yOffSet > 0) {
                        this.yOffSet = 0;
                    }
                }
                graphics.setColor(0x99CCFF);
                graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
                n19 = this.screenWidth / this.tileWidth + 1;
                n18 = this.screenHeight / this.tileHeight + 1;
                n17 = -this.xOffSet / this.tileWidth;
                int n20 = -this.yOffSet / this.tileHeight;
                for (n = n17; n <= n17 + n19; ++n) {
                    for (int i = n20; i <= n20 + n18; ++i) {
                        if (n < 0 || i < 0 || i >= this.level.length || n >= this.level[i].length || this.level[i][n] <= 0) continue;
                        graphics.drawImage(this.tiles[this.level[i][n]], this.xOffSet + n * this.tileWidth, this.yOffSet + i * this.tileHeight, 20);
                    }
                }
                graphics.drawImage(this.chestImage, this.xOffSet + this.chestX, this.yOffSet + this.chestY + 8, 36);
                graphics.setClip(this.xOffSet + this.pXPos, this.yOffSet + this.pYPos - this.pHeight, this.pWidth, this.pHeight);
                graphics.drawImage(this.playerImages, this.xOffSet + this.pXPos - this.pWidth * this.pCurrentFrame, this.yOffSet + this.pYPos - this.pHeight - this.pCurrentMove * this.pHeight, 20);
                if (this.bubblesCounter > 15) {
                    switch (this.pCurrentMove) {
                        case 2: {
                            graphics.setClip(this.xOffSet + this.pXPos - 3, this.yOffSet + this.pYPos - this.pHeight - 12, 6, 12);
                            graphics.drawImage(this.bubbles, this.xOffSet + this.pXPos - 6 * this.bubblesFrame - 3, this.yOffSet + this.pYPos - this.pHeight, 36);
                            break;
                        }
                        case 3: {
                            graphics.setClip(this.xOffSet + this.pXPos + this.pWidth - 3, this.yOffSet + this.pYPos - this.pHeight - 12, 6, 12);
                            graphics.drawImage(this.bubbles, this.xOffSet + this.pXPos + this.pWidth - 6 * this.bubblesFrame - 3, this.yOffSet + this.pYPos - this.pHeight, 36);
                        }
                    }
                }
                if (this.shot != null) {
                    this.shot.paint(graphics, this.xOffSet, this.yOffSet);
                }
                for (n = 0; n < this.sharks.length; ++n) {
                    if (this.sharks[n] == null) continue;
                    this.sharks[n].paint(graphics, this.xOffSet, this.yOffSet);
                }
                graphics.setClip(0, 0, this.screenWidth, this.screenHeight + this.statusBarHeight);
                graphics.drawImage(this.statusBarImage, 0, this.screenHeight, 20);
                if (this.extraLife) {
                    this.drawText(graphics, this.parseString(this.langT[2]), this.getFont(this.langA[2]), true, this.halfScreenWidth, 5);
                }
                if (this.levelClear) {
                    this.drawText(graphics, this.parseString(this.langT[0]), this.getFont(this.langA[0]), true, this.halfScreenWidth, this.halfScreenHeight);
                } else if (this.gameover) {
                    this.drawText(graphics, this.parseString(this.langT[1]), this.getFont(this.langA[1]), true, this.halfScreenWidth, this.halfScreenHeight);
                }
                if (this.start) {
                    this.drawText(graphics, this.parseString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.langT[3]))).append(this.currentLevel + 1)))), this.getFont(this.langA[3]), true, this.halfScreenWidth, this.halfScreenHeight);
                }
                if (this.paused) {
                    this.drawText(graphics, this.parseString(this.langT[4]), this.getFont(this.langA[4]), true, this.halfScreenWidth, this.halfScreenHeight);
                }
            } else {
                graphics.drawImage(this.endScreen, 0, 0, 20);
            }
        }
    }

    public void run() {
        while (this.running) {
            try {
                if (this.start) {
                    this.repaint();
                    Thread.sleep(2000L);
                    this.start = false;
                    this.repaint();
                }
                if (this.levelClear || this.gameover || !this.keyPressed) continue;
                if (this.extraLife) {
                    --this.extraLifeCounter;
                    if (this.extraLifeCounter <= 0) {
                        this.extraLife = false;
                    }
                }
                if (this.up && this.pDY > -this.pMaxDY) {
                    --this.pDY;
                }
                if (this.down && this.pDY < this.pMaxDY) {
                    ++this.pDY;
                }
                if (this.left && this.pDX > -this.pMaxDX) {
                    --this.pDX;
                }
                if (this.right && this.pDX < this.pMaxDX) {
                    ++this.pDX;
                }
                if (this.fire) {
                    this.fire();
                    this.fire = false;
                }
                if (this.pDX != 0) {
                    ++this.pXSlowDown;
                    if (this.pXSlowDown == 10) {
                        this.pXSlowDown = 0;
                        this.pDX = this.pDX < 0 ? ++this.pDX : --this.pDX;
                    }
                }
                if (this.pDX != 0 || this.pDY != 0) {
                    ++this.pFrameCounter;
                    if (this.pFrameCounter == 3) {
                        this.pFrameCounter = 0;
                        ++this.pCurrentFrame;
                        if (this.pCurrentFrame == P_FRAMES[this.pCurrentMove]) {
                            this.pCurrentFrame = 0;
                        }
                    }
                } else {
                    this.pCurrentFrame = 0;
                }
                if (!this.dead) {
                    this.unifiedMethod(null);
                    if (this.shot != null) {
                        this.shot.move();
                        if (this.shot.xPos < -this.xOffSet || this.shot.xPos > -this.xOffSet + this.screenWidth || this.shot.yPos < -this.yOffSet || this.shot.yPos > -this.yOffSet + this.screenHeight) {
                            this.shot = null;
                        }
                    }
                    for (int i = 0; i < this.sharks.length; ++i) {
                        if (this.sharks[i] == null) continue;
                        this.sharks[i].move();
                        if (this.sharks[i].dead && this.sharks[i].yPos < 0 || this.sharks[i].yPos > this.levelHeight) {
                            this.sharks[i] = null;
                            continue;
                        }
                        if (this.sharks[i].dead) continue;
                        if (this.shot != null && this.shot.xPos + this.shot.halfWidth >= this.sharks[i].xPos - this.sharks[i].halfWidth && this.shot.xPos - this.shot.halfWidth <= this.sharks[i].xPos + this.sharks[i].halfWidth && this.shot.yPos + this.shot.halfHeight >= this.sharks[i].yPos - this.sharks[i].halfHeight && this.shot.yPos - this.shot.halfHeight <= this.sharks[i].yPos + this.sharks[i].halfHeight) {
                            BSCanvas.playSound(this.sounds[4]);
                            this.sharks[i].dead = true;
                            this.shot = null;
                            this.score += 100;
                            this.updateStatus = true;
                            continue;
                        }
                        if (this.pXPos + this.pWidth < this.sharks[i].xPos - this.sharks[i].halfWidth || this.pXPos > this.sharks[i].xPos + this.sharks[i].halfWidth || this.pYPos < this.sharks[i].yPos - this.sharks[i].halfHeight || this.pYPos - this.pHeight > this.sharks[i].yPos + this.sharks[i].halfHeight) continue;
                        this.dead();
                    }
                    if (this.pXPos + this.pHalfWidth >= this.chestX && this.pXPos + this.pHalfHeight <= this.chestX + this.chestWidth && this.pYPos - this.pHalfHeight >= this.chestY - 7 && this.pYPos - this.pHalfHeight <= this.chestY + 8) {
                        this.won();
                    }
                } else {
                    if (this.pDY > -this.pMaxDY) {
                        --this.pDY;
                    }
                    if (this.pYPos > this.levelHeight || this.pYPos - this.pHeight < 0 || this.pXPos + this.pWidth > this.levelWidth || this.pXPos < 0) {
                        Thread.sleep(1000L);
                        if (this.pLives == 0) {
                            this.gameover = true;
                            this.repaint();
                            Thread.sleep(3000L);
                            this.commandListener.commandAction(BSCanvas.GAME_ENDED, (Displayable)this);
                        }
                        if (!this.gameover) {
                            this.pXPos = this.pOrigXPos;
                            this.pDX = 0;
                            this.pYPos = this.pOrigYPos;
                            this.pCurrentMove = 3;
                            this.pCurrentFrame = 0;
                            this.pDY = 0;
                            this.xOffSetCounter = 0;
                            this.xOffSetAdjust = -40;
                            if (this.pShots < 3) {
                                this.pShots = 3;
                            }
                            this.updateStatus = true;
                            for (int i = 0; i < this.sharks.length; ++i) {
                                if (this.sharks[i] == null || this.sharks[i].dead) continue;
                                this.sharks[i].reset();
                            }
                            this.dead = false;
                            this.repaint();
                            Thread.sleep(1000L);
                        }
                    }
                    this.pXPos += this.pDX;
                    this.pYPos += this.pDY;
                }
                ++this.bubblesCounter;
                if (this.bubblesCounter == 45) {
                    this.bubblesCounter = 0;
                }
                if (this.bubblesCounter % 3 == 2) {
                    ++this.bubblesFrame;
                    if (this.bubblesFrame == 2) {
                        this.bubblesFrame = 0;
                    }
                }
                this.repaint();
                Thread.sleep(66L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void fire() {
        if (this.pShots > 0 && this.shot == null) {
            switch (this.pCurrentMove) {
                case 2: {
                    this.shot = new Shot(this.pXPos, this.pYPos - this.pHalfHeight, -this.shotSpeed, 0, 2, this.shotImages);
                    break;
                }
                case 3: {
                    this.shot = new Shot(this.pXPos + this.pWidth, this.pYPos - this.pHalfHeight, this.shotSpeed, 0, 3, this.shotImages);
                }
            }
            BSCanvas.playSound(this.sounds[3]);
            --this.pShots;
            this.updateStatus = true;
        }
    }

    public void keyPressed(int n) {
        this.keyPressed = true;
        if (!this.dead && !this.won) {
            int n2 = this.getGameAction(n);
            if (n == -7) {
                this.commandListener.commandAction(BSCanvas.DISPLAY_MENU, (Displayable)this);
            } else {
                block0 : switch (n2) {
                    case 1: {
                        this.up = true;
                        break;
                    }
                    case 6: {
                        this.down = true;
                        break;
                    }
                    case 2: {
                        this.left = true;
                        if (this.pCurrentMove != 2) {
                            this.pCurrentMove = 2;
                            this.xOffSetCounter = 80 + this.xOffSetCounter;
                            this.xOffSetAdjust = 40;
                        }
                        this.pCurrentFrame = 0;
                        break;
                    }
                    case 5: {
                        this.right = true;
                        if (this.pCurrentMove != 3) {
                            this.pCurrentMove = 3;
                            this.xOffSetCounter = -80 + this.xOffSetCounter;
                            this.xOffSetAdjust = -40;
                        }
                        this.pCurrentFrame = 0;
                        break;
                    }
                    case 8: {
                        this.fire = true;
                        break;
                    }
                    default: {
                        switch (n) {
                            case 50: {
                                this.up = true;
                                break block0;
                            }
                            case 56: {
                                this.down = true;
                                break block0;
                            }
                            case 52: {
                                this.left = true;
                                if (this.pCurrentMove != 2) {
                                    this.pCurrentMove = 2;
                                    this.xOffSetCounter = 80 + this.xOffSetCounter;
                                    this.xOffSetAdjust = 40;
                                }
                                this.pCurrentFrame = 0;
                                break block0;
                            }
                            case 54: {
                                this.right = true;
                                if (this.pCurrentMove != 3) {
                                    this.pCurrentMove = 3;
                                    this.xOffSetCounter = -80 + this.xOffSetCounter;
                                    this.xOffSetAdjust = -40;
                                }
                                this.pCurrentFrame = 0;
                            }
                        }
                    }
                }
            }
        }
    }

    public void keyReleased(int n) {
        int n2 = this.getGameAction(n);
        block0 : switch (n2) {
            case 1: {
                this.up = false;
                break;
            }
            case 6: {
                this.down = false;
                break;
            }
            case 2: {
                this.left = false;
                break;
            }
            case 5: {
                this.right = false;
                break;
            }
            default: {
                switch (n) {
                    case 50: {
                        this.up = false;
                        break block0;
                    }
                    case 56: {
                        this.down = false;
                        break block0;
                    }
                    case 52: {
                        this.left = false;
                        break block0;
                    }
                    case 54: {
                        this.right = false;
                    }
                }
            }
        }
    }

    public String[] parseString(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = string.substring(0, string.indexOf(44));
            string = string.substring(string.indexOf(44) + 1);
        }
        stringArray[n] = string;
        return stringArray;
    }

    public void drawText(Graphics graphics, String[] stringArray, Font font, boolean bl, int n, int n2) {
        Font[] fontArray = new Font[stringArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = font;
        }
        this.drawText(graphics, stringArray, fontArray, bl, n, n2);
    }

    public void drawText(Graphics graphics, String[] stringArray, Font[] fontArray, boolean bl, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n5 = Math.max(fontArray[n3].stringWidth(stringArray[n3]), n5);
            n7 += fontArray[n3].getHeight();
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n - n5 / 2 - 2, n2 - 2, n5 + 2, n7 + 2);
        graphics.setColor(0);
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            n4 = fontArray[n3].stringWidth(stringArray[n3]);
            graphics.setFont(fontArray[n3]);
            graphics.drawString(stringArray[n3], n, n2 + n6, 17);
            n6 += fontArray[n3].getHeight();
        }
        if (bl) {
            graphics.drawRect(n - n5 / 2 - 2, n2 - 2, n5 + 2, n7 + 2);
        }
    }

    static {
        P_UP = 0;
        P_DOWN = 1;
        P_LEFT = 2;
        P_RIGHT = 3;
        P_DEAD = 4;
        P_FRAMES = new int[]{0, 0, 4, 4, 1};
        F_FRAMES = new int[]{0, 0, 2, 2, 0};
    }
}

