/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.Collidable;
import com.lavastorm.astrosmash.GameWorld;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Enemy
extends Collidable {
    private int m_hitScore = 0;
    private int m_groundScore = 0;
    private int m_enemyTypeId = -1;
    private int m_hitReaction = 0;
    private Image[] m_xPlosionImages = new Image[0];
    private int m_currentExplosionImage = 0;
    protected GameWorld m_gameWorld = null;

    public Enemy() {
        this.reset();
    }

    public void reset() {
        super.reset();
        this.m_currentExplosionImage = 0;
    }

    public void setEnemyTypeId(int n) {
        this.m_enemyTypeId = n;
    }

    public int getEnemyTypeId() {
        return this.m_enemyTypeId;
    }

    public void setHitScore(int n) {
        this.m_hitScore = n;
    }

    public int getHitScore() {
        return this.m_hitScore;
    }

    public void setGroundScore(int n) {
        this.m_groundScore = n;
    }

    public int getGroundScore() {
        return this.m_groundScore;
    }

    public void setHitReaction(int n) {
        this.m_hitReaction = n;
    }

    public int getHitReaction() {
        return this.m_hitReaction;
    }

    public void setExplosionImages(Image[] imageArray) {
        this.m_xPlosionImages = imageArray;
    }

    public Image[] getExplosionImages() {
        return this.m_xPlosionImages;
    }

    public void paint(Graphics graphics) {
        if (this.getCollided() && 1 == this.m_hitReaction) {
            if (this.m_currentExplosionImage < this.m_xPlosionImages.length) {
                Image image = this.m_xPlosionImages[this.m_currentExplosionImage];
                graphics.drawImage(image, this.getX(), this.getY(), 20);
                ++this.m_currentExplosionImage;
            }
            if (this.m_currentExplosionImage >= this.m_xPlosionImages.length) {
                this.m_gameWorld.doneExploding(this);
            }
        } else {
            super.paint(graphics);
        }
    }

    public void tick(long l) {
        if (!this.getCollided()) {
            super.tick(l);
        } else if (1 != this.m_hitReaction) {
            this.m_gameWorld.doneExploding(this);
        }
    }

    public void setGameWorld(GameWorld gameWorld) {
        this.m_gameWorld = gameWorld;
    }

    protected boolean hasNextExplosionImage() {
        return this.m_currentExplosionImage < this.m_xPlosionImages.length;
    }

    protected Image getNextExplosionImage() {
        Image image = this.m_xPlosionImages[this.m_currentExplosionImage];
        ++this.m_currentExplosionImage;
        return image;
    }
}

