/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.AstrosmashMidlet;
import com.lavastorm.astrosmash.GameWorld;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;

public class AstrosmashScreen
extends Canvas
implements Runnable {
    public static final int INITIAL_KEY_DELAY = 250;
    public static final int KEY_REPEAT_CYCLE = 75;
    private boolean m_bRunning = true;
    private Thread m_gameThread = null;
    private GameWorld m_gameWorld = null;
    private volatile boolean m_bKeyHeldDown = false;
    private volatile boolean m_bAfterInitialWait = false;
    private volatile int m_heldDownGameAction;
    private volatile long m_initialHoldDownTime;
    private boolean m_bFirstPaint = true;
    private Command m_pauseCommand = null;
    private Command m_nextCommand = null;
    private Command m_exitCommand = null;
    private long m_nStartTime;
    Thread m_currentThread = null;
    int m_nThreadSwitches = 0;
    long m_nLastMemoryUsageTime = 0L;

    public AstrosmashScreen(Command command, Command command2, Command command3) {
        this.m_pauseCommand = command;
        this.addCommand(this.m_pauseCommand);
        this.m_exitCommand = command3;
        this.addCommand(this.m_exitCommand);
        this.m_nextCommand = command2;
    }

    public boolean setup(AstrosmashMidlet astrosmashMidlet) {
        if (this.m_gameWorld == null) {
            this.m_gameWorld = new GameWorld(this.getWidth(), this.getHeight() - 14, this);
            if (!this.m_gameWorld.setup(astrosmashMidlet)) {
                return false;
            }
        }
        this.m_bFirstPaint = true;
        this.m_nStartTime = 0L;
        return true;
    }

    protected void paint(Graphics graphics) {
        if (this.m_bFirstPaint) {
            this.clearScreen(graphics);
            this.m_bFirstPaint = false;
        }
        this.m_gameWorld.paint(graphics);
    }

    public void run() {
        try {
            long l;
            long l2 = System.currentTimeMillis();
            long l3 = l = System.currentTimeMillis();
            this.m_nLastMemoryUsageTime = 0L;
            while (this.m_bRunning) {
                long l4 = System.currentTimeMillis();
                long l5 = l4 - l;
                if (this.m_bKeyHeldDown && l4 - this.m_initialHoldDownTime > 250L && l4 - l3 > 75L) {
                    l3 = l4;
                    this.m_gameWorld.handleAction(this.m_heldDownGameAction);
                }
                this.m_gameWorld.tick(l5);
                this.repaint();
                this.serviceRepaints();
                l = l4;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void resetStartTime() {
        this.m_nStartTime = System.currentTimeMillis();
    }

    public void pause() {
        this.m_bRunning = false;
        this.m_gameThread = null;
        System.gc();
    }

    public void exit() {
        this.m_bRunning = false;
        this.m_gameThread = null;
    }

    public void start() {
        System.gc();
        this.m_bRunning = true;
        this.m_gameThread = new Thread(this);
        this.m_gameThread.start();
    }

    public void gameIsOver() {
        this.m_bRunning = false;
        this.m_gameThread = null;
        AstrosmashMidlet.setGameOver(true);
        this.removeCommand(this.m_pauseCommand);
        this.removeCommand(this.m_exitCommand);
        this.addCommand(this.m_nextCommand);
        this.repaint();
        this.serviceRepaints();
        System.gc();
    }

    public int getPeakScore() {
        return this.m_gameWorld.getPeakScore();
    }

    public void restartGame() {
        System.gc();
        this.removeCommand(this.m_nextCommand);
        this.addCommand(this.m_pauseCommand);
        this.addCommand(this.m_exitCommand);
        this.m_gameWorld.reset();
        this.m_bFirstPaint = true;
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
        this.m_bKeyHeldDown = false;
    }

    public int getGameAction(int n) {
        switch (n) {
            case 49: 
            case 51: {
                return 9;
            }
            case 50: {
                return 1;
            }
            case 52: {
                return 2;
            }
            case 54: {
                return 5;
            }
            case 56: {
                return 6;
            }
            case 53: 
            case 55: 
            case 57: {
                return 10;
            }
        }
        return super.getGameAction(n);
    }

    protected void keyPressed(int n) {
        try {
            int n2 = this.getGameAction(n);
            this.m_gameWorld.handleAction(n2);
            this.m_heldDownGameAction = n2;
            this.m_bKeyHeldDown = true;
            this.m_initialHoldDownTime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    protected void clearScreen(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }
}

