/*
 * Decompiled with CFR 0.152.
 */
package com.lavastorm.astrosmash;

import com.lavastorm.astrosmash.AstrosmashScreen;
import com.lavastorm.astrosmash.HiScoreDisplay;
import com.lavastorm.astrosmash.Language;
import com.lavastorm.astrosmash.MenuScreen;
import com.lavastorm.astrosmash.SplashCanvas;
import com.lavastorm.astrosmash.SplashForm;
import com.lavastorm.astrosmash.StatusCanvas;
import com.motorola.midi.MidiPlayer;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class AstrosmashMidlet
extends MIDlet
implements CommandListener,
Runnable {
    public static final int DIVISION_GRANULARITY = 1024;
    public static final String TITLE_SPLASH = "/splash_astro0.png";
    public static final String MENU_SPLASH = "/menu.png";
    public static final String PREGAME_SPLASH = "/splash_astro1.png";
    public static final String MENU_ARROW_IMAGE = "/menu_arrow.png";
    public static final String BACKGROUND_MUSIC = "midis/tiny_techno.mid";
    public static final int INTRO_DURATION = 2000;
    public static final int DEMO_INTRO_DURATION = 4000;
    public static final int PREGAME_SPLASH_DURATION = 2000;
    public static String START_LABEL;
    public static String EXIT_LABEL;
    public static String QUIT_LABEL;
    public static String QUIT_CONFIRM_LABEL;
    public static String QUIT_ABORT_LABEL;
    public static String PAUSE_LABEL;
    public static String RESUME_LABEL;
    public static String RESTART_LABEL;
    public static String NEXT_LABEL;
    public static String BACK_LABEL;
    public static String MORE_LABEL;
    public static String SELECT_LABEL;
    public static String BLANK_LABEL;
    public static String CREDITS_TITLE;
    public static String HELP_TITLE;
    public static String DEMO_OVER_TITLE;
    public static final int LEFT_PRIORITY = 12;
    public static final int RIGHT_PRIORITY = 1;
    private boolean m_bGameStarted = false;
    private boolean m_bPaused = false;
    private boolean m_bMightQuit = false;
    private boolean m_bDidQuit = false;
    private boolean m_bShowingSplash = false;
    private static boolean m_bGameOver;
    private boolean m_bMusicStarted = false;
    private int m_nSplash = 0;
    private Display m_display = null;
    private AstrosmashScreen m_astroSmashScreen = null;
    private MenuScreen m_menuScreen = null;
    private HiScoreDisplay m_hiScoreDisplay = null;
    private Image m_titleImage = null;
    private Image m_menuImage = null;
    private Image m_pregameImage = null;
    private Image m_menuArrowImage = null;
    private Command m_start = null;
    private Command m_exit = null;
    private Command m_quit = null;
    private Command m_quitConfirm = null;
    private Command m_quitAbort = null;
    private Command m_pause = null;
    private Command m_resume = null;
    private Command m_restart = null;
    private Command m_next = null;
    private Command m_back = null;
    private Command m_select = null;
    private Command m_blank = null;
    private Timer m_timer = null;
    private Form m_form = null;
    private boolean m_bLoadFlag = true;
    private Thread m_loadThread = null;
    private Form m_loadForm = null;
    private Gauge m_loadGauge = null;
    private static Random m_random;
    protected StatusCanvas m_statusCanvas;
    protected Command m_command1;
    protected Command m_command2;

    public AstrosmashMidlet() {
        m_random = new Random(System.currentTimeMillis());
        this.m_statusCanvas = null;
        this.m_command1 = null;
        this.m_command2 = null;
        Language.init(System.getProperty("microedition.locale"));
        this.prepareLabels();
        this.m_display = Display.getDisplay((MIDlet)this);
        this.m_loadForm = new Form("Astrosmash");
        this.m_loadGauge = new Gauge(Language.getString("Loading"), false, 10, 0);
        this.m_exit = new Command(EXIT_LABEL, 7, 12);
        this.m_blank = new Command(BLANK_LABEL, 1, 1);
        this.m_loadForm.append("\n");
        this.m_loadForm.append((Item)this.m_loadGauge);
        this.m_loadForm.addCommand(this.m_exit);
        this.m_loadForm.addCommand(this.m_blank);
        this.m_loadForm.setCommandListener((CommandListener)this);
        this.m_display.setCurrent((Displayable)this.m_loadForm);
        this.m_loadThread = new Thread(this);
        this.setLoadFlag(true);
    }

    public void prepareLabels() {
        START_LABEL = Language.getString("Start");
        EXIT_LABEL = Language.getString("Exit");
        QUIT_LABEL = Language.getString("Quit");
        QUIT_CONFIRM_LABEL = Language.getString("Yes");
        QUIT_ABORT_LABEL = Language.getString("No");
        PAUSE_LABEL = Language.getString("Pause");
        RESUME_LABEL = Language.getString("Resume");
        NEXT_LABEL = Language.getString("Next");
        BACK_LABEL = Language.getString("Back");
        SELECT_LABEL = Language.getString("Select");
        CREDITS_TITLE = Language.getString("Credits");
        HELP_TITLE = Language.getString("Help");
        RESTART_LABEL = Language.getString("Restart");
        DEMO_OVER_TITLE = Language.getString("DemoOver");
        MORE_LABEL = "MORE";
        BLANK_LABEL = "";
    }

    public void run() {
        if (!this.createResources()) {
            return;
        }
        this.m_form = new Form("");
        this.m_form.addCommand(this.m_back);
        this.m_form.setCommandListener((CommandListener)this);
        if (!this.setupMenuScreen()) {
            return;
        }
        if (!this.updateGauge(1)) {
            return;
        }
        if (!this.setupAstroSmashScreen()) {
            return;
        }
        if (!this.updateGauge(1)) {
            return;
        }
        this.m_timer = new Timer();
        this.m_hiScoreDisplay = new HiScoreDisplay(this.m_display, this);
        Displayable displayable = this.showSplash(this.m_titleImage, null, null, false);
        if (!this.m_bMusicStarted) {
            try {
                MidiPlayer.play(BACKGROUND_MUSIC, 0);
                this.m_bMusicStarted = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_bShowingSplash = true;
        this.m_nSplash = 1;
        this.scheduleCommand(this.m_next, displayable, 2000L);
        this.m_loadThread = null;
        this.m_loadGauge = null;
        this.m_loadForm = null;
    }

    public boolean updateGauge(int n) {
        this.m_loadGauge.setValue(this.m_loadGauge.getValue() + n);
        this.waitLoadFlag(true);
        return this.m_loadThread != null;
    }

    public void startApp() {
        if (this.m_loadThread != null) {
            try {
                this.m_loadThread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            this.setLoadFlag(true);
        } else if (!m_bGameOver) {
            if (this.m_bShowingSplash) {
                if (this.m_nSplash == 2) {
                    this.startGame(true);
                } else if (this.m_nSplash == 1) {
                    Displayable displayable = this.showSplash(this.m_titleImage, null, null, false);
                    this.m_bShowingSplash = true;
                    this.m_nSplash = 1;
                    this.scheduleCommand(this.m_next, displayable, 2000L);
                }
            } else if (this.m_bMightQuit) {
                this.displayStatus(Language.getString("QuitCheck"), this.m_quitAbort, this.m_quitConfirm);
            } else if (!this.m_bDidQuit && this.m_bGameStarted) {
                this.startGame(false);
            }
        }
    }

    public void pauseApp() {
        if (this.m_loadThread != null) {
            this.setLoadFlag(false);
        } else {
            this.m_timer.cancel();
            this.m_timer = new Timer();
            this.m_astroSmashScreen.pause();
        }
    }

    public void destroyApp(boolean bl) throws MIDletStateChangeException {
        if (this.m_loadThread != null) {
            this.m_loadThread = null;
            this.setLoadFlag(true);
        }
        if (this.m_astroSmashScreen != null) {
            this.m_astroSmashScreen.exit();
            this.m_astroSmashScreen = null;
        }
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
        MidiPlayer.stop();
        this.m_bMusicStarted = false;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.m_next) {
            if (displayable instanceof AstrosmashScreen) {
                this.showHiScores(null, this.m_next, true, false);
            } else {
                this.m_hiScoreDisplay.readHighScores();
                this.showMenuScreen();
            }
        } else if (command == this.m_back) {
            this.showMenuScreen();
        } else if (command == this.m_restart) {
            this.startGame(true);
        } else if (command == this.m_exit) {
            if (this.m_loadThread != null) {
                this.m_loadThread = null;
                this.setLoadFlag(true);
            } else {
                this.m_astroSmashScreen.exit();
            }
            try {
                this.destroyApp(true);
                this.notifyDestroyed();
            }
            catch (MIDletStateChangeException mIDletStateChangeException) {}
        } else if (command == this.m_quit) {
            this.pauseApp();
            this.m_bMightQuit = true;
            this.displayStatus(Language.getString("QuitCheck"), this.m_quitAbort, this.m_quitConfirm);
        } else if (command == this.m_quitConfirm) {
            if (!this.m_bDidQuit) {
                this.m_astroSmashScreen.exit();
                this.m_bMightQuit = false;
                this.m_bDidQuit = true;
                m_bGameOver = true;
                this.m_bPaused = false;
                this.m_astroSmashScreen.removeCommand(this.m_resume);
                this.m_astroSmashScreen.addCommand(this.m_pause);
            }
            this.showHiScores(null, this.m_next, true, true);
        } else if (command == this.m_quitAbort) {
            if (this.m_bPaused) {
                this.m_display.setCurrent((Displayable)this.m_astroSmashScreen);
                this.m_astroSmashScreen.setCommandListener(this);
            } else {
                this.m_bMightQuit = false;
                this.startGame(false);
            }
        } else if (command == this.m_pause) {
            this.pauseApp();
            this.m_bPaused = true;
            this.m_astroSmashScreen.removeCommand(this.m_pause);
            this.m_astroSmashScreen.addCommand(this.m_resume);
        } else if (command == this.m_resume) {
            this.m_astroSmashScreen.removeCommand(this.m_resume);
            this.m_astroSmashScreen.addCommand(this.m_pause);
            this.m_bPaused = false;
            this.startGame(false);
        }
    }

    public void handleMenuChoice(int n) {
        switch (n) {
            case 0: {
                this.m_bShowingSplash = true;
                this.m_nSplash = 2;
                Displayable displayable = this.showSplash(this.m_pregameImage, null, null, false);
                this.scheduleCommand(this.m_restart, displayable, 2000L);
                break;
            }
            case 1: {
                this.showHiScores(this.m_back, this.m_blank, false, false);
                break;
            }
            case 2: {
                this.showForm(HELP_TITLE, Language.getString("HelpText"));
                break;
            }
            case 3: {
                this.showForm(CREDITS_TITLE, Language.getString("CreditsText"));
                break;
            }
        }
    }

    protected void showForm(String string, String string2) {
        if (!string.equals(this.m_form.getTitle())) {
            while (this.m_form.size() > 0) {
                try {
                    this.m_form.delete(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_form.setTitle(string);
            this.m_form.append(string2);
        }
        this.m_display.setCurrent((Displayable)this.m_form);
    }

    protected boolean createResources() {
        try {
            if (this.m_titleImage == null) {
                this.m_titleImage = Image.createImage((String)TITLE_SPLASH);
            }
            if (this.m_menuImage == null) {
                this.m_menuImage = Image.createImage((String)MENU_SPLASH);
            }
            if (this.m_pregameImage == null) {
                this.m_pregameImage = Image.createImage((String)PREGAME_SPLASH);
            }
            if (this.m_menuArrowImage == null) {
                this.m_menuArrowImage = Image.createImage((String)MENU_ARROW_IMAGE);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (this.m_start == null) {
            this.m_start = new Command(START_LABEL, 1, 1);
        }
        if (this.m_exit == null) {
            this.m_exit = new Command(EXIT_LABEL, 7, 12);
        }
        if (this.m_quit == null) {
            this.m_quit = new Command(QUIT_LABEL, 1, 12);
        }
        if (this.m_quitConfirm == null) {
            this.m_quitConfirm = new Command(QUIT_CONFIRM_LABEL, 1, 1);
        }
        if (this.m_quitAbort == null) {
            this.m_quitAbort = new Command(QUIT_ABORT_LABEL, 1, 12);
        }
        if (this.m_pause == null) {
            this.m_pause = new Command(PAUSE_LABEL, 1, 1);
        }
        if (this.m_resume == null) {
            this.m_resume = new Command(RESUME_LABEL, 1, 1);
        }
        if (this.m_restart == null) {
            this.m_restart = new Command(RESTART_LABEL, 1, 1);
        }
        if (this.m_next == null) {
            this.m_next = new Command(NEXT_LABEL, 1, 1);
        }
        if (this.m_back == null) {
            this.m_back = new Command(BACK_LABEL, 1, 12);
        }
        if (this.m_select == null) {
            this.m_select = new Command(SELECT_LABEL, 1, 1);
        }
        if (this.m_blank == null) {
            this.m_blank = new Command(BLANK_LABEL, 1, 1);
        }
        return true;
    }

    protected static void setGameOver(boolean bl) {
        m_bGameOver = bl;
    }

    protected boolean setupMenuScreen() {
        if (this.m_menuScreen == null) {
            this.m_menuScreen = new MenuScreen(this.m_menuImage, this.m_menuArrowImage, this.m_exit, this.m_select, this);
        }
        return true;
    }

    protected boolean setupAstroSmashScreen() {
        if (this.m_astroSmashScreen == null) {
            this.m_astroSmashScreen = new AstrosmashScreen(this.m_pause, this.m_next, this.m_quit);
            if (!this.m_astroSmashScreen.setup(this)) {
                return false;
            }
        }
        this.m_astroSmashScreen.setCommandListener(this);
        return true;
    }

    protected Displayable showSplash(Image image, Command command, Command command2, boolean bl) {
        Object object;
        if (bl) {
            object = new SplashForm(image);
        } else {
            object = new SplashCanvas(image);
            ((SplashCanvas)((Object)object)).repaint();
            ((SplashCanvas)((Object)object)).serviceRepaints();
        }
        if (command != null) {
            object.addCommand(command);
        }
        if (command2 != null) {
            object.addCommand(command2);
        }
        object.setCommandListener(this);
        this.m_display.setCurrent((Displayable)object);
        return object;
    }

    protected void showMenuScreen() {
        this.m_bDidQuit = false;
        m_bGameOver = false;
        this.m_bGameStarted = false;
        this.m_bPaused = false;
        this.m_bShowingSplash = false;
        this.m_astroSmashScreen.exit();
        this.m_display.setCurrent((Displayable)this.m_menuScreen);
        this.m_menuScreen.repaint();
        this.m_menuScreen.serviceRepaints();
    }

    protected void showHiScores(Command command, Command command2, boolean bl, boolean bl2) {
        int n = this.m_astroSmashScreen.getPeakScore();
        this.m_hiScoreDisplay.setPeakScore(n);
        this.m_hiScoreDisplay.setCommands(command, command2);
        if (bl) {
            if (!this.m_hiScoreDisplay.enterHighScore(bl2)) {
                this.showMenuScreen();
            }
        } else {
            this.m_hiScoreDisplay.showHighScores();
        }
    }

    protected void startGame(boolean bl) {
        if (!this.m_bPaused) {
            if (bl || !this.m_bGameStarted) {
                this.m_astroSmashScreen.resetStartTime();
                this.m_astroSmashScreen.restartGame();
            }
            this.m_display.setCurrent((Displayable)this.m_astroSmashScreen);
            this.m_astroSmashScreen.setCommandListener(this);
            this.m_astroSmashScreen.start();
            this.m_bGameStarted = true;
            this.m_bShowingSplash = false;
            this.m_nSplash = 0;
        }
    }

    public static void printMemoryUsage(String string) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        long l2 = runtime.totalMemory();
        System.out.println(string + ": " + l + " free bytes out of " + l2);
    }

    protected void scheduleCommand(Command command, Displayable displayable, long l) {
        this.m_timer.schedule((TimerTask)new CommandTimerTask(command, displayable), l);
    }

    public void displayStatus(String string, Command command, Command command2) {
        int n;
        if (this.m_statusCanvas == null) {
            this.m_statusCanvas = new StatusCanvas();
        }
        if (this.m_command1 != null) {
            this.m_statusCanvas.removeCommand(this.m_command1);
        }
        if (this.m_command2 != null) {
            this.m_statusCanvas.removeCommand(this.m_command2);
        }
        this.m_command1 = command;
        if (this.m_command1 != null) {
            this.m_statusCanvas.addCommand(this.m_command1);
        }
        this.m_command2 = command2;
        if (this.m_command2 != null) {
            this.m_statusCanvas.addCommand(this.m_command2);
        }
        if ((n = string.indexOf(10)) >= 0) {
            this.m_statusCanvas.setText(string.substring(0, n), string.substring(n + 1));
        } else {
            this.m_statusCanvas.setText(string);
        }
        this.m_display.setCurrent((Displayable)this.m_statusCanvas);
        this.m_statusCanvas.setCommandListener(this);
        this.m_statusCanvas.repaint();
        this.m_statusCanvas.serviceRepaints();
    }

    public static int getRandomInt() {
        m_random.setSeed(System.currentTimeMillis() + (long)m_random.nextInt());
        return m_random.nextInt();
    }

    public static int getAbsRandomInt() {
        m_random.setSeed(System.currentTimeMillis() + (long)m_random.nextInt());
        return Math.abs(m_random.nextInt());
    }

    private synchronized void setLoadFlag(boolean bl) {
        this.m_bLoadFlag = bl;
        this.notifyAll();
    }

    private synchronized void waitLoadFlag(boolean bl) {
        if (this.m_bLoadFlag == bl) {
            return;
        }
        do {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.m_bLoadFlag != bl);
    }

    static {
        m_bGameOver = false;
    }

    protected class CommandTimerTask
    extends TimerTask {
        private Command m_command;
        private Displayable m_displayable;

        public CommandTimerTask(Command command, Displayable displayable) {
            this.m_command = command;
            this.m_displayable = displayable;
        }

        public void run() {
            AstrosmashMidlet.this.commandAction(this.m_command, this.m_displayable);
        }
    }
}

