/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class TFont {
    private int fCharHeight;
    private short[] fCharBuff;
    private short[] fCharOffset;

    public TFont(String fileName) {
        int i = 0;
        int n = 0;
        this.fCharHeight = 0;
        try {
            InputStream is = this.getClass().getResourceAsStream(fileName);
            if (is == null) {
                return;
            }
            DataInputStream file = new DataInputStream(is);
            this.fCharHeight = file.readByte();
            int k = file.readShort();
            this.fCharOffset = new short[256];
            this.fCharBuff = new short[k];
            n = 0;
            i = 0;
            while (i < 256) {
                k = file.readByte();
                this.fCharOffset[i] = (short)n;
                this.fCharBuff[n++] = k;
                if (k > 0) {
                    int j = 0;
                    while (j < k) {
                        this.fCharBuff[n++] = file.readShort();
                        ++j;
                    }
                }
                ++i;
            }
            file.close();
            System.err.println("font " + fileName);
        }
        catch (IOException e) {
            System.out.println("io error " + e);
        }
    }

    public int getHeight() {
        return this.fCharHeight;
    }

    public int getWidth(int b) {
        if (this.fCharHeight > 0) {
            return this.fCharBuff[this.fCharOffset[b & 0xFF]];
        }
        return 0;
    }

    public boolean loaded() {
        return this.fCharHeight > 0;
    }

    public int getMaxWidth() {
        if (this.fCharHeight > 0) {
            short m = 0;
            int n = 0;
            int i = 0;
            while (i <= 255) {
                short k = this.fCharBuff[n];
                if (k > m) {
                    m = k;
                }
                n = n + k + 1;
                ++i;
            }
            return m;
        }
        return 0;
    }

    public int drawChar(Graphics g, int x, int y, int b) {
        int n;
        int k = this.fCharOffset[b & 0xFF];
        if ((n = this.fCharBuff[k++]) > 0 && this.fCharHeight > 0) {
            int ix = 0;
            while (ix < n) {
                int m = this.fCharBuff[k++];
                int nn = 0;
                int iy = 0;
                while (iy < this.fCharHeight) {
                    if ((m & 1) != 0) {
                        ++nn;
                    } else if (nn != 0) {
                        g.fillRect(x + ix, y + iy - nn, 1, nn);
                        nn = 0;
                    }
                    m >>= 1;
                    ++iy;
                }
                if (nn != 0) {
                    g.fillRect(x + ix, y + iy - nn, 1, nn);
                }
                ++ix;
            }
        }
        return n;
    }
}

