/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import wrapper.WrapperMIDlet;

public class Menu
extends Canvas
implements Runnable,
Constants {
    private static final String emptyString = "";
    private Graphics screen;
    private Image[] images = null;
    static String portalURL;
    static String portalText;
    static Bundle bundle;
    public static int lang_sel;
    public static int lang_num;
    public static String[] lang_code;
    public static String[] lang_name;
    private static boolean isLanguagesSelector;
    private static boolean isMultiLanguages;
    public static boolean isDemo;
    private int selectedLanguageIndex = 0;
    private Image splash;
    private Image icon;
    private XFont font = new XFont();
    private String[] names;
    private int type;
    private Throwable t;
    private String msg;
    private int state;
    private String lsk;
    private String rsk;
    private int screenWidth = 0;
    private int screenHeight = 0;
    private int scrollingPosition = 0;
    private int selected;
    private String[] txtAbout;
    private String[] txtMoreGames;
    private String[] txtExitQ;
    public static String[][] texts;
    private String[] portals;
    private int scrollCount = 0;
    private int pressedKey = 0;
    private int pressingKey = 0;
    private boolean isPreesedEnter = false;
    private boolean isPaintLock = false;
    private int textBoxLines;
    private boolean isShortHeight;
    private boolean isBitShortHeight;

    public Menu() {
        this.setFullScreenMode(true);
    }

    private void setSoftLabel(int key, String label) {
        if (key == 21) {
            this.lsk = label;
        } else if (key == 22) {
            this.rsk = label;
        }
    }

    private void setSoftkeys(String lsk, String rsk) {
        this.setSoftLabel(21, lsk);
        this.setSoftLabel(22, rsk);
    }

    public void keyReleased(int keyCode) {
        this.pressingKey = 0;
    }

    public void keyPressed(int keyCode) {
        if (keyCode < 0 && (keyCode == -21 || keyCode == -22)) {
            keyCode = -keyCode;
        }
        switch (this.state) {
            case 3: {
                if (this.isAction(keyCode)) {
                    if (2 == this.selected) {
                        if (null != portalURL) {
                            this.isPreesedEnter = true;
                        }
                    } else if (3 != this.selected) {
                        this.changeState(200);
                    }
                    this.repaintNow();
                } else if (this.isUp(keyCode)) {
                    this.pressingKey = keyCode;
                } else if (this.isDown(keyCode)) {
                    this.pressingKey = keyCode;
                } else if (this.isLeft(keyCode)) {
                    --this.selected;
                    if (this.selected < 0) {
                        this.selected = this.names.length - 1;
                    }
                    this.scrollingPosition = 0;
                    this.scrollCount = 0;
                    this.pressedKey = keyCode;
                    this.pressingKey = keyCode;
                    if (2 == this.selected && null == portalURL || 3 == this.selected) {
                        this.setSoftkeys(null, Menu.getMessage(131072));
                    } else {
                        this.setSoftkeys(Menu.getMessage(131070), Menu.getMessage(131072));
                    }
                } else if (this.isRight(keyCode)) {
                    ++this.selected;
                    if (this.selected >= this.names.length) {
                        this.selected = 0;
                    }
                    this.scrollingPosition = 0;
                    this.scrollCount = 0;
                    this.pressedKey = keyCode;
                    this.pressingKey = keyCode;
                    if (2 == this.selected && null == portalURL || 3 == this.selected) {
                        this.setSoftkeys(null, Menu.getMessage(131072));
                    } else {
                        this.setSoftkeys(Menu.getMessage(131070), Menu.getMessage(131072));
                    }
                }
                if (keyCode != 22) break;
                this.scrollingPosition = 0;
                this.scrollCount = 0;
                this.changeState(6);
                break;
            }
            case 6: {
                if (this.isAction(keyCode)) {
                    this.changeState(100);
                    break;
                }
                if (keyCode == 22) {
                    this.scrollingPosition = 0;
                    this.changeState(3);
                    break;
                }
                if (this.isUp(keyCode)) {
                    this.pressingKey = keyCode;
                    break;
                }
                if (!this.isDown(keyCode)) break;
                this.pressingKey = keyCode;
                break;
            }
            case 2: {
                this.handleSelectLanguage(keyCode);
                this.repaintNow();
            }
        }
    }

    private boolean isAction(int keyCode) {
        if (keyCode == 53 || keyCode == 21) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 8;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isUp(int keyCode) {
        if (keyCode == 50) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isDown(int keyCode) {
        if (keyCode == 56) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 6;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isLeft(int keyCode) {
        if (keyCode == 52) {
            return true;
        }
        try {
            if (this.getGameAction(keyCode) == 2) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isRight(int keyCode) {
        if (keyCode == 54) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 5;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void executionException(int type, Throwable t) {
        this.type = type;
        this.t = t;
        System.out.println(" t " + t.toString());
        this.repaintNow();
    }

    protected void msg(int type, String msg) {
        this.type = type;
        this.msg = msg;
        System.out.println(" msg " + msg);
        this.repaintNow();
    }

    public void run() {
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.isShortHeight = false;
        if (this.screenHeight < this.changeScaleValueFromMLes(180)) {
            this.isShortHeight = true;
        }
        this.isBitShortHeight = false;
        if (this.screenHeight < this.changeScaleValueFromMLes(210)) {
            this.isBitShortHeight = true;
        }
        boolean isMenu = true;
        while (this.state != 100 && isMenu) {
            switch (this.state) {
                case 0: {
                    try {
                        this.splash = Image.createImage((String)"/disney_logo.png");
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    this.load();
                    this.font.load("/small_font.png", "/small_font.xft");
                    isLanguagesSelector = false;
                    isMultiLanguages = false;
                    this.readSettings();
                    if (!this.isInitializedLanguages()) {
                        isLanguagesSelector = true;
                        if (lang_sel == 0) {
                            lang_sel = 1;
                        }
                        this.loadStrings();
                    } else {
                        this.loadStrings();
                    }
                    this.changeState(1);
                    this.repaintNow();
                    break;
                }
                case 1: {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (1 < lang_num) {
                        isMultiLanguages = true;
                    }
                    if (1 < lang_num && isLanguagesSelector) {
                        this.changeState(2);
                        break;
                    }
                    this.loadStrings();
                    this.changeState(3);
                    this.repaintNow();
                    break;
                }
                case 2: {
                    this.repaintNow();
                    try {
                        Thread.yield();
                        Thread.sleep(100L);
                    }
                    catch (Exception e3) {}
                    break;
                }
                case 3: {
                    this.handleMenu();
                    break;
                }
                case 6: {
                    this.handleExitQ();
                    break;
                }
                case 200: {
                    this.free();
                    this.setSoftkeys(null, null);
                    isMenu = false;
                    WrapperMIDlet.getInstance().executeMIDlet(this.selected);
                    this.changeState(300);
                    break;
                }
                case 300: {
                    this.repaintNow();
                    try {
                        Thread.yield();
                        Thread.sleep(100L);
                    }
                    catch (Exception e4) {}
                    break;
                }
                case 5: {
                    this.repaintNow();
                    try {
                        Thread.yield();
                        Thread.sleep(100L);
                    }
                    catch (Exception e5) {}
                    break;
                }
                case 4: {
                    if (this.isPreesedEnter) {
                        this.startBrowser(portalURL);
                        this.isPreesedEnter = false;
                        break;
                    }
                    this.repaintNow();
                    try {
                        Thread.yield();
                        Thread.sleep(100L);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (isMenu) {
            WrapperMIDlet.getInstance().notifyDestroyed();
        }
    }

    private void repaintNow() {
        this.isPaintLock = false;
        this.repaint();
        this.serviceRepaints();
        try {
            Thread.yield();
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void changeState(int newState) {
        this.state = newState;
        int tw = this.screenWidth - 32;
        switch (this.state) {
            case 3: {
                this.load();
                if (null != this.portals) {
                    this.txtMoreGames = this.font.breakPages(this.portals[0], tw, -1)[0];
                }
                String about = XFont.replace(WrapperMIDlet.getInstance().getAppProperty("MIDlet-Version"), Menu.getMessage(196605));
                this.txtAbout = this.font.breakPages(about, tw, -1)[0];
                this.setSoftkeys(Menu.getMessage(131070), Menu.getMessage(131072));
                break;
            }
            case 2: {
                this.setSoftkeys("OK", null);
                break;
            }
            case 6: {
                this.txtExitQ = this.font.breakPages(Menu.getMessage(196606), tw, -1)[0];
                this.setSoftkeys(Menu.getMessage(131070), Menu.getMessage(131071));
                break;
            }
            case 300: {
                break;
            }
        }
        this.repaintNow();
    }

    protected void paint(Graphics g2) {
        if (null == g2 || this.isPaintLock) {
            return;
        }
        this.isPaintLock = true;
        this.screen = g2;
        switch (this.state) {
            case 0: {
                this.paintLoading(this.screen);
                break;
            }
            case 1: {
                this.paintSplash(this.screen);
                break;
            }
            case 2: {
                this.drawSelectLanguage(this.screen);
                break;
            }
            case 3: {
                this.paintMenu(this.screen);
                break;
            }
            case 6: {
                this.paintExitQ(this.screen);
                break;
            }
            case 200: 
            case 300: {
                this.screen.setColor(0);
                this.screen.fillRect(0, 0, this.screenWidth, this.screenHeight);
            }
        }
        if (0 < this.type) {
            this.screen.setClip(0, 0, this.screenWidth, this.screenHeight);
            this.screen.setColor(0);
            this.screen.fillRect(0, 0, this.screenWidth, this.screenHeight);
            this.screen.setColor(0xFF0000);
            if (null != this.t) {
                this.screen.drawString(this.t.toString(), 0, 20, 20);
            }
            if (null != this.msg) {
                this.screen.drawString(this.msg, 0, 50, 20);
            }
        }
    }

    private void paintLoading(Graphics g2) {
    }

    private void paintSplash(Graphics g2) {
        g2.setColor(0xFFFFFF);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (this.splash != null) {
            g2.drawImage(this.splash, this.screenWidth / 2, this.screenHeight / 2, 3);
        }
    }

    private int changeScaleValueFromQVGA(int n) {
        return n * 10000 / 187 / 100;
    }

    private int changeScaleValueFromMLes(int n) {
        return n * 10000 / 137 / 100;
    }

    private void paintMenu(Graphics g2) {
        g2.setColor(0);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (this.selected < 0) {
            this.selected = this.names.length - 1;
        }
        if (this.selected >= this.names.length) {
            this.selected = 0;
        }
        int offsetY = this.changeScaleValueFromMLes(this.isShortHeight ? 0 : (this.isBitShortHeight ? 2 : 14));
        g2.drawImage(this.images[0], this.screenWidth / 2, offsetY, 17);
        g2.drawImage(this.images[1], this.screenWidth / 2, offsetY += this.images[0].getHeight() + this.changeScaleValueFromMLes(this.isShortHeight ? 0 : 5), 17);
        offsetY += this.images[1].getHeight() + this.changeScaleValueFromMLes(this.isShortHeight ? 0 : 10);
        if (this.screenWidth <= this.images[2].getWidth()) {
            g2.drawImage(this.images[2], this.screenWidth / 2, offsetY, 17);
            offsetY += this.images[2].getHeight() + this.changeScaleValueFromMLes(this.isShortHeight ? 0 : 4);
        }
        int y = offsetY;
        int x = 8;
        int xs = this.screenWidth - 5;
        int w = this.screenWidth - 16;
        this.drawLabelBox(g2, this.names[this.selected], x, y, w, this.font.getHeight());
        y = offsetY += this.font.getHeight() + this.changeScaleValueFromMLes(this.isShortHeight ? 0 : 2);
        int h2 = this.screenHeight - (offsetY + 12 + this.changeScaleValueFromMLes(4));
        if (0 == this.selected) {
            g2.drawImage(this.images[4], this.screenWidth / 2, y, 17);
        } else if (1 == this.selected) {
            g2.drawImage(this.images[3], this.screenWidth / 2, y, 17);
        } else if (2 == this.selected) {
            if (null == portalURL) {
                this.textBoxLines = h2 / this.font.getHeight();
                this.drawTextBox(g2, this.txtAbout, x, y, w, h2);
                this.drawUpDownCursor(g2, this.txtAbout, w, h2, xs, y + 5, 3, h2 - 10);
            } else {
                this.textBoxLines = h2 / this.font.getHeight();
                this.drawTextBox(g2, this.txtMoreGames, x, y, w, h2);
                this.drawUpDownCursor(g2, this.txtMoreGames, w, h2, xs, y + 5, 3, h2 - 10);
            }
        } else if (3 == this.selected) {
            this.textBoxLines = h2 / this.font.getHeight();
            this.drawTextBox(g2, this.txtAbout, x, y, w, h2);
            this.drawUpDownCursor(g2, this.txtAbout, w, h2, xs, y + 5, 3, h2 - 10);
        }
        this.paintSoftkeys(g2);
    }

    private void paintExitQ(Graphics g2) {
        g2.setColor(0);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (this.selected < 0) {
            this.selected = this.names.length - 1;
        }
        if (this.selected >= this.names.length) {
            this.selected = 0;
        }
        int offsetY = this.changeScaleValueFromMLes(this.isShortHeight ? 0 : 15);
        g2.drawImage(this.images[0], this.screenWidth / 2, offsetY, 17);
        g2.drawImage(this.images[1], this.screenWidth / 2, offsetY += this.images[0].getHeight() + this.changeScaleValueFromMLes(this.isShortHeight ? 0 : 5), 17);
        offsetY += this.images[1].getHeight() + this.changeScaleValueFromMLes(this.isShortHeight ? 0 : 10);
        if (this.screenWidth <= this.images[2].getWidth()) {
            g2.drawImage(this.images[2], this.screenWidth / 2, offsetY, 17);
            offsetY += this.images[2].getHeight() + this.changeScaleValueFromMLes(this.isShortHeight ? 0 : 4);
        }
        int y = offsetY;
        int x = 8;
        int xs = this.screenWidth - 5;
        int w = this.screenWidth - 16;
        this.drawLabelBox(g2, Menu.getMessage(131072), x, y, w, this.font.getHeight());
        y = offsetY += this.font.getHeight() + this.changeScaleValueFromMLes(this.isShortHeight ? 0 : 2);
        int h2 = this.screenHeight - (offsetY + 12 + this.changeScaleValueFromMLes(4));
        this.textBoxLines = h2 / this.font.getHeight();
        this.drawTextBox(g2, this.txtExitQ, x, y, w, h2);
        this.drawUpDownCursor(g2, this.txtExitQ, w, h2, xs, y + 5, 3, h2 - 10);
        this.paintSoftkeys(g2);
    }

    private void handleMenu() {
        if (this.isUp(this.pressingKey) || this.isDown(this.pressingKey)) {
            if (2 == this.selected) {
                if (null == portalURL) {
                    this.handleUpDownCursor(this.txtAbout, this.pressingKey);
                } else {
                    this.handleUpDownCursor(this.txtMoreGames, this.pressingKey);
                }
            } else if (3 == this.selected) {
                this.handleUpDownCursor(this.txtAbout, this.pressingKey);
            }
        }
        int tw = this.font.stringWidth(this.names[this.selected]) + this.changeScaleValueFromQVGA(60);
        this.scrollCount += this.changeScaleValueFromMLes(3);
        if (tw < this.scrollCount) {
            this.scrollCount = 0;
        }
        if (this.isPreesedEnter) {
            this.startBrowser(portalURL);
            this.isPreesedEnter = false;
        }
        this.repaintNow();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleExitQ() {
        if (this.isUp(this.pressingKey) || this.isDown(this.pressingKey)) {
            this.handleUpDownCursor(this.txtExitQ, this.pressingKey);
        }
        int tw = this.font.stringWidth(this.names[this.selected]) + this.changeScaleValueFromQVGA(60);
        this.scrollCount += this.changeScaleValueFromMLes(3);
        if (tw < this.scrollCount) {
            this.scrollCount = 0;
        }
        this.repaintNow();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void paintSoftkeys(Graphics g2) {
        if (this.lsk != null) {
            this.drawBox(g2, -20, this.screenHeight - 12, 50, 32);
            g2.drawImage(this.images[15], 15, this.screenHeight - 6, 3);
        }
        if (this.rsk != null) {
            this.drawBox(g2, this.screenWidth - 30, this.screenHeight - 12, 50, 32);
            if (0 == this.rsk.compareTo(Menu.getMessage(131072))) {
                g2.drawImage(this.images[16], this.screenWidth - 15, this.screenHeight - 6, 3);
            } else if (0 == this.rsk.compareTo(Menu.getMessage(131071))) {
                g2.drawImage(this.images[17], this.screenWidth - 15, this.screenHeight - 6, 3);
            }
        }
        g2.setColor(4340009);
        g2.drawRect(32, this.screenHeight - 12, this.screenWidth - 64, 32);
    }

    private void drawLabelBox(Graphics g2, String label, int x, int y, int w, int h2) {
        g2.setClip(x + 5, y, w - 10, h2);
        int y2 = y + h2 / 2 + this.changeScaleValueFromQVGA(2);
        int tw = this.font.stringWidth(label) + this.changeScaleValueFromQVGA(60);
        this.font.drawString(g2, label, x + w / 2 - (this.scrollCount + tw), y2, 6);
        this.font.drawString(g2, label, x + w / 2 - this.scrollCount, y2, 6);
        this.font.drawString(g2, label, x + w / 2 - (this.scrollCount - tw), y2, 6);
        g2.setClip(0, 0, this.screenWidth, this.screenHeight);
        int CURSOR_LEFT_X = this.changeScaleValueFromMLes(5);
        int CURSOR_RIGHT_X = this.changeScaleValueFromMLes(5);
        if (this.isLeft(this.pressedKey)) {
            g2.drawImage(this.images[13], x - (CURSOR_LEFT_X + 3), y2, 10);
        } else {
            g2.drawImage(this.images[13], x - CURSOR_LEFT_X, y2, 10);
        }
        if (this.isRight(this.pressedKey)) {
            g2.drawImage(this.images[14], x + w + (CURSOR_RIGHT_X + 3), y2, 6);
        } else {
            g2.drawImage(this.images[14], x + w + CURSOR_RIGHT_X, y2, 6);
        }
        this.pressedKey = 0;
    }

    private void drawBox(Graphics g2, int x, int y, int w, int h2) {
        g2.setColor(0);
        g2.fillRect(x, y, w, h2);
        g2.setColor(4340009);
        g2.drawRect(x, y, w, h2);
        g2.drawImage(this.images[5], x, y, 20);
        g2.drawImage(this.images[6], x + w + 1, y, 24);
        g2.drawImage(this.images[8], x + w + 1, y + h2, 40);
        g2.drawImage(this.images[7], x, y + h2, 36);
    }

    public DataInputStream initializeImageFromBNDL(String resource) throws Exception {
        DataInputStream in = null;
        in = new DataInputStream(this.getClass().getResourceAsStream(resource));
        in.readInt();
        return in;
    }

    public Image loadImageFromBNDL(DataInputStream in) throws Exception {
        Image img = null;
        int numBytes = in.readInt();
        byte[] b2 = new byte[numBytes];
        in.readFully(b2);
        img = Image.createImage((byte[])b2, (int)0, (int)numBytes);
        b2 = null;
        return img;
    }

    public void skipImageFromBNDL(DataInputStream in) throws Exception {
        int numBytes = in.readInt();
        in.skipBytes(numBytes);
    }

    public void closeImageFromBNDL(DataInputStream in) throws Exception {
        if (null != in) {
            in.close();
        }
        in = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() {
        block12: {
            System.gc();
            if (null != this.images) {
                return;
            }
            DataInputStream bndl = null;
            this.images = new Image[18];
            bndl = this.initializeImageFromBNDL("/menu.bin");
            for (int i2 = 0; i2 < this.images.length; ++i2) {
                this.images[i2] = this.loadImageFromBNDL(bndl);
            }
            try {
                this.closeImageFromBNDL(bndl);
            }
            catch (Exception e2) {}
            break block12;
            catch (Exception e3) {
                try {
                    e3.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        this.closeImageFromBNDL(bndl);
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.closeImageFromBNDL(bndl);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void free() {
        this.font.unload();
        this.font = null;
        this.splash = null;
        if (null != this.images) {
            for (int i2 = 0; i2 < this.images.length; ++i2) {
                if (null == this.images[i2]) continue;
                this.images[i2] = null;
            }
        }
        System.gc();
        this.images = null;
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public void startBrowser(String urlName) {
        System.out.println("platformRequest: " + urlName);
        try {
            if (null != urlName) {
                Thread.sleep(100L);
                WrapperMIDlet.getInstance().platformRequest(urlName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void terminate() {
        this.changeState(100);
    }

    private void loadStrings() {
        try {
            String lang = lang_code[lang_sel - 1];
            Bundle bundle = null;
            try {
                bundle = new Bundle("/text__" + lang + ".txt");
                texts = new String[4][];
                Menu.texts[0] = bundle.getArray("menu");
                Menu.texts[1] = bundle.getArray("names");
                Menu.texts[2] = bundle.getArray("softkeys");
                Menu.texts[3] = bundle.getArray("messages");
                bundle = null;
            }
            catch (Exception e2) {
                System.out.println("loadStrings1 " + e2);
            }
            try {
                bundle = new Bundle("/portal__" + lang + ".txt");
                this.portals = bundle.getArray("portal");
                bundle = null;
            }
            catch (Exception e3) {
                System.out.println("loadStrings2 " + e3);
            }
            Menu.readSpecialFeatures(lang_sel - 1);
            if (null == portalURL) {
                this.names = new String[3];
                this.names[0] = Menu.getMessage(65535);
                this.names[1] = Menu.getMessage(65536);
                this.names[2] = Menu.getMessage(0);
            } else {
                this.names = new String[4];
                this.names[0] = Menu.getMessage(65535);
                this.names[1] = Menu.getMessage(65536);
                this.names[2] = Menu.getMessage(1);
                this.names[3] = Menu.getMessage(0);
            }
        }
        catch (Exception e4) {
            System.out.println("loadStrings3 " + e4);
        }
    }

    public static void readSpecialFeatures(int sel) {
        String[] urls;
        System.out.println(" readSpecialFeatures ");
        try {
            bundle = new Bundle("lang.txt");
        }
        catch (Exception e2) {
            System.out.println("file lang.txt not found");
            return;
        }
        portalURL = null;
        String portalTag = "portal=";
        try {
            urls = bundle.getArray("urls");
            if (urls != null) {
                for (int i2 = 0; i2 < urls.length; ++i2) {
                    if (urls[i2].indexOf("portal=") != 0) continue;
                    portalURL = Menu.getPropertyURL(Menu.getKeyValue(urls[i2]));
                }
            }
        }
        catch (Exception e3) {
            System.out.println("portal / url not found");
        }
        try {
            urls = bundle.getArray("urls");
            int count = 0;
            if (null != urls) {
                int i3;
                for (i3 = 0; i3 < urls.length; ++i3) {
                    if (urls[i3].indexOf("portal=") == 0) {
                        ++count;
                    }
                    if (urls[i3].indexOf("community=") != 0) continue;
                    ++count;
                }
                if (0 < count) {
                    MainMIDlet.urlNames = new String[count];
                    MainMIDlet.urlValues = new String[count];
                    count = 0;
                    for (i3 = 0; i3 < urls.length; ++i3) {
                        if (urls[i3].indexOf("portal=") == 0) {
                            MainMIDlet.urlNames[count] = "portal";
                            MainMIDlet.urlValues[count] = Menu.getPropertyURL(Menu.getKeyValue(urls[i3]));
                            ++count;
                        }
                        if (urls[i3].indexOf("community=") != 0) continue;
                        MainMIDlet.urlNames[count] = "community";
                        MainMIDlet.urlValues[count] = Menu.getKeyValue(urls[i3]);
                        ++count;
                    }
                }
            }
        }
        catch (Exception e4) {
            // empty catch block
        }
        Menu.cleanBundle();
        String langCode = lang_code[sel];
        try {
            bundle = new Bundle("portal__" + langCode + ".txt");
            portalText = bundle.getArray("portal")[0];
        }
        catch (Exception e5) {
            System.out.println("file portal__" + langCode + ".txt not found");
            return;
        }
        Menu.cleanBundle();
    }

    public static void cleanBundle() {
        if (bundle != null) {
            Menu.bundle.hash.clear();
            bundle = null;
            System.gc();
        }
    }

    public static String getPropertyURL(String value) {
        int pos = value.indexOf("jad:");
        if (pos != 0) {
            return value;
        }
        int pos2 = value.indexOf(124);
        String tag = value.substring(pos + "jad:".length(), pos2);
        value = value.substring(pos2 + 1);
        String valJAD = WrapperMIDlet.getInstance().getAppProperty(tag);
        if (valJAD == null) {
            return value;
        }
        if ((value = value + "&url=" + valJAD).length() > 128) {
            return valJAD;
        }
        return value;
    }

    public static String getKeyValue(String str) {
        return str.substring(str.indexOf("=") + 1, str.length());
    }

    private boolean isInitializedLanguages() {
        this.loadLanguageInfo();
        if (lang_num <= 1) {
            lang_sel = 1;
            return true;
        }
        if (lang_sel == 0) {
            this.initializeLanguages();
            return false;
        }
        return true;
    }

    private void loadLanguageInfo() {
        Bundle b2 = null;
        try {
            try {
                b2 = new Bundle("lang.txt");
            }
            catch (Exception e2) {
                System.out.println("file lang.txt not found");
            }
            String[] content = b2.getArray("lang");
            b2 = null;
            lang_code = new String[content.length];
            lang_name = new String[content.length];
            int next_lang = 0;
            DataInputStream test = null;
            Vector<String> langVec = new Vector<String>();
            for (int i2 = 0; i2 < content.length; ++i2) {
                int pos = content[i2].indexOf(",");
                Menu.lang_code[next_lang] = content[i2].substring(0, pos);
                Menu.lang_name[next_lang] = content[i2].substring(pos + 1, content[i2].length());
                try {
                    test = new DataInputStream(this.getClass().getResourceAsStream("/text__" + lang_code[next_lang] + ".txt"));
                    ((InputStream)test).close();
                    test = null;
                }
                catch (Exception e3) {
                    continue;
                }
                langVec.addElement(lang_name[next_lang]);
                ++next_lang;
            }
            lang_num = next_lang;
            lang_name = new String[lang_num];
            int count = 0;
            Enumeration e4 = langVec.elements();
            while (e4.hasMoreElements()) {
                Menu.lang_name[count] = (String)e4.nextElement();
                ++count;
            }
            content = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initializeLanguages() {
        String property = System.getProperty("microedition.locale");
        if (property == null) {
            lang_sel = 1;
        } else {
            for (lang_sel = 1; lang_sel <= lang_num && !property.startsWith(lang_code[lang_sel - 1]); ++lang_sel) {
            }
            if (lang_sel >= lang_num + 1) {
                lang_sel = 1;
            }
        }
    }

    private void handleSelectLanguage(int keyCode) {
        if (this.isAction(keyCode)) {
            lang_sel = 1 + this.selectedLanguageIndex;
            this.loadStrings();
            this.saveSettings();
            this.changeState(3);
        } else if (this.isUp(keyCode)) {
            --this.selectedLanguageIndex;
            if (this.selectedLanguageIndex < 0) {
                this.selectedLanguageIndex = lang_num - 1;
            }
        } else if (this.isDown(keyCode)) {
            ++this.selectedLanguageIndex;
            if (lang_num <= this.selectedLanguageIndex) {
                this.selectedLanguageIndex = 0;
            }
        }
    }

    private void drawSelectLanguage(Graphics g2) {
        g2.setColor(0);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        int spc = (this.screenHeight - 12 - 8) / (lang_num + 1);
        for (int i2 = 0; i2 < lang_num; ++i2) {
            int offsetY = spc * (i2 + 1);
            if (this.selectedLanguageIndex == i2) {
                g2.drawImage(this.images[14], this.screenWidth / 2 - (this.font.stringWidth(lang_name[i2]) + 10) / 2, offsetY, 10);
                g2.drawImage(this.images[13], this.screenWidth / 2 + (this.font.stringWidth(lang_name[i2]) + 10) / 2, offsetY, 6);
                this.font.drawString(g2, lang_name[i2], this.screenWidth / 2, offsetY, 3);
                continue;
            }
            this.font.drawString(g2, lang_name[i2], this.screenWidth / 2, offsetY, 3);
        }
        this.paintSoftkeys(g2);
    }

    public void saveSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"Pixar_Selection_V1", (boolean)true);
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(ba);
            byte[] buffer = null;
            try {
                out.writeInt(lang_sel);
                buffer = ba.toByteArray();
                rs.setRecord(1, buffer, 0, buffer.length);
            }
            catch (InvalidRecordIDException e2) {
                rs.addRecord(buffer, 0, buffer.length);
            }
            rs.closeRecordStore();
            rs = null;
            out.close();
            out = null;
            ba.close();
            ba = null;
            System.gc();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettings() {
        boolean isNoData = false;
        try {
            FilterInputStream in = null;
            byte[] buffer = null;
            try {
                RecordStore rs = RecordStore.openRecordStore((String)"Pixar_Selection_V1", (boolean)true);
                try {
                    buffer = rs.getRecord(1);
                    if (buffer == null || buffer.length == 0) {
                        throw new IllegalStateException();
                    }
                }
                catch (Exception e2) {
                    buffer = new byte[1024];
                    isNoData = true;
                }
                rs.closeRecordStore();
                rs = null;
                System.gc();
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                in = new DataInputStream(new ByteArrayInputStream(buffer));
                lang_sel = ((DataInputStream)in).readInt();
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            finally {
                if (null != in) {
                    in.close();
                    in = null;
                }
                System.gc();
            }
        }
        catch (Exception e5) {
            e5.printStackTrace();
        }
    }

    private void drawTextBox(Graphics g2, String[] text, int x, int y, int w, int h2) {
        this.drawBox(g2, x, y, w, h2);
        int y1 = y - this.font.getHeight() * this.scrollingPosition;
        int count = 0;
        for (int i2 = 0; i2 < text.length; ++i2) {
            if (y <= y1 && y1 < y + this.font.getHeight() * this.textBoxLines && count < this.textBoxLines) {
                this.font.drawString(g2, text[i2], x + 8, y1, 20);
                ++count;
            }
            y1 += this.font.getHeight();
        }
    }

    private void handleUpDownCursor(String[] text, int keyCode) {
        try {
            if (this.isUp(keyCode) && 0 < this.scrollingPosition) {
                --this.scrollingPosition;
            }
            if (this.isDown(keyCode) && this.scrollingPosition < text.length - this.textBoxLines) {
                ++this.scrollingPosition;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawUpDownCursor(Graphics g2, String[] text, int w, int h2, int x1, int y1, int w1, int h1) {
        boolean isDown;
        int x = this.screenWidth / 2;
        int y = this.screenHeight - 12 + 3;
        boolean isUp = 0 < this.scrollingPosition;
        boolean bl = isDown = this.scrollingPosition < text.length - this.textBoxLines;
        if (isUp) {
            g2.drawImage(this.images[9], x, y, 17);
        } else {
            g2.drawImage(this.images[10], x, y, 17);
        }
        y += this.images[9].getHeight() + 3;
        if (isDown) {
            g2.drawImage(this.images[11], x, y, 17);
        } else {
            g2.drawImage(this.images[12], x, y, 17);
        }
        if (isUp || isDown) {
            int pos = this.scrollingPosition * this.font.getHeight();
            int max = text.length * this.font.getHeight();
            int scrollable = max - h2;
            this.drawScrollBar(g2, x1, y1, w1, h1, pos, max, scrollable);
        }
    }

    private int drawScrollBar(Graphics g2, int x, int y, int w, int h2, int pos, int max, int scrollable) {
        int result = 0;
        if (max < h2) {
            return result;
        }
        result = 0 == pos ? 1 : 2;
        g2.setColor(4340009);
        g2.drawRect(x, y, w - 1, h2 - 1);
        int pix = y;
        if (0 < pos && 0 < scrollable) {
            pix += h2 * pos / scrollable;
        }
        if (y + h2 - 2 < pix) {
            pix = y + h2 - 2;
            result = 3;
        }
        g2.setColor(15975293);
        g2.fillRect(x, pix, w, 2);
        g2.setColor(0xFFFFFF);
        g2.fillRect(x, pix, 2, 1);
        return result;
    }

    public static String getMessage(int id) {
        if (texts == null) {
            return "null";
        }
        return texts[id / 65535][id % 65535];
    }

    static {
        bundle = null;
        lang_sel = 0;
        lang_code = null;
        lang_name = null;
        isLanguagesSelector = false;
        isMultiLanguages = false;
        isDemo = false;
    }
}

