/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.rms.RecordStore;

public class BaseClass {
    public static GameScreen screen;
    public static Game game;
    public static String debug;
    public static final int targetFPS = 20;
    public static boolean guestMode;
    public static int key;
    public static int keyPress;
    public static int keyCode;
    public static final Font defaultFont;
    public static int screenWidth;
    public static int fullScreenHeight;
    public static int screenHeight;
    public static Random rand;
    public static int gameState;
    public static int nextGameState;
    public static byte[] data;
    public static int ticksCounter;
    public static String[] currentLabels;
    public static Command cmdPositive;
    public static Command cmdNegative;
    public static String[] str;
    public static String mSmsPrice;
    public static String mSmsNumber;
    public static String mSmsGameCode;
    public static boolean hasInteraction;
    public static boolean hasSendToFriend;
    public static boolean hasMoreGameRu;
    public static int xFrame;
    public static int yFrame;
    public static int wFrame;
    public static int hFrame;
    static Image windowIm;
    static Graphics grWindowIm;
    public static int commandsSetTick;
    private static Command additionalCommand;
    private static final String dataRecordStoreName = "Unisex";
    public static long[] timerResults;
    public static long[] timerValues;
    private static Image[] imageArray;
    private static int[] imageOptions;
    private static int[] imageIDs;
    private static int[] imageRating;
    public static String storeName;
    public static boolean needDownloadRes;
    public static int[] resTable;
    public static byte[] resData;
    public static int fileSize;
    public static int resSize;
    public static final int TRANSPARENT = 0;
    public static final int OPAQUE = -16777216;
    public static int bmpLastWidth;
    public static int bmpLastHeight;
    private static int[] fontsFirstChar;
    private static int[] fontsLastChar;
    private static int[][] charWidths;
    private static int[][] charOffsetsX;
    private static int[][] charOffsetsY;
    private static final int fontSpacing = 0;
    private static int[] fontHeights;
    public static int[] spaceBetweenChars;
    private static int fontColor;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_BIG = 0;
    public static final int MAX_FONT = 1;
    private static short[] specialChars;
    static final byte[] PNG_HEADER;
    static final byte[] IHDR;
    static final byte[] PLTE;
    static final byte[] IDAT;
    static final byte[] IEND;
    static final byte[] tRNS;
    private static final int TRANSP_OPAQUE = -1;
    public static final int TRANSP_BY_PALETTE = -2;
    static int crc_crc;
    static final int[] crc_table;
    private static byte[][] soundsData;
    public static int soundPlaying;
    public static boolean loop;
    private static Object sound;
    private static Object[] sounds;
    private static int[] duration;
    private static long timeToRestartSound;
    private static int startSound;
    private static boolean runnerStarted;
    public static Listener listener;
    public static int vibrationStartedTick;
    public static byte FULL_VERSION;
    public static String leaderboardURL;
    public static String sendToFriendURL;
    public static final int BASE = 8;
    public static final int PI = 804;
    public static int[] sinusTable;

    public static void loadStrings() {
        str = new String[101];
        try {
            int n = data[0];
            if (hasMoreGameRu) {
                n = 1 - n;
            }
            if (n < 0 || n > 1) {
                n = 0;
            }
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(BaseClass.getResource(0 + n)));
            dataInputStream.readShort();
            for (int i = 0; i < 101; ++i) {
                BaseClass.str[i] = dataInputStream.readUTF();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean isRusLang() {
        return hasMoreGameRu && data[0] == 0;
    }

    public static void load() {
        screen = App.screen;
        Sprites.initialize();
        game = new Game();
        data = new byte[328];
        BaseClass.loadData();
        String string = App.app.getAppProperty("Locale");
        if (string != null && string.substring(0, 2).equals("ru")) {
            hasMoreGameRu = true;
        }
        BaseClass.loadStrings();
        BaseClass.initFonts();
        BaseClass.loadSounds();
        leaderboardURL = App.app.getAppProperty("G4RT-Net");
        if (leaderboardURL == null) {
            hasInteraction = false;
        } else if (leaderboardURL.substring(0, 1).equals("0")) {
            hasInteraction = false;
        }
        sendToFriendURL = App.app.getAppProperty("G4RT-Friend");
        if (sendToFriendURL == null) {
            hasSendToFriend = false;
        } else if (sendToFriendURL.substring(0, 1).equals("0") || !hasMoreGameRu) {
            hasSendToFriend = false;
        }
    }

    static String parsePrice(String string) {
        String string2 = "0123456789ABCDEF";
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                if (c == '#') {
                    stringBuffer.append('#');
                    bl = false;
                    continue;
                }
                int n3 = string2.indexOf(c);
                if (n3 > 0) {
                    n += n3 * n2;
                }
                if ((n2 >>= 4) != 0) continue;
                stringBuffer.append((char)n);
                bl = false;
                continue;
            }
            if (c == '#') {
                bl = true;
                n = 0;
                n2 = 4096;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void init() {
    }

    public void paint(Graphics graphics) {
    }

    public void turn() {
    }

    public void close() {
        if (imageRating != null) {
            for (int i = 0; i < imageRating.length; ++i) {
                BaseClass.imageRating[i] = -1;
            }
        }
    }

    public static void setCommands(int n, int n2) {
        BaseClass.setCommands(n >= 0 ? BaseClass.getString(n) : null, n2 >= 0 ? BaseClass.getString(n2) : null);
    }

    public static void setCommands(String string, String string2) {
        if (string == currentLabels[0] && string2 == currentLabels[1]) {
            return;
        }
        commandsSetTick = ticksCounter;
        BaseClass.currentLabels[0] = string;
        BaseClass.currentLabels[1] = string2;
    }

    public static void saveDataNow() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)dataRecordStoreName, (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                recordStore.setRecord(recordStore.getNextRecordID() - 1, data, 0, data.length);
            } else {
                recordStore.addRecord(data, 0, data.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadData() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)dataRecordStoreName, (boolean)false);
            byte[] byArray = recordStore.getRecord(recordStore.getNextRecordID() - 1);
            System.arraycopy(byArray, 0, data, 0, Math.min(data.length, byArray.length));
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveIntToData(int n, int n2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new DataOutputStream(byteArrayOutputStream).writeInt(n);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            System.arraycopy(byArray, 0, data, n2, Math.min(byArray.length, 4));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getIntFromData(int n) {
        try {
            return new DataInputStream(new ByteArrayInputStream(data, n, 4)).readInt();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void saveNameToData(String string, int n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new DataOutputStream(byteArrayOutputStream).writeUTF(string);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            System.arraycopy(byArray, 0, data, n, Math.min(byArray.length, 26));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getNameFromData(int n) {
        try {
            return new DataInputStream(new ByteArrayInputStream(data, n, 26)).readUTF();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String[] addToArray(String[] stringArray, String string) {
        if (stringArray == null) {
            stringArray = new String[1];
        } else {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        stringArray[stringArray.length - 1] = string;
        return stringArray;
    }

    public static int[] addToArray(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            nArray = new int[nArray2.length];
        } else {
            int[] nArray3 = new int[nArray.length + nArray2.length];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            nArray = nArray3;
        }
        System.arraycopy(nArray2, 0, nArray, nArray.length - nArray2.length, nArray2.length);
        return nArray;
    }

    public static int[] addToArray(int[] nArray, int n) {
        if (nArray == null) {
            nArray = new int[1];
        } else {
            int[] nArray2 = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        nArray[nArray.length - 1] = n;
        return nArray;
    }

    public static short[] addToArray(short[] sArray, short[] sArray2) {
        if (sArray == null) {
            sArray = new short[sArray2.length];
        } else {
            short[] sArray3 = new short[sArray.length + sArray2.length];
            System.arraycopy(sArray, 0, sArray3, 0, sArray.length);
            sArray = sArray3;
        }
        System.arraycopy(sArray2, 0, sArray, sArray.length - sArray2.length, sArray2.length);
        return sArray;
    }

    public static short[] addToArray(short[] sArray, short s) {
        if (sArray == null) {
            sArray = new short[1];
        } else {
            short[] sArray2 = new short[sArray.length + 1];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            sArray = sArray2;
        }
        sArray[sArray.length - 1] = s;
        return sArray;
    }

    public static void startDebugTimer(int n) {
    }

    public static void stopDebugTimer(int n) {
    }

    public static String getString(int n) {
        if (n < 0 || str == null || n >= str.length) {
            return null;
        }
        return str[n];
    }

    public static String replaceParameter(String string, String string2, int n) {
        return BaseClass.replaceParameter(string, string2, Integer.toString(n));
    }

    public static String replaceParameter(String string, String string2, String string3) {
        while (string.indexOf(string2) >= 0) {
            int n = string.indexOf(string2);
            String string4 = n > 0 ? string.substring(0, n) : "";
            string4 = string4 + string3;
            if (n + string2.length() < string.length()) {
                string4 = string4 + string.substring(n + string2.length());
            }
            string = string4;
        }
        return string;
    }

    public static byte[] getResource(String string) {
        if (string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            InputStream inputStream = App.app.getClass().getResourceAsStream(string);
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 1;
            while (n > 0) {
                n = inputStream.read(byArray);
                if (n <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static int random(int n) {
        if (n <= 0) {
            return n;
        }
        return Math.abs(rand.nextInt()) % n;
    }

    public static void drawFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        Sprites.draw(graphics, n, n2, n3, n4);
    }

    public static void drawFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Sprites.draw(graphics, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static int getFrameHeight(int n) {
        return BaseClass.getImage(n).getHeight();
    }

    public static int getFrameWidth(int n) {
        return BaseClass.getImage(n).getWidth();
    }

    public static Image getImage(int n) {
        int n2;
        int n3 = -1;
        if (n <= 3) {
            n3 = fontColor;
        }
        if (imageArray == null) {
            imageArray = new Image[20];
            imageIDs = new int[20];
            imageRating = new int[20];
            imageOptions = new int[20];
        }
        int n4 = -1;
        for (n2 = 0; n2 < 20; ++n2) {
            if (imageIDs[n2] == n && imageArray[n2] != null && (n3 < 0 || imageOptions[n2] == n3)) {
                BaseClass.imageRating[n2] = ticksCounter;
                return imageArray[n2];
            }
            if (n4 >= 0 || imageArray[n2] != null) continue;
            n4 = n2;
        }
        if (n4 < 0) {
            for (n2 = 0; n2 < 20; ++n2) {
                if (n4 >= 0 && imageRating[n4] <= imageRating[n2]) continue;
                n4 = n2;
            }
            BaseClass.imageArray[n4] = null;
        }
        try {
            BaseClass.imageArray[n4] = BaseClass.makeImage(n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n5 = 0;
        while (n5 >= 0 && (imageArray[n4] == null || Runtime.getRuntime().freeMemory() < 20000L)) {
            n5 = -1;
            for (int i = 0; i < 20; ++i) {
                if (i == n4 || imageArray[i] == null || n5 >= 0 && imageRating[n5] <= imageRating[i]) continue;
                n5 = i;
            }
            if (n5 >= 0) {
                BaseClass.imageArray[n5] = null;
            }
            System.gc();
            Thread.yield();
            if (imageArray[n4] != null) continue;
            try {
                BaseClass.imageArray[n4] = BaseClass.makeImage(n);
            }
            catch (Throwable throwable) {}
        }
        BaseClass.imageIDs[n4] = n;
        BaseClass.imageRating[n4] = ticksCounter;
        if (n3 >= 0) {
            BaseClass.imageOptions[n4] = n3;
        }
        return imageArray[n4];
    }

    public static void freeImages() {
        if (imageArray != null) {
            for (int i = 0; i < 20; ++i) {
                BaseClass.imageArray[i] = null;
            }
        }
        System.gc();
        Thread.yield();
    }

    public static void freeImages(int n) {
        n = Sprites.getImageId(n);
        for (int i = 0; i < imageArray.length; ++i) {
            if (imageIDs[i] != n || imageArray[i] == null) continue;
            BaseClass.imageArray[i] = null;
            BaseClass.imageRating[i] = 0;
        }
    }

    public static void drawScrollBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Sprites.getHeight(1) + 2;
        if (n4 > 0) {
            BaseClass.drawFrame(graphics, 1, screenWidth - 1, n7 - 1, 40);
        }
        if (n4 + n5 < n6) {
            BaseClass.drawFrame(graphics, 0, screenWidth - 1, n7, 24);
        }
    }

    public static byte[] getResource(int n) {
        return BaseClass.getResource(Integer.toString(n));
    }

    public static Image makeImage(int n) {
        byte[] byArray = null;
        if (n >= 3 && n <= 3) {
            try {
                byArray = BaseClass.unpackPng(n);
            }
            catch (Exception exception) {}
        } else {
            byArray = BaseClass.getResource(n);
        }
        return Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static int[] getRGBfromBMP(int n) {
        byte[] byArray = BaseClass.getResource(n);
        int n2 = BaseClass.readIntBE(byArray, 10, 4);
        int n3 = BaseClass.readIntBE(byArray, 18, 4);
        int n4 = BaseClass.readIntBE(byArray, 22, 4);
        int n5 = BaseClass.readIntBE(byArray, 28, 2);
        int n6 = BaseClass.readIntBE(byArray, 34, 4);
        int n7 = BaseClass.readIntBE(byArray, 46, 4);
        if (n7 == 0) {
            n7 = (n2 - 14 - 40) / 4;
        }
        int[] nArray = new int[n7];
        if (n5 <= 8) {
            for (int i = 0; i < n7; ++i) {
                nArray[i] = BaseClass.readIntBE(byArray, 54 + i * 4, 4);
            }
        }
        int[] nArray2 = new int[n3 * n4 + 2];
        int n8 = n6 / n4;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n9 = 0;
                if (n5 == 24) {
                    n9 = BaseClass.readIntBE(byArray, n2 + (n4 - 1 - i) * n8 + j * n5 / 8, n5 / 8);
                } else if (n5 == 8) {
                    n9 = nArray[byArray[n2 + (n4 - 1 - i) * n8 + j] & 0xFF];
                } else if (n5 == 4) {
                    n9 = nArray[(byArray[n2 + (n4 - 1 - i) * n8 + j * n5 / 8] & 15 << n5 * (1 - j % 2)) >> n5 * (1 - j % 2)];
                }
                n9 = n9 == 0xFF00FF ? 0 : (n9 |= 0xFF000000);
                nArray2[i * n3 + j] = n9;
            }
        }
        bmpLastWidth = n3;
        bmpLastHeight = n4;
        return nArray2;
    }

    public static int readIntBE(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += (byArray[n + i] & 0xFF) << 8 * i;
        }
        return n3;
    }

    private static void initFonts() {
        charWidths = new int[1][];
        charOffsetsX = new int[1][];
        charOffsetsY = new int[1][];
        fontsFirstChar = new int[1];
        fontsLastChar = new int[1];
        fontHeights = new int[1];
        for (int i = 0; i < 1; ++i) {
            Image image = BaseClass.getImage(3 + i);
            int n = image != null ? image.getWidth() : 10000;
            BaseClass.charWidths[i] = new int[256];
            BaseClass.charOffsetsX[i] = new int[256];
            BaseClass.charOffsetsY[i] = new int[256];
            byte[] byArray = BaseClass.getResource(2 + i);
            BaseClass.fontsFirstChar[i] = byArray[0] & 0xFF;
            BaseClass.fontsLastChar[i] = byArray[1] & 0xFF;
            BaseClass.fontHeights[i] = byArray[2] & 0xFF;
            int n2 = 0;
            int n3 = 0;
            for (int j = fontsFirstChar[i]; j <= fontsLastChar[i]; ++j) {
                BaseClass.charWidths[i][j] = byArray[3 + j - fontsFirstChar[i]];
                if (n2 + charWidths[i][j] > n) {
                    n2 = 0;
                    n3 += fontHeights[i];
                }
                BaseClass.charOffsetsX[i][j] = n2;
                BaseClass.charOffsetsY[i][j] = n3;
                n2 += charWidths[i][j];
            }
        }
    }

    public static int drawText(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        int n6 = BaseClass.getFontHeight(n5);
        String[] stringArray = Interface.getStringArray(string, n4, n5);
        for (int i = 0; i < stringArray.length; ++i) {
            BaseClass.drawString(graphics, stringArray[i], n, n2, n3, n5);
            n2 += n6;
        }
        return n6 * (stringArray.length - 1);
    }

    public static void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        if (n4 >= 1) {
            n4 = 0;
        }
        fontColor = graphics.getColor();
        if ((n3 & 1) != 0) {
            n -= BaseClass.stringWidth(string, n4) / 2;
        } else if ((n3 & 8) != 0) {
            n -= BaseClass.stringWidth(string, n4);
        }
        if ((n3 & 2) != 0) {
            n2 -= fontHeights[n4] / 2;
        } else if ((n3 & 0x20) != 0) {
            n2 -= fontHeights[n4];
        }
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        Image image = BaseClass.getImage(3 + n4);
        for (int i = 0; i < string.length() && n < screenWidth; ++i) {
            int n9;
            int n10 = BaseClass.getCharNumber(string.charAt(i), n4);
            if (n10 < 0 || (n9 = charWidths[n4][n10]) == 0) continue;
            graphics.setClip(n, n2, n9, fontHeights[n4]);
            graphics.clipRect(n5, n6, n7, n8);
            graphics.drawImage(image, n - charOffsetsX[n4][n10], n2 - charOffsetsY[n4][n10], 20);
            n += n9 + spaceBetweenChars[n4];
        }
        graphics.setClip(n5, n6, n7, n8);
    }

    public static int stringWidth(String string, int n) {
        if (n >= 1) {
            n = 0;
        }
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            n2 += BaseClass.charWidth(string.charAt(i), n);
        }
        return n2 + spaceBetweenChars[n] * (string.length() - 1);
    }

    public static void drawString2(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        if (n4 >= 1) {
            n4 = 0;
        }
        fontColor = graphics.getColor();
        if ((n3 & 1) != 0) {
            n -= BaseClass.stringWidth(string, n4) / 2;
        } else if ((n3 & 8) != 0) {
            n -= BaseClass.stringWidth(string, n4);
        }
        if ((n3 & 2) != 0) {
            n2 -= fontHeights[n4] / 2;
        } else if ((n3 & 0x20) != 0) {
            n2 -= fontHeights[n4];
        }
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        Image image = BaseClass.getImage(3 + n4);
        int n9 = 0;
        for (int i = 0; i < string.length() && n < screenWidth; ++i) {
            int n10;
            n9 = BaseClass.random(2);
            int n11 = BaseClass.getCharNumber(string.charAt(i), n4);
            if (n11 < 0 || (n10 = charWidths[n4][n11]) == 0) continue;
            graphics.setClip(n, n2 + n9, n10, fontHeights[n4]);
            graphics.clipRect(n5, n6 + n9, n7, n8);
            graphics.drawImage(image, n - charOffsetsX[n4][n11], n2 + n9 - charOffsetsY[n4][n11], 20);
            n += n10 + spaceBetweenChars[n4];
        }
        graphics.setClip(n5, n6, n7, n8);
    }

    public static String getCutString(String string, int n, int n2) {
        if (string == null) {
            return string;
        }
        if (n2 >= 1) {
            n2 = 0;
        }
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if ((n3 += BaseClass.charWidth(string.charAt(i), n2) + spaceBetweenChars[n2]) < n) continue;
            return string.substring(0, i - 1);
        }
        return string;
    }

    public static int charWidth(char c, int n) {
        int n2;
        if (n >= 1) {
            n = 0;
        }
        if ((n2 = BaseClass.getCharNumber(c, n)) < 0) {
            return 0;
        }
        return charWidths[n][n2];
    }

    public static int getCharNumber(int n, int n2) {
        if (n2 >= 1) {
            n2 = 0;
        }
        if (n >= 192 && n < 255) {
            n = n - 192 + 1040;
        }
        if (n == 1105) {
            n = 1077;
        }
        if (n == 1025) {
            n = 1045;
        }
        if (n >= 1040) {
            n = n - 1040 + 128 + 64;
        }
        if (n < charWidths[n2].length) {
            return n;
        }
        return -1;
    }

    public static int getFontHeight(int n) {
        if (fontHeights != null && n >= 0 && n < fontHeights.length) {
            return fontHeights[n];
        }
        return 0;
    }

    public static void drawScoreLine(Graphics graphics, int n, int n2, String string, String string2, String string3, int n3, boolean bl) {
        String string4 = "...";
        String string5 = " " + string3;
        if (bl) {
            BaseClass.drawString2(graphics, string5, (screenWidth - n2) / 2 + n2, n, 24, n3);
        } else {
            BaseClass.drawString(graphics, string5, (screenWidth - n2) / 2 + n2, n, 24, n3);
        }
        int n4 = BaseClass.stringWidth(string5, n3);
        String string6 = string + "." + string2;
        int n5 = BaseClass.stringWidth(string6, n3);
        if (n5 + n4 > n2) {
            string6 = BaseClass.getCutString(string6, n2 - n4 - BaseClass.stringWidth(string4, n3), n3) + string4;
        }
        if (bl) {
            BaseClass.drawString2(graphics, string6, (screenWidth - n2) / 2, n, 20, n3);
        } else {
            BaseClass.drawString(graphics, string6, (screenWidth - n2) / 2, n, 20, n3);
        }
    }

    public static void fillTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Math.min(n, Math.min(n3, n5));
        int n8 = Math.max(n, Math.max(n3, n5));
        int n9 = Math.min(n2, Math.min(n4, n6));
        int n10 = Math.max(n2, Math.max(n4, n6));
        int[] nArray = new int[]{n, n3, n5};
        int[] nArray2 = new int[]{n2, n4, n6};
        if (n8 - n7 < n10 - n9) {
            for (int i = n7; i <= n8; ++i) {
                n2 = n10;
                n4 = n9;
                for (int j = 0; j < 3; ++j) {
                    int n11;
                    int n12 = n11 = j < 2 ? j + 1 : 0;
                    if ((nArray[j] > i || nArray[n11] < i) && (nArray[j] < i || nArray[n11] > i)) continue;
                    if (nArray[j] == nArray[n11]) {
                        n2 = Math.min(n2, Math.min(nArray2[j], nArray2[n11]));
                        n4 = Math.max(n4, Math.max(nArray2[j], nArray2[n11]));
                        continue;
                    }
                    int n13 = (nArray2[j] * (i - nArray[n11]) + nArray2[n11] * (nArray[j] - i)) / (nArray[j] - nArray[n11]);
                    n2 = Math.min(n13, n2);
                    n4 = Math.max(n13, n4);
                }
                graphics.fillRect(i, n2, 1, n4 - n2 + 1);
            }
        } else {
            for (int i = n9; i <= n10; ++i) {
                n = n8;
                n3 = n7;
                for (int j = 0; j < 3; ++j) {
                    int n14;
                    int n15 = n14 = j < 2 ? j + 1 : 0;
                    if ((nArray2[j] > i || nArray2[n14] < i) && (nArray2[j] < i || nArray2[n14] > i)) continue;
                    if (nArray2[j] == nArray2[n14]) {
                        n = Math.min(n, Math.min(nArray[j], nArray[n14]));
                        n3 = Math.max(n3, Math.max(nArray[j], nArray[n14]));
                        continue;
                    }
                    int n16 = (nArray[j] * (i - nArray2[n14]) + nArray[n14] * (nArray2[j] - i)) / (nArray2[j] - nArray2[n14]);
                    n = Math.min(n16, n);
                    n3 = Math.max(n16, n3);
                }
                graphics.fillRect(n, i, n3 - n + 1, 1);
            }
        }
    }

    public static int getMax(int[][] nArray, int n) {
        int n2 = nArray[0][n];
        for (int i = 1; i < nArray.length; ++i) {
            if (n2 >= nArray[i][n]) continue;
            n2 = nArray[i][n];
        }
        return n2;
    }

    public static int getMin(int[][] nArray, int n) {
        int n2 = nArray[0][n];
        for (int i = 1; i < nArray.length; ++i) {
            if (n2 <= nArray[i][n]) continue;
            n2 = nArray[i][n];
        }
        return n2;
    }

    public static void fill_N_angle(Graphics graphics, int n, int n2, int[][] nArray, int n3, int n4) {
        int n5 = BaseClass.getMin(nArray, 0);
        int n6 = BaseClass.getMax(nArray, 0);
        int n7 = BaseClass.getMin(nArray, 1);
        int n8 = BaseClass.getMax(nArray, 1);
        if (n6 - n5 < n8 - n7) {
            for (int i = n5; i <= n6; ++i) {
                int n9 = n8;
                int n10 = n7;
                for (int j = 0; j < nArray.length; ++j) {
                    int n11;
                    int n12 = n11 = j < nArray.length - 1 ? j + 1 : 0;
                    if ((nArray[j][0] > i || nArray[n11][0] < i) && (nArray[j][0] < i || nArray[n11][0] > i)) continue;
                    if (nArray[j][0] == nArray[n11][0]) {
                        n9 = Math.min(n9, Math.min(nArray[j][1], nArray[n11][1]));
                        n10 = Math.max(n10, Math.max(nArray[j][1], nArray[n11][1]));
                        continue;
                    }
                    int n13 = (nArray[j][1] * (i - nArray[n11][0]) + nArray[n11][1] * (nArray[j][0] - i) + (nArray[j][0] - nArray[n11][0]) / 2) / (nArray[j][0] - nArray[n11][0]);
                    n9 = Math.min(n13, n9);
                    n10 = Math.max(n13, n10);
                }
                graphics.setColor(n3);
                graphics.fillRect(i + n, n9 + n2, 1, n10 - n9 + 1);
            }
        } else {
            for (int i = n7; i <= n8; ++i) {
                int n14 = n6;
                int n15 = n5;
                for (int j = 0; j < nArray.length; ++j) {
                    int n16;
                    int n17 = n16 = j < nArray.length - 1 ? j + 1 : 0;
                    if ((nArray[j][1] > i || nArray[n16][1] < i) && (nArray[j][1] < i || nArray[n16][1] > i)) continue;
                    if (nArray[j][1] == nArray[n16][1]) {
                        n14 = Math.min(n14, Math.min(nArray[j][0], nArray[n16][0]));
                        n15 = Math.max(n15, Math.max(nArray[j][0], nArray[n16][0]));
                        continue;
                    }
                    int n18 = (nArray[j][0] * (i - nArray[n16][1]) + nArray[n16][0] * (nArray[j][1] - i) + (nArray[j][1] - nArray[n16][1]) / 2) / (nArray[j][1] - nArray[n16][1]);
                    n14 = Math.min(n18, n14);
                    n15 = Math.max(n18, n15);
                }
                graphics.setColor(n3);
                graphics.fillRect(n14 + n, i + n2, n15 - n14 + 1, 1);
            }
        }
    }

    static byte[] createImageData(int n, int n2, int n3, byte[] byArray, int n4, int n5, byte[] byArray2, int n6, int[] nArray, int n7, int n8) throws IOException {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = 0;
        if (n5 == -1) {
            n5 = byArray.length - n4;
        }
        for (int i = 0; i != nArray.length; i += 2) {
            n13 += nArray[i + 1];
        }
        byte[] byArray3 = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        BaseClass.crc_getValue();
        dataOutputStream.write(PNG_HEADER);
        dataOutputStream.writeInt(13);
        dataOutputStream.write(IHDR);
        BaseClass.crc_update(IHDR);
        dataOutputStream.writeInt(n);
        BaseClass.crc_updateInt(n);
        dataOutputStream.writeInt(n2);
        BaseClass.crc_updateInt(n2);
        dataOutputStream.writeByte(n3);
        BaseClass.crc_updateByte(n3);
        dataOutputStream.writeByte(3);
        BaseClass.crc_updateByte(3);
        dataOutputStream.writeByte(0);
        BaseClass.crc_updateByte(0);
        dataOutputStream.writeByte(0);
        BaseClass.crc_updateByte(0);
        dataOutputStream.writeByte(0);
        BaseClass.crc_updateByte(0);
        dataOutputStream.writeInt(BaseClass.crc_getValue());
        dataOutputStream.writeInt(n13 * 3);
        dataOutputStream.write(PLTE);
        BaseClass.crc_update(PLTE);
        for (n12 = 0; n12 != nArray.length; n12 += 2) {
            for (n11 = nArray[n12]; n11 != nArray[n12] + nArray[n12 + 1]; ++n11) {
                n10 = 0xFF00 & byArray2[n6 + 2 * n11] << 8 | 0xFF & byArray2[n6 + 2 * n11 + 1];
                n9 = 0xF & n10 >> 8;
                int n14 = 0xF & n10 >> 4;
                int n15 = 0xF & n10;
                n9 |= n9 << 4;
                n14 |= n14 << 4;
                n15 |= n15 << 4;
                dataOutputStream.writeByte((byte)n9);
                BaseClass.crc_updateByte((byte)n9);
                dataOutputStream.writeByte((byte)n14);
                BaseClass.crc_updateByte((byte)n14);
                dataOutputStream.writeByte((byte)n15);
                BaseClass.crc_updateByte((byte)n15);
            }
        }
        dataOutputStream.writeInt(BaseClass.crc_getValue());
        if (n7 >= 0 && n8 == 255) {
            dataOutputStream.writeInt(1);
            dataOutputStream.write(tRNS);
            BaseClass.crc_update(tRNS);
            dataOutputStream.writeByte(n7);
            BaseClass.crc_updateByte(n7);
            dataOutputStream.writeInt(BaseClass.crc_getValue());
        } else if (n7 >= 0 && n8 != 255) {
            dataOutputStream.writeInt(n13);
            dataOutputStream.write(tRNS);
            BaseClass.crc_update(tRNS);
            for (n12 = 0; n12 != n13; ++n12) {
                if (n12 != n7) {
                    dataOutputStream.write(n8);
                    BaseClass.crc_updateByte(n8);
                    continue;
                }
                dataOutputStream.write(0);
                BaseClass.crc_updateByte(0);
            }
            dataOutputStream.writeInt(BaseClass.crc_getValue());
        } else if (n7 == -2) {
            dataOutputStream.writeInt(n13);
            dataOutputStream.write(tRNS);
            BaseClass.crc_update(tRNS);
            for (n12 = 0; n12 != nArray.length; n12 += 2) {
                for (n11 = nArray[n12]; n11 != nArray[n12] + nArray[n12 + 1]; ++n11) {
                    n10 = 0xFF00 & byArray2[n6 + 2 * n11] << 8 | 0xFF & byArray2[n6 + 2 * n11 + 1];
                    n9 = 0xF & n10 >> 12;
                    n9 |= n9 << 4;
                    dataOutputStream.writeByte((byte)n9);
                    BaseClass.crc_updateByte((byte)n9);
                }
            }
            dataOutputStream.writeInt(BaseClass.crc_getValue());
        }
        dataOutputStream.writeInt(n5);
        dataOutputStream.write(IDAT);
        BaseClass.crc_update(IDAT);
        dataOutputStream.write(byArray, n4, n5);
        BaseClass.crc_update(byArray, n4, n5);
        dataOutputStream.writeInt(BaseClass.crc_getValue());
        dataOutputStream.writeInt(0);
        dataOutputStream.write(IEND);
        BaseClass.crc_update(IEND);
        dataOutputStream.writeInt(BaseClass.crc_getValue());
        dataOutputStream.close();
        byArray3 = byteArrayOutputStream.toByteArray();
        return byArray3;
    }

    private static byte[] getFontData(int n) {
        byte[] byArray = BaseClass.getResource(n);
        int n2 = 0xFF & byArray[3];
        for (int i = 0; i < n2; ++i) {
            if (byArray[4 + 2 * i] == -16 && byArray[4 + 2 * i + 1] != 0) continue;
        }
        return byArray;
    }

    static byte[] unpackPng(int n) throws IOException {
        int n2;
        byte[] byArray = n >= 3 && n <= 3 ? BaseClass.getFontData(n) : BaseClass.getResource(n);
        for (n2 = 0; n2 < byArray.length && n2 < PNG_HEADER.length && byArray[n2] == PNG_HEADER[n2]; ++n2) {
        }
        if (n2 >= PNG_HEADER.length) {
            return byArray;
        }
        byte by = byArray[0];
        int n3 = 0xFF & byArray[3];
        int n4 = 0xFF & byArray[1];
        int n5 = 0xFF & byArray[2];
        if (byArray.length > 4 + n3 * 2 + n4 * n5 + 10) {
            n4 += 256;
        }
        System.out.println("Unpack " + n + ": " + n4 + "x" + n5 + "x" + n3 + "  :" + by);
        return BaseClass.createImageData(n4, n5, by, byArray, 4 + n3 * 2, -1, byArray, 4, new int[]{0, n3}, -2, 255);
    }

    static int crc_getValue() {
        int n = ~crc_crc;
        crc_crc = -1;
        return n;
    }

    static void crc_updateByte(int n) {
        crc_crc = crc_table[(crc_crc ^ (byte)n) & 0xFF] ^ crc_crc >> 8 & 0xFFFFFF;
    }

    static void crc_update(byte[] byArray) {
        BaseClass.crc_update(byArray, 0, byArray.length);
    }

    static void crc_update(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            BaseClass.crc_updateByte(byArray[i + n]);
        }
    }

    static void crc_updateInt(int n) {
        BaseClass.crc_updateByte((byte)(n >> 24));
        BaseClass.crc_updateByte((byte)(n >> 16));
        BaseClass.crc_updateByte((byte)(n >> 8));
        BaseClass.crc_updateByte((byte)n);
    }

    public static void loadSounds() {
        soundsData = new byte[3][];
        for (int i = 0; i < 3; ++i) {
            BaseClass.soundsData[i] = BaseClass.getResource(4 + i);
        }
    }

    private static Object loadSound(byte[] byArray, int n) throws Throwable {
        return Manager.createPlayer((InputStream)new ByteArrayInputStream(byArray), (String)(n == 1 ? "audio/midi" : "audio/x-wav"));
    }

    private static Object loadSound(InputStream inputStream, int n) throws Throwable {
        return Manager.createPlayer((InputStream)inputStream, (String)(n == 1 ? "audio/midi" : "audio/x-wav"));
    }

    public static void playSound(int n) {
        BaseClass.playSound(n - 4, false);
    }

    public static void playSound(int n, boolean bl) {
        if (data[1] == 0) {
            BaseClass.playSoundNow(n, bl);
        }
    }

    public static void playSoundNow(int n, boolean bl) {
        byte[] byArray = null;
        byArray = soundsData[n];
        if (byArray == null) {
            return;
        }
        try {
            BaseClass.stopSounds();
            try {
                sound = BaseClass.loadSound(byArray, 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (sound == null) {
                return;
            }
            if (bl) {
                try {
                    ((Player)sound).setLoopCount(-1);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ((Player)sound).start();
            soundPlaying = n;
        }
        catch (Throwable throwable) {
            soundPlaying = -1;
        }
    }

    public static void prefetchSound(int n) {
    }

    public static void stopSounds() {
        BaseClass.stopSound(soundPlaying);
    }

    public static void stopSound(int n) {
        if (n == soundPlaying && sound != null && soundPlaying >= 0) {
            try {
                try {
                    ((Player)sound).stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    ((Player)sound).deallocate();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    ((Player)sound).close();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sound = null;
            soundPlaying = -1;
        }
    }

    public static void startVibration() {
    }

    public static void stopVibration() {
    }

    public static boolean isDemo() {
        return false;
    }

    public static void setFullVersion() {
        BaseClass.data[3] = FULL_VERSION;
        BaseClass.saveDataNow();
    }

    public static int sin(int n) {
        int n2 = 1;
        if (n < 0) {
            n = -n;
            n2 = -1;
        }
        if ((n %= 1608) > 804) {
            n = 1608 - n;
            n2 *= -1;
        }
        if (n > 402) {
            n = 804 - n;
        }
        if (sinusTable == null) {
            sinusTable = new int[403];
        }
        if (n == 0 || sinusTable[n] > 0) {
            return n2 * sinusTable[n];
        }
        int n3 = n;
        int n4 = 1;
        int n5 = n;
        if (n > 201) {
            n3 = 256;
            n4 = 0;
            n = 402 - n;
        }
        int n6 = n3;
        while (n3 != 0 && n4 < 15) {
            n3 = -n3 * n * n / (n4 += 2) / (n4 - 1) >> 16;
            n6 += n3;
        }
        BaseClass.sinusTable[n5] = n6;
        return n2 * n6;
    }

    public static int cos(int n) {
        return BaseClass.sin(402 - n);
    }

    public static int sqrt(int n) {
        if (n <= 0) {
            return 0;
        }
        int n2 = 1;
        for (int i = 1; i < n && i > 0; i <<= 2) {
            n2 <<= 1;
        }
        int n3 = 1;
        while (n3 != 0) {
            n3 = (n / n2 - n2) / 2;
            n2 += n3;
        }
        if (n == n2 * (n2 - 1)) {
            --n2;
        }
        return n2;
    }

    public static long sqrt(long l) {
        long l2 = 1L;
        for (long i = 1L; i < l; i <<= 2) {
            l2 <<= 1;
        }
        long l3 = 1L;
        while (l3 != 0L) {
            l3 = (l / l2 - l2) / 2L;
            l2 += l3;
        }
        if (l == l2 * (l2 - 1L)) {
            --l2;
        }
        return l2;
    }

    public static int arcTan(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 1;
        if (n2 < 0) {
            n5 = -1;
            n2 = -n2;
        }
        if (n < 0) {
            n4 = 804;
            n5 *= -1;
            n = -n;
        }
        if (n2 > n) {
            n4 += n5 * 804 / 2;
            n5 *= -1;
            n3 = n2;
            n2 = n;
            n = n3;
        }
        if (n == 0) {
            return 0;
        }
        n3 = 1;
        int n6 = 0;
        int n7 = 1;
        for (int i = 128; i != 0 && n7 != 0; i >>= 1) {
            n7 = n * BaseClass.sin(n6) - n2 * BaseClass.cos(n6);
            if (n7 > 0) {
                n6 -= i;
            }
            if (n7 >= 0) continue;
            n6 += i;
        }
        return n4 + n5 * n6;
    }

    static {
        int n;
        debug = "";
        defaultFont = null;
        screenWidth = 176;
        fullScreenHeight = 0;
        rand = new Random();
        currentLabels = new String[2];
        hasInteraction = true;
        hasSendToFriend = true;
        hasMoreGameRu = false;
        storeName = "UGirls_res";
        needDownloadRes = false;
        spaceBetweenChars = new int[]{0, 0};
        specialChars = new short[0];
        PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        IHDR = new byte[]{73, 72, 68, 82};
        PLTE = new byte[]{80, 76, 84, 69};
        IDAT = new byte[]{73, 68, 65, 84};
        IEND = new byte[]{73, 69, 78, 68};
        tRNS = new byte[]{116, 82, 78, 83};
        crc_crc = -1;
        crc_table = new int[256];
        byte[] byArray = new byte[]{0, 1, 2, 4, 5, 7, 8, 10, 11, 12, 16, 22, 23, 26};
        int n2 = 0;
        for (n = 0; n < 14; ++n) {
            n2 |= 1 << 31 - byArray[n];
        }
        for (n = 0; n < 256; ++n) {
            int n3 = n;
            for (int i = 0; i < 8; ++i) {
                int n4 = n3 >> 1 & Integer.MAX_VALUE;
                n3 = (n3 & 1) != 0 ? n2 ^ n4 : n4;
            }
            BaseClass.crc_table[n] = n3;
        }
        soundPlaying = -1;
        duration = new int[]{0, 0, 0, 6, 33, 29, 39};
        startSound = -1;
        runnerStarted = false;
        FULL_VERSION = (byte)69;
    }

    public static class Listener
    implements PlayerListener {
        public void playerUpdate(Player player, String string, Object object) {
            if (string == "endOfMedia" && startSound < 0 && loop) {
                BaseClass.playSound(soundPlaying);
            }
        }
    }

    public static class Runner
    implements Runnable {
        public void run() {
            while (!App.exiting) {
                if (!App.paused && startSound >= 0) {
                    BaseClass.playSoundNow(startSound, loop);
                }
                startSound = -1;
                Thread.yield();
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

