/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.midlet.MIDlet;

public class Battleship
extends MIDlet
implements CommandListener {
    Display display;
    private BattleCanvas canvas;
    private Score score;
    private Screen scoreScreen;
    private Alert alert;
    private Command restartCommand = new Command("Start Over", 3, 21);
    private Command exitCommand = new Command("Exit", 7, 60);
    private Command scoresCommand = new Command("Show Scores", 1, 25);
    private Command okCommand = new Command("OK", 4, 30);
    private Command meCommand = new Command("Show Me", 4, 24);
    private Command enemyCommand = new Command("Show Enemy", 1, 22);
    private Command aboutCommand = new Command("About", 5, 30);

    public Battleship() {
        this.display = Display.getDisplay((MIDlet)this);
        this.score = new Score();
        this.canvas = new BattleCanvas(this, this.score);
        this.alert = new Alert("Warning");
    }

    public void startApp() {
        if (!this.score.open()) {
            System.out.println("Score open failed");
        }
        this.canvas.init();
        this.canvas.addCommand(this.scoresCommand);
        this.canvas.addCommand(this.restartCommand);
        this.canvas.addCommand(this.exitCommand);
        this.canvas.addCommand(this.meCommand);
        this.canvas.addCommand(this.enemyCommand);
        this.canvas.addCommand(this.aboutCommand);
        this.canvas.setCommandListener(this);
        this.display.setCurrent((Displayable)this.canvas);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        this.display.setCurrent(null);
        this.canvas.destroy();
        if (this.score != null) {
            this.score.close();
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.restartCommand) {
            this.canvas.restart();
        } else if (c == this.scoresCommand) {
            this.scoreScreen = this.canvas.getScoreScreen();
            this.scoreScreen.addCommand(this.okCommand);
            this.scoreScreen.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.scoreScreen);
        } else if (c == this.okCommand && s == this.scoreScreen) {
            this.display.setCurrent((Displayable)this.canvas);
        } else if (c == this.exitCommand) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (c == List.SELECT_COMMAND && s == this.canvas) {
            this.scoreScreen = this.canvas.getScoreScreen();
            this.scoreScreen.addCommand(this.okCommand);
            this.scoreScreen.setCommandListener((CommandListener)this);
            this.display.setCurrent((Displayable)this.scoreScreen);
        } else if (c != this.aboutCommand) {
            System.out.println("Unknown command issued " + c);
        }
    }
}

