/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SSMusic {
    public static final int NO_SOUND = -1;
    public static final int SOUND_MIDI = 0;
    public static final int SOUND_AMR = 1;
    public static final int SOUND_MP3 = 2;
    private static final int MAX_ELEMENTS = 16;
    private Player[] midis = new Player[16];
    private byte[] soundType = new byte[16];
    private int lastSoundIndex = 0;
    private int actualSound = -1;

    public int loadSound(byte[] soundData, int type) {
        ByteArrayInputStream is = new ByteArrayInputStream(soundData);
        if (is == null) {
            return -1;
        }
        try {
            ++this.lastSoundIndex;
            switch (type) {
                case 0: {
                    Player p = Manager.createPlayer((InputStream)is, (String)"audio/midi");
                    p.prefetch();
                    this.midis[this.lastSoundIndex] = p;
                    this.soundType[this.lastSoundIndex] = 0;
                    break;
                }
                case 2: {
                    Player p = Manager.createPlayer((InputStream)is, (String)"audio/mp3");
                    p.prefetch();
                    this.midis[this.lastSoundIndex] = p;
                    this.soundType[this.lastSoundIndex] = 2;
                    break;
                }
                case 1: {
                    Player p = Manager.createPlayer((InputStream)is, (String)"audio/amr");
                    p.prefetch();
                    this.midis[this.lastSoundIndex] = p;
                    this.soundType[this.lastSoundIndex] = 1;
                }
            }
            return this.lastSoundIndex;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public void playSound(int soundIndex) {
        if (soundIndex <= this.lastSoundIndex) {
            this.stopSound(this.actualSound);
            try {
                switch (this.soundType[soundIndex]) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.midis[soundIndex].start();
                        this.actualSound = soundIndex;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setVolume(int soundIndex, int percent) {
        try {
            VolumeControl vc = (VolumeControl)this.midis[soundIndex].getControl("VolumeControl");
            if (vc != null) {
                vc.setLevel(percent);
            }
        }
        catch (Exception _ex) {
            // empty catch block
        }
    }

    public void stopSound(int soundIndex) {
        if (soundIndex <= this.lastSoundIndex && this.actualSound != -1) {
            try {
                switch (this.soundType[soundIndex]) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.midis[soundIndex].stop();
                        this.midis[soundIndex].deallocate();
                        this.actualSound = -1;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isSound(int soundIndex) {
        try {
            return this.midis[soundIndex].getState() == 400;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void unloadSound(int soundIndex) {
        if (soundIndex <= this.lastSoundIndex) {
            try {
                switch (this.soundType[soundIndex]) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.midis[soundIndex].close();
                        this.midis[soundIndex] = null;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

