/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.utils;

public class SSKeyboard {
    public static final char LEFT_BUTTON = '\u0000';
    public static final char RIGHT_BUTTON = '\u0001';
    public static final char FIRE_BUTTON = '\u0002';
    public static final char LEFT_ARROW = '\u0003';
    public static final char RIGHT_ARROW = '\u0004';
    public static final char UP_ARROW = '\u0005';
    public static final char DOWN_ARROW = '\u0006';
    public static final char NO_KEY = '\uffff';
    public static final byte KEY_PRESSED = 0;
    public static final byte KEY_RELEASED = 1;
    private static final String NUMBERS_CHARS = "0123456789*#";
    private static final int BUFFER_SIZE = 50;
    private byte[] evtType = new byte[50];
    private char[] evtKeys = new char[50];
    private int posRead = 0;
    private int posWrite = 0;
    private int lastEvent;
    private char lastKey;
    private boolean hasMoreKeys = false;
    private static final int LEFT_BUTTON_CODE = -21;
    private static final int RIGHT_BUTTON_CODE = -22;
    private static final int FIRE_BUTTON_CODE = -20;
    private static final int LEFT_ARROW_CODE = -2;
    private static final int RIGHT_ARROW_CODE = -5;
    private static final int UP_ARROW_CODE = -1;
    private static final int DOWN_ARROW_CODE = -6;

    public boolean getHasMoreKeys() {
        return this.hasMoreKeys;
    }

    public int getLastEvent() {
        return this.lastEvent;
    }

    public char nextChar() {
        if (!this.hasMoreKeys) {
            return '\uffff';
        }
        this.lastEvent = this.evtType[this.posRead];
        this.lastKey = this.evtKeys[this.posRead];
        ++this.posRead;
        if (this.posRead == 50) {
            this.posRead = 0;
        }
        this.hasMoreKeys = this.posRead != this.posWrite;
        return this.lastKey;
    }

    public void removeAllEvents() {
        this.posRead = this.posWrite;
        this.hasMoreKeys = false;
    }

    private void addKey(byte type, char key) {
        this.evtKeys[this.posWrite] = key;
        this.evtType[this.posWrite] = type;
        ++this.posWrite;
        if (this.posWrite == 50) {
            this.posWrite = 0;
        }
        this.hasMoreKeys = true;
    }

    public synchronized void keyPressed(int keyCode) {
        int number = this.getNumericKeyForKeycode(keyCode);
        if (number != -1) {
            this.addKey((byte)0, NUMBERS_CHARS.charAt(number));
        } else {
            char action = this.getActionByKeyCode(keyCode);
            if (action != '\uffff') {
                this.addKey((byte)0, action);
            }
        }
    }

    public synchronized void keyReleased(int keyCode) {
        int number = this.getNumericKeyForKeycode(keyCode);
        if (number != -1) {
            this.addKey((byte)1, NUMBERS_CHARS.charAt(number));
        } else {
            char action = this.getActionByKeyCode(keyCode);
            if (action != '\uffff') {
                this.addKey((byte)1, action);
            }
        }
    }

    private int getNumericKeyForKeycode(int keyCode) {
        switch (keyCode) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 42: {
                return 10;
            }
            case 35: {
                return 11;
            }
        }
        return -1;
    }

    private char getActionByKeyCode(int keyCode) {
        switch (keyCode) {
            case -21: {
                return '\u0000';
            }
            case -22: {
                return '\u0001';
            }
            case -20: {
                return '\u0002';
            }
            case -2: {
                return '\u0003';
            }
            case -5: {
                return '\u0004';
            }
            case -1: {
                return '\u0005';
            }
            case -6: {
                return '\u0006';
            }
        }
        return '\uffff';
    }
}

