/*
 * Decompiled with CFR 0.152.
 */
package Rayman3SET610;

import Rayman3SET610.Anim;
import Rayman3SET610.AnimData;
import Rayman3SET610.Game;
import Rayman3SET610.GameMidlet;
import javax.microedition.lcdui.Graphics;

public class Actor {
    static AnimData[] aniData = new AnimData[28];
    Actor actorReference;
    Anim anim = new Anim();
    byte objType;
    byte[] colBox = new byte[4];
    int[] V;
    int[] m_iInitV;
    long x;
    long y;
    short dx;
    short dy;
    short mmodel_type;
    short mmodel_vX;
    short mmodel_vY;
    short mmodel_aX;
    short mmodel_aY;
    short mmodel_fX;
    short mmodel_fY;
    short stateFlag;
    long m_lInitX;
    long m_lInitY;
    int m_iInitAction;
    short m_sInitStateFlag;
    byte[][] m_bPHBTable;
    short m_sPHBTableReferenceTileX;
    short m_sPHBTableReferenceTileY;
    short m_sTableRefIndexX;
    short m_sTableRefIndexY;
    boolean xDirectionConfirmed;
    int xDirectionConfirmationCounter;
    int yDirectionConfirmed;
    int yDirectionConfirmationCounter;

    public Actor(byte[] byArray) {
        this.Actor_ctor(byArray);
        int n = 6;
        switch (this.objType) {
            case 0: {
                this.V = new int[17];
                this.V[1] = 0;
                this.V[12] = 0;
                this.V[0] = this.V[0] | 2;
                this.actorReference = null;
                this.m_bPHBTable = new byte[6][5];
                this.m_sPHBTableReferenceTileX = (short)-20;
                this.m_sPHBTableReferenceTileY = (short)-20;
                this.m_sTableRefIndexX = (short)2;
                this.m_sTableRefIndexY = (short)4;
                this.xDirectionConfirmed = true;
                break;
            }
            case 1: {
                this.stateFlag = (short)(this.stateFlag | 8);
                this.anim.newAction = 0;
                this.actorReference = null;
                break;
            }
            case 12: {
                this.V = new int[1];
                this.V[0] = 2;
                if (byArray[n++] == 0) break;
                this.anim.newAction = 5;
                break;
            }
            case 22: {
                this.V = new int[6];
                this.V[0] = byArray[n++] & 0xFF;
                this.V[1] = byArray[n++] & 0xFF;
                this.V[2] = byArray[n++] & 0xFF;
                this.V[2] = this.V[2] << 16;
                this.V[2] = this.V[2] | byArray[n++] & 0xFF;
                this.V[2] = this.V[2] | this.V[2] << 8;
                this.V[5] = byArray[n++] & 0xFF;
                this.V[3] = 240;
                this.V[4] = 0;
                break;
            }
            case 25: {
                this.stateFlag = (short)(this.stateFlag | 8);
                break;
            }
            case 10: 
            case 11: {
                this.V = new int[2];
                this.V[0] = byArray[n++];
                this.m_bPHBTable = new byte[1][1];
                this.m_sPHBTableReferenceTileX = (short)-10;
                this.m_sPHBTableReferenceTileY = (short)-10;
                this.m_sTableRefIndexX = 0;
                this.m_sTableRefIndexY = 0;
                break;
            }
            case 19: {
                this.V = new int[2];
                this.V[0] = 30;
                break;
            }
            case 7: {
                this.stateFlag = (short)(this.stateFlag | 2);
                break;
            }
            case 6: {
                this.V = new int[1];
                this.V[0] = byArray[n++] & 0xFF;
            }
        }
        if ((this.stateFlag & 2) != 0) {
            ++Game.s_iLeftToDie;
        }
        this.m_lInitX = this.x;
        this.m_lInitY = this.y;
        this.m_iInitAction = this.anim.newAction;
        this.m_sInitStateFlag = this.stateFlag;
        if (this.V != null) {
            this.m_iInitV = new int[this.V.length];
            System.arraycopy(this.V, 0, this.m_iInitV, 0, this.V.length);
        }
    }

    boolean GameObj_checkCollsion(Actor actor) {
        if (actor == null) {
            return false;
        }
        return this.GameObj_isCollideBox((int)((actor.x >> 8) + (long)actor.colBox[0]), (int)((actor.y >> 8) + (long)actor.colBox[1]), actor.colBox[2] - actor.colBox[0], actor.colBox[3] - actor.colBox[1]);
    }

    boolean GameObj_isCollideBox(int n, int n2, int n3, int n4) {
        int n5 = (int)(this.x >> 8) + this.colBox[2];
        int n6 = n;
        if (n5 < n6) {
            return false;
        }
        n6 = n + n3;
        n5 = (int)(this.x >> 8) + this.colBox[0];
        if (n6 < n5) {
            return false;
        }
        n6 = n2 + n4;
        n5 = (int)(this.y >> 8) + this.colBox[1];
        if (n6 < n5) {
            return false;
        }
        n5 = (int)(this.y >> 8) + this.colBox[3];
        n6 = n2;
        return n5 >= n6;
    }

    void MModel_Init(byte by, short[] sArray) {
        if (by == 2) {
            return;
        }
        this.mmodel_type = by;
        switch (this.mmodel_type) {
            case 0: {
                this.mmodel_vY = 0;
                this.mmodel_vX = 0;
                this.mmodel_aY = 0;
                this.mmodel_aX = 0;
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.mmodel_vX = sArray[0];
                this.mmodel_vY = sArray[1];
                break;
            }
            case 4: {
                this.mmodel_vX = sArray[0];
                this.mmodel_vY = 0;
                break;
            }
            case 5: {
                this.mmodel_vY = sArray[0];
                this.mmodel_vX = 0;
                break;
            }
            case 6: {
                this.mmodel_vX = sArray[0];
                break;
            }
            case 7: {
                this.mmodel_vY = sArray[0];
                break;
            }
            case 11: {
                this.mmodel_vX = sArray[0];
                this.mmodel_vY = sArray[1];
                this.mmodel_fX = sArray[2];
                this.mmodel_aX = sArray[3];
                this.mmodel_fY = sArray[4];
                this.mmodel_aY = sArray[5];
                this.mmodel_type = (short)8;
                break;
            }
            case 8: {
                this.mmodel_fX = sArray[0];
                this.mmodel_aX = sArray[1];
                this.mmodel_fY = sArray[2];
                this.mmodel_aY = sArray[3];
                break;
            }
            case 12: {
                this.mmodel_vX = sArray[0];
                this.mmodel_fX = sArray[1];
                this.mmodel_aX = sArray[2];
                this.mmodel_type = (short)9;
                break;
            }
            case 9: {
                this.mmodel_fX = sArray[0];
                this.mmodel_aX = sArray[1];
                break;
            }
            case 13: {
                this.mmodel_vY = sArray[0];
                this.mmodel_fY = sArray[1];
                this.mmodel_aY = sArray[2];
                this.mmodel_type = (short)10;
                break;
            }
            case 10: {
                this.mmodel_fY = sArray[0];
                this.mmodel_aY = sArray[1];
            }
        }
    }

    void MModel_Tick() {
        if ((this.mmodel_type == 8 || this.mmodel_type == 9) && this.mmodel_aX != 0) {
            this.mmodel_vX = (short)(this.mmodel_vX + this.mmodel_aX);
            if (this.mmodel_fX > 0 && this.mmodel_vX > this.mmodel_fX || this.mmodel_fX < 0 && this.mmodel_vX < this.mmodel_fX) {
                this.mmodel_vX = this.mmodel_fX;
                this.mmodel_aX = 0;
            }
        }
        if ((this.mmodel_type == 8 || this.mmodel_type == 10) && this.mmodel_aY != 0) {
            this.mmodel_vY = (short)(this.mmodel_vY + this.mmodel_aY);
            if (this.mmodel_fY > 0 && this.mmodel_vY > this.mmodel_fY || this.mmodel_fY < 0 && this.mmodel_vY < this.mmodel_fY) {
                this.mmodel_vY = this.mmodel_fY;
                this.mmodel_aY = 0;
            }
        }
    }

    static void AniLoad(int n, int n2) {
        int n3;
        int n4;
        AnimData animData;
        byte[] byArray = Game.RM_Array_Data[n];
        if (byArray == null) {
            return;
        }
        int n5 = byArray[0] & 0x7F;
        if (aniData[n5] != null) {
            Actor.aniData[n5].flag = (byte)(Actor.aniData[n5].flag | 2);
            return;
        }
        Actor.aniData[n5] = animData = new AnimData();
        animData.resID = (byte)n2;
        animData.flag = (byte)((byArray[0] & 0x80) != 0 ? 1 : 0);
        animData.nbModule = byArray[1];
        animData.nbFrame = byArray[2];
        animData.nbAction = byArray[3];
        animData.flag = (byte)(animData.flag | 2);
        int n6 = animData.nbModule & 0xFF;
        animData.modules = new byte[n6][];
        int n7 = 4;
        for (n4 = 0; n4 < n6; ++n4) {
            animData.modules[n4] = new byte[4];
            System.arraycopy(byArray, n7, animData.modules[n4], 0, 4);
            n7 += 4;
        }
        n6 = animData.nbFrame & 0xFF;
        animData.frames = new byte[n6][];
        for (n3 = 0; n3 < n6; ++n3) {
            n4 = 6 + 3 * (byArray[n7 + 0] & 0xFF);
            animData.frames[n3] = new byte[n4];
            System.arraycopy(byArray, n7, animData.frames[n3], 0, n4);
            n7 += n4;
        }
        n6 = animData.nbAction & 0xFF;
        animData.actions = new byte[n6][];
        animData.mmParam = new byte[n6][];
        for (n3 = 0; n3 < n6; ++n3) {
            n4 = 1 + (byArray[n7 + 0] & 0xFF);
            animData.actions[n3] = new byte[n4];
            System.arraycopy(byArray, n7, animData.actions[n3], 0, n4);
            n7 += n4;
            n4 = 1 + (byArray[n7 + 0] & 0xF);
            animData.mmParam[n3] = new byte[n4];
            System.arraycopy(byArray, n7, animData.mmParam[n3], 0, n4);
            n7 += n4;
        }
    }

    boolean Ani_CheckEnd() {
        if (this.anim.newAction != this.anim.curAction) {
            return false;
        }
        return this.anim.frameTick + 1 >= this.anim.frameDuration && this.anim.actionFrame + 1 >= Actor.aniData[this.anim.type].actions[this.anim.newAction][0];
    }

    static void drawModule(AnimData animData, int n, int n2, int n3, int n4, Graphics graphics) {
        byte[] byArray = animData.modules[n];
        GameMidlet.Instance_Game.drawImageEx(n2, n3, byArray[2] & 0xFF, byArray[3] & 0xFF, animData.resID, byArray[0] & 0xFF, byArray[1] & 0xFF, n4);
    }

    void step() {
        this.x += (long)this.dx;
        this.y += (long)this.dy;
        Anim.aniEvent_flag = 0;
        this.anim.step(true);
        if ((Anim.aniEvent_flag & 1) != 0) {
            this.MModel_Init(Anim.aniEvent_mmtype, Anim.aniEvent_mmpar);
            this.stateFlag = (short)(this.stateFlag | 0x10);
        }
        if ((Anim.aniEvent_flag & 2) != 0) {
            if ((this.stateFlag & 1) != 0) {
                this.colBox[0] = -Anim.aniEvent_pColBoxData[2];
                this.colBox[2] = -Anim.aniEvent_pColBoxData[0];
            } else {
                this.colBox[0] = Anim.aniEvent_pColBoxData[0];
                this.colBox[2] = Anim.aniEvent_pColBoxData[2];
            }
            if ((this.stateFlag & 4) != 0) {
                this.colBox[1] = -Anim.aniEvent_pColBoxData[3];
                this.colBox[3] = -Anim.aniEvent_pColBoxData[1];
            } else {
                this.colBox[1] = Anim.aniEvent_pColBoxData[1];
                this.colBox[3] = Anim.aniEvent_pColBoxData[3];
            }
        }
        this.dx = (this.stateFlag & 0x10) != 0 && (this.stateFlag & 1) != 0 ? (short)(-this.mmodel_vX) : this.mmodel_vX;
        this.dy = (this.stateFlag & 0x10) != 0 && (this.stateFlag & 4) != 0 ? (short)(-this.mmodel_vY) : this.mmodel_vY;
        if ((this.stateFlag & 0x10) != 0) {
            this.MModel_Tick();
        }
    }

    void draw() {
        if (this.objType == 0 && (this.V[1] & 1) == 1 || this.objType == 22 && (this.V[4] & 1) == 1) {
            return;
        }
        this.anim.draw((int)(this.x >> 8), (int)(this.y >> 8), this.stateFlag & 5);
    }

    void Actor_ctor(byte[] byArray) {
        this.objType = byArray[1];
        this.x = Game.ReadUnsignedShort(byArray, 2);
        this.x *= 1L;
        this.x <<= 8;
        this.y = Game.ReadUnsignedShort(byArray, 4);
        this.y *= 1L;
        this.y <<= 8;
        short s = (short)(byArray[0] & 0xF);
        this.stateFlag = (short)((byArray[0] & 0xF0) >> 4);
        this.mmodel_vY = 0;
        this.mmodel_vX = 0;
        this.mmodel_aY = 0;
        this.mmodel_aX = 0;
        this.mmodel_fY = 0;
        this.mmodel_fX = 0;
        Anim.aniEvent_flag = 0;
        this.anim.build(this.objType, s);
        if ((Anim.aniEvent_flag & 1) != 0) {
            this.MModel_Init(Anim.aniEvent_mmtype, Anim.aniEvent_mmpar);
            this.stateFlag = (short)(this.stateFlag | 0x10);
        }
        if ((Anim.aniEvent_flag & 2) != 0) {
            if ((this.stateFlag & 1) != 0) {
                this.colBox[0] = -Anim.aniEvent_pColBoxData[0];
                this.colBox[2] = -Anim.aniEvent_pColBoxData[2];
            } else {
                this.colBox[0] = Anim.aniEvent_pColBoxData[0];
                this.colBox[2] = Anim.aniEvent_pColBoxData[2];
            }
            if ((this.stateFlag & 4) != 0) {
                this.colBox[1] = -Anim.aniEvent_pColBoxData[1];
                this.colBox[3] = -Anim.aniEvent_pColBoxData[3];
            } else {
                this.colBox[1] = Anim.aniEvent_pColBoxData[1];
                this.colBox[3] = Anim.aniEvent_pColBoxData[3];
            }
        }
        this.dx = 0;
        this.dy = 0;
    }

    boolean checkFloor() {
        if (this.dy < 0) {
            return false;
        }
        int n = (int)(this.x + (long)this.dx >> 8 >> 3);
        int n2 = (int)(this.y + (long)this.dy >> 8 >> 3);
        byte by = this.Actor_GetPHB(n, n2);
        if (by == 0 && (by = this.Actor_GetPHB(n, n2 = (int)(this.y + (long)this.dy + (long)Math.abs(this.dx) >> 8 >> 3))) == 0) {
            return false;
        }
        boolean bl = false;
        while (by == 1 || by == 31) {
            bl = true;
            this.dy = (short)((long)(n2 << 8 << 3) - this.y);
            by = this.Actor_GetPHB(n, --n2);
        }
        if (by == 2 || by >= 4 && by <= 9) {
            int n3 = GameMidlet.Instance_Game.PF_getSlopeDisp(by, (int)((this.x + (long)this.dx >> 8 & 7L) / 1L));
            this.dy = (short)((long)((n2 << 8 << 3) + n3 * 1) - this.y);
            return true;
        }
        return bl;
    }

    boolean checkWall() {
        int n;
        byte by = this.dx <= 0 ? this.colBox[0] : this.colBox[2];
        int n2 = (int)(this.x + (long)this.dx >> 8) + by >> 3;
        int n3 = (int)(this.y + (long)this.dy >> 8) + this.colBox[3] - 1 >> 3;
        for (int i = n = (int)(this.y + (long)this.dy >> 8) + this.colBox[1] + 1 >> 3; i <= n3; ++i) {
            byte by2 = this.Actor_GetPHB(n2, i);
            if (by2 != 1 && by2 != 31) continue;
            by2 = this.dx < 0 ? this.Actor_GetPHB(n2 + 1, i) : this.Actor_GetPHB(n2 - 1, i);
            if (this.dx < 0) {
                int n4 = (int)(this.x + (long)this.dx >> 8) + this.colBox[2] >> 3;
                for (int j = n2; j < n4; ++j) {
                    by2 = this.Actor_GetPHB(j + 1, i);
                    if (by2 != 2 && (by2 < 4 || by2 > 9)) continue;
                    return false;
                }
            } else {
                int n5;
                for (int j = n5 = (int)(this.x + (long)this.dx >> 8) + this.colBox[0] >> 3; j > n2; --j) {
                    by2 = this.Actor_GetPHB(j - 1, i);
                    if (by2 != 2 && (by2 < 4 || by2 > 9)) continue;
                    return false;
                }
            }
            this.dx = (short)(8 - (char)((this.x >> 8) + (long)by - (long)(n2 << 3)) << 8);
            return true;
        }
        return false;
    }

    void Bomb_ai() {
        int n = this.anim.curAction;
        switch (n) {
            case 0: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.doDamage();
                    this.anim.newAction = 1;
                }
                if (!Game.pFist.Fist_CheckCollision(this)) break;
                this.anim.newAction = 1;
                GameMidlet.Instance_Game.PlaySound(27, true);
                break;
            }
            case 1: {
                if (!this.Ani_CheckEnd()) break;
                this.stateFlag = (short)(this.stateFlag | 8);
            }
        }
    }

    void SeaUrchin_ai() {
        int n = this.anim.curAction;
        switch (n) {
            case 0: {
                if (Game.pFist.Fist_CheckCollision(this)) {
                    this.anim.newAction = 1;
                }
                if (!this.GameObj_checkCollsion(Game.pRayman)) break;
                Game.pRayman.doDamage();
                break;
            }
            case 1: {
                if (this.Ani_CheckEnd() && (Game.pFist.stateFlag & 8) != 0) {
                    this.anim.newAction = 0;
                }
                if (!this.GameObj_checkCollsion(Game.pRayman)) break;
                Game.pRayman.doDamage();
            }
        }
    }

    void Tentacle_ai() {
        int n = this.anim.curAction;
        switch (n) {
            case 0: 
            case 1: {
                this.V[1] = this.V[1] + 1;
                if (this.V[1] <= this.V[0] || Math.abs(Game.pRayman.x - this.x) >= 16384L || Math.abs(Game.pRayman.y - this.y) >= 14336L) break;
                if (n == 1) {
                    this.anim.newAction = 5;
                    break;
                }
                this.anim.newAction = 2;
                break;
            }
            case 2: 
            case 5: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.doDamage();
                }
                if (Game.pFist.Fist_CheckCollision(this)) {
                    this.anim.newAction = n == 5 ? 7 : 4;
                    this.V[1] = 0;
                    GameMidlet.Instance_Game.PlaySound(27, true);
                }
                if (!this.Ani_CheckEnd()) break;
                if (n == 5) {
                    this.anim.newAction = 6;
                    break;
                }
                this.anim.newAction = 3;
                break;
            }
            case 3: 
            case 6: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.doDamage();
                }
                if (!Game.pFist.Fist_CheckCollision(this)) break;
                this.V[1] = 0;
                this.anim.newAction = n == 6 ? 7 : 4;
                GameMidlet.Instance_Game.PlaySound(27, true);
                break;
            }
            case 4: 
            case 7: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = n == 7 ? 1 : 0;
            }
        }
    }

    void Fly_ai() {
        int n = this.anim.curAction;
        switch (n) {
            case 0: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.doDamage();
                }
                if (Game.pFist.Fist_CheckCollision(this)) {
                    this.anim.newAction = 2;
                    GameMidlet.Instance_Game.PlaySound(27, true);
                }
                if (Math.abs(Game.pRayman.x - this.x) >= 16384L || Math.abs(Game.pRayman.y - this.y) >= 14336L) break;
                this.anim.newAction = 1;
                this.mmodel_vX = (short)((Game.pRayman.x - this.x) / 32L);
                this.mmodel_vY = (short)((Game.pRayman.y - this.y) / 32L);
                break;
            }
            case 1: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.doDamage();
                }
                if (Game.pFist.Fist_CheckCollision(this)) {
                    this.anim.newAction = 2;
                    GameMidlet.Instance_Game.PlaySound(27, true);
                }
                if (GameMidlet.Instance_Game.Camera_IsVisible(this)) break;
                this.stateFlag = (short)(this.stateFlag | 8);
                break;
            }
            case 2: {
                if (!this.Ani_CheckEnd()) break;
                this.stateFlag = (short)(this.stateFlag | 8);
            }
        }
    }

    void Bonus_ai() {
        if (this.objType == 9) {
            Actor actor = Game.pFist;
            if ((actor.stateFlag & 8) == 0 && this.GameObj_checkCollsion(actor)) {
                actor.stateFlag = (short)(actor.stateFlag | 8);
                actor.anim.curAction = 0;
                Game.pRayman.actorReference = null;
                int n = (int)(Game.pRayman.x - this.x >> 8);
                int n2 = n = n < 0 ? -n : n;
                Game.pRayman.anim.newAction = n < 35 ? 41 : (n < 45 ? 42 : 27);
                Game.pRayman.x = this.x;
                Game.pRayman.y = this.y;
                Game.pRayman.V[13] = (int)this.x >> 8;
                Game.pRayman.V[14] = (int)this.y >> 8;
            }
        } else if (this.GameObj_checkCollsion(Game.pRayman)) {
            this.stateFlag = (short)(this.stateFlag | 8);
            switch (this.objType) {
                case 2: {
                    ++Game.s_iLumsTaken;
                    Game.Status_Show(2);
                    GameMidlet.Instance_Game.PlaySound(29, true);
                    break;
                }
                case 3: {
                    Game.m_gameFrame_nLife = (byte)(Game.m_gameFrame_nLife + (Game.m_gameFrame_nLife < 99 ? (byte)1 : 0));
                    Game.Status_Show(0);
                    GameMidlet.Instance_Game.PlaySound(31, true);
                    break;
                }
                case 5: {
                    Game.m_gameFrame_nEnergy = (byte)(Game.m_gameFrame_nEnergy + (Game.m_gameFrame_nEnergy < 5 ? (byte)1 : 0));
                    Game.Status_Show(0);
                    GameMidlet.Instance_Game.PlaySound(30, true);
                    break;
                }
                case 4: {
                    Game.pRayman.V[7] = -1;
                    Game.pRayman.anim.newAction = 9;
                    GameMidlet.Instance_Game.PlaySound(29, true);
                    break;
                }
                case 24: {
                    Game.s_actorCheckpoint = this;
                    GameMidlet.Instance_Game.PlaySound(29, true);
                }
            }
        }
    }

    void Cage_ai() {
        int n = this.anim.curAction;
        switch (n) {
            case 0: {
                if (!Game.pFist.Fist_CheckCollision(this)) break;
                GameMidlet.Instance_Game.PlaySound(25, true);
                this.anim.newAction = 2;
                break;
            }
            case 2: {
                if (!this.Ani_CheckEnd()) break;
                this.V[0] = this.V[0] - 1;
                if (this.V[0] != 0) {
                    this.anim.newAction = 0;
                    break;
                }
                GameMidlet.Instance_Game.PlaySound(24, true);
                ++Game.s_iCageOpened;
                this.anim.newAction = 4;
                Game.Status_Show(1);
                break;
            }
            case 4: {
                if (!this.Ani_CheckEnd() && GameMidlet.Instance_Game.Camera_IsVisible(this)) break;
                this.stateFlag = (short)(this.stateFlag | 8);
                break;
            }
            case 5: {
                if (!Game.pFist.Fist_CheckCollision(this)) break;
                GameMidlet.Instance_Game.PlaySound(25, true);
                this.anim.newAction = 7;
                break;
            }
            case 7: {
                if (!this.Ani_CheckEnd()) break;
                this.V[0] = this.V[0] - 1;
                if (this.V[0] != 0) {
                    this.anim.newAction = 5;
                    break;
                }
                GameMidlet.Instance_Game.PlaySound(24, true);
                ++Game.s_iCageOpened;
                this.anim.newAction = 9;
                Game.Status_Show(1);
                break;
            }
            case 9: {
                if (!this.Ani_CheckEnd() && GameMidlet.Instance_Game.Camera_IsVisible(this)) break;
                this.stateFlag = (short)(this.stateFlag | 8);
            }
        }
    }

    void Platform_ai() {
        int n = this.anim.curAction;
        boolean bl = false;
        if (Game.pRayman.anim.curAction != 27 && Game.pRayman.anim.curAction != 41 && Game.pRayman.anim.curAction != 42) {
            bl = Game.pRayman.Rayman_checkAttachPlatform(this);
        }
        block0 : switch (n) {
            case 0: {
                if (!bl) break;
                this.anim.newAction = this.V[0];
                break;
            }
            case 5: {
                if (GameMidlet.Instance_Game.Camera_IsVisible(this)) break;
                this.Actor_Reset();
                break;
            }
            case 10: {
                this.V[1] = this.V[1] - 1;
                if (this.V[1] > 0) break;
            }
            default: {
                int n2 = (int)(this.x >> 8 >> 3);
                int n3 = (int)(this.y >> 8 >> 3);
                byte by = this.Actor_GetPHB(n2, n3);
                if (by == 0) {
                    return;
                }
                switch (by) {
                    case 28: {
                        this.anim.newAction = 5;
                        break block0;
                    }
                    case 20: {
                        if (n == 4) {
                            this.V[1] = 20;
                            this.anim.newAction = 10;
                            break block0;
                        }
                        this.anim.newAction = 6;
                        break block0;
                    }
                    case 21: {
                        if (n == 6) {
                            this.V[1] = 20;
                            this.anim.newAction = 10;
                            break block0;
                        }
                        this.anim.newAction = 4;
                        break block0;
                    }
                    case 22: {
                        this.anim.newAction = 8;
                        break block0;
                    }
                    case 23: {
                        this.anim.newAction = 2;
                        break block0;
                    }
                    case 24: {
                        this.anim.newAction = 9;
                        break block0;
                    }
                    case 25: {
                        this.anim.newAction = 7;
                        break block0;
                    }
                    case 26: {
                        this.anim.newAction = 3;
                        break block0;
                    }
                    case 27: {
                        this.anim.newAction = 1;
                    }
                }
            }
        }
    }

    void Fist_checkHitBackEnd() {
        Actor actor = Game.pRayman;
        if (this.actorReference != null) {
            this.dx = 0;
            this.anim.newAction = 5;
        } else {
            int n = (int)(this.x - actor.x);
            if (n < 0) {
                n *= -1;
            }
            if (n < 3072 || (this.stateFlag & 1) == 0 && this.x > actor.x || (this.stateFlag & 1) != 0 && this.x < actor.x || n > 65536) {
                this.stateFlag = (short)(this.stateFlag | 8);
                this.anim.curAction = 0;
            } else {
                int n2 = (int)(actor.y - this.y);
                n2 = n2 * 1024 / n;
                this.dy = (short)(this.dy + n2);
            }
        }
    }

    void Fist_ai() {
        int n = this.anim.curAction;
        block0 : switch (n) {
            case 1: {
                if (this.actorReference != null) {
                    this.dx = 0;
                    this.anim.newAction = 3;
                    break;
                }
                if (this.mmodel_vX >= 0) {
                    this.anim.newAction = 4;
                    break;
                }
                if ((this.dx < 0 ? -this.dx : this.dx) > 8) {
                    int n2 = (this.dx > 0 ? 8 : -8) << 8;
                    int n3 = 0;
                    long l = this.x;
                    while ((n3 < 0 ? -n3 : n3) <= (this.dx + n2 < 0 ? -(this.dx + n2) : this.dx + n2)) {
                        if (this.Actor_GetPHB((int)(l >> 8 >> 3), (int)((this.y >> 8) + (long)this.colBox[1] >> 3)) == 1) {
                            this.dx = (short)n3;
                            this.anim.newAction = 3;
                            break block0;
                        }
                        n3 = (short)(n3 + n2);
                        l = this.x + (long)n3;
                    }
                    break;
                }
                if (this.Actor_GetPHB((int)(this.x >> 8 >> 3), (int)((this.y >> 8) + (long)this.colBox[1] >> 3)) != 1) break;
                this.dx = 0;
                this.anim.newAction = 3;
                break;
            }
            case 2: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 4;
                break;
            }
            case 4: {
                this.Fist_checkHitBackEnd();
                break;
            }
            case 3: {
                this.Fist_checkHitBackEnd();
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 4;
                break;
            }
            case 5: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 4;
            }
        }
        this.actorReference = null;
    }

    void Fist_launch(int n, int n2) {
        int n3;
        Actor actor = Game.pRayman;
        this.stateFlag = (byte)(n | this.stateFlag & 0xFFFFFFFA);
        if ((actor.stateFlag & 1) == 0) {
            actor.xDirectionConfirmed = false;
            actor.xDirectionConfirmationCounter = -2;
            n3 = -512;
        } else {
            actor.xDirectionConfirmed = true;
            actor.xDirectionConfirmationCounter = 2;
            n3 = 512;
        }
        if (n2 > 3840) {
            n2 = 3840;
        }
        this.mmodel_vX = (short)(-n2);
        this.dy = 0;
        this.dx = 0;
        this.x = actor.x + (long)actor.dx + (long)n3;
        this.y = actor.y - (long)actor.dy;
        this.stateFlag = (short)(this.stateFlag & 0xFFFFFFF7);
        this.anim.newAction = 1;
        GameMidlet.Instance_Game.PlaySound(39, false);
    }

    boolean Fist_CheckCollision(Actor actor) {
        if ((this.stateFlag & 8) != 0) {
            return false;
        }
        if (this.GameObj_checkCollsion(actor)) {
            this.actorReference = actor;
            return true;
        }
        return false;
    }

    void LevelSign_ai() {
        int n = this.anim.curAction;
        switch (n) {
            case 0: 
            case 2: {
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    Game.pRayman.actorReference = this;
                    break;
                }
                if (Game.pRayman.actorReference != this) break;
                Game.pRayman.actorReference = null;
                break;
            }
            case 1: {
                if ((this.V[0] > 8 || this.V[0] > Game.m_gameFrame_unlockedLevel) && ((Game.s_iLumsTaken & 0xFF) < 140 || Game.s_iCageOpened < 12)) break;
                this.anim.newAction = 4;
                break;
            }
            case 4: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 2;
                break;
            }
            case 3: {
                int n2 = Game.pRayman.anim.curAction;
                if (n == 15 || n == 16 || n == 13) break;
                if (this.GameObj_checkCollsion(Game.pRayman)) {
                    if (Game.pRayman.actorReference == this) break;
                    Game.pRayman.actorReference = this;
                    GameMidlet.Instance_Game.m_iGlobalTicker = 14;
                    break;
                }
                if (Game.pRayman.actorReference != this) break;
                Game.pRayman.actorReference = null;
            }
        }
    }

    void LevelPost_ai() {
        int n = this.anim.curAction;
        if (this.anim.curAction == 0 && this.GameObj_checkCollsion(Game.pRayman) && (Game.pRayman.anim.curAction == 0 || Game.pRayman.anim.curAction == 2) && Game.s_iLeftToDie == 1) {
            --Game.s_iLeftToDie;
        }
    }

    void Bullet_ai() {
        if (!GameMidlet.Instance_Game.Camera_IsVisible(this)) {
            this.stateFlag = (short)(this.stateFlag | 8);
        }
        if (this.GameObj_checkCollsion(Game.pRayman)) {
            Game.pRayman.doDamage();
            this.stateFlag = (short)(this.stateFlag | 8);
        }
    }

    void Pirate_ai() {
        if (this.checkFloor()) {
            this.mmodel_type = 0;
        } else {
            this.mmodel_fY = (short)1792;
            this.mmodel_aY = (short)256;
            this.mmodel_type = (short)10;
        }
        switch (this.anim.curAction) {
            case 0: {
                if ((Game.pRayman.stateFlag & 8) != 0) break;
                if (this.V[3] % 15 == 0) {
                    if ((this.V[2] & 0x10000) != 0) {
                        this.anim.newAction = 1;
                        this.V[3] = this.V[3] - 15;
                    } else if ((this.V[2] & 1) != 0) {
                        this.anim.newAction = 3;
                        this.V[3] = this.V[3] - 15;
                    } else {
                        this.V[3] = this.V[3] - 1;
                    }
                    this.V[2] = this.V[2] >> 1;
                } else {
                    this.V[3] = this.V[3] - 1;
                }
                if (this.V[3] != 0) break;
                this.V[2] = this.m_iInitV[2];
                this.V[3] = this.m_iInitV[3];
                break;
            }
            case 1: {
                if (!this.Ani_CheckEnd()) break;
                Actor actor = GameMidlet.Instance_Game.actors[this.V[0]];
                if ((this.stateFlag & 1) == 0 && actor.mmodel_vX > 0 || (this.stateFlag & 1) != 0 && actor.mmodel_vX < 0) {
                    actor.mmodel_vX = -actor.mmodel_vX;
                }
                actor.x = this.x - (long)(5120 * ((this.stateFlag & 1) == 0 ? 1 : -1)) + (long)this.dx;
                actor.y = this.y - 4096L + (long)this.dy;
                actor.stateFlag = (short)(actor.stateFlag & 0xFFFFFFF7);
                this.V[4] = 0;
                this.anim.newAction = 2;
                break;
            }
            case 2: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 0;
                break;
            }
            case 3: {
                if (!this.Ani_CheckEnd()) break;
                Actor actor = GameMidlet.Instance_Game.actors[this.V[0]];
                if ((this.stateFlag & 1) == 0 && actor.mmodel_vX > 0 || (this.stateFlag & 1) != 0 && actor.mmodel_vX < 0) {
                    actor.mmodel_vX = -actor.mmodel_vX;
                }
                actor.x = this.x - (long)(3584 * ((this.stateFlag & 1) == 0 ? 1 : -1)) + (long)this.dx;
                actor.y = this.y - 1792L + (long)this.dy;
                actor.stateFlag = (short)(actor.stateFlag & 0xFFFFFFF7);
                this.V[4] = 0;
                this.anim.newAction = 4;
                break;
            }
            case 4: {
                if (!this.Ani_CheckEnd()) break;
                this.anim.newAction = 0;
                break;
            }
            case 5: {
                if (!this.Ani_CheckEnd()) break;
                while (this.V[3] % 15 != 0) {
                    this.V[3] = this.V[3] - 1;
                }
                for (int i = 0; i < 16 && (this.V[2] & 0x10000) == 0 && (this.V[2] & 1) == 0; ++i) {
                    this.V[2] = this.V[2] >> 1;
                    this.V[3] = this.V[3] - 15;
                    if (this.V[3] != 0) continue;
                    this.V[2] = this.m_iInitV[2];
                    this.V[3] = this.m_iInitV[3];
                }
                this.anim.newAction = 0;
                break;
            }
            case 6: {
                if (this.Ani_CheckEnd()) {
                    if ((this.stateFlag & 0x20) != 0) {
                        this.stateFlag = (short)(this.stateFlag | 0x40);
                    } else {
                        this.Actor_Death();
                    }
                }
                return;
            }
        }
        boolean bl = false;
        if (this.V[4] == 0) {
            bl = Game.pFist.Fist_CheckCollision(this);
        } else {
            this.V[4] = this.V[4] - 1;
        }
        if (bl) {
            this.V[1] = this.V[1] - 1;
            if (this.V[1] > 0) {
                this.anim.newAction = 5;
                this.V[4] = 50;
                GameMidlet.Instance_Game.PlaySound(27, true);
            } else {
                this.anim.newAction = 6;
                GameMidlet.Instance_Game.PlaySound(26, true);
            }
        } else if (this.GameObj_checkCollsion(Game.pRayman)) {
            Game.pRayman.doDamage();
            if ((this.stateFlag & 1) == 0 && (Game.pRayman.stateFlag & 1) != 0 || (this.stateFlag & 1) != 0 && (Game.pRayman.stateFlag & 1) == 0) {
                Game.pRayman.mmodel_vX = 0;
                Game.pRayman.dx = 0;
            }
        }
    }

    boolean checkCeilingStandUp() {
        int n = (int)(this.x >> 8 >> 3);
        int n2 = (int)(this.y >> 8 >> 3);
        byte by = Actor.aniData[0].frames[Actor.aniData[0].actions[0][1]][3];
        int n3 = Math.abs(by / 8);
        if (by % 8 != 0) {
            ++n3;
        }
        for (int i = 1; i <= n3; ++i) {
            byte by2 = this.Actor_GetPHB(n, n2 - i);
            if (by2 != 1 && by2 != 31) continue;
            return true;
        }
        return false;
    }

    void jumpUp(int n, int n2) {
        if (this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10)) {
            this.actorReference = null;
            this.dy = (short)(this.dy - 512);
        }
        if (n > 0) {
            this.mmodel_vX = this.checkClimb() ? (short)(-(n - n2)) : (short)(this.mmodel_vX - (n - n2));
            this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
        } else if (n < 0) {
            this.mmodel_vX = this.checkClimb() ? (short)(n + n2) : (short)(this.mmodel_vX + (n + n2));
            this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
        } else {
            this.mmodel_vX = (short)((this.stateFlag & 5) != 0 ? -n2 : n2);
        }
        this.anim.newAction = 7;
        if (this.mmodel_vX > 1792) {
            this.mmodel_vX = (short)1792;
        } else if (this.mmodel_vX < -1792) {
            this.mmodel_vX = (short)-1792;
        }
        this.V[16] = (int)(this.y >> 8);
        this.V[15] = 0;
        this.mmodel_aX = 0;
    }

    void startFly(int n) {
        if ((this.V[0] & 2) != 2) {
            return;
        }
        this.anim.newAction = 9;
        this.mmodel_aX = 0;
        if (n > 0) {
            this.mmodel_vX = (short)(-n);
            this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
        } else if (n < 0) {
            this.mmodel_vX = (short)n;
            this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
        }
        this.V[6] = 0;
        this.V[0] = this.V[0] & 0xFFFFFFFD;
    }

    void handleKeyEvent() {
        int n = this.anim.curAction;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        switch (n) {
            case 17: {
                if (this.anim.oldAction == 11 || this.anim.oldAction == 9 || this.anim.oldAction == 7 || this.anim.oldAction == 8 || this.anim.oldAction == 10) {
                    this.yDirectionConfirmed = 0;
                    this.yDirectionConfirmationCounter = 0;
                }
                if ((this.V[4] & 0x20) != 0 && (Game.pFist.stateFlag & 8) != 0) {
                    this.anim.newAction = 25;
                    this.V[2] = 0;
                    return;
                }
                if ((this.V[3] & 4) != 0) {
                    bl = this.checkClimbJump(4);
                    if ((this.V[4] & 4) != 0) {
                        if (bl) {
                            this.y -= 2048L;
                            this.jumpUp(0, 0);
                        }
                    } else if (!bl) {
                        this.anim.newAction = 18;
                    }
                }
                if ((this.V[3] & 0x100) != 0) {
                    bl = this.checkClimbJump(8);
                    if ((this.V[4] & 0x100) != 0) {
                        if (bl) {
                            this.anim.newAction = 11;
                            this.V[15] = 0;
                            this.y += 3072L;
                        }
                    } else if (!bl) {
                        this.anim.newAction = 20;
                    }
                }
                if ((this.V[3] & 0x10) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    bl = this.checkClimbJump(1);
                    if ((this.V[4] & 0x10) != 0) {
                        if (bl) {
                            this.xDirectionConfirmationCounter -= 2;
                        }
                    } else if (!bl) {
                        this.anim.newAction = 22;
                    }
                }
                if ((this.V[3] & 0x40) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    bl = this.checkClimbJump(2);
                    if ((this.V[4] & 0x40) != 0) {
                        if (bl) {
                            this.xDirectionConfirmationCounter += 2;
                        }
                    } else if (!bl) {
                        this.anim.newAction = 22;
                    }
                }
                if ((this.V[3] & 8) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    bl = this.checkClimbJump(6);
                    if ((this.V[4] & 8) != 0) {
                        if (bl) {
                            this.y -= 2048L;
                            this.x += 2048L;
                            if (this.x + (long)(this.colBox[2] << 8) > (long)(GameMidlet.Instance_Game.m_sBackgroundWidth << 3 << 8)) {
                                this.x = (GameMidlet.Instance_Game.m_sBackgroundWidth << 3) - (this.colBox[2] + 2) << 8;
                                this.jumpUp(0, 0);
                            } else {
                                this.jumpUp(768, 0);
                            }
                        }
                    } else if (!bl) {
                        this.anim.newAction = 19;
                    }
                }
                if ((this.V[3] & 2) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    bl = this.checkClimbJump(5);
                    if ((this.V[4] & 2) != 0) {
                        if (bl) {
                            this.x -= 2048L;
                            this.y -= 2048L;
                            if (this.x + (long)(this.colBox[0] << 8) < 0L) {
                                this.x = -this.colBox[0] << 8;
                                this.jumpUp(0, 0);
                            } else {
                                this.jumpUp(-768, 0);
                            }
                        }
                    } else if (!bl) {
                        this.anim.newAction = 19;
                    }
                }
                if ((this.V[3] & 0x200) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    bl = this.checkClimbJump(8);
                    bl2 = this.checkClimbJump(2);
                    if ((this.V[4] & 0x200) != 0) {
                        if (bl) {
                            this.anim.newAction = 11;
                            this.V[15] = 0;
                            this.y += 3072L;
                        }
                    } else if (!(bl | bl2)) {
                        this.anim.newAction = 21;
                    }
                }
                if ((this.V[3] & 0x80) == 0) break;
                this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                bl = this.checkClimbJump(8);
                bl2 = this.checkClimbJump(1);
                if ((this.V[4] & 0x80) != 0) {
                    if (!bl) break;
                    this.anim.newAction = 11;
                    this.V[15] = 0;
                    this.y += 3072L;
                    break;
                }
                if (bl | bl2) break;
                this.anim.newAction = 21;
                break;
            }
            case 18: {
                n2 = 14;
                if ((this.V[3] & n2) != 0 && this.checkClimbJump(4)) {
                    if ((this.V[4] & 4) != 0) {
                        this.jumpUp(0, 0);
                    } else if ((this.V[4] & 2) != 0) {
                        this.jumpUp(-768, 0);
                    } else if ((this.V[4] & 8) != 0) {
                        this.jumpUp(768, 0);
                    } else {
                        this.anim.newAction = 17;
                    }
                }
                if ((this.V[3] & 4) != 0) break;
                this.anim.newAction = 17;
                break;
            }
            case 20: {
                n2 = 896;
                if ((this.V[3] & n2) != 0 && this.checkClimbJump(8)) {
                    if ((this.V[4] & n2) != 0) {
                        this.anim.newAction = 11;
                        this.V[15] = 0;
                        this.y += 2048L;
                    } else {
                        this.anim.newAction = 17;
                    }
                }
                if ((this.V[3] & 0x100) != 0) break;
                this.anim.newAction = 17;
                break;
            }
            case 19: {
                if ((this.V[3] & 2) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    bl = this.checkClimbJump(4);
                    bl2 = this.checkClimbJump(1);
                    if (bl && !bl2) {
                        this.mmodel_vY = 0;
                    } else if (!bl && bl2) {
                        this.mmodel_vX = 0;
                    } else if (bl && bl2) {
                        this.anim.newAction = 17;
                    }
                }
                if ((this.V[3] & 8) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    bl = this.checkClimbJump(4);
                    bl2 = this.checkClimbJump(2);
                    if (bl && !bl2) {
                        this.mmodel_vY = 0;
                    } else if (!bl && bl2) {
                        this.mmodel_vX = 0;
                    } else if (bl && bl2) {
                        this.anim.newAction = 17;
                    }
                }
                if ((this.V[3] & (n2 = (this.stateFlag & 1) == 0 ? 2 : 8)) != 0) break;
                this.anim.newAction = 17;
                break;
            }
            case 21: {
                if ((this.V[3] & 0x80) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    bl = this.checkClimbJump(8);
                    bl2 = this.checkClimbJump(1);
                    if (bl && !bl2) {
                        this.mmodel_vY = 0;
                    } else if (!bl && bl2) {
                        this.mmodel_vX = 0;
                    } else if (bl && bl2) {
                        this.anim.newAction = 17;
                    }
                }
                if ((this.V[3] & 0x200) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    bl = this.checkClimbJump(8);
                    bl2 = this.checkClimbJump(2);
                    if (bl && !bl2) {
                        this.mmodel_vY = 0;
                    } else if (!bl && bl2) {
                        this.mmodel_vX = 0;
                    } else if (bl && bl2) {
                        this.anim.newAction = 17;
                    }
                }
                if ((this.V[3] & (n2 = (this.stateFlag & 1) == 0 ? 128 : 512)) != 0) break;
                this.anim.newAction = 17;
                break;
            }
            case 22: {
                if ((this.V[3] & 0x10) != 0) {
                    bl = this.checkClimbJump(1);
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    if (bl) {
                        this.anim.newAction = 17;
                    }
                }
                if ((this.V[3] & 0x40) != 0) {
                    bl = this.checkClimbJump(2);
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    if (bl) {
                        this.anim.newAction = 17;
                    }
                }
                if ((this.V[3] & (n2 = (this.stateFlag & 1) == 0 ? 16 : 64)) != 0) break;
                this.anim.newAction = 17;
                break;
            }
            case 27: 
            case 41: 
            case 42: {
                if ((this.V[4] & 4) != 0) {
                    this.jumpUp(0, 0);
                } else if ((this.V[4] & 8) != 0) {
                    this.jumpUp(768, 0);
                } else if ((this.V[4] & 2) != 0) {
                    this.jumpUp(-768, 0);
                } else {
                    return;
                }
                this.x = this.V[13] + (this.colBox[0] + this.colBox[2] >> 1);
                this.y = this.V[14] + (this.colBox[1] + this.colBox[3] >> 1);
                this.x <<= 8;
                this.y <<= 8;
                this.step();
                this.actorReference = null;
                break;
            }
            case 0: 
            case 12: 
            case 39: 
            case 40: {
                if (this.V[3] == 0 && this.V[4] == 0) {
                    this.yDirectionConfirmed = 0;
                    this.yDirectionConfirmationCounter = 0;
                }
                if ((this.V[3] & (n2 = 14)) != 0 && (this.V[4] & n2) != 0) {
                    if ((this.V[4] & 4) != 0) {
                        this.jumpUp(0, 0);
                    } else if ((this.V[4] & 2) != 0) {
                        this.jumpUp(-768, 0);
                    } else if ((this.V[4] & 8) != 0) {
                        this.jumpUp(768, 0);
                    }
                }
                if ((this.V[3] & 0x100) != 0 && (this.V[4] & 0x100) != 0) {
                    this.anim.newAction = 3;
                }
                if ((this.V[3] & 0x10) != 0) {
                    if ((this.stateFlag & 1) == 0 && this.xDirectionConfirmationCounter < -1) {
                        this.anim.newAction = 2;
                    } else {
                        this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                        if (this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10) && this.actorReference.dy != 0 && this.actorReference.dx == 0) {
                            this.xDirectionConfirmed = false;
                            this.xDirectionConfirmationCounter = -2;
                        } else {
                            --this.xDirectionConfirmationCounter;
                        }
                    }
                }
                if ((this.V[3] & 0x40) != 0) {
                    if ((this.stateFlag & 1) != 0 && this.xDirectionConfirmationCounter > 1) {
                        this.anim.newAction = 2;
                    } else {
                        this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                        if (this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10) && this.actorReference.dy != 0 && this.actorReference.dx == 0) {
                            this.xDirectionConfirmed = true;
                            this.xDirectionConfirmationCounter = 2;
                        } else {
                            ++this.xDirectionConfirmationCounter;
                        }
                    }
                }
                if ((this.V[3] & 0x80) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 3;
                }
                if ((this.V[3] & 0x200) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 3;
                }
                if ((this.V[4] & 0x20) != 0) {
                    if (this.actorReference != null && this.actorReference.objType == 6 && (this.actorReference.anim.curAction == 2 || this.actorReference.anim.curAction == 0)) {
                        GameMidlet.Instance_Game.StopMusic();
                        if (this.actorReference.anim.curAction == 2 || this.actorReference.anim.curAction == 0) {
                            GameMidlet.Instance_Game.PlaySound(30, true);
                        }
                        this.anim.newAction = 37;
                    } else if ((Game.pFist.stateFlag & 8) != 0) {
                        this.anim.newAction = 15;
                        this.V[2] = 0;
                    }
                }
                if (this.V[4] == 0) {
                    this.V[10] = this.V[10] + 1;
                    break;
                }
                this.V[10] = 0;
                GameMidlet.Instance_Game.LockDrawText();
                break;
            }
            case 2: {
                if ((this.V[3] & 0x10) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                } else if ((this.V[3] & 0x40) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                }
                if ((this.V[4] & 4) != 0) {
                    this.jumpUp(0, 0);
                } else if ((this.V[4] & 0x100) != 0) {
                    this.anim.newAction = 3;
                } else if ((this.V[4] & 8) != 0) {
                    this.jumpUp(768, -this.mmodel_vX);
                } else if ((this.V[4] & 2) != 0) {
                    this.jumpUp(-768, -this.mmodel_vX);
                } else if ((this.V[4] & 0x80) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 3;
                } else if ((this.V[4] & 0x200) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 3;
                } else if ((this.V[3] & 0x40) == 0 && (this.V[3] & 0x10) == 0) {
                    this.anim.newAction = 0;
                }
                if ((this.V[4] & 0x20) == 0 || (Game.pFist.stateFlag & 8) == 0) break;
                this.anim.newAction = 15;
                this.V[2] = 0;
                break;
            }
            case 9: {
                if (this.V[7] != 0) {
                    if ((this.V[3] & 4) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 8) != 0) {
                        this.mmodel_vY = (short)-256;
                    } else {
                        if (this.mmodel_vY < 0) {
                            this.mmodel_vY = 0;
                        }
                        this.mmodel_vY = (short)(this.mmodel_vY + 64);
                        if (this.mmodel_vY > 256) {
                            this.mmodel_vY = (short)256;
                        }
                    }
                }
                if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 0x80) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    if (this.mmodel_vX > -768) {
                        this.mmodel_vX = (short)(this.mmodel_vX - 256);
                        if (this.mmodel_vX < -768) {
                            this.mmodel_vX = (short)-768;
                        }
                    }
                } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0 || (this.V[3] & 0x200) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    if (this.mmodel_vX > -768) {
                        this.mmodel_vX = (short)(this.mmodel_vX - 256);
                        if (this.mmodel_vX < -768) {
                            this.mmodel_vX = (short)-768;
                        }
                    }
                }
                if ((this.V[3] & 0x10) == 0 && (this.V[3] & 2) == 0 && (this.V[3] & 0x80) == 0 && (this.V[3] & 0x40) == 0 && (this.V[3] & 8) == 0 && (this.V[3] & 0x200) == 0) {
                    this.mmodel_vX = 0;
                }
                if ((this.V[3] & 4) == 0 && (this.V[3] & 2) == 0 && (this.V[3] & 8) == 0) {
                    if (this.V[7] != 0) {
                        int n3 = this.V[8];
                        this.V[8] = n3 + 1;
                        if (n3 < 5) {
                            this.mmodel_vY = 0;
                            this.dy = 0;
                        }
                    }
                } else {
                    this.V[8] = 0;
                }
                if ((this.V[4] & 0x20) == 0 || (Game.pFist.stateFlag & 8) == 0) break;
                if (this.V[7] != 0) {
                    this.anim.newAction = 34;
                    break;
                }
                this.anim.newAction = 10;
                Game.pFist.Fist_launch(this.stateFlag & 1, 2880);
                break;
            }
            case 34: 
            case 35: {
                if ((this.V[5] & 0x20) == 0) break;
                this.anim.newAction = 36;
                Game.pFist.Fist_launch(this.stateFlag & 1, 2880);
                break;
            }
            case 30: {
                if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 31;
                } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 31;
                }
                if ((this.V[3] & 0x100) == 0 && (this.V[3] & 0x80) == 0 && (this.V[3] & 0x200) == 0) break;
                this.yDirectionConfirmed = 1;
                this.yDirectionConfirmationCounter = 5;
                this.anim.newAction = 11;
                this.y += 2048L;
                break;
            }
            case 31: {
                if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                }
                if ((this.V[5] & 0x100) != 0 || (this.V[5] & 0x80) != 0 || (this.V[5] & 0x200) != 0) {
                    this.yDirectionConfirmed = 1;
                    this.yDirectionConfirmationCounter = 5;
                    this.anim.newAction = 11;
                    this.y += 2048L;
                    break;
                }
                if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0) break;
                this.anim.newAction = 30;
                break;
            }
            case 11: {
                if ((this.V[4] & 4) != 0 || (this.V[4] & 8) != 0 || (this.V[4] & 2) != 0) {
                    this.startFly(0);
                } else if ((this.V[4] & 8) != 0) {
                    this.startFly(768);
                } else if ((this.V[4] & 2) != 0) {
                    this.startFly(-768);
                }
                if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 0x80) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    if (this.mmodel_vX < 0) {
                        this.mmodel_vX = (short)(this.mmodel_vX - 256);
                        if (this.mmodel_vX < -768) {
                            this.mmodel_vX = (short)-768;
                        }
                    }
                } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0 || (this.V[3] & 0x200) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    if (this.mmodel_vX > -768) {
                        this.mmodel_vX = (short)(this.mmodel_vX - 256);
                        if (this.mmodel_vX < -768) {
                            this.mmodel_vX = (short)-768;
                        }
                    }
                }
                if ((this.V[4] & 0x20) == 0 || (Game.pFist.stateFlag & 8) == 0) break;
                this.anim.newAction = 10;
                Game.pFist.Fist_launch(this.stateFlag & 1, 2880);
                break;
            }
            case 7: {
                if (this.anim.oldAction == 28 || this.anim.oldAction == 29) {
                    this.mmodel_vY = (short)(this.mmodel_vY - 256);
                    this.V[9] = 0x7FFFFFF;
                    break;
                }
                this.V[9] = 0;
                break;
            }
            case 8: {
                if ((this.V[4] & 4) != 0) {
                    if (this.mmodel_vX < 0) {
                        this.mmodel_vX = 0;
                    }
                    this.mmodel_vY = 0;
                    this.mmodel_aY = 0;
                    this.startFly(0);
                } else if ((this.V[4] & 8) != 0) {
                    this.mmodel_vY = 0;
                    this.mmodel_aY = 0;
                    this.startFly(768);
                } else if ((this.V[4] & 2) != 0) {
                    this.mmodel_vY = 0;
                    this.mmodel_aY = 0;
                    this.startFly(-768);
                }
                if ((this.V[3] & 4) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 8) != 0) {
                    int n4 = this.V[9];
                    this.V[9] = n4 + 1;
                    if (n4 < 8) {
                        this.mmodel_vY = (short)(this.mmodel_vY - 153);
                    }
                }
                if ((this.V[3] & 0x10) != 0 || (this.V[3] & 2) != 0 || (this.V[3] & 0x80) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    if (this.mmodel_vX > -768) {
                        this.mmodel_vX = (short)(this.mmodel_vX - 256);
                        if (this.mmodel_vX < -768) {
                            this.mmodel_vX = (short)-768;
                        }
                    }
                } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 8) != 0 || (this.V[3] & 0x200) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    if (this.mmodel_vX > -768) {
                        this.mmodel_vX = (short)(this.mmodel_vX - 256);
                        if (this.mmodel_vX < -768) {
                            this.mmodel_vX = (short)-768;
                        }
                    }
                }
                if ((this.V[4] & 0x20) == 0 || (Game.pFist.stateFlag & 8) == 0) break;
                this.anim.newAction = 10;
                Game.pFist.Fist_launch(this.stateFlag & 1, 2880);
                break;
            }
            case 4: {
                if ((this.V[3] & 0x10) != 0 || (this.V[3] & 0x80) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 5;
                } else if ((this.V[3] & 0x40) != 0 || (this.V[3] & 0x200) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 5;
                }
                if ((this.V[3] & 0x100) != 0 || (this.V[3] & 0x80) != 0 || (this.V[3] & 0x200) != 0 || this.checkCeilingStandUp()) break;
                this.anim.newAction = 6;
                break;
            }
            case 5: {
                if ((this.V[3] & 0x80) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                } else if ((this.V[3] & 0x200) != 0) {
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                } else if ((this.V[3] & 0x100) != 0) {
                    this.anim.newAction = 4;
                }
                if ((this.V[3] & 0x100) != 0 || (this.V[3] & 0x80) != 0 || (this.V[3] & 0x200) != 0) break;
                if (!this.checkCeilingStandUp()) {
                    this.anim.newAction = 6;
                    break;
                }
                this.anim.newAction = 4;
                break;
            }
            case 6: {
                if ((this.V[4] & 0x20) == 0 || this.checkCeilingStandUp()) break;
                this.anim.newAction = 15;
                this.V[2] = 0;
                break;
            }
            case 13: {
                if ((this.V[4] & 4) != 0) {
                    this.jumpUp(0, 0);
                    break;
                }
                if ((this.V[3] & 0x100) != 0) {
                    this.anim.newAction = 3;
                    break;
                }
                if ((this.V[4] & 0x10) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 2;
                    break;
                }
                if ((this.V[4] & 0x40) != 0) {
                    this.anim.newAction = 2;
                    this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                    break;
                }
                if ((this.V[4] & 8) != 0) {
                    this.jumpUp(768, 0);
                    break;
                }
                if ((this.V[4] & 2) != 0) {
                    this.jumpUp(-768, 0);
                    break;
                }
                if ((this.V[4] & 0x80) != 0) {
                    this.stateFlag = (byte)(0 | this.stateFlag & 0xFFFFFFFA);
                    this.anim.newAction = 3;
                    break;
                }
                if ((this.V[4] & 0x80) == 0) break;
                this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                this.anim.newAction = 3;
                break;
            }
            case 15: {
                if ((this.V[5] & 0x20) == 0) break;
                this.anim.newAction = 13;
                Game.pFist.Fist_launch(this.stateFlag & 1, this.V[2] * 80 + 2256);
                break;
            }
            case 16: {
                if ((this.V[5] & 0x20) == 0) break;
                this.anim.newAction = 13;
                Game.pFist.Fist_launch(this.stateFlag & 1, this.V[2] * 80 + 2256);
                break;
            }
            case 25: {
                if ((this.V[5] & 0x20) == 0) break;
                this.anim.newAction = 23;
                Game.pFist.Fist_launch(this.stateFlag & 1, this.V[2] * 80 + 2256);
                break;
            }
            case 28: {
                this.yDirectionConfirmed = 0;
                this.yDirectionConfirmationCounter = 0;
                if ((this.V[4] & 4) != 0) {
                    if ((this.stateFlag & 1) == 0) {
                        this.jumpUp(-256, 0);
                        break;
                    }
                    this.jumpUp(256, 0);
                    break;
                }
                if ((this.V[4] & 0x100) != 0) {
                    this.y += 2048L;
                    this.x = (this.stateFlag & 1) == 0 ? (this.x += 512L) : (this.x -= 512L);
                    this.anim.newAction = 11;
                    break;
                }
                if ((this.V[4] & 8) != 0) {
                    this.jumpUp(256, 0);
                    break;
                }
                if ((this.V[4] & 2) == 0) break;
                this.jumpUp(-256, 0);
                break;
            }
            case 29: {
                if ((this.V[4] & 4) != 0) {
                    if ((this.stateFlag & 1) == 0) {
                        this.jumpUp(-256, 0);
                        break;
                    }
                    this.jumpUp(256, 0);
                    break;
                }
                if ((this.V[4] & 0x100) != 0) {
                    this.y += 2048L;
                    this.x = (this.stateFlag & 1) == 0 ? (this.x += 512L) : (this.x -= 512L);
                    this.anim.newAction = 11;
                    break;
                }
                if ((this.V[4] & 8) != 0) {
                    this.jumpUp(256, 0);
                    break;
                }
                if ((this.V[4] & 2) == 0) break;
                this.jumpUp(-256, 0);
            }
        }
        n2 = 146;
        if ((this.V[4] & n2) != 0) {
            --this.xDirectionConfirmationCounter;
        }
        if ((this.V[4] & (n2 = 584)) != 0) {
            ++this.xDirectionConfirmationCounter;
        }
    }

    boolean checkCeilingAir() {
        int n = (int)(this.x >> 8 >> 3);
        int n2 = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] >> 3);
        byte by = this.Actor_GetPHB(n, n2);
        if (by == 1) {
            while (by == 1) {
                by = this.Actor_GetPHB(n, ++n2);
            }
            this.y = (n2 << 3) - this.colBox[1] + 2 << 8;
            this.dy = 0;
            return true;
        }
        return false;
    }

    boolean canHangRoof() {
        int n = (int)(this.x + (long)this.dx >> 8 >> 3);
        int n2 = (int)((this.y + (long)this.dy >> 8) - 40L >> 3);
        byte by = this.Actor_GetPHB(n, n2);
        if (by == 30) {
            this.y = (n2 << 3) + 40 + 4 << 8;
            this.dy = 0;
            return true;
        }
        return false;
    }

    boolean checkClimb() {
        int n = (int)(this.x + (long)this.dx >> 8 >> 3);
        int n2 = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] >> 3);
        int n3 = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[3] >> 3);
        if (this.Actor_GetPHB(n, n2) == 16 && this.Actor_GetPHB(n, n2 + 1) == 16) {
            if (this.Actor_GetPHB(n + 1, n2) != 16) {
                this.x = (n << 3) + 8 - this.colBox[2] << 8;
            } else if (this.Actor_GetPHB(n - 1, n2) != 16) {
                this.x = (n << 3) - this.colBox[0] << 8;
            }
            if (this.dy > 0 && this.Actor_GetPHB(n, n2 - 1) != 16) {
                this.y = (n2 << 3) - this.colBox[1] << 8;
            } else if (this.dy < 0 && this.Actor_GetPHB(n, n2 + 2) != 16) {
                this.y = (n2 << 3) - this.colBox[1] << 8;
            }
            this.dy = 0;
            this.dx = 0;
            this.V[15] = 1;
        } else {
            this.V[15] = 0;
        }
        return this.V[15] == 1;
    }

    boolean checkClimbJump(int n) {
        int n2 = -100;
        int n3 = -100;
        if ((n & 1) != 0) {
            n2 = (int)((this.x + (long)this.dx >> 8) + (long)this.colBox[2] >> 3);
        }
        if ((n & 2) != 0) {
            n2 = (int)((this.x + (long)this.dx >> 8) + (long)this.colBox[0] - 1L >> 3);
        }
        if ((n & 4) != 0) {
            n3 = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] + 4L >> 3);
        }
        if ((n & 8) != 0) {
            n3 = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] >> 3);
        }
        if (n2 == -100) {
            n2 = (int)(this.x + (long)this.dx >> 8 >> 3);
        }
        if (n3 == -100) {
            n3 = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] >> 3);
        }
        if ((n & 1) != 0) {
            --n2;
        }
        if ((n & 2) != 0) {
            ++n2;
        }
        if ((n & 4) != 0) {
            --n3;
        }
        if ((n & 8) != 0) {
            n3 += 2;
        }
        return this.Actor_GetPHB(n2, n3) == 0;
    }

    boolean canHangOnLedge() {
        boolean bl = (this.stateFlag & 1) == 0;
        int n = (int)(this.x + (long)this.dx) >> 8;
        int n2 = (int)(this.y + (long)this.dy) >> 8;
        n = bl ? (n += this.colBox[0] - 4) : (n += this.colBox[2] + 4);
        int n3 = n >> 3;
        int n4 = (int)((this.y + (long)this.dy >> 8) + (long)this.colBox[1] + 8L) >> 3;
        byte by = this.Actor_GetPHB(n3, n4);
        int n5 = n3;
        n5 = bl ? ++n5 : --n5;
        byte by2 = this.Actor_GetPHB(n5, n4);
        if (by == 31 || by2 == 31) {
            this.anim.newAction = 28;
            this.x = by2 == 31 ? (long)(n5 << 3) : (long)(n3 << 3);
            this.y = (n4 << 3) - this.colBox[1] - 4;
            this.x = bl ? (this.x -= (long)(this.colBox[0] - 8 + 0)) : (this.x -= (long)(this.colBox[2] - 0));
            this.dy = 0;
            this.dx = 0;
            this.x <<= 8;
            this.y <<= 8;
            return true;
        }
        return false;
    }

    void doDamage() {
        if (this.V[12] > 0 || (this.stateFlag & 8) != 0) {
            return;
        }
        if ((Game.m_gameFrame_nEnergy = (byte)(Game.m_gameFrame_nEnergy - (Game.m_gameFrame_nEnergy > 0 ? (byte)1 : 0))) == 0) {
            this.anim.newAction = 33;
            GameMidlet.Instance_Game.PlaySound(41, true);
        } else {
            this.V[1] = 1;
            this.V[12] = 1;
            GameMidlet.Instance_Game.PlaySound(43, true);
        }
        Game.Status_Show(0);
    }

    boolean checkDamage() {
        int n = (int)(this.y + (long)(this.colBox[1] << 8));
        while ((long)n <= this.y + (long)(this.colBox[3] << 8)) {
            long l = (this.stateFlag & 1) == 0 ? this.x + (long)(this.colBox[0] << 8) : this.x + (long)(this.colBox[2] << 8);
            byte by = this.Actor_GetPHB((int)(l >> 8 >> 3), n >> 8 >> 3);
            if (by == 18) {
                this.anim.newAction = 33;
                GameMidlet.Instance_Game.PlaySound(41, true);
                return true;
            }
            if (by == 29) {
                this.anim.newAction = 32;
                GameMidlet.Instance_Game.PlaySound(45, true);
                return true;
            }
            if (by == 17) {
                this.doDamage();
            }
            if ((by = this.Actor_GetPHB((int)((l = (this.stateFlag & 1) == 0 ? this.x + (long)(this.colBox[2] << 8) : this.x + (long)(this.colBox[0] << 8)) >> 8 >> 3), n >> 8 >> 3)) == 18) {
                this.anim.newAction = 33;
                GameMidlet.Instance_Game.PlaySound(41, true);
                return true;
            }
            if (by == 29) {
                this.anim.newAction = 32;
                GameMidlet.Instance_Game.PlaySound(45, true);
                return true;
            }
            if (by == 17) {
                this.doDamage();
            }
            n += 2048;
        }
        return false;
    }

    boolean Rayman_checkAttachPlatform(Actor actor) {
        if (this.actorReference != null || this.dy < 0) {
            return false;
        }
        int n = (int)(this.x >> 8);
        int n2 = (int)(this.y >> 8) + this.colBox[3];
        int n3 = (int)((long)actor.colBox[0] + (actor.x >> 8));
        int n4 = (int)((long)actor.colBox[1] + (actor.y >> 8));
        int n5 = (int)((long)actor.colBox[2] + (actor.x >> 8));
        int n6 = n4 + 5;
        if (n >= n3 && n < n5 && n2 >= (n4 -= 5) && n2 < n6) {
            this.actorReference = actor;
            this.dy = 0;
            this.dx = 0;
            this.mmodel_vY = 0;
            this.mmodel_vX = 0;
            this.mmodel_aY = 0;
            this.mmodel_aX = 0;
            this.y = actor.y + (long)(actor.colBox[1] - this.colBox[3] << 8) + (long)actor.dy;
            this.anim.newAction = 12;
            if (this.anim.curAction == 9) {
                GameMidlet.Instance_Game.StopSound(42);
            }
            return true;
        }
        return false;
    }

    void Rayman_doPlatform() {
        int n = (int)(this.x >> 8);
        int n2 = (int)((long)this.actorReference.colBox[0] + (this.actorReference.x >> 8));
        int n3 = (int)((long)this.actorReference.colBox[2] + (this.actorReference.x >> 8));
        if (n < n2 || n >= n3) {
            this.anim.newAction = 11;
            if (this.actorReference.dy == 0 && this.actorReference.dx != 0) {
                this.y += (long)(this.actorReference.colBox[3] - this.actorReference.colBox[1] + 2 << 8);
                this.x = (this.stateFlag & 1) == 0 ? (this.x -= 1024L) : (this.x += 1024L);
            }
            this.actorReference = null;
        } else {
            this.y = this.actorReference.y + (long)(this.actorReference.colBox[1] - this.colBox[3] << 8);
            this.dy = this.actorReference.dy;
            this.dx = (short)(this.dx + this.actorReference.dx);
        }
    }

    void Rayman_ai() {
        int n = this.anim.curAction;
        this.V[4] = GameMidlet.Instance_Game.pressedKey;
        this.V[5] = GameMidlet.Instance_Game.releasedKey;
        this.V[3] = GameMidlet.Instance_Game.currentKey;
        if (Game.m_gameFrame_curLevel > 0 && Game.s_iLeftToDie == 0 && (n == 0 || n == 2)) {
            this.V[3] = 0;
            this.V[4] = 0;
            this.V[5] = 0;
            this.anim.newAction = 38;
        }
        if (this.V[12] > 0) {
            this.V[12] = this.V[12] + 1;
            if (this.V[12] == 20) {
                this.V[12] = 0;
            }
            if (this.V[1] > 0) {
                this.V[1] = this.V[1] + 1;
                if (this.V[1] == 20) {
                    this.V[1] = 0;
                }
            }
        }
        if (n == 15 || n == 16 || n == 25 || n == 35) {
            this.V[2] = this.V[2] + 1;
        }
        if (this.Ani_CheckEnd()) {
            switch (n) {
                case 39: 
                case 40: {
                    this.anim.newAction = 0;
                    this.V[10] = 0;
                    break;
                }
                case 27: 
                case 41: 
                case 42: {
                    this.stateFlag = (this.stateFlag & 1) == 0 ? (short)((byte)(1 | this.stateFlag & 0xFFFFFFFA)) : (short)((byte)(0 | this.stateFlag & 0xFFFFFFFA));
                    this.anim.newAction = 27;
                    this.step();
                    break;
                }
                case 34: {
                    this.anim.newAction = 35;
                    break;
                }
                case 23: {
                    this.anim.newAction = 17;
                    break;
                }
                case 36: {
                    if (this.V[7] != 0) {
                        this.anim.newAction = 9;
                        break;
                    }
                    this.anim.newAction = 8;
                    break;
                }
                case 7: 
                case 10: {
                    this.anim.newAction = 8;
                    break;
                }
                case 6: 
                case 12: 
                case 13: {
                    this.anim.newAction = 0;
                    break;
                }
                case 3: {
                    this.anim.newAction = 4;
                    break;
                }
                case 28: {
                    this.anim.newAction = 29;
                    break;
                }
                case 38: {
                    if (Game.m_gameFrame_unlockedLevel <= Game.m_gameFrame_curLevel) {
                        Game.m_gameFrame_unlockedLevel = (byte)(Game.m_gameFrame_curLevel + 1);
                    }
                    Game.GameFrame_PostMessage(2, 0);
                    this.anim.newAction = 0;
                    break;
                }
                case 37: {
                    this.anim.newAction = 0;
                    this.m_lInitX = this.actorReference.x;
                    this.m_lInitY = this.actorReference.y;
                    Game.GameFrame_PostMessage(2, this.actorReference.V[0]);
                    break;
                }
                case 32: 
                case 33: {
                    this.stateFlag = (short)(this.stateFlag | 8);
                    Game.GameFrame_PostMessage(1, 0);
                    return;
                }
                case 15: {
                    this.anim.newAction = 16;
                }
            }
        }
        if ((n == 8 || n == 7) && this.mmodel_vY > 0) {
            this.anim.newAction = 11;
        }
        this.handleKeyEvent();
        this.checkCamera();
        if (this.V[10] > 70) {
            GameMidlet.Instance_Game.Status_ShowLock();
            int n2 = this.V[11];
            this.V[11] = n2 + 1;
            if ((n2 & 1) == 0) {
                boolean bl = false;
                byte by = (this.stateFlag & 1) == 0 ? this.Actor_GetPHB((int)(this.x + (long)this.colBox[0] >> 8 >> 3) - 1, (int)(this.y >> 8 >> 3) + 1) : this.Actor_GetPHB((int)(this.x + (long)this.colBox[2] >> 8 >> 3) + 1, (int)(this.y >> 8 >> 3) + 1);
                if (by == 1) {
                    this.anim.newAction = 39;
                } else {
                    this.anim.newAction = 40;
                    this.V[11] = 0;
                }
            } else {
                this.anim.newAction = 40;
                this.V[11] = 0;
            }
            this.V[10] = 0;
        }
        if (this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10)) {
            this.Rayman_doPlatform();
        }
        if (n == 9 || n == 8 || n == 7 || n == 10 || n == 18 || n == 19) {
            this.checkCeilingAir();
        }
        if (n != 27 && n != 41 && n != 42 && this.checkWall()) {
            this.dx = 0;
        }
        if (n == 27 || n == 41 || n == 42) {
            this.dy = 0;
            this.dx = 0;
        } else if (this.V[15] == 1 || this.checkClimb()) {
            switch (n) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.anim.newAction = 17;
                }
            }
        } else if (this.canHangRoof()) {
            switch (n) {
                case 7: 
                case 8: 
                case 9: 
                case 11: {
                    this.anim.newAction = 30;
                }
            }
        } else {
            switch (n) {
                case 31: {
                    this.anim.newAction = 11;
                    this.y += 1024L;
                    break;
                }
                case 7: 
                case 8: {
                    if (!this.checkCeilingAir()) break;
                    this.anim.newAction = 11;
                }
            }
        }
        if (this.anim.newAction != 8 && this.anim.newAction != 7) {
            if (this.checkFloor()) {
                switch (n) {
                    case 9: 
                    case 10: 
                    case 11: {
                        this.anim.newAction = 12;
                    }
                }
            } else if (this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10)) {
                switch (n) {
                    case 9: 
                    case 28: 
                    case 29: {
                        this.anim.newAction = 12;
                    }
                }
            } else {
                switch (n) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 5: {
                        this.anim.newAction = 11;
                        break;
                    }
                    case 9: {
                        if (this.canHangOnLedge() || this.V[7] != 0 || (this.V[6] = this.V[6] + 1) <= 25) break;
                        this.anim.newAction = 11;
                        this.V[0] = this.V[0] & 0xFFFFFFFD;
                        break;
                    }
                    case 10: 
                    case 11: {
                        this.canHangOnLedge();
                    }
                }
            }
        }
        if (this.anim.newAction == 28 || this.anim.newAction == 12 || this.anim.newAction == 30 || this.anim.newAction == 27 || this.anim.newAction == 41 || this.anim.newAction == 42 || this.anim.newAction == 7 || this.anim.newAction >= 17 && this.anim.newAction <= 22) {
            this.V[0] = this.V[0] | 2;
        }
        if (n != 33 && n != 32) {
            this.checkDamage();
        }
        if (n == 11 && (this.anim.oldAction == 2 || this.anim.oldAction == 0 || this.anim.oldAction == 5 || this.anim.oldAction == 5 || this.anim.oldAction == 4)) {
            if (this.mmodel_vX < 0) {
                this.mmodel_vX = (short)-512;
            } else if (this.mmodel_vX > 0) {
                this.mmodel_vX = (short)512;
            }
        }
        if (this.anim.curAction != this.anim.newAction) {
            this.anim.oldAction = this.anim.curAction;
            if (this.anim.curAction == 9) {
                GameMidlet.Instance_Game.StopSound(42);
            }
            switch (this.anim.newAction) {
                case 16: 
                case 25: 
                case 35: {
                    GameMidlet.Instance_Game.PlaySound(38, true, -1);
                    break;
                }
                case 9: {
                    if (Game.pRayman.V[7] == -1) break;
                    GameMidlet.Instance_Game.PlaySound(42, true, -1);
                    break;
                }
                case 11: {
                    if (this.anim.curAction == 7 || this.anim.curAction == 8) break;
                    this.V[16] = (int)(this.y >> 8);
                    if (this.mmodel_vX < 0) {
                        this.mmodel_vX = (short)-768;
                        break;
                    }
                    if (this.mmodel_vX <= 0) break;
                    this.mmodel_vX = (short)768;
                    break;
                }
                case 7: {
                    GameMidlet.Instance_Game.PlaySound(44, true);
                    break;
                }
                case 10: 
                case 13: 
                case 23: 
                case 36: {
                    GameMidlet.Instance_Game.PlaySound(39, true);
                    break;
                }
                case 3: {
                    GameMidlet.Instance_Game.PlaySound(40, false);
                    break;
                }
            }
        }
    }

    void ai() {
        switch (this.objType) {
            case 15: 
            case 16: {
                this.SeaUrchin_ai();
                break;
            }
            case 17: {
                this.Bomb_ai();
                break;
            }
            case 0: {
                this.Rayman_ai();
                break;
            }
            case 1: {
                this.Fist_ai();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 24: {
                this.Bonus_ai();
                break;
            }
            case 12: {
                this.Cage_ai();
                break;
            }
            case 6: {
                this.LevelSign_ai();
                break;
            }
            case 22: {
                this.Pirate_ai();
                break;
            }
            case 25: {
                this.Bullet_ai();
                break;
            }
            case 18: {
                this.Fly_ai();
                break;
            }
            case 19: {
                this.Tentacle_ai();
                break;
            }
            case 7: {
                this.LevelPost_ai();
                break;
            }
            case 10: 
            case 11: {
                this.Platform_ai();
            }
        }
    }

    public void Actor_Reset() {
        if (this.objType == 27 || this.objType == 12 || this.objType == 9 || this.objType == 25 || this.objType == 26 || this.objType == 2) {
            return;
        }
        this.x = this.m_lInitX;
        this.y = this.m_lInitY;
        this.anim.newAction = this.m_iInitAction;
        this.stateFlag = this.m_sInitStateFlag;
        if (this.m_iInitV != null) {
            System.arraycopy(this.m_iInitV, 0, this.V, 0, this.V.length);
        }
        this.dx = 0;
        this.dy = 0;
        this.m_sPHBTableReferenceTileX = (short)-10;
        this.m_sPHBTableReferenceTileY = (short)-10;
        if (this.m_bPHBTable != null) {
            for (int i = 0; i < this.m_bPHBTable.length; ++i) {
                for (int j = 0; j < this.m_bPHBTable[i].length; ++j) {
                    this.m_bPHBTable[i][j] = 0;
                }
            }
        }
        if (this.objType == 0) {
            if (Game.s_actorCheckpoint != null) {
                this.x = Game.s_actorCheckpoint.x;
                this.y = Game.s_actorCheckpoint.y;
                this.stateFlag = (byte)(1 | this.stateFlag & 0xFFFFFFFA);
                this.xDirectionConfirmed = true;
            }
            this.xDirectionConfirmed = (this.stateFlag & 1) != 0;
            Game.pFist.anim.curAction = 0;
            this.xDirectionConfirmationCounter = this.xDirectionConfirmed ? 2 : -2;
        }
    }

    void Actor_SetReferencePoint(int n, int n2) {
        short s = (short)(n - this.m_sPHBTableReferenceTileX);
        short s2 = (short)(n2 - this.m_sPHBTableReferenceTileY);
        short s3 = -this.m_sTableRefIndexX;
        int n3 = this.m_bPHBTable[0].length - 1 - this.m_sTableRefIndexX;
        short s4 = -this.m_sTableRefIndexY;
        int n4 = this.m_bPHBTable.length - 1 - this.m_sTableRefIndexY;
        if (s < 0) {
            if (s2 < 0) {
                int n5 = this.m_bPHBTable.length - 1;
                for (int i = n2 + n4; i >= n2 + s4; --i) {
                    int n6 = this.m_bPHBTable[n5].length - 1;
                    for (int j = n + n3; j >= n + s3; --j) {
                        this.m_bPHBTable[n5][n6] = this.Actor_GetPHB(j, i);
                        --n6;
                    }
                    --n5;
                }
            } else {
                int n7 = 0;
                for (int i = n2 + s4; i <= n2 + n4; ++i) {
                    int n8 = this.m_bPHBTable[n7].length - 1;
                    for (int j = n + n3; j >= n + s3; --j) {
                        this.m_bPHBTable[n7][n8] = this.Actor_GetPHB(j, i);
                        --n8;
                    }
                    ++n7;
                }
            }
        } else if (s2 < 0) {
            int n9 = this.m_bPHBTable.length - 1;
            for (int i = n2 + n4; i >= n2 + s4; --i) {
                int n10 = 0;
                for (int j = n + s3; j <= n + n3; ++j) {
                    this.m_bPHBTable[n9][n10] = this.Actor_GetPHB(j, i);
                    ++n10;
                }
                --n9;
            }
        } else {
            int n11 = 0;
            for (int i = n2 + s4; i <= n2 + n4; ++i) {
                int n12 = 0;
                for (int j = n + s3; j <= n + n3; ++j) {
                    this.m_bPHBTable[n11][n12] = this.Actor_GetPHB(j, i);
                    ++n12;
                }
                ++n11;
            }
        }
        this.m_sPHBTableReferenceTileX = (short)n;
        this.m_sPHBTableReferenceTileY = (short)n2;
    }

    byte Actor_GetPHB(int n, int n2) {
        if (this.m_bPHBTable != null && n >= this.m_sPHBTableReferenceTileX + -this.m_sTableRefIndexX && n <= this.m_sPHBTableReferenceTileX + (this.m_bPHBTable[0].length - 1 - this.m_sTableRefIndexX) && n2 >= this.m_sPHBTableReferenceTileY + -this.m_sTableRefIndexY && n2 <= this.m_sPHBTableReferenceTileY + (this.m_bPHBTable.length - 1 - this.m_sTableRefIndexY)) {
            return this.m_bPHBTable[n2 - this.m_sPHBTableReferenceTileY + this.m_sTableRefIndexY][n - this.m_sPHBTableReferenceTileX + this.m_sTableRefIndexX];
        }
        return GameMidlet.Instance_Game.PF_getPHBI(n, n2);
    }

    boolean Actor_Death() {
        if (this.objType != 7) {
            this.stateFlag = (short)(this.stateFlag | 8);
        } else if (Game.s_iLeftToDie != 1) {
            return false;
        }
        if ((this.stateFlag & 2) != 0) {
            --Game.s_iLeftToDie;
        }
        return true;
    }

    void checkCamera() {
        if (this.anim.curAction != 8 && this.anim.curAction != 7 && (this.anim.curAction != 11 && this.anim.curAction != 10 || this.y >> 8 > (long)this.V[16]) && (this.anim.curAction != 9 || this.V[7] == -1 || this.y >> 8 > (long)this.V[16])) {
            if (this.yDirectionConfirmed == 0) {
                if (this.dy < 0) {
                    --this.yDirectionConfirmationCounter;
                } else if (this.dy > 0) {
                    ++this.yDirectionConfirmationCounter;
                }
                if (this.yDirectionConfirmationCounter > 4) {
                    this.yDirectionConfirmed = 1;
                } else if (this.yDirectionConfirmationCounter < -4) {
                    this.yDirectionConfirmed = -1;
                }
            } else if (this.yDirectionConfirmed == 1) {
                if (this.dy < 0) {
                    --this.yDirectionConfirmationCounter;
                }
                if (this.yDirectionConfirmationCounter < -1) {
                    this.yDirectionConfirmed = -1;
                }
            } else if (this.yDirectionConfirmed == -1) {
                if (this.dy > 0) {
                    ++this.yDirectionConfirmationCounter;
                }
                if (this.yDirectionConfirmationCounter > 1) {
                    this.yDirectionConfirmed = 1;
                }
            }
        }
        if (this.xDirectionConfirmed) {
            if (this.dx < 0 || this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10) && this.actorReference.dx < 0) {
                --this.xDirectionConfirmationCounter;
            }
            if (this.xDirectionConfirmationCounter < -1) {
                this.xDirectionConfirmed = false;
            }
        } else {
            if (this.dx > 0 || this.actorReference != null && (this.actorReference.objType == 11 || this.actorReference.objType == 10) && this.actorReference.dx > 0) {
                ++this.xDirectionConfirmationCounter;
            }
            if (this.xDirectionConfirmationCounter > 1) {
                this.xDirectionConfirmed = true;
            }
        }
        if (this.anim.curAction == 16 || this.anim.curAction == 35 || this.anim.curAction == 34 || this.anim.curAction == 10 || this.anim.curAction == 25 || this.anim.curAction == 24 || this.anim.curAction == 23) {
            this.xDirectionConfirmed = (this.stateFlag & 1) != 0;
            this.xDirectionConfirmationCounter = this.xDirectionConfirmed ? 4 : -4;
        }
        if (Game.pFist.anim.curAction != 0) {
            if (Game.pFist.x < this.x) {
                this.xDirectionConfirmed = false;
                this.xDirectionConfirmationCounter = -4;
            } else if (Game.pFist.x > this.x) {
                this.xDirectionConfirmed = true;
                this.xDirectionConfirmationCounter = 4;
            }
        }
    }
}

