/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Utilities
implements DMC2DConstants {
    private static final int FONT_SPACING = 1;
    private static final int FONT_SPACE = 4;
    public static final int FONT_TITLE = 0;
    public static final int FONT_SMALL = 1;
    public static final int FONT_SMALL_SPECIAL = 2;
    public static final int FONT_COUNT = 3;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_ALT = 3;
    private static final String[] fontFiles = new String[]{"title", "small", "small_sp"};
    private static Image[] fontImage;
    private static String[] fontCharMap;
    private Boolean[] fontMixedCase;
    private static byte[][] fontCharWidths;
    private static short[][] fontCharX;
    private static long[] crcTable;
    private static boolean crcTableComputed;
    public static final int FONT_LINE_WIDTH = 123;
    private static String[] titleString;
    private static String[] buffer;
    public static final int ARROW_UP = 0;
    public static final int ARROW_DOWN = 1;
    public static final int ARROW_LEFT = 2;
    public static final int ARROW_RIGHT = 3;

    public static final void drawString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == 0) {
            string = Utilities.textPrepareTitleString(string);
        }
        int n7 = 0;
        int n8 = 0;
        ++n2;
        try {
            if (n4 == 1 || n4 == 8) {
                n7 = Utilities.stringWidth(string, n5);
                if (n4 == 1) {
                    n += n3 / 2 - n7 / 2;
                } else if (n4 == 8) {
                    n -= n7;
                }
            }
            int n9 = n5;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                n9 = n5;
                if (Utilities.isSpecialChar(c) && n5 != 0) {
                    ++n9;
                }
                int n10 = fontCharMap[n9].indexOf(c);
                if (c == ' ' || c == '\u00a0') {
                    n8 += 4;
                    continue;
                }
                if (n10 < 0) continue;
                if (n5 == 0) {
                    DMC2DCanvas.drawRegion(graphics, fontImage[n9 + n6], fontCharX[n9][n10], 0, fontCharWidths[n9][n10], fontImage[n9 + n6].getHeight(), 0, n + n8, n2, 20);
                    n8 += fontCharWidths[n9][n10] + (n5 == 0 ? (byte)0 : 1);
                    continue;
                }
                DMC2DCanvas.drawRegion(graphics, fontImage[n9 + n6], fontCharX[n9][n10] % 123, 0 + fontCharX[n9][n10] / 123 * 8, fontCharWidths[n9][n10], 8, 0, n + n8, n2, 20);
                n8 += fontCharWidths[n9][n10] + (n5 == 0 ? (byte)0 : 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String textPrepareTitleString(String string) {
        if (titleString[0] != null && titleString[0].equals(string)) {
            return titleString[1];
        }
        Utilities.titleString[0] = string;
        string = string.replace('\u00c8', 'E');
        string = string.replace('\u00c9', 'E');
        string = string.replace('\u00d9', 'U');
        string = string.replace('\u00c0', 'A');
        string = string.replace('\u00dc', 'U');
        string = string.replace('\u00da', 'U');
        string = string.replace('\u00d6', 'O');
        string = string.replace('\u00d3', 'O');
        string = string.replace('\u00c1', 'A');
        string = string.replace('!', ' ');
        string = string.replace('\u00a1', ' ');
        string = string.replace('?', ' ');
        Utilities.titleString[1] = string = string.replace('\u00bf', ' ');
        return string;
    }

    private static final boolean needsWrapping(String string, int n, int n2, int n3) {
        return Utilities.stringWidth(string, n3) >= n2 - n;
    }

    public static final int drawStringWrapped(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 1;
        if (Utilities.needsWrapping(string, n, n3, n5)) {
            String[] stringArray = Utilities.splitString(string, n3 - n, n5);
            for (int i = 0; i < stringArray.length; ++i) {
                Utilities.drawString(graphics, stringArray[i], n, n2 + i * n7, n3, n4, n5, n6);
            }
            n8 = stringArray.length;
        } else {
            Utilities.drawString(graphics, string, n, n2, n3, n4, n5, n6);
        }
        return n8;
    }

    public void init() {
        try {
            fontImage = new Image[6];
            fontCharMap = new String[3];
            this.fontMixedCase = new Boolean[3];
            fontCharWidths = new byte[3][];
            fontCharX = new short[3][];
            Utilities.fontImage[0] = Image.createImage((String)("/" + fontFiles[0] + ".png"));
            Utilities.fontImage[1] = Image.createImage((String)("/" + fontFiles[1] + ".png"));
            Utilities.fontImage[2] = Image.createImage((String)("/" + fontFiles[2] + ".png"));
            Utilities.fontImage[4] = this.createFontWithColourOrBrightness(1, 0x868686, 0);
            Utilities.fontImage[5] = this.createFontWithColourOrBrightness(2, 0x868686, 0);
            this.addBMF(0);
            this.addBMF(1);
            this.addBMF(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Image createFontWithColourOrBrightness(int n, int n2, int n3) {
        Image image = null;
        try {
            int n4;
            byte[] byArray = this.getImageAsBytes("/" + fontFiles[n] + ".png");
            int n5 = 0;
            for (n4 = 0; n4 < byArray.length; ++n4) {
                if (byArray[n4] != 80 || byArray[n4 + 1] != 76 || byArray[n4 + 2] != 84 || byArray[n4 + 3] != 69) continue;
                n5 = n4 + 4 + 3;
            }
            if (n3 == 0) {
                byArray[n5] = (byte)(n2 >> 16 & 0xFF);
                byArray[n5 + 1] = (byte)(n2 >> 8 & 0xFF);
                byArray[n5 + 2] = (byte)(n2 & 0xFF);
            } else {
                n4 = Utilities.getPaletteEntryCount(byArray, n5 - 8 - 3);
                for (int i = n5; i < n5 + (n4 - 3); ++i) {
                    int n6 = byArray[i];
                    if (n6 > 0) {
                        if ((n6 = (byte)(n6 - n3)) < 0) {
                            n6 = 0;
                        }
                    } else if ((n6 = (byte)(n6 - n3)) < -128) {
                        n6 += 256;
                    }
                    byArray[i] = (byte)n6;
                }
            }
            Utilities.updatePNGCRC(byArray, n5 - 8 - 3);
            image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    private void setAltFontColour(int n) {
        Utilities.fontImage[5] = null;
        System.gc();
        Utilities.fontImage[4] = this.createFontWithColourOrBrightness(1, n, 0);
        Utilities.fontImage[5] = this.createFontWithColourOrBrightness(2, n, 0);
    }

    private void addBMF(int n) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/" + fontFiles[n] + ".bmf");
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.fontMixedCase[n] = new Boolean(dataInputStream.readBoolean());
            Utilities.fontCharMap[n] = dataInputStream.readUTF();
            int n2 = fontCharMap[n].length();
            Utilities.fontCharWidths[n] = new byte[n2];
            Utilities.fontCharX[n] = new short[n2];
            short s = 0;
            for (int i = 0; i < n2; ++i) {
                Utilities.fontCharWidths[n][i] = dataInputStream.readByte();
                Utilities.fontCharX[n][i] = s;
                s = (short)(s + fontCharWidths[n][i]);
            }
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int stringWidth(String string) {
        return Utilities.stringWidth(string, 1);
    }

    public static int stringWidth(String string, int n) {
        int n2 = 0;
        char c = ' ';
        try {
            if (string.startsWith("[alt]") || string.startsWith("[scr]")) {
                string = string.substring(5);
            }
            for (int i = 0; i < string.length(); ++i) {
                c = string.charAt(i);
                if (c == ' ' || c == '\u00a0') {
                    n2 += 4;
                    continue;
                }
                if (Utilities.isSpecialChar(c) && n != 0) {
                    n2 += fontCharWidths[n + 1][fontCharMap[n + 1].indexOf(c)] + (n == 0 ? (byte)0 : 1);
                    continue;
                }
                n2 += fontCharWidths[n][fontCharMap[n].indexOf(c)] + (n == 0 ? (byte)0 : 1);
            }
            n2 -= n == 0 ? 0 : 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    public static final String[] splitString(String string, int n, int n2) {
        String[] stringArray = null;
        try {
            if (string == null || string.equals("")) {
                return null;
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            buffer = new String[128];
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ' ' && string.charAt(i) != '\n' && string.charAt(i) != '$') continue;
                if (string.charAt(i) == '\n' || string.charAt(i) == '$') {
                    if (Utilities.stringWidth(string.substring(n4, i), n2) >= n) {
                        Utilities.buffer[n5++] = string.substring(n4, n3);
                        n4 = n3 + 1;
                    }
                    Utilities.buffer[n5++] = string.substring(n4, i);
                    n4 = i + 1;
                    n3 = i;
                    continue;
                }
                if (Utilities.stringWidth(string.substring(n4, i), n2) >= n) {
                    Utilities.buffer[n5++] = string.substring(n4, n3);
                    n4 = n3 + 1;
                    n3 = i;
                    continue;
                }
                n3 = i;
            }
            if (Utilities.stringWidth(string.substring(n4, string.length() - 1), n2) >= n) {
                Utilities.buffer[n5++] = string.substring(n4, n3);
                n4 = n3 + 1;
            }
            Utilities.buffer[n5++] = string.substring(n4);
            stringArray = new String[n5];
            System.arraycopy(buffer, 0, stringArray, 0, stringArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public static final String[] splitString(String[] stringArray, int n, int n2) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            string = string + stringArray[i] + (i == stringArray.length - 1 ? "" : "\n");
        }
        return Utilities.splitString(string, n, n2);
    }

    public static final int lineCount(String string, int n, int n2, int n3) {
        if (Utilities.needsWrapping(string, n, n2, n3)) {
            return Utilities.splitString(string, n2 - n, n3).length;
        }
        return 1;
    }

    private static boolean isSpecialChar(char c) {
        return !(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z') && (c < 'a' || c > 'z');
    }

    public Image createImageWithColourEffect(String string, int n, int n2, int n3, boolean bl) {
        Image image = null;
        try {
            byte[] byArray = this.getImageAsBytes(string);
            image = this.createImageWithColourEffect(byArray, n, n2, n3, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public Image createImageWithColourEffect(byte[] byArray, int n, int n2, int n3, boolean bl) {
        Image image = null;
        try {
            int n4;
            int n5 = 0;
            for (n4 = 0; n4 < byArray.length; ++n4) {
                if (byArray[n4] != 80 || byArray[n4 + 1] != 76 || byArray[n4 + 2] != 84 || byArray[n4 + 3] != 69) continue;
                n5 = n4 + 4 + 3;
            }
            n4 = Utilities.getPaletteEntryCount(byArray, n5 - 8 - 3);
            boolean bl2 = n != 0 || n2 != 0 || n3 != 0;
            for (int i = n5; i < n5 + (n4 - 3); i += 3) {
                if (bl) {
                    byte by;
                    byArray[i] = by = (byte)(((byArray[i] & 0xFF) + (byArray[i + 1] & 0xFF) + (byArray[i + 2] & 0xFF)) / 3);
                    byArray[i + 1] = by;
                    byArray[i + 2] = by;
                }
                if (!bl2) continue;
                byArray[i] = Utilities.clipByte((byArray[i] & 0xFF) + n);
                byArray[i + 1] = Utilities.clipByte((byArray[i + 1] & 0xFF) + n2);
                byArray[i + 2] = Utilities.clipByte((byArray[i + 2] & 0xFF) + n3);
            }
            Utilities.updatePNGCRC(byArray, n5 - 8 - 3);
            image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public Image getImageWithPalette(String string, String string2) {
        Image image = null;
        try {
            byte[] byArray = this.getImageBytesWithPalette(string, string2);
            image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (Exception exception) {
            Utilities.printException("getImageWithPalette: " + exception);
        }
        return image;
    }

    public byte[] getImageBytesWithPalette(String string, String string2) {
        byte[] byArray = this.getImageAsBytes(string);
        byte[] byArray2 = null;
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(string2));
            int n = 45;
            byArray2 = new byte[n];
            dataInputStream.read(byArray2);
            int n2 = byArray2[0] & 0xFF;
            int n3 = byArray2[1] & 0xFF;
            int n4 = n2;
            int n5 = 2;
            while (n4 < n2 + n3 * 3 + 4) {
                byArray[n4] = byArray2[n5];
                ++n4;
                ++n5;
            }
        }
        catch (Exception exception) {
            Utilities.printException("getImageWithPalette: " + exception);
        }
        if (dataInputStream != null) {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {
                Utilities.printException("getImageWithPalette - close stream: " + iOException);
            }
        }
        return byArray;
    }

    private final byte[] getImageAsBytes(String string) {
        byte[] byArray = null;
        byte[] byArray2 = new byte[256];
        try {
            int n;
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    private static final int getPaletteEntryCount(byte[] byArray, int n) {
        byte[] byArray2 = new byte[4];
        for (int i = 0; i < 4; ++i) {
            byArray2[i] = byArray[n + i];
        }
        return Utilities.byteArrayToInt(byArray2);
    }

    private static final void updatePNGCRC(byte[] byArray, int n) {
        try {
            int n2;
            byte[] byArray2 = new byte[4];
            for (n2 = 0; n2 < 4; ++n2) {
                byArray2[n2] = byArray[n + n2];
            }
            n2 = Utilities.byteArrayToInt(byArray2) / 3;
            byte[] byArray3 = Utilities.getCRC(byArray, n + 4, n + 8 + n2 * 3);
            for (int i = 0; i < 4; ++i) {
                byArray[n + 8 + n2 * 3 + i] = byArray3[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void makeCRCTable() {
        for (int i = 0; i < 256; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                if ((l & 1L) != 0L) {
                    l = 0xEDB88320L ^ l >> 1;
                    continue;
                }
                l >>= 1;
            }
            Utilities.crcTable[i] = l;
        }
        crcTableComputed = true;
    }

    private static final long generateCRC(long l, byte[] byArray, int n, int n2) {
        long l2 = l;
        if (!crcTableComputed) {
            Utilities.makeCRCTable();
        }
        for (int i = n; i < n2; ++i) {
            l2 = crcTable[(int)((l2 ^ (long)byArray[i]) & 0xFFL)] ^ l2 >> 8;
        }
        return l2;
    }

    private static final byte[] getCRC(byte[] byArray, int n, int n2) {
        long l = Utilities.generateCRC(0xFFFFFFFFL, byArray, n, n2) ^ 0xFFFFFFFFL;
        byte[] byArray2 = new byte[4];
        byArray2[3] = (byte)l;
        byArray2[2] = (byte)(l >> 8);
        byArray2[1] = (byte)(l >> 16);
        byArray2[0] = (byte)(l >> 24);
        return byArray2;
    }

    public static void drawArrow(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        try {
            graphics.setColor(n5);
            int n6 = 1;
            int n7 = 3;
            if (n3 == 0) {
                for (int i = 0; i < n4; ++i) {
                    graphics.fillRect(n + n7, n2 + i, n6, 1);
                    n6 += 2;
                    --n7;
                }
            } else if (n3 == 1) {
                for (int i = n4 - 1; i >= 0; --i) {
                    graphics.fillRect(n + n7, n2 + i, n6, 1);
                    n6 += 2;
                    --n7;
                }
            } else if (n3 == 2) {
                for (int i = 0; i < n4; ++i) {
                    graphics.fillRect(n + i, n2 + n7 - 3, 1, n6);
                    n6 += 2;
                    --n7;
                }
            } else if (n3 == 3) {
                for (int i = n4; i > 0; --i) {
                    graphics.fillRect(n + i, n2 + n7 - 3, 1, n6);
                    n6 += 2;
                    --n7;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawGradientRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n5 != -1) {
            graphics.setColor(n5);
            graphics.fillRect(n, n2 + 1, n3, n4 - 2);
        } else {
            Utilities.fillGradientRect2(graphics, n, n2 + 1, n3, n4 - 2);
        }
        int n6 = n3 / 2 / 15;
        graphics.setColor(90, 90, 90);
        graphics.fillRect(n, n2, 1, n4);
        graphics.fillRect(n + n3 - 1, n2, 1, n4);
        int n7 = 90;
        for (int i = 1; i < n3; i += n6) {
            if (i + n6 > n3) {
                n6 = n3 - i;
            }
            n7 = i < n3 / 2 ? (n7 += 11) : (n7 -= 11);
            if (n7 < 90) {
                n7 = 90;
            }
            if (n7 > 255) {
                n7 = 255;
            }
            graphics.setColor(n7, n7, n7);
            graphics.fillRect(n + i, n2, n6, 1);
            graphics.fillRect(n + i, n2 + n4 - 1, n6, 1);
        }
    }

    public static void fillGradientRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 2;
        int n6 = 40;
        for (int i = n; i <= n + n3; i += n5) {
            if ((n6 += n5) > 255) {
                n6 = 255;
            }
            graphics.setColor(n6, 0, 0);
            graphics.fillRect(i, n2, n5, n4);
        }
    }

    public static void fillGradientRect2(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 2;
        int n6 = 40;
        for (int i = n; i <= n + n3 / 2; i += n5) {
            if ((n6 += n5) > 255) {
                n6 = 255;
            }
            graphics.setColor(n6, 0, 0);
            graphics.fillRect(i, n2, n5, n4);
            graphics.fillRect(n3 - i, n2, n5, n4);
        }
    }

    public static void blend(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray.length;
        for (int i = 0; i < n4; ++i) {
            int n5 = 0;
            int n6 = nArray[i] & 0xFFFFFF;
            if (n2 == n6) {
                n5 = 0;
            } else if (n3 == n6) {
                n5 = 255;
            } else if (n > 0) {
                n5 = n;
            }
            nArray[i] = n6 += (n5 <<= 24);
        }
    }

    public static void blend(int[] nArray, int n) {
        Utilities.blend(nArray, n, -1, -1);
    }

    public static int getBlendedColor(int n, int n2, int n3, int n4) {
        int n5 = (((n & 0xFF0000) >> 16) * n3 + ((n2 & 0xFF0000) >> 16) * (n4 - n3)) / n4;
        int n6 = (((n & 0xFF00) >> 8) * n3 + ((n2 & 0xFF00) >> 8) * (n4 - n3)) / n4;
        int n7 = (((n & 0xFF) >> 0) * n3 + ((n2 & 0xFF) >> 0) * (n4 - n3)) / n4;
        return n5 << 16 | n6 << 8 | n7;
    }

    public static final byte clipByte(int n) {
        return (byte)(n > 0 ? (n <= 255 ? n : 255) : 0);
    }

    public static final int byteArrayToInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = (3 - i) * 8;
            n += (byArray[i] & 0xFF) << n2;
        }
        return n;
    }

    public static void printException(String string) {
    }

    public static final void p(String string) {
    }

    static {
        crcTable = new long[256];
        crcTableComputed = false;
        titleString = new String[2];
    }
}

