/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class DMC2DSound {
    public byte volume = (byte)60;
    public boolean enabled = true;
    public byte nextSound = (byte)-1;
    private byte lastSound = (byte)-1;
    public byte suspendedSound = (byte)-1;
    private static Player soundPlayer;
    private DMC2DCanvas canvas;
    boolean forcePlay;
    boolean suspended;

    DMC2DSound(DMC2DCanvas dMC2DCanvas) {
        this.canvas = dMC2DCanvas;
    }

    public void setBGM(byte by) {
        this.nextSound = by;
    }

    public void playCuedBGM() {
        if (this.nextSound != -1) {
            this.playBGM(this.nextSound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playBGM(byte by) {
        if (by == this.lastSound && soundPlayer != null && soundPlayer.getState() == 400) {
            return;
        }
        this.prepareSound(by);
        this.forcePlay = false;
        this.lastSound = by;
        try {
            soundPlayer.setLoopCount(99);
            soundPlayer.start();
            for (int i = 0; i < 3 && soundPlayer.getState() != 400; ++i) {
                Thread.sleep(1L);
            }
            if (soundPlayer.getState() != 400) {
                this.forcePlay = true;
                this.setBGM(this.lastSound);
            } else {
                this.nextSound = (byte)-1;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.suspendedSound = (byte)-1;
        }
    }

    public void suspend() {
        if (soundPlayer != null && soundPlayer.getState() == 400) {
            this.suspendedSound = this.lastSound;
            this.suspended = true;
            this.stopSound();
            soundPlayer.deallocate();
        }
        this.nextSound = (byte)-1;
    }

    public void resume() {
        if (soundPlayer != null && this.suspendedSound != -1) {
            this.setBGM(this.suspendedSound);
        }
    }

    public void stopSound() {
        try {
            if (soundPlayer != null && soundPlayer.getState() == 400) {
                soundPlayer.stop();
                for (int i = 0; i < 10 && soundPlayer.getState() == 400; ++i) {
                    Thread.sleep(1L);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean prepareSound(byte by) {
        try {
            this.stopSound();
            Thread.sleep(1L);
            if (this.suspended || by != this.lastSound) {
                this.suspended = false;
                if (soundPlayer != null) {
                    soundPlayer.close();
                    soundPlayer = null;
                }
                soundPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/s" + by + ".mid"), (String)"audio/midi");
                soundPlayer.realize();
                for (int i = 0; i < 10 || soundPlayer.getState() != 200; ++i) {
                    Thread.sleep(1L);
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

