/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DMC2DMap
implements DMC2DConstants {
    DMC2DCanvas canvas;
    Image tileSet;
    Image backBuffer;
    byte[][] map;
    byte[][] items;
    byte screenCount;
    public byte[][][] spawnSites;
    public boolean[] roomLocks;
    public byte startLock;
    public byte endLock;
    public byte currentScreen;

    DMC2DMap(DMC2DCanvas dMC2DCanvas) {
        this.canvas = dMC2DCanvas;
    }

    public void setMap(byte[][] byArray) {
        try {
            this.map = byArray;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setItems(byte[][] byArray) {
        try {
            this.items = byArray;
            this.screenCount = (byte)this.items.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getEnemySetForRoomSection() {
        int n = 0;
        for (int i = this.startLock; i < this.endLock; ++i) {
            block7: for (int n2 = 0; n2 < 6; n2 = (int)((byte)(n2 + 1))) {
                if (this.spawnSites[i][n2] == null) continue;
                switch (this.spawnSites[i][n2][0]) {
                    case 1: {
                        n |= 1;
                        continue block7;
                    }
                    case 3: {
                        n |= 4;
                        continue block7;
                    }
                    case 2: {
                        n |= 2;
                        continue block7;
                    }
                    case 6: {
                        n |= 0x10;
                    }
                }
            }
        }
        return n;
    }

    public void initMap() {
        try {
            this.backBuffer = Image.createImage((int)32, (int)64);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image createBackground() {
        int n;
        Graphics graphics = this.backBuffer.getGraphics();
        for (n = 2; n < 34; ++n) {
            DMC2DCanvas.drawRegion(graphics, this.tileSet, (this.map[this.currentScreen][n] & 0x3F) % 6 * 8, (this.map[this.currentScreen][n] & 0x3F) / 6 * 8, 8, 8, this.getTransform(this.map[this.currentScreen][n]), (n - 2) % 4 * 8, (n - 2) / 4 * 8, 20);
        }
        if (this.map[this.currentScreen][0] > 0) {
            for (int i = n = 34; i < n + this.map[this.currentScreen][0] * 2; i += 2) {
                int n2 = this.map[this.currentScreen][i] & 0xFF;
                DMC2DCanvas.drawRegion(graphics, this.tileSet, (this.map[this.currentScreen][i + 1] & 0x3F) % 6 * 8, (this.map[this.currentScreen][i + 1] & 0x3F) / 6 * 8, 8, 8, this.getTransform(this.map[this.currentScreen][i + 1]), n2 % 4 * 8, n2 / 4 * 8, 20);
            }
        }
        return this.backBuffer;
    }

    public void paintBackground(Graphics graphics, int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            graphics.drawImage(this.backBuffer, n + i * 32, n2, 20);
        }
        graphics.setColor(0x585858);
        graphics.fillRect(n, n2 + 64, 128, 64);
    }

    public void setMapObjects(DMC2DCharacter[] dMC2DCharacterArray) {
        int n = 6;
        int n2 = 23;
        this.spawnSites = new byte[this.screenCount][6][4];
        this.roomLocks = new boolean[this.screenCount];
        this.map = new byte[this.screenCount][];
        for (int i = 0; i < this.items.length; ++i) {
            int n3 = 0;
            if (this.items[i] == null || this.items[i].length == 0) continue;
            for (int j = 0; j < this.items[i].length; j += 2) {
                int n4;
                int n5;
                int n6 = this.items[i][j] & 0xFF;
                int n7 = this.items[i][j + 1] & 0xFF;
                if (n7 == 11) {
                    this.roomLocks[i] = true;
                    continue;
                }
                if (n7 >= 3 && n7 <= 6) {
                    dMC2DCharacterArray[n2] = new DMC2DCharacter(this.canvas);
                    n5 = n6 % 16;
                    n4 = n6 / 16;
                    dMC2DCharacterArray[n2].x = n5 * 15 + i * 240;
                    if (n4 >= 8) {
                        dMC2DCharacterArray[n2].y = 0;
                        dMC2DCharacterArray[n2].z = (n4 - 8) * 15;
                    } else {
                        dMC2DCharacterArray[n2].y = (8 - n4) * 15 * 2;
                        dMC2DCharacterArray[n2].z = 0;
                    }
                    dMC2DCharacterArray[n2].type = (byte)(10 + (n7 - 3));
                    dMC2DCharacterArray[n2].alive = true;
                    ++this.canvas.idCounter;
                    dMC2DCharacterArray[n2].id = dMC2DCharacterArray[n2].id;
                    dMC2DCharacterArray[n2].life = dMC2DCharacterArray[n2].type > 10 ? (byte)2 : (byte)1;
                    ++n2;
                    continue;
                }
                if (n7 == 1 || n7 == 2) {
                    dMC2DCharacterArray[n] = new DMC2DCharacter(this.canvas);
                    n5 = n6 % 16;
                    n4 = n6 / 16;
                    dMC2DCharacterArray[n].x = n5 * 15 + i * 240 + 4;
                    if (n4 >= 8) {
                        dMC2DCharacterArray[n].y = 0;
                        dMC2DCharacterArray[n].z = (n4 - 8) * 15;
                    } else {
                        dMC2DCharacterArray[n].y = (8 - n4) * 15 * 2;
                        dMC2DCharacterArray[n].z = 0;
                    }
                    if (n7 == 1) {
                        dMC2DCharacterArray[n].type = (byte)8;
                        dMC2DCharacterArray[n].orbValue = (byte)5;
                    } else {
                        dMC2DCharacterArray[n].type = (byte)9;
                        dMC2DCharacterArray[n].orbValue = (byte)100;
                    }
                    dMC2DCharacterArray[n].alive = true;
                    ++this.canvas.idCounter;
                    dMC2DCharacterArray[n].id = dMC2DCharacterArray[n].id;
                    dMC2DCharacterArray[n].anim = 1;
                    ++n;
                    continue;
                }
                if (n7 < 14) continue;
                n5 = 0;
                n4 = 0;
                int n8 = 0;
                if (n7 >= 155) {
                    n5 = 2;
                    n4 = (n7 - 155) / 15;
                    n8 = n7 - 155 - n4 * 15 + 1;
                } else if (n7 >= 65) {
                    n5 = 3;
                    n4 = (n7 - 65) / 15;
                    n8 = n7 - 65 - n4 * 15 + 1;
                } else if (n7 >= 20) {
                    n5 = 1;
                    n4 = (n7 - 20) / 15;
                    n8 = n7 - 20 - n4 * 15 + 1;
                } else if (n7 >= 14) {
                    n5 = 6;
                    n8 = 1;
                    n4 = n7 - 14;
                }
                if (n8 == 15) {
                    n8 = 127;
                }
                if (n3 >= 6) continue;
                this.spawnSites[i][n3][0] = n5;
                this.spawnSites[i][n3][1] = (byte)n8;
                this.spawnSites[i][n3][2] = this.items[i][j];
                this.spawnSites[i][n3][3] = (byte)n4;
                ++n3;
            }
        }
        this.endLock = 0;
        this.setNextLocks();
    }

    public void setTileMap() {
        int n;
        for (n = 0; n < this.screenCount; ++n) {
            this.map[n] = null;
        }
        for (n = this.startLock; n < this.endLock; ++n) {
            this.map[n] = this.canvas.ioLoadMap("/m" + this.canvas.room[2 + n]);
        }
    }

    private int getTransform(byte by) {
        int n = 0;
        if ((by & 0x40) != 0 && (by & 0x80) != 0) {
            n = 3;
        } else if ((by & 0x40) != 0) {
            n = 2;
        } else if ((by & 0x80) != 0) {
            n = 1;
        }
        return n;
    }

    public byte[][] getSpawnSites() {
        return this.spawnSites[this.currentScreen];
    }

    public void setNextLocks() {
        this.startLock = this.endLock;
        this.endLock = (byte)(this.endLock + 1);
    }

    public void checkMap(int n) {
        if (n / 240 != this.currentScreen) {
            this.changeMap((byte)(n / 240));
        }
    }

    public void changeMap(byte by) {
        this.currentScreen = by;
        this.canvas.aiClearAllCharacterImages();
        System.gc();
        try {
            Thread.sleep(2L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.canvas.ioLoadTileSet(this.canvas.room[0]);
        this.createBackground();
        this.tileSet = null;
        System.gc();
        try {
            Thread.sleep(2L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.canvas.missionLoadEnemiesForRoomSection(this.getEnemySetForRoomSection());
    }

    public void nextRoomSection() {
        this.setNextLocks();
        this.setTileMap();
        int n = this.getEnemySetForRoomSection();
        this.canvas.doppelgangerState = (n & 0x10) != 0 ? (byte)1 : 0;
        if ((n & 0x20) != 0) {
            this.canvas.spawnPeriod = 0;
            this.canvas.missionSpawnNextEnemy();
        }
    }

    public void p(String string) {
    }
}

