/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DMC2DCharacter
implements DMC2DConstants {
    public DMC2DCanvas canvas;
    public int id;
    public byte type;
    public int x;
    public int y;
    public int z;
    public int targetX;
    public int targetY;
    public int targetZ;
    private int screen_x;
    private int screen_y;
    private int shadow_x;
    private int shadow_y;
    public boolean vulnerable = true;
    public Image[] images;
    private Image shadowImage;
    public int direction;
    public int face;
    public int jumpUpThrust;
    public int momentum;
    public byte anim;
    public byte nextAnim;
    public byte animFrame;
    public byte gravityModifier;
    public byte AIState;
    public int targetFace = -1;
    public boolean alive;
    public byte life;
    public byte orbValue;
    public byte[] rest;
    public byte[] choice;
    public int[][] hits;
    public byte impact;
    public byte difficulty;
    public byte speed;
    public boolean swapTarget;

    DMC2DCharacter(DMC2DCanvas dMC2DCanvas) {
        this.canvas = dMC2DCanvas;
    }

    public void init(byte by, Image[] imageArray, Image image) {
        this.type = by;
        this.images = imageArray;
        this.shadowImage = image;
    }

    public void setState(byte by, byte by2) {
        this.vulnerable = by != 7 && by != 5 && by != 9 && by != 2 && by != 15 && (this.type != 6 || !this.swapTarget);
        if ((this.type == 6 || this.type == 5) && by == 11) {
            this.vulnerable = false;
        }
        if (by != this.AIState) {
            if (by != 20) {
                this.setAnim(DMC2DCanvas.stateAnim[this.type < 5 ? 0 : this.type - 4][by], by2);
            }
            this.AIState = by;
        }
    }

    public void setXYZ(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public void setTargetXYZ(int n, int n2, int n3) {
        this.targetX = n;
        this.targetY = n2;
        this.targetZ = n3;
    }

    public void setAnim(byte by, byte by2) {
        this.anim = by;
        this.animFrame = by2;
    }

    public void faceDirection() {
        if ((this.direction & 0x40) != 0) {
            this.face = 64;
        } else if ((this.direction & 0x20) != 0) {
            this.face = 32;
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3 = -1;
        if (this.AIState == 20) {
            return;
        }
        int n4 = this.canvas.characterGetScreenX(this);
        int n5 = this.canvas.characterGetScreenY(this);
        this.shadow_y = this.z / 1;
        n4 = n4 * 8 / 15;
        n5 = n5 * 8 / 15;
        this.shadow_y = this.shadow_y * 8 / 15;
        if (this.type == 8 || this.type == 9 || this.type == 19) {
            if (this.anim != 0 && this.type != 19 || this.canvas.runCounter % 2 != 0) {
                this.screen_y = n5;
                this.screen_x = n4;
                graphics.drawImage(DMC2DCanvas.ingameImages[this.type == 8 ? 0 : (this.type == 9 ? 1 : 6)], n + this.screen_x - 4, n2 + this.screen_y, 20);
            }
        } else if (this.type == 11) {
            this.screen_y = n5;
            this.screen_x = n4;
            if (this.jumpUpThrust > 0 || this.AIState != -1 || this.canvas.runCounter % 2 != 0) {
                graphics.drawImage(DMC2DCanvas.ingameImages[5], n + this.screen_x - DMC2DCanvas.characterPositionOffsets[this.type][0][0], n2 + this.screen_y - DMC2DCanvas.characterPositionOffsets[this.type][0][1], 20);
            }
        } else if (this.type == 18) {
            this.screen_y = n5;
            this.screen_x = n4;
            DMC2DCanvas.drawRegion(graphics, this.images[DMC2DCanvas.imageOffsets[0][102][0]], DMC2DCanvas.imageOffsets[0][102][5], DMC2DCanvas.imageOffsets[0][102][6], DMC2DCanvas.imageOffsets[0][102][3], DMC2DCanvas.imageOffsets[0][102][4], this.face == 64 ? 0 : 2, n + this.screen_x - DMC2DCanvas.characterPositionOffsets[this.type][0][0], n2 + this.screen_y - DMC2DCanvas.characterPositionOffsets[this.type][0][1], 20);
        } else {
            this.screen_y = -DMC2DCanvas.characterPositionOffsets[this.type][this.face == 64 ? 0 : 1][1] + n5;
            this.screen_x = n4;
            if ((this.canvas.doppelgangerState != 4 && this.canvas.doppelgangerState != 5 || this.type != 0) && this.canvas.doppelgangerState != 6) {
                this.shadow_y -= DMC2DCanvas.characterPositionOffsets[this.type == 3 ? 15 : 14][0][1];
                this.shadow_x = n4 - DMC2DCanvas.characterPositionOffsets[this.type == 3 ? 15 : 14][0][0];
                graphics.drawImage(this.shadowImage, n + this.shadow_x, n2 + this.shadow_y, 20);
            }
            if (this.type != 6 || this.canvas.doppelgangerState != 4) {
                for (int i = 0; i < DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame].length; ++i) {
                    int n6;
                    ++n3;
                    if (this.face == 64) {
                        n6 = DMC2DCanvas.imageOffsets[this.type][DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame][i]][1] - DMC2DCanvas.characterPositionOffsets[this.type][0][0];
                    } else {
                        int n7 = DMC2DCanvas.characterPositionOffsets[this.type][0][0] - DMC2DCanvas.imageOffsets[this.type][DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame][i]][1];
                        n6 = n7 - DMC2DCanvas.imageOffsets[this.type][DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame][i]][3];
                    }
                    if (DMC2DCanvas.imageOffsets[this.type][DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame][i]][0] > 2) {
                        return;
                    }
                    DMC2DCanvas.drawRegion(graphics, this.images[DMC2DCanvas.imageOffsets[this.type][DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame][i]][0]], DMC2DCanvas.imageOffsets[this.type][DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame][i]][5], DMC2DCanvas.imageOffsets[this.type][DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame][i]][6], DMC2DCanvas.imageOffsets[this.type][DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame][i]][3], DMC2DCanvas.imageOffsets[this.type][DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame][i]][4], this.face == 64 ? 0 : 2, n + this.screen_x + n6, n2 + this.screen_y + DMC2DCanvas.imageOffsets[this.type][DMC2DCanvas.characterAnim[this.type][this.anim][this.animFrame][i]][2], 20);
                }
            }
            if (this.type == 3 && this.AIState == 13) {
                graphics.setColor(255, 255, 255);
                graphics.fillRect(n + n4 - DMC2DCanvas.characterPositionOffsets[17][this.face == 64 ? 1 : 0][0], n2 + n5 - DMC2DCanvas.characterPositionOffsets[17][0][1] - 160, 1, 160);
            }
        }
    }

    public void p(String string) {
    }
}

