/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class DMC2DCanvas
extends Canvas
implements Runnable,
DMC2DConstants {
    public DMC2DMap map;
    private Utilities util;
    private DMC2DCharacter[] gameItems;
    private DMC2DSound sound;
    public static short[][][] imageOffsets;
    public static short[][][] characterPositionOffsets;
    public static byte[][][][] characterAnim;
    public static final short[][][] ranges;
    private static final byte[][] impactEffectHeight;
    public static final byte[] danteAttackFrame;
    public static final byte[][] stateAnim;
    private static final byte[][][] enemyAiStats;
    private static final byte[][] orbValues;
    private static final String[] characterFilenames;
    private byte[][][] weaponStats = new byte[][][]{new byte[][]{{12, 13, 16, 19, 22}, {10, 30, 50, 70, 90}}, new byte[][]{{4, 6, 8, 10, 12}, {15, 35, 60, 75, 110}}};
    private DMC2DCharacter boss;
    private DMC2DCharacter dante;
    private int[][] impactEffect = new int[4][3];
    private boolean danteDead;
    private byte swordLevel = 0;
    private byte gunLevel = 0;
    private int orbCount = 0;
    private byte swordSlash;
    private byte characterCount;
    public int idCounter;
    private byte targetCount;
    private boolean[][] targetSlots = new boolean[2][2];
    private int spawnTimer;
    public int spawnPeriod;
    public byte doppelgangerState;
    public byte doppelgangerEffectCount;
    public static Image[] ingameImages;
    private static Image[] hudImages;
    private static Image logoImage;
    private static Image barImage;
    private static Image titleImageText;
    private static Image missionMapImage;
    private static Image menuBannerImage;
    private static Image[][] characterImages;
    private int mAlpha = 0;
    private int mValue = 20;
    private static Image advert;
    private String[] languages;
    private String[][] bootText;
    private String[] text;
    private String[] message;
    private byte[][] colourSettings = new byte[][]{{0, 0, 0, 0}, {60, -40, -40, 0}, {-20, 40, -20, 0}, {0, 0, 80, 0}, {-30, -20, 10, 1}};
    private byte[] mission;
    public byte[] room;
    private byte missionState;
    private byte[] missionStatus = new byte[12];
    private byte[] openMissions = new byte[2];
    private int missionStateCounter;
    private boolean nextRoomSection;
    private int missionTimer;
    private int missionObjectiveCount;
    private byte currentMission;
    private byte missionDamageRank;
    private byte missionDamage;
    private byte missionRank;
    private boolean freeSelect;
    private boolean freeSelectPlayed;
    private static final boolean tutorial = false;
    private boolean tutorialComplete;
    private boolean tutorialRetry;
    private byte tutorialLesson;
    private int[][] keyCodes = new int[7][3];
    private long[] keyRecord = new long[8];
    private int[] actionCue = new int[1];
    private int menuKey;
    private static Random random;
    private boolean initialised;
    public int runCounter;
    private byte gameState;
    private byte lastGameState = this.gameState = 0;
    private byte nextState = (byte)-1;
    private boolean interrupted;
    private boolean hasContinue;
    private byte advertFrames;
    private Command leftSoftKey;
    private Command rightSoftKey;
    private Image dblBuffer;
    private Graphics dblBufferGraphic;
    private int horizontalScrollTime;
    private int headerScrollTime;
    private boolean customKeys;
    private boolean optionsEdited;
    private int loadingCounter = -1;
    private int[] softkey = new int[2];
    private byte postSavedState;
    private boolean saveScreenPainted;
    private byte loadingTip = (byte)-1;
    private byte gameRank;
    private byte[] xOffsets = new byte[5];
    private byte languageSelected = 0;
    private int menuDirection;
    private int selectionScrollCounter;
    private int menuSelection = 1;
    private int menuHighlight;
    private int menuOptionsCount;
    private byte optionsState;
    private int textBoxStartLine;
    private byte[] menuOptions = new byte[]{8, 8, 13, 6, 14, 22};
    private byte soundResumeCounter;
    private boolean vibrate;
    private boolean virbrationEnabled = false;
    boolean[] cheats = new boolean[4];
    private static final int[] CHEAT_CODE;
    int cheatPosition = 0;
    boolean cheatEnabled = false;
    public static final int CHEAT_CLEAR_MISSION = 0;
    public static final int CHEAT_FAIL_MISSION = 1;
    public static final int CHEAT_INVINSIBLE = 2;
    public static final int CHEAT_SUPER_POWER = 3;
    public static boolean showBoundingBox;

    DMC2DCanvas() {
        this.setCommandListener(new CommandListener(){

            public void commandAction(Command command, Displayable displayable) {
                DMC2DCanvas.this.actionPerformed(command, displayable);
            }
        });
        this.dblBuffer = Image.createImage((int)128, (int)127);
        this.dblBufferGraphic = this.dblBuffer.getGraphics();
    }

    private void aiAddHit(DMC2DCharacter dMC2DCharacter, int n) {
        for (int i = dMC2DCharacter.hits.length - 1; i > 0; --i) {
            dMC2DCharacter.hits[i][0] = dMC2DCharacter.hits[i - 1][0];
            dMC2DCharacter.hits[i][1] = dMC2DCharacter.hits[i - 1][1];
        }
        dMC2DCharacter.hits[0][0] = n;
        dMC2DCharacter.hits[0][1] = this.runCounter;
    }

    private void aiBubbleSortByDistance(DMC2DCharacter[] dMC2DCharacterArray, DMC2DCharacter dMC2DCharacter) {
        for (int i = dMC2DCharacterArray.length - 1; i >= 0; --i) {
            for (int j = 1; j <= i; ++j) {
                if (this.aiDistanceFromSquared(dMC2DCharacterArray[j - 1], dMC2DCharacter) <= this.aiDistanceFromSquared(dMC2DCharacterArray[j], dMC2DCharacter)) continue;
                DMC2DCharacter dMC2DCharacter2 = dMC2DCharacterArray[j - 1];
                dMC2DCharacterArray[j - 1] = dMC2DCharacterArray[j];
                dMC2DCharacterArray[j] = dMC2DCharacter2;
            }
        }
    }

    private void aiBubbleSortByZ(DMC2DCharacter[] dMC2DCharacterArray) {
        for (int i = dMC2DCharacterArray.length - 1; i >= 0; --i) {
            for (int j = 1; j <= i; ++j) {
                if (dMC2DCharacterArray[j - 1].z <= dMC2DCharacterArray[j].z) continue;
                DMC2DCharacter dMC2DCharacter = dMC2DCharacterArray[j - 1];
                dMC2DCharacterArray[j - 1] = dMC2DCharacterArray[j];
                dMC2DCharacterArray[j] = dMC2DCharacter;
            }
        }
    }

    private boolean aiCheckEvade(DMC2DCharacter dMC2DCharacter) {
        if (this.aiGetHitCount(dMC2DCharacter, 16) > 2) {
            this.aiSetAvadeXYZ(dMC2DCharacter, this.dante);
            dMC2DCharacter.setState((byte)12, (byte)0);
            return true;
        }
        if (this.aiGetHitRepeatCount(dMC2DCharacter, 16) > 1) {
            this.aiSetAvadeXYZ(dMC2DCharacter, this.dante);
            dMC2DCharacter.setState((byte)12, (byte)0);
            return true;
        }
        return false;
    }

    private static boolean aiChoice(byte by) {
        return Math.abs(random.nextInt() % 100) < by;
    }

    public void aiClearAllCharacterImages() {
        for (int i = 1; i < 7; ++i) {
            DMC2DCanvas.characterImages[i] = null;
        }
    }

    private void aiClearRest(DMC2DCharacter dMC2DCharacter) {
        for (int i = 0; i < dMC2DCharacter.rest.length; ++i) {
            dMC2DCharacter.rest[i] = 0;
        }
    }

    private DMC2DCharacter aiCreateEnemy(byte by, int n, int n2, int n3, byte by2) {
        DMC2DCharacter dMC2DCharacter = null;
        try {
            dMC2DCharacter = new DMC2DCharacter(this);
            dMC2DCharacter.init(by, characterImages[by], by == 3 ? ingameImages[4] : ingameImages[3]);
            dMC2DCharacter.setState(by2, (byte)-1);
            dMC2DCharacter.setXYZ(n, n2, n3);
            if (this.dante.x > n) {
                dMC2DCharacter.face = 64;
            }
            dMC2DCharacter.id = this.idCounter++;
            dMC2DCharacter.alive = true;
            dMC2DCharacter.speed = enemyAiStats[by][dMC2DCharacter.difficulty][0];
            this.characterCount = (byte)(this.characterCount + 1);
            dMC2DCharacter.life = enemyAiStats[by][dMC2DCharacter.difficulty][2];
            dMC2DCharacter.impact = (byte)-1;
            if (by == 6) {
                dMC2DCharacter.rest = new byte[8];
                dMC2DCharacter.choice = new byte[8];
                dMC2DCharacter.hits = new int[4][2];
                dMC2DCharacter.choice[0] = enemyAiStats[by][dMC2DCharacter.difficulty][15];
                dMC2DCharacter.choice[1] = enemyAiStats[by][dMC2DCharacter.difficulty][16];
                dMC2DCharacter.choice[2] = enemyAiStats[by][dMC2DCharacter.difficulty][17];
                dMC2DCharacter.choice[3] = enemyAiStats[by][dMC2DCharacter.difficulty][18];
                dMC2DCharacter.choice[4] = enemyAiStats[by][dMC2DCharacter.difficulty][19];
                dMC2DCharacter.choice[5] = enemyAiStats[by][dMC2DCharacter.difficulty][26];
                dMC2DCharacter.choice[6] = enemyAiStats[by][dMC2DCharacter.difficulty][27];
                dMC2DCharacter.choice[7] = enemyAiStats[by][dMC2DCharacter.difficulty][28];
            } else {
                dMC2DCharacter.rest = new byte[5];
                dMC2DCharacter.choice = new byte[5];
                dMC2DCharacter.hits = new int[4][2];
                dMC2DCharacter.choice[0] = enemyAiStats[by][dMC2DCharacter.difficulty][15];
                dMC2DCharacter.choice[1] = enemyAiStats[by][dMC2DCharacter.difficulty][16];
                dMC2DCharacter.choice[2] = enemyAiStats[by][dMC2DCharacter.difficulty][17];
                dMC2DCharacter.choice[3] = enemyAiStats[by][dMC2DCharacter.difficulty][18];
                dMC2DCharacter.choice[4] = enemyAiStats[by][dMC2DCharacter.difficulty][19];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return dMC2DCharacter;
    }

    private DMC2DCharacter aiCreateOrb(int n, int n2, int n3, byte by, byte by2) {
        DMC2DCharacter dMC2DCharacter = null;
        try {
            dMC2DCharacter = new DMC2DCharacter(this);
            dMC2DCharacter.setXYZ(n, n2, n3);
            dMC2DCharacter.type = by2;
            dMC2DCharacter.alive = true;
            dMC2DCharacter.id = this.idCounter++;
            dMC2DCharacter.animFrame = 0;
            dMC2DCharacter.anim = 0;
            dMC2DCharacter.orbValue = by;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dMC2DCharacter;
    }

    private DMC2DCharacter aiCreateSword(DMC2DCharacter dMC2DCharacter) {
        DMC2DCharacter dMC2DCharacter2 = null;
        try {
            dMC2DCharacter2 = new DMC2DCharacter(this);
            dMC2DCharacter2.setXYZ(dMC2DCharacter.x, dMC2DCharacter.y + 180, dMC2DCharacter.z);
            dMC2DCharacter2.type = (byte)18;
            dMC2DCharacter2.face = dMC2DCharacter.face;
            dMC2DCharacter2.AIState = (byte)19;
            dMC2DCharacter2.anim = (byte)16;
            dMC2DCharacter2.alive = true;
            dMC2DCharacter2.life = (byte)10;
            dMC2DCharacter2.images = dMC2DCharacter.images;
            dMC2DCharacter2.id = this.idCounter++;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dMC2DCharacter2;
    }

    private void aiCreepToTarget(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2) {
        int n = (ranges[dMC2DCharacter.type][0][0] - ranges[dMC2DCharacter.type][0][1]) / 2 + 10;
        int n2 = 0;
        int n3 = 0;
        if (dMC2DCharacter.x < dMC2DCharacter2.x) {
            n2 = -n;
            n3 = dMC2DCharacter2.x + n2 - dMC2DCharacter.x;
        } else {
            n2 = n;
            n3 = dMC2DCharacter.x - (dMC2DCharacter2.x + n2);
        }
        if (n3 > n) {
            if (!DMC2DCanvas.aiChoice(dMC2DCharacter.choice[0])) {
                this.aiMoveToTarget(dMC2DCharacter, dMC2DCharacter2.x + n2, dMC2DCharacter.y, dMC2DCharacter.z, 5, dMC2DCharacter.speed / 2);
            }
            if (dMC2DCharacter.anim != 1) {
                dMC2DCharacter.anim = 1;
                dMC2DCharacter.animFrame = 0;
            }
        } else if (dMC2DCharacter.anim != 0) {
            dMC2DCharacter.anim = 0;
            dMC2DCharacter.animFrame = 0;
        }
    }

    private int aiDistanceFromSquared(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2) {
        int n = dMC2DCharacter.x - dMC2DCharacter2.x;
        int n2 = dMC2DCharacter.z - dMC2DCharacter2.z;
        return n * n + n2 * n2;
    }

    private void aiEnemyAct(DMC2DCharacter dMC2DCharacter) {
        if (dMC2DCharacter.type != 18) {
            this.aiUnrest(dMC2DCharacter);
        }
        if (dMC2DCharacter.life <= 0 && dMC2DCharacter.y <= 0 && dMC2DCharacter.AIState != 5 && dMC2DCharacter.AIState != 9) {
            dMC2DCharacter.setState((byte)9, (byte)-1);
        }
        switch (dMC2DCharacter.AIState) {
            case 13: {
                if (dMC2DCharacter.type != 6 || this.doppelgangerState != 4 || !this.aiMoveToTarget(dMC2DCharacter, dMC2DCharacter.targetX, dMC2DCharacter.targetY, dMC2DCharacter.targetZ, 5, dMC2DCharacter.speed)) break;
                this.doppelgangerState = (byte)5;
                dMC2DCharacter.setAnim((byte)15, (byte)-1);
                this.aiFaceItem(dMC2DCharacter, this.dante);
                break;
            }
            case 0: {
                this.aiFaceItem(dMC2DCharacter, this.dante);
                if (!this.aiRested(dMC2DCharacter, 0)) break;
                if (dMC2DCharacter.targetFace != -1) {
                    dMC2DCharacter.setState((byte)1, (byte)-1);
                    break;
                }
                this.aiCreepToTarget(dMC2DCharacter, this.dante);
                break;
            }
            case 1: 
            case 3: {
                this.aiFaceItem(dMC2DCharacter, this.dante);
                if (this.aiTargetIsInRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][0]) && dMC2DCharacter.nextAnim != -1) {
                    if (!dMC2DCharacter.swapTarget && dMC2DCharacter.type == 6 && DMC2DCanvas.aiChoice(dMC2DCharacter.choice[4]) && (this.characterGetScreenX(this.dante) < 120 && dMC2DCharacter.targetFace == 0 || this.characterGetScreenX(this.dante) > 120 && dMC2DCharacter.targetFace == 1)) {
                        if (!(dMC2DCharacter.targetFace != 0 || this.targetSlots[1][0] && this.targetSlots[1][1])) {
                            this.aiTargetRelease(dMC2DCharacter);
                            this.aiTargetLock(dMC2DCharacter, 1);
                            dMC2DCharacter.swapTarget = true;
                            if (dMC2DCharacter.type != 6) break;
                            dMC2DCharacter.vulnerable = false;
                            break;
                        }
                        if (!(dMC2DCharacter.targetFace != 1 || this.targetSlots[0][0] && this.targetSlots[0][1])) {
                            this.aiTargetRelease(dMC2DCharacter);
                            this.aiTargetLock(dMC2DCharacter, 0);
                            dMC2DCharacter.swapTarget = true;
                            if (dMC2DCharacter.type != 6) break;
                            dMC2DCharacter.vulnerable = false;
                            break;
                        }
                    }
                    if (dMC2DCharacter.type == 6 && dMC2DCharacter.swapTarget) {
                        if (DMC2DCanvas.aiChoice((byte)35) && this.aiRested(dMC2DCharacter, 4)) {
                            dMC2DCharacter.setState((byte)16, (byte)0);
                            return;
                        }
                        if (DMC2DCanvas.aiChoice((byte)35) && this.aiRested(dMC2DCharacter, 3)) {
                            dMC2DCharacter.setState((byte)15, (byte)0);
                            return;
                        }
                    }
                    if (this.aiTargetIsOnSide(dMC2DCharacter, this.dante) && (dMC2DCharacter.swapTarget || DMC2DCanvas.aiChoice(dMC2DCharacter.choice[3]))) {
                        int n = this.dante.x + (dMC2DCharacter.targetFace == 0 ? -(ranges[dMC2DCharacter.type][1][0] - 10) : ranges[dMC2DCharacter.type][1][0] - 10);
                        dMC2DCharacter.setTargetXYZ(n, 0, this.dante.z);
                        dMC2DCharacter.setState((byte)14, (byte)0);
                        dMC2DCharacter.swapTarget = false;
                        dMC2DCharacter.vulnerable = true;
                        return;
                    }
                    dMC2DCharacter.swapTarget = false;
                    dMC2DCharacter.vulnerable = true;
                    if (this.aiRested(dMC2DCharacter, 0)) {
                        if (dMC2DCharacter.type == 6) {
                            if (DMC2DCanvas.aiChoice(dMC2DCharacter.choice[6]) && this.aiRested(dMC2DCharacter, 4)) {
                                dMC2DCharacter.setState((byte)16, (byte)0);
                                return;
                            }
                            if (DMC2DCanvas.aiChoice(dMC2DCharacter.choice[5]) && this.aiRested(dMC2DCharacter, 3)) {
                                dMC2DCharacter.setState((byte)15, (byte)-1);
                                return;
                            }
                        }
                        dMC2DCharacter.setState((byte)2, (byte)-1);
                        return;
                    }
                    dMC2DCharacter.setState((byte)3, (byte)-1);
                    return;
                }
                this.aiRest(dMC2DCharacter, 0, enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][6], enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][11]);
                if (dMC2DCharacter.targetFace != -1) {
                    if (!dMC2DCharacter.swapTarget && this.aiIsOnSameScreen(dMC2DCharacter, this.dante) && this.aiTargetIsOnSide(dMC2DCharacter, this.dante) && this.aiTargetIsInRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][1]) && this.aiRested(dMC2DCharacter, 1) && DMC2DCanvas.aiChoice(dMC2DCharacter.choice[2])) {
                        if (dMC2DCharacter.type == 1 || dMC2DCharacter.type == 2) {
                            dMC2DCharacter.jumpUpThrust = 115;
                            ++dMC2DCharacter.y;
                        }
                        if (dMC2DCharacter.type == 3) {
                            dMC2DCharacter.setTargetXYZ(this.dante.x, 0, this.dante.z);
                        } else {
                            dMC2DCharacter.setTargetXYZ(this.aiGetTargetX(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][0]), 0, this.dante.z);
                        }
                        dMC2DCharacter.setState((byte)11, (byte)-1);
                        this.aiRest(dMC2DCharacter, 1, enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][8], enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][13]);
                        this.aiRest(dMC2DCharacter, 0, enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][5], enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][10]);
                    } else if (!dMC2DCharacter.swapTarget && Math.abs(dMC2DCharacter.x - this.dante.x) > ranges[dMC2DCharacter.type][0][0] + ranges[dMC2DCharacter.type][0][0] / 2 && this.aiRested(dMC2DCharacter, 2) && DMC2DCanvas.aiChoice(dMC2DCharacter.choice[1])) {
                        dMC2DCharacter.setTargetXYZ(this.dante.x, 0, this.dante.z);
                        dMC2DCharacter.jumpUpThrust = 115;
                        ++dMC2DCharacter.y;
                        this.aiRest(dMC2DCharacter, 2, enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][9], enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][14]);
                        dMC2DCharacter.setState((byte)10, (byte)-1);
                    } else {
                        dMC2DCharacter.setState((byte)1, (byte)-1);
                        if (dMC2DCharacter.swapTarget || !DMC2DCanvas.aiChoice(dMC2DCharacter.choice[0])) {
                            if (dMC2DCharacter.type == 1 || dMC2DCharacter.type == 2) {
                                byte by = (byte)(dMC2DCharacter.speed / 3 * 2);
                                if (dMC2DCharacter.animFrame == 0 || dMC2DCharacter.animFrame == 3) {
                                    by = (byte)(dMC2DCharacter.speed / 3);
                                } else if (dMC2DCharacter.animFrame == 2 || dMC2DCharacter.animFrame == 5) {
                                    by = (byte)(dMC2DCharacter.speed * 3 / 2);
                                }
                                this.aiMoveToRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][0], dMC2DCharacter.swapTarget ? (byte)(by * 2) : by);
                            } else {
                                this.aiMoveToRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][0], dMC2DCharacter.swapTarget ? (byte)(dMC2DCharacter.speed * 2) : dMC2DCharacter.speed);
                            }
                        }
                    }
                } else {
                    dMC2DCharacter.setState((byte)0, (byte)-1);
                }
                this.aiFaceItem(dMC2DCharacter, this.dante);
                break;
            }
            case 14: {
                if (!this.aiMoveToTarget(dMC2DCharacter, dMC2DCharacter.targetX, dMC2DCharacter.targetY, dMC2DCharacter.targetZ, 5, dMC2DCharacter.speed)) break;
                if (this.aiTargetIsInRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][1])) {
                    if (dMC2DCharacter.type == 3) {
                        dMC2DCharacter.setTargetXYZ(this.dante.x, 0, this.dante.z);
                    } else {
                        dMC2DCharacter.setTargetXYZ(this.aiGetTargetX(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][0]), 0, this.dante.z);
                    }
                    if (dMC2DCharacter.type == 1 || dMC2DCharacter.type == 2) {
                        dMC2DCharacter.jumpUpThrust = 115;
                        ++dMC2DCharacter.y;
                    }
                    dMC2DCharacter.setState((byte)11, (byte)-1);
                    break;
                }
                dMC2DCharacter.setState((byte)0, (byte)-1);
                break;
            }
            case 2: {
                this.aiFaceItem(dMC2DCharacter, this.dante);
                if (dMC2DCharacter.animFrame != 1) break;
                if (this.aiTargetIsInRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][0])) {
                    this.aiEnemyAttackDante(dMC2DCharacter);
                }
                this.aiRest(dMC2DCharacter, 0, enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][5], enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][10]);
                break;
            }
            case 15: {
                this.aiFaceItem(dMC2DCharacter, this.dante);
                if (dMC2DCharacter.animFrame != 1) break;
                if (this.aiTargetIsInRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][0])) {
                    this.aiEnemyAttackDante(dMC2DCharacter);
                }
                if (dMC2DCharacter.anim != 14) break;
                this.aiRest(dMC2DCharacter, 0, enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][5], enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][10]);
                break;
            }
            case 11: {
                this.aiFaceItem(dMC2DCharacter, this.dante);
                if (dMC2DCharacter.type == 3 || dMC2DCharacter.type == 6) {
                    if (this.aiTargetIsInRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][2])) {
                        this.aiEnemyAttackDante(dMC2DCharacter);
                        dMC2DCharacter.vulnerable = true;
                    }
                    if (!this.aiMoveToTarget(dMC2DCharacter, dMC2DCharacter.targetX, dMC2DCharacter.targetY, dMC2DCharacter.targetZ, 5, enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][1])) break;
                    this.aiRest(dMC2DCharacter, 0, enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][5], enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][10]);
                    dMC2DCharacter.vulnerable = true;
                    dMC2DCharacter.setState((byte)0, (byte)-1);
                    break;
                }
                if (!this.aiMoveToTarget(dMC2DCharacter, dMC2DCharacter.targetX, dMC2DCharacter.targetY, dMC2DCharacter.targetZ, 5, enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][1])) break;
                if (dMC2DCharacter.difficulty != 0) {
                    this.aiClearRest(dMC2DCharacter);
                    dMC2DCharacter.setState((byte)2, (byte)0);
                    break;
                }
                if (this.aiRested(dMC2DCharacter, 0)) {
                    dMC2DCharacter.setState((byte)2, (byte)0);
                    break;
                }
                dMC2DCharacter.setState((byte)0, (byte)0);
                break;
            }
            case 10: {
                this.aiMoveToRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][0], dMC2DCharacter.speed);
                break;
            }
            case 16: {
                if (dMC2DCharacter.animFrame == 1) {
                    if (this.aiTargetIsInRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][0])) {
                        this.aiEnemyAttackDante(dMC2DCharacter);
                    }
                    dMC2DCharacter.jumpUpThrust = 125;
                    ++dMC2DCharacter.y;
                    dMC2DCharacter.setState((byte)17, (byte)-1);
                }
            }
            case 17: {
                if (dMC2DCharacter.animFrame == 0) {
                    dMC2DCharacter.jumpUpThrust = 125;
                    break;
                }
                if (dMC2DCharacter.animFrame != 2) break;
                dMC2DCharacter.gravityModifier = (byte)-125;
                if (!this.aiTargetIsInRange(dMC2DCharacter, this.dante, ranges[dMC2DCharacter.type][0])) break;
                this.aiEnemyAttackDante(dMC2DCharacter);
                this.aiRest(dMC2DCharacter, 4, enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][21], enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][24]);
                break;
            }
            case 8: {
                if (dMC2DCharacter.y + -35 > 0) break;
                dMC2DCharacter.setState((byte)0, (byte)-1);
                break;
            }
            case 12: {
                this.aiFaceItem(dMC2DCharacter, this.dante);
                int n = dMC2DCharacter.type == 6 ? dMC2DCharacter.speed * 2 : dMC2DCharacter.speed + dMC2DCharacter.speed / 2;
                if (!this.aiMoveToTarget(dMC2DCharacter, dMC2DCharacter.targetX, dMC2DCharacter.targetY, dMC2DCharacter.targetZ, 5, n)) break;
                if (this.characterGetScreenX(this.dante) < 120 && dMC2DCharacter.targetFace == 0 || this.characterGetScreenX(this.dante) > 120 && dMC2DCharacter.targetFace == 1) {
                    if (!(dMC2DCharacter.targetFace != 0 || this.targetSlots[1][0] && this.targetSlots[1][1])) {
                        this.aiTargetRelease(dMC2DCharacter);
                        this.aiTargetLock(dMC2DCharacter, 1);
                        dMC2DCharacter.swapTarget = true;
                        if (dMC2DCharacter.type == 6) {
                            dMC2DCharacter.vulnerable = false;
                        }
                    } else if (!(dMC2DCharacter.targetFace != 1 || this.targetSlots[0][0] && this.targetSlots[0][1])) {
                        this.aiTargetRelease(dMC2DCharacter);
                        this.aiTargetLock(dMC2DCharacter, 0);
                        dMC2DCharacter.swapTarget = true;
                        if (dMC2DCharacter.type == 6) {
                            dMC2DCharacter.vulnerable = false;
                        }
                    }
                }
                dMC2DCharacter.setState((byte)0, (byte)-1);
            }
        }
    }

    private void aiEnemyAnimate(DMC2DCharacter dMC2DCharacter) {
        switch (dMC2DCharacter.anim) {
            case 9: {
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                if (dMC2DCharacter.y + -35 <= 0) {
                    dMC2DCharacter.setState((byte)0, (byte)0);
                    break;
                }
                dMC2DCharacter.animFrame = 0;
                break;
            }
            case 0: 
            case 1: {
                if (dMC2DCharacter.AIState == 1) {
                    dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                    if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                    dMC2DCharacter.animFrame = 0;
                    break;
                }
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                dMC2DCharacter.animFrame = 0;
                break;
            }
            case 2: {
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                if (dMC2DCharacter.AIState == 2) {
                    dMC2DCharacter.setState((byte)0, (byte)0);
                    break;
                }
                dMC2DCharacter.setAnim((byte)13, (byte)0);
                break;
            }
            case 3: {
                if (dMC2DCharacter.AIState == 6) {
                    dMC2DCharacter.animFrame = 0;
                    break;
                }
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                if (dMC2DCharacter.difficulty != 0) {
                    if (this.aiCheckEvade(dMC2DCharacter)) break;
                    dMC2DCharacter.setState((byte)0, (byte)0);
                    break;
                }
                dMC2DCharacter.setState((byte)0, (byte)0);
                break;
            }
            case 6: {
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                dMC2DCharacter.gravityModifier = 0;
                dMC2DCharacter.animFrame = 0;
                break;
            }
            case 5: {
                if (dMC2DCharacter.AIState == 7) {
                    dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                    if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                    dMC2DCharacter.animFrame = 0;
                    if (this.aiCheckEvade(dMC2DCharacter)) break;
                    dMC2DCharacter.setState((byte)0, (byte)0);
                    break;
                }
                if (dMC2DCharacter.AIState != 9 || (dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1)) < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                this.aiEnemyDie(dMC2DCharacter);
                return;
            }
            case 4: {
                if (dMC2DCharacter.y > 0 && dMC2DCharacter.animFrame > 0 || (dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1)) < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                dMC2DCharacter.animFrame = 0;
                dMC2DCharacter.setState((byte)7, (byte)0);
                break;
            }
            case 8: {
                if (dMC2DCharacter.type == 1 || dMC2DCharacter.type == 2) {
                    dMC2DCharacter.animFrame = 0;
                } else {
                    dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                    if (dMC2DCharacter.animFrame >= characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) {
                        dMC2DCharacter.animFrame = (byte)(characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length - 1);
                    }
                }
                if (dMC2DCharacter.animFrame <= 1 || dMC2DCharacter.type != 3 && dMC2DCharacter.type != 6 || dMC2DCharacter.difficulty <= 1) break;
                dMC2DCharacter.vulnerable = false;
                break;
            }
            case 7: {
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame >= characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) {
                    dMC2DCharacter.animFrame = (byte)(characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length - 1);
                }
                if (dMC2DCharacter.y > 0) break;
                dMC2DCharacter.setState((byte)0, (byte)0);
                break;
            }
            case 10: {
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                dMC2DCharacter.animFrame = (byte)(characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length - 1);
                break;
            }
            case 11: {
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame >= characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) {
                    dMC2DCharacter.animFrame = (byte)(characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length - 1);
                }
                if (dMC2DCharacter.y > 0) break;
                dMC2DCharacter.setState((byte)0, (byte)0);
                break;
            }
            case 13: {
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                dMC2DCharacter.setAnim((byte)14, (byte)0);
                break;
            }
            case 14: {
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                dMC2DCharacter.setState((byte)0, (byte)0);
                break;
            }
            case 12: {
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                dMC2DCharacter.setState((byte)0, (byte)0);
                break;
            }
            case 15: {
                dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1);
                if (dMC2DCharacter.animFrame < characterAnim[dMC2DCharacter.type][dMC2DCharacter.anim].length) break;
                dMC2DCharacter.setState((byte)0, (byte)0);
                this.doppelgangerState = (byte)6;
                this.aiRest(dMC2DCharacter, 0, 3, 4);
            }
        }
        if (dMC2DCharacter.momentum != 0) {
            dMC2DCharacter.x += dMC2DCharacter.momentum;
            dMC2DCharacter.momentum = dMC2DCharacter.momentum - (dMC2DCharacter.momentum > 0 ? 8 : -8);
        }
        dMC2DCharacter.jumpUpThrust = dMC2DCharacter.jumpUpThrust + -35 < 0 || dMC2DCharacter.gravityModifier == -125 ? (dMC2DCharacter.jumpUpThrust += -35 + dMC2DCharacter.gravityModifier) : (dMC2DCharacter.jumpUpThrust += -35);
        if ((dMC2DCharacter.y += dMC2DCharacter.jumpUpThrust) < 0) {
            dMC2DCharacter.y = 0;
            dMC2DCharacter.gravityModifier = 0;
            if (dMC2DCharacter.AIState == 6) {
                dMC2DCharacter.setState((byte)0, (byte)0);
            }
        }
        int n = this.map.startLock * 240 + 4;
        int n2 = this.map.endLock * 240 - 4;
        if (dMC2DCharacter.x < n) {
            dMC2DCharacter.x = n;
            if (Math.abs(dMC2DCharacter.x - this.dante.x) < ranges[dMC2DCharacter.type][0][0] && dMC2DCharacter.AIState != 7 && dMC2DCharacter.AIState != 4 && dMC2DCharacter.AIState != 5 && dMC2DCharacter.AIState != 12) {
                if (DMC2DCanvas.aiChoice((byte)65)) {
                    this.aiSetAvadeXYZ(dMC2DCharacter, this.dante);
                    if (dMC2DCharacter.type != 6) {
                        dMC2DCharacter.targetX = this.map.currentScreen * 240 + 120;
                    }
                    dMC2DCharacter.setState((byte)12, (byte)0);
                } else {
                    dMC2DCharacter.setState((byte)0, (byte)0);
                }
            }
            if (dMC2DCharacter.targetX < n) {
                dMC2DCharacter.targetX = n;
            }
            dMC2DCharacter.momentum = 0;
        } else if (dMC2DCharacter.x > n2) {
            dMC2DCharacter.x = n2;
            if (Math.abs(dMC2DCharacter.x - this.dante.x) < ranges[dMC2DCharacter.type][0][0] && dMC2DCharacter.AIState != 7 && dMC2DCharacter.AIState != 4 && dMC2DCharacter.AIState != 5 && dMC2DCharacter.AIState != 12) {
                if (DMC2DCanvas.aiChoice((byte)65)) {
                    this.aiSetAvadeXYZ(dMC2DCharacter, this.dante);
                    if (dMC2DCharacter.type != 6) {
                        dMC2DCharacter.targetX = this.map.currentScreen * 240 + 120;
                    }
                    dMC2DCharacter.setState((byte)12, (byte)0);
                } else {
                    dMC2DCharacter.setState((byte)0, (byte)0);
                }
            }
            if (dMC2DCharacter.targetX > n2) {
                dMC2DCharacter.targetX = n2;
            }
            dMC2DCharacter.momentum = 0;
        }
        if (dMC2DCharacter.impact != -1) {
            int n3 = dMC2DCharacter.anim == 5 || dMC2DCharacter.anim == 4 && dMC2DCharacter.animFrame > 1 ? 1 : 0;
            int n4 = dMC2DCharacter.x - this.map.currentScreen * 240 - characterPositionOffsets[16][0][0];
            int n5 = characterPositionOffsets[16][0][1] - dMC2DCharacter.y / 2 + dMC2DCharacter.z / 1 - impactEffectHeight[dMC2DCharacter.type][n3];
            this.impactEffectAdd(n4, n5);
            dMC2DCharacter.impact = (byte)-1;
        }
    }

    private boolean aiEnemyAttackDante(DMC2DCharacter dMC2DCharacter) {
        if (this.dante.vulnerable || dMC2DCharacter.AIState == 17) {
            this.danteTakeHit(dMC2DCharacter);
            return true;
        }
        if (this.danteDead) {
            int n = this.dante.momentum = dMC2DCharacter.face == 64 ? 16 : -16;
            if (DMC2DCanvas.aiChoice((byte)40)) {
                this.dante.jumpUpThrust = DMC2DCanvas.random(80);
            }
            int n2 = this.dante.x - this.map.currentScreen * 240 - characterPositionOffsets[16][0][0];
            int n3 = characterPositionOffsets[16][0][1] - this.dante.y / 2 + this.dante.z / 1 - impactEffectHeight[0][1];
            this.impactEffectAdd(n2, n3);
        }
        return false;
    }

    private void aiEnemyDie(DMC2DCharacter dMC2DCharacter) {
        if (this.mission[5] == 3 && --this.missionObjectiveCount < 0) {
            this.missionObjectiveCount = 0;
        }
        if (this.mission[5] == 2 && this.missionEnemyCleared() && this.characterCount == 1 && this.map.endLock == this.map.screenCount) {
            this.aiSpawnOrb(dMC2DCharacter, this.danteClipToCurrentScreen(dMC2DCharacter.x), 60, dMC2DCharacter.z, (byte)19);
            this.aiTargetRelease(dMC2DCharacter);
            dMC2DCharacter.alive = false;
            this.itemRemove(dMC2DCharacter);
            this.characterCount = (byte)(this.characterCount - 1);
        } else {
            byte by = DMC2DCanvas.aiChoice(this.missionHasCondition((byte)2) ? (byte)50 : 80) ? (byte)8 : 9;
            this.aiSpawnOrb(dMC2DCharacter, dMC2DCharacter.x, 60, dMC2DCharacter.z, by);
            this.aiTargetRelease(dMC2DCharacter);
            dMC2DCharacter.alive = false;
            this.itemRemove(dMC2DCharacter);
            this.characterCount = (byte)(this.characterCount - 1);
        }
    }

    private void aiFaceItem(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2) {
        dMC2DCharacter.face = dMC2DCharacter.x < dMC2DCharacter2.x ? 64 : 32;
    }

    private int aiGetHitCount(DMC2DCharacter dMC2DCharacter, int n) {
        int n2 = 0;
        for (int i = 0; i < dMC2DCharacter.hits.length && dMC2DCharacter.hits[i][1] > this.runCounter - n; ++i) {
            if (dMC2DCharacter.hits[i][0] == 0) continue;
            ++n2;
        }
        return n2;
    }

    private int aiGetHitRepeatCount(DMC2DCharacter dMC2DCharacter, int n) {
        int n2 = 0;
        int n3 = dMC2DCharacter.hits[0][0];
        for (int i = 1; i < dMC2DCharacter.hits.length && dMC2DCharacter.hits[i][0] == n3; ++i) {
            ++n2;
        }
        return n2;
    }

    private int aiGetMapXFromScreenX(int n) {
        return this.map.currentScreen * 240 + n;
    }

    private int aiGetTargetX(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2, short[] sArray) {
        int n = (sArray[0] + sArray[1]) / 2;
        return dMC2DCharacter2.x + (dMC2DCharacter.targetFace == 0 ? -n : n);
    }

    private boolean aiIsOnSameScreen(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2) {
        return dMC2DCharacter.x / 240 == dMC2DCharacter2.x / 240;
    }

    private void aiMoveToRange(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2, short[] sArray, byte by) {
        int n = 0;
        int n2 = 0;
        int n3 = this.aiGetTargetX(dMC2DCharacter, dMC2DCharacter2, sArray);
        int n4 = Math.abs(n3 - dMC2DCharacter.x);
        int n5 = Math.abs(dMC2DCharacter2.z - dMC2DCharacter.z);
        int n6 = n4 < by ? n4 : (int)by;
        int n7 = n5 < by ? n5 : (int)by;
        n = dMC2DCharacter.x < n3 ? n6 : -n6;
        if (dMC2DCharacter.z < dMC2DCharacter2.z) {
            if (dMC2DCharacter2.z - dMC2DCharacter.z >= sArray[2]) {
                n2 = n7;
            }
        } else if (dMC2DCharacter.z - dMC2DCharacter2.z >= sArray[2]) {
            n2 = -n7;
        }
        if (n != 0 && n2 != 0) {
            n = n * 7 / 10;
            n2 = n2 * 7 / 10;
        }
        dMC2DCharacter.x += n;
        dMC2DCharacter.z += n2;
    }

    private boolean aiMoveToTarget(DMC2DCharacter dMC2DCharacter, int n, int n2, int n3, int n4, int n5) {
        boolean bl = true;
        int n6 = Math.abs(dMC2DCharacter.x - n);
        if (n6 >= n4) {
            bl = false;
            dMC2DCharacter.x = dMC2DCharacter.x < n ? dMC2DCharacter.x + (n5 < n6 ? n5 : n6) : dMC2DCharacter.x - (n5 < n6 ? n5 : n6);
        }
        if ((n6 = Math.abs(dMC2DCharacter.z - n3)) >= n4) {
            bl = false;
            dMC2DCharacter.z = dMC2DCharacter.z < n3 ? dMC2DCharacter.z + (n5 < n6 ? n5 : n6) : dMC2DCharacter.z - (n5 < n6 ? n5 : n6);
        }
        if (dMC2DCharacter.type == 8 || dMC2DCharacter.type == 9) {
            n5 *= 2;
        }
        if ((n6 = Math.abs(dMC2DCharacter.y - n2)) >= n4) {
            bl = false;
            dMC2DCharacter.y = dMC2DCharacter.y < n2 ? dMC2DCharacter.y + (n5 < n6 ? n5 : n6) : dMC2DCharacter.y - (n5 < n6 ? n5 : n6);
        }
        return bl;
    }

    private void aiRest(DMC2DCharacter dMC2DCharacter, int n, int n2, int n3) {
        dMC2DCharacter.rest[n] = (byte)(DMC2DCanvas.random(n3 - n2) + n2);
    }

    private boolean aiRested(DMC2DCharacter dMC2DCharacter, int n) {
        return dMC2DCharacter.rest[n] <= 0;
    }

    private void aiRun(DMC2DCharacter dMC2DCharacter) {
        this.aiEnemyAct(dMC2DCharacter);
        this.aiEnemyAnimate(dMC2DCharacter);
        if (DMC2DCanvas.aiChoice((byte)50)) {
            this.aiSeperateCharacter(dMC2DCharacter);
        }
    }

    private void aiSeperateCharacter(DMC2DCharacter dMC2DCharacter) {
        for (int i = 1; i < 5; ++i) {
            if (this.gameItems[i] == null || !this.gameItems[i].alive || this.gameItems[i].id == dMC2DCharacter.id || this.gameItems[i].AIState == 5 || this.gameItems[i].AIState == 9 || Math.abs(this.gameItems[i].x - dMC2DCharacter.x) >= 10 || dMC2DCharacter.AIState == 11) continue;
            if (this.gameItems[i].z < dMC2DCharacter.z) {
                if (dMC2DCharacter.z - this.gameItems[i].z >= 10) continue;
                dMC2DCharacter.z += 5;
                continue;
            }
            if (this.gameItems[i].z - dMC2DCharacter.z >= 10) continue;
            dMC2DCharacter.z -= 5;
        }
    }

    private void aiSetAvadeXYZ(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2) {
        dMC2DCharacter.targetX = dMC2DCharacter.x < dMC2DCharacter2.x ? dMC2DCharacter.x - ranges[dMC2DCharacter.type][4][0] : dMC2DCharacter.x + ranges[dMC2DCharacter.type][4][0];
        dMC2DCharacter.targetZ = dMC2DCharacter.z < 60 ? dMC2DCharacter.z + ranges[dMC2DCharacter.type][4][2] : dMC2DCharacter.z - ranges[dMC2DCharacter.type][4][2];
    }

    private void aiSetSlothRandomTarget(DMC2DCharacter dMC2DCharacter) {
        int n = 80;
        int n2 = 20;
        int n3 = 10;
        int n4 = this.characterGetScreenX(this.dante);
        int n5 = n4 > 120 ? DMC2DCanvas.random(n4 - (n + n3)) + n3 : 240 - DMC2DCanvas.random(240 - n4 - (n + n3)) - n3;
        int n6 = this.dante.z > 60 ? DMC2DCanvas.random(this.dante.z - (n2 + 4)) + 4 : 120 - DMC2DCanvas.random(120 - this.dante.z - (n2 + 4)) - 4;
        dMC2DCharacter.setTargetXYZ(this.aiGetMapXFromScreenX(n5), 0, n6);
    }

    private void aiSpawnOrb(DMC2DCharacter dMC2DCharacter, int n, int n2, int n3, byte by) {
        for (int i = 6; i < 22; ++i) {
            if (this.gameItems[i] != null) continue;
            this.gameItems[i] = this.aiCreateOrb(n, n2, n3, orbValues[dMC2DCharacter.type][by == 8 ? 0 : 1], by);
            return;
        }
    }

    private void aiSpawnSword(DMC2DCharacter dMC2DCharacter) {
        for (int i = 23; i < 39; ++i) {
            if (this.gameItems[i] != null) continue;
            this.gameItems[i] = this.aiCreateSword(dMC2DCharacter);
            return;
        }
    }

    private void aiTargetEnemies() {
        int n;
        DMC2DCharacter[] dMC2DCharacterArray = new DMC2DCharacter[this.characterCount];
        int n2 = 0;
        for (n = 1; n < 5; ++n) {
            if (this.gameItems[n] == null || !this.gameItems[n].alive) continue;
            dMC2DCharacterArray[n2++] = this.gameItems[n];
        }
        this.aiBubbleSortByDistance(dMC2DCharacterArray, this.dante);
        if (dMC2DCharacterArray.length == 1 && dMC2DCharacterArray[0].targetFace != -1) {
            return;
        }
        for (n = dMC2DCharacterArray.length - 1; n >= this.mission[4]; --n) {
            if (dMC2DCharacterArray[n].AIState == 14 || dMC2DCharacterArray[n].AIState == 11) continue;
            this.aiTargetRelease(dMC2DCharacterArray[n]);
        }
        for (n = 0; n < dMC2DCharacterArray.length; ++n) {
            if (dMC2DCharacterArray[n] == null || !dMC2DCharacterArray[n].alive || dMC2DCharacterArray[n].AIState == 14 || dMC2DCharacterArray[n].AIState == 11) continue;
            this.aiTargetRelease(dMC2DCharacterArray[n]);
            n2 = -1;
            if (dMC2DCharacterArray[n].type == 2) {
                n2 = this.aiTargetGetRear(dMC2DCharacterArray[n], this.dante);
            }
            if (n2 == -1) {
                n2 = this.aiTargetGetClosest(dMC2DCharacterArray[n], this.dante);
            }
            if (n2 == -1) continue;
            this.aiTargetLock(dMC2DCharacterArray[n], n2);
        }
    }

    private int aiTargetGetClosest(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2) {
        if (!(dMC2DCharacter.x >= dMC2DCharacter2.x || this.targetSlots[0][0] && this.targetSlots[0][1])) {
            return 0;
        }
        if (!this.targetSlots[1][0] || !this.targetSlots[1][1]) {
            return 1;
        }
        if (!this.targetSlots[0][0] || !this.targetSlots[0][1]) {
            return 0;
        }
        if (!this.targetSlots[1][0] || !this.targetSlots[1][1]) {
            return 1;
        }
        return -1;
    }

    private int aiTargetGetRear(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2) {
        if (!(this.dante.face != 64 || this.characterGetScreenX(this.dante) <= 74 || this.targetSlots[0][0] && this.targetSlots[0][1])) {
            return 0;
        }
        if (!(this.dante.face != 32 || this.characterGetScreenX(this.dante) >= 166 || this.targetSlots[1][0] && this.targetSlots[1][1])) {
            return 1;
        }
        return -1;
    }

    private boolean aiTargetIsInRange(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2, short[] sArray) {
        int n;
        int n2 = (sArray[0] + sArray[1]) / 2;
        int n3 = dMC2DCharacter2.x + (dMC2DCharacter.targetFace == 0 ? -n2 : n2);
        int n4 = Math.abs(dMC2DCharacter.x - n3);
        return n4 < (n = Math.abs(dMC2DCharacter.x - dMC2DCharacter2.x)) && n > sArray[1] && n < sArray[0] && Math.abs(dMC2DCharacter2.z - dMC2DCharacter.z) < sArray[2] && dMC2DCharacter2.y < dMC2DCharacter.y + sArray[3];
    }

    private boolean aiTargetIsOnSide(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2) {
        if (dMC2DCharacter.targetFace == 0 && dMC2DCharacter.x > dMC2DCharacter2.x) {
            return false;
        }
        return dMC2DCharacter.targetFace != 1 || dMC2DCharacter.x >= dMC2DCharacter2.x;
    }

    private void aiTargetLock(DMC2DCharacter dMC2DCharacter, int n) {
        if (n != -1 && this.targetCount < this.mission[4]) {
            if (!this.targetSlots[n][0]) {
                this.targetSlots[n][0] = true;
            } else {
                this.targetSlots[n][1] = true;
            }
            this.targetCount = (byte)(this.targetCount + 1);
            dMC2DCharacter.targetFace = n;
        }
    }

    private void aiTargetRelease(DMC2DCharacter dMC2DCharacter) {
        if (dMC2DCharacter.targetFace != -1) {
            if (this.targetSlots[dMC2DCharacter.targetFace][0]) {
                this.targetSlots[dMC2DCharacter.targetFace][0] = false;
            } else {
                this.targetSlots[dMC2DCharacter.targetFace][1] = false;
            }
            dMC2DCharacter.targetFace = -1;
            this.targetCount = (byte)(this.targetCount - 1);
        }
    }

    private void aiUnrest(DMC2DCharacter dMC2DCharacter) {
        for (int i = 0; i < dMC2DCharacter.rest.length; ++i) {
            if (dMC2DCharacter.rest[i] <= 0) continue;
            int n = i;
            dMC2DCharacter.rest[n] = (byte)(dMC2DCharacter.rest[n] - 1);
        }
    }

    private void appChangeState(byte by) {
        this.horizontalScrollTime = -14;
        this.headerScrollTime = -14;
        this.textBoxStartLine = 0;
        switch (by) {
            case 4: {
                this.sound.stopSound();
                this.menuOptionsCount = 5;
                this.menuHighlight = this.menuSelection;
                this.menuDirection = 0;
                this.selectionScrollCounter = 0;
            }
            case 2: {
                this.gameState = by;
                this.sofykeysSet(2, 5);
                break;
            }
            case 31: {
                this.sofykeysSet(1, 0);
                this.textPrepareMessage(this.text[53], 114);
                break;
            }
            case 8: {
                if (this.currentMission >= 12) {
                    this.currentMission = (byte)11;
                } else if (this.currentMission < 0) {
                    this.currentMission = 0;
                }
                this.sofykeysSet(1, 4);
                this.ioLoadMissionData("missions", this.currentMission);
                this.textPrepareObjective(false);
                break;
            }
            case 13: {
                if (this.gameState == 42) {
                    this.optionsState = this.gameState;
                } else if (this.gameState == 4) {
                    this.optionsState = this.gameState;
                }
                this.sofykeysSet(2, 4);
                this.menuSelection = 1;
                this.menuOptionsCount = 2;
                break;
            }
            case 20: {
                this.sofykeysSet(3, 6);
                this.textPrepareMessage(" $" + this.text[30] + "$ ", 114);
                break;
            }
            case 21: {
                this.loadRandomMenuBanner();
                if (this.gameState == 4) {
                    this.menuSelection = 0;
                }
                this.sofykeysSet(2, 4);
                break;
            }
            case 27: {
                this.sofykeysSet(3, 6);
                break;
            }
            case 14: {
                this.textInitAbout();
                this.sofykeysSet(0, 4);
                break;
            }
            case 23: {
                this.sofykeysSet(0, 4);
                this.textPrepareMessage(this.getGetMoreGamesText(), 114);
                break;
            }
            case 15: {
                this.menuOptionsCount = 2;
                this.menuSelection = 0;
                this.sofykeysSet(2, 0);
                break;
            }
            case 26: {
                this.menuOptionsCount = 2;
                this.menuSelection = 0;
                this.sofykeysSet(2, 0);
                break;
            }
            case 6: {
                this.textPrepareMessage(this.text[52] + "$ $" + this.text[46] + "$" + this.keyCodesGetCustomKeyName(this.keyCodes[4][0]) + " " + this.text[38] + " " + this.keyCodesGetCustomKeyName(this.keyCodes[4][1]) + "$ $" + this.text[47] + "$" + this.keyCodesGetCustomKeyName(this.keyCodes[6][0]) + " " + this.text[38] + " " + this.keyCodesGetCustomKeyName(this.keyCodes[6][1]) + "$ $" + this.text[44] + "$" + this.keyCodesGetCustomKeyName(this.keyCodes[2][0]) + " " + this.text[38] + " " + this.keyCodesGetCustomKeyName(this.keyCodes[2][1]) + "$ $" + this.text[45] + "$" + this.keyCodesGetCustomKeyName(this.keyCodes[3][0]) + " " + this.text[38] + " " + this.keyCodesGetCustomKeyName(this.keyCodes[3][1]) + "$ $" + this.text[42] + "$" + this.keyCodesGetCustomKeyName(this.keyCodes[0][0]) + " " + this.text[38] + " " + this.keyCodesGetCustomKeyName(this.keyCodes[0][1]) + "$ $" + this.text[43] + "$" + this.keyCodesGetCustomKeyName(this.keyCodes[1][0]) + " " + this.text[38] + " " + this.keyCodesGetCustomKeyName(this.keyCodes[1][1]) + "$ $ $" + this.text[70] + "$ $" + this.text[71] + "$" + this.text[66] + "$ $" + this.text[72] + "$" + this.text[67] + "$ $" + this.text[73] + "$" + this.text[68] + "$ $" + this.text[74] + "$" + this.text[69], 114);
                this.sofykeysSet(0, 4);
                break;
            }
            case 24: {
                this.sofykeysSet(0, 0);
                this.loadingCounter = -1;
                break;
            }
            case 25: {
                this.sofykeysSet(2, 0);
                this.menuOptionsCount = 1;
                break;
            }
            case 41: {
                this.textPrepareObjective(true);
                this.sound.stopSound();
                this.sofykeysSet(9, 0);
                break;
            }
            case 42: {
                this.sound.stopSound();
                if (this.gameState == 40) {
                    this.menuSelection = 0;
                }
                this.menuOptionsCount = 4;
                this.sofykeysSet(2, 4);
                break;
            }
            case 43: {
                this.sofykeysSet(3, 6);
                this.textPrepareMessage(" $" + this.text[57] + "$ ", 114);
                break;
            }
            case 44: {
                this.sofykeysSet(3, 6);
                this.textPrepareMessage(" $" + this.text[56] + "$ ", 114);
                break;
            }
            case 40: {
                this.sofykeysSet(7, 8);
                this.sound.setBGM((byte)1);
                break;
            }
        }
        this.lastGameState = this.gameState;
        this.gameState = by;
    }

    private void appDoNextState() {
        if (this.nextState != -1) {
            this.appChangeState(this.nextState);
            this.nextState = (byte)-1;
        }
    }

    private void appExit() {
        if (this.sound != null) {
            this.sound.stopSound();
        }
        System.gc();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        DMC2DMIDlet.app.terminateApp();
    }

    private void appInit() {
        this.util = new Utilities();
        this.util.init();
        this.textLoadBoot();
        this.languageSelected = this.rmsReadLanguage();
    }

    private void appInitialLoad(int n) {
        switch (n) {
            case 0: {
                barImage = null;
                logoImage = null;
                System.gc();
                this.text = new String[75];
                this.textLoad(this.text, "all.txt", 5, 75, -1);
                break;
            }
            case 1: {
                this.gameItems = new DMC2DCharacter[40];
                this.gameItems[0] = this.dante = new DMC2DCharacter(this);
                this.map = new DMC2DMap(this);
                this.sound = new DMC2DSound(this);
                break;
            }
            case 2: {
                random = new Random();
                this.ioLoadHUDImages();
                this.keyCodesInit();
                this.map.initMap();
                this.ioLoadMenuImages();
                break;
            }
            case 3: {
                imageOffsets = this.ioLoadShort3("imgos");
                characterAnim = this.ioLoadByte4("charanim");
                characterPositionOffsets = this.ioLoadShort3("cpos");
                DMC2DCanvas.characterPositionOffsets[6] = characterPositionOffsets[0];
                DMC2DCanvas.imageOffsets[6] = imageOffsets[0];
                if (!this.rmsLoad()) {
                    this.appInitialiseFirstPlay();
                }
                this.uiSetTitleMenuSelection();
            }
        }
    }

    private void appInitialiseFirstPlay() {
        this.currentMission = 0;
        this.hasContinue = false;
    }

    public int characterGetScreenX(DMC2DCharacter dMC2DCharacter) {
        return dMC2DCharacter.x - this.map.currentScreen * 240;
    }

    public int characterGetScreenY(DMC2DCharacter dMC2DCharacter) {
        return -(dMC2DCharacter.y / 2) + dMC2DCharacter.z / 1;
    }

    private DMC2DCharacter[] characterGetZSortedList() {
        int n;
        DMC2DCharacter[] dMC2DCharacterArray = null;
        int n2 = 0;
        for (n = 0; n < this.gameItems.length; ++n) {
            if (this.gameItems[n] == null || !this.gameItems[n].alive) continue;
            ++n2;
        }
        dMC2DCharacterArray = new DMC2DCharacter[n2];
        n2 = 0;
        for (n = 0; n < this.gameItems.length; ++n) {
            if (this.gameItems[n] == null || !this.gameItems[n].alive) continue;
            dMC2DCharacterArray[n2++] = this.gameItems[n];
        }
        this.aiBubbleSortByZ(dMC2DCharacterArray);
        return dMC2DCharacterArray;
    }

    private int danteActionPeek() {
        return this.actionCue[0];
    }

    private int danteActionPop() {
        int n = this.actionCue[0];
        this.actionCue[this.actionCue.length - 1] = 0;
        for (int i = 0; i < this.actionCue.length - 1; ++i) {
            this.actionCue[i] = this.actionCue[i + 1];
        }
        return n;
    }

    private void danteActionPush(int n) {
        if (n == 4 && (this.actionCue[0] == 4 || this.dante.anim == 2)) {
            return;
        }
        for (int i = this.actionCue.length - 1; i > 0; --i) {
            this.actionCue[i] = this.actionCue[i - 1];
        }
        this.actionCue[0] = n;
    }

    private void danteActionsClear() {
        for (int i = 0; i < this.actionCue.length; ++i) {
            this.actionCue[i] = 0;
        }
    }

    private void danteAnimate() {
        switch (this.dante.anim) {
            case 0: {
                this.dante.animFrame = 0;
                this.dante.vulnerable = true;
                break;
            }
            case 1: {
                this.dante.faceDirection();
                this.danteMove(14);
                this.dante.animFrame = (byte)(this.dante.animFrame + 1);
                if (this.dante.animFrame < characterAnim[0][this.dante.anim].length) break;
                this.dante.animFrame = 0;
                break;
            }
            case 2: {
                this.dante.faceDirection();
                this.dante.animFrame = 0;
                if (this.dante.y == 0) {
                    this.danteDoNextAnim((byte)0);
                    break;
                }
                this.danteMove(9);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (this.dante.anim == 6 && this.dante.animFrame > 0 || this.dante.animFrame == danteAttackFrame[this.dante.anim]) {
                    this.danteDoAttack();
                }
            }
            case 10: 
            case 11: {
                if (this.dante.anim == 11 && this.dante.y > 0 && this.dante.animFrame > 0) {
                    this.dante.animFrame = 0;
                }
                if ((this.dante.animFrame = (byte)(this.dante.animFrame + 1)) < characterAnim[0][this.dante.anim].length) break;
                this.dante.gravityModifier = 0;
                this.dante.faceDirection();
                if (this.dante.anim == 7) {
                    this.danteSetNextAnim((byte)2, (byte)0);
                } else if (this.dante.anim == 6) {
                    this.danteDoNextAnim((byte)0);
                } else if (this.dante.anim == 11) {
                    if (this.dante.life > 0) {
                        this.danteDoNextAnim((byte)0);
                    } else {
                        this.dante.animFrame = (byte)(characterAnim[0][this.dante.anim].length - 1);
                    }
                } else {
                    this.danteDoNextAnim((byte)0);
                }
                if (this.dante.anim == 11) {
                    this.danteDead = true;
                }
                this.dante.vulnerable = true;
                break;
            }
            case 12: {
                this.dante.animFrame = 0;
                if (this.dante.y != 0) break;
                this.danteDoNextAnim((byte)0);
            }
        }
        this.dante.jumpUpThrust = this.dante.jumpUpThrust + -35 < 0 || this.dante.gravityModifier == -125 ? (this.dante.jumpUpThrust += -35 + this.dante.gravityModifier) : (this.dante.jumpUpThrust += -35);
        if ((this.dante.y += this.dante.jumpUpThrust) < 0) {
            this.dante.y = 0;
            this.dante.gravityModifier = 0;
        }
        if (this.dante.z > 116) {
            this.dante.z = 116;
        } else if (this.dante.z < 4) {
            this.dante.z = 4;
        }
        if (this.dante.momentum != 0) {
            int n = this.danteClipToCurrentScreen(this.dante.x + this.dante.momentum);
            this.danteDoObjectCollision(this.dante, n, this.dante.z);
            this.dante.momentum = this.dante.momentum - (this.dante.momentum > 0 ? 8 : -8);
        }
        if (this.dante.x < this.map.startLock * 240 + 4) {
            this.dante.x = this.map.startLock * 240 + 4;
        } else if (this.dante.x > this.map.endLock * 240 - 4) {
            if (this.missionState == 2) {
                this.nextRoomSection = true;
            }
            this.dante.x = this.map.endLock * 240 - 4;
        }
        this.map.checkMap(this.dante.x);
        if (this.doppelgangerState == 1 && this.characterGetScreenX(this.dante) >= 48) {
            this.danteSetNextAnim((byte)0, (byte)0);
            this.danteActionsClear();
            this.dante.direction = 0;
            this.doppelgangerState = (byte)2;
            this.doppelgangerEffectCount = (byte)3;
        }
    }

    private boolean danteAttackIsInRange(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2, short[] sArray) {
        if (dMC2DCharacter.face == 64) {
            if (dMC2DCharacter2.x - dMC2DCharacter.x > sArray[0]) {
                return false;
            }
            if (dMC2DCharacter2.x - dMC2DCharacter.x < sArray[1]) {
                return false;
            }
        } else {
            if (dMC2DCharacter.x - dMC2DCharacter2.x > sArray[0]) {
                return false;
            }
            if (dMC2DCharacter.x - dMC2DCharacter2.x < sArray[1]) {
                return false;
            }
        }
        if (Math.abs(dMC2DCharacter2.z - dMC2DCharacter.z) > sArray[2]) {
            return false;
        }
        return dMC2DCharacter.y >= dMC2DCharacter2.y || Math.abs(dMC2DCharacter2.y - dMC2DCharacter.y) <= sArray[3];
    }

    public void danteClearImages() {
        DMC2DCanvas.characterImages[0] = null;
    }

    private int danteClipToCurrentScreen(int n) {
        int n2 = this.map.currentScreen * 240 + 4;
        int n3 = this.map.currentScreen * 240 + 240 - 4;
        if (n < n2) {
            n = n2;
        } else if (n > n3) {
            n = n3;
        }
        return n;
    }

    private void danteComboAddAction(int n) {
        for (int i = this.keyRecord.length - 1; i > 0; --i) {
            this.keyRecord[i] = this.keyRecord[i - 1];
        }
        this.keyRecord[0] = n;
    }

    private boolean danteComboCheck(int n, int n2, int n3) {
        for (int i = n2; i < n3; ++i) {
            if ((this.keyRecord[i] & (long)n) == 0L) continue;
            this.danteComboClear();
            return true;
        }
        return false;
    }

    private void danteComboClear() {
        for (int i = 0; i < this.keyRecord.length; ++i) {
            this.keyRecord[i] = 0L;
        }
    }

    private void danteDoAttack() {
        int n;
        boolean bl = false;
        int n2 = 0;
        boolean[] blArray = null;
        if (this.dante.anim == 9) {
            blArray = new boolean[5];
        }
        for (n = 1; n < 5; ++n) {
            if (this.gameItems[n] != null && this.gameItems[n].alive && this.gameItems[n].vulnerable && this.danteAttackIsInRange(this.dante, this.gameItems[n], ranges[0][this.dante.anim - 3])) {
                this.aiRest(this.gameItems[n], 0, enemyAiStats[this.gameItems[n].type][this.gameItems[n].difficulty][7], enemyAiStats[this.gameItems[n].type][this.gameItems[n].difficulty][12]);
                this.gameItems[n].impact = 0;
                switch (this.dante.anim) {
                    case 7: {
                        this.gameItems[n].setState((byte)6, (byte)-1);
                        this.gameItems[n].jumpUpThrust = 125;
                        ++this.gameItems[n].y;
                        break;
                    }
                    case 8: {
                        if (this.gameItems[n].AIState == 6) {
                            this.gameItems[n].gravityModifier = (byte)-125;
                            this.gameItems[n].setState((byte)5, (byte)0);
                            break;
                        }
                        this.gameItems[n].setState((byte)5, (byte)0);
                        break;
                    }
                    case 9: {
                        bl = true;
                        if (this.gameItems[n].AIState == 6) {
                            this.gameItems[n].setState((byte)8, (byte)-1);
                            this.gameItems[n].gravityModifier = (byte)30;
                            n2 = this.weaponStats[1][0][this.gunLevel];
                            break;
                        }
                        blArray[n] = true;
                        break;
                    }
                    case 6: {
                        if (this.gameItems[n].AIState == 4 || this.gameItems[n].AIState == 5) break;
                        int n3 = this.gameItems[n].momentum = this.dante.face == 64 ? 32 : -32;
                        if (this.gameItems[n].type == 3 && this.gameItems[n].difficulty != 0) {
                            this.gameItems[n].setState((byte)4, (byte)0);
                            break;
                        }
                        this.gameItems[n].setState((byte)5, (byte)0);
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (this.gameItems[n].type == 3 && this.gameItems[n].difficulty != 0) {
                            this.gameItems[n].momentum = this.dante.face == 64 ? 16 : -16;
                            break;
                        }
                        this.gameItems[n].setState((byte)4, (byte)-1);
                        break;
                    }
                    case 5: {
                        if (this.gameItems[n].type == 3 && this.gameItems[n].difficulty != 0) {
                            this.gameItems[n].setState((byte)4, (byte)-1);
                        } else {
                            this.gameItems[n].setState((byte)5, (byte)-1);
                        }
                        int n4 = this.gameItems[n].momentum = this.dante.face == 64 ? 16 : -16;
                    }
                }
                if (this.dante.anim == 9 && (this.dante.anim != 9 || this.gameItems[n].AIState != 6)) continue;
                if (this.dante.anim != 7) {
                    this.aiAddHit(this.gameItems[n], this.dante.anim);
                }
                this.gameItems[n].life = (byte)(this.gameItems[n].life - (byte)(n2 + this.weaponStats[bl ? 1 : 0][0][bl ? this.gunLevel : this.swordLevel] * enemyAiStats[this.gameItems[n].type][this.gameItems[n].difficulty][4] / 100));
                continue;
            }
            if (this.gameItems[n] == null || !this.gameItems[n].alive || this.gameItems[n].AIState != 7 && this.gameItems[n].AIState != 5 || this.gameItems[n].vulnerable || !this.danteAttackIsInRange(this.dante, this.gameItems[n], ranges[0][this.dante.anim - 3])) continue;
            this.gameItems[n].momentum = this.dante.x < this.gameItems[n].x ? 8 : -8;
            this.gameItems[n].life = (byte)(this.gameItems[n].life - (byte)(this.weaponStats[bl ? 1 : 0][0][bl ? this.gunLevel : this.swordLevel] * enemyAiStats[this.gameItems[n].type][this.gameItems[n].difficulty][4] / 100));
            this.gameItems[n].impact = 1;
        }
        if (this.dante.anim == 9) {
            int n5;
            n = 8;
            for (n5 = 1; n5 < 5; ++n5) {
                if (!blArray[n5]) continue;
                for (int i = 1; i < 5; ++i) {
                    if (!blArray[i] || Math.abs(this.gameItems[i].x - this.dante.x) >= Math.abs(this.gameItems[n5].x - this.dante.x) || Math.abs(this.gameItems[i].z - this.gameItems[n5].z) >= n) continue;
                    blArray[n5] = false;
                    this.gameItems[n5].impact = (byte)-1;
                }
            }
            for (n5 = 1; n5 < 5; ++n5) {
                if (!blArray[n5]) continue;
                this.gameItems[n5].setState((byte)4, (byte)-1);
                if (this.dante.anim != 7) {
                    this.aiAddHit(this.gameItems[n5], this.dante.anim);
                }
                this.gameItems[n5].life = (byte)(this.gameItems[n5].life - (byte)(n2 + this.weaponStats[1][0][this.gunLevel] * enemyAiStats[this.gameItems[n5].type][this.gameItems[n5].difficulty][4] / 100));
            }
        }
        for (n = 23; n < 39; ++n) {
            if (this.gameItems[n] == null || !this.gameItems[n].alive || !this.gameItems[n].vulnerable || !this.danteAttackIsInRange(this.dante, this.gameItems[n], ranges[0][this.dante.anim - 3])) continue;
            this.gameItems[n].life = (byte)(this.gameItems[n].life - 1);
            if (this.gameItems[n].life <= 0) {
                this.gameItems[n].momentum = this.dante.x < this.gameItems[n].x ? 16 : -16;
                this.gameItems[n].jumpUpThrust = 40;
                this.gameItems[n].y = 1;
                if (this.gameItems[n].AIState != -1) {
                    this.aiSpawnOrb(this.gameItems[n], this.gameItems[n].x + 4, 60, this.gameItems[n].z, DMC2DCanvas.aiChoice((byte)80) ? (byte)8 : 9);
                }
                this.gameItems[n].AIState = (byte)-1;
                this.gameItems[n].vulnerable = false;
                continue;
            }
            this.gameItems[n].momentum = this.dante.x < this.gameItems[n].x ? 8 : -8;
            this.gameItems[n].vulnerable = false;
            this.gameItems[n].anim = (byte)3;
        }
    }

    private void danteDoNextAnim(byte by) {
        this.dante.anim = this.dante.nextAnim;
        this.dante.nextAnim = 0;
        this.dante.animFrame = by;
    }

    private void danteDoObjectCollision(DMC2DCharacter dMC2DCharacter, int n, int n2) {
        int n3 = 24;
        int n4 = 12;
        boolean bl = false;
        for (int i = 23; i < 39; ++i) {
            if (this.gameItems[i] == null || Math.abs(this.gameItems[i].x - n) >= n3 || Math.abs(this.gameItems[i].z - n2) >= n4) continue;
            if (Math.abs(dMC2DCharacter.x - this.gameItems[i].x) < n3) {
                dMC2DCharacter.z = dMC2DCharacter.z < this.gameItems[i].z ? this.gameItems[i].z - n4 : this.gameItems[i].z + n4;
                bl = true;
                continue;
            }
            dMC2DCharacter.x = dMC2DCharacter.x < this.gameItems[i].x ? this.gameItems[i].x - n3 : this.gameItems[i].x + n3;
            bl = true;
        }
        if (!bl) {
            dMC2DCharacter.x = n;
            dMC2DCharacter.z = n2;
        }
    }

    private void danteGetNextAction() {
        int n;
        if (this.dante.anim == 1 && this.dante.direction == 0) {
            this.danteSetNextAnim((byte)0, (byte)-1);
        }
        if (this.dante.anim == 1 || this.dante.anim == 0) {
            n = this.danteActionPop();
            if (n != 0) {
                switch (n) {
                    case 4: {
                        if (this.dante.y > 0) break;
                        this.danteSetNextAnim((byte)2, (byte)-1);
                        break;
                    }
                    case 1: {
                        if (this.danteComboCheck(this.dante.face, 0, 3)) {
                            this.danteSetNextAnim((byte)7, (byte)-1);
                            break;
                        }
                        if (this.danteComboCheck(1, 0, 6)) {
                            this.swordSlash = (byte)(this.swordSlash + 1);
                            if (this.swordSlash >= 3) {
                                this.swordSlash = 0;
                            }
                        } else {
                            this.swordSlash = 0;
                        }
                        this.danteSetNextAnim((byte)(3 + this.swordSlash), (byte)-1);
                        break;
                    }
                    case 2: {
                        this.danteSetNextAnim((byte)9, (byte)-1);
                        break;
                    }
                    case 8: 
                    case 16: {
                        this.danteSetNextAnim((byte)1, (byte)-1);
                        break;
                    }
                    case 32: 
                    case 64: {
                        this.dante.face = n;
                        if (this.danteComboCheck(n, 0, 3)) {
                            this.dante.momentum = this.dante.face == 64 ? 24 : -24;
                            this.danteSetNextAnim((byte)6, (byte)-1);
                            break;
                        }
                        this.danteSetNextAnim((byte)1, (byte)-1);
                    }
                }
            } else if (this.dante.anim == 0 && this.dante.direction != 0) {
                this.danteSetNextAnim((byte)1, (byte)-1);
            }
            this.danteComboAddAction(n);
        } else {
            this.danteComboAddAction(0);
        }
        n = this.danteActionPeek();
        if (this.dante.anim == 9 && (n == 32 && this.dante.face != 32 || n == 64 && this.dante.face != 64) && this.dante.y == 0) {
            this.danteActionPop();
            int n2 = this.dante.momentum = this.dante.face != 64 ? 16 : -16;
        }
        if (this.dante.anim == 2 && this.danteActionPeek() == 2) {
            this.danteActionPop();
            this.dante.gravityModifier = (byte)30;
            this.danteSetNextAnim((byte)9, (byte)-1);
        } else if (this.dante.anim == 2 && this.danteActionPeek() == 1) {
            this.danteActionPop();
            if (this.dante.y > 130 || this.dante.jumpUpThrust < 0) {
                this.dante.jumpUpThrust = 135;
                this.dante.gravityModifier = (byte)-125;
                this.danteSetNextAnim((byte)8, (byte)-1);
            } else {
                this.danteSetNextAnim((byte)5, (byte)-1);
            }
        }
    }

    private void danteInit() {
        this.dante.init((byte)0, characterImages[0], ingameImages[3]);
        this.dante.setXYZ(40, 0, 60);
        this.dante.jumpUpThrust = 0;
        this.dante.momentum = 0;
        this.dante.impact = (byte)-1;
        this.dante.face = 64;
        this.dante.setAnim((byte)0, (byte)0);
        this.dante.alive = true;
        this.dante.vulnerable = true;
        this.dante.life = (byte)100;
        this.dante.id = -1;
        this.danteDead = false;
    }

    private void danteInputPressed(int n) {
        if (this.doppelgangerState >= 2 && this.doppelgangerState <= 5) {
            return;
        }
        switch (n) {
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: {
                this.danteUpdateDirection(n);
            }
            case 1: 
            case 4: {
                this.danteActionPush(n);
            }
        }
    }

    private void danteInputReleased(int n) {
        switch (n) {
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                if ((this.dante.direction & n) == 0) break;
                this.dante.direction ^= n;
                break;
            }
            case 128: {
                this.dante.direction = 0;
            }
        }
    }

    public void danteLoadImages() {
        this.ioLoadCharacterImages(0);
        this.dante.init((byte)0, characterImages[0], ingameImages[3]);
    }

    private void danteMove(int n) {
        int n2 = 1;
        int n3 = this.dante.x;
        int n4 = this.dante.z;
        if ((this.dante.direction & 0x40) != 0) {
            n3 = this.dante.x + n;
            n2 = 2;
        } else if ((this.dante.direction & 0x20) != 0) {
            n3 = this.dante.x - n;
            n2 = 2;
        }
        if ((this.dante.direction & 8) != 0) {
            n4 = this.dante.z - n / n2;
        } else if ((this.dante.direction & 0x10) != 0) {
            n4 = this.dante.z + n / n2;
        }
        this.danteDoObjectCollision(this.dante, n3, n4);
    }

    private void danteRun() {
        if (this.missionHasCondition((byte)2) && this.runCounter % 4 == 0) {
            this.dante.life = (byte)(this.dante.life - 1);
        }
        if (this.dante.life <= 0 && this.dante.anim != 11) {
            this.dante.setAnim((byte)11, (byte)-1);
        }
        this.danteGetNextAction();
        this.danteAnimate();
    }

    private void danteSetNextAnim(byte by, byte by2) {
        this.dante.nextAnim = by;
        switch (this.dante.anim) {
            case 0: 
            case 1: 
            case 7: {
                if (this.dante.nextAnim != 2) break;
                this.dante.jumpUpThrust = 125;
                ++this.dante.y;
            }
        }
        if (this.dante.anim == 1 && this.dante.nextAnim == 1) {
            this.danteDoNextAnim(this.dante.animFrame);
        } else {
            this.danteDoNextAnim(by2);
        }
    }

    private void danteTakeHit(DMC2DCharacter dMC2DCharacter) {
        int n = this.dante.x - this.map.currentScreen * 240;
        int n2 = -(this.dante.y / 2) + this.dante.z / 1 - impactEffectHeight[0][0];
        this.impactEffectAdd(n, n2);
        if (!(this.cheatEnabled && this.cheats[2] || this.missionState == 3)) {
            this.dante.life = (byte)(this.dante.life - enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][3]);
            this.missionDamage = (byte)(this.missionDamage - enemyAiStats[dMC2DCharacter.type][dMC2DCharacter.difficulty][3]);
            if (this.missionDamage < 0) {
                this.missionDamage = 0;
            }
            if (this.dante.life <= 0) {
                this.dante.life = 0;
            }
        }
        this.dante.momentum = 0;
        if (dMC2DCharacter.AIState == 11) {
            int n3 = this.dante.momentum = dMC2DCharacter.face == 64 ? 32 : -32;
            if (dMC2DCharacter.type == 3 && dMC2DCharacter.difficulty < 2) {
                this.dante.setAnim((byte)10, (byte)0);
            } else {
                this.dante.setAnim((byte)11, (byte)0);
            }
        } else if (dMC2DCharacter.AIState == 16) {
            this.dante.setAnim((byte)12, (byte)0);
            this.dante.jumpUpThrust = 125;
            ++this.dante.y;
        } else if (dMC2DCharacter.AIState == 17) {
            this.dante.setAnim((byte)11, (byte)0);
            this.dante.gravityModifier = (byte)-125;
        } else {
            this.dante.setAnim((byte)10, (byte)0);
        }
        this.dante.vulnerable = false;
        this.vibrate = true;
    }

    private void danteUpdateDirection(int n) {
        if (this.dante.anim == 11) {
            return;
        }
        if (n == 128) {
            this.dante.direction = 0;
            return;
        }
        if (n == 32) {
            if ((this.dante.direction & 0x40) != 0) {
                this.dante.direction ^= 0x40;
            }
        } else if (n == 64) {
            if ((this.dante.direction & 0x20) != 0) {
                this.dante.direction ^= 0x20;
            }
        } else if (n == 8) {
            if ((this.dante.direction & 0x10) != 0) {
                this.dante.direction ^= 0x10;
            }
        } else if (n == 16 && (this.dante.direction & 8) != 0) {
            this.dante.direction ^= 8;
        }
        if ((this.dante.direction & n) == 0) {
            this.dante.direction |= n;
        }
    }

    private void gamePlayRun() {
        int n;
        if (this.nextRoomSection) {
            this.nextRoomSection = false;
            this.map.nextRoomSection();
            this.missionSetState((byte)1);
        }
        if (this.missionState == 0) {
            if (--this.missionStateCounter <= 0) {
                this.missionSetState((byte)1);
            }
            return;
        }
        if (this.missionState == 3) {
            if (--this.missionStateCounter <= 0) {
                this.missionSetState((byte)5);
            }
        } else if (this.missionState == 4) {
            if (--this.missionStateCounter <= 0) {
                this.missionSetState((byte)6);
            }
        } else {
            if (this.missionState == 5) {
                this.missionCleanUp();
                this.sound.stopSound();
                this.missionFinish();
                return;
            }
            if (this.missionState == 6) {
                this.missionCleanUp();
                this.sound.stopSound();
                this.appChangeState((byte)26);
                return;
            }
            this.missionCheckStatus();
        }
        if (this.missionHasCondition((byte)1) && this.runCounter % 8 == 0) {
            --this.missionTimer;
            if (this.missionTimer < 0) {
                this.missionTimer = 0;
            }
        }
        this.danteRun();
        this.missionSpawnNextEnemy();
        this.aiTargetEnemies();
        for (n = 1; n < 5; ++n) {
            if (this.gameItems[n] == null || !this.gameItems[n].alive) continue;
            this.aiRun(this.gameItems[n]);
        }
        for (n = 6; n < 22; ++n) {
            if (this.gameItems[n] == null || !this.gameItems[n].alive) continue;
            this.orbRun(this.gameItems[n]);
        }
        for (n = 23; n < 39; ++n) {
            if (this.gameItems[n] == null || !this.gameItems[n].alive) continue;
            this.objectRun(this.gameItems[n]);
        }
    }

    private void impactEffectAdd(int n, int n2) {
        for (int i = this.impactEffect.length - 1; i > 0; --i) {
            this.impactEffect[i][0] = this.impactEffect[i - 1][0];
            this.impactEffect[i][1] = this.impactEffect[i - 1][1];
            this.impactEffect[i][2] = this.impactEffect[i - 1][2];
        }
        this.impactEffect[0][0] = n;
        this.impactEffect[0][1] = n2;
        this.impactEffect[0][2] = 2;
    }

    private void ioLoadBootImages() {
        try {
            logoImage = Image.createImage((String)"/capcom_logo.png");
            barImage = Image.createImage((String)"/bar.png");
            titleImageText = Image.createImage((String)"/tl_txt.png");
            this.initialised = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ioLoadCharacterImages(int n) {
        try {
            if (characterImages[n] == null) {
                DMC2DCanvas.characterImages[n] = new Image[n == 0 || n == 6 ? 3 : (n == 2 ? 2 : 1)];
                for (int i = 0; i < characterImages[n].length; ++i) {
                    byte[] byArray = null;
                    if (i == 0 && n == 2) {
                        byArray = this.util.getImageBytesWithPalette("/p0.png", "/lust.plt");
                    }
                    if (n == 6) {
                        DMC2DCanvas.characterImages[n][i] = this.util.createImageWithColourEffect("/" + characterFilenames[n] + i + ".png", -255, -255, -255, true);
                        continue;
                    }
                    if (this.mission != null && this.mission[10] != 0) {
                        if (byArray != null) {
                            DMC2DCanvas.characterImages[n][i] = this.util.createImageWithColourEffect(byArray, (int)this.colourSettings[this.mission[10]][0], (int)this.colourSettings[this.mission[10]][1], (int)this.colourSettings[this.mission[10]][2], this.colourSettings[this.mission[10]][3] == 1);
                            continue;
                        }
                        DMC2DCanvas.characterImages[n][i] = this.util.createImageWithColourEffect("/" + characterFilenames[n] + i + ".png", (int)this.colourSettings[this.mission[10]][0], (int)this.colourSettings[this.mission[10]][1], (int)this.colourSettings[this.mission[10]][2], this.colourSettings[this.mission[10]][3] == 1);
                        continue;
                    }
                    DMC2DCanvas.characterImages[n][i] = byArray != null ? Image.createImage((byte[])byArray, (int)0, (int)byArray.length) : Image.createImage((String)("/" + characterFilenames[n] + i + ".png"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ioLoadHUDImages() {
        try {
            hudImages = new Image[7];
            for (int i = 0; i < 7; ++i) {
                DMC2DCanvas.hudImages[i] = Image.createImage((String)("/h" + i + ".png"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ioLoadIngameImages() {
        try {
            ingameImages = new Image[7];
            for (int i = 0; i < 7; ++i) {
                DMC2DCanvas.ingameImages[i] = this.mission != null && this.mission[10] != 0 ? this.util.createImageWithColourEffect("/ig" + i + ".png", (int)this.colourSettings[this.mission[10]][0], (int)this.colourSettings[this.mission[10]][1], (int)this.colourSettings[this.mission[10]][2], this.colourSettings[this.mission[10]][3] == 1) : Image.createImage((String)("/ig" + i + ".png"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] ioLoadMap(String string) {
        InputStream inputStream = null;
        byte[] byArray = null;
        try {
            inputStream = this.getClass().getResourceAsStream(string);
            byte by = (byte)inputStream.read();
            byte by2 = (byte)inputStream.read();
            byArray = new byte[34 + by * 2 + by2 * 2];
            byArray[0] = by;
            byArray[1] = by2;
            inputStream.read(byArray, 2, byArray.length - 2);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] ioLoadMapItems(String string) {
        InputStream inputStream = null;
        Object object = null;
        try {
            inputStream = this.getClass().getResourceAsStream("/" + string);
            int n = inputStream.read();
            object = new byte[n][];
            for (int i = 0; i < n; ++i) {
                int n2 = inputStream.read();
                if ((n2 &= 0xFF) == 0) continue;
                object[i] = new byte[n2 * 2];
                object[i][0] = (byte)n2;
                inputStream.read(object[i], 0, object[i].length);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (Exception exception) {}
        }
        return object;
    }

    private void ioLoadMenuImages() {
        try {
            if (titleImageText == null) {
                titleImageText = Image.createImage((String)"/tl_txt.png");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ioLoadMissionData(String string, int n) {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream("/" + string);
            byte[] byArray = new byte[n * 11];
            inputStream.read(byArray, 0, byArray.length);
            this.mission = new byte[11];
            inputStream.read(this.mission, 0, this.mission.length);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ioLoadRoom(String string, int n) {
        InputStream inputStream = null;
        try {
            int n2;
            int n3;
            inputStream = this.getClass().getResourceAsStream("/" + string);
            for (n3 = 0; n3 < n - 1; ++n3) {
                inputStream.read();
                n2 = inputStream.read();
                byte[] byArray = new byte[n2];
                inputStream.read(byArray, 0, n2);
            }
            n3 = (byte)inputStream.read();
            n2 = (byte)inputStream.read();
            this.room = new byte[2 + n2];
            this.room[0] = n3;
            this.room[1] = n2;
            inputStream.read(this.room, 2, n2);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void ioLoadTileSet(int n) {
        try {
            this.map.tileSet = this.mission != null && this.mission[10] != 0 ? this.util.createImageWithColourEffect("/ts" + n + ".png", (int)this.colourSettings[this.mission[10]][0], (int)this.colourSettings[this.mission[10]][1], (int)this.colourSettings[this.mission[10]][2], this.colourSettings[this.mission[10]][3] == 1) : Image.createImage((String)("/ts" + n + ".png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short[][][] ioLoadShort3(String string) {
        Object object = null;
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(this.getClass().getResourceAsStream("/" + string));
            byte by = ((DataInputStream)filterInputStream).readByte();
            object = new short[by][][];
            for (int i = 0; i < ((short[][][])object).length; ++i) {
                by = ((DataInputStream)filterInputStream).readByte();
                object[i] = new short[by][];
                for (int j = 0; j < object[i].length; ++j) {
                    by = ((DataInputStream)filterInputStream).readByte();
                    object[i][j] = new short[by];
                    for (int k = 0; k < object[i][j].length; ++k) {
                        object[i][j][k] = ((DataInputStream)filterInputStream).readShort();
                    }
                }
            }
        }
        catch (IOException iOException) {
            object = null;
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] ioLoadByte2(String string) {
        Object object = null;
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(this.getClass().getResourceAsStream("/" + string));
            byte by = ((DataInputStream)filterInputStream).readByte();
            object = new byte[by][];
            for (int i = 0; i < ((byte[][])object).length; ++i) {
                by = ((DataInputStream)filterInputStream).readByte();
                object[i] = new byte[by];
                for (int j = 0; j < object[i].length; ++j) {
                    object[i][j] = ((DataInputStream)filterInputStream).readByte();
                }
            }
        }
        catch (IOException iOException) {
            object = null;
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][][][] ioLoadByte4(String string) {
        Object object = null;
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(this.getClass().getResourceAsStream("/" + string));
            byte by = ((DataInputStream)filterInputStream).readByte();
            object = new byte[by][][][];
            for (int i = 0; i < ((byte[][][][])object).length; ++i) {
                by = ((DataInputStream)filterInputStream).readByte();
                object[i] = new byte[by][][];
                for (int j = 0; j < object[i].length; ++j) {
                    by = ((DataInputStream)filterInputStream).readByte();
                    object[i][j] = new byte[by][];
                    for (int k = 0; k < object[i][j].length; ++k) {
                        by = ((DataInputStream)filterInputStream).readByte();
                        object[i][j][k] = new byte[by];
                        for (int i2 = 0; i2 < object[i][j][k].length; ++i2) {
                            object[i][j][k][i2] = ((DataInputStream)filterInputStream).readByte();
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            object = null;
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        return object;
    }

    private void itemRemove(DMC2DCharacter dMC2DCharacter) {
        boolean bl = false;
        for (int i = 0; i < 40; ++i) {
            if (this.gameItems[i] == null || dMC2DCharacter.id != this.gameItems[i].id) continue;
            this.gameItems[i] = null;
            bl = true;
        }
    }

    private String keyCodesGetCustomKeyName(int n) {
        int[] nArray = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -1, -2, -3, -4, -5, 42, 35, 999999};
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "^", "~", "<", ">", this.text[39], "*", "#", "-"};
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return stringArray[i];
        }
        return "";
    }

    private void keyCodesInit() {
        this.keyCodes[4][0] = 35;
        this.keyCodes[5][0] = 57;
        this.keyCodes[6][0] = 48;
        this.keyCodes[0][0] = -1;
        this.keyCodes[1][0] = -2;
        this.keyCodes[2][0] = -3;
        this.keyCodes[3][0] = -4;
        this.keyCodes[4][1] = -5;
        this.keyCodes[5][1] = 55;
        this.keyCodes[6][1] = 42;
        this.keyCodes[0][1] = 50;
        this.keyCodes[1][1] = 56;
        this.keyCodes[2][1] = 52;
        this.keyCodes[3][1] = 54;
        this.keyCodes[4][2] = 1;
        this.keyCodes[5][2] = 2;
        this.keyCodes[6][2] = 4;
        this.keyCodes[0][2] = 8;
        this.keyCodes[1][2] = 16;
        this.keyCodes[2][2] = 32;
        this.keyCodes[3][2] = 64;
    }

    protected void keyPressed(int n) {
        if (this.gameState == 40) {
            for (int i = 0; i < 7; ++i) {
                if (n != this.keyCodes[i][0] && n != this.keyCodes[i][1]) continue;
                this.danteInputPressed(this.keyCodes[i][2]);
                break;
            }
        }
        this.menuKey = n;
    }

    protected void keyReleased(int n) {
        if (this.gameState == 40) {
            for (int i = 0; i <= 3; ++i) {
                if (n != this.keyCodes[i][0] && n != this.keyCodes[i][1]) continue;
                this.danteInputReleased(this.keyCodes[i][2]);
                break;
            }
        }
    }

    private void loadRandomMenuBanner() {
        try {
            menuBannerImage = Image.createImage((String)("/b" + DMC2DCanvas.random(1) + ".png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void missionCheckStatus() {
        if (this.mission[5] == 4 && this.missionTimer <= 0) {
            this.missionStateCounter = 16;
            this.missionSetState((byte)3);
            return;
        }
        if (this.danteDead || this.missionTimer <= 0) {
            this.missionStateCounter = 16;
            this.missionSetState((byte)4);
            return;
        }
        if (this.missionObjectiveCount <= 0) {
            this.missionStateCounter = 16;
            this.missionSetState((byte)3);
            return;
        }
        if (this.missionEnemyCleared() && this.characterCount == 0) {
            if (this.map.endLock == this.map.screenCount) {
                if (this.mission[5] != 2) {
                    this.missionStateCounter = 16;
                    this.missionSetState((byte)3);
                }
            } else {
                this.missionSetState((byte)2);
            }
        }
    }

    private void missionCheckTutorialState(int n, int n2) {
        switch (this.tutorialLesson) {
            case 0: {
                if (n != 4) break;
                this.tutorialComplete = true;
                break;
            }
            case 1: {
                if (n != 0) break;
                this.tutorialComplete = true;
                break;
            }
            case 2: {
                if (n != 1) break;
                this.tutorialComplete = true;
                break;
            }
            case 3: {
                if (n != 2) break;
                this.tutorialComplete = true;
                break;
            }
            case 4: {
                if (n != 3) break;
                this.tutorialComplete = true;
                break;
            }
            case 5: {
                if (n2 < 4) break;
                this.tutorialComplete = true;
            }
        }
    }

    private void missionCleanUp() {
        this.missionClearItems();
        this.danteActionsClear();
        this.danteComboClear();
        this.danteClearImages();
        this.aiClearAllCharacterImages();
        this.missionClearInGameImages();
        this.doppelgangerState = 0;
        this.doppelgangerEffectCount = 0;
        System.gc();
        this.ioLoadMenuImages();
    }

    private void missionClearItems() {
        int n;
        for (n = 1; n < 5; ++n) {
            if (this.gameItems[n] == null) continue;
            this.gameItems[n] = null;
        }
        for (n = 6; n < 22; ++n) {
            if (this.gameItems[n] == null) continue;
            this.gameItems[n] = null;
        }
        for (n = 23; n < 39; ++n) {
            if (this.gameItems[n] == null) continue;
            this.gameItems[n] = null;
        }
        this.characterCount = 0;
        this.targetSlots[0][0] = false;
        this.targetSlots[0][1] = false;
        this.targetSlots[1][0] = false;
        this.targetSlots[1][1] = false;
        this.targetCount = 0;
    }

    private void missionClearInGameImages() {
        for (int i = 0; i < 7; ++i) {
            DMC2DCanvas.ingameImages[i] = null;
        }
    }

    private boolean missionEnemyCleared() {
        for (int i = this.map.startLock; i < this.map.endLock; ++i) {
            for (int n = 0; n < 6; n = (int)((byte)(n + 1))) {
                if (this.map.spawnSites[i][n] == null || this.map.spawnSites[i][n][1] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private void missionFinish() {
        this.hasContinue = true;
        this.currentMission = (byte)(this.currentMission + 1);
        this.rmsDoSave((byte)15);
    }

    private boolean missionHasCondition(byte by) {
        return (this.mission[7] & by) != 0;
    }

    public void missionLoadEnemiesForRoomSection(int n) {
        if ((n & 1) != 0) {
            this.ioLoadCharacterImages(1);
        }
        if ((n & 2) != 0) {
            this.ioLoadCharacterImages(2);
        }
        if ((n & 4) != 0) {
            this.ioLoadCharacterImages(3);
        }
        if ((n & 0x10) != 0) {
            this.ioLoadCharacterImages(6);
        }
        this.reAssignImages();
    }

    private void reAssignImages() {
        for (int i = 1; i < 5; ++i) {
            if (this.gameItems[i] == null || !this.gameItems[i].alive) continue;
            this.gameItems[i].images = characterImages[this.gameItems[i].type];
        }
    }

    private void missionLoadEverything(int n) {
        this.ioLoadRoom("rooms", this.mission[0]);
        this.map.setItems(this.ioLoadMapItems("i" + this.mission[1]));
        this.map.setMapObjects(this.gameItems);
        this.map.setTileMap();
    }

    private void missionRunLoad(int n) {
        switch (n) {
            case 0: {
                this.spawnTimer = 6;
                missionMapImage = null;
                menuBannerImage = null;
                titleImageText = null;
                this.missionDamage = (byte)100;
                this.freeSelectPlayed = this.freeSelect;
                System.gc();
                break;
            }
            case 1: {
                this.missionLoadEverything(this.currentMission);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.ioLoadIngameImages();
                break;
            }
            case 4: {
                this.danteLoadImages();
                this.danteInit();
                if (!this.missionHasCondition((byte)4)) break;
                this.dante.life = this.mission[9];
                break;
            }
            case 5: {
                int n2 = this.map.getEnemySetForRoomSection();
                this.map.changeMap((byte)0);
                this.doppelgangerState = (n2 & 0x10) != 0 ? (byte)1 : 0;
                this.boss = null;
                if ((n2 & 0x20) == 0) break;
                this.spawnTimer = 0;
                this.missionSpawnNextEnemy();
                break;
            }
            case 6: {
                this.missionTimer = this.missionHasCondition((byte)1) ? this.mission[8] * 10 : 1;
                this.missionObjectiveCount = this.mission[5] == 3 ? this.mission[6] : (this.mission[5] == 1 ? this.mission[6] * 10 : 1);
                this.missionStateCounter = 12;
                this.missionSetState((byte)0);
                this.sound.suspendedSound = (byte)-1;
                this.dante.direction = 0;
            }
        }
    }

    private void missionSetState(byte by) {
        this.missionState = by;
    }

    public void missionSpawnNextEnemy() {
        if (this.doppelgangerState == 1 || this.doppelgangerState == 2) {
            return;
        }
        if (this.characterCount < this.mission[3] && --this.spawnTimer <= 0) {
            int n;
            byte[][] byArray = this.map.getSpawnSites();
            byte[] byArray2 = new byte[6];
            int n2 = 0;
            for (n = 0; n < 6; n = (int)((byte)(n + 1))) {
                if (byArray[n] == null || byArray[n][1] == 0) continue;
                int n3 = n2;
                n2 = (byte)(n2 + 1);
                byArray2[n3] = n;
            }
            if (n2 > 0) {
                n = byArray2[DMC2DCanvas.random(n2)];
                int n4 = byArray[n][2] & 0xFF;
                int n5 = n4 % 16 * 15 + this.map.currentScreen * 240;
                int n6 = (n4 / 16 - 8) * 15;
                int n7 = 0;
                for (int i = 1; i < 5; ++i) {
                    if (this.gameItems[i] != null) continue;
                    n7 = 350;
                    if (byArray[n][0] == 6) {
                        this.gameItems[i] = this.aiCreateEnemy(byArray[n][0], this.dante.x, this.dante.y, this.dante.z - 1, (byte)13);
                        this.gameItems[i].setTargetXYZ(n5, 0, this.dante.z);
                        this.gameItems[i].face = this.dante.face;
                        this.doppelgangerState = (byte)4;
                        this.boss = this.gameItems[i];
                    } else {
                        this.gameItems[i] = this.aiCreateEnemy(byArray[n][0], n5, n7, n6, (byte)13);
                    }
                    this.gameItems[i].difficulty = byArray[n][3];
                    byte[] byArray3 = byArray[n];
                    byArray3[1] = (byte)(byArray3[1] - 1);
                    this.spawnTimer = this.spawnPeriod = DMC2DCanvas.random(16) + 4;
                    return;
                }
            }
        }
    }

    private void objectRun(DMC2DCharacter dMC2DCharacter) {
        if (dMC2DCharacter.type == 18) {
            if (this.aiMoveToTarget(dMC2DCharacter, this.dante.x, this.dante.y + 90, this.dante.z, 20, 44)) {
                this.itemRemove(dMC2DCharacter);
            }
            return;
        }
        if (dMC2DCharacter.momentum != 0) {
            dMC2DCharacter.x += dMC2DCharacter.momentum;
            dMC2DCharacter.momentum = dMC2DCharacter.momentum - (dMC2DCharacter.momentum > 0 ? 8 : -8);
        }
        if ((dMC2DCharacter.anim = (byte)(dMC2DCharacter.anim - 1)) <= 0) {
            dMC2DCharacter.vulnerable = true;
        }
        dMC2DCharacter.jumpUpThrust += -35;
        if ((dMC2DCharacter.y += dMC2DCharacter.jumpUpThrust) < 0) {
            dMC2DCharacter.y = 0;
            dMC2DCharacter.gravityModifier = 0;
        }
        if (dMC2DCharacter.AIState == -1 && dMC2DCharacter.y == 0 && (dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1)) > 3) {
            this.itemRemove(dMC2DCharacter);
            return;
        }
        if (dMC2DCharacter.x < 4) {
            dMC2DCharacter.x = 4;
            dMC2DCharacter.momentum = 0;
        } else if (dMC2DCharacter.x > this.room[1] * 240 - 4) {
            dMC2DCharacter.x = this.room[1] * 240 - 4;
            dMC2DCharacter.momentum = 0;
        }
    }

    private boolean orbIsInRange(DMC2DCharacter dMC2DCharacter, DMC2DCharacter dMC2DCharacter2, int n, int n2) {
        n2 = n2 < 0 ? dMC2DCharacter2.y : dMC2DCharacter2.y + n2;
        return Math.abs(dMC2DCharacter.x - dMC2DCharacter2.x) <= n && Math.abs(dMC2DCharacter.y - n2) <= n && Math.abs(dMC2DCharacter.z - dMC2DCharacter2.z) <= n;
    }

    private void orbRun(DMC2DCharacter dMC2DCharacter) {
        if (dMC2DCharacter.anim != 0) {
            if (this.orbIsInRange(dMC2DCharacter, this.dante, 16, 60)) {
                this.orbTake(dMC2DCharacter);
            } else if (dMC2DCharacter.type == 19 || this.orbIsInRange(dMC2DCharacter, this.dante, dMC2DCharacter.type != 8 ? 36 : 64, 60)) {
                dMC2DCharacter.targetFace = 0;
            }
            if (dMC2DCharacter.targetFace != -1) {
                this.aiMoveToTarget(dMC2DCharacter, this.dante.x, this.dante.y + 60, this.dante.z, 0, dMC2DCharacter.type != 19 ? 24 : 12);
            }
        }
        if (dMC2DCharacter.anim == 0 && (dMC2DCharacter.animFrame = (byte)(dMC2DCharacter.animFrame + 1)) > (dMC2DCharacter.type == 19 ? (byte)8 : 4)) {
            dMC2DCharacter.anim = 1;
        }
    }

    private void orbTake(DMC2DCharacter dMC2DCharacter) {
        if (dMC2DCharacter.type == 8) {
            this.orbCount += dMC2DCharacter.orbValue;
            if (this.orbCount > 9999) {
                this.orbCount = 9999;
            }
            if (this.mission[5] == 1 && (this.missionObjectiveCount -= dMC2DCharacter.orbValue) < 0) {
                this.missionObjectiveCount = 0;
            }
        } else if (dMC2DCharacter.type == 9) {
            this.dante.life = this.dante.life + dMC2DCharacter.orbValue < 100 ? (byte)(this.dante.life + dMC2DCharacter.orbValue) : (byte)100;
        } else {
            this.missionObjectiveCount = 0;
        }
        this.itemRemove(dMC2DCharacter);
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics;
        graphics = this.dblBufferGraphic;
        if (!this.initialised) {
            this.paintUICBlackScreen(graphics);
            return;
        }
        switch (this.gameState) {
            case 1: {
                this.paintUICapcomLogo(graphics);
                break;
            }
            case 2: {
                this.paintUILanguageSelectionScreen(graphics);
                break;
            }
            case 3: {
                this.paintUIInitialLoading(graphics, this.loadingCounter);
                break;
            }
            case 24: 
            case 25: {
                this.paintUIMissionLoading(graphics, this.loadingCounter);
                break;
            }
            case 4: 
            case 20: {
                this.paintUITitleScreen(graphics);
                break;
            }
            case 21: 
            case 27: {
                this.paintUINewGame(graphics);
                break;
            }
            case 6: {
                this.paintUIPlainTextScreen(graphics, this.text[16], this.message);
                break;
            }
            case 14: {
                this.paintUIPlainTextScreen(graphics, this.text[18], this.message);
                break;
            }
            case 23: {
                this.paintUIPlainTextScreen(graphics, this.text[23], this.message);
                break;
            }
            case 8: {
                this.paintUIMissionPrologue(graphics);
                break;
            }
            case 31: {
                this.paintUIPathOrStoryComplete(graphics);
                break;
            }
            case 15: {
                this.paintUIMissionCleared(graphics);
                break;
            }
            case 26: {
                this.paintUIMissionFailed(graphics);
                break;
            }
            case 13: {
                this.paintUIOptions(graphics);
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                this.paintUIInGameMenu(graphics);
                break;
            }
            case 29: {
                this.paintUISaving(graphics);
                break;
            }
            case 55: {
                this.paintUICheatScreen(graphics);
                break;
            }
            case 40: 
            case 41: {
                this.paintGame(graphics);
            }
        }
        graphics2.drawImage(this.dblBuffer, 0, 0, 20);
    }

    private void paintGame(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 128, 0);
        graphics.fillRect(0, 128, 128, -1);
        graphics.setClip(0, 0, 128, 128);
        if (this.doppelgangerState == 2) {
            this.doppelgangerEffectCount = (byte)(this.doppelgangerEffectCount - 1);
            if (this.doppelgangerEffectCount <= 0) {
                this.doppelgangerState = (byte)3;
                this.spawnTimer = 0;
            }
            if (this.doppelgangerEffectCount % 2 == 0) {
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            graphics.fillRect(0, 0, 128, 128);
        } else {
            this.map.paintBackground(graphics, 0, 0);
            DMC2DCharacter[] dMC2DCharacterArray = this.characterGetZSortedList();
            for (int i = 0; i < dMC2DCharacterArray.length; ++i) {
                if (dMC2DCharacterArray[i] == null) continue;
                dMC2DCharacterArray[i].paint(graphics, 0, 64);
            }
            this.paintGameImpactEffects(graphics, 0, 64);
            if (this.missionState == 2 && this.runCounter % 2 != 0) {
                graphics.drawImage(hudImages[2], 116, 60, 20);
            }
            if (this.missionState == 0 && this.missionStateCounter % 4 != 0) {
                Utilities.drawString(graphics, this.text[11], 0, 59, 128, 1, 0, 0);
            } else if (this.missionState == 3) {
                Utilities.drawString(graphics, this.text[12], 0, 59, 128, 1, 0, 0);
            } else if (this.missionState == 4) {
                Utilities.drawString(graphics, this.text[13], 0, 59, 128, 1, 0, 0);
            }
        }
        graphics.setClip(0, 0, 128, 127);
        this.paintGameHUD(graphics);
        if (this.gameState == 41) {
            int n = (124 - this.message.length * 11 + 2 + 4) / 2;
            this.paintUICMessageWindow(graphics, this.message, n, 4, true, true, this.message.length, 0);
        }
    }

    private void paintGameHUD(Graphics graphics) {
        int n;
        int n2 = 58 * this.dante.life / 100;
        int n3 = 5483828;
        int n4 = 9757296;
        int n5 = 13893561;
        int n6 = 10;
        int n7 = Math.abs(this.runCounter % (n6 * 2 + 1) - n6);
        if (this.missionHasCondition((byte)2)) {
            n3 = Utilities.getBlendedColor(9578383, 0xAAAAAA, n7, n6);
            n4 = Utilities.getBlendedColor(11035816, 0xCCCCCC, n7, n6);
            n5 = Utilities.getBlendedColor(12422335, 0xFFFFFF, n7, n6);
        } else if (this.dante.life < 10) {
            n3 = 12267302;
            n4 = 15688547;
            n5 = 16759229;
        }
        graphics.setColor(n3);
        graphics.fillRect(18, 3, n2, 3);
        graphics.setColor(n4);
        graphics.fillRect(18, 4, n2, 1);
        graphics.drawImage(hudImages[0], 0, 0, 20);
        graphics.drawImage(hudImages[1], 86, 0, 20);
        Utilities.drawString(graphics, "" + this.orbCount, 100, -2, 0, 4, 0, 0);
        if (this.boss != null) {
            graphics.drawImage(hudImages[5], 20, 116, 20);
            graphics.drawImage(hudImages[6], 101, 116, 20);
            graphics.setColor(0x7B7D7B);
            graphics.fillRect(27, 116, 74, 6);
            graphics.setColor(0x181C18);
            graphics.fillRect(27, 117, 74, 4);
            n = 74 * this.boss.life / 100;
            if (n < 0) {
                n = 0;
            } else if (n > 74) {
                n = 74;
            }
            graphics.setColor(0xDE0000);
            graphics.fillRect(27, 118, n, 2);
        }
        if (this.missionHasCondition((byte)1)) {
            n = this.missionTimer % 60;
            String string = this.missionTimer / 60 + ":" + (n > 9 ? "" + n : "0" + n);
            graphics.drawImage(hudImages[4], 2, 116, 20);
            Utilities.drawString(graphics, string, 11, 115, 0, 4, 0, 0);
        }
        if (this.mission[5] == 3) {
            graphics.drawImage(hudImages[3], 113, 116, 20);
            String string = this.missionObjectiveCount > 9 ? "" + this.missionObjectiveCount : "0" + this.missionObjectiveCount;
            Utilities.drawString(graphics, "" + string, 111, 115, 0, 8, 0, 0);
        } else if (this.mission[5] == 1) {
            graphics.drawImage(hudImages[1], 116, 117, 20);
            String string = this.missionObjectiveCount > 9 ? "" + this.missionObjectiveCount : "0" + this.missionObjectiveCount;
            Utilities.drawString(graphics, "" + string, 114, 115, 0, 8, 0, 0);
        }
    }

    private void paintGameImpactEffects(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.impactEffect.length; ++i) {
            n3 = this.impactEffect[i][0] * 8 / 15;
            n4 = this.impactEffect[i][1] * 8 / 15;
            int[] nArray = this.impactEffect[i];
            nArray[2] = nArray[2] - 1;
            if (nArray[2] <= 0) continue;
            graphics.drawImage(ingameImages[2], n + n3 - characterPositionOffsets[16][0][0], n2 + n4 - characterPositionOffsets[16][0][1], 20);
        }
    }

    private void paintGameStyleMeter(Graphics graphics, int n, int n2) {
    }

    private void paintUICBlackScreen(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 128, 127);
    }

    private void paintUICMenu(Graphics graphics, int n, String[] stringArray, int n2, boolean bl) {
        int n3 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            if (n3 == n2) {
                this.paintUICMenuSelection(graphics, n + n3 * 12);
            }
            if (bl && stringArray[i].startsWith("[alt]")) {
                graphics.setColor(0x101010);
                graphics.fillRect(0, n + n3 * 12, 128, 9);
                if (n3 + 1 == n2) {
                    graphics.setColor(0x808080);
                } else {
                    graphics.setColor(0x404040);
                }
                graphics.drawRect(0, n + n3 * 12, 127, 9);
            }
            Utilities.drawString(graphics, stringArray[i].startsWith("[alt]") ? stringArray[i].substring(5) : stringArray[i], 0, n + n3 * 12 + 1, 128, 1, 1, n3 == n2 || bl && n3 + 1 == n2 ? 0 : 3);
            ++n3;
        }
    }

    private void paintUICMenuSelection(Graphics graphics, int n) {
        int n2 = (int)(System.currentTimeMillis() / 50L % 32L);
        if (n2 > 16) {
            n2 = 32 - n2;
        }
        for (int i = 0; i < 8; ++i) {
            int n3 = n2 * 7 + 75 - (16 - i) * 5;
            if (n3 < 16) {
                n3 = 16;
            }
            int n4 = n3 << 16 | 16 - n2 << 8 | 16 - n2;
            graphics.setColor(n4);
            graphics.fillRect(i * 8, n - 2, 8, 13);
            graphics.fillRect((15 - i) * 8, n - 2, 8, 13);
        }
    }

    private void paintUICMessageWindow(Graphics graphics, String string, int n, int n2, boolean bl, boolean bl2, int n3, int n4) {
        String[] stringArray = new String[]{string};
        this.paintUICMessageWindow(graphics, stringArray, n, n2, bl, bl2, n3, n4);
    }

    private void paintUICMessageWindow(Graphics graphics, String[] stringArray, int n, int n2, boolean bl, boolean bl2, int n3, int n4) {
        int n5 = 0;
        boolean bl3 = false;
        String[] stringArray2 = bl ? Utilities.splitString(stringArray, 120 - (n3 > 0 ? 6 : 0), 1) : stringArray;
        Utilities.drawGradientRect(graphics, 1, n, 126, (n3 > 0 ? n3 : stringArray2.length) * 11 + 2 + 4, n4);
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].startsWith("[alt]")) continue;
            Utilities.fillGradientRect(graphics, 4, n + 3, 119, 11);
        }
        if (n3 > 0) {
            if (this.textBoxStartLine < 0) {
                this.textBoxStartLine = 0;
            } else if (this.textBoxStartLine + n3 > stringArray2.length) {
                this.textBoxStartLine = Math.max(stringArray2.length - n3, 0);
            }
            if (stringArray2.length - this.textBoxStartLine > n3) {
                bl3 = true;
            }
            n5 = this.textBoxStartLine;
        }
        this.paintUICTextBox(graphics, 4, n + 4, 120, n3 > 0 ? n3 : stringArray2.length, stringArray2, bl2, n2, n5);
        if (bl3) {
            Utilities.drawArrow(graphics, 119, n + n3 * 11 + 2 + 4 - 3 - 3, 1, 3, 0x868686);
        }
        if (n5 != 0) {
            Utilities.drawArrow(graphics, 119, n + 5, 0, 3, 0x868686);
        }
    }

    private void paintUICScrollingMenu(Graphics graphics, int n, String[] stringArray, int n2, int n3, boolean bl) {
        int n4 = n2 / 2;
        this.paintUICMenuSelection(graphics, n + 12 * n4 + 3 + 1);
        if (this.menuDirection != 8) {
            Utilities.drawArrow(graphics, 62, n, 0, 3, 0x969696);
        }
        if (this.menuDirection != 16) {
            Utilities.drawArrow(graphics, 62, n + 3 + 1 + n2 * 12, 1, 3, 0x969696);
        }
        graphics.setClip(0, n + 3 + 1, 128, n2 * 12 - 1);
        int n5 = n3 - n4 - 1;
        for (int i = -1; i < n2 + 1; ++i) {
            int n6 = n5 >= this.menuOptionsCount ? n5 - this.menuOptionsCount : (n5 = n5 < 0 ? this.menuOptionsCount + n5 : n5);
            if (stringArray[n5].startsWith("[alt]")) {
                graphics.setColor(0x101010);
                graphics.fillRect(0, this.selectionScrollCounter + n + i * 12 + 3 + 1, 128, 9);
                if (bl && i + 1 == n4 && this.selectionScrollCounter == 0 && this.menuDirection == 0) {
                    graphics.setColor(0x808080);
                } else {
                    graphics.setColor(0x404040);
                }
                graphics.drawRect(0, this.selectionScrollCounter + n + i * 12 + 3 + 1, 127, 9);
            }
            String string = stringArray[n5].startsWith("[alt]") ? stringArray[n5].substring(5) : stringArray[n5];
            int n7 = !bl && i == n4 && this.selectionScrollCounter == 0 && (this.gameState != 4 || this.hasContinue || i != 2) || i == n4 && this.selectionScrollCounter == 0 && this.menuDirection == 0 || bl && i + 1 == n4 && this.selectionScrollCounter == 0 && this.menuDirection == 0 ? 0 : 3;
            Utilities.drawString(graphics, string, 0, this.selectionScrollCounter + n + i * 12 + 1 + 3 + 1, 128, 1, 1, n7);
            ++n5;
        }
        graphics.setClip(0, 0, 128, 127);
    }

    private void paintUICSoftkeys(Graphics graphics) {
        graphics.setColor(0);
        if (this.softkey[0] != 0) {
            graphics.fillRect(0, 118, Utilities.stringWidth(this.text[0 + this.softkey[0]]) + 2, 9);
        }
        if (this.softkey[1] != 0) {
            graphics.fillRect(0, 118, Utilities.stringWidth(this.text[0 + this.softkey[1]]) + 2, 9);
        }
        Utilities.drawString(graphics, this.text[0 + this.softkey[0]], 1, 118, 0, 4, 1, 0);
        Utilities.drawString(graphics, this.text[0 + this.softkey[1]], 127, 118, 0, 8, 1, 0);
    }

    private void paintUICSoftkeysAsArrows(Graphics graphics) {
        Utilities.drawArrow(graphics, 1, 127, 1, 0, 0xFFFFFF);
        Utilities.drawArrow(graphics, 120, 127, 1, 0, 0xFFFFFF);
    }

    private void paintUICTextBox(Graphics graphics, int n, int n2, int n3, int n4, String[] stringArray, boolean bl, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        this.horizontalScrollTime += 2;
        if (stringArray != null) {
            if (bl) {
                for (n8 = n6; n8 < stringArray.length && n7 < n4; ++n8) {
                    int n9;
                    if (stringArray[n8] == null) continue;
                    if (stringArray[n8].startsWith("[scr]") && (n9 = Utilities.stringWidth(stringArray[n8].substring(5))) >= n3) {
                        graphics.setClip(n, n2 + n7 * 11, n3, 9);
                        if (this.horizontalScrollTime > 0) {
                            bl2 = true;
                            int n10 = n9 + 16;
                            for (int i = 0; i < 2; ++i) {
                                Utilities.drawString(graphics, stringArray[n8].substring(5), n - this.horizontalScrollTime % n10 + i * n10, n2 + n7 * 11, n3, n5, 1, 0);
                            }
                        }
                    }
                    if (!bl2) {
                        Utilities.drawString(graphics, stringArray[n8].startsWith("[alt]") || stringArray[n8].startsWith("[scr]") ? stringArray[n8].substring(5) : stringArray[n8], n, n2 + n7 * 11, n3, n5, 1, 0);
                    }
                    ++n7;
                }
            } else {
                for (n8 = 0; n8 < stringArray.length && n7 < n4; ++n8) {
                    int n11;
                    if (n8 >= stringArray.length || stringArray[n8] == null) continue;
                    if (stringArray[n8].startsWith("[scr]") && (n11 = Utilities.stringWidth(stringArray[n8].substring(5))) >= n3) {
                        graphics.setClip(n, n2 + n7 * 11, n3, 9);
                        if (this.horizontalScrollTime > 0) {
                            bl2 = true;
                            int n12 = n11 + 16;
                            for (int i = 0; i < 2; ++i) {
                                Utilities.drawString(graphics, stringArray[n8].startsWith("[scr]") ? stringArray[n8].substring(5) : stringArray[n8], n - this.horizontalScrollTime % n12 + i * n12, n2 + n7 * 11, n3, n5, 1, 0);
                            }
                        }
                    }
                    if (!bl2) {
                        Utilities.drawString(graphics, stringArray[n8].startsWith("[scr]") || stringArray[n8].startsWith("[alt]") ? stringArray[n8].substring(5) : stringArray[n8], n, n2 + n7 * 11, n3, n5, 1, 0);
                    }
                    ++n7;
                }
            }
        }
        graphics.setClip(0, 0, 128, 127);
    }

    private void paintUICPopUp(Graphics graphics, int n) {
        int n2 = (124 - this.message.length * 11 + 2 + 4) / 2;
        this.paintUICMessageWindow(graphics, this.message, n2, n, false, true, this.message.length, -1);
    }

    private void paintUICTitleBar(Graphics graphics, String string) {
        int n;
        int n2;
        int n3;
        this.headerScrollTime += 2;
        int n4 = 10;
        for (n3 = 0; n3 < 25; ++n3) {
            n2 = 250 - n3 * n4;
            n = n2 << 16 | n2 << 8 | n2;
            graphics.setColor(n);
            graphics.fillRect(n3, 3, 1, 12);
            graphics.fillRect(128 - n3 - 1, 3, 1, 12);
        }
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 1, 128, 1);
        graphics.fillRect(0, 16, 128, 1);
        n3 = Utilities.stringWidth(Utilities.textPrepareTitleString(string), 0);
        int n5 = n2 = n3 > 128 ? 1 : (128 - n3) / 2;
        if (n3 >= 128 && this.headerScrollTime > 0) {
            n = n3 + 16;
            for (int i = 0; i < 2; ++i) {
                Utilities.drawString(graphics, string, n2 - this.headerScrollTime % n + i * n, 3, 128, 4, 0, 0);
            }
        } else {
            Utilities.drawString(graphics, string, n2, 3, 128, 4, 0, 0);
        }
    }

    private void paintUICapcomLogo(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        graphics.drawImage(logoImage, 14, 54, 20);
    }

    private void paintUICheatScreen(Graphics graphics) {
    }

    private void paintUIInGameMenu(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        this.paintUICTitleBar(graphics, this.text[20]);
        String[] stringArray = new String[]{this.text[28], this.text[26], this.text[17], this.text[29]};
        this.paintUICMenu(graphics, 46, stringArray, this.menuSelection, false);
        if (this.gameState == 43 || this.gameState == 44) {
            this.paintUICPopUp(graphics, 1);
        }
    }

    private void paintUIInitialLoading(Graphics graphics, int n) {
        this.paintUICBlackScreen(graphics);
        graphics.drawImage(titleImageText, 1, 11, 20);
        this.paintUILoadingBar(graphics, n, 3, 16, 72, 96, 6);
        Utilities.drawStringWrapped(graphics, this.bootText[this.languageSelected][0], 0, 81, 124, 1, 1, 0, 11);
        Utilities.drawString(graphics, this.bootText[this.languageSelected][4], 0, 115, 124, 1, 1, 0);
    }

    private void paintUILanguageSelectionScreen(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        this.paintUICTitleBar(graphics, this.bootText[this.languageSelected][3]);
        for (int i = 0; i < 5; ++i) {
            if (i == this.languageSelected) {
                int n = i;
                this.xOffsets[n] = (byte)(this.xOffsets[n] + 15);
                if (this.xOffsets[i] > 15) {
                    this.xOffsets[i] = 15;
                }
            } else {
                int n = i;
                this.xOffsets[n] = (byte)(this.xOffsets[n] - 8);
                if (this.xOffsets[i] < 0) {
                    this.xOffsets[i] = 0;
                }
            }
            int n = 0;
            int n2 = 8;
            n = 15 * (i + 2) - 8 + 10;
            graphics.drawImage(barImage, 0 + n2 + this.xOffsets[i], n + 9, 20);
            Utilities.drawString(graphics, this.languages[i], 0 + n2 + 25 + this.xOffsets[i], n, 0, 4, 1, i == this.languageSelected ? 0 : 3);
        }
    }

    private void paintUILoadingBar(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Utilities.drawGradientRect(graphics, n3, n4, n5, n6, 0x606060);
        int n7 = (n5 - 4) * n / n2;
        int n8 = 2;
        int n9 = n7 / n8;
        int n10 = (n5 - 4) / n8;
        for (int i = n9; i > 0; --i) {
            int n11 = 255 - n10 << 16 | 0;
            --n10;
            graphics.setColor(n11);
            graphics.fillRect(n3 + i * n8, n4 + 1, n8, n6 - 2);
        }
    }

    private void paintUIMenuBanner(Graphics graphics) {
        if (menuBannerImage == null) {
            this.loadRandomMenuBanner();
        }
        graphics.drawImage(menuBannerImage, 5, 18, 20);
    }

    private void paintUIMissionCleared(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        this.paintUICTitleBar(graphics, this.text[14]);
        this.paintUIMenuBanner(graphics);
        String[] stringArray = new String[]{this.text[1], this.text[10]};
        this.paintUICMenu(graphics, 77, stringArray, this.menuSelection, false);
    }

    private void paintUIMissionFailed(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        this.paintUICTitleBar(graphics, this.text[13]);
        this.paintUIMenuBanner(graphics);
        String[] stringArray = new String[]{this.text[26], this.text[29]};
        this.paintUICMenu(graphics, 77, stringArray, this.menuSelection, false);
    }

    private void paintUIMissionLoading(Graphics graphics, int n) {
        this.paintUICBlackScreen(graphics);
        this.paintUIMenuBanner(graphics);
        if (this.gameState == 24) {
            this.paintUILoadingBar(graphics, n, 6, 16, 84, 96, 6);
            Utilities.drawStringWrapped(graphics, this.bootText[this.languageSelected][0], 0, 93, 124, 1, 1, 0, 11);
        } else {
            String[] stringArray = new String[]{this.text[11]};
            this.paintUICMenu(graphics, 84, stringArray, 0, false);
        }
    }

    private void paintUIMissionPrologue(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        String[] stringArray = new String[]{"[alt]" + this.text[36] + " " + (this.currentMission + 1)};
        this.paintUICMessageWindow(graphics, stringArray, 1, 4, false, false, 0, 0);
        this.paintUIMenuBanner(graphics);
        this.paintUICMessageWindow(graphics, this.message, 67, this.gameState == 31 ? 1 : 4, false, true, 4, 0);
    }

    private void paintUINewGame(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        this.paintUICTitleBar(graphics, this.text[21]);
        this.paintUIMenuBanner(graphics);
        if (this.gameState == 27) {
            this.paintUICMessageWindow(graphics, this.text[31], 21, 4, true, true, 8, 0);
        } else {
            String[] stringArray = new String[]{this.text[25]};
            this.paintUICMenu(graphics, 83, stringArray, this.menuSelection, false);
        }
    }

    private void paintUIOptions(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        this.paintUICTitleBar(graphics, this.text[17]);
        String[] stringArray = new String[]{"[alt]" + this.text[24], "[" + (this.sound.enabled ? this.text[34] : this.text[35]) + "]"};
        this.paintUICMenu(graphics, 58, stringArray, this.menuSelection, true);
    }

    private void paintUIPathOrStoryComplete(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        this.paintUICTitleBar(graphics, this.text[19]);
        this.paintUIMenuBanner(graphics);
        this.paintUICMessageWindow(graphics, this.message, 67, this.gameState == 31 ? 1 : 4, false, true, 4, 0);
    }

    private void paintUIPlainTextScreen(Graphics graphics, String string, String[] stringArray) {
        this.paintUICBlackScreen(graphics);
        this.paintUICTitleBar(graphics, string);
        this.paintUICMessageWindow(graphics, stringArray, 19, this.gameState == 6 ? 1 : 4, false, true, 8, 0);
    }

    private void paintUISaving(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        Utilities.drawStringWrapped(graphics, this.text[37], 0, 59, 124, 1, 1, 0, 11);
        this.saveScreenPainted = true;
    }

    private void paintUITitleScreen(Graphics graphics) {
        this.paintUICBlackScreen(graphics);
        String[] stringArray = new String[]{this.text[21], this.text[22], this.text[17], this.text[16], this.text[18], this.text[23]};
        graphics.drawImage(titleImageText, 1, 11, 20);
        this.paintUICScrollingMenu(graphics, 53, stringArray, 3, this.menuHighlight, false);
        Utilities.drawStringWrapped(graphics, this.bootText[this.languageSelected][4], 0, 115, 124, 1, 1, 0, 11);
        if (this.gameState == 20) {
            this.paintUICPopUp(graphics, 1);
        }
    }

    public static int random(int n) {
        return Math.abs(random.nextInt() % n);
    }

    private void rmsDoSave(byte by) {
        this.rmsSave();
        this.optionsEdited = false;
        this.appChangeState(by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rmsLoad() {
        block16: {
            RecordStore recordStore = null;
            FilterInputStream filterInputStream = null;
            try {
                recordStore = RecordStore.openRecordStore((String)"dmc2d", (boolean)true);
                if (recordStore.getNumRecords() != 0) {
                    byte[] byArray = recordStore.getRecord(1);
                    filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                    this.orbCount = ((DataInputStream)filterInputStream).readInt();
                    this.currentMission = ((DataInputStream)filterInputStream).readByte();
                    this.sound.enabled = ((DataInputStream)filterInputStream).readBoolean();
                    this.hasContinue = ((DataInputStream)filterInputStream).readBoolean();
                    break block16;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (filterInputStream != null) {
                        filterInputStream.close();
                    }
                    if (recordStore != null) {
                        recordStore.closeRecordStore();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte rmsReadLanguage() {
        RecordStore recordStore = null;
        byte by = 0;
        try {
            recordStore = RecordStore.openRecordStore((String)"lg", (boolean)true);
            if (recordStore.getNumRecords() != 0) {
                byte[] byArray = recordStore.getRecord(1);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                by = dataInputStream.readByte();
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            byte by2 = 0;
            return by2;
        }
        finally {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (Exception exception) {}
        }
        return by;
    }

    private void rmsResetData(boolean bl) {
        this.appInitialiseFirstPlay();
        if (!bl) {
            this.swordLevel = 0;
            this.gunLevel = 0;
            this.orbCount = 0;
        }
        this.rmsDoSave((byte)8);
        this.rmsSave();
    }

    private void rmsRunSave() {
        if (this.saveScreenPainted) {
            this.rmsSave();
            this.optionsEdited = false;
            this.appChangeState(this.postSavedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rmsSave() {
        RecordStore recordStore = null;
        FilterOutputStream filterOutputStream = null;
        try {
            RecordStore.deleteRecordStore((String)"dmc2d");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)"dmc2d", (boolean)true);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                ((DataOutputStream)filterOutputStream).writeInt(this.orbCount);
                ((DataOutputStream)filterOutputStream).writeByte(this.currentMission);
                ((DataOutputStream)filterOutputStream).writeBoolean(this.sound.enabled);
                ((DataOutputStream)filterOutputStream).writeBoolean(this.hasContinue);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            finally {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rmsSaveLanguage(byte by) {
        RecordStore recordStore = null;
        try {
            RecordStore.deleteRecordStore((String)"lg");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            try {
                recordStore = RecordStore.openRecordStore((String)"lg", (boolean)true);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeByte(by);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            finally {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        block16: while (true) {
            try {
                block17: while (true) {
                    long l = System.currentTimeMillis();
                    ++this.runCounter;
                    this.appDoNextState();
                    this.uiHandleKeypress();
                    switch (this.gameState) {
                        case 0: {
                            this.ioLoadBootImages();
                            this.nextState = 1;
                            Thread.sleep(10L);
                            continue block17;
                        }
                        case 1: {
                            this.uiRunCapcomLogo();
                            break;
                        }
                        case 3: {
                            if (++this.loadingCounter >= 3) {
                                this.nextState = (byte)4;
                            }
                            this.appInitialLoad(this.loadingCounter);
                            break;
                        }
                        case 24: {
                            if (++this.loadingCounter >= 6) {
                                this.nextState = (byte)25;
                            }
                            this.missionRunLoad(this.loadingCounter);
                            break;
                        }
                        case 29: {
                            this.rmsRunSave();
                            break;
                        }
                        case 22: {
                            this.appChangeState((byte)4);
                            this.getMoreGames();
                            break;
                        }
                        case 4: 
                        case 55: {
                            this.uiRunScrollingMenu(12);
                            break;
                        }
                        case 40: {
                            this.gamePlayRun();
                        }
                    }
                    this.repaint();
                    this.serviceRepaints();
                    if (this.sound != null && this.sound.enabled) {
                        this.sound.playCuedBGM();
                    }
                    if (this.virbrationEnabled && this.vibrate) {
                        this.vibrate = false;
                    }
                    if (this.interrupted && (this.soundResumeCounter = (byte)(this.soundResumeCounter + 1)) > 12) {
                        this.interrupted = false;
                        if (this.sound != null) {
                            this.sound.resume();
                        }
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long l2 = System.currentTimeMillis();
                    long l3 = 125L - (l2 - l);
                    try {
                        if (l3 > 3L) {
                            Thread.sleep(l3);
                            continue block16;
                        }
                        Thread.sleep(3L);
                        continue block16;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                DMC2DCanvas.printException("run: " + exception);
                exception.printStackTrace();
                return;
            }
        }
    }

    private void sofykeysSet(int n, int n2) {
        this.softkey[0] = n;
        this.softkey[1] = n2;
        this.removeCommand(this.leftSoftKey);
        this.removeCommand(this.rightSoftKey);
        if (this.softkey[0] == 0) {
            this.leftSoftKey = new Command(" ", 1, 1);
            this.addCommand(this.leftSoftKey);
        } else {
            this.leftSoftKey = this.gameState == 2 ? new Command(this.bootText[this.languageSelected][2], 1, 1) : new Command(this.text[0 + this.softkey[0]], 1, 1);
            this.addCommand(this.leftSoftKey);
        }
        if (this.softkey[1] == 0) {
            this.rightSoftKey = new Command(" ", 1, 2);
            this.addCommand(this.rightSoftKey);
        } else {
            this.rightSoftKey = this.gameState == 2 ? new Command(this.bootText[this.languageSelected][1], 1, 1) : new Command(this.text[0 + this.softkey[1]], 1, 2);
            this.addCommand(this.rightSoftKey);
        }
    }

    public void actionPerformed(Command command, Displayable displayable) {
        if (command == this.leftSoftKey) {
            this.menuKey = -6;
        }
        if (command == this.rightSoftKey) {
            this.menuKey = -7;
        }
    }

    private void textInitAbout() {
        String[] stringArray = new String[]{"Devil May Cry", this.text[48] + " 1.0.0", " ", this.text[49], " ", this.text[50]};
        this.textPrepareMessage(stringArray, 114);
        stringArray = new String[this.message.length + 1];
        System.arraycopy(this.message, 0, stringArray, 0, this.message.length);
        stringArray[this.message.length] = "[scr]" + this.text[51];
        this.message = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String textLoad(String[] stringArray, String string, int n, int n2, int n3) {
        FilterInputStream filterInputStream = null;
        int n4 = 0;
        String string2 = null;
        try {
            int n5;
            filterInputStream = new DataInputStream(this.getClass().getResourceAsStream("/" + string));
            for (n5 = 0; n5 < n; ++n5) {
                ((DataInputStream)filterInputStream).readUTF();
            }
            for (n5 = 0; n5 < n2 * this.languageSelected; ++n5) {
                ((DataInputStream)filterInputStream).readUTF();
            }
            if (n3 >= 0) {
                for (n4 = 0; n4 < n3; ++n4) {
                    ((DataInputStream)filterInputStream).readUTF();
                }
                string2 = ((DataInputStream)filterInputStream).readUTF();
            } else {
                for (n4 = 0; n4 < n2; ++n4) {
                    stringArray[n4] = ((DataInputStream)filterInputStream).readUTF();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void textLoadBoot() {
        FilterInputStream filterInputStream = null;
        this.languages = new String[5];
        this.bootText = new String[5][5];
        try {
            int n;
            filterInputStream = new DataInputStream(this.getClass().getResourceAsStream("/boot.txt"));
            for (n = 0; n < 5; ++n) {
                this.languages[n] = ((DataInputStream)filterInputStream).readUTF();
            }
            for (n = 0; n < 5; ++n) {
                for (int i = 0; i < 5; ++i) {
                    this.bootText[n][i] = ((DataInputStream)filterInputStream).readUTF();
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void textPrepareMessage(String string, int n) {
        this.message = Utilities.splitString(string, n, 1);
    }

    private void textPrepareMessage(String[] stringArray, int n) {
        this.message = Utilities.splitString(stringArray, n, 1);
    }

    private void textPrepareObjective(boolean bl) {
        String string = (bl ? "[alt]" + this.text[55] + "$" + this.text[36] + " " + (this.currentMission + 1) + "$" : "") + this.text[54] + "$" + this.text[58 + this.mission[5]];
        int n = this.mission[5] == 1 ? this.mission[6] * 10 : this.mission[6];
        int n2 = string.indexOf("#");
        if (n2 > 0) {
            string = string.substring(0, n2) + n + string.substring(n2 + 1, string.length());
        }
        if (this.mission[5] != 4 && this.missionHasCondition((byte)1)) {
            string = string + "$" + this.text[63];
        }
        if (this.missionHasCondition((byte)2)) {
            string = string + "$" + this.text[64];
        }
        if (this.missionHasCondition((byte)4)) {
            string = string + "$" + this.text[65];
        }
        this.textPrepareMessage(string, 114);
    }

    private void uiHandleKeypress() {
        if (this.gameState == 40) {
            if (this.menuKey == -7) {
                this.appChangeState((byte)42);
            } else if (this.menuKey == -6) {
                this.appChangeState((byte)41);
            }
            this.menuKey = 0;
            return;
        }
        int n = 0;
        if (this.menuKey == 50 || this.menuKey == -1) {
            n = 1;
        } else if (this.menuKey == 56 || this.menuKey == -2) {
            n = 2;
        }
        if (this.menuKey == 54 || this.menuKey == -4) {
            n = 4;
        } else if (this.menuKey == 52 || this.menuKey == -3) {
            n = 3;
        } else if ((this.menuKey == 53 || this.menuKey == -5) && this.softkey[0] >= 1 || this.menuKey == -6 && this.softkey[0] >= 1) {
            n = 5;
        } else if (this.menuKey == -7) {
            n = 6;
        }
        switch (this.gameState) {
            case 41: {
                if (this.menuKey != -6) break;
                this.appChangeState((byte)40);
                if (this.dante == null) break;
                this.dante.direction = 0;
                break;
            }
            case 2: {
                if (n == 1) {
                    this.languageSelected = (byte)(this.languageSelected - 1 >= 0 ? this.languageSelected - 1 : 4);
                    break;
                }
                if (n == 2) {
                    this.languageSelected = (byte)(this.languageSelected + 1 < 5 ? this.languageSelected + 1 : 0);
                    break;
                }
                if (n == 5) {
                    this.rmsSaveLanguage(this.languageSelected);
                    this.sofykeysSet(0, 0);
                    this.appChangeState((byte)3);
                    break;
                }
                if (n != 6) break;
                this.appExit();
                break;
            }
            case 4: {
                if (n == 1) {
                    if (this.menuDirection == 16) break;
                    this.menuDirection = 8;
                    int n2 = this.menuSelection - 1;
                    if (!this.hasContinue && n2 == 1) {
                        --n2;
                    }
                    this.menuSelection = n2 >= 0 ? n2 : this.menuOptionsCount - 1;
                    break;
                }
                if (n == 2) {
                    if (this.menuDirection == 8) break;
                    this.menuDirection = 16;
                    int n3 = this.menuSelection + 1;
                    if (!this.hasContinue && n3 == 1) {
                        ++n3;
                    }
                    this.menuSelection = n3 < this.menuOptionsCount ? n3 : 0;
                    break;
                }
                if (n == 5) {
                    this.selectionScrollCounter = 0;
                    this.menuHighlight = this.menuSelection;
                    this.menuDirection = 0;
                    this.tutorialLesson = (byte)-1;
                    if (this.menuSelection == 0 && this.hasContinue) {
                        this.appChangeState((byte)21);
                        break;
                    }
                    this.appChangeState(this.menuOptions[this.menuSelection]);
                    break;
                }
                if (n != 6) break;
                this.appChangeState((byte)20);
                break;
            }
            case 6: 
            case 14: {
                if (n == 1) {
                    this.textBoxStartLine -= 7;
                } else if (n == 2) {
                    this.textBoxStartLine += 7;
                }
                if (n != 6) break;
                this.appChangeState((byte)4);
                break;
            }
            case 23: {
                if (n != 6) break;
                this.appChangeState((byte)4);
                break;
            }
            case 8: {
                if (n == 1) {
                    this.textBoxStartLine -= 3;
                } else if (n == 2) {
                    this.textBoxStartLine += 3;
                }
                if (n == 5) {
                    this.appChangeState((byte)24);
                    break;
                }
                if (n != 6) break;
                this.appChangeState((byte)4);
                break;
            }
            case 15: {
                if (n == 1) {
                    this.menuSelection = this.menuSelection - 1 >= 0 ? this.menuSelection - 1 : this.menuOptionsCount - 1;
                } else if (n == 2) {
                    int n4 = this.menuSelection = this.menuSelection + 1 < this.menuOptionsCount ? this.menuSelection + 1 : 0;
                }
                if (n != 5) break;
                if (this.menuSelection == 1) {
                    this.currentMission = (byte)(this.currentMission - 1);
                }
                if (this.currentMission >= 12) {
                    this.currentMission = (byte)11;
                    this.appChangeState((byte)31);
                    break;
                }
                this.appChangeState((byte)8);
                break;
            }
            case 26: {
                if (n == 1) {
                    this.menuSelection = this.menuSelection - 1 >= 0 ? this.menuSelection - 1 : this.menuOptionsCount - 1;
                    break;
                }
                if (n == 2) {
                    this.menuSelection = this.menuSelection + 1 < this.menuOptionsCount ? this.menuSelection + 1 : 0;
                    break;
                }
                if (n != 5) break;
                if (this.menuSelection == 0) {
                    this.appChangeState((byte)8);
                    break;
                }
                this.appChangeState((byte)4);
                break;
            }
            case 31: {
                if (n == 1) {
                    this.textBoxStartLine -= 3;
                } else if (n == 2) {
                    this.textBoxStartLine += 3;
                }
                if (n != 5) break;
                this.menuSelection = 0;
                this.appChangeState((byte)4);
                break;
            }
            case 13: {
                if (n == 5 || n == 3 || n == 4) {
                    if (this.menuSelection != 1) break;
                    this.sound.enabled = !this.sound.enabled;
                    this.sound.stopSound();
                    this.sound.setBGM((byte)1);
                    this.optionsEdited = true;
                    break;
                }
                if (n != 6) break;
                if (this.optionsState == 42) {
                    if (this.optionsEdited) {
                        this.rmsDoSave((byte)42);
                    } else {
                        this.appChangeState((byte)42);
                    }
                    this.menuSelection = 2;
                    break;
                }
                if (this.optionsEdited) {
                    this.rmsDoSave(this.optionsState);
                } else {
                    this.appChangeState(this.optionsState);
                }
                this.menuSelection = 2;
                this.menuHighlight = 2;
                break;
            }
            case 42: {
                if (n == 1) {
                    this.menuSelection = this.menuSelection - 1 >= 0 ? this.menuSelection - 1 : this.menuOptionsCount - 1;
                } else if (n == 2) {
                    int n5 = this.menuSelection = this.menuSelection + 1 < this.menuOptionsCount ? this.menuSelection + 1 : 0;
                }
                if (n == 5) {
                    if (this.menuSelection == 0) {
                        this.appChangeState((byte)40);
                        break;
                    }
                    if (this.menuSelection == 1) {
                        this.appChangeState((byte)43);
                        break;
                    }
                    if (this.menuSelection == 2) {
                        this.appChangeState((byte)13);
                        break;
                    }
                    this.appChangeState((byte)44);
                    break;
                }
                if (n != 6) break;
                this.appChangeState((byte)40);
                break;
            }
            case 43: {
                if (this.menuKey == -6) {
                    this.missionCleanUp();
                    this.appChangeState((byte)8);
                    break;
                }
                if (n != 6 && this.menuKey != -5) break;
                this.appChangeState((byte)42);
                break;
            }
            case 44: {
                if (this.menuKey == -6) {
                    this.missionCleanUp();
                    this.uiSetTitleMenuSelection();
                    this.appChangeState((byte)4);
                    break;
                }
                if (n != 6 && this.menuKey != -5) break;
                this.appChangeState((byte)42);
                break;
            }
            case 25: {
                if (n == 5) {
                    this.appChangeState((byte)40);
                }
            }
            case 24: {
                if (n == 1) {
                    this.textBoxStartLine -= 4;
                    break;
                }
                if (n != 2) break;
                this.textBoxStartLine += 4;
                break;
            }
            case 20: {
                if (this.menuKey == -6) {
                    this.appExit();
                    break;
                }
                if (n != 6 && this.menuKey != -5) break;
                this.appChangeState((byte)4);
                break;
            }
            case 21: {
                if (n == 1 || n == 2) {
                    if (this.menuSelection == 0) {
                        this.menuSelection = 1;
                        break;
                    }
                    this.menuSelection = 0;
                    break;
                }
                if (n == 5) {
                    this.appChangeState((byte)27);
                    break;
                }
                if (n != 6) break;
                this.menuSelection = 0;
                this.appChangeState((byte)4);
                break;
            }
            case 27: {
                if (n == 1) {
                    this.textBoxStartLine -= 7;
                    break;
                }
                if (n == 2) {
                    this.textBoxStartLine += 7;
                    break;
                }
                if (this.menuKey == -6) {
                    this.rmsResetData(false);
                    break;
                }
                if (n != 6 && this.menuKey != -5) break;
                this.menuSelection = 0;
                this.appChangeState((byte)21);
                break;
            }
        }
        this.menuKey = 0;
    }

    private void uiRunCapcomLogo() {
        this.mAlpha += this.mValue;
        if (this.mAlpha >= 255) {
            this.mAlpha = 255;
            this.appInit();
            this.mValue *= -2;
        } else if (this.mAlpha < 0) {
            this.mAlpha = 0;
            this.appChangeState((byte)2);
        }
    }

    private void uiRunScrollingMenu(int n) {
        if (this.menuDirection == 8) {
            if ((this.selectionScrollCounter += n) >= 12) {
                this.menuHighlight = this.menuHighlight - 1 >= 0 ? this.menuHighlight - 1 : this.menuOptionsCount - 1;
                this.selectionScrollCounter = 0;
                if (this.menuHighlight == this.menuSelection) {
                    this.menuDirection = 0;
                }
            }
        } else if (this.menuDirection == 16 && (this.selectionScrollCounter -= n) <= -12) {
            this.menuHighlight = this.menuHighlight + 1 < this.menuOptionsCount ? this.menuHighlight + 1 : 0;
            this.selectionScrollCounter = 0;
            if (this.menuHighlight == this.menuSelection) {
                this.menuDirection = 0;
            }
        }
    }

    private void uiSetTitleMenuSelection() {
        this.menuSelection = this.hasContinue ? 1 : 0;
    }

    protected void hideNotify() {
        if (this.gameState == 40) {
            this.appChangeState((byte)41);
        }
        if (this.sound != null) {
            this.sound.suspend();
        }
        this.soundResumeCounter = 0;
        this.interrupted = false;
    }

    protected void showNotify() {
        this.soundResumeCounter = 0;
        this.interrupted = true;
        if (this.dante != null) {
            this.dante.direction = 0;
        }
    }

    private String getGetMoreGamesText() {
        return "Go to the video games section of the portal";
    }

    private String getGetMoreGamesURL() {
        return "http://bango.capcom-mobile.com";
    }

    private void getMoreGames() {
        boolean bl = false;
        this.appChangeState((byte)23);
    }

    public static void drawRegion(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = graphics.getClipX();
        int n10 = graphics.getClipY();
        int n11 = graphics.getClipWidth();
        int n12 = graphics.getClipHeight();
        if (n5 == 2) {
            n = image.getWidth() - n - n3;
        }
        graphics.clipRect(n6, n7, n3, n4);
        graphics.drawImage(image, n6 - n, n7 - n2, n8);
        graphics.setClip(n9, n10, n11, n12);
    }

    public static void printException(String string) {
    }

    public static void alert(String string) {
    }

    public static void p(String string) {
    }

    static {
        ranges = new short[][][]{new short[][]{{88, 0, 20, 80}, {88, -80, 20, 80}, {94, -80, 20, 80}, {100, 0, 20, 80}, {80, 0, 20, 80}, {90, 0, 20, 80}, {240, 0, 20, 80}}, new short[][]{{100, 40, 20, 80}, {140, 40, 20, 80}, {40, 0, 20, 80}, new short[0], {10, 0, 32}}, new short[][]{{100, 40, 20, 80}, {140, 40, 20, 80}, {40, 0, 20, 80}, new short[0], {10, 0, 32}}, new short[][]{{80, 60, 20, 80}, {120, 90, 20, 80}, {60, 0, 20, 40}, new short[0], {10, 0, 32}}, new short[0][], new short[0][], new short[][]{{80, 60, 20, 80}, {120, 90, 20, 80}, {100, 20, 20, 80}, {200, 100, 20, 80}, {10, 0, 42}}};
        impactEffectHeight = new byte[][]{{52, 16}, {50, 16}, {50, 16}, {30, 22}, new byte[0], new byte[0], {52, 16}};
        danteAttackFrame = new byte[]{0, 0, 0, 1, 1, 1, 1, 1, -1, -1};
        stateAnim = new byte[][]{{0, 1, 2, 0, 3, 4, 3, 5, 6, 5, 7, 8, 1, 9, 1}, new byte[0], {0, 1, 2, 0, 3, 4, 3, 5, 6, 5, 7, 8, 1, 1, 1, 2, 10, 11, 12}};
        enemyAiStats = new byte[][][]{new byte[0][], new byte[][]{{8, 24, 40, 5, 100, 12, 14, 12, 40, 30, 18, 18, 18, 45, 35, 15, 15, 20, 30, 30}, {8, 24, 90, 5, 100, 6, 6, 6, 40, 30, 10, 10, 10, 45, 35, 15, 15, 40, 40, 30}, {10, 24, 100, 5, 75, 3, 2, 5, 30, 30, 9, 5, 9, 35, 35, 15, 15, 60, 50, 30}}, new byte[][]{{12, 24, 60, 5, 100, 12, 14, 12, 40, 30, 18, 18, 18, 45, 35, 15, 15, 20, 30, 30}, {12, 24, 100, 5, 100, 3, 3, 3, 40, 30, 8, 8, 8, 45, 35, 15, 15, 30, 35, 30}, {14, 24, 100, 5, 80, 0, 0, 0, 10, 10, 2, 1, 2, 20, 20, 0, 25, 80, 40, 30}}, new byte[][]{{8, 45, 40, 5, 100, 8, 8, 12, 30, 30, 16, 12, 18, 60, 60, 30, 20, 20, 20, 30}, {8, 45, 100, 5, 90, 6, 4, 6, 30, 30, 12, 8, 12, 60, 60, 30, 20, 30, 30, 30}, {10, 45, 100, 5, 70, 2, 2, 3, 30, 30, 6, 6, 8, 60, 60, 30, 30, 35, 20, 30}}, new byte[0][], new byte[0][], new byte[][]{{14, 30, 100, 3, 30, 1, 0, 0, 30, 30, 4, 3, 6, 60, 60, 30, 15, 30, 30, 30, 30, 30, 30, 60, 60, 60, 55, 90, 30}, {14, 30, 100, 3, 25, 1, 0, 0, 30, 30, 4, 3, 6, 60, 60, 30, 15, 30, 30, 30, 30, 30, 30, 60, 60, 60, 55, 90, 30}, {14, 30, 100, 4, 20, 0, 0, 0, 30, 30, 2, 1, 3, 60, 60, 30, 15, 30, 30, 30, 30, 30, 30, 60, 60, 60, 55, 90, 30}}};
        orbValues = new byte[][]{{0, 0}, {10, 20}, {15, 20}, {10, 25}, new byte[0], new byte[0], {35, 100}, {5, 10}, new byte[0], new byte[0], new byte[0], {10, 10}, new byte[0], new byte[0], {0, 0}};
        characterFilenames = new String[]{"d", "p", "l", "a", "s", "v", "d"};
        characterImages = new Image[7][];
        CHEAT_CODE = new int[]{42, 51, 52, 55, 35};
    }
}

