/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import de.tuttas.GameAPI.MenuItem2;
import de.tuttas.GameAPI.MenuListener2;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public abstract class Menu2 {
    public String name;
    private int selectedItemIndex;
    private MenuItem2 selectedItem;
    public MenuItem2 tmpItem;
    private MenuListener2 listener;
    private boolean visible;
    private int width;
    private int height;
    private Vector items;

    public Menu2(String n) {
        this.name = n;
        this.visible = false;
        this.items = new Vector();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void addMenuItem(MenuItem2 m) {
        if (this.items.size() == 0) {
            this.selectedItem = m;
            this.selectedItemIndex = 0;
            m.setSelected(true);
        }
        this.items.addElement(m);
        if (m.getWidth() > this.width) {
            this.width = m.getWidth();
        }
        if (m.getHeight() > this.height) {
            this.height = m.getHeight();
        }
        System.out.println("Menu width=" + this.width + " height=" + this.height);
    }

    public void insertMenuItem(int i, MenuItem2 m) {
        this.items.insertElementAt(m, i);
        if (m.getWidth() > this.width) {
            this.width = m.getWidth();
        }
        if (m.getHeight() > this.height) {
            this.height = m.getHeight();
        }
    }

    public boolean previous() {
        try {
            this.tmpItem = (MenuItem2)this.items.elementAt(this.selectedItemIndex - 1);
            this.selectedItem.setSelected(false);
            --this.selectedItemIndex;
            this.selectedItem = (MenuItem2)this.items.elementAt(this.selectedItemIndex);
            this.selectedItem.setSelected(true);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException abo) {
            return false;
        }
    }

    public boolean next() {
        try {
            this.tmpItem = (MenuItem2)this.items.elementAt(this.selectedItemIndex + 1);
            this.selectedItem.setSelected(false);
            ++this.selectedItemIndex;
            this.selectedItem = (MenuItem2)this.items.elementAt(this.selectedItemIndex);
            this.selectedItem.setSelected(true);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException abo) {
            return false;
        }
    }

    public boolean hasNext() {
        try {
            this.tmpItem = (MenuItem2)this.items.elementAt(this.selectedItemIndex + 1);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException abo) {
            return false;
        }
    }

    public boolean hasPrevious() {
        try {
            this.tmpItem = (MenuItem2)this.items.elementAt(this.selectedItemIndex - 1);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException abo) {
            return false;
        }
    }

    public int getItemHeight(int i) {
        return this.selectedItem.getHeight();
    }

    public void setListener(MenuListener2 ml) {
        this.listener = ml;
    }

    public void select() {
        this.listener.select(this.selectedItem);
    }

    public MenuItem2 getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(int i) {
        this.selectedItem.setSelected(false);
        this.selectedItem = (MenuItem2)this.items.elementAt(i);
        this.selectedItem.setSelected(true);
        this.selectedItemIndex = i;
    }

    public int getSelectedIndex() {
        return this.selectedItemIndex;
    }

    public void removeMenuItem(MenuItem2 m) {
        this.items.removeElement(m);
    }

    public abstract void paint(Graphics var1);

    public int getNumberOfItems() {
        return this.items.size();
    }

    public MenuItem2 getFirst() {
        return (MenuItem2)this.items.firstElement();
    }

    public MenuItem2 getLast() {
        return (MenuItem2)this.items.lastElement();
    }

    public MenuItem2 getItem(int i) {
        try {
            return (MenuItem2)this.items.elementAt(i);
        }
        catch (ArrayIndexOutOfBoundsException aob) {
            return null;
        }
    }
}

