/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import de.tuttas.GameAPI.BuyerListener;
import de.tuttas.GameAPI.Menu;
import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Buyer
implements MenuListener,
CommandListener {
    public static final int BUY_OK = 1;
    public static final int BUY_FAILED = 2;
    public static final int BUY_CANCELED = 3;
    public static final int BUY_END = 4;
    BuyerListener listener;
    public static final int REQUEST = 1;
    public static final int SELECT = 2;
    public static final int RESULT = 4;
    public static final int FAILED = 5;
    public static final int OK = 6;
    public int state;
    int selection;
    Command okCommand;
    Command nokCommand;
    public String[] requestString = new String[]{"Buy the full", "version for", "only 3 EUR?"};
    public String[] failedString = new String[]{"Send SMS with"};
    public String[] okString = new String[]{"Thanks for", "ordering"};
    Menu m;
    String[] locations = new String[]{"UK", "Germany", "Denmark", "Sweden", "Spain", "Netherland", "Finland", "France", "Norway", "Austria", "Belgium", "other"};
    String[] sms = new String[]{"80160", "81850", "1231", "72299", "7603", "4443", "179600", "82282", "2030", "0900800800", "3669", "-1"};
    MenuItem[] items = new MenuItem[this.locations.length];
    String keyWord;
    String gameName;
    public static int fgColor = 0xFFFFFF;
    Image yesImage;
    Image noImage;
    int leftSoftKey;
    int rightSoftKey;
    int yPos;
    Canvas canvas;

    public void sendSMS(String Snum, String Smsg) {
    }

    public Buyer(String gn, String code, int leftKey, int rightKey, int y, Canvas c) {
        this.keyWord = code;
        this.gameName = gn;
        this.leftSoftKey = leftKey;
        this.rightSoftKey = rightKey;
        this.canvas = c;
        this.yPos = y;
        try {
            this.yesImage = Image.createImage((String)"/de/tuttas/GameAPI/yes.png");
            this.noImage = Image.createImage((String)"/de/tuttas/GameAPI/no.png");
        }
        catch (IOException iox) {
            this.okCommand = new Command("Yes", 2, 1);
            this.nokCommand = new Command("No", 4, 1);
        }
        this.m = new Menu(y);
        int i = 0;
        while (i < this.locations.length) {
            this.items[i] = new MenuItem(this.locations[i], fgColor, 0x888888, 0);
            this.m.add(this.items[i]);
            ++i;
        }
        this.m.setListener(this);
        this.state = 1;
    }

    public void setFgColor(int c) {
        fgColor = c;
        int i = 0;
        while (i < this.locations.length) {
            this.items[i].colorActive = c;
            ++i;
        }
    }

    public void setListener(BuyerListener l) {
        this.listener = l;
    }

    public void start() {
        if (this.okCommand != null) {
            this.canvas.addCommand(this.okCommand);
            this.canvas.addCommand(this.nokCommand);
            this.canvas.setCommandListener((CommandListener)this);
        }
        this.state = 1;
    }

    public void paint(Graphics g) {
        int y = this.yPos;
        if (this.state == 1) {
            if (this.yesImage != null && this.noImage != null) {
                g.drawImage(this.yesImage, 0, g.getClipHeight(), 36);
                g.drawImage(this.noImage, g.getClipWidth(), g.getClipHeight(), 40);
            }
            g.setColor(fgColor);
            int i = 0;
            while (i < this.requestString.length) {
                g.drawString(this.requestString[i], g.getClipWidth() / 2, y, 17);
                y += g.getFont().getHeight();
                ++i;
            }
        } else if (this.state == 2) {
            g.setColor(fgColor);
            g.drawString("Select Country", g.getClipWidth() / 2, y, 17);
            this.m.MenuStart = y += g.getFont().getHeight();
            this.m.paint(g);
        } else if (this.state == 4 || this.state == 5) {
            this.paintFailed(g);
        } else if (this.state == 6) {
            g.setColor(fgColor);
            int i = 0;
            while (i < this.okString.length) {
                g.drawString(this.okString[i], g.getClipWidth() / 2, y, 17);
                y += g.getFont().getHeight();
                ++i;
            }
            g.drawString(this.gameName, g.getClipWidth() / 2, y, 17);
        }
    }

    private void paintFailed(Graphics g) {
        g.setColor(fgColor);
        int y = this.yPos;
        if (this.sms[this.selection].compareTo("-1") == 0) {
            g.drawString("Visit", g.getClipWidth() / 2, y, 17);
            g.drawString("www.tinysolutions.de", g.getClipWidth() / 2, y += g.getFont().getHeight(), 17);
            g.drawString("to register", g.getClipWidth() / 2, y += g.getFont().getHeight(), 17);
            y += g.getFont().getHeight();
        } else {
            int i = 0;
            while (i < this.failedString.length) {
                g.drawString(this.failedString[i], g.getClipWidth() / 2, y, 17);
                y += g.getFont().getHeight();
                ++i;
            }
            g.drawString("Keyword", g.getClipWidth() / 2, y, 17);
            g.drawString(this.keyWord, g.getClipWidth() / 2, y += g.getFont().getHeight(), 17);
            g.drawString("TO", g.getClipWidth() / 2, y += g.getFont().getHeight(), 17);
            g.drawString(this.sms[this.selection], g.getClipWidth() / 2, y += g.getFont().getHeight(), 17);
        }
    }

    public static boolean isWMAPresent() {
        try {
            Class.forName("javax.wireless.messaging.MessageConnection");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void keyPressed(int keyCode, int action) {
        if (this.state == 1 && this.okCommand == null) {
            if (keyCode == this.leftSoftKey) {
                this.state = 2;
            } else if (keyCode == this.rightSoftKey) {
                this.listener.buyFinished(3);
            } else if (action == 8) {
                this.state = 2;
            }
        } else if (this.state == 2) {
            if (action == 2 || action == 1) {
                this.m.left();
            } else if (action == 5 || action == 6) {
                this.m.right();
            } else if (action == 8 || keyCode == this.leftSoftKey || keyCode == this.rightSoftKey) {
                this.m.select();
            }
        } else if (this.state == 5 || this.state == 4) {
            this.listener.buyFinished(4);
        } else if (this.state == 6) {
            this.listener.buyFinished(4);
        }
        this.canvas.repaint();
    }

    public void select(MenuItem mi) {
        this.selection = this.m.index;
        this.state = 4;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.okCommand) {
            this.state = 2;
        } else if (c == this.nokCommand) {
            this.listener.buyFinished(3);
        }
        d.removeCommand(this.okCommand);
        d.removeCommand(this.nokCommand);
        this.canvas.repaint();
    }
}

