/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;

public class BTGame
implements Runnable,
DiscoveryListener {
    public static final int CONNECT_AS_CLIENT = 1;
    public static final int CONNECT_AS_SERVER = 2;
    public static final int SEARCH_DEVICES = 3;
    public static final int SEARCH_SERVICES = 4;
    public static final int STOPPED = 5;
    int state = 0;
    public int actualServiceID;
    public static final String UUID = "42249B70A08911DAA7460800200C9A66";
    private static final String SERVICE_URL = "btl2cap://localhost:42249B70A08911DAA7460800200C9A66";
    String url = "btl2cap://localhost:42249B70A08911DAA7460800200C9A66";
    LocalDevice device = null;
    RemoteDevice remoteDevice = null;
    RemoteDevice foundDevice = null;
    DiscoveryAgent agent = null;
    BTGameListener listener = null;
    Thread thread;
    public Vector devices;
    int deviceNumber;
    L2CAPConnectionNotifier connectionNotifier = null;
    String name;

    public BTGame(String n) {
        this.name = n;
        this.foundDevice = null;
    }

    public int getState() {
        return this.state;
    }

    public void setListener(BTGameListener l) {
        this.device = null;
        this.agent = null;
        if (this.devices != null) {
            this.devices.removeAllElements();
        } else {
            this.devices = new Vector();
        }
        this.state = 3;
        this.listener = l;
        this.url = SERVICE_URL;
        this.url = this.url + ";authenticate=false";
        this.url = this.url + ";authorize=false";
        this.url = this.url + ";encrypt=false";
        this.url = this.url + ";name=" + this.name;
        this.listener.info("Start Client Thread");
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ix) {
            // empty catch block
        }
        if (this.agent == null) {
            this.initialize();
        }
        if (this.foundDevice == null) {
            try {
                this.agent.startInquiry(10390323, (DiscoveryListener)this);
            }
            catch (BluetoothStateException e) {
                if (this.listener != null) {
                    this.listener.error("BluetoothStateException:" + e.getMessage());
                }
            }
        } else {
            this.searchAtRemoteDevice();
        }
    }

    public String getClientURL() {
        return this.url;
    }

    public void stop() {
        this.listener = null;
        try {
            if (this.connectionNotifier != null) {
                this.connectionNotifier.close();
            }
            if (this.listener != null) {
                this.listener.info("Close");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.state == 3) {
            this.agent.cancelInquiry((DiscoveryListener)this);
        } else if (this.state == 4) {
            this.agent.cancelServiceSearch(this.actualServiceID);
        }
        this.state = 5;
    }

    public void run() {
        block11: {
            try {
                this.connectionNotifier = (L2CAPConnectionNotifier)Connector.open((String)this.url);
                Thread.sleep(100L);
                if (this.listener != null) {
                    this.listener.info("Client Listening");
                }
                L2CAPConnection connection = this.connectionNotifier.acceptAndOpen();
                if (this.listener != null) {
                    this.listener.info("Connected");
                }
                if (this.state != 2) {
                    if (this.listener != null) {
                        this.listener.info("Connect as Client");
                    }
                    if (this.listener != null) {
                        this.listener.connected(connection, 1);
                    }
                    this.state = 1;
                }
            }
            catch (InterruptedException ic) {
            }
            catch (IOException e) {
                e.printStackTrace();
                if (this.connectionNotifier != null) {
                    // empty if block
                }
                if (this.listener != null) {
                    this.listener.error("Client IOException:" + e.getMessage());
                }
            }
            catch (SecurityException e) {
                if (this.listener == null) break block11;
                this.listener.error("SecurityException:" + e.getMessage());
            }
        }
        this.thread = null;
    }

    public void initialize() {
        block2: {
            this.device = null;
            this.agent = null;
            try {
                this.device = LocalDevice.getLocalDevice();
                this.device.setDiscoverable(10390323);
                this.agent = this.device.getDiscoveryAgent();
            }
            catch (BluetoothStateException e) {
                e.printStackTrace();
                if (this.listener == null) break block2;
                this.listener.error("SecurityException:" + e.getMessage());
            }
        }
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        try {
            if (this.listener != null) {
                this.listener.info("found #" + (this.devices.size() + 1) + "<" + remoteDevice.getFriendlyName(false) + ">");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.devices.addElement(remoteDevice);
    }

    public void inquiryCompleted(int complete) {
        if (this.devices.size() != 0) {
            this.state = 4;
            if (this.listener != null) {
                this.listener.info("Inquiry completed #" + this.devices.size());
            }
            this.deviceNumber = 0;
            this.search4Service();
        } else {
            if (this.listener != null) {
                this.listener.info("No BT-Device found");
            }
            if (this.listener != null) {
                this.listener.noDeviceFound();
            }
        }
    }

    private void search4Service() {
        UUID[] searchList = new UUID[]{new UUID(UUID, false)};
        this.remoteDevice = (RemoteDevice)this.devices.elementAt(this.deviceNumber);
        try {
            if (this.listener != null) {
                this.listener.info("search @" + this.remoteDevice.getFriendlyName(false));
            }
            this.actualServiceID = this.agent.searchServices(null, searchList, this.remoteDevice, (DiscoveryListener)this);
        }
        catch (BluetoothStateException bx) {
            if (this.listener != null) {
                this.listener.info("BluetoothStateException:" + bx.getMessage());
            }
            bx.printStackTrace();
        }
        catch (IOException iox) {
            if (this.listener != null) {
                this.listener.info("IOException:" + iox.getMessage());
            }
            iox.printStackTrace();
        }
    }

    private void searchAtRemoteDevice() {
        UUID[] searchList = new UUID[]{new UUID(UUID, false)};
        try {
            if (this.listener != null) {
                this.listener.info("search " + this.foundDevice.getFriendlyName(false));
            }
            this.actualServiceID = this.agent.searchServices(null, searchList, this.foundDevice, (DiscoveryListener)this);
        }
        catch (BluetoothStateException bx) {
            if (this.listener != null) {
                this.listener.info("BluetoothStateException:" + bx.getMessage());
            }
            bx.printStackTrace();
        }
        catch (IOException iox) {
            if (this.listener != null) {
                this.listener.info("IOException:" + iox.getMessage());
            }
            iox.printStackTrace();
        }
    }

    public void servicesDiscovered(int transId, ServiceRecord[] records) {
        block5: {
            if (this.listener != null) {
                this.listener.info("serviceDiscovered");
            }
            if (this.state == 5) break block5;
            try {
                L2CAPConnection connection = (L2CAPConnection)Connector.open((String)records[0].getConnectionURL(0, false));
                this.thread = null;
                this.foundDevice = this.remoteDevice;
                if (this.state == 1) break block5;
                this.state = 2;
                if (this.listener != null) {
                    this.listener.info("Connecte as Server");
                }
                if (this.listener != null) {
                    this.listener.connected(connection, 2);
                }
            }
            catch (IOException iox) {
                if (this.listener == null) break block5;
                this.listener.error("IOException:" + iox.getMessage());
            }
        }
    }

    public void serviceSearchCompleted(int transId, int complete) {
        if (this.listener != null) {
            this.listener.info("Search " + (this.deviceNumber + 1) + "/" + transId + " completed");
        }
        ++this.deviceNumber;
        if (this.deviceNumber >= this.devices.size() && this.state != 2 && this.state != 1) {
            if (this.listener != null) {
                this.listener.info("No Service found");
            }
            if (this.listener != null) {
                this.listener.noServiceFound();
            }
        } else if (this.state != 1 && this.state != 2) {
            this.agent.cancelServiceSearch(transId);
            this.search4Service();
        }
    }
}

