/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class DebugUtil
extends Canvas {
    protected static Vector debugMsg;
    protected static DebugUtil instance;

    static DebugUtil getInstance() {
        if (instance == null) {
            instance = new DebugUtil();
        }
        return instance;
    }

    public DebugUtil() {
        debugMsg = new Vector();
        debugMsg.removeAllElements();
    }

    public static boolean addMsg(String info) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"DebugInfo", (boolean)true);
            byte[] data = info.getBytes();
            rs.addRecord(data, 0, data.length);
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            return false;
        }
        return true;
    }

    public static boolean isEmpty() {
        DebugUtil.readMsgs();
        return debugMsg.size() == 0;
    }

    protected static void readMsgs() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"DebugInfo", (boolean)false);
            for (int i = 1; i < rs.getNumRecords() + 1; ++i) {
                int size = rs.getRecordSize(i);
                byte[] data = new byte[size];
                rs.getRecord(i, data, 0);
                debugMsg.addElement(new String(data));
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public static boolean successFinish() {
        try {
            RecordStore.deleteRecordStore((String)"DebugInfo");
            debugMsg.removeAllElements();
        }
        catch (RecordStoreException ex) {
            return false;
        }
        return true;
    }

    protected void paint(Graphics g) {
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        for (int i = 0; i < debugMsg.size(); ++i) {
            g.drawString((String)debugMsg.elementAt(i), 0, i * 15, 0);
        }
    }

    static {
        instance = null;
    }
}

