/*
 * Decompiled with CFR 0.152.
 */
public class cStrMgr {
    static final int _StrMgr_MAX_STR_PACKS = 5;
    private static final String _StrMgr_UTF8 = "UTF-8";
    static byte[][] _StrMgr_Packs = new byte[5][];
    static short[][] _StrMgr_Offsets = new short[5][];

    static boolean LoadStrPack(int pack, byte[] data, byte[] offsets) {
        if (pack < 0 || pack >= 5 || data == null) {
            throw new IllegalArgumentException();
        }
        if (_StrMgr_Packs[pack] != null) {
            return false;
        }
        cStrMgr._StrMgr_Packs[pack] = data;
        if (offsets != null) {
            int nStrings = offsets[0] & 0xFF | (offsets[1] & 0xFF) << 8;
            cStrMgr._StrMgr_Offsets[pack] = new short[nStrings];
            int i = 0;
            while (i < nStrings) {
                cStrMgr._StrMgr_Offsets[pack][i] = (short)((offsets[i * 2 + 2] & 0xFF) + ((offsets[i * 2 + 3] & 0xFF) << 8));
                ++i;
            }
        } else {
            cStrMgr.UpdatePackOffsets(pack);
        }
        return true;
    }

    static boolean UnloadStrPack(int pack) {
        if (pack < 0 || pack >= 5) {
            throw new IllegalArgumentException();
        }
        if (_StrMgr_Offsets[pack] != null) {
            cStrMgr._StrMgr_Offsets[pack] = null;
        }
        if (_StrMgr_Packs[pack] == null) {
            return false;
        }
        cStrMgr._StrMgr_Packs[pack] = null;
        return true;
    }

    static void UpdatePackOffsets(int pack) {
        int nStrings = 0;
        int i = 0;
        while (i < _StrMgr_Packs[pack].length) {
            if (_StrMgr_Packs[pack][i] == 0) {
                ++nStrings;
            }
            ++i;
        }
        cStrMgr._StrMgr_Offsets[pack] = new short[nStrings];
        int i2 = 0;
        int j = 0;
        while (i2 < _StrMgr_Packs[pack].length) {
            if (_StrMgr_Packs[pack][i2] == 0) {
                cStrMgr._StrMgr_Offsets[pack][j++] = (short)(i2 + 1);
            }
            ++i2;
        }
    }

    static String GetString(int pack, int string) {
        if (pack < 0 || pack >= 5 || _StrMgr_Packs[pack] == null) {
            return "";
        }
        if (string < 0 || string >= _StrMgr_Offsets[pack].length) {
            return "";
        }
        int off = string == 0 ? 0 : _StrMgr_Offsets[pack][string - 1] & 0xFFFF;
        int len = (_StrMgr_Offsets[pack][string] & 0xFFFF) - off - 1;
        if (len == 0) {
            return "";
        }
        if (_StrMgr_UTF8 == null) {
            return cStrMgr.StringFromByteArrayUTF8(_StrMgr_Packs[pack], off, len);
        }
        return new String(_StrMgr_Packs[pack], off, len);
    }

    static String StringFromByteArrayUTF8(byte[] src, int offset, int len) {
        char[] buf = new char[len];
        int d = 0;
        int s = offset;
        while (s < offset + len) {
            if ((src[s] & 0x80) == 0) {
                buf[d++] = (char)src[s++];
                continue;
            }
            if ((src[s] & 0xC0) == 192 && s + 1 < offset + len && (src[s + 1] & 0xC0) == 128) {
                buf[d++] = (char)((src[s] & 0x1F) << 6 | src[s + 1] & 0x3F);
                s += 2;
                continue;
            }
            if ((src[s] & 0xE0) == 224 && s + 2 < offset + len && (src[s + 1] & 0xC0) == 128 && (src[s + 2] & 0xC0) == 128) {
                buf[d++] = (char)((src[s] & 0xF) << 12 | (src[s + 1] & 0x3F) << 6 | src[s + 2] & 0x3F);
                s += 3;
                continue;
            }
            return "";
        }
        return new String(buf, 0, d);
    }

    static String StringFromByteArray(byte[] src, int offset, int len) {
        StringBuffer sb = new StringBuffer();
        int i_max = offset + len;
        int i = offset;
        while (i < i_max) {
            sb.append((char)(src[i] & 0xFF));
            ++i;
        }
        return sb.toString();
    }

    static String StringFromByteArray(byte[] src) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < src.length && src[i] != 0) {
            sb.append((char)(src[i] & 0xFF));
            ++i;
        }
        return sb.toString();
    }
}

