/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Player {
    private static Image m_SharedImage;
    private static int[] m_NormalFrameSequence;
    private static int[] m_ExploFrameSequence;
    private int m_HighPrecisionXpos;
    private int m_HighPrecisionYpos;
    private byte m_Direction;
    private byte m_NextDirection;
    private byte m_LastMapXpos;
    private byte m_LastMapYpos;
    private byte m_Energy;
    private byte m_Lives;
    private int m_Score;
    private int m_Speed;
    private boolean m_UseFastSpeed;
    private int m_StoppedDirection;
    private boolean m_Explosion;
    private boolean m_IsDead;
    private boolean m_IsShielded;
    private int[] m_CurrentSequence;
    private int m_SequencePosition;
    private int m_FrameSize;
    private boolean m_Visible;

    public Player(int direction, int x, int y) {
        try {
            LineOut lineout = (LineOut)Application.getCurrent();
            LineOutCanvas canvas = (LineOutCanvas)Display.getDisplay((MIDlet)lineout).getCurrent();
            this.m_FrameSize = canvas.getGraphicsContext().getClipWidth() / 16;
            this.m_HighPrecisionXpos = x;
            this.m_HighPrecisionYpos = y;
            this.m_Direction = (byte)direction;
            this.m_NextDirection = (byte)direction;
            this.m_LastMapXpos = (byte)((x >> 16) / this.m_FrameSize);
            this.m_LastMapYpos = (byte)((y >> 16) / this.m_FrameSize);
            this.m_Energy = (byte)100;
            this.m_Lives = (byte)3;
            this.m_Score = 0;
            this.m_Speed = (this.m_FrameSize << 20) / 128;
            this.m_UseFastSpeed = false;
            this.m_StoppedDirection = 0;
            this.m_Explosion = false;
            this.m_IsDead = false;
            this.m_IsShielded = false;
            this.m_CurrentSequence = m_NormalFrameSequence;
            this.m_SequencePosition = 0;
            this.m_Visible = true;
            if (m_SharedImage == null) {
                m_SharedImage = Image.createImage((String)"/player.png");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void update() {
        LineOut lineout = (LineOut)Application.getCurrent();
        Game game = (Game)Display.getDisplay((MIDlet)lineout).getCurrent();
        GameField gameField = game.getGameField();
        int xpos = this.m_HighPrecisionXpos >> 16;
        int ypos = this.m_HighPrecisionYpos >> 16;
        int mapElementSize = game.getGraphicsContext().getClipWidth() / gameField.getFieldWidth();
        int midXpos = xpos + mapElementSize / 2;
        int midYpos = ypos + mapElementSize / 2;
        int mapXpos = midXpos / mapElementSize;
        int mapYpos = midYpos / mapElementSize;
        int ways = gameField.getBlock(mapXpos, mapYpos);
        int wayElementSize = (game.getGraphicsContext().getClipWidth() << 16) / (gameField.getFieldWidth() * 6);
        int wayXpos = (midXpos << 16) / wayElementSize % 6;
        int wayYpos = (midYpos << 16) / wayElementSize % 6;
        if (!this.m_Explosion) {
            if (ways < 16) {
                if (wayXpos <= 1) {
                    gameField.deleteBlock(mapXpos, mapYpos, 8);
                }
                if (wayXpos >= 4) {
                    gameField.deleteBlock(mapXpos, mapYpos, 4);
                }
                if (wayYpos <= 1) {
                    gameField.deleteBlock(mapXpos, mapYpos, 2);
                }
                if (wayYpos >= 4) {
                    gameField.deleteBlock(mapXpos, mapYpos, 1);
                }
            }
            if (xpos % mapElementSize == 0 && ypos % mapElementSize == 0) {
                this.m_Speed = !this.m_UseFastSpeed ? (mapElementSize << 20) / 128 : (mapElementSize << 21) / 128;
                if (mapXpos != this.m_LastMapXpos || mapYpos != this.m_LastMapYpos) {
                    gameField.updateBlock(this.m_LastMapXpos, this.m_LastMapYpos, mapXpos, mapYpos, 0);
                    this.m_LastMapXpos = (byte)mapXpos;
                    this.m_LastMapYpos = (byte)mapYpos;
                }
                if (ways < 16) {
                    if ((ways & this.m_NextDirection) != 0) {
                        this.m_Direction = this.m_NextDirection;
                        this.m_NextDirection = 0;
                    }
                    if ((ways & this.m_Direction) == 0) {
                        this.m_Direction = (byte)8;
                    }
                    if ((ways & this.m_Direction) == 0) {
                        this.m_Direction = (byte)4;
                    }
                    if ((ways & this.m_Direction) == 0) {
                        this.m_Direction = (byte)2;
                    }
                    if ((ways & this.m_Direction) == 0) {
                        this.m_Direction = 1;
                    }
                }
                if (ways == 17) {
                    if (this.m_StoppedDirection == 0) {
                        switch (this.m_Direction) {
                            case 8: {
                                this.m_StoppedDirection = 4;
                                break;
                            }
                            case 4: {
                                this.m_StoppedDirection = 8;
                                break;
                            }
                            case 2: {
                                this.m_StoppedDirection = 1;
                                break;
                            }
                            case 1: {
                                this.m_StoppedDirection = 2;
                            }
                        }
                        this.m_Direction = 0;
                    } else if (this.m_NextDirection != 0 && this.m_NextDirection != this.m_StoppedDirection) {
                        this.m_StoppedDirection = 0;
                        this.m_Direction = this.m_NextDirection;
                    }
                }
                if (ways == 0) {
                    this.setEnergy(0, true);
                }
            }
            if (ways == 16) {
                this.setEnergy(0, true);
            }
            if (midXpos < 0 || midXpos > mapElementSize * gameField.getFieldWidth()) {
                this.setEnergy(0, true);
            }
            if (midYpos < 0 || midYpos > mapElementSize * gameField.getFieldHeight()) {
                this.setEnergy(0, true);
            }
            switch (this.m_Direction) {
                case 8: {
                    this.m_HighPrecisionXpos -= this.m_Speed;
                    break;
                }
                case 4: {
                    this.m_HighPrecisionXpos += this.m_Speed;
                    break;
                }
                case 2: {
                    this.m_HighPrecisionYpos -= this.m_Speed;
                    break;
                }
                case 1: {
                    this.m_HighPrecisionYpos += this.m_Speed;
                }
            }
            ++this.m_SequencePosition;
            if (this.m_SequencePosition >= this.m_CurrentSequence.length) {
                this.m_SequencePosition = 0;
            }
        } else if (this.m_SequencePosition == this.m_CurrentSequence.length - 1) {
            this.m_IsDead = true;
            this.m_Visible = false;
        } else {
            ++this.m_SequencePosition;
            if (this.m_SequencePosition >= this.m_CurrentSequence.length) {
                this.m_SequencePosition = 0;
            }
        }
    }

    public void paint(Graphics graphics, int x, int y) {
        if (this.m_Visible) {
            int xpos = (this.m_HighPrecisionXpos >> 16) + x;
            int ypos = (this.m_HighPrecisionYpos >> 16) + y;
            int frame = this.m_CurrentSequence[this.m_SequencePosition];
            int imageX = frame * this.m_FrameSize % m_SharedImage.getWidth();
            int imageY = frame * this.m_FrameSize / m_SharedImage.getWidth() * this.m_FrameSize;
            int oldClipX = graphics.getClipX();
            int oldClipY = graphics.getClipY();
            int oldClipWidth = graphics.getClipWidth();
            int oldClipHeight = graphics.getClipHeight();
            graphics.clipRect(xpos, ypos, this.m_FrameSize, this.m_FrameSize);
            graphics.drawImage(m_SharedImage, xpos - imageX, ypos - imageY, 20);
            graphics.setClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
        }
    }

    public void setNextDirection(int direction) {
        if (this.m_Direction != 0) {
            if (this.m_Direction == 8 && direction == 4) {
                return;
            }
            if (this.m_Direction == 4 && direction == 8) {
                return;
            }
            if (this.m_Direction == 2 && direction == 1) {
                return;
            }
            if (this.m_Direction == 1 && direction == 2) {
                return;
            }
        }
        this.m_NextDirection = (byte)direction;
    }

    public void setEnergy(int energy, boolean force) {
        if (this.m_IsShielded && !force && this.m_Energy > energy) {
            return;
        }
        if (energy < 0) {
            energy = 0;
        }
        if (energy > 100) {
            energy = 100;
        }
        if (energy == 0 && !this.m_Explosion) {
            this.m_Explosion = true;
            this.m_CurrentSequence = m_ExploFrameSequence;
            this.m_SequencePosition = 0;
        }
        this.m_Energy = (byte)energy;
    }

    public void setLives(int lives) {
        if (lives < 0) {
            lives = 0;
        }
        if (lives > 9) {
            lives = 9;
        }
        this.m_Lives = (byte)lives;
    }

    public void setScore(int score) {
        if (score < 0) {
            score = 0;
        }
        if (score > 999999) {
            score = 999999;
        }
        this.m_Score = score;
    }

    public void setFastSpeed(boolean value) {
        this.m_UseFastSpeed = value;
    }

    public void setShield(boolean value) {
        this.m_IsShielded = value;
    }

    public int getEnergy() {
        return this.m_Energy;
    }

    public int getLives() {
        return this.m_Lives;
    }

    public int getScore() {
        return this.m_Score;
    }

    public int getHighPrecisionX() {
        return this.m_HighPrecisionXpos;
    }

    public int getHighPrecisionY() {
        return this.m_HighPrecisionYpos;
    }

    public boolean isDead() {
        return this.m_IsDead;
    }

    public boolean isShielded() {
        return this.m_IsShielded;
    }

    public boolean collidesWith(int x, int y, int width, int height) {
        int xpos = this.m_HighPrecisionXpos >> 16;
        int ypos = this.m_HighPrecisionYpos >> 16;
        if (x + width <= xpos) {
            return false;
        }
        if (y + height <= ypos) {
            return false;
        }
        if (xpos + this.m_FrameSize <= x) {
            return false;
        }
        return ypos + this.m_FrameSize > y;
    }

    static {
        m_NormalFrameSequence = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 2, 2, 1, 1};
        m_ExploFrameSequence = new int[]{4, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9};
    }
}

