/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class Menu
extends LineOutCanvas {
    private static final byte MENU_MAIN = 0;
    private static final byte MENU_SCORE = 1;
    private static final byte MENU_HOWTOPLAY = 2;
    private static final byte MENU_HOWTOPLAY2 = 3;
    private static final byte MENU_OPTIONS = 4;
    private static final byte MENU_CREDITS = 5;
    private static final byte MENU_USERNAMEINPUT = 6;
    private static final byte ACTION_NOTHING = 0;
    private static final byte ACTION_STARTGAME = 1;
    private static final byte ACTION_EXITGAME = 2;
    private static final byte ACTION_SELECTMENU_MAIN = 3;
    private static final byte ACTION_SELECTMENU_SCORE = 4;
    private static final byte ACTION_SELECTMENU_HOWTOPLAY = 5;
    private static final byte ACTION_SELECTMENU_HOWTOPLAY2 = 6;
    private static final byte ACTION_SELECTMENU_OPTIONS = 7;
    private static final byte ACTION_SELECTMENU_CREDITS = 8;
    private static final byte ACTION_GETVALUE_SCORE0 = 9;
    private static final byte ACTION_GETVALUE_SCORE1 = 10;
    private static final byte ACTION_GETVALUE_SCORE2 = 11;
    private static final byte ACTION_GETVALUE_SCORE3 = 12;
    private static final byte ACTION_GETVALUE_SCORE4 = 13;
    private static final byte ACTION_GETVALUE_SCORE5 = 14;
    private static final byte ACTION_GETVALUE_SOUND = 15;
    private static final byte ACTION_GETVALUE_GAMEMODE = 16;
    private static final byte ACTION_GETVALUE_USERNAME = 17;
    private static final byte ACTION_INCVALUE_SOUND = 18;
    private static final byte ACTION_INCVALUE_GAMEMODE = 19;
    private static final byte ACTION_INCVALUE_USERNAME = 20;
    private static final byte ACTION_GETIMAGE_HOWTOPLAY = 21;
    private static final byte ACTION_GETIMAGE_HOWTOPLAY2 = 22;
    private static final byte ACTION_GETIMAGE_CREDITS = 23;
    private static final byte[][] MENUITEM_DRAWACTIONS = new byte[][]{{0, 0, 0, 0, 0, 0, 0}, {9, 10, 11, 12, 13, 14, 0, 0}, {21, 0, 0, 0, 0, 0, 0, 0, 0}, {22, 0, 0, 0, 0, 0, 0, 0, 0}, {15, 16, 0, 0}, {23, 0, 0, 0, 0, 0, 0}, {0, 0, 17, 0, 0, 0}};
    private static final byte[][] MENUITEM_UPDATEACTIONS = new byte[][]{{1, 4, 5, 7, 8, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 3}, {0, 0, 0, 0, 0, 0, 0, 0, 6}, {0, 0, 0, 0, 0, 0, 0, 0, 3}, {18, 19, 0, 3}, {0, 0, 0, 0, 0, 0, 3}, {0, 0, 20, 0, 0, 3}};
    private static final String[][][] MENUITEM_TEXTSTRINGS = new String[][][]{{{"START GAME"}, {"HIGHSCORES"}, {"HOW TO PLAY"}, {"OPTIONS"}, {"CREDITS"}, {""}, {"EXIT"}}, {{""}, {""}, {""}, {""}, {""}, {""}, {""}, {"EXIT"}}, {{""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {"NEXT"}}, {{""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {"EXIT"}}, {{"SOUND OFF", "SOUND VOLUME 1", "SOUND VOLUME 2", "SOUND VOLUME 3", "SOUND VOLUME 4", "SOUND VOLUME 5", "SOUND VOLUME 6", "SOUND VOLUME 7", "SOUND VOLUME 8", "SOUND VOLUME 9", "SOUND VOLUME 10"}, {"MODE NORMAL", "MODE SAVEDGAME", "MODE GIRL AMY", "MODE GIRL LEA", "MODE GIRL ZOE", "MODE RANDOM"}, {""}, {"EXIT"}}, {{""}, {""}, {""}, {""}, {""}, {""}, {"EXIT"}}, {{"ENTER YOUR NAME"}, {""}, {""}, {""}, {""}, {"EXIT"}}};
    private int m_KeysOld;
    private int m_CurrentMenu;
    private int m_CurrentMenuItem;
    private int m_MainMenuItem;
    private int m_CurrentCharacter;
    private int m_UserNamePosition;
    private StringBuffer m_UserName;
    private StringBuffer m_UserScore;
    private Image m_BackgroundImage;
    private Image m_HowToPlayImage;
    private Image m_HowToPlayImage2;
    private Image m_CreditsImage;
    private int m_BlendPos;
    private int m_BlendSpeed;
    private Player m_MidiSong;
    private VolumeControl m_MidiVolume;

    public void init() {
        super.init();
        try {
            LineOut lineout = (LineOut)Application.getCurrent();
            this.m_KeysOld = this.getKeyStates();
            this.m_CurrentMenu = 0;
            this.m_CurrentMenuItem = 0;
            this.m_MainMenuItem = 0;
            this.m_CurrentCharacter = 0;
            this.m_UserNamePosition = 6;
            this.m_UserName = new StringBuffer("AAAAAA");
            this.m_UserScore = null;
            this.m_BackgroundImage = Image.createImage((String)"/menu.png");
            this.m_HowToPlayImage = Image.createImage((String)"/howtoplay.png");
            this.m_HowToPlayImage2 = Image.createImage((String)"/howtoplay2.png");
            this.m_CreditsImage = Image.createImage((String)"/credits.png");
            this.m_BlendPos = 0;
            this.m_BlendSpeed = 4;
            this.m_MidiSong = Manager.createPlayer((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/song_menu.mid"), (String)"audio/midi");
            this.m_MidiSong.realize();
            this.m_MidiSong.setLoopCount(-1);
            this.m_MidiVolume = (VolumeControl)this.m_MidiSong.getControl("VolumeControl");
            this.m_MidiVolume.setLevel(0);
            this.m_MidiSong.start();
            if (lineout.soundMode() == 0) {
                this.m_MidiSong.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void init(int score) {
        this.init();
        LineOut lineout = (LineOut)Application.getCurrent();
        String highscore = lineout.highscoreEntry(this.m_UserNamePosition - 1).substring(0, 6);
        while (Integer.valueOf(highscore) < score) {
            --this.m_UserNamePosition;
            this.m_CurrentMenu = 6;
            this.m_CurrentMenuItem = 2;
            if (this.m_UserNamePosition == 0) break;
            highscore = lineout.highscoreEntry(this.m_UserNamePosition - 1).toString().substring(0, 6);
        }
        this.m_UserScore = new StringBuffer();
        this.m_UserScore.append(score);
        while (this.m_UserScore.length() < 6) {
            this.m_UserScore.insert(0, "0");
        }
        for (int i = 4; i >= this.m_UserNamePosition; --i) {
            lineout.setHighscoreEntry(i + 1, lineout.highscoreEntry(i));
        }
    }

    public boolean update() {
        if (this.m_BackgroundImage == null || this.m_HowToPlayImage == null || this.m_CreditsImage == null) {
            return true;
        }
        int keys = this.getKeyStates();
        this.m_KeysOld &= keys;
        int keysMask = this.m_KeysOld;
        this.m_KeysOld = keys;
        keys ^= keysMask;
        LineOut lineout = (LineOut)Application.getCurrent();
        Graphics graphics = this.getGraphicsContext();
        this.m_MidiVolume.setLevel(Math.min(this.m_BlendPos, lineout.soundMode() * 10));
        this.m_BlendPos += this.m_BlendSpeed;
        if (this.m_BlendPos > graphics.getClipHeight() + this.m_BlendSpeed) {
            this.m_BlendPos = graphics.getClipHeight() + this.m_BlendSpeed;
        } else if (this.m_BlendPos > 0) {
            keys = 0;
        } else {
            try {
                this.m_MidiSong.close();
                this.m_MidiSong = null;
                this.m_MidiVolume = null;
                this.m_BackgroundImage = null;
                this.m_HowToPlayImage = null;
                this.m_HowToPlayImage2 = null;
                this.m_CreditsImage = null;
                this.m_UserName = null;
                this.m_UserScore = null;
                System.gc();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.flushGraphics();
            Game game = new Game();
            game.flushGraphics();
            Display.getDisplay((MIDlet)lineout).setCurrent((Displayable)game);
            game.init();
            lineout.resetFrameTimer();
            return true;
        }
        if ((keys & 4) != 0) {
            do {
                --this.m_CurrentMenuItem;
                if (this.m_CurrentMenuItem < 0) {
                    this.m_CurrentMenuItem = MENUITEM_UPDATEACTIONS[this.m_CurrentMenu].length - 1;
                }
                int n = this.m_MainMenuItem = this.m_CurrentMenu == 0 ? this.m_CurrentMenuItem : this.m_MainMenuItem;
            } while (MENUITEM_UPDATEACTIONS[this.m_CurrentMenu][this.m_CurrentMenuItem] == 0);
        }
        if ((keys & 8) != 0) {
            do {
                ++this.m_CurrentMenuItem;
                if (this.m_CurrentMenuItem >= MENUITEM_UPDATEACTIONS[this.m_CurrentMenu].length) {
                    this.m_CurrentMenuItem = 0;
                }
                int n = this.m_MainMenuItem = this.m_CurrentMenu == 0 ? this.m_CurrentMenuItem : this.m_MainMenuItem;
            } while (MENUITEM_UPDATEACTIONS[this.m_CurrentMenu][this.m_CurrentMenuItem] == 0);
        }
        if ((keys & 1) != 0 && MENUITEM_UPDATEACTIONS[this.m_CurrentMenu][this.m_CurrentMenuItem] == 20) {
            --this.m_CurrentCharacter;
            if (this.m_CurrentCharacter < 0) {
                this.m_CurrentCharacter = 5;
            }
        }
        if ((keys & 2) != 0 && MENUITEM_UPDATEACTIONS[this.m_CurrentMenu][this.m_CurrentMenuItem] == 20) {
            ++this.m_CurrentCharacter;
            if (this.m_CurrentCharacter >= 6) {
                this.m_CurrentCharacter = 0;
            }
        }
        if ((keys & 0x10) != 0) {
            switch (MENUITEM_UPDATEACTIONS[this.m_CurrentMenu][this.m_CurrentMenuItem]) {
                case 1: {
                    this.m_BlendSpeed = -this.m_BlendSpeed;
                    break;
                }
                case 2: {
                    try {
                        this.m_MidiSong.close();
                        return false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break;
                    }
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (this.m_CurrentMenu == 4) {
                        lineout.saveToStore();
                    }
                    if (this.m_CurrentMenu == 6) {
                        lineout.setHighscoreEntry(this.m_UserNamePosition, this.m_UserScore + " " + this.m_UserName);
                        lineout.saveToStore();
                    }
                    lineout.resetFrameTimer();
                    this.m_CurrentMenu = MENUITEM_UPDATEACTIONS[this.m_CurrentMenu][this.m_CurrentMenuItem];
                    this.m_CurrentMenu -= 3;
                    int numItems = MENUITEM_UPDATEACTIONS[this.m_CurrentMenu].length;
                    this.m_CurrentMenuItem = this.m_CurrentMenu == 0 ? this.m_MainMenuItem : numItems - 1;
                    break;
                }
                case 18: {
                    try {
                        lineout.setSoundMode((lineout.soundMode() + 1) % 11);
                        if (lineout.soundMode() == 0) {
                            this.m_MidiSong.stop();
                            break;
                        }
                        if (lineout.soundMode() == 1) {
                            this.m_MidiVolume.setLevel(lineout.soundMode() * 10);
                            this.m_MidiSong.setMediaTime(0L);
                            this.m_MidiSong.start();
                            break;
                        }
                        this.m_MidiVolume.setLevel(lineout.soundMode() * 10);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break;
                }
                case 19: {
                    lineout.setGameMode(lineout.gameMode() + 1);
                    if (lineout.gameMode() <= lineout.activeModes()) break;
                    lineout.setGameMode(0);
                    break;
                }
                case 20: {
                    String availChars = lineout.bitmapFontA().availableCharacters();
                    int index = availChars.indexOf(this.m_UserName.charAt(this.m_CurrentCharacter)) + 1;
                    index = index >= availChars.length() ? 0 : index;
                    this.m_UserName.setCharAt(this.m_CurrentCharacter, availChars.charAt(index));
                }
            }
        }
        return true;
    }

    public void hideNotify() {
        try {
            if (this.m_MidiSong != null) {
                this.m_MidiSong.stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showNotify() {
        try {
            if (this.m_MidiSong != null) {
                this.m_MidiSong.start();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void render() {
        if (this.m_BackgroundImage == null || this.m_HowToPlayImage == null || this.m_CreditsImage == null) {
            return;
        }
        LineOut lineout = (LineOut)Application.getCurrent();
        Graphics graphics = this.getGraphicsContext();
        int tx = this.translateX();
        int ty = this.translateY();
        graphics.drawImage(this.m_BackgroundImage, tx, ty, 20);
        for (int i = 0; i < MENUITEM_DRAWACTIONS[this.m_CurrentMenu].length; ++i) {
            String menuItemText = null;
            Image menuItemImage = null;
            BitmapFont menuItemFont = lineout.bitmapFontA();
            boolean singleChar = false;
            switch (MENUITEM_DRAWACTIONS[this.m_CurrentMenu][i]) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    int textOffset = MENUITEM_DRAWACTIONS[this.m_CurrentMenu][i] - 9;
                    menuItemText = lineout.highscoreEntry(textOffset);
                    break;
                }
                case 15: {
                    int textOffset = lineout.soundMode() - 0;
                    menuItemText = MENUITEM_TEXTSTRINGS[this.m_CurrentMenu][i][textOffset];
                    break;
                }
                case 16: {
                    int textOffset = lineout.gameMode() - 0;
                    menuItemText = MENUITEM_TEXTSTRINGS[this.m_CurrentMenu][i][textOffset];
                    break;
                }
                case 17: {
                    menuItemText = this.m_UserName.toString();
                    singleChar = i == this.m_CurrentMenuItem;
                    break;
                }
                case 21: {
                    menuItemImage = this.m_HowToPlayImage;
                    break;
                }
                case 22: {
                    menuItemImage = this.m_HowToPlayImage2;
                    break;
                }
                case 23: {
                    menuItemImage = this.m_CreditsImage;
                    break;
                }
                default: {
                    menuItemText = MENUITEM_TEXTSTRINGS[this.m_CurrentMenu][i][0];
                }
            }
            if (!singleChar && i == this.m_CurrentMenuItem) {
                menuItemFont = lineout.bitmapFontB();
            }
            if (menuItemText != null) {
                this.drawString(graphics, menuItemFont, menuItemText, graphics.getClipWidth() / 2 + tx, graphics.getClipHeight() * 3 / 7 + (menuItemFont.characterHeight() + graphics.getClipHeight() / 72) * i + ty, 17);
                if (singleChar) {
                    this.drawString(graphics, lineout.bitmapFontB(), menuItemText.substring(this.m_CurrentCharacter, this.m_CurrentCharacter + 1), graphics.getClipWidth() / 2 - lineout.bitmapFontB().stringWidth(menuItemText) / 2 + lineout.bitmapFontB().characterWidth() * this.m_CurrentCharacter + tx, graphics.getClipHeight() * 3 / 7 + (menuItemFont.characterHeight() + graphics.getClipHeight() / 72) * i + ty, 20);
                }
            }
            if (menuItemImage == null) continue;
            graphics.drawImage(menuItemImage, graphics.getClipWidth() / 2 + tx, graphics.getClipHeight() * 3 / 7 + (menuItemFont.characterHeight() + graphics.getClipHeight() / 72) * i + ty, 17);
        }
        this.drawBlendEffect(graphics, this.m_BlendPos, this.m_BlendSpeed);
        this.flushGraphics();
    }
}

