/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class LineOutCanvas
extends Canvas2D {
    private int translateX;
    private int translateY;

    public void init() {
        super.init();
        int displayWidth = this.getWidth();
        int displayHeight = this.getHeight();
        int factorW = (displayWidth << 16) / 128;
        int factorH = (displayHeight << 16) / 160;
        int elementWidth = 128 * factorW / 16 >> 16;
        int elementHeight = 144 * factorH / 18 >> 16;
        int factor = elementWidth < elementHeight ? (elementWidth * 16 << 16) / 128 : (elementHeight * 16 << 16) / 128;
        int clipWidth = 128 * factor >> 16;
        int clipHeight = 160 * factor >> 16;
        int clipX = displayWidth - clipWidth >> 1;
        int clipY = displayHeight - clipHeight >> 1;
        this.getGraphicsContext().setClip(clipX, clipY, clipWidth, clipHeight);
        this.translateX = clipX;
        this.translateY = clipY;
    }

    public int translateX() {
        return this.translateX;
    }

    public int translateY() {
        return this.translateY;
    }

    public void drawBlendEffect(Graphics graphics, int position, int speed) {
        int width = graphics.getClipWidth();
        int height = graphics.getClipHeight();
        int size = Math.abs(speed);
        int numX = (width + size - 1) / size;
        int numY = (height + size - 1) / size;
        if (numX % 2 == 1) {
            ++numX;
        }
        if (numY % 2 == 1) {
            ++numY;
        }
        int maxX = numX - position / size;
        int maxY = numY - position / size;
        graphics.setColor(0, 0, 0);
        for (int i = 0; i < maxX; i += 2) {
            graphics.fillRect(this.translateX + i * size, this.translateY, size, height);
            graphics.fillRect(this.translateX + (numX - i - 1) * size, this.translateY, size, height);
        }
    }
}

