/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class LineOut
extends Application {
    public static final byte MODE_NORMAL = 0;
    public static final byte MODE_SAVEDGAME = 1;
    public static final byte MODE_FIGURE1 = 2;
    public static final byte MODE_FIGURE2 = 3;
    public static final byte MODE_FIGURE3 = 4;
    public static final byte MODE_RANDOM = 5;
    public static final byte MODE_SOUND0 = 0;
    public static final byte MODE_SOUND1 = 1;
    public static final byte MODE_SOUND2 = 2;
    public static final byte MODE_SOUND3 = 3;
    public static final byte MODE_SOUND4 = 4;
    public static final byte MODE_SOUND5 = 5;
    public static final byte MODE_SOUND6 = 6;
    public static final byte MODE_SOUND7 = 7;
    public static final byte MODE_SOUND8 = 8;
    public static final byte MODE_SOUND9 = 9;
    public static final byte MODE_SOUND10 = 10;
    private LineOutCanvas m_LastCanvas;
    private byte m_SoundMode;
    private byte m_GameMode;
    private byte m_ActiveModes;
    private byte m_SavedLevel;
    private byte m_SavedLives;
    private String[] m_Highscores;
    private BitmapFont m_BitmapFontA;
    private BitmapFont m_BitmapFontB;

    public LineOut() {
        try {
            this.m_SoundMode = (byte)5;
            this.m_GameMode = 0;
            this.m_ActiveModes = (byte)2;
            this.m_SavedLevel = 1;
            this.m_SavedLives = (byte)3;
            this.m_Highscores = new String[6];
            this.m_Highscores[0] = "060000 ALEX  ";
            this.m_Highscores[1] = "050000 FABIAN";
            this.m_Highscores[2] = "040000 ANDI  ";
            this.m_Highscores[3] = "030000 PATRIC";
            this.m_Highscores[4] = "020000 ELMA  ";
            this.m_Highscores[5] = "010000 ERWIN ";
            Image imageFontA = Image.createImage((String)"/font1.png");
            Image imageFontB = Image.createImage((String)"/font2.png");
            int fontWidth = imageFontA.getWidth() / 13;
            int fontHeight = imageFontA.getHeight() / 3;
            String availChars = "0123456789 ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            this.m_BitmapFontA = BitmapFont.getFont(imageFontA, fontWidth, fontHeight, availChars);
            this.m_BitmapFontB = BitmapFont.getFont(imageFontB, fontWidth, fontHeight, availChars);
            StartScreen startscreen = new StartScreen();
            this.loadFromStore();
            this.setFrameRate(25);
            Display.getDisplay((MIDlet)Application.getCurrent()).setCurrent((Displayable)startscreen);
            startscreen.init();
            System.gc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadFromStore() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"LineOutOptions", (boolean)false);
            byte[] data = store.getRecord(1);
            ByteArrayInputStream bytestream = new ByteArrayInputStream(data);
            DataInputStream datastream = new DataInputStream(bytestream);
            this.m_SoundMode = datastream.readByte();
            this.m_GameMode = datastream.readByte();
            this.m_ActiveModes = datastream.readByte();
            this.m_SavedLevel = datastream.readByte();
            this.m_SavedLives = datastream.readByte();
            this.m_Highscores = null;
            System.gc();
            this.m_Highscores = new String[6];
            for (int i = 0; i < 6; ++i) {
                this.m_Highscores[i] = datastream.readUTF();
            }
            store.closeRecordStore();
            store = null;
            bytestream = null;
            datastream = null;
            data = null;
            System.gc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveToStore() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)"LineOutOptions", (boolean)true);
            ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
            DataOutputStream datastream = new DataOutputStream(bytestream);
            datastream.writeByte(this.m_SoundMode);
            datastream.writeByte(this.m_GameMode);
            datastream.writeByte(this.m_ActiveModes);
            datastream.writeByte(this.m_SavedLevel);
            datastream.writeByte(this.m_SavedLives);
            for (int i = 0; i < 6; ++i) {
                datastream.writeUTF(this.m_Highscores[i].toString());
            }
            byte[] data = bytestream.toByteArray();
            if (store.getNumRecords() == 0) {
                store.addRecord(data, 0, data.length);
            } else {
                store.setRecord(1, data, 0, data.length);
            }
            store.closeRecordStore();
            store = null;
            bytestream = null;
            datastream = null;
            data = null;
            System.gc();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean update() {
        LineOutCanvas currentCanvas;
        this.m_LastCanvas = currentCanvas = (LineOutCanvas)Display.getDisplay((MIDlet)Application.getCurrent()).getCurrent();
        if (currentCanvas != null) {
            return currentCanvas.update();
        }
        return false;
    }

    public void render() {
        LineOutCanvas currentCanvas = (LineOutCanvas)Display.getDisplay((MIDlet)Application.getCurrent()).getCurrent();
        if (currentCanvas != null && currentCanvas == this.m_LastCanvas) {
            currentCanvas.render();
        }
    }

    public void setSoundMode(int mode) {
        this.m_SoundMode = (byte)mode;
    }

    public void setGameMode(int mode) {
        this.m_GameMode = (byte)mode;
    }

    public void setActiveModes(int mode) {
        this.m_ActiveModes = (byte)mode;
    }

    public void setSavedLevel(int level) {
        this.m_SavedLevel = (byte)level;
    }

    public void setSavedLives(int lives) {
        this.m_SavedLives = (byte)lives;
    }

    public void setHighscoreEntry(int line, String txt) {
        this.m_Highscores[line] = txt;
    }

    public int soundMode() {
        return this.m_SoundMode;
    }

    public int gameMode() {
        return this.m_GameMode;
    }

    public int activeModes() {
        return this.m_ActiveModes;
    }

    public int savedLevel() {
        return this.m_SavedLevel;
    }

    public int savedLives() {
        return this.m_SavedLives;
    }

    public String highscoreEntry(int line) {
        return this.m_Highscores[line];
    }

    public BitmapFont bitmapFontA() {
        return this.m_BitmapFontA;
    }

    public BitmapFont bitmapFontB() {
        return this.m_BitmapFontB;
    }
}

