/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;

public class ProfileManager {
    public static boolean ENABLED = true;
    static Hashtable profileList = new Hashtable();
    static String lastId;

    private static ProfileEntry getProfile(String string) {
        ProfileEntry profileEntry = (ProfileEntry)profileList.get(string);
        if (profileEntry == null) {
            profileEntry = new ProfileEntry();
            profileList.put(string, profileEntry);
        }
        return profileEntry;
    }

    public static void start(String string) {
        if (ENABLED) {
            ProfileEntry profileEntry = ProfileManager.getProfile(string);
            profileEntry.lastStartTime = System.currentTimeMillis();
            lastId = string;
        }
    }

    public static void end(String string) {
        if (ENABLED) {
            long l = System.currentTimeMillis();
            ProfileEntry profileEntry = ProfileManager.getProfile(string);
            ProfileManager.add(string, l - profileEntry.lastStartTime);
        }
    }

    public static void end() {
        if (ENABLED) {
            long l = System.currentTimeMillis();
            ProfileEntry profileEntry = ProfileManager.getProfile(lastId);
            ProfileManager.add(lastId, l - profileEntry.lastStartTime);
        }
    }

    public static void add(String string, long l) {
        if (ENABLED) {
            ProfileEntry profileEntry = ProfileManager.getProfile(string);
            profileEntry.lastTickTotalDuration += l;
            ++profileEntry.number;
            if (l == 0L) {
                ++profileEntry.numberZeroResults;
                return;
            }
            if (l < profileEntry.shortest) {
                profileEntry.shortest = l;
            }
            if (l > profileEntry.longest) {
                profileEntry.longest = l;
            }
            profileEntry.total += l;
            profileEntry.average = profileEntry.total / profileEntry.number;
        }
    }

    public static void show(String string) {
        ProfileEntry profileEntry = (ProfileEntry)profileList.get(string);
        if (profileEntry != null) {
            System.out.println(string + " : " + profileEntry.getReportString());
        }
    }

    public static String getProfileString(int n) {
        int n2 = 0;
        Enumeration enumeration = profileList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (n2 == n) {
                ProfileEntry profileEntry = (ProfileEntry)profileList.get(string);
                return string + ":" + profileEntry.previousTickTotalDuration + " " + profileEntry.lastTickTotalDuration + ":" + profileEntry.getReportString();
            }
            ++n2;
        }
        return "";
    }

    public static void showAll() {
        Enumeration enumeration = profileList.keys();
        while (enumeration.hasMoreElements()) {
            ProfileManager.show((String)enumeration.nextElement());
        }
    }

    public static void preTick() {
        if (ENABLED) {
            Enumeration enumeration = profileList.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ((ProfileEntry)ProfileManager.profileList.get((Object)string)).lastTickTotalDuration = 0L;
            }
        }
    }

    public static void postTick() {
        if (ENABLED) {
            Enumeration enumeration = profileList.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ProfileEntry profileEntry = (ProfileEntry)profileList.get(string);
                profileEntry.previousTickTotalDuration = profileEntry.lastTickTotalDuration;
            }
        }
    }

    static class ProfileEntry {
        long shortest = Long.MAX_VALUE;
        long longest = Long.MIN_VALUE;
        long total = 0L;
        long number = 0L;
        long numberZeroResults = 0L;
        long average;
        long lastStartTime;
        long lastTickTotalDuration;
        long previousTickTotalDuration;

        public String getReportString() {
            if (this.number == this.numberZeroResults) {
                return "All zero";
            }
            return this.shortest + "<" + this.average + "<" + this.longest + " (" + this.number + "samples, " + this.numberZeroResults + " were zero";
        }
    }
}

