/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class DeviceSound
implements PlayerListener {
    private static Player[] midi_sounds;
    private static Player midi_current;
    private static int[] MIDI_FILES;
    private static boolean[] MIDI_LOOPS;
    private static int[] SOUND_MAPPING;
    private static DeviceSound instance;

    DeviceSound() {
        instance = this;
    }

    public static void init() {
        try {
            midi_sounds = new Player[MIDI_FILES.length];
            for (int i = 0; i < midi_sounds.length; ++i) {
                if (MIDI_FILES[i] == 11 || MIDI_FILES[i] == 10 || MIDI_FILES[i] == 9) {
                    DeviceSound.midi_sounds[i] = Manager.createPlayer((InputStream)new ByteArrayInputStream(ResourceMaster.getResource(MIDI_FILES[i])), (String)"audio/x-wav");
                    midi_sounds[i].addPlayerListener((PlayerListener)instance);
                } else {
                    DeviceSound.midi_sounds[i] = Manager.createPlayer((InputStream)new ByteArrayInputStream(ResourceMaster.getResource(MIDI_FILES[i])), (String)"audio/midi");
                }
                midi_sounds[i].realize();
                midi_sounds[i].prefetch();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void playerUpdate(Player player, String string, Object object) {
        if (string != "endOfMedia") return;
        try {
            if (Engine.lastSound == -1) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void play(int n) {
        int n2 = SOUND_MAPPING[n];
        if (n2 == -1) {
            return;
        }
        int n3 = Engine.lastSound = MIDI_LOOPS[n2] ? n2 : -1;
        if (!Engine.soundOn || Engine.hideNotify) {
            return;
        }
        try {
            DeviceSound.stop();
            midi_current = midi_sounds[n2];
            midi_current.setLoopCount(MIDI_LOOPS[n2] ? -1 : 1);
            midi_current.setMediaTime(0L);
            midi_current.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void stop() {
        try {
            if (midi_current != null) {
                midi_current.stop();
                midi_current = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean resume() {
        int n = Engine.lastSound;
        if (Engine.soundOn && n != -1 && !DeviceSound.isSoundPlaying()) {
            DeviceSound.play(n);
            return DeviceSound.isSoundPlaying();
        }
        return true;
    }

    public static boolean isSoundPlaying() {
        return midi_current != null && midi_current.getState() == 400;
    }

    static {
        MIDI_FILES = new int[]{7, 0, 1, 6, 4, 2, 3, 5, 8, 11, 10, 9};
        MIDI_LOOPS = new boolean[]{true, true, true, false, false, false, false, false, false, false, false, false};
        SOUND_MAPPING = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    }
}

