/*
 * Decompiled with CFR 0.152.
 */
package movilib;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import movilib.Animation;
import movilib.SPRManager;

public class ANIManager {
    public static final byte INV_H = 1;
    public static final byte INV_V = 2;
    public static final byte NOREMOVE = 16;
    public static final byte STILL = 32;
    public SPRManager sprman;
    public Animation[] animations;

    public ANIManager load(String fileName, SPRManager sprman) throws IOException {
        this.sprman = sprman;
        InputStream is = this.getClass().getResourceAsStream(fileName);
        if (is != null) {
            DataInputStream dis = new DataInputStream(is);
            int numAni = dis.readShort();
            this.animations = new Animation[numAni];
            for (int i = 0; i < numAni; ++i) {
                Animation ani = new Animation();
                ani.id = dis.readShort();
                ani.loop = dis.readByte();
                int numFrames = dis.readShort();
                if (numFrames > 0) {
                    ani.frames = new short[numFrames << 2];
                    int j = 0;
                    int k = 0;
                    while (j < numFrames) {
                        short dx = 0;
                        short dy = 0;
                        ani.frames[k] = dis.readShort();
                        if (sprman != null) {
                            ani.frames[k] = (short)sprman.findSprite(ani.frames[k]);
                        }
                        ani.frames[k + 1] = dx = (short)(dx + dis.readShort());
                        ani.frames[k + 2] = dy = (short)(dy + dis.readShort());
                        byte time = dis.readByte();
                        byte flags = dis.readByte();
                        ani.frames[k + 3] = (short)(time & 0xFF | flags << 8 & 0xFF00);
                        ++j;
                        k += 4;
                    }
                }
                this.animations[i] = ani;
            }
            dis.close();
        }
        return this;
    }

    public void unload() {
        if (this.animations != null) {
            for (int i = this.animations.length - 1; i >= 0; --i) {
                this.animations[i].frames = null;
                this.animations[i] = null;
            }
            this.animations = null;
        }
        this.sprman = null;
    }

    public int findAnimation(int id) {
        int i;
        for (i = this.animations.length - 1; i >= 0 && this.animations[i].id != id; --i) {
        }
        return i;
    }
}

